def rewrite_finer_to_bio(rows):
    retval = []
    def xml2bio(tag):
        if 'Prs' in tag: return 'PER'
        elif 'Pro' in tag: return 'PRO'
        elif 'TmeDat' in tag: return 'DATE'
        elif 'Loc' in tag: return 'LOC'
        elif 'Org' in tag: return 'ORG'
        else: return 'MISC'

    tag, state = '', 'O'
    for row in rows:
        if row.startswith('</'):
            tag = xml2bio(row[2:-1])
            retval.append('I-' + tag)
            state = 'O'
        elif row.endswith('/>'):
            tag = xml2bio(row[1:-2])
            retval.append('B-' + tag)
            state = 'O'
        elif row.startswith('<'):
            tag = xml2bio(row[1:-1])
            retval.append('B-' + tag)
            state = 'I'
        else:
            if state == 'I':
                retval.append('I-' + tag)
            else:
                retval.append('O')
    return retval


if __name__ == '__main__':
    lines = []
    tags = []

    while True:
        try:
            line = input()
        except EOFError:
            break
        if '\t' in line:
            tags.append(line.split('\t')[-1])
            lines.append('\t'.join(line.split('\t')[:-1]))
        else:
            lines.append(line)
            tags.append('')
    for i, tag in enumerate(rewrite_finer_to_bio(tags)):
        if tag == '' or lines[i] == '':
            print(lines[i])
        else:
            print(lines[i] + '\t' + tag)
