/*
        File: WrkSpa.ll
        Author: Dimitrios Kokkinakis
        version: 070228
        Finds titles of ARTWORK
*/
%{
%}
U	[\101-\132\300-\335\&]
CITAT	\"|\|\'|\'\'|"\' \'"|||\&\#x201[39D]\;
%{
	/* projects */
int printWRKP (char *a, int x);
	/* written media */
int printWMD (char *a, int x);
	/* written media that are some kind of orgs*/
	/*int printWMO (char *a, int x);*/
	/* paintings, sculptures? */
int printWAO (char *a, int x);
	/* Rest */
int printWRK (char *a, int x);
%}
%%
	/* EXCEPTIONS */
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|TRM)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDC|MDA|MDD|MDI|MDO|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"\<TIMEX TYPE\="\"TME"\" SBT\=\""(DAT)\"\>[^\n\<]+"\<\/TIMEX\>"	{ECHO;}
[Mm]ediekoncernen" "({U}[^\n ]+" ")+Tribune	{ECHO;}
	/* Projects */
[^\n ]*[Pp]rojekt(et)?" "({U}[^\n ]+igt|Art|Framtida|Kvinnor|A|Bakom|Nrmare|Det|Operation|Rda|Den|Frsta|In|The|Unga|Rdda)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRKP(yytext,0);}
[^\n ]*[Aa]ffrsomrde(t)?" "{U}[^\n ]+\-" och "[^\n ]+	{printWRKP(yytext,1);}
[^\n ]*[Aa]ffrsomrde(t)?" "{U}[^\n ]+(" "{U}[^\n ]+)+	{printWRKP(yytext,1);}
"Agenda 21"	{printWRKP(yytext,0);}
[^\n ]*([Aa]vtal|[Pp]rojekt)(et)?" "{CITAT}" "{U}[^\n ]+(" "[^\n\"\'\]+)+" "{CITAT}	{printWRKP(yytext,1);}
("Human Proteome"|"Rda "|"Big "|"Stora "|"Local "|"Pelle "|"Norra ")?{U}[^\n ]+projektet	{printWRKP(yytext,0);}
"Operation Lkemedelsdrrknackning"	{printWRKP(yytext,0);}
EU\:s" utvidgning"	{printWRKP(yytext,0);}
FN\:s" "millenniedeklaration	{printWRKP(yytext,0);}
"ledare fr "{U}[^\n ]+" project"	{printWRKP(yytext,2);}
("Respiratory Health"|National|"Hospital Attitude"|Examination)" Health Survey"(" and "[A-Z][^\n ]+|" of "[A-Z][^\n ]+)?	{printWRKP(yytext,0);}
("Project Gutenberg"|"Web Survey of Users"|"Form 36 Health Survey")	{printWRKP(yytext,0);}
({U}[^\n ]*" ")+(Disease|Prevention)" Project"	{/*Hepatit C Prevention Project*/printWRKP(yytext,0);}
National" "({U}[^\n ]*" ")+Education" "Program	{printWRKP(yytext,0);}
	/* MULTI WORKs - WRITTEN*/
	/* 1 Keyword " TITLE " */
	/* 2 Keyword , TITLE ,|. */
	/* 3 Keyword[BESTMD] TITLE */
	/* 4 Media, newspapers */
	/* 5 Compounds */
({U}[^\n ]+" "[IXV]+|{U}+|"Salt II"|"Sharm el\-Sheikh")\-avtal(et)?	{printWRKP(yytext,0);}
"Camp David"(\-)?avtalet	{printWRKP(yytext,0);}
[^\n ]*(handels|spridnings)avtalet(" "{U}[^\n ]+)+	{printWRKP(yytext,1);}
"Mat fr Livet"	{printWRKP(yytext,0);}
({U}[^\n ]" ")+(International|Initiative|Intervention)" Program"	{printWRKP(yytext,0);}
{U}+\:s" "[^\n ]*(strategi|plan|medelsprogram)(en)?	{printWRKP(yytext,0);}
({U}[^\n ]" ")+(Framework|Environment)" Programme"	{printWRKP(yytext,0);}
({U}[^\n ]+frdragets|{U}+\:s" s kallade"|{U}+\:s|[^\n ]+\-" och")" "[^\n ]*pakt	{printWRKP(yytext,0);}
{U}[^\n ]+s" "Marsprogram(met)?	{printWRKP(yytext,0);}
[^\n ]*projektet" Lugna gatan"	{printWRKP(yytext,1);}
[^\n ]*obotprogram(met)?" "al\-[^\n ]+	{printWRKP(yytext,1);}
{U}[^\n ]+(ak|dad|rea|\:|ien)s" "[^\n ]+vapenprogram	{printWRKP(yytext,0);}
{U}+:s" utvecklingsprogram"(" "{U}[^\n ]+|" \( "{U}+" \)")?	{printWRKP(yytext,0);}
"FN:s "{CITAT}" "[a-z]+\-[a-z]+\-[a-z]+" "{CITAT}	{printWRKP(yytext,0);}
"FN:s "{CITAT}" Operation"(" "[^\n\"\'\]+)+" "{CITAT}	{printWRKP(yytext,0);}
{U}+:s" olja mot "[^\n ]+program	{printWRKP(yytext,0);}
(i|sin)" Vision r "[12][0-9][0-9][0-9]	{printWRKP(yytext,1);}
	/* NEWSPAPERS & MAGAZINES that should NOT be ORGS cause of near context */
	/* <ENAMEX TYPE="WRK" SBT="WMD"></ENAMEX><MTH="PTR"/> */
"norska Elle"	{printWMD(yytext,1);}
(Aftonbladet|SvD|Arbetet|GP|DN|Sydsvenskan|Expressen|Dagens" "{U}[^\n ]+)" "(Nringsliv|Vetenskap|Debatt)	{printWMD(yytext,0);}
(Winter\-Bladet|Islands" "lkartidning|Lkartidningen" "[0-9]+\/[0-9]+|LT" nr "[0-9]+\/[0-9]+|Lkartidningen" nr "[0-9]+\/[0-9]+|Lkartidningen" volym "[0-9]+|[^\n ]+"Fass lkemedelsbeskrivning"[a-z]*|F[Aa][Ss][Ss]" "[12][09][09][0-9]|"SvD Brnnpunkt"|"Rose el\-Youssef"|"Paris Match"|"Business Week"|"Skna Hem"|"Allt i Hemmet"|"Tidskrift fr nysvensk "[a-z]+forskning|"Tidskrift fr vetenskap och konst"|[Dd]"en Svenska Almanackan"|"Hem & Villa"|"Europaguide 200"[0-9]|"Rough Guide"|"Hennes "[Jj]ournal|"Blue Guide"|"Hemmets Journal"|"New Scientist"|"Medicinsk Vetenskap"|"Vecko Revyn"|"VG Nett"|"Metal Bulletin"|"Dagens Medicin"|"Dagens Naeringsliv"|"Gula Sidorna"|"Observer Magazine"|"Land Lantbruk"|{U}[^\n ]+isk" "tidskrift|Sdra" "[^\n ]+" Tidning"|"Life "[Mm]agazine|"Guide Gourmand de la "[^\n ]+)	{printWMD(yytext,0);}
(Finsk|Svensk|Norsk)" "Tidss?krift	{printWMD(yytext,0);}
[Tt]he(" "{U}[^\n ]+)+" "(Book|Yearbook)	{printWMD(yytext,0);}
[^\n ]+krift(en)?" "(Nutida|Svensk|Ngon|In|Frn|I|De|Allt|Mitt|Att|A|The|En|Ett|Till|Nr|Det|Den|Du|[^\n ]+r|[^\n ]+ska|[^\n ]+skt)" "[^\n ]+(" "{U}[^\n ]*)*	{printWMD(yytext,1);}
[^\n ]+krift(en)?" "(Nutida|Svensk|Ngon|In|Frn|I|De|Allt|Mitt|Att|A|The|En|Ett|Till|Nr|Det|Den|Du)" "[^\n ]+	{printWMD(yytext,1);}
Journal" of the "{U}[^\n ]+" "[^\n ]+ical" "[^\n ]+	{printWRK(yytext,0);}
Journal" of the "[^\n ]+" of "[^\n ]+" "[^\n ]+	{printWRK(yytext,0);}
[^\n ]*[Tt]id(ning|skrift)(en)?(" the"|" L \'")(" "{U}[^\n ]*)+(" ntupplaga"|" of "{U}[^\n ]+)?	{printWMD(yytext,1);}
[^\n ]+krift(en)?(" "{U}[^\n ]*)+" "and(" "{U}[^\n ]*)+" in"{U}[^\n ]+	{printWMD(yytext,1);}
[^\n ]+krift(en)?(" "{U}[^\n ]*)+" "(in|a|for|the|of|and|one|"of the"|"on the"|"for the")(" "{U}[^\n ]*)+	{printWMD(yytext,1);}
(senaste|frsta|sista|andra|rs)" "(upplaga|upplagan|numret)" av"(" "{U}[^\n\: ]+)+" of"(" "{U}[^\n ]+)+	{printWMD(yytext,3);}
"DN \- Nyheter"	{printWMD(yytext,0);}
[^\n ]*"numret av "("Ekonomisk Debatt"|"Moderna "[Tt]ider|"Vr Bostad"|"Tv Dagar"|"Svensk Golf"|"Svensk "[Jj]akt)	{printWMD(yytext,2);}
[^\n ]*"numret av "{U}[^\n ]+" "{U}[^\n ]+	{printWMD(yytext,2);}
({U}[^\n ]+vrlden|Expressen|Sydsvenskan|stgta[^\n ]+|Dagens" "Nyheter|Aftonbladet)s" "ntupplaga	{printWMD(yytext,0);}
Klla" \: "({U}[^\n ]+" ")+[12][0-9][0-9][0-9]	{printWMD(yytext,2);}
	/* MOD (Jyrki Niemi): The following two rules modifying existing
	   tags have been moved to filterBadTags-pm.
	   CHECK: Does it affect the result?
	   "Journal of the \<ENAMEX TYPE=\"ORG\" SBT=\"CRP\"\>"[^\n\<]+"\<\/ENAMEX\>"	{int i=15;	printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">Journal of the ");	for(;yytext[i]!='>';i++); i++; for(;i<yyleng; putchar(yytext[i++]));}
	   "Journal of \<ENAMEX TYPE=\"ORG\" SBT=\"CRP\"\>"[^\n\<]+"\<\/ENAMEX\>"	{int i=11;	printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">Journal of the ");	for(;yytext[i]!='>';i++); i++; for(;i<yyleng; putchar(yytext[i++]));}
	 */
	/* NEWSPAPERS & MAGAZINES that should be some kind of ORG */
	/* <ENAMEX TYPE="WRK" SBT="WMO"></ENAMEX><MTH="PTR"/> */
"Modern Times"	{ECHO;}
[Tt]"he European Agency"	{ECHO;}
[Tt]he" "(Starr|Mirror|Guardian|European|Economist|Observer|Sun|Lancet|Independent)	{printWMD(yytext,0);}
{U}[^\n ]+" Daily News"	{printWMD(yytext,0);}
"Din Del AB"	{ECHO;}
(S|Syd)venska" Dagbladets "[^\n ]+(medalj|pris)	{ECHO;}
([Tt]he" ")?("Hollywood Reporter"|"China Daily"|"South China Morning Post"|"New Yorker"|"Sunday Independent"|"Sunday Telegraph"|"Weekly Mail"|"Sunday Business"|"Wall Street Journal"|"Evening News"|"London Evening Standard"|"Boston Globe"|"Washington Post"|"Vanity Fair"|"Sunday Mirror"|"NY Times Magazine"|"Time Magazine"|"New York Times"|"New York Post"|"Los Angeles Times"|"Los Angeles Post"|"Evening Standard")(\-kopian)?	{printWMD(yytext,0);}
"Gazet vam"(" "{U}[^\n ]*)+	{printWMD(yytext,0);}
([Ll]" "[^\n ]*Equipe|"Malayala Manorama"|"Die Zeit"|"Frankfurter Allgemeine"|"al\-Sharq al\-Awsat"|"al\-Quds al\-Arabi"|"Gteborgs Morgonpost"|"Res Publica"|"La Repubblica"|"Damernas Vrld"|"USA Today"|"El Pais"|"Der Spiegel"|"La Stampa"|"Le Figaro"|F[Ii][Bb]\-Aktuellt|"Ekstra Bladet"|"Ny Teknik"|"Nya Dagen"|"DN Debatt"|"DN Stockholm"|"Al Ahram"|Novaja" "[Gg]azeta|"Svenska Biet"|"Hnt Extra"|"Se \& Hr"|"Teknikens Vrld"|"Din Del"|"Video Magazine"|"Tutto Sport"|"Danska Politiken"|"Sports "[Ii]llustrated|"Sport Illustrated"|"Le Soir"|"El Pa"[i]s|"Computer Sweden"|"National Geographic")	{printWMD(yytext,0);}
{U}[^\n ]+[es]" "[Ll]ns" "(Allehanda|[Tt]idning)	{printWMD(yytext,0);}
"Dagens "(Nyheter|[Ii]ndustri|N[]ringsliv)	{printWMD(yytext,0);}
("Gteborgs ")?Handel(s)?(\-)?" "(och|\&)" "[Ss]jfarts(\-)?tidning(en)?	{printWMD(yytext,0);}
(Arboga|Avesta|{U}[^\n ]+" Nya")" Tidning"	{printWMD(yytext,0);}
("Veckans Affrer"|"Swedish Press"|"Sverige Nytt")	{printWMD(yytext,0);}
([Tt]"he ")?"Daily "{U}[^\n ]+	{printWMD(yytext,0);}
Ber(linske|lingske|gens)" "Tiden(e|de)	{printWMD(yytext,0);}
(Sydsven|Sven|Skn|[Nn]or)ska" "[Dd]agbladet	{printWMD(yytext,0);}
({U}[^\n ]*" ")+("Morning Herald"|"Times Herald"|"Herald Tribune"|Chronicle|Cronicle|Zeitung|Shimbun|Times|Allehanda|Dagblad|Dagbladet|Pravda|Tribune)	{printWMD(yytext,0);}
[^\n ]*(idningen|sprkiga|systerbladet)" "({U}[^\n ]*" ")+(Tribune|Times|Daily|Herald|[Nn]ews|gazeta)	{printWMD(yytext,1);}
[^\n ]*idningen" "{U}[^\n ]+" "al\-[^\n ]+	{printWMD(yytext,1);}
(noterar|skriver)" Norra Vsterbotten"	{printWMD(yytext,1);}
[^\n ]*"intervju i Veckans "[Aa]ffrer	{printWMD(yytext,2);}
[^\n ]*"idningen "(Veckans|Ny|Dagens|Svensk|Le)" "[^\n ]+(" "{U}[^\n ]*)*	{printWMD(yytext,1);}
	/* <ENAMEX TYPE="WRK" SBT="WAO"></ENAMEX><MTH="PTR"/> */
(bilden|Picassos|Vincis)" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printWAO(yytext,1);}
"Monumentet fr Tredje "{U}[^\n ]+	{printWAO(yytext,0);}
"Monumentet ver "[^\n ]+ens" "[^\n ]+	{printWAO(yytext,0);}
"Monumentet ver"(" "{U}[^\n ]+)+	{printWAO(yytext,0);}
[^\n ]*onumentet(" "{U}[^\n ]+)+" of "[^\n ]+	{printWAO(yytext,1);}
"en "{U}[^\n ]+" "{U}[^\n ]+\-(teckning|mlning)	{printWAO(yytext,1);}
"\" Mona Lisa \""	{printWAO(yytext,0);}
(Cranach|Rembrandt|Borsdone|Zorn)s(" "{U}[^\n ]+)+	{printWAO(yytext,1);}
{U}[^\n ]+(tavla|monumentet)	{printWAO(yytext,0);}
(bredvid|framfr|hga)" "Poseidon	{printWAO(yytext,1);}
	/*****************************/
	/* *** KEYWORD " TITLE " *** */
	/*****************************/
	/* <ENAMEX TYPE="WRK" SBT="???"></ENAMEX><MTH="PTR"/> */
"trollkarlen Harry Potter"	{ECHO;}
("Trnrosens "[Bb]ok|"Sunes jul"|"Sunes sommar"|"Thelma och Louise"|"Les Mis"[e]rables|[Kk]ejsar[a-z]+" av "Portugallien|"Karius och Baktus"|"Lotta p Brkmakargatan"|"The Matrix"|[Rr]vare" i Kamomilla stad"|"Klas Klttermus"|Tribadernas" "[Nn]att|"A Chorus Line"|"Solveigs sng"|"Jeppe p Berget"|"Den "[Ll]illa" "[Ss]jjungfrun|"Little "[Mm]an" "[Tt]ate|"Mio min Mio"|"Little Shop of Horrors"|"Brderna Lejonhjrta"|"Ave Verum Corpus"|"The road to El Dorado"|"Vgen till El Dorado"|"Vem r rdd fr Virginia Wolf"|"Den store Gatsby"|"Big Lebowski"|"Nils Holgerssons underbara resa"|"Jesus Christ "[Ss]uperstar|"Kristus stannade i Eboli"|"Trollkarlen frn Oz"|"Alice i "[Uu]nderlandet|"Brott och "[Ss]traff|"Fanny och Alexander"|"Dden i Venedig"|"Harry Potter and the "[^\n ]+|"Pettson \& Findus"|"Mamma Mia"|"Almqvists Skrifter"|"Rnja Rvardotter"|"Karl-Bertil Jonssons julafton"|"West "[Ss]ide" "[Ss]tory|"Carmina Burana"|"Tusen och en natt"|"Jorden runt p 80 dagar"|"La Traviata"|[Tt]"he House of E"[l]+iott|"Ringaren i N"[o]"tre Dame"|"Araminta May"|"Harry Potter och fngen frn Azkaban"|"Harry Potter"|"Kristina frn Duvemla"|Vargens" "Dotter|"Barberaren i Sevilla"|"Fantomen p Operan"|"Phantom "[Oo]f" "[Tt]he" Opera"|"God "[Ss]ave" "[Tt]he" Queen"|"En "[Mm]idsommarnattsdrm|"Sound of Music"|"Figaros "[Bb]rllop|"Madam Butterfly"|"Tristan och Isolde"|"My "[Ff]air" "[Ll]ady)(\-boken)?	{printWRK(yytext,0);}
"Sagan om "([Kk]onungens" "[]terkomst|[Rr]ingen|"de tv "[Tt]ornen)(\-film[a-z]*)?	{printWRK(yytext,0);}
"Johannes uppenbarelse "[0-9]+" kapit"(el|let)	{printWRK(yytext,0);}
{U}[^\n ]+s" "[Ss]amlade" "([Ss]krifter|[Vv]erk)	{printWRK(yytext,0);}
SAMLADE" "VERK" "[1-9][0-9]?	{printWRK(yytext,0);}
[^\n ]*utgvan" av "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printWRK(yytext,2);}
[^\n ]*tgvan" av"(" "{U}[^\n ]+)+" Outlook"	{printWRK(yytext,2);}
(Hga|Havets|Narrens|Idas)" "visa(n)?	{printWRK(yytext,0);}
[^\n ]*(frfattaren|frfattare|regissr|texten)" till "(Det|En|Det|Bortom|Mitt|P|The|Ungt)" "[^\n ]+(" "{U}[^\n ]*)*	{printWRK(yytext,2);}
[^\n ]*(frfattaren|regissr|manus|omslaget|frordet|vertyren|texten)" till "{U}[^\n ]*(sk|ig|ska|rys)" "[a-z]+	{printWRK(yytext,2);}
	/* Famous Authors (mostly) with citat following */
[A-Z](oppola|arantino|rding|wijk|essn|augh|ellini|ntonioni|ubrick|ngvar|izet|onchielli|onnevi|oretti|orngold|ullberg|ilburn|eierstad|hemiri|cDonell|ennon|ammerth|ohnson|incher|agerman|dorno|linge|derberg|ihlgrd|blin|osephson|tephenson|ikkola|ondheim|ervante|ollin|iskylo|lmqvist|ach\|eethoven|ergman|rahm|recht|lake|ellman|hristie|haplin|lackwell|ante|icken|ahlbergh|kman|ckehart|uillou|uripide|oethe|ndel|kelf|emingway|aydn|itchcock|jertn|onesco|bsen|afka|arlfeldt|agerlf|indgren|olire|oliere|idholm|ergiliu|inn|undell|vidiu|aufman|ozart|orn|artinson|aupassant|ietzsche|rwell|uccini|laton|lato|ornby|ossini|ussel|ankell|chubert|hakespeare|artre|aube|egnr|oberg|olstoj|horvall|roust|llman|isconti|ender|agner|illiam|onteverdi|onizetti|arner|ilder|arhol|ebber|indstrm|kelund|alvatore|oodwin|ushdie|afaelson|aylor|rokofjev|almkvist|rokofiev|ller|agerkvist|undmark|oddwin|llmann|ridell|eckett|yrdal|hristensen|chiller|offmann|dstrm|andstrm|ihlgrd|reenaway|the|o\-Johansson|stner|corsese|yllensten|orneli|orneille|ardell|arrison|tolpe|uma)"s "{CITAT}(" "[^\n\#\"\'\]+)+" "{CITAT}	{printWRK(yytext,1);}
(A[Bb][Bb][Aa]|Lyon|Levi|Ryan|Elliot|Dove|Lang|Auster|Berg|Lorca|Joyce|Holm|Handke|Ek|Gogh|Munch|Grime|Hugo|Krau|Landi|Gay|Lee|Eliot|Ramel|Mann|Pope|Ravel|Leone|Trier|Sontag|Verdi|Troell|Popper|Conrad|Verne|Gras|Woolf|Welsh|Wajda|Zorn|Norn|Davi|Joyce|Tjder|Bach\')"s "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printWRK(yytext,1);}
{U}[^\n ]+(anov|berg|wski|skij|skild|nski|wijk|lkov|vski|chov)"s "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printWRK(yytext,1);}
	/*************************************/
	/* *** KEYWORD KEYWORD " TITLE " *** */
	/*************************************/
	/* <ENAMEX TYPE="WRK" SBT="???"></ENAMEX><MTH="PTR"/> */
	/*****************************/
	/* *** " TITLE " KEYWORD *** */
	/*****************************/
	/* <ENAMEX TYPE="WRK" SBT="???"></ENAMEX><MTH="PTR"/> */
	/*********************************/
	/* *** KEYWORD , {T}ITLE ,|. *** */
	/*********************************/ 	/*X+ the */
	/* almost sure mult-patterns moved moved the WrkPat.ll */
[^\n ]*(stor|mastodont|nombrotts|konst|rkester|amlings|pslags|[Dd]ikt|[Kk]onst|[Mm]ster|[Rr]oman|ngdoms|bands)verk(et)?" "(All|De|En|P|Den|Det|Ett|I|Till|{U}[^\n ]+ges|[^\n ]+ns|[^\n ]+ets|[^\n ]+ska)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*(stor|mastodont|nombrotts|konst|rkester|amlings|pslags|[Dd]ikt|[Kk]onst|[Mm]ster|[Rr]oman|ngdoms|bands)verk(et)?" "[^\n ]+" of "[^\n ]+	{printWRK(yytext,1);}
[^\n ]*([Dd]ebut|[Ll]yrik|ntologi|psats|forism|ovell|ss|[Dd]ikt|erttelse|okument)samling(en)?" "(I|De|En|P|Den|Det|Ett|The|{U}[^\n ]+ges|[^\n ]+ens|[^\n ]+ets|[^\n ]+ska)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*([Dd]ebut|[Ll]yrik|ntologi|psats|forism|ovell|[Ee]ss|[Dd]ikt|erttelse|okument)samling(en)?" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*[Dd]ramat" "({U}[^\n ]+" ")+(for|and|of|"of the"|"for the"|a)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]+(ri|rio|to|ra)login" "(Modern|Mellan|Att|The|Det|Den|Ett)" "[^\n ]+(" "{U}[^\n ]*)*	{printWRK(yytext,1);}
[^\n ]*([Kk]apitlet|klassikern)" "(Det|The|{U}[^\n ]+" "over|Min|{U}[^\n ]+ska|{U}[^\n ]+ets|{U}[^\n ]+" of "the|If|{U}[^\n ]+" "of|En|Ett|All)" "[^\n ]+(" "{U}[^\n ]*)*	{printWRK(yytext,1);}
[^\n ]*([Rr]oman|[Nn]ovell|[Aa]vhandling)(en)?(" "{U}[^\n ]*)+(" of an"|" efter"|" of"|" of the")" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
	/* WRITTEN MATERIAL that should NOT be ORGS */
({U}[^\n ]+" och ")?{U}[^\n ]+" epistlar"	{printWRK(yytext,0);}
"Allt "[Oo]m" "(Jakt|Trdgrd|Stockholm)	{printWRK(yytext,0);}
(FoF|"Guinness Book of Records"|"Nouvelle Revue"|{U}[^\n ]+"s Desk Reference"|"Svensk Tidskrift"|"News \& World Report"|Star" "[Tt]rek\-[a-z]*boken)	{printWRK(yytext,0);}
({U}[^\n ]+" ")+(Shopping|Development|Competitiveness|Investment|Policy|Disasters)" Report"	{printWRK(yytext,0);}
[Tt]he" "{U}+" "[0-9]+" Report"	{printWRK(yytext,0);}
([Vv]ecko|[Nn]yhets|[Rr]ese|[Ss]port)magasinet(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
{U}[^\n ]+(borg|land)sguiden	{printWRK(yytext,0);}
[^\n ]*(bankens|Temos|Skops|Sifos|dustrins|Gallups|USA|mteriets|frenings)" "[^\n ]*barometer	{printWRK(yytext,0);}
"Nationella kvalitetsregistret fr "[^\n ]+(vrd|kirurgi)	{printWRK(yytext,0);}
(Spos|Lloyds|Autodatas|SECC|WHOs|"Svenska Coronar Angiografi och Angioplastik")" "[Rr]egist(er|ret)	{printWRK(yytext,0);}
(SWEDIS|Nordiskt|Svenskt|WHOs|[Nn]ationell|[Nn]ationella|Svenska|Danska|Vgverkets|[Ss]venska" "Medicinska)" "[^\n ]+regist(er|ret)	{printWRK(yytext,0);}
(Socialstyrelsens|Nordiska|[Nn]ationella|[Ss]venska|Regionala|Reumatoid)" "[^\n ]+registret	{printWRK(yytext,0);}
{U}+\:s" "[^\n ]+" "[^\n ]+databas	{printWRK(yytext,0);}
[A-Z\:]+s" "[^\n ]*(register|databas)	{printWRK(yytext,0);}
"National "[^\n ]+" "[^\n ]+" Registry of "[^\n ]+	{printWRK(yytext,0);}
(Lkemedelsverkets|Socialstyrelsens)" "[^\n ]*register	{printWRK(yytext,0);}
(SAOL|Psalt)" "[XI0-9\:]+	{printWRK(yytext,0);}
"Svenska "[Aa]kadem[a-z]+" "[Oo]rd(bok|lista)	{printWRK(yytext,0);}
[Ss]ocialstyrelsens" rapport om "[^\n ]+" i "[A-Z][^\n ]+	{printWRK(yytext,0);}
"Virchows Archiv fr Patologische Anatomie und Physiologie"	{printWRK(yytext,0);}
"Unescos "[^\n ]+slista	{printWRK(yytext,0);}
"Internationella "{U}+\:s" "[Cc]harta	{printWRK(yytext,0);}
{U}[^\n ]+" Korint"h?iebrevet	{printWRK(yytext,0);}
("Frsta "|"Andra ")?{U}[^\n ]+breve(t|n)	{printWRK(yytext,0);}
[1-9]"\:e "{U}[^\n ]+bok	{/*2:a Mose*/printWRK(yytext,0);} 
([Hh]and|[Oo]rd)bok" "(fr|ver)" "([^\n ]+|[Ss]venska" "[^\n ]+)	{printWRK(yytext,0);}
(Nordisk|Lunds|Svensk)" "[^\n ]+is(ka|k)(" "[^\n ]+s)?" "rsbok	{printWRK(yytext,0);}
[^\n ]*[Bb]oken" The "[^\n ]+" "(by|in|a|for|the|of|and|one|"of the"|"on the"|"for the")" "[^\n ]+(" "{U}[^\n ]+)*(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*[Bb]oken" "(Mellan|Drfr|Varfr|Bakom|Les)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*[Bb]ok(en)?" "({U}[^\n ]+" ")+(dessa|mina|vackra|[^\n ]+erad|by|in|a|for|des|the|of|and|one|fr|"de la"|"of the"|"on the"|"for the")" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*[Bb]oken" "{U}[^\n ]+" "(till|med|fr|it)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*[Bb]ok(en)?" "{U}[^\n ]+(gs|nsk|ig|ing|nda|ins|nas|isk|rs|ens|ers|nde|ska|iga)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
(Strkkvartett|Pianokonsert)" "[Nn]r" "[1-9]+(\-[0-9]+)?	{printWRK(yytext,0);}
[^\n ]*[Ss]ymfoni(" nr")?" "[1-9][0-9]?(" "[^\n ]+moll)?	{printWRK(yytext,0);}
[Ss]venska" "[^\n ]+iska" registret"(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
[Ss]venska" "[^\n ]+\-" och "[^\n ]+registret	{printWRK(yytext,0);}
"Symphonie "[^\n ]+ique	{printWRK(yytext,0);}
"satsen ur "{U}[^\n ]+" nr "[^\n ]+ 	{printWRK(yytext,2);}
"satsen ur "{U}[^\n ]+" "[^\n ]*(konsert|sonat|sviten)	{printWRK(yytext,2);}
"Codex "({U}[^\n ]+ius|Marian)	{printWRK(yytext,0);}
[^\n ]*[Ss]onatan" L"[ae]" "[^\n ]+	{printWRK(yytext,1);}
{U}[^\n ]+" da "[Rr]equiem	{printWRK(yytext,0);}
"skrev "\"{U}[^\n ]+" "[^\"]+" \""	{printWRK(yytext,0);}
[Ss]venska" "[^\n ]+" "[^\n ]+" och "[^\n ]+" "Registret	{printWRK(yytext,0);}
({U}[^\n ]+" ")*"Drug Registry"	{printWRK(yytext,0);}
({U}[^\n ]+" ")*(Chronicle|Dictionary|Manual|Registry|Register|Registret|Encyclopedia|J[Oo][Uu][Rr][Nn][Aa][Ll]|Proceedings)" "("of the"|of)(" "{U}[^\n ]+)+(" of "[^\n ]+|" to "[^\n ]+)?	{printWRK(yytext,0);}
({U}[^\n ]+" ")+("Medical Journal"|Journal|Journalen|Review|Pergament|Dictionary|Manual|Registret|Encyclopedia)(" of "[^\n ]+|" of "[^\n ]+" and "[^\n ]+)?	{printWRK(yytext,0);}
[Ss]venska" "[^\n ]*registret" fr "[^\n ]+	{printWRK(yytext,0);}
[Ss]venska" "[^\n ]+registret	{printWRK(yytext,0);}
"New England "[Jj]ournal" of "[^\n ]+	{printWRK(yytext,0);}
(Le" ")?("La Revue de"|Encyclopedia|"Dictionnaire de la")(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
Journal" "("of the"|of)(" "{U}[^\n ]+)+(" of "{U}[^\n ]+|" and "{U}[^\n ]+)?	{printWRK(yytext,0);}
(Le" ")?Journal" "(de|des|"de la"|of)(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
([Tt]he" ")?Guidelines" for the"(" "{U}[^\n ]+)+" and"(" "{U}[^\n ]+)+" of"(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
([Tt]he" ")?Guidelines(" "[^\n ]*)?(" "{U}[^\n ]+)+" of"(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
([Tt]he" ")?Guidelines(" "[^\n ]*)?(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
[Tt]he" "[A-TV-Z][^\n ]+" of "{U}[^\n ]+" in"(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
Annals" "(of|of" "the)(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
({U}[^\n ]+" ")+"and "({U}[^\n ]+" ")+Manual" of "[^\n ]+	{printWRK(yytext,0);}
[Tt]"he "[^\n ]+" Atlas of"(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
(Atlas|Encyclopedia)" of"(" "{U}[^\n ]+)+" in "{U}[^\n ]+	{printWRK(yytext,0);}
(Encyclopedia|Slide" "Atlas)" of"(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
[^\n ]+"anska "[^\n ]+freningens" "[^\n ]*[Manual]	{printWRK(yytext,0);}
International(" "{U}[^\n ]+)+" Guidelines"	{printWRK(yytext,0);}
Declaration(" "[^\n ]*)?(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
Encyclopedia" "[^\n ]+ica	{printWRK(yytext,0);}
[Tt]he(" "{U}[^\n ]+)+" Guide"	{printWRK(yytext,0);}
"Pharmacotherapy "[12][0-9][0-9][0-9]	{printWRK(yytext,0);}
"\" General Theory \""	{printWRK(yytext,0);}
"Science "[0-9]+\;[0-9]+\:[0-9\-]+	{printWRK(yytext,0);}
{U}[^\n ]+" and "{U}[^\n ]+" Bulletin"	{printWRK(yytext,0);}
{U}[^\n ]+"ical "[^\n ]+" and Epidemiology"	{printWRK(yytext,0);}
({U}[^\n ]+" and ")?({U}[^\n ]+" ")+("For the"|Polyp|Development|Hypertension|Immunogenicity|International|Evaluation|Imaging|Experimental|Survival|Heart|Health|Trial|Diabetes|Protection|Memory|Prevention|National" "[^\n ]+|Replacement|Longitudinal|Women|Co\-operative|Follow\-up|Elderly|Violence|Screening|Outcome|Eye|Therapy|Incidence|stent)" "[Ss]tudy(" in "{U}[^\n ]+|" "o[fn]" "{U}[^\n ]+|" "o[fn]" the "{U}[^\n ]+)?	{printWRK(yytext,0);}
Health" "({U}[^\n ]+" ")+Study	{printWRK(yytext,0);}
({U}[^\n ]+" and ")?({U}[^\n ]+" ")+(Prevention|Stroke|Event|Failure|Attack|Randomized|Intervention|Lowering|Surgery|Infarction|Surgery|Controlled|Comparison|Outcomes|Amalgam)" Trial"(" in "{U}[^\n ]+|" "o[fn]" "{U}[^\n ]+|" "o[fn]" the "{U}[^\n ]+)?	{printWRK(yytext,0);}
[A-Z][^\n ]+" "[1-9IV]+\-studien	{printWRK(yytext,0);}
([Gg]"lobal ")?[Ff]as" "[IV]+"\-studie"(n|r|rna)?	{printWRK(yytext,0);}
"studierna "{U}[^\n ]+" och "{U}[^\n ]+	{printWRK(yytext,1);}
"tudien \, "{U}[^\n ]+" "{U}[^\n ]+" "(on|and|of|in)" "{U}[^\n ]+	{printWRK(yytext,2);}
[^\n ]*"frmulret "{U}[^\n ]+" in "{U}[^\n ]+	{printWRK(yytext,1);}
"Swedish "[^\n ]+" "[^\n ]+" "[^\n ]+" "[^\n ]+" "[Ss]tudy	{printWRK(yytext,0);}
"Swedish Trial in"(" "[A-Z][^\n ]+)+	{printWRK(yytext,0);}
"Intervention and Event Lowering in "{U}[^\n ]+	{printWRK(yytext,0);}
"Acta "{U}[^\n ]+" Scandinavica"	{printWRK(yytext,0);}
"Acta "{U}[^\n ]+" Regiae Stockholmiensis"	{printWRK(yytext,0);}
Scand" J "(Prim" Health "Care|Caring" "Sci|Plast" Reconstr "Surg|Public" "Health|Soc" "Med)\.?	{printWRK(yytext,0);}
(DiabetologNytt|Nordisk" "Nutrition|Diabetesvrd|Incitament)" "[Nn]r" "[1-9]+(\-[0-9]+)?	{printWRK(yytext,0);}
(DiabetologNytt|Nordisk" "Nutrition|Diabetesvrd|Incitament)" \, "[Nn]r" "[1-9]+[\/\-0-9]*	{printWRK(yytext,0);}
{U}[^\n ]+" Disease Assessment Scale"[^\n ]*	{printWRK(yytext,0);}
{U}[^\n ]+" Interview Based Impression of Change"	{printWRK(yytext,0);}
"Dermatologist\'s Static Global Assessment of Target Lesion"	{printWRK(yytext,0);}
(Sjukhuslkaren|PROPPEN)" "[Nn]r" "[0-9]+(\/[0-9]+)?	{printWRK(yytext,0);}
(LT|LMV)" "[0-9]+\-[0-9]+(\/[0-9]+)?	{printWRK(yytext,0);}
(Prop|LT|LMV)" "[0-9]+(\/[0-9]+)?	{printWRK(yytext,0);}
Infektionslkaren[0-9]+\/[0-9]+	{printWRK(yytext,0);}
"Nature Reviews in"(" "[A-Z][^\n ]+)+	{printWRK(yytext,0);}
"Diabetes Care"	{printWRK(yytext,0);}
"Diabetic Medicine"	{printWRK(yytext,0);}
[Cc]ancer" incidence in "[Ss]weden" "[12][0-9][0-9][0-9]	{printWRK(yytext,0);}
"Am J Respir Crit Cor Med"\.?	{printWRK(yytext,0);}
International" "[^\n ]+" Journal"	{printWRK(yytext,0);}
"J\. of Occupational \& Environmental Medicine"	{printWRK(yytext,0);}
studie" ( "[A-Z]+" "[0-9]+" )"	{printWRK(yytext,1);}
Trial" of "[^\n ]+" and "[^\n ]+" with "[^\n ]+" "[^\n ]+" Outcomes"	{printWRK(yytext,0);}
[Tt]he" European cooperative study "trial	{printWRK(yytext,0);}
	/*Regulations, recommendations, archives, treaties? */
[Dd]irektiv(en)?" "[0-9][0-9\/A-Z]+	{printWRK(yytext,1);}
"Lagen om yrkesverksamhet p hlso\- och sjukvrdens "omrde(t)?	{printWRK(yytext,0);}
"Lagen om "[^\n ]+isk" "[^\n ]+	{printWRK(yytext,0);}
"Lag med srskilda bestmmelser om vrd av unga"	{printWRK(yytext,0);}
([Tt]"he ")?Archives" of "([^\n ]+" and "[^\n ]+ic" "[^\n ]+|[^\n ]+ics)	{printWRK(yytext,0);}
([Tt]"he ")?Archives" of"(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
Arch(" "[A-Z][^\n ]+)+" "(Med|Surg)\.?	{printWRK(yytext,0);}
FN:s" "[^\n ]+(resolution|konvention)	{printWRK(yytext,0);}
(Fifa|{U}+\:)s" "("nya ")?[^\n ]*(frdraget|regler|onstitution|bestmmelser|grundlagar|grundlag|stadgar|frdrag|pressmeddelande|regelverk|rekommendationer)	{printWRK(yytext,0);}
"Riks\- och "[^\n ]+arkive(n|t)	{printWRK(yytext,0);}
"Treaty of"(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
{U}[^\n ]+"arkivets "[^\n ]+samlingar	{printWRK(yytext,0);}
(I|igenom|frn|ur|hela)" "{U}[^\n ]+" "[^\n ]*arkiv(en|et)?	{printWRK(yytext,1);}
{U}[^\n ]+s" "[^\n ]*(kvartal|delr|mnader)s(\-)?rapport	{printWRK(yytext,0);}
(SvD\:|T\-kontoret|Stasi|{U}+\:|Spo|{U}[^\n ]+polisen|"Sveriges Radio"|Svea" "hovrtt|{U}[^\n ]+museum|Arbetarrrelsen)s" "arkiv	{printWRK(yytext,0);}
{U}[^\n ]+(ens|ets|nsk)" "[Ff]rfattningsssamling	{printWRK(yytext,0);}
({U}[^\n ]+" ")+Treaty(" "{U}[^\n ]+)*	{printWRK(yytext,0);}
\n	{ECHO;}
.	{ECHO;}
%%
int printWRKP(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==5){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);
}
int printWMD(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==5){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==101){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==102){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
int printWAO(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAO\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==101){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==103){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==201){
while(yytext[c]!=' ') c--; 
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); z=z+1;
for(;z<c; putchar(yytext[z++])); printf("</ENAMEX>");
for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
int printWRK(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==5){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==101){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==102){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==103){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==104){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==105){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==201){
while(yytext[c]!=' ') c--; 
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1;
for(;z<c; putchar(yytext[z++])); printf("</ENAMEX>");
for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
main( argc, argv )
int argc;
char **argv;
{
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  yylex();return(0);
}
