/*
	File: TimPat.ll
	Author: Dimitrios Kokkinakis
	Version: 080521
	Finds: times expressions
*/
%{
%}
DAY	[Mm]n|[Tt]is|[Oo]ns|[Tt]ors|[Ff]re|[Ll]r|[Ss][][Nn]|skrtors|UUXXUU|thors
DAYdag	{DAY}""dag
MNH	[Jj]anuari|[Ff]ebruari|mars|[Aa]pril|[Mm]aj|[Jj]uni|[Jj]uli|[Aa]ugusti|[Ss]eptember|[Oo]ktober|[Nn]ovember|[Dd]ecember|UUX1XUU
NUM	Ett|[^\n\t ]*[Tt]v|[^\n\t ]*[Tt]re|[^\n\t ]*[Ff]yra|[^\n\t ]*[Ff]em|[^\n\t ]*[Ss]ex|[^\n\t ]*[Ss]ju|[^\n\t ]*[]tta|[^\n\t ]*[Nn]io|[^\n\t ]*[Tt]io|[^\n\t ]*[Ee]lva|[^\n\t ]*[Tt]olv|[Tt]olf|[Tt]retton|[Ff]jorton|[Ff]emton|[Ss]exton|[Ss]jutton|[Nn]itton|[^\n\t ]*[Tt]jugo|UUX2XUU
%{
  int printTME YY_PROTO((char *a, int x));
%}
%%
	/* GUESS */
"SBT=\"HPL\"\>"[^\n\<\>]+\<\/ENAMEX\>" "[12][0-9][0-9][0-9]	{
	/* #tag TmeDat : [12][0-9][0-9][0-9] : <EnamexLoc[HP]pl>{NoTags}</EnamexLoc[HP]pl>" " */
	/* Ignore the rest that is not supported by the conversion script. */
	/* #skiprest */
	int i=10; printf("SBT=\"HPL\">");
	for(;yytext[i]!='>';putchar(yytext[i++])); putchar(yytext[i++]); 
	printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">");
	putchar(yytext[yyleng-4]); putchar(yytext[yyleng-3]);
	putchar(yytext[yyleng-4]); putchar(yytext[yyleng-1]);printf("</TIMEX>");
}
"SBT=\"PPL\"\>"[^\n\<\>]+\<\/ENAMEX\>" "[12][0-9][0-9][0-9]	{
	/* Covered in the #tag of the previous rule so ignore the rest
	   that is not supported by the conversion script. */
	/* #skiprest */
	int i=10; printf("SBT=\"PPL\">");
	for(;yytext[i]!='>';putchar(yytext[i++])); putchar(yytext[i++]); 
	printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">");
	putchar(yytext[yyleng-4]); putchar(yytext[yyleng-3]);
	putchar(yytext[yyleng-4]); putchar(yytext[yyleng-1]);printf("</TIMEX>");}
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|TRM)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDC|MDA|MDS|MDP|MDF|MDD|MDI|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|FRQ|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"p peptiden"	{ECHO;}
"ens hittills mest"	{ECHO;}
[Ii]" en nyligen"	{ECHO;}
(s|den)" hittills "(vrsta|strsta|mest|vrsta)	{ECHO;}
Tidigare" "(anamnes|studier|underskning)	{ECHO;}
"frsta och hittills enda"	{ECHO;}
"flera nyligen publicerade"	{ECHO;}
"en nyligen publicerad"	{ECHO;}
"fr tidigt fdda"	{ECHO;}
" en hittills "	{ECHO;}
samtidigt" "frekommande	{ECHO;}
	/* CLOCK; SEKUNDER; TIMMAR */
[Ss]trax" "(innan|efter|fre)" klockan "(halv" ")?(ett|{NUM}|[0-9\.]+|[0-9]+\:[0-9]+)(" svensk tid"|" lokal tid"|" denna kvll")?	{printTME(yytext,0);}
[Ss]trax" "(innan|efter|fre)" "("halv ")?{NUM}(" svensk tid"|" lokal tid")?	{printTME(yytext,0);}
([Ff]rn|[Mm]ellan)" klockan "(ett|[012][0-9]|[012][0-9]\.[0-9][0-9]|[0-9]\.[0-9][0-9]|{NUM})" "(till|och)" "([012][0-9]|[012][0-9]\.[0-9][0-9]|[0-9]\.[0-9][0-9]|{NUM}|ett)	{printTME(yytext,0);}
[Kk]lockan" "(r|var)(" ver"|" inte ens"|" strax fre"|" strax efter"|" snart"|" nstan"|" runt"|" cirka"|" nrmare"|" bara"|" lite ver"|" "nu)*(" halv")?" "([^\n\t ]+" minuter i "[^\n\t ]+|[^\n\t ]+" minuter ver "[^\n\t ]+|[^\n\t ]+" minuter ver halv "{NUM}|{NUM}|{NUM}" i "{NUM}|{NUM}" ver "{NUM}|[012][0-9]\.[0-9][0-9]|[1-9]|[^\n\t ]+" midnatt"|lunchtid)(" i "{NUM})?(" p eftermiddagen"|" p kvllen"|" p aftonen"|" p "[^\n\t ]*middagen|" prick")?	{printTME(yytext,2);}
[Ee]n" minut fre "{NUM}	{printTME(yytext,0);}
([Ss]trax" ")?([Ee]fter" "|[Ff]re" "|[Ff]rn" "|[Oo]"mkring "|{DAY}"dag "|"till ")?[Kk]lockan" "("halv "|"half "|precis" ")?([012][0-9]|[012][0-9]\.[0-9][0-9]|[0-9]\.[0-9][0-9]|[012][0-9]+\:[0-9][0-9]|{NUM}|ett" "ungefr)(" minuter ver "{NUM})?(" om natten"|" svensk tid"|" p "[^\n\t ]*morgon|" lokal tid"|" denna kvll"|" denna dag"|" den dag"|" denna "{DAY}dag|" denna "{DAY}dagseftermiddag|" natten till "{DAY}dag|" p "[^\n\t ]*kvll|" dagen fre"|" p "[^\n\t ]+dag|" p "[^\n\t ]+dag" morgon"|" "{DAY}dag" "[^\n\t ]*middag)*(en)?	{printTME(yytext,0);}
([Ss]"enast "|[Mm]ellan" ")?([Kk]l|{DAY}dag" "[Kk]l)" "[0-9]+\.[0-9]+(" \- "[0-9]+\.[0-9]+|"\-"[0-9]+\.[0-9]+)?(" "[^\n\t ]+tid|" lokal tid"|[^\n\t ]+tid)?	{printTME(yytext,0);}
([Ss]"enast ")?[Vv]id" "[^\n\t ]+(" \- "[0-9]+\.[0-9]+)?(" "[^\n\t ]+tid|" lokal tid"|[^\n\t ]+tid)	{printTME(yytext,0);}
([Nn]gon" "|[Pp]" "|[Ee]fter" "|I" "|[Ii]nom" "|[Uu]nder" "|[Oo]m" "|[Ii]nom" loppet av "|[Ii]" ytterligare ")?(nstan" "|ungefr" "|minst" "|mindre" n "|"ngon ")*[Ee]n" "(kvarts" "|qvarts" "|"knappt "|"och en "|dryg" "|dryga" "|knapp" "|knappa" ")?(halv|half|"half "|"halv ")?timm[aern]+("s mellanrum"|"s tid"|" senare"|" lngre")?	{printTME(yytext,0);}
[Ii]" "[^\n\t ]+" och en halv "timm[ae]r?	{printTME(yytext,0);}
[Mm]ellan" "[012][0-9]\.[012][0-9]" och "[012][0-9]\.[012][0-9]	{printTME(yytext,0);}
([0-9]+" "till" "|[Pp]" "|[Ee]fter" "|[Kk]nappt" "|[Ee]"ndast "|[Cc]irka" "|[Bb]ara" "|[Ii]" c:a "|[Ii]" ca "|[Cc]a" "|[Cc]"\:a ")?([Ee]tt" par \, "{NUM}|[0-9]+\-[0-9]+|{NUM}|[0-9]+|[0-9]+\.[0-9]+|[^\n\t ]+\-[^\n\t ]+)" "minuter(na)?(" senare")?	{printTME(yytext,0);}
([Rr]"edan ")?([Ii]" "|[Ii]" den ")[^\n\t ]+[ea]" "[^\n\t ]*minut(en)?	{printTME(yytext,0);}
([Rr]"edan ")?([Ii]" "|[Ii]" den ")?([Ss]ista|[0-9]+\:[ea]|[^\n\t ]+nde|[0-9]+)" "[^\n\t ]*minut(en|er)?	{printTME(yytext,0);}
([Tt]"idigare "|[Ss]"enare "|[Ss]"ent ")?([Kk]vart" ver "[^\n\t ]+" "|[Kk]lockan" "[^\n\t ]+" ")?[Pp]" "(kvll|natt|[a-z]+middag|morgon)(en)?(" till "[^\n\t ]+dagen)?(" svensk tid"|" lokal tid")?	{printTME(yytext,0);}
[Vv]id" "([^\n\t ]+\-tiden|{NUM}tiden|lunchtid|klockan" kvart "(ver|i)" "[^\n\t ]+|halv" "{NUM})(" svensk tid")?	{printTME(yytext,0);}
([Mm]ellan" ")?[Kk]l("\. "|" "|\.)[0-9][0-9]?\.[0-9][0-9]\-[0-9][0-9]\.[0-9][0-9]	{printTME(yytext,0);}
([Mm]ellan" ")?[Kk]l("\. "|" "|\.)[0-9][0-9]?\.[0-9][0-9]" \- "[0-9][0-9]\.[0-9][0-9]	{printTME(yytext,0);}
([Ss]"enast "|[Ff]"rn "|{DAY}"dag "|{DAY}"dag eftermiddag "|{DAY}"dagseftermiddag ")?[Kk]l("\. "|" "|\.)[0-9][0-9]([\:\.\-][0-9][0-9])?	{printTME(yytext,0);}
[Kk]lockslaget" "[0-9][0-9]\.[0-9][0-9]	{printTME(yytext,1);}
[Kk]lockan" "(blev|slog|slr)" "("nu ")?{NUM}	{printTME(yytext,2);}
	/* MOD (Jyrki Niemi): Rule was split by the number of context words.
	   They could be recombined in Pmatch.
	   [Kk]lockan" "(hade" "slagit|gr" "mot|gick" p halv")" "{NUM}	{printTME(yytext,2);}
	 */
[Kk]lockan" "(hade" "slagit|gr" "mot)" "{NUM}	{printTME(yytext,2);}
[Kk]lockan" "gick" p halv "{NUM}	{printTME(yytext,3);}
[Kk]lockan" "[0-9]+[\:\,][0-9]+	{printTME(yytext,1);}
	/* MOD (Jyrki Niemi): Rule was split by the number of context words.
	   They could be recombined in Pmatch.
	   [Kk]lockan" "("r ju"|"p slaget"|"ha varit"|"nrmar sig"|"hade passerat"|var)" "("ver "|"nstan "|"blott ")?(midnatt|{NUM})	{printTME(yytext,3);}
	 */
[Kk]lockan" "("r ju"|"p slaget"|"ha varit"|"nrmar sig"|"hade passerat")" "("ver "|"nstan "|"blott ")?(midnatt|{NUM})	{printTME(yytext,3);}
[Kk]lockan" "var" "("ver "|"nstan "|"blott ")?(midnatt|{NUM})	{printTME(yytext,2);}
[Kk]lockan" "("mellan ")?[0-9][0-9]?" och "[0-9][0-9]?	{printTME(yytext,1);}
[Kk]lockan" "[0-9][0-9]\.[0-9][0-9]\-[0-9][0-9]\.[0-9][0-9]	{printTME(yytext,1);}
"mste ha varit "("ungefr ")?halv" "{NUM}	{printTME(yytext,3);}
([Ee]fter" "|O"m ")?[Ee]"n stund "(under|p)" "[^\n\t ]*(morgon|[kq]vll|dag)(en)?	{printTME(yytext,0);}
([Ff]r" korta"|[]ven" kortare"|[Ff]r|[Vv]id|[Ii]" sdana"|[Pp]" timmar och"|[Pp])" "[a-z]*stunder(na)?	{printTME(yytext,0);}
([Ee]fter" "|Om" "|[Ff]"r ")?[Ee]n(" "[^\n\t ]+|ganska" "god)?" "stund(" senare"|" sedan"|" derefter"|" drefter")?	{printTME(yytext,0);}
[Kk]l" "[0-9]+" och "[0-9]+	{printTME(yytext,0);}
[Kk]l"\. "[0-9]+":"[0-9]+	{printTME(yytext,0);}
[Kk]"l:"[012][0-9]	{printTME(yytext,0);}
[Kk]l" "[012][0-9]30	{printTME(yytext,0);}
[Kk]l" "[12][0-9][0-5][0-9]	{printTME(yytext,0);}
[Dd]en(" "[^\n\t ]+)?" "stunden	{printTME(yytext,0);}
[Ll]ngre" n "[^\n ]+" "(sekunder|minuter)	{printTME(yytext,0);}
([Uu]ngefr" "|[Bb]ara" "|[Rr]edan" "|[Mm]ax" "|[Oo]ftast" ")?([Mm]ed|[Uu]nder|[Ee]fter" ver"|[Ee]fter" "[0-9]" respektive"|"I ver"|[Ee]fter|[Pp]|[Ii]nom|[Mm]er" "n|[]ver|till" cirka"|[Cc]a|[Ff]rn|[Ii]" knappa"|[Ii]" minst"|[Ii]" ca"|[Ii]" cirka")" "("minst "|"cirka "|"c\:a ")?(ngra|[0-9]+|[1-9]\,[0-9]+|[1-9]\.[0-9]+|{NUM}|"drygt "{NUM}|{NUM}" spelade"|[0-9]+" \- "[0-9]+|[0-9\,]+\-[0-9\,]+|[0-9]+\-[0-9]+|"drygt "[0-9]+|[Dd]"om "frsta" "{NUM}|[Dd]"e "frsta" "{NUM}|[Mm]"ellan "{NUM}" och"|[Dd]"om "frsta" "[0-9]+|[Dd]"e "frsta" "[0-9]+|fljande" "[0-9]+|[Dd]"e "senaste" "[^\n\t ]+|"de "{NUM}" "frsta|dessa|"de frsta"|"ngra f"|[Ee]"tt antal"|{NUM}" och en halv till "{NUM}|[Ii]"nom de nrmsta"|{NUM}" till "{NUM})" "[a-z]*(minuter|timmar|sekunder)(na)?(s" duration"|" eller lngre"|"s mellanrum"|" "tidigare|" "senare|"s period"|" "mellanrum)?	{printTME(yytext,0);}
([Ff]rn" "[0-9]+" till ")?[0-9]+(\,[0-9]+)?" timmar i veckan"	{printTME(yytext,0);}
([Rr]"edan ")?([Uu]nder|[Ee]fter|[Bb]ara)" "[^\n\t ]+" "(knapp|dryg)(a)?" "(sekund|kvart)(en)?(" senare")?	{printTME(yytext,0);}
([Rr]"edan "[Bb]"ara ")?[Ee]fter" "[^\n\t ]+" "kvart	{printTME(yytext,0);}
([Rr]"edan "|[Bb]"ara ")?([Ee]fter" ")?[Ee]n" "("dryg ")?"kvart senare"	{printTME(yytext,0);}
[Dd]en" "[^\n\t ]+" kvarten"	{printTME(yytext,0);}
"honom vecka "[0-9]+	{printTME(yytext,1);}
([Bb]ara" ")?(En|[Nn]gon|[Ff]r" ngon"|[Ff]rn" ngon"|"till "ngo[nt]|[Ee]n" och en halv"|[Mm]indre" n en"|[Ii]nom" en "hal[vf])" minut"(" senare")?	{printTME(yytext,0);}
Ngon" vecka efter"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">Ngon vecka</TIMEX> efter");}
([Pp]|[Mm]ed|[Uu]nder)" tiden "[0-9]+\.[0-9]+(\,[0-9]+|\.[0-9]+)	{printTME(yytext,1);}
	/* MOD (Jyrki Niemi): Corrected [Ti]ill to [Tt]ill */
([Pp]" s kort tid som "|[Ss]" sent som "|[Ee]fter" "|[Dd]refter" "|[Rr]edan" "|[Nn]"stan ")?([Ii]nom" "|[Oo]m" "|[Ff]r" "|[Ss]"edan "|[Ee]"fter "|[Aa]"lltifrn "|[Ff]"rn "|[Tt]"ill "|[Uu]"nder loppet av "|[Uu]"nder "|[Uu]"nder de frsta "|[Rr]edan" frn frsta "|[Ii]"nom loppet av "|[Ii]nom" ngon till ")?([Uu]"ngefr "|[Dd]"rygt "|[Yy]"tterligare "|[Bb]"ara "|[Mm]"indre n "|[Mm]er" n "|[Cc]"irka "|[Kk]"nappt ")?({NUM}" till "{NUM}|{NUM}|[Nn]gra|[0-9]+|[0-9]+" "[0-9]+|[0-9]+\,[0-9]+|[0-9]+\-[0-9\,]+|[Ff]lera|[Nn]"gra f"|"ett ftal"|[Ee]"tt par"|"de senaste "[^\n\t ]+|[Dd]e" "frsta|I" "[^\nA-Z ]+|[Ii]nom" loppet av "[^\n\t ]+|[Uu]"pp till "[^\n\t ]+|[Bb]ara|[Cc]irka" "[^\n\t ]+|[Ii]" slutet av de "{NUM}|{NUM}" frsta"|fregende)" "("extra ")?[a-z]*(minuter|millisekunder|sekunder|timma|dagar|veckan|vecka|veckor|"en dag"|"en timma"|"en timme"|timme|timmar|semesterdagar|dag|dgr|dagen)(na)?(" eller ngon vecka"|"s mellanrum"|"s tid"|" sedan"|" sen"|" senare"|" tillbaka"|" tidigare"|" i fljd"|" eller mer"|" "framt|" "d[e]refter)?	{printTME(yytext,0);}
([Vv]id" "kvllstid|[Vv]id" "middagstid|[Vv]id" "lunchtid|[Ff]rsta" halvtimman")(" p "{DAY}dagen" svensk tid")?	{printTME(yytext,0);}
[0-9]+\,[0-9]+" "(minuter|millisekunder|sekunder|sek\.|sek)	{printTME(yytext,0);}
([Ee]n" "halv|[Ee]n" "knapp|[Hh]undradelar" av en"|[Uu]"nder en"|[Uu]"nder frsta"|[Ii]" denna")" "[a-z]*sekund(en)?	{printTME(yytext,0);}
([Uu]nder" den "[^\n\t ]+|[Ii]|[Ff]rsta)" "[^\n\t ]*timm[ae]n	{printTME(yytext,0);}
([Pp]er|[Pp]" "en|[Ee]fter" "ngon|[Pp]" "ngon|[0-9]+\:e|[Ss]jtte|[Ss]edan" en"|[]ver" en"|En|[Ii]nom" ngon enstaka"|""|[Ii]" samma")" "[a-z]*(minut|sekund|timma|timme)	{printTME(yytext,0);}
[Kk]"lockan "[1-9](\,[0-9]|\-[0-9]+|\/2" "1[012])?	{printTME(yytext,0);}
(ca|[Cc]irka|[Pp]" minst"|[0-9]+" tim")" "[^\n\t ]+" min\."	{printTME(yytext,0);}
(ca|c\:a|[Cc]irka|[Pp]" minst"|[0-9]+" tim"|[0-9]+" "respektive|[Ee]fter|[Dd]refter|"i "respektive)" "[^\n\t ]+" min "	{int i=0; printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">");	for(;i<yyleng-1;putchar(yytext[i++])); printf("</TIMEX> ");}
(I" "|[Ii]nom" "|[Ii]" minst "|"ca "|[Ii]" snitt "|[Tt]ill" ca ")?([0-9]+\-)?([0-9]+|[0-9]+\,[0-9]+|[1-9])" "(tim|min|sek)" "	{	int i=0; printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">"); for(;i<yyleng-1;putchar(yytext[i++])); printf("</TIMEX> ");}
[Ee]n" "[^\n\< ]*dag" "(kl|klocka)" "[0-9]+	{printTME(yytext,0);}
[Kk]vart" "(i|ver)" "{NUM}	{printTME(yytext,0);}
(tar|verstigande)" "[0-9][0-9\-]*" timmar"(na)?	{printTME(yytext,1);}
mlet" efter "[0-9]+\.[0-9]+	{printTME(yytext,1);}
[Uu]"nder "[^\n\t ]+" minuters tid"	{printTME(yytext,0);}
[Ii]" "[^\n \<>]*(minut|sekund)(en|er|erna)	{printTME(yytext,0);}
	/* MOD (Jyrki Niemi): Require word boundary on the right to avoid
	   matching partial year ranges. */
[^\n\t ]*[Tt]iden" "[0-9][0-9\.]*([\,\-]|" "[\,\-]" ")[0-9][0-9](\.[0-9][0-9])?" "	{printTME(yytext,11);}
[0-9]+\.[0-9]+\-[0-9]+\.[0-9]+" p vardagar"	{printTME(yytext,1);}
([]ppen|ankommer)" "[0-9]+\.[0-9]+	{printTME(yytext,1);}
[Ii]nkommer" "[0-9][0-9][0-9][0-9][0-9][0-9]	{printTME(yytext,1);}
[]ppet" till "[0-9][0-9][\.\,][0-9][0-9]	{printTME(yytext,2);}
[]ppet" alla dagar till "[0-9][0-9]	{printTME(yytext,1);}
([Bb]ara" "|[Ee]ndast" ")?({NUM}|[0-9]+)" "("futtiga ")?(tusen|hundra)delar	{printTME(yytext,0);}
[Ss]trax" "[^\n\t ]" gryningen"	{printTME(yytext,0);}
[Vv]id" "([0-9]+\-snret|tolvsnret|[^\n\t ]+tiden)	{printTME(yytext,0);}
([Ff]ram" "till|[Ff]re|[Ee]fter)" "[0-9][0-9]\.[0-9][0-9]	{printTME(yytext,0);}
([Kk]ring|[Pp])" "(jul|midsommar|nyrs)(dag|afton)(en)?(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
[Ss]trax" "(fre|efter)" "[0-9][0-9]\.[0-9][0-9]	{printTME(yytext,0);}
[1-9]\,[1-9]\-[1-9]" timmar"	{printTME(yytext,0);}
([Ff]rn" och med "detta|[Uu]nder" de dr "sista|[Ee]tt" "kort|[Ll]ngt|[Ss]dant" "tidens|[Ii]" "sista|[Nn]gra|[Ii]" det "hr|Ena|[Ii]" exakt "rtt|[Ii]" "ena|[Uu]nder" "dessa|[Uu]nder" de "[^\n\<\> ]+a|[Ee]fter" "ett|[Ii]" "varje|[Ii]" "samma|[Ii]" "det|[Ii]" detta"|[Ee]tt|[Nn]sta|[Pp]|[Ee]tt" "enda|[Ii]" det "[a-z]+grande|[Ii]|[Ee]fter" "ngra|[Ii]" ett "sdant|[Pp]" ett "sdant|[Ii]" sdana"|[Ii]" det "[a-z]+a|[Ff]rn" "frsta|[Ii]" "frsta|[Pp]" detta "stora|[Ee]tt" "par|[Ee]tt" "lugnt|a[fv]grande)" "gonblick(et|en)?(" "senare|" "tidigare|[Ee]fter" "ngra" "[a-z]+)?	{printTME(yytext,0);}
(hgst" ")?"1 timme"(" "senare)?	{printTME(yytext,0);}
([Mm]ellan|[Dd]agligen)" "[0-9][0-9]\.[0-9][0-9]\-[0-9][0-9]\.[0-9][0-9](" och sedan "[0-9][0-9]\.[0-9][0-9]\-[0-9][0-9]\.[0-9][0-9]|" och "[0-9][0-9]\.[0-9][0-9]\-[0-9][0-9]\.[0-9][0-9])?	{printTME(yytext,0);}
lyfte" "[0-9][0-9]\:[0-9][0-9]	{printTME(yytext,1);}
[Ii]" "[1-9]" och 1\/2 "(tim|timma|timme)	{printTME(yytext,0);}
"1 1\/2 "(tim\.?|timme)	{printTME(yytext,0);}
[0-9][0-9\,\/]*" miljoner "[^\n\t ]*timmar	{printTME(yytext,0);}
" 1 tim efter"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">1 tim</TIMEX> efter");}
" den dag det"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">den dag</TIMEX> det");}
([Pp]" "|[Uu]nder" ")?(brkdelen" "av|[Ss]" lite "som)" en "[a-z]*sekund	{printTME(yytext,0);}
[Ss]edan" "[1-9]" "(tim|timmar)(" "tillbaka)?	{printTME(yytext,0);}
[Ee]fter" en kvart"[^\n\t ]+" minuter"	{printTME(yytext,0);}
("ca "[1-9]|[1-9][0-9]\-[1-9][0-9]|[1-9][0-9])" "(min|tim)" "	{int i=0;printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">"); 	 for(;i<yyleng-1;putchar(yytext[i++])); printf("</TIMEX> ");}
("ca "[1-9]|[1-9][0-9]\-[1-9][0-9]|[1-9][0-9])" "(min|tim)\n	{int i=0;printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">"); 	 for(;i<yyleng-1;putchar(yytext[i++])); printf("</TIMEX>\n");}
[Vv]id" "halv" "[^\n\t ]+tiden	{printTME(yytext,0);}
[Mm]orgon" och "(kvll|eftermiddag)(arna)?	{printTME(yytext,0);}
[Mm]ellan" halv "[a-z]+" och halv "[a-z]+" p "(fr|efter)middagen	{printTME(yytext,0);}
[Uu]nder" de frsta "[^\n\t ]+" levnadstimmarna"	{printTME(yytext,0);}
([Ii]nom" "|[Pp]" "|[Uu]nder" en ")?[12]?[1-9](\-)?[1-9]h(" eller "[0-9]+h|" resp\. "[0-9]+h)?(" period")?	{printTME(yytext,0);}
[0-9]+" eller "[0-9][\-0-9]+h	{printTME(yytext,0);}
[Ee]n" skn "[^\n ]*morgon" i "[a-z]+" "mnad	{printTME(yytext,0);}
(Om|Mot)" "aftonen	{printTME(yytext,0);}
([Dd]enna|[Ff]ljande)" "morgon(en)?	{printTME(yytext,0);}
[Pp]" en "[a-z]+" natt"	{printTME(yytext,0);}
([Ii]nom|[Cc]\:a)" "[0-9]+" h"	{printTME(yytext,0);}
(till" ")?([Ee]fter" "{NUM}|[Kk]l" "[1-9])" p "(kvllen|morgonen)	{printTME(yytext,0);}
(till" ")?[Kk]l" "[1-9][0-9]00(" p "kvllen)?	{printTME(yytext,0);}
[Cc]irka" "[^\n\<\> ]+" "tillggsminuter	{printTME(yytext,0);}
[Ee]n" tidig "[a-z]*morgon	{printTME(yytext,0);}
stod" en "[a-z]*morgon	{printTME(yytext,1);}
[Mm]ellan" half "[1-9][0-9]?	{printTME(yytext,1);}
[Dd]e" sista "[^\n ]+" minuter"(na)?	{printTME(yytext,1);}
Senaste" "timmen	{printTME(yytext,0);}
[Nn]"gon timma"	{printTME(yytext,0);}
	/* DAYS */
([Rr]edan" "|[Ss]ent" om "|[Ss]ent" "|[Ss]enast" "|[Tt]"idigare "|[Tt]"idigt "|[Tt]"idigast ")?([Dd]"enna "|[Ii]" "|[Ff]ramp" "|[Pp][]" "|[Uu]nder" "|[Tt]idigare" ")?{DAY}(dags|dag)(" "kvll|afton|natt|midnatt|snatt|eftermiddan|efternatten|seftermiddag|"morgon bitti"|morgon" "bittida|" "natt|[^\n\t ]*kvll|[^\n\t ]*kvllen" eller dagen"|[a-z]+middag|morgon|" morse"|" och "{DAY}dags|" "[a-z]+middag)(en)?(" den "[1-9]" "{MNH}|" den "[1-9][0-9]" "{MNH}|" "kl\.[0-9\.]+[0-9]|" svensk tid")?	{printTME(yytext,0);}
([Ff]rn|[Pp])" "{DAY}dag(seftermiddag|tid|en|ar|arna)?(" och "{DAY}dag[enar]*|" "kl" "[0-9\-\.]+|" "[1-9]\/1[0-2]|" "[1-9]\/[1-9]|" "[123][0-9]\/1[0-2]|" "[123][0-9]\/[1-9])?	{printTME(yytext,0);}
([^\n\t ]*tiden" "|[SRsr]edan" ")?([Ss]enast|[Ff]rra|[Nn]atten" till"|[Uu]nder" natten till"|[Nn]atten" mot"|[Ff]"ram till"|[SsRr]edan)" "(igr" natt"|igr" morse"|"dagens datum"|i" gr afton"|i" gr natt"|igr|i" "gr|i" gr eftermiddag"|{DAY}dagens" "[^\n\t ]+middag|{DAY}dagen|{DAY}dag|[Mm]idt" i natten")(" svensk tid"|" lokal tid")?	{printTME(yytext,0);}
([SRsr]edan" "|[Jj]ust" ")?([Vv]id" "|[Ff]rn" och "med" "|[Ff]ramt" "|[Ff]rn" "|[Ss]trax" fre "|[Ss]trax" efter "|halv" "|"vid halv "|"fram till ")?[^\n\t ]+tiden" p "([^\n\t ]*morgonen|[^\n\t ]*natten|[^\n\t ]*kvllen|i" gr afton"|i" gr morse"|i" "gr|"i kvll"|igr|igr" morse"|[^\n\t ]+dagen|ikvll|[^\n\t ]+dag)	{printTME(yytext,0);}
([Ss]"enast "|[Tt]idigare" "|[Ss]enare" "|[Tt]idigt" "|[Ss]"ent ")?([Ii]" "veckan|[Ii]" "dag|[Ii]" "morse|[Ii]" "frrgr|[Ii]"gr natt"|[Ii]" gr natt"|[Ii]" "gr|[Ff]ramt|[Ii]gr|[Ss]amma|[Ff]regende)(" morse"|" kvll"|" qvll"|" "eftermiddag|" "frmiddag)(en)?(" lokal tid")?	{printTME(yytext,0);}
([Hh]gst" "[^\n\t ]+|[Uu]ngefr" "[^\n\t ]+" till "[^\n\t ]+|[Mm]inst" "[^\n\t ]+" till "[^\n\t ]+|[Ii]" "[0-9]+|[Ii]nom" "[^\n\t ]+|[Uu]nder" "[0-9]+|[Ii]ntill" "[^\n\t ]+|[Pp]" "[^\n\t ]+|[0-9]+\-[0-9]+|[Ee]fter" "[^\n\t ]+|[Ii]" antalet"|[Ii]" dessa"|[Uu]"nder dessa"|[Uu]"nder dessa dystra")" "(arbets)?dagar	{printTME(yytext,0);}
([Uu]"nder "|[Ee]fter" "|[Pp]" "|[Ii]" ver "|[Ii]" "|[Ii]nom" "|[Mm]"er n "|[Mm]"inst ")?([Dd]rygt" "|[Ii]" c:a "|[Tt]v)?([Tt]"idigast "[^\n\t ]+|[Mm]"indre n ett"|[Nn]stan" "[^\n\t ]|[Ee]tt" till "[^\n\t ]+|[0-9]+" \- "[0-9]+|[Ff]r" "[^\n\t ]+" eller "[^\n\t ]+|[0-9\-]+|[0-9\-]+\,[0-9]+|{NUM}|[Ee]tt|[Ee]tt" "knappt|[Ee]tt" "halvt|[Ee]tt" och ett "halvt|[Ee]tt" "par|[Ss]" "mnga|per|[Ff]lera|[Ss]amma|[Ff]ler|[Nn]got|[Vv]arje|[Uu]pp" till "[^\n\t ]+|[Hh]alva|"sitt andra"|[Ee]"tt extra"|[Ee]"tt ftal"|[Ll]"ngre n ngot"|[Ee]tt" "helt|symtomfria)" dygn"("s timmar"|" "framt|" "senare|" tidigare"|" dessfrinnan"|" tillbaka")?	{printTME(yytext,0);}
[Uu]nder" "(dagar" , "veckor|rets" "[^\t\n\< ]+)" "[^\n\t ]+" mnader"	{printTME(yytext,0);}
([SsRr]edan" "[Tt]idigare" "|[Ss]enare" "|[Tt]idigt" ")?([Vv]"id halv "[a-z]+" i"|[Ff]"rn "[1-9]" p"|[Tt]"ill "[1-9]" p"|[Mm]"ellan "[^\n\t ]+" och "[^\n\t ]+" p"|"till sent p"|[Uu]"nder en"|[Uu]"nder hela"|[Vv]arje|[Pp]|[Uu]nder|[Ii]|En|mot|[Hh]ela|[Nn]sta|[Ff]rra|[Dd]"e nrmaste"|[Dd]"e "{NUM}" sista"|"fram till"|[Ee]"n varm"|[^\n ]+"tiden i")" "("gr natt"|lngfredag|{DAY}dag|{DAY}dagskvllar|{DAY}dagsmorgarna|{DAY}dagsmorse|{MNH}kvll|dag|dagtid|midnatt|natt|kvll|frsommarkvll|pskhelgen|helg|helger|morgon|"morgon bitti"|"morgon \( "{DAY}dag" \)"|ntter|[^\n\t ]*ntterna)(en|ar|arna)?(" och "[^\n\t ]+dagen|" och "[^\n\t ]+natten|" eftermiddag"|" morgon")?(" svensk tid"|" lokal tid")?	{printTME(yytext,0);}
([Ee]fter" "|[Ff]re" "|[Vv]id" ")?[Hh]"alv "[^\n\t ]+" p "(kvll|dag|middag|natt|morgon)en	{printTME(yytext,0);}
([Ss]trax" ")?([Ff]"re och efter"|[Ii]nnan|[Ff]re|[Ee]fter|[Vv]id|[Kk]ring|[Rr]unt|"frrn i")" "(jul" "[12][0-9][0-9][0-9]|jul|midnatt)	{printTME(yytext,0);}
([Ss]" sent som"|[Ff]ram" till")" i "{DAY}dags	{printTME(yytext,0);}
([SRsr]edan" "|[Ss]ent" "|[Ss]enast" ")?[Ii]" "(mellandagarna|dagarna|{DAY}dags|eftermiddag|eftermiddagen)	{printTME(yytext,0);}
([Ff]rrn" "till|[Pp]" "julaftons|[Ff]rn" morgon till "sen|[Dd]en" hr "sena|[Ii]" den "tidiga|[Ff]rrn" vid "[^\n ]+tiden" "p|[Hh]ela)" "[^\n\t ]*(efter|fr)middag(ar|arna|en)	{printTME(yytext,0);}
([Mm]ot" slutet"|[Ii]" brjan")" av "[^\n\t ]*dagen	{printTME(yytext,0);}
([Hh]ittills" "|[Tt]"idigare "|[SRsr]"edan "|[Bb]"ara "|[Ff]"rst "|[Ff]"ortfarande "|[Nn]u" "|nnu" ")?(i" "kvll|i" "natt|i" "morse|i" "dag)(" svensk tid"|" \, "{DAY}dag)?	{printTME(yytext,0);}
([Dd]e" frsta ")?[1-9][0-9]+" "dagar(na)?	{printTME(yytext,0);}
[0-9]+" jmfrt med "[0-9]+" "dagar	{printTME(yytext,0);}
[Ff]r" bara ngra "[^\n\t ]+" sedan"	{printTME(yytext,0);}
[Ff]r" "[^\n\t ]+" "[^\n\t ]+" dagar sedan"	{printTME(yytext,0);}
([Ss]enast|[Ff]r)" "[^\n\t ]+" dagar "(sen|sedan)	{printTME(yytext,0);}
([^\n\t ]+"dag morgon svensk"|[0-2][0-9]" "svensk)" tid"	{printTME(yytext,0);}
[Ss]ista" dagen"	{printTME(yytext,0);}
([Rr]edan" "|[Ss]enare" "|[Tt]"idigare ")?([Ii]|[Ii]\_|[Ii]" "|[Ss]amma" "|[Ee]fter" en ")(morgon|[Dd][Aa][Gg])(" "{DAY}dag)?	{printTME(yytext,0);}
{DAY}dag" "[0-9][0-9]([01][0-9][0-3][0-9]|\.[0-9][0-9])	{printTME(yytext,0);}
([Hh]ittills" "|[Tt]"idigare "|[Tt]"idigt "|[RSrs]"edan "|[Bb]"ara "|[Ff]"rst "|[Ss]"ent "|[Ss]"enast "|[Ss]"enast nu ")?[Ii](gr|gr" "{DAY}dag|dag|morse|natt|kvll)	{printTME(yytext,0);}
([Dd]essa|[Vv]issa|[Aa]lla|ngr|[Uu]nder" rets alla")" "dagar(" och "ntter)?	{printTME(yytext,0);}
En" "[^\n\t ]+" "(kvll|dagar)	{printTME(yytext,0);}
[Mm]ellan" ett och "[^\n\<\> ]+" "dygn	{printTME(yytext,0);}
([Uu]nder" "|[Ii]nom" "|[Rr]edan" ")?([Dd]"et sista"|[Dd]e[nt]" nrmaste"|[Dd]e[nt]" senaste"|[Ff]"rn frsta"|[Dd]e[nt]" frsta"|[Oo]m|[Ff]rn|[Hh]ela|[Uu]nder|[Pp]|[Ff]rn" och med "[^\n\t ]+|[Tt]ill" och med "[^\n\t ]+|[Rr]"edan frsta"|[Dd]et" "fljande|[Dd]et" "fregende|[Ff]rsta|[Aa]ndra|"det frsta postoperativa"|"det frsta"|"viss del av"|[Ss]enaste|[Dd]e" "frsta)" "([a-z0-9\-\/]*dygnet|dagen)("s mrka timmar")?	{printTME(yytext,0);}
([Ii]nom|[Uu]nder|[Ee]fter|[Ff]rn|[Pp])" "[^\n\t ]+" dygn"(et)?	{printTME(yytext,0);}
[Uu]"nder "[^\n\t ]+" "{DAY}dagar	{printTME(yytext,0);}
[Ff]"r "[^\n\t ]+e" "dagen	{printTME(yytext,0);}
[Vv]eckan" "[^\n\t ]+" midsommar"	{printTME(yytext,0);}
{DAY}dag" "(och|till)" "{DAY}dag(" kl "[0-9\-]+)?	{printTME(yytext,0);}
([Dd]en" hr"|[Ss]edan|[Ss]trre" delen "av)" "{DAY}dagen	{printTME(yytext,0);}
([Ss]enast" ")?{DAY}dagen" den "[^\n\t ]+" "{MNH}(" "[12][\-0-9]+)?	{printTME(yytext,0);}
([Pp]fljande|[Nn]stfljande|[Jj]"ust den"|p" "en|[Ff]ljande)" "(dag|{DAY}dag)	{printTME(yytext,0);}
{DAY}dag(en)" den "[1-9][0-9]?" "({MNH}|okt|jan|feb|apr|aug|sep|nov|dec)\.	{printTME(yytext,0);}
{DAY}dag(en)?" den "[1-9][0-9]?" "({MNH}|okt|jan|feb|apr|aug|sep|nov|dec)" "	{int i=0; 	printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">");	for(;i<yyleng-1;putchar(yytext[i++])); printf("</TIMEX> ");}
{DAY}dagen" den "[1-9][0-9]?\/[1-9][012]?	{printTME(yytext,0);}
{DAY}dag" "(natt|morgon|kvll|dag)(" svensk tid"|" lokal tid")?	{printTME(yytext,0);}
[^\n\t ]+" ver "[^\n\t ]+" "(svensk|lokal)" "tid	{printTME(yytext,0);}
(tillbringat|inledde)" "({DAY}dag|{DAY}dags)?(natten|morgonen|kvllen|dagen)	{printTME(yytext,1);}
[Rr]edan" frsta "{DAY}dag(en)?	{printTME(yytext,0);}
" en "(helgdag|{DAY}dag|{MNH}kvll|dag|natt|[^\n\t ]*kvll|morgon)	{int i=1; printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">");	for(;i<yyleng;putchar(yytext[i++])); printf("</TIMEX>");}
Det" var en"(" "[^\n\t ]+)?" tidig morgon"	{printTME(yytext,2);}
{DAY}dag\-{DAY}dag	{printTME(yytext,0);}
M\-(fre|to|l|s)	{printTME(yytext,0);}
([Uu]nder" ")?{DAY}dag" \, "{DAY}dag" och "{DAY}dag	{printTME(yytext,0);}
([Uu]nder|[Mm]"ellan "|[Nn]"atten mellan ")?{DAY}dagen" och "{DAY}dagen	{printTME(yytext,0);}
([Uu]nder|[Mm]"ellan "|[Nn]"atten mellan ")?{DAY}dag" och "{DAY}dag	{printTME(yytext,0);}
[Ee]n" sen "[^\n\t ]*(kvll|eftermiddag)	{printTME(yytext,0);}
[Ee]n" "[^\n\t ]*(kvll|eftermiddag)	{printTME(yytext,0);}
({DAY}|gr)dags(kvll|natt|morgon|frmiddag|eftermiddag)(en)?	{printTME(yytext,0);}
^{DAY}dagen	{printTME(yytext,0);}
(En|[Dd]enna)" "[a-z]+" "(sommar|{MNH})(kvll|dag)	{printTME(yytext,0);}
[0-9]+dgr	{printTME(yytext,0);}
(c\:a" "[0-9]+\-|[0-9]+" \- "|ca" "[0-9]+\-|[0-9]+" \- ")?[0-9]+" dgr"	{printTME(yytext,0);}
[Dd]enna" "{MNH}dag	{printTME(yytext,0);}
[0-9]+" "(ntter|jorddagar)	{printTME(yytext,0);}
{DAY}dagar(na)?	{printTME(yytext,0);}
(vardagar|helger)" "([Kk]l\.|kl)" "[0-9\-]+(\.[0-9]+)?	{printTME(yytext,0);}
([Pp]|[Uu]nder|[Tt]ill)" "helger(na)?	{printTME(yytext,0);}
Dagen" fre hade"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">Dagen fre</TIMEX> hade");}
([Ff]rn|till|[Jj]ust|[Uu]nder)" den dagen"	{printTME(yytext,0);}
Dagen" fre "[A-Z]	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">Dagen fre</TIMEX> "); putchar(yytext[yyleng-1]);}
"p till "{DAY}dag	{printTME(yytext,1);}
Det" "(r|var)" "{DAY}dag(" "[^\n\t ]*middag)?	{printTME(yytext,2);}
Natten(" till "[0-9][0-9]\.[0-9][0-9])	{printTME(yytext,0);}
([Pp]|[Uu]nder|[Ss]trsta" delen "av|[Dd]elen" "av|[Hh]alva|[Hh]alfva|ver|[Ff]rsta|Om|[]fver)" "(efternatt|dag|natt)en	{printTME(yytext,0);}
[Ii]"morgon em "[1-9][0-9]?\/[1-9][0-9]?	{printTME(yytext,0);}
" om dan "	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">om dan</TIMEX> ");}
"dagen efter d"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">dagen efter</TIMEX> d");}
[Tt]"ill midnatt"	{printTME(yytext,0);}
" stllet fr "{DAY}dag	{printTME(yytext,2);}
[0-9]"\,"[0-9]" dagar"	{printTME(yytext,0);}
[Ee]"fter "[^\n\t ]+" intensiva dagar"	{printTME(yytext,0);}
([Bb]"de ")?[Ff]rmiddag" och "("en ")?[^\n\t ]*(eftermiddag|kvll|tid)	{printTME(yytext,0);}
([Ii]" "|[Uu]nder" "|[Ff]ramt" "|[Dd]enna" "|[Nn]sta" "|[Ff]ljande" ")(efter|fr)middag(en|s|arna)?	{printTME(yytext,0);}
[Ee]"n "(lng" "|tidig" "|hel" ")?(efter|fr)middag	{printTME(yytext,0);}
"Redan dagen efter"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">Redan dagen</TIMEX> efter");}
[Ff]"rn och med "{DAY}dagen	{printTME(yytext,0);}
[Dd]ag" "[1-9]" och dag "[0-9]+	{printTME(yytext,0);}
" med dygnet \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">med dygnet</TIMEX> .");}
Dag" "[0-9]+	{printTME(yytext,0);}
"\( "[0-9]+" dagar\-"[0-9]+" mnader \)"	{printTME(yytext,0);}
"\( 1 dag\-"[0-9]+" mnader \)"	{printTME(yytext,0);}
"tors "[12][0-9]\/[1-9]	{printTME(yytext,0);}
" den dagen \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">den dagen</TIMEX> .");}
[SsRr]edan" dag "[1-9]	{printTME(yytext,0);}
[Uu]nder" dag "[1-9](\-[0-9]+|och" "[1-9])?	{printTME(yytext,0);}
(var" "det|det" "var|det" "kanske|r" "det|det" "r)" "dax	{printTME(yytext,2);}
[Tt]ill" "([qk]vllen|vardags)	{printTME(yytext,0);}
ute" den kvllen"	{printTME(yytext,1);}
helst" om "kvllarna	{printTME(yytext,1);}
[Pp]" den "[a-z]+a" "(morgonen|[qk]vllen)	{printTME(yytext,0);}
till" "{NUM}" p qvllen"	{printTME(yytext,0);}
[Ee]n" "[^\n ]+dagsafton	{printTME(yytext,0);}
[Dd]om" "(sista|frsta)" "[0-9]+" "(dagarna|ntterna)	{printTME(yytext,0);}
[Ii]" den klara \, kalla "[^\n ]+dagen	{printTME(yytext,0);}
[Ee]n" "(bit" "in|{DAY}dagskvll)" i "{MNH}	{printTME(yytext,0);}
[Pp]" den "[a-z]+onde" dagen"	{printTME(yytext,0);}
[Ii]" en "[^\n ]+natt	{printTME(yytext,0);}
[Uu]nder" de "[^\n ]+" "[a-z]+" "dagarna	{printTME(yytext,0);}
[^\n ]+dag\-" och "[^\n ]+dagkvllar(na)?	{printTME(yytext,0);}
[^\n ]+[Dd][Aa][Gg][Ss]" morgonen den "[0-9]+" "{MNH}	{printTME(yytext,0);}
{DAY}dags" "afton	{printTME(yytext,0);}
[Nn]atten" "(mellan|emellan)" den "[1-9][0-9]?" och "[1-9][0-9]?(" "{MNH})?	{printTME(yytext,0);}
[Nn]atten" "(mellan|emellan)" "[1-9][0-9]?" och "[1-9][0-9]?(" "{MNH})?	{printTME(yytext,0);}
[Mm]orgonen" "a[vf]" den "[a-z]+a" "[1-9][0-9]?" "(Mars|{MNH})	{printTME(yytext,0);}
{NUM}" "korta" "dagarne	{printTME(yytext,0);}
[Mm]ellan" nyrs\- och "[^\n ]+dagen	{printTME(yytext,0);}
[Uu]nder" en vr\- eller "[^\n ]+dag	{printTME(yytext,0);}
([Tt]refaldighetssndagen|[Ss]ndagarne|[Mm]idsommaraftnarne|[^\n\< ]+dagsmorgnarne)	{printTME(yytext,0);}
[Uu]nder" en av rets sista "[a-z]+dagar	{printTME(yytext,0);}
[Jj]mfrt" med "underskn(ingen|ing)?" "([1-9][0-9]?\/[0-9][0-9]?|[0-9]+|[1-9][0-9]?\/[0-9][0-9]?\-[0-9]+)	{printTME(yytext,3);}
[Ee]n" "[a-z]+dag" e m"	{printTME(yytext,0);}
frsta" "kvllen	{printTME(yytext,0);}
Kvll" "[012][0-9]\.[0-9][0-9]	{printTME(yytext,0);}
	/* VECKA */
({DAY}en" i frra "|[Ss]enare" "|[Rr]edan" ")?([Uu]nder" ")?([Ii]" brjan av"|[Vv]id" slutet av"|[Ii]" slutet av"|[Ii]" mitten av nsta"|[Ss]" sent som i frra"|[Ff]rsta|[Pp]" "en|[Ii]" frra"|[Ii]" mitten av"|[Ii]" mitten"|[Ii]" nsta"|[Ff]rra|[Nn]sta|[Uu]nder|[Uu]nder" ngon"|[Ii]nom" ngon"|[Vv]arje|[Ii]" slutet av frra"|[Ii]" brjan av"|[Dd]en" senaste"|[Dd]en" hr"|[Ii]|[Dd]enna)(" "nsta)?" "(arbets)?vecka(n)?(" "[1-5][0-9]?)?	{printTME(yytext,0);}
([Uu]nder" "|[Ii]"nom "|[Ee]"fter "|[Ff]r" "|[Pp]" ")?[Dd]e" "(fljande|nrmaste|nrmsta|[^\n\t ]+" "senaste|[^\n\t ]+" "sista|senaste|sista|[^\n\t ]+" "frsta|frsta)" "({NUM}" till "{NUM}" "|{NUM}" "|{NUM}"\-"{NUM}" "|{NUM}" \- "{NUM}" "|{NUM}\-{NUM}" "|[0-9]+" "|[0-9]+\.[0-9]+" "|{MNH}\-)?[^\n\t ]*(dagar|veckor|mnader|kvllar|ren|dygnen|dagarne)(na)?	{printTME(yytext,0);}
([Ii]" minst"|[Ii]" nstan"|Om|[Uu]nder|[Pp])" "(en|{NUM})" "veck(a|or)	{printTME(yytext,0);}
([Ss]" sent som ")?([Ss]edan|Sen|[Ii]|[Ff]r|[Ii]nom|[Uu]nder|[Ee]fter|[Bb]ara|[Tt]ill|En" eller"|[Pp]|Knappt|[Nn]stan|[Oo]m)" "("dryga "|"nstan "|"drygt "|"dryg "|"ca "|"maximalt "|"c\:a "|"ca "[1-9]|"cirka "|"minst "|"hgst "|"nstan "|"snart "|"knappt ")?([a-z]+" och en halv"|"ett par"|"den gngna"|"bara ngra"|ngra|"bara en"|"mer n "[a-z0-9\:]+|"en dryg"|flera|{NUM}|[0-9]+|[0-9]+\-[0-9]+)" "("en vecka"|mnad|veckan|vecka|veckor|mnader)(na)?("s intervall"|"s mellanrum"|"s tid"|" "tidigare|" "tillbaka|" "drp|" "sen|" "sedan|" i rad"|" senare")?	{printTME(yytext,0);}
([Tt]idigare" "denna|[Dd]enna|[Ee]fter" en dryg"|[Yy]tterligare" en"|[Ee]fter" en"|[Oo]m" en dryg"|[Uu]nder" en dryg"|per|[Cc]irka" 1"|[Vv]arje|En|[Mm]indre" n en"|[Ff]"r en knapp"|[Ee]fter" c\:a 1"|[Uu]pp" till 1"|[Ss]edan" 1")" "(mn|mnad|[^\n\t ]*vecka)(" tillbaka")?	{printTME(yytext,0);}
[Vv]ecka" "[1-5][0-9]?(" och "[1-5][0-9]?)	{printTME(yytext,0);}
[]"rets frsta "[^\n\t ]+" mnader"(na)?	{printTME(yytext,0);}
([0-9]+" \- "[0-9]+|[]ver" "[0-9]+|[Cc]a" "[0-9]+|med" "[0-9]+|[Cc]irka" "[0-9]+|[Yy]tterligare" "[0-9]+|[0-9]+" och "[0-9]+|[Ee]fter" "[0-9]+|{NUM}\-{NUM}|med" "[a-z]+|[Ii]" maximalt "[0-9]+|Nstan" "[0-9]+)" "(dagar|veckor|mnader)(na)?("s mellanrum"|"s intervall")?	{printTME(yytext,0);}
([Bb]ara|[Nn]gra|[1-9]+|{NUM})" "(mnader|veckor)" "("fr sent"|innan|senare|tidigare)	{printTME(yytext,0);}
(De" "|[Dd]en" "|[RrSs]edan" ")?(frra|andra|kommande|hrom|[Nn]rmaste)(" ")?(natten|dagen|kvllen|veckan|vecka)	{printTME(yytext,0);}
[Ii]" brjan av "(den|denna)" "(laparoskopiska" "eran|hrp" "fljande" "veckan|andra" "trimestern|nra" "framtiden)	{printTME(yytext,0);}
[Ii]" brjan av "(den|denna)" "[^\n\< ]+" "vecka(n)?	{printTME(yytext,0);}
[Uu]nder" den "[^\n\< ]+" "levnadsveckan	{printTME(yytext,0);}
"Veckan efter"	{printTME(yytext,0);}
[Pp]skveckan" "[1-9][0-9]	{printTME(yytext,0);}
([Ss]enaste|[Uu]nder|[Ss]ista)" "([^\n\<]+" ")?veckorna	{printTME(yytext,0);}
([1-9][0-9]?\,[1-9][0-9]?|[1-9][0-9]?)" "[a-z]*veckor	{printTME(yytext,0);}
[1-9][0-9]?\-[1-9][0-9]?" "[a-z]*veckor	{printTME(yytext,0);}
"1\/2 veckan sedan"	{printTME(yytext,0);}
([Ii]|fr|med)" vecka "([0-9]+|[0-9]+\-[0-9]+)	{printTME(yytext,1);}
[Ss]" kort "(tid" ")?som" "[0-9\-]+" veckor"	{printTME(yytext,0);}
[Ff]rn" vecka "[0-9]+" till "[0-9]+	{printTME(yytext,0);}
[Ii]" s litet som "[^\n\t ]+" veckor"	{printTME(yytext,0);}
[Ee]fter" den "[0-9]+"\:a vecka"(n)?	{printTME(yytext,0);}
[Pp]" typ "[^\n ]+" "mnader	{printTME(yytext,0);}
ngon" vecka till \,"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">ngon vecka till</TIMEX> ,");}
([Ff]re" "|[Ee]"fter ")?[0-9]+"\:e graviditestvecka"(n)?	{printTME(yytext,0);}
([Ff]rn|[Uu]nder|[Ii])" "graviditetsvecka" "[1-9][0-9]?([\+\-][1-9][0-9]?)?	{printTME(yytext,0);}
([Ff]rn|[Uu]nder|[Ii])" "graviditetsvecka" "{NUM}	{printTME(yytext,0);}
[]ver" "[^\n\t ]+vekorsintervall	{printTME(yytext,0);}
[Ee]fter" ca "[^\n ]+" veckors fritt intervall"	{printTME(yytext,0);}
[Vv]ecka" "[0-9]+(" \, "[0-9]+)+" och "[0-9]+	{printTME(yytext,0);}
[Gg]ravititestvecka" "[0-9]+(" och "[0-9]+|\+[1-9])	{printTME(yytext,1);}
([Pp]fljande|[Nn]sta|[Ss]enaste|[Ss]ista)" vecka"(n)?	{printTME(yytext,0);}
" en vecka"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">en vecka</TIMEX>");}
([Hh]ela|[Ss]enaste)" dagarna"	{printTME(yytext,0);}
	/* -TALET */
[Ff]rn" "[0-9]+\-" till "[0-9]+\-talet	{printTME(yytext,0);}
([Rr]edan" ")?([Aa]lltsedan|[Ss]en|[Ss]edan|[Uu]nder|[Ff]rn|[Pp]|[Ii]|[Mm]ot|[Ff]ram" "till|[Vv]id|[Ff]"rn i")" "("senare hlften"|"senare delen"|"frsta hlften"|brjan|mitten|slutet|"andra hlft"|"andra halvan"|"frsta brjan"|"frsta halvan"|inledningsskedet)" "a[vf]" "[^\n\t ]+tale(t|n|ets)(" ingng"|" andra hlft"|" slut och framt"|" och framt"|" "slut|" "mitt|" "brjan|e\.Kr\.)?	{printTME(yytext,0);}
([Rr]"edan ")?([Ee]"n kort period p"|[Aa]lltsedan|[Tt]ill|[Ss]en|[Ss]edan|[Uu]nder|[Ff]rn|[Pp]|[Ii]|[Mm]ot|[Ff]ram" "till|[Vv]id|[Ff]"rn i")" "("mitten p "|"slutet p "|"slutet av "|brjan\/mitten" av "|tidigt" "|sent" "|"hela "|[]"nda till "|"brjan p "|"det sena "|[Ee]"n bit in p "|[Aa]"lltsedan ")?([^\n\t ]+tio|[^\n\t ]+hundra|[0-9]+\-|[0-9]\-" och "[0-9]+\-)tal(et|en|ets)(" slut och framt"|" "slut|" "mitt|" midt"|" "brjan|" och tidigt "[0-9]+\-tal)?	{printTME(yytext,0);}
([Uu]nder" frsta delen av"|[Vv]id" ingngen "av|[Ff]ortfarande" in p"|[Hh]ela|[Ss]" sent som p"|"brjan p"|"brjan av"|"hlften av")" "[^\n\t ]+talet(" och "[^\n ]+talets" brjan"|"s andra hlft")?	{printTME(yytext,0);}
([Rr]"edan ")?([Ss]en|[Ss]edan|[Uu]nder|[Ff]rn|[Pp]|[Ii]|[Mm]ot|[Ff]ram" "till|[Vv]id)(" "[0-9\-]+" \, "[0-9\-]+)+" och "[0-9]+\-talen	{printTME(yytext,0);}
([Rr]"edan ")?([Ss]en|[Ss]edan|[Uu]nder|[Ff]rn|[Pp]|[Ii]|[Mm]ot|[Ff]ram" "till|[Vv]id)" "[0-9]+\-" "(resp|resp\.|och)" "[0-9]+\-talen	{printTME(yytext,0);}
([Rr]"edan ")?([Ee]"n kort period p"|[Tt]ill|[Ss]en|[Ss]edan|[Uu]nder|[Ff]rn|[Rr]unt|[Pp]|[Ii]|[Mm]ot|[Ff]ram" "till|[Vv]id)" "("mitten p "|"slutet p "|tidigt" "|sent" "|"hela "|[]"nda till "|"brjan p "|"det sena "|"slutet af "|tidigt" ")?([^\n\t ]+hundra|[^\n\t ]+tio|[0-9]+\-)tal	{printTME(yytext,0);}
[0-9]+\-talets" slut och "[0-9]+"\-"talets" "brjan	{printTME(yytext,0);}
[12][0-9][0-9][0-9]" och brjan a"[vf]" "[0-9]+"\-"tale[tn]	{printTME(yytext,0);}
[12][0-9][0-9][0-9]\-tal" till "[0-9]+"\-"tal[etn]*	{printTME(yytext,0);}
[Ii]" svenskt "[0-9]+\-tal(et)?	{printTME(yytext,0);}
[Uu]nder" "[0-9]+"\-"[0-9]+"\-"tale[tn]	{printTME(yytext,0);}
([Tt]idigt|[Ff]re|[Uu]nder)" "[0-9]+"\-"tal(et|en)?	{printTME(yytext,0);}
[0-9]+tale[tn]	{printTME(yytext,0);}
[Pp]" "[0-9]+" "talet	{printTME(yytext,0);}
60\-talet" "prgla	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">60-talet</TIMEX> prgla");}
prgla" "[0-9]+\-talet	{printTME(yytext,1);}
	/* MONTHS */
[Ii]" gryningen den "[^\n\<\> ]+" "{MNH}	{printTME(yytext,0);}
([SRsr]"edan "|[Ff]"rrn ")?([Tt]ill|[Ii]|[Ff]rn|[Ss]edan|[Vv]id)" "(mitten\-slutet|mitten|slutet|brjan)" "(p|av|af)" "(Mars|{MNH})(" "mnad)?(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
([Ii]|[Uu]nder|[Mm]ellan|[Ff]rn|[Uu]nder" "tiden)" "{MNH}(" \- "|" och "|" till "|\-){MNH}(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
([Ii]|[Uu]nder|[Uu]nder" "tiden)" "([0-9]+" "{MNH}" "[12][0-9\-]+" "{MNH}" "[12][0-9\-]+|{MNH}" "mnad|{MNH}mnad|{MNH}" "[12][0-9]+|{MNH}" \-"[12][0-9]+|{MNH}" "\-[1-9][0-9]|" till och med "{MNH}" "[12][0-9]+|"andra halvan av "{MNH}" "[12][0-9]+|"frsta halvan av "{MNH}" "[12][0-9]+)	{printTME(yytext,0);}
([Ii]|[Uu]nder)" "({MNH}mnad|{MNH}" "mnad|{MNH})" r "[12][0-9]+	{printTME(yytext,0);}
([Ii]|[Uu]nder)" "({MNH}mnad|{MNH}" "mnad|{MNH})" "[12][0-9]+	{printTME(yytext,0);}
([Ii]" kommande "|[Ii]" "|[Vv]id" "|[Ff]rn" "|[Ss]edan" "|[Kk]"ring ")?[^\n\t ]*skiftet" "([^\n\t ]\/{MNH}|{MNH}" \- "{MNH}|{MNH}" "{MNH}|{MNH}\/{MNH}|{MNH}\-{MNH})	{printTME(yytext,0);}
([Ss]edan" "|[Ff]"rn och med "|[Ss]enast" ")?([^\n\t ]*[Mm]"orgonen "|[^\n\t ]*"kvllen "|[^\n\t ]*"dagen ")?([Ff]rn|[Ss]edan|[Dd]en" "[0-9]+\:[ae]|[Dd]en" "[a-z]+e|[Dd]en" "[a-z]+a|{DAY}dag" "den" "[^\n\t ]+nde|[Dd]en" "[^\n\t ]+nde|[Dd]en" "[0-9]+" till den "[0-9]+|[Dd]en" "[0-9]+|{DAY}dag" den "[0-9]+|[Dd]en" "[0-9]+" och "[0-9]+|[Dd]en" "[0-9]+\-[0-9]+|[0-9]+|fre|[Ff]rn|[Ff]"ram till"|[Ff]rn" och med"|I|{DAY}dag" \, "[1-9][0-9]?)" "(Mars|{MNH})(" "mnad)?(" "[0-9][0-9]+|" \-"[0-9][0-9]+)?(" till "{MNH})?	{printTME(yytext,0);}
([Ee]fter|[Uu]nder|[Ii]nom|[Ii])" "(ytterligare" "|ungefr" "|"upp till "|"minst "|"hgst "|{NUM}" till "|[0-9]+" till "|{NUM}" och ")?[^\n\t ]+" "mnader(na)?	{printTME(yytext,0);}
([Ll]ngre" "n|[Mm]inst|[Vv]id)" "[^\n ]+" "mnader	{printTME(yytext,0);}
([Mm]ellan" "[^\n\t ]+" "|[Ee]n" "|{NUM}" ")?"till "[^\n\t ]+" mnader"	{printTME(yytext,0);}
([Ss]enare" "denna|[Ss]"edan i "{MNH}|[Ii]"nom loppet av en"|[Uu]"nder loppet av en"|[]"ver en")" "[^\n\t ]*mnad(" "[12][\-0-9]+)?	{printTME(yytext,0);}
[^\n\t ]+sta" "{DAY}dagen" i "{MNH}	{printTME(yytext,0);}
([Pp]" ")?[1-9]+[\-\,][1-9]+" "(dagar|veckor|mnader)(na)?	{printTME(yytext,0);}
[Uu]nder" de"("gngna "|"frsta ")?(tv|tre|fyra|fem|sex|[1-9]\-[1-9])" mnaderna"	{printTME(yytext,0);}
[Uu]nder" den nu "[a-z]+" "[^\n\t ]*perioden" "[0-9]+(" "\-" "|" "och" "|" "till" "|\-)" "[0-9]+	{printTME(yytext,0);}
[Uu]nder" den "[a-z]+" "[^\n\t ]*perioden" "[0-9]+(" "\-" "|" "och" "|" "till" "|\-)" "[0-9]+	{printTME(yytext,0);}
([Uu]"nder perioden ")?[Dd]en" "[1-9][0-9]?" "{MNH}(\-|" "och" "|" "till" "|" \- ")[1-9][0-9]?" "{MNH}	{printTME(yytext,0);}
([Ff]"r perioden "|[Uu]"nder perioden "|[^\n\t ]*perioden" ")?{MNH}(" "\-" "|" "och" "|" till_och_med "|" "till" "|" fram till "|\-)(idag|{MNH})(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
([Ff]r" "|[Uu]nder" ")?[^\n\t ]*[Pp]erioden" "[123][0-9]?" "{MNH}" "[12][0-9][0-9][0-9](" till"|" till_och_med"|" till och med"|" "och)" "[123][0-9]?" "{MNH}" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
([Ff]"r perioden "|[Uu]"nder perioden "|[^\n\t ]*[Pp]erioden" ")?{MNH}" "[12][0-9][0-9][0-9](" "\-" "|" till och med "|" "och" "|" till_och_med "|" "till" "|\-){MNH}" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
([Uu]nder" "|[Ff]r" ")?[^\n\t ]*perioden" "([12][0-9\-]+|till|[Tt]"ill och med")" "{MNH}(" "[12][\-0-9]+)?	{printTME(yytext,0);}
([Nn]"gon gng ")?([Uu]nder|[Ii])" "{MNH}(" "[12][\-0-9]+|" \-"[0-9][0-9])?	{printTME(yytext,0);}
([Ii]" ")?[1-9][0-9]?(e|\:e)" "({DAY}dag|sekund|minut|timme|timma|timmar|dag|vecka|mnad|r)(en|n|et)?	{printTME(yytext,0);}
([Ff]"r omkring en"|[Ee]n" och en halv"|[Ee]n" dryg"|"c:a "[^\n\t ]+)" "(vecka|veckan|mnad|mnaden)(" "senare|" "sen|" "sedan)?	{printTME(yytext,0);}
([SRsr]"edan "|[Tt]"idigare "|[Rr]"edan till ")?[Ii]" "({MNH}|{MNH}\-{MNH})(" nsta r"|" samma r"|" i r"|" frra ret"|" ifjol"|" i fjol"|" "[12][0-9][0-9][0-9])	{printTME(yytext,0);}
([SRsr]"edan "|[Tt]"idigare "|[Rr]"edan till ")?[Ii]" "({MNH}|{MNH}\-{MNH})(" nsta r"|" samma r"|" i r"|" frra ret"|" ifjol"|" i fjol"|" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
(pgtt|lg)" en "(vecka|mnad)	{printTME(yytext,1);}
[^\n\t ]+" respektive "[^\n\t ]+" "(dagar|veckor|mnader)(na)?	{printTME(yytext,0);}
[Mm]ellan" "[a-z]+" och "{NUM}" mnader"(na)?	{printTME(yytext,0);}
([Uu]"ppemot ")?{NUM}" "(dagar|veckor|mnader|ntter)(" dessfrinnan"|" senare")?	{printTME(yytext,0);}
[^\n\t ]*tiden" var "[0-9]+" "(dagar|veckor|mnader)(na)?	{printTME(yytext,2);}
([Ee]n" eller ")?[Ee]tt" "(par|antal)" "(dagar|veckor|mnader)(na)?(" senare"|" tidigare")?	{printTME(yytext,0);}
([Ff]rra|[Ff]rsta|[Ii]|[Ss]ista|Senaste|[Ii]" "[^\n< ]+nde|[Ii]" "[a-z]+te)" "mnaden	{printTME(yytext,0);}
([Bb]rjan|[Ss]lutet)" "(af|av)" "{MNH}(" "[12][\-0-9]+)?	{printTME(yytext,0);}
([Nn]atten" till den"|[Dd]en)" "(sista|frsta|[1-9][0-9]?)" "({MNH}|{MNH}veckan)(" frra ret"|" "[12][\-0-9]+)?	{printTME(yytext,0);}
[Dd]en" "(sista|frsta|andra|tredje|[0-9]+\:e)" mnaden"(" p raken")?	{printTME(yytext,0);}
[Uu]nder" "[a-z]+" till "[a-z]+" "graviditetsmnad(en)?	{printTME(yytext,0);}
([Uu]nder|[]ver)" en "[^\n ]+mnaders" "period	{printTME(yytext,0);}
([Ss]enaste|[Uu]nder|[Uu]nder" de sista"|[Dd]"e kommande"|[Dd]"e sista "[^\n\t ]+|[Ff]"rsta "[a-z]+)" "[^\n\t ]*mnader(na)?	{printTME(yytext,0);}
[1-9][0-9]?\-[1-9][0-9]" "{MNH}(" "[0-9]+)?	{printTME(yytext,0);}
(Mn|Tis|Ons|Tors|Fre|Lr|Sn)dag(en)?" "([1-3][0-9]|[1-9])" "{MNH}(" "[0-9][0-9]\:[0-9][0-9])?	{printTME(yytext,0);}
([1-3][0-9]|[1-9])" "{MNH}(" "[0-9][0-9]\:[0-9][0-9])?	{printTME(yytext,0);}
([Ss]enast" ")?(Januari|Februari|Augusti|September|Oktober|November|December)(" "[0-9][0-9]|" \-"[0-9][0-9])?	{printTME(yytext,0);}
([Ff]lera|[0-9]+\-[0-9]+)" mnader"(na)?	{printTME(yytext,0);}
(Mn|Tis|Ons|Tors|Fre|Lr|Sn)dag(en)?	{printTME(yytext,0);}
debut" "[123][0-9]\/[1-9][0-9]?	{printTME(yytext,1);}
{DAY}dag" "[1-9][0-9]?" "(jan|feb|feb|mars|apr|maj|jun|jul|aug|sep|sept|okt|nov|dec)" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[1-9][0-9]?" "(jan|feb|febr|mars|apr|maj|jun|jul|aug|sep|sept|[Oo]kt|nov|dec)" kl "[012][0-9]\:[0-9][0-9]	{printTME(yytext,0);}
[1-9][0-9]?" "(jan|feb|febr|mars|apr|maj|jun|jul|aug|sep|sept|[Oo]kt|nov|dec)\.?" "([12][0-9][0-9][0-9]|\-[0-9][0-9])	{printTME(yytext,0);}
[1-9][0-9]?" "(jan|feb|febr|mars|apr|maj|jun|jul|aug|sep|sept|[Oo]kt|nov|dec)" "	{int i=0; printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">");	for(;i<yyleng-1;putchar(yytext[i++])); printf("</TIMEX> ");}
[Ii]" "[a-z]+" af "[^\n ]+ii" mnad"	{printTME(yytext,0);}
([Uu]nder|I" "|[Ss]edan" "|[Ss]enast" "|[Ss]enaste" ")("slutet av "|"brjan av "|"slutet af "|"brjan af ")?([a-z]+\-)?(jan|feb|febr|mars|apr|maj|jun|jul|aug|sep|sept|okt|nov|dec)[a-z]*("\-"[0-9][0-9]|" \-"[0-9][0-9]|" "[12][0-9][0-9][0-9]|" frra ret")?	{printTME(yytext,0);}
(jan|feb|[Ff]ebr|mars|apr|maj|jun|jul|julii|aug|sep|sept|okt|nov|dec)(" "[12][0-9][0-9][0-9]|" "\-[0-9][0-9]|\-[0-9][0-9]|\-[0-9][0-9][0-9][0-9])	{printTME(yytext,0);}
[Ff]"r "[^\n\t ]+" mn sedan"	{printTME(yytext,0);}
[Ss]"edan "[^\n\t ]+" mn tillbaka"	{printTME(yytext,0);}
"den "[12][0-9]\.1[012]	{printTME(yytext,1);}
[Ff]rn" "[12][0-9][0-9][0-9]" till "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[1-9]\-[1-9]" mn\."	{printTME(yytext,0);}
senaste" "[1-9]" mn\."	{printTME(yytext,0);}
[0-9]+" mnader\-"[0-9]+" r"	{printTME(yytext,0);}
[Uu]nder" "{MNH}" "[12][0-9][0-9][0-9]"\-"{MNH}" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
{NUM}" mn sedan"	{printTME(yytext,0);}
([Mm]ed|[Vv]id|[Mm]inst|[Mm]indre" n"|[Uu]nder|[Ee]fter)" "[^\n\t ]+" "(halvrs|rs|mnaders|veckors)" "(uppfljning|intervall|duration)(stid)?	{printTME(yytext,0);}
([Mm]ed|[Vv]id|[Mm]inst|[Uu]nder|[Ee]fter)" "[^\n\t ]+" "uppfljningstid" "(p|av)" "([a-z]+" ")?[0-9][0-9\,]+" "r	{printTME(yytext,0);}
[Tt]ill" och med "{MNH}" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
([Dd]ec|[Jj]an|{MNH})" "([12][\-0-9]+|\-[0-9][0-9])	{printTME(yytext,0);}
([123][0-9]" och ")?[123][0-9]" "{MNH}" "[12][0-9][0-9][0-9]" "[012][0-9]\:[0-5][0-9]	{printTME(yytext,0);}
[Mm]ellan" mnad "[a-z]+" och "[a-z]+	{printTME(yytext,0);}
[Uu]nder" den andra och tredje trimester"(n)?	{printTME(yytext,0);}
([Uu]nder" "|[Ii]" frsta respektive ")?(den" ")?(sista|frsta|andra|tredje)" "("och andra ")?trimestern	{printTME(yytext,0);}
(Frsta|Andra|Tredje)" "trimestern	{printTME(yytext,0);}
Kvllen" fre kom"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">Kvllen fre</TIMEX> kom");}
Kvllen" fre blev"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">Kvllen fre</TIMEX> blev");}
" en mnad efter"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">en mnad</TIMEX> efter");}
[Mm]nadsskiftet" "[a-z]+" \/ "[a-z]+(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
[Mm]nadsskiftet" "[a-z]+\/[a-z]+(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
(jan|feb|febr|mars|apr|maj|jun|jul|aug|sep|sept|okt|nov|dec)" "(\-[0-9][0-9]|[12][0-9][0-9][0-9]|\-[12][0-9][0-9][0-9])	{printTME(yytext,0);}
[Aa]v" dessa "[0-9]+" mnader"	{printTME(yytext,0);}
[0-9]+" mnader \, "[0-9]+" mnader och drefter varje r"	{printTME(yytext,0);}
[Ss]enast" "[1-9]\/[1-9]([012])?	{printTME(yytext,0);}
{MNH}" \-"[7890][0-9]	{printTME(yytext,0);}
([Ff]rst" ")?[Ee]fter" "[0-9]+" mn"(ader|\.|aders" "tid)?	{printTME(yytext,0);}
"tid r "[0-9]+" mnader"	{printTME(yytext,2);}
[Nn]u" i "[0-9]+\:e" "[^\n ]*mnaden	{printTME(yytext,0);}
([Tt]idigast" ")?([Ff]rn|[Ee]fter)" "[^\n ]+rsmnaden	{printTME(yytext,0);}
([Dd]e" sista"|[Ss]enaste)" "[^\n ]+" mnaderna"	{printTME(yytext,0);}
[Dd]en" "[^\n ]+" "(februarii|Mars|[Jj]ulii)(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
[Ii]" "(februarii|Mars|[Jj]ulii)" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[Ss]enast" "[0-9][0-9]"\:e "{MNH}" pfljande r"	{printTME(yytext,0);}
([Ii]nom" ")?[0-9]+" mnaders vntetid"	{printTME(yytext,0);}
[Ee]n" och en halv mnad "(sen|sedan)	{printTME(yytext,0);}
[Uu]nder" "[12][0-9][0-9][0-9]" mnad fr mnad"	{printTME(yytext,0);}
[Uu]nder" "(de|den)" "(frsta)" "[^\n\t ]+a" "mnade[nr](na)?	{printTME(yytext,0);}
[Uu]nder" "de" "({NUM}|[^\n\t ]+a|nrmaste|fregende|senaste|gngna|nrmast" "fregende)" "[^\n\t ]+" "mnader(na)?	{printTME(yytext,0);}
([]ver|[Uu]tver|[Ee]fter)" "de" "[^\n\< ]+" "mnader(na)?	{printTME(yytext,0);}
[Uu]nder" "(rets|fjolrets)" "[a-z]+" sista "mnader	{printTME(yytext,0);}
[Dd]e" "(frsta|kommande|sista)" "[^\n\< ]+" "mnader(na)?	{printTME(yytext,0);}
[0-9]+" r och "[0-9]+" "mnader	{printTME(yytext,0);}
[0-9]+" r \, "[0-9]+" "mnader	{printTME(yytext,0);}
(Sista|Frsta)" "{MNH}	{printTME(yytext,0);}
[Kk]l\."  "[1-9][0-9]?	{printTME(yytext,0);}
[Tt]ill" och med "{MNH}" i somras"	{printTME(yytext,0);}
{MNH}" "([12][0-9][0-9][0-9]|\-[0-9][0-9])	{printTME(yytext,0);}
{MNH}" nsta r"	{printTME(yytext,0);}
{MNH}" frra ret"	{printTME(yytext,0);}
{MNH}" "\-[012][0-9]	{printTME(yytext,0);}
[0-9]+" "{MNH}\-[0-9]+" "{MNH}	{printTME(yytext,0);}
[Ii]\_brjan\_av" "{MNH}	{printTME(yytext,0);}
[Nn]u" i "{MNH}	{printTME(yytext,0);}
	/* YEARS */
[Pp]erioden" "[0-9]+" "{MNH}" "[0-9]+\-[0-9]+" "{MNH}" "[0-9]+	{printTME(yytext,0);}
" r det ett r "	{printf(" r det <TIMEX TYPE=\"TME\" SBT=\"DAT\">ett r</TIMEX> ");}
([Ss]edan|[]r|[^\n\t ]*[]ret|[Rr]edan|"fram till"|[Ff]rn" och med"|[Tt]ill" och med"|frrn" omkring"|[Ff]rrn)" "[12][0-9][0-9][0-9](\/[0-9]+|\-[0-9][0-9]\-[0-9][0-9])?	{printTME(yytext,0);}
[Pp]" "nyrsdagen(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
([Uu]ngefr" ")?([]"ren runt "|[Ff]"ram till och efter "|[Vv]id" varje "|[Vv]id" "|[Kk]"ring "|[Ff]"rn "|[Ss]"edan "|[Rr]unt" "|[Uu]"nder "|[Ff]re" "|[Tt]"ill "|[Ee]"fter "|[Ff]"rra "|Sen" ")?[^\n\t ]*(illenie|illennie|rs|sekel|mnads)skiftet(" "[012][0-9][0-9][0-9\/\-]+)?	{printTME(yytext,0);}
(Frst" "|[Pp]" "[Rr]unt" "|[Oo]mkring" "|[Ff]ram" till ")r" "[0-9]+" "[EeFf](" \."[Kk]r|" "[Kk]r|\.[Kk]r\.|\.[Kk]r|\." "[Kk]r)	{printTME(yytext,0);}
(Frst" "|[Pp]" "[Rr]unt" "|[Oo]mkring" "|[Ff]ram" till ")?[1-9][0-9\-]+(\-talet)?" "("r ")?[EeFf](" \."[Kk]r|" "[Kk]r|\.[Kk]r\.|\.[Kk]r|\." "[Kk]r)	{printTME(yytext,0);}
	/* MOD (Jyrki Niemi): Allow "rs": this makes the result slightly
	   different from that of the original recognizer but includes a NE
	   that would otherwise have been removed by the correction filter.
	   Also require a word boundary as the right context. */
([Ii]" mer n "|[Pp]" ver "|[Uu]nder" mer n "|[Pp]" "|[Ff]r" ungefr "|[Ff]r" nstan "|[Ff]r" ett "|[Ff]r" "|[Ff]r" snart "|[Ee]fter" "|[Ii]" "|[]ver" "|[Nn]"stan ")?(ytterligare" "|minst" "|ca" "|"c\:a "|[Cc]irka" "|"mer n "|"drygt "|snart" "|knappt" ")?([Nn]gra|flera|[Tt]v|[Ee]tt|ett" knappt"|[Tt]re|[Ff]yra|[^\n\t ]*[Ff]em|[Ss]ex|[Ss]ju|[]tta|[Nn]io|[Tt]io|[Tt]jugo|[1-9]" 1\/2"|[1-9]" och 1\/2"|[0-9]+|[0-9]+\-[0-9]+|[^\n\t ]*[Hh]undra|[^\n\t ]+ton|[^\n\t ]+" och ett halvt"|"ett halvt"|[Ff]r" "[^\n\t ]+|[Ee]"tt par"|{NUM})(" hundra"|" miljoner"|" tusen")?" r"(" framt i tiden"|" tillbaka i tiden"|ssikt|s" "sikt|s" "tid|" "sedan|" "tidigare|" tillbaka"|" eller mer"|" "senare|" "sen|" senare "[12][0-9][0-9][0-9]|" senare \, "[12][0-9][0-9][0-9]|s)?" "	{printTME(yytext,11);}
[Pp]" "[^\n< ]+" "(dagars|veckors|mnaders|rs)" eller "[^\n< ]+" "(dagars|veckors|mnaders|rs)" "sikt	{printTME(yytext,0);}
[Pp]" "[^\n< ]+" "(vecko|daga|mnade|)es" "sikt	{printTME(yytext,0);}
([Ff]r" ")?([Dd]rygt" "|[Mm]"er n "|[Ee]fter" ")?[Ee]tt" "("kvarts ")?[a-z]*sekel(" tillbaka"|" senare"|" sedan")?	{printTME(yytext,0);}
[Uu]nder" "(de|det)" aktuella "re(t|n)(" \, "[12][0-9][0-9][0-9\-]+)?	{printTME(yytext,0);}
([TtFfr]\.o\.m\.|[Tt]" o m"|[Ff]"r o m"|[Tt]"ill och med")" "[12][0-9][0-9][0-9]" "[1-9][0-9]?\/[1-9][012]?	{printTME(yytext,0);}
([TtFfr]\.o\.m\.|[Tt]" o m"|[Ff]"r o m"|[Tt]"ill och med")" "[12][0-9][0-9][0-9]"\-"[0-9][0-9]"\-"[0-9][0-9]	{printTME(yytext,0);}
([TtFfr]\.o\.m\.|[Tt]" o m"|[Ff]"r o m"|[Tt]"ill och med")" "[7890][0-9][0-9][0-9][0-9][0-9]	{printTME(yytext,0);}
([TtFfr]\.o\.m\.|[Tt]" o m"|[Ff]"r o m"|[Tt]"ill och med")" "[123]?[0-9]\.[12]?[1-9]\.[12][0-9][0-9][0-9]	{printTME(yytext,0);}
([TtFfr]\.o\.m\.|[Tt]" o m"|[Ff]"r o m"|[Tt]"ill och med")" "[0-9][0-9]\-[0-9][0-9]\-[0-9][0-9]	{printTME(yytext,0);}
([TtFfr]\.o\.m\.|[Tt]" o m"|[Ff]"r o m"|[Tt]"ill och med")" "[1-9][0-9]?\/[1-9][0-9]?" \-"[0-9][0-9]	{printTME(yytext,0);}
([TtFfr]\.o\.m\.|[Tt]" o m"|[Ff]"r o m"|[Tt]"ill och med"|[Ff]"rn och med")" "([1-9][0-9][0-9][0-9]|idag|vecka" "[0-9][0-9]?|mitten" av vecka "[0-9][0-9]?)	{printTME(yytext,0);}
[Uu]nder" "kontrollren" "[0-9]+" och "[0-9]+	{printTME(yytext,0);}
[^\n\t ]+" till "[^\n\t ]+" rs intervall"	{printTME(yytext,0);}
([Uu]nder|[Dd]e|[Dd]et|[Uu]nder" "de|[Uu]nder" "det|[Pp]|[Ss]edan|[Dd]om)" "(ett|andra|dryga|frsta|senare|senaste|sista" "[0-9]+|sista)" "(halv|krigs)?r(stid|s" "tid|et|en|tiondena|"et "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
([Uu]nder" "|[Pp]" ")?[0-9]+\-" och "[0-9]+\-tal[etns]+	{printTME(yytext,0);}
([Ss]enare" i"|[Hh]ittills" i"|[Nn]u" i"|[Uu]nder|[Ii]|[SsRr]edan" i"|[Ss]enast" i"|[Ss]edan|[Tt]idigare" i"|[Ff]rn" tidigare"|[Ff]rn" i")" ren"(" "[12][0-9][0-9][0-9]|" "[12][0-9][0-9][0-9]\-[0-9]+|" "[12][0-9][0-9][0-9]" \- "[0-9]+)	{printTME(yytext,0);}
([Ss]enare" i"|[Hh]ittills" i"|[Nn]u" i"|[Uu]nder|[Ii]|[SsRr]edan" i"|[Ss]en" i"|[Ss]enast" i"|[SsRr]edan|[Tt]idigare" i"|[Ff]rn" tidigare"|[Ff]rn" i")" "("flera "|{NUM}" ")?(ratal|sekler|rtionde[tn]|rtionden|manr|r|fjol|fjolsomras|pskas|vras|hstas|hst|hsten|sommras|somras|vintras|somrar|somrarna|vintrarna|vintrar|"vras\-somras")(" "[12][0-9][0-9][0-9]|" \-"[0-9][0-9]|" "senare|" "sednare|" framt i tiden"|" bakt i tiden")?	{printTME(yytext,0);}
	/* removed fr*/
([Uu]nder" "|[Ss]enare" "|[RrSs]edan" ")?([Ii]nfr|[Ii]nnan|[Pp]|[Rr]unt|[Ss]edan|[Ss]enast|[Tt]ill|[Uu]nder|[Vv]arje|Fr|[Ff]re|[Ff]rra|[Ff]rrn|[Hh]ela|[Ii]|[Ff]rn|[Ee]fter|[Ff]r\.o\.m\.|[Tt]idigt" under"|[Aa]lla" de hr"|[Bb]rjan" av"|[Dd]essa" "{NUM}|[Dd]e" "kommande|[Ff]ram" till slutet av"|[Ff]rn" och med i"|[Ff]rn" och med"|[Ff]rn" slutet av"|[Ff]r" "hela|[Ff]r" det gngna"|[Ii]" brjan "av|[Ii]" brjan "p|[Ii]" slutet "av|[Ii]" slutet av frra"|[Ii]" slutet av nsta"|[Ii]" slutet p frra"|[Mm]ot" slutet "av|[Mm]otsvarande" period frra"|[Nn]u" under"|[Nn]stan" varje"|[Pp]" hela"|[Rr]esten" av"|[SRsr]edan" frra"|[Ss]enare" delen av"|[Uu]nder" "kommande|[Uu]nder" alla "[^\n ]+|[Uu]nder" de gngna"|[Uu]nder" de hr"|[Uu]nder" den gngna"|[Uu]nder" det gngna")" "("frsta "|"andra "|"nsta "|sen)?([^\n\t ]*halvret|r|ret|midsommar|sommarlovet|sommar|vren|hsten|[^\n\t ]*sommaren|sommarens" "hgssong|helret|"rets slut"|vinter" och vr"|vintern|vinter|vintertid|sommartid|ret|ren|den" dr "vren|den" "vren)(" och vintern"|" och sommaren"|" och hsten")?(" "[12][0-9]+|" i r")?	{printTME(yytext,0);}
([Dd]en" "[^\n\t ]+bara" "|[RrSs]"edan ")?([Jj]ulen|[Ss]ommar|[Vv]ren|[Hh]sten|[Ss]ommaren|[Vv]intern|[Ss]enast)" "(\-[0-9][0-9]|[12][0-9\-]+)	{printTME(yytext,0);}
([Ii]"bland ")?([Ii]nom" "ett|[Bb]ortt" "ett|[Uu]nder" flera hundra"|Om" "[a-z]+|[Ss]edan" ngra"|[Uu]"nder ngra"|[Ss]edan" "[0-9]+|[Ii]" ver "[^\n\t ]+|[Ff]rn" "[^\n\t ]+mnader" till ett"|[Ii]" upp till "[^\n\t ]+|flera|[Dd]rygt" "ett|[Kk]nappt" ett"|[Pp]" "[^\n\t ]+" till "[^\n\t ]+|[Ii]"nom "[^\n\t ]+" till "[^\n\t ]+|[Uu]nder" "[^\n\t ]+[^\ng ]" till "[^\n\t ]+|[Pp]" ngra f"|[Mm]ed" "[^\t\nk ][^\n\t ]+" "{NUM}|[Ee]fter" mer n "[^\n\t ]+|minst" "ngot|[Pp]" mnaders eller "ngot|P" "[^\n\t ]+|[Ee]fter" ca "[^\n\t ]+|[Ee]tt" "helt|[Ee]fter" "[^\n\t ]+" lnga"|[Uu]"nder tusentals"|[Uu]"nder de "{NUM}" nrmaste"|[Uu]"nder de "{NUM}|[Nn]got)" r"(en|"s sikt"|" senare"|" tidigare"|" sedan")?(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
[Uu]nder" "("hela "[^\n\t ]*perioden" "|[^\n\t ]*perioden" "[12][0-9][0-9][0-9]" "till|[^\n\t ]*perioden|[12][0-9][0-9][0-9]" "och|hela|lngt" "bortom|"resten av")" "[12][0-9\-]+	{printTME(yytext,0);}
[^\n\t ]*[Pp]erioden" "[12][0-9][0-9][0-9]" "till" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[^\n\t ]*[Pp]erioden" "[12][0-9][0-9][0-9]"\-"[12][0-9][0-9][0-9]	{printTME(yytext,0);}
([Ff]r" "innevarande|[Ss]edan" i "[a-z]+" av frra"|[SsRr]"edan i slutet av nsta"|[Ff]"rn och med nsta"|[Vv]arje|[Ff]rra|[Pp]|[Ii]nom" det nrmaste"|[Nn]sta|[Uu]nder" de fljande"|[Uu]nder" "nsta|[Ii]nfr" "nsta|[Dd]e" sista "[^\n\t ]+|[Dd]e" "[^\n\t ]+" kommande"|[Ii]" "[0-9]+|[Uu]nder" de kommande"|[Ss]edan" ngra "|[Uu]nder" mnga "|[Uu]nder" detta "|[Uu]nder" de kommande "[^\n\t ]+|[Dd]e" stormiga"|[Dd]"e kommande"|[Dd]"et kommande"|[Dd]"e nrmaste "[^\n\t ]+|[Dd]"e nrmaste"|[Uu]"nder det kommande"|[Uu]nder" de senaste "[^\n\t ]+|[Nn]gra|[Gg]enom|[Uu]nder" "{NUM})" "(man)?r(tiondena|tionde[tn]|et|en|hundraden|hundradena|hundradet|tusenden)?(" "tillbaka)?	{printTME(yytext,0);}
[Mm]ellan" "[12][0-9][0-9][0-9]" och "([0-9][0-9]|[12][0-9][0-9][0-9])	{printTME(yytext,0);}
Efter" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[Uu]nder" "den" "[0-9\-]+riga" "[^\n\t ]*perioden	{printTME(yytext,0);}
[Uu]nder" "[^\n\t ]+perioden(s" "brjan)?	{printTME(yytext,0);}
[Uu]nder" en vldigt lng "[^\n\t ]*period	{printTME(yytext,0);}
[Uu]nder" en relativt "[a-z]+" "[^\n\t ]*period	{printTME(yytext,0);}
[Uu]nder" "en" "[^\n\t ]+period	{printTME(yytext,0);}
([Ff]ram" "till|[Nn]yret|[Ff]"regende "[^\n\t ]+period|[Tt]axeringsret|[Tt]axeringsr|[Tt]idigast|sekelskiftet|[Ii]" brjan av"|[Ii]" slutet av"|[Uu]nder|"liksom ret innan"|[Ss]amma" period ret innan"|[Ss]amma" period"|frret|[Mm]otsvarande" period"|Frst|[Ii]nfr|[Ii]nnan|[Dd]en" dagen"|[Ff]r" resten av"|[Ll]sret)" "[12][0-9][0-9][0-9](" tom "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
([Uu]nder|[Ii]" brjan av")" "(den|en|samma|ngon|denna|"den senaste"|hela)" "([^\n\t ]+" "[^\n\t ]+" lng "|[^\n\t ]+" "|[^\n\t ]+" \, lng ")?(tids|[^\n\t ]*rs)?period(en)?	{printTME(yytext,0);}
([Vv]id|[Ff]rn|[Uu]nder)" den "[^\n\t ]+" "([^\n\t ]+rsperioden|[^\n\t ]+rsperiod|rsskifte|rsskiftet)	{printTME(yytext,0);}
([Vv]id|[Ff]rn|[Uu]nder)" "[^\n\t ]+" "([^\n\t ]+rsperioden|[^\n\t ]+rsperiod|rsskifte|rsskiftet)	{printTME(yytext,0);}
([Vv]id|[Uu]nder)" varje "[^\n\t ]+rsskifte	{printTME(yytext,0);}
([Ff]rn|[Uu]nder)" tminstone "[^\n\t ]+" "[^\n\t ]+rsperiod	{printTME(yytext,0);}
([Ee]fter|[Ii])(" nstan")?" "[a-z0-9]+" r"	{printTME(yytext,0);}
[Nn]ormalt" r och till och med decennier"	{printTME(yytext,0);}
	/* MOD (Jyrki Niemi): Removed spurious ] from regexp */
([Ii]nom|[Ii]|[Ss]edan|[Uu]nder|[Mm]indre" n"|[Uu]"pp till")" ett "(par" "|halv)(r|decennier)(" tillbaka")?	{printTME(yytext,0);}
([Ss]en|[RrSs]edan|[Ii]|[Uu]nder|[Ee]fter|[Pp]|[Uu]pp" "till|[Ii]" "nstan|[Ii]" "ver|[Ii]" ytterligare")" "([^\n\t ]+" rs tid"|[^\n\t ]+" rs mellanrum"|"bara "[0-9]+" r"|"nra "[0-9]+" r"|"de tre sista decennierna"|"fr flera decennier"|"flera decennier"|"resterande del av ret"|{NUM}" decennier"|"ngot decennium"|"ett decennium"|[^\n\t ]+" r tillbaka i tiden"|[^\n\t ]+" r tillbaka"|"mer n "[^\n\t ]+" r"|decennier)(" "tidigare|" sedan"|" "tillbaka)?	{printTME(yytext,0);}
[Uu]nder" den "[^\n\t ]+" rstiden"	{printTME(yytext,0);}
([Dd]etta|[0-9]+\:e)" "ret	{printTME(yytext,0);}
([Mm]ot|[Vv]id)" "({MNH}|[12][0-9][0-9][0-9])" "(mnads|rs)" "utgng	{printTME(yytext,0);}
[Uu]nder" den "[a-z\-]+" tiden"	{printTME(yytext,0);}
(Framemot|[Ff]rsta|[Dd]en" "hr)" "[a-z]*tiden	{printTME(yytext,0);}
[Tt]idig" vr "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[Mm]ellan" 199"[0-9]\-9[0-9]	{printTME(yytext,0);}
[Mm]ellan" ren "[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]	{printTME(yytext,0);}
[Nn]gon" gng mellan "[0-9][0-9]" och "[0-9][0-9]	{printTME(yytext,0);}
[Mm]ellan" "[12][0-9][0-9][0-9]"\-"[12][0-9][0-9][0-9]	{printTME(yytext,0);}
"intrffade "[0-9]+" ddsfall"	{ECHO;}
[Nn]sta" "(vecka|mnad|vr|sommar|vinter|hst)	{printTME(yytext,0);}
[^\n\t ]*(formaliserades|faststlldes|terfanns|uppfanns|frliste|fraktur|epikris|vinst|enkt|opererades|spelas|infll|resa|branden|igng|levererades|uppgick|tillflle|ndades|frig|villkorligt|greps|revs|godknd|privatiserades|kulminera|sjs|skilsmss|begravning|mstar|klar|modell|delser|anlades|[Bb]ygg|evenemang|mord|mte|miljarder|nederlag|kptes|stng|plats|diagnos|dateringen|frdigt|bilda|valet|rstningen|konferens|ppnades|hit|kriget|inleddes|upphrde|mnades|president|ebuterade|pensionering|revolutionen|infrdes|start|spring|delningen|lanseras|krisen|tcktes|revolutionen|intrffade|fddes|makten|slutfr|pererad|pbrja|fdd|den|han|hon|fdda|fds|digheten|frdrevs|cerades|publicerats|examen|sldes|slut|starta|infrdes|dmdes|dd|ensionerad|dog|studie|levde|grunda|jubile|starten|infrt|utgav|rrelsen|intg|genomfrdes|silv|infras|infrandetguld|belpris|regerade|rapport|regering|vigdes|brjade|kuppen|mig|nd|frst|edovisningen|besk|upprttades|rdigstlld|avlmnas|tfrdad|ut|Lancet|BMJ|inkomster|vapenvilla|kraft|undersktes|introducerades|hndelsen|frdigstll|rka|EKG|prov)[a-z]*(" omkring"|" efter"|" fre"|" under")?" "[12][0-9][0-9][0-9]([\/\-][0-9]+|[\/\-][0-9][0-9][\/\-][0-9][0-9]|" och "\-[0-9]+)?	{printTME(yytext,1);}
("gifte sig"|"udget fr"|"udgeten fr"|"et al"|"lades fram"|"utsattes fr"|"Det var"|"jmfrt med"|"niv med"|"prognos infr"|"som stoppades"|"kom ut"|"statistiken fr"|"drjde till"|"frsta gngen"|"den till"|"gr ut"|"gde rum"|[Pp]roduktionsr" \:")" "[12][0-9][0-9][0-9](\-[12][0-9][0-9][0-9])?	{printTME(yytext,2);}
"kom till "[^\n\t ]+" "[12][0-9][0-9][0-9]	{printTME(yytext,3);}
[12][0-9][0-9][0-9]\-[01][0-9]\-[0123][0-9]	{printTME(yytext,0);}
([Ss]" sent som"|[]nnu|[Ff]re|Under|[Ff]rn|[Ff]r|[]rtalet|[Aa]nno|[Ff]rn" mitten av")" "[12][0-9][0-9][0-9](" och "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
([Ff]r|[Uu]nder|[Pp]|[Ss]edan|[Oo]ftast|[Ll]iksom)" "([^\n\t ]+" ")?("ett "[^\n\t ]+\-tal|senare|tidigare|mnga)" r"(" sedan"|" sen")?	{printTME(yytext,0);}
([Ii]" "nrmare" "[^\n\t ]+|[Ff]"rrn om "[^\n\t ]+" "[0-9]+|[Uu]nder" de dryga "[^\n\t ]+|[Ii]nom" "[a-z0-9]+|[Vv]art" "[^\n\t ]+e|[Ff]lera" tusen"|"per tusen"|[Uu]"nder fljande"|[Uu]"nder ngot")" r"	{printTME(yytext,0);}
([Mm]ellan|[Uu]nder|[Ff]r|[Gg]enom|[Ee]fter|[Ff]rn)" ren "[12][0-9]+(" \- "[12][0-9]+|" och "[12][0-9]+|" till "[12][0-9]+|\-[12][0-9][0-9]?[0-9]?)	{printTME(yytext,0);}
([Rr]"edan ")?([Ss]en|[Ss]edan|[Uu]nder|[Ff]rn|[Pp]|[Mm]ot|[Ss]enaste)" "("andra hlften"|"frsta hlften"|"senare hlften"|"senare delen"|frsta" "delen|brjan|mitten|slutet|"andra halvan")" "(af|av)" "[12][0-9][0-9][0-9](\-talet)?	{printTME(yytext,0);}
([Nn]stan|[Mm]ellan" "[0-9]+" och ")[0-9]+" r"	{printTME(yytext,0);}
([Ss]enast" ")?den" "[12][0-9][0-9][0-9]\-[0-9][0-9]\-[0-9][0-9]	{printTME(yytext,0);}
[Kk]ring" r "[12][0-9][0-9][0-9]\-[0-9][0-9][0-9][0-9]	{printTME(yytext,0);}
"jmfrt med ret fre"	{printTME(yytext,2);}
([Aa]ndra|[Ff]rsta|[Uu]nder" det nrmaste"|[12]\:a)" halvret"(" i r"|" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
{NUM}" r i rad"(" \( "[0-9][0-9][0-9]?[0-9]?" och "[0-9][0-9][0-9]?[0-9]?" \)")?	{printTME(yytext,0);}
([Ff]r" ")?[^\n\t ]+[ea]" ret i rad"	{printTME(yytext,0);}
[12][0-9][0-9][0-9]" "(vann|startade|omsatte|slde|kade|uppgick|flytta|lmnad|registr|infrde|dmdes|anmldes|debutera|utnmn|pbrja)[^\n\t ]*	{printTME(yytext,11);}
^[12][0-9][0-9][0-9]" "(behandlades|berknas|beslt|betonade|beviljade|bildades|blev|brjade|diagnostiserades|dog|drabbades|fanns|fatta|fick|frskrevs|frsvarade|framstlld|gift|godkndes|hade|hedrades|inhmtades|inleddes|inrttades|insjuknade|installerades|introducera|invigdes|kom|lanserade|lyckades|noterades|nybeviljades|omsa|opererades|ppnade|verflyttades|verfrdes|vergick|verskreds|publicerad|rapportera|redovisa|sjsatte|skedd|slogs|strmma|upphrde|uppskattades|upptckt|utfrdes|vann|var)	{printTME(yytext,11);}
(behandlades|dog|drabbades|fanns|hedrades|inhmtades|inleddes|inrttades|insjuknade|installerades|opererad|opererades|ppnades|verflyttades|verfrdes|publicerad|rapporterad|redovisad|sjsattes|upphrdes|uppskattades|upptcktes|utfrdes)" i "[a-z]+" "[12][0-9][0-9][0-9]	{printTME(yytext,3);}
[Oo]m" "[^\n\t ]+" "(till|eller)" "[^\n\t ]+" r"	{printTME(yytext,0);}
[Ee]fter" "[0-9]+" resp "[0-9]+" "r	{printTME(yytext,0);}
"I vr kan"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">I vr</TIMEX> kan");}
"hela tiden \."	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">hela tiden</TIMEX> .");}
"Lnge har "	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">Lnge</TIMEX> har ");}
"ch d ska "	{printf("ch <TIMEX TYPE=\"TME\" SBT=\"DAT\">d</TIMEX> ska ");}
"hade d ngo"	{printf("hade <TIMEX TYPE=\"TME\" SBT=\"DAT\">d</TIMEX> ngo");}
" det ret \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">det ret</TIMEX> .");}
" ret fre \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">ret fre</TIMEX> .");}
" dagen efter \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">dagen efter</TIMEX> .");}
" som tidigare r "	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">som tidigare r</TIMEX> ");}
"Och d "	{printf("Och <TIMEX TYPE=\"TME\" SBT=\"DAT\">d</TIMEX> ");}
" sllan understiger"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">sllan</TIMEX> understiger");}
"undersker nu "	{printf("undersker <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
"inom ret \?"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">inom ret</TIMEX> ?");}
" om ret"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">om ret</TIMEX>");}
" i vr ,"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">i vr</TIMEX> ,");}
" ret om skulle"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">ret om</TIMEX> skulle");}
" s sent hem"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">s sent</TIMEX> hem");}
" om "[^\n\t ]+" "r(" eller "senare|" \( eller senare \)")?	{int i=1; printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); for(;i<yyleng;putchar(yytext[i++])); printf("</TIMEX>");}
[12][0-9][0-9][0-9]" r ett bra r"	{int i=8; printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">");
	putchar(yytext[0]); putchar(yytext[1]); putchar(yytext[2]); putchar(yytext[3]);
	printf("</TIMEX> r "); printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">");
	for(;i<yyleng;putchar(yytext[i++])); printf("</TIMEX>");}
([Tt]" o m"[Ff]r" "rets|[Uu]nder|[Ii]" det"|[Ee]"tt "[a-z]+|[Uu]nder" "det|[Dd]et|[]rets|[Ff]r|[Uu]nder" "rets)" "[^\n\t ]+[ae]" "(tv" "|tre" ")?(kvartal|kvartalet|[^\n\t ]+" "mnader)(" "[12][0-9]+)?	{printTME(yytext,0);}
([Ff]rrn" ")?("2\:a kvartal"|"senaste decenniet"|[1-9]"\:e decenniet"|[Aa]ndra" "kvartalet|[Aa]ndra" kvartalet"|[Dd]"e senaste decennierna"|[Dd]e" tv senaste "decennierna|[Dd]en" "[1-9][0-9]?\/[1-9][012]?" "[0-9]+|[Dd]en" "[1-9][0-9]?\/[1-9][012]?|[Ee]n" bra bit in i nsta decennium"|[Ee]tt" decennium"|[Ee]tt" par "decennier|ett" rhundrade senare"|[Ff]ram" till de senaste decennierna"|[Ff]rn" samma kvartal"|[Ff]r" helret "[1-9][0-9]+\/[1-9][0-9]+|[Ff]rra" kvartalet"|[Ff]rsta" "kvartalet|[Ii]" mitten av decenniet"|[Ii]" mitten av det hr decenniet"|[Ii]" mnga decennier"|[Mm]otsvarande" kvartal"|[Mm]otsvarande" tid"|[Nn]sta" decennium"|[Oo]m" "ret|[Pp]" ngra "decennier|[Uu]nder" "[^\n\t ]+" "kvartalet|[Uu]nder" de senaste "[^\n\t ]+" "decennierna|[Uu]nder" decennierna"|[Uu]nder" det senaste decenniet"|[Uu]nder" kommande "decennier|[Uu]nder" kvartalet"|[Uu]nder" samma kvartal"|[Uu]nder" senare "decennier)(" "ifjol|" i "fjol|" ungefr i samma "tid|" i r"|" ret fre"|" tillbaka"|" "[12][0-9]+)?	{printTME(yytext,0);}
	/* MOD (Jyrki Niemi): Rule was split by the number of context
	   words and slightly generalized to convert correctly.
	   They could be recombined in Pmatch.
	   ([Ss]att" "{NUM}|avtjnat" "{NUM}|"dmd till "[0-9]+|"dmts till "[0-9]+|"tagit flera"|"av drygt "[^\n\t ]+|tar" "[0-9\-]+)" "(mnader|veckor|dagar|r)	{printTME(yytext,1);}
	 */
([Ss]att|avtjnat|tagit|tar)" "({NUM}|flera|[0-9\-]+)" "(mnader|veckor|dagar|r)	{printTME(yytext,1);}
(dm(d|ts)" till"|"av drygt")" "({NUM}|[0-9]+)" "(mnader|veckor|dagar|r)	{printTME(yytext,2);}
([Ff]r" "|[Ff]rn" "|[Tt]ill" ")?([Ss]ommaren|[Tt]axeringsret|[Vv]intern|[Hh]sten|[Vv]ren)" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
([Uu]"ngefr "|[Ss]"edan ")?([Ii]" mnga mnga"|[Ii]" s mnga"|[Ss]" mnga"|[Nn]"gra f"|"rtt mnga"|[Gg]"anska mnga"|[Tt]usen|[Ee]"tt antal"|[Ss]" lite som "[^\n\t ]+|[Uu]"nder sina "[^\n\t ]+" verksamma"|[Mm]"ellan "[^\n\t ]+" och ett halvt"|"med tidigare"|[Ff]"r frsta gngen p "[^\n\t ]+|[Tt]"idigare"|[Ss]amma|[Mm]nga|[Vv]artannat|[Hh]alvtannat|[Mm]"nga framgngsrika"|[Ee]"tt halvt"|[Ii]" "[^\n\t ]+" och ett halvt")" r"(" tidigare"|" sedan"|" tillbaka"|"s mellanrum")?	{printTME(yytext,0);}
([Uu]"ngefr "|[SsRr]"edan ")?("ett sekel tillbaka"|"per r"|"per sekel"|"senate ren"|[]rets" "[^\n\t ]+" "halvr|[Ee]fter" nyr"|[Ee]fter" nyret"|[Ee]tt" halvr"|fre" den gngna julen"|[Ff]rsommaren|[Ff]ramt" midsommar"|[Gg]enom" "ren|[Hh]sten\-[0-9][0-9]|[Kk]ring" midsommar"|[Mm]ed" ren"|[Mm]ed" drygt "[^\n\t ]+" rs "mellanrum|[Pp]" "de[nt]" "[a-z]+" "millenniet|[Pp]" "halfr|[Ss]" hr rs"|[Ss]amma" r \, "[12][0-9][0-9][0-9]|[Ss]enaste" "[^\n\t ]+" ren"|[Ss]enaste" re"[tn]|[Ss]enaste" ren"|[Ss]ista" ret"|[Uu]nder" "krigsren|[Uu]nder" re"[nt]s" lopp"|[Uu]nder" de ren"|[Uu]nder" fjolret"|[Uu]nder" julen"|[Uu]nder" sommaruppehllet"|[Uu]nder" vinterhalvret"|[Tt]idigare" i_r"|[Vv]id" rets slut"|[Vv]id" midsommar"|I" vr tid")(" tidigare"|" sedan")?	{printTME(yytext,0);}
"som under "[^\n\t ]+" r"	{printTME(yytext,1);}
[]r(en)?" "[12][0-9][0-9][0-9](" "[12][0-9][0-9][0-9]" \,")*" "(till|och)" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[]ren" "[12][0-9][0-9][0-9]\-[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[]ren" "[12][0-9][0-9][0-9]\-[0-9][0-9]	{printTME(yytext,0);}
[]"tmistone "[0-9]+" "[0-9]+" r"	{printTME(yytext,0);}
([Ff]rn" och "med|[Tt]ill" och "med|[Ff]r\.o\.m\.|[Tt]\.o\.m\.)" "([1-9][0-9]?\/[1-9][0-9]?[0-9]?[0-9]?|[1-9][0-9][0-9][0-9])	{printTME(yytext,0);}
([Uu]nder|[Ii]" den "[^\n\t ]+|[Ii]" slutet av "den|[Ii]" slutet av")" "[a-z]*perioden	{printTME(yytext,0);}
[]ret" "(r|var)" "[12][0-9][0-9][0-9]	{printTME(yytext,2);}
[Kk]ulmen" "kom" "[12][0-9][0-9][0-9]	{printTME(yytext,2);}
blev" kung "[12][0-9][0-9][0-9]	{printTME(yytext,2);}
[Ii]" nnu "[^\n\t ]+" sekler"	{printTME(yytext,0);}
"p "[0-9]+" "[0-9]+" r"	{printTME(yytext,0);}
[Uu]nder" "[a-z]+s" frsta "r	{printTME(yytext,0);}
([Mm]ot" slutet"|[Ii]" brjan"|[Uu]"nder senare delen")" av "("frra ")?[^\n\t ]*seklet	{printTME(yytext,0);}
[Ff]"rra "[^\n\t ]*seklet	{printTME(yytext,0);}
[Dd]"e "[^\n\t ]+" fregende rens lnga perioder"	{printTME(yytext,0);}
([Ff]rn|fr\.o\.m\.)" "[0-9]+" och framt"	{printTME(yytext,0);}
(till|[Vv]id)" "("mer n ")?(dessa|ett|detta)" "("par "|"flera ")?(tidigare" "|upprepade" "|senare" "|stora" ")?tillflle(n|t)?	{printTME(yytext,0);}
(till|[Vv]id)" "(de" "flertaliga|samtliga" dessa"|[0-9]+|ngra|flera|ngt|vissa|ngot|varje|"mer n ett"|"de sllsynta"|tv|tre|"minst tv"|detta)" "(tidigare" "|senare" ")?tillflle(n)?(" "tidigare)?	{printTME(yytext,0);}
till" "(andra|nsta)" "tillflle(n)?	{printTME(yytext,0);}
[0-9]+\,[0-9]+" r"	{printTME(yytext,0);}
[Ss]edan" \-"[0-9][0-9]	{printTME(yytext,0);}
[^\n\t ]*[Kk]rigen" "[12][0-9][0-9][0-9]" och "[12][0-9][0-9][0-9]	{printTME(yytext,1);}
([Oo]pererad|lutade|fdd|ansionerad|slutat)" "\-[0-9][0-9](" "respektive" "\-[0-9][0-9])?	{printTME(yytext,1);}
([Oo]pererad|lutade|fdd|ansionerad|slutat|gjord|ppfljning)" "[1-9][0-9]?\/[0-9]	{printTME(yytext,1);}
([Mm]an|vinna)" fdd "[0-9][0-9][0-9]?[0-9]?	{printTME(yytext,2);}
(dog|fddes)" i "[A-Z][^\n ]+" "[12][0-9][0-9][0-9]	{printTME(yytext,3);}
"drogs in "[12][0-9][0-9][0-9]	{printTME(yytext,2);}
"i efterhand "[12][0-9][0-9][0-9][0-9][0-9]	{printTME(yytext,2);}
([Uu]nder" ")?[]ren" "[12][0-9][0-9][0-9]" \, "[12][0-9][0-9][0-9]" och "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[Uu]"nder ren"(" "[12][0-9][0-9][0-9][0-9][0-9])?	{printTME(yytext,0);}
[0-9][0-9]?\.[0-9][0-9]?" r"	{printTME(yytext,0);}
([0-9]+" ")?[0-9]+" personr"	{printTME(yytext,0);}
[0-9]+"\-rsperiod"(en)?	{printTME(yytext,0);}
[Jj](mfrt|mf|mfrt)" med "[12][0-9][0-9][0-9]"\-"[12][0-9][0-9][0-9]	{printTME(yytext,2);}
[Jj](mfrt|mf|mfrt)" med "([0-9][0-9][0-9][0-9][0-9][0-9]|\-[0-9][0-9][0-9][0-9][0-9][0-9]|\-[0-9][0-9]|[0-9][0-9]*\/[0-9][0-9]*|[0-9][0-9]*\/[0-9][0-9]*\-[0-9][0-9]|[0-9][0-9]\-[0-9][0-9]\-[0-9][0-9]|[0-9][0-9]*\/[0-9][0-9]*" \-"[0-9][0-9])	{printTME(yytext,2);}
[]rgng" \-"[0-9][0-9]	{printTME(yytext,0);}
[^\n\t ]*[]rgng" \( "[0-9][0-9][0-9][0-9]\-[0-9][0-9][0-9][0-9]" \)"	{printTME(yytext,0);}
[0-9]+" patientr"	{printTME(yytext,0);}
": "[12][0-9]"\-"[0-9]"\-"[0-9]" "[0-9][0-9]":"[0-9][0-9]	{printTME(yytext,1);}
"r snd "0[12][012][0-9][0123][0-9]	{printTME(yytext,2);}
p" nytt "[12][0-9]\-[12][0-9]\/[1-9][0-9]?	{printTME(yytext,2);}
[Ss]edan" "[0-9]\-[0-9]	{printTME(yytext,0);}
[1-9][0-9]?\/[1-9][0-9]?" "[Tt]" o m "[123][0-9]\/[1-9][0-9]?	{printTME(yytext,0);}
[Tt]" o m "[123][0-9]\/[1-9][0-9]?	{printTME(yytext,0);}
Sen" \-"[0-9][0-9]	{printTME(yytext,0);}
Vren" "[0-9][0-9]	{printTME(yytext,0);}
(VT|HT)" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
Mellan" "[12][0-9][0-9][0-9]\-[12][0-9][0-9][0-9]	{printTME(yytext,0);}
(Tor|Fre|Mn|Tis|Ons|Lr|Sn)\.?" "[0-9][0-9]" "(Jan|Feb|Mars|Apr|Maj|Jun|Jul|Aug|Sep|Okt|Nov|Dec)\.?" \, "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[Aa]nkomst" senast "[0-9][0-9]\.[0-9][0-9]	{printTME(yytext,1);}
[^\n ]+mnadersperioden	{printTME(yytext,0);}
r" "[12](" ")?[0-9][0-9][0-9]	{printTME(yytext,0);}
	/* MOD (Jyrki Niemi): Removed unquoted [ from character class */
([Ff]r" "|[Uu]nder" ")?([Uu]ngefr" "|ca" "|[Cc]irka" ")?[0-9]+([\,0-9]+)?" miljarder r sedan"	{printTME(yytext,0);}
[Ff]r" "[0-9]+" r sedan"	{printTME(yytext,0);}
	/* SSONG */
([Ii]nfr|[Uu]nder)" ssongen "[^\n\t ]+" till brjan av "[^\n\t ]+	{printTME(yytext,0);}
[Uu]nder" "{NUM}" "([a-z]+" ")?ssonger(na)?	{printTME(yytext,0);}
([Ii]nfr|[Uu]nder|[Dd]en" hr"|[Uu]"nder hela"|[Hh]ela|[Ff]r)" "[a-z]*ssongen(" "\-[0-9]+|" "[0-9]+\/[0-9]+)?	{printTME(yytext,0);}
[Ss]songerna" "[0-9]+\-[0-9]+(" och "[0-9]+\-[0-9]+)?	{printTME(yytext,0);}
[Ss]song" \-"[0-9][0-9]	{printTME(yytext,0);}
[0-9]+" r "(tidigare|senare)	{printTME(yytext,0);}
	/* TID */
([^\n\t ]*[Tt]iden|[Mm]ellan)" "[12][0-9][0-9][0-9]" till "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
("bara ")?([Uu]"nder ")?(Under" "|[Ss]edan" en "|en" "|[Ee]fter" en "|[Vv]id" "|[Mm]ot" "|[Dd]enna" "|[Ii]"nom "|[Ff]r" ")?(motsvarande|viss|kort|kortare|"ett mycket kort"|relativt|"ngon lngre"|lngre|frhistorisk|lng|[Ss]amma|denna)" "(kort" ")?(tidssperspektiv|tidsperiod|period|tid|"tid framt"|"tid framver")(" frra ret"|" i fjol"|" ifjol"|" fregende r")?	{printTME(yytext,0);}
([0-9]+\-rs|"ver en"|[Uu]"nder denna"|[Dd]enna)" "[^\n\t ]*period	{printTME(yytext,0);}
([Rr]edan" ")?([Pp]|[Uu]nder|[Mm]ot" slutet av")" "([a-z]+" "tid|[a-z]*tiden|"en "[^\n\t ]+" tid")	{printTME(yytext,0);}
([Ff]ram" till"|[Rr]edan" under")" "[^\n ]+tiden	{printTME(yytext,0);}
([Mm]ycket" "|[Nn]"got ")?"lngre "tid(en|er)?	{printTME(yytext,0);}
[Uu]nder" hela sin "[^\n\t ]+" tid"	{printTME(yytext,0);}
(tillbringa|gnas)" "(mer|mycket)" tid"	{printTME(yytext,1);}
"kommer sllan"	{printTME(yytext,1);}
(stanna|vnta|vistats|lever|anvn|levde|varar|suttit)[a-z]*" "(lnge|lngre)	{printTME(yytext,1);}
"r det dags"	{printTME(yytext,2);}
"togs den "[123][0-9]\/[0-9][0-9](\-[089][0-9])?	{printTME(yytext,2);}
pgr" nnu"	{printTME(yytext,1);}
(blev|betala)" "tidigt	{printTME(yytext,1);}
[Aa]rbetar" "halvtid	{printTME(yytext,1);}
([]r|som|[Oo]ch)" "numera	{printTME(yytext,1);}
" numera vet "	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">numera</TIMEX> vet ");}
" i tid "	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">i tid</TIMEX> ");}
skedde" tidigare"	{printTME(yytext,1);}
tidigare" "(har|bertta|tro|sagt|arbeta|redog|godk)	{int i=0; printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">");	for(;yytext[i]!=' ';putchar(yytext[i++]));	printf("</TIMEX>"); for(;i<yyleng; putchar(yytext[i++])); }
([Uu]nder" "|[Ii]"nom ")?([Dd]en" ")?([Nn]rmaste|[Ss]enaste)" tiden"	{printTME(yytext,0);}
([Uu]nder" ")[Ll]ngre" tid n "[^\n ]+" "(r|mnader|veckor|dagar)	{printTME(yytext,0);}
[Uu]nder" "(denna|den|hela)" "[a-z]+tid(en)?	{printTME(yytext,0);}
([Hh]ela|[Ff]rr" i"|[Nn]"u fr"|[Pp]" "den|[Pp]" "senaste|[Uu]nder|[Ee]"fter halva "den|[Vv]id" "den|[Uu]nder" "hela|den|[Dd]"en sista"|"en gng i"|[Ss]ista)" "tiden(" "[12][0-9][0-9][0-9]\-[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
([Ii]nfr|[Ii]|[Ii]nom|[Aa]v|[Ff]r" all")" "("den nrmaste "|"en nra "|"en snar ")?framtid(en)?	{printTME(yytext,0);}
[Ff]"rn "[^\n\t ]+"sk tid och "senare	{printTME(yytext,0);}
([Ii]" god"|[Ee]fter" "[^\n\t ]+|[Aa]"llt mer"|[Mm]"ycket kort")" "tid	{printTME(yytext,0);}
[Ee]fter" "[^\n\<\t ]+" dagars vrdtid"	{printTME(yytext,0);}
" med tiden \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">med tiden</TIMEX> .");}
" en tid "	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">en tid</TIMEX> ");}
"om tidigare \."	{printf("om <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX> .");}
"som tidigare inte"	{printf("som <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX> inte");}
"som tidigare visat"	{printf("som <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX> visat");}
"det en gng var "	{printf("det <TIMEX TYPE=\"TME\" SBT=\"DAT\">en gng</TIMEX> var ");}
"skrivits tidigare i "	{printf("skrivits <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX> i ");}
"som tidigare var"	{printf("som <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX> var");}
" var en gng de"	{printf(" var <TIMEX TYPE=\"TME\" SBT=\"DAT\">en gng</TIMEX> de");}
"inom ret \,"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">inom ret</TIMEX> ,");}
[Vv]id" "[a-z]+" tidpunkt"(en|er)?	{printTME(yytext,0);}
[Vv]id" "[a-z]+" samma "tidpunkt(en|er)?	{printTME(yytext,0);}
[Vv]id" en "[a-z]+" tidpunkt"(en|er)?	{printTME(yytext,0);}
[Vv]id" "tidpunkt(en|er)?	{printTME(yytext,0);}
[Ee]n" "(timma|kvart)" "[^\n\t ]+" "stngningstid	{printTME(yytext,0);}
[Hh]alvtiden	{printTME(yytext,0);}
(frn" dessa "[a-z]+a|[Ii]" "sednare|[Ii]" "gamla|[Ii]" "alla|[Uu]nder" lnga"|[Ii]" ngot ldre")" tider"	{printTME(yytext,0);}
(med" "|[Ff]rn" ")?[]ret" "dessfrinnan	{printTME(yytext,0);}
[Dd]e" "{NUM}" ren nrmast dessfrinnan"	{printTME(yytext,0);}
[Tt]illbaka" till "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
"man redan har"	{printf("man <TIMEX TYPE=\"TME\" SBT=\"DAT\">redan</TIMEX> har");}
"Ju frr man"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">Ju frr</TIMEX> man");}
([Uu]nder|[Ii]nfr)" "[^\n\t ]+terminen(" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
[^\n\t ]+[Tt][Ee][Rr][Mm][Ii][Nn][Ee][Nn]" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[Ss]" "(sent|tidigt|snart|lnge)" som "(mjligt|[12][0-9][0-9][0-9])	{printTME(yytext,0);}
behv(er|t|de)" tid"	{printTME(yytext,1);}
frndras" ver tid"	{printTME(yytext,1);}
([Ii]nom" "en|[Ee]n" "lngre)" "[^\n\t ]*period	{printTME(yytext,0);}
[Uu]nder" "(kortare|lngre)" "[^\n\t ]*(tider|period|perioder)	{printTME(yytext,0);}
[Ii]" olika "[^\n\t ]*(tider|perioder)	{printTME(yytext,0);}
[Ii]" "(lngre|kortare)" "[^\n\t ]*perioder	{printTME(yytext,0);}
[Uu]"nder "[^\n\t ]*(tider|perioder)(na)?	{printTME(yytext,0);}
[Pp]" kort "[a-z]+" lng sikt"	{printTME(yytext,0);}
[]r" op \-"[0-9][0-9]	{printTME(yytext,2);}
[Ff]ick" barn \-"[0-9][0-9]	{printTME(yytext,2);}
(ensionerad|infarkt|kstopp|ektomerad|troke|rka|bldning|PTCA|diagn)" "[0-9][0-9][0-9][0-9]	{/*AT*/printTME(yytext,1);}
(ensionerad|infarkt|kstopp|ektomerad|troke|rka|bldning|PTCA|diagn|utredd|pass\-op|lymfom|[Pp]ulm|hjrna)" \-"[0-9][0-9]	{/*AT*/printTME(yytext,1);}
	/* MOD (Jyrki Niemi): Rule was split by the number of context words.
	   They could be recombined in Pmatch.
	   (ensionerad|infarkt|kstopp|ektomerad|troke|konferens|kontroll|rka|bldning|efterbeh|PTCA|diagn|pass\-op|insatt|lymfom|[Pp]ulm|hjrna|axel|rtg|"ordnas till")" "[1-9][0-9]?\/[1-9][0-9]?(" \-"[0-9][0-9])?	{printTME(yytext,1);}
	 */
(ensionerad|infarkt|kstopp|ektomerad|troke|konferens|kontroll|rka|bldning|efterbeh|PTCA|diagn|pass\-op|insatt|lymfom|[Pp]ulm|hjrna|axel|rtg)" "[1-9][0-9]?\/[1-9][0-9]?(" \-"[0-9][0-9])?	{/*AT*/printTME(yytext,1);}
"ordnas till "[1-9][0-9]?\/[1-9][0-9]?(" \-"[0-9][0-9])?	{/*AT*/printTME(yytext,2);}
(underskning|ambulans)" "([0-9][0-9][0-9][0-9][0-9][0-9]|[0-9][0-9]\/[0-9][0-9]|[0-9][0-9]\/[0-9][0-9]" respektive "[0-9][0-9]\/[0-9][0-9])	{/*AT*/printTME(yytext,1);}
"ett tungt r "[0-9][0-9]	{printTME(yytext,0);}
"fr "[0-9][0-9]"\-r\@sedan"	{printTME(yytext,0);}
"sedan "[1-9]\.[1-9]\.?	{printTME(yytext,0);}
"sedan \-"([1-9]\.[1-9]|[1-9][0-9][0-9][0-9][0-9]?[0-9]?)	{printTME(yytext,0);}
S[Ee][Dd][Aa][Nn]" "[1-9][0-9][0-9][0-9](\-[0-9]+|[0-9][0-9])?	{printTME(yytext,0);}
"men under \-"[0-9][0-9]	{printTME(yytext,1);}
(sen|under|frn|fram" till"|fre)" \-"[0-9][0-9]	{printTME(yytext,0);}
[Dd]en" "[1-9][0-9]?\/[1-9][0-9]?\-[0-9][0-9]([0-9][0-9])?	{printTME(yytext,1);}
"Allt sedan "[0-9][0-9][0-9][0-9]" eller "[0-9][0-9][0-9][0-9]	{printTME(yytext,0);}
(som|men|och|att|det|kan)" p sikt "	{ putchar(yytext[0]); putchar(yytext[1]); putchar(yytext[2]);	 printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">p sikt</TIMEX> ");}
([Ss]edan|[Uu]nder|[Kk]ortare" eller"|[Ss]edan" en"|[Ee]fter" en"|[]"ver en"|[]nnu)" lngre tid"(" ifjol"|" i fjol"|" i r"|" ret fre"|" "[12][0-9]+)?	{printTME(yytext,0);}
([Gg]anska|[Ss]edan|[Uu]nder|alldeles" fr"|[Kk]ort" eller")(" "[^\n\t ]+)?" lng tid"(" tillbaka"|" ifjol"|" i fjol"|" i r"|" ret fre"|" "[12][0-9]+)?	{printTME(yytext,0);}
[Uu]nder" "[^\n\t ]+" kort tid"(" som mjligt")?	{printTME(yytext,0);}
[Ff]"ram till "[7890][0-9][0-9][0-9][0-9][0-9]	{printTME(yytext,0);}
[Ee]fter" "[12][0-9]" tiden"	{printTME(yytext,0);}
("inte fr"|[Tt]illrckligt|[]n" p"|[Ss]edan)" lnge"	{printTME(yytext,0);}
([Rr]edan" ")?([Kk]vllstid|[Ff]"r nrvarande"|[Nn]uet|[Nn]"stan alltid"|"lngt senare"|"lngre sikt"|"i vr tid"|"ngonsin tidigare"|[Ss]" smningom"|"nu s smningom"|[Tt]"iotalet r"|"nu n tidigare"|"ver helgen"|[Ii]" akutskedet"|[Mm]idsommarafton|[Pp]" "sikt|[Ll]"ite senare"|[Ii]" nulget"|[Pp]" sistone"|[Pp]" den gamla goda tiden"|"under "antiken|[Hh]"elt nyligen"|"lng latenstid"|[Ee]"fter helgen"|"lng tid"|"betydligt tidigare"|[Ii]"nom kort"|[Ll]"ngt senare"|"snart dags"|[Ff]r" ett bra tag "sedan|gonblickligt|[Ff]"r ett tag sedan"|[Vv]"id den nya tidens slut"|"frn min tid"|RET|[Aa]"ldrig tidigare"|[Dd]"enna gng"|[Nn]"gon gng"|[Mm]esta" tiden"|[Ss]"edan tidigare"|[Ff]ramt" "dagen|[Jj]"ust d"|"lngt tidigare"|[Ss]edan" "dess|[Ss]en" "dess|helst" "nu|frrn" nu"|[Ss]"trax innan"|"Allt sedan"|[Ii]" frtid"|"Med tiden"|[Ff]ramdeles|[Ll]itet" "drefter|[Ii]" dagslget"|[Uu]nder" den nyligen frflutna tiden"|[Ii]nnan" dess"|[Nn]"sta helg"|"lngre perioder"|[12][0-9][0-9][0-9]\-talet|[Gg]anska" snart"|RHUNDRADET)	{printTME(yytext,0);}
Men" samtidigt"	{printTME(yytext,1);}
([Vv]inter|sommar|frsommar|[Jj]ule)tid(en)?	{printTME(yytext,0);} 
([Ii]fjol|[Dd]agtid|Sommartid|Vintertid|[Dd]essfrinnan|[Oo]medelbart|Strax|[Ss]tundtals|[Nn]yligen|Senare|Snart|Ibland|Sllan|Oftast|Nu|[Nn]attetid|Frr|Numera|[Nn]ufrtiden|Tidigare|[Ss]amtidigt|[Hh]ittills|[Ss]narast|Fortfarande|[]gonblickligen)	{printTME(yytext,0);}
[Hh]rom(sommaren|ret|dagen|veckan)	{printTME(yytext,0);}
[Ii]"nkom ter "[1-9][0-9]?\/[0-9][012]?	{printTME(yytext,1);}
"nmligen med tiden"	{printTME(yytext,1);}
" frr \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">frr</TIMEX> .");}
" strax \!"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">strax</TIMEX> !");}
" med frr \,"	{printf(" med <TIMEX TYPE=\"TME\" SBT=\"DAT\">frr</TIMEX> ,");}
" nnu \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">nnu</TIMEX> .");}
" fr sent \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">fr sent</TIMEX> .");}
" fr sent \,"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">fr sent</TIMEX> ,");}
" nu \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> .");}
" du nu "	{printf(" du <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
" har nu "	{printf(" har <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
"och nu "	{printf("och <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
"kommer nu "	{printf("kommer <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
"redan tidigare haft"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">redan tidigare</TIMEX> haft");}
" ses nu "	{printf(" ses <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
" men nu "	{printf(" men <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
" fr gott \,"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">fr gott</TIMEX> ,");}
" frrn d \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">frrn d</TIMEX> .");}
" som nu "	{printf(" som <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
" r nu \,"	{printf(" r <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ,");}
" gr nu "	{printf(" gr <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
" r nu i "	{printf(" r <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> i ");}
" ibland \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">ibland</TIMEX> .");}
" till natten \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">till natten</TIMEX> .");}
" nu lngre \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu lngre</TIMEX> .");}
"inte lngre kan"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">inte lngre</TIMEX> kan");}
"inte lngre r"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">inte lngre</TIMEX> r");}
"finns inte lngre"	{printf("finns <TIMEX TYPE=\"TME\" SBT=\"DAT\">inte lngre</TIMEX>");}
"D han var"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">D</TIMEX> han var");}
" nyss "	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">nyss</TIMEX> ");}
"gnger frr "	{printf("gnger <TIMEX TYPE=\"TME\" SBT=\"DAT\">frr</TIMEX> ");}
"drabbar oftare"	{printf("drabbar <TIMEX TYPE=\"TME\" SBT=\"DAT\">oftare</TIMEX>");}
" fortfarande r "	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">fortfarande</TIMEX> r ");}
" han fortfarande"	{printf(" han <TIMEX TYPE=\"TME\" SBT=\"DAT\">fortfarande</TIMEX>");}
"Mr fortfarande"	{printf("Mr <TIMEX TYPE=\"TME\" SBT=\"DAT\">fortfarande</TIMEX>");}
"hoppas fortfarande"	{printf("hoppas <TIMEX TYPE=\"TME\" SBT=\"DAT\">fortfarande</TIMEX>");}
"hittas tidigt"	{printf("hittas <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigt</TIMEX>");}
" nnu finns"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">nnu</TIMEX> finns");}
"r nnu tidigt"	{printf("r <TIMEX TYPE=\"TME\" SBT=\"DAT\">nnu tidigt</TIMEX>");}
"att tidigt \,"	{printf("att <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigt</TIMEX> ,");}
"de tidigt ska"	{printf("de <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigt</TIMEX> ska");}
" tidigt \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigt</TIMEX> .");}
" n ngonsin \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">n ngonsin</TIMEX> .");}
" n idag"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">n idag</TIMEX>");}
" n ifjol"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">n fjol</TIMEX>");}
" ngonsin \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">ngonsin</TIMEX> .");}
"som snart ska"	{printf("som <TIMEX TYPE=\"TME\" SBT=\"DAT\">snart</TIMEX> ska");}
" snart bli"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">snart</TIMEX> bli");}
"men snart"	{printf("men <TIMEX TYPE=\"TME\" SBT=\"DAT\">snart</TIMEX>");}
"drabbas oftare av"	{printf("drabbas <TIMEX TYPE=\"TME\" SBT=\"DAT\">oftare</TIMEX> av");}
" lika lnge "	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">lika lnge</TIMEX> ");}
"r nnu s lnge"	{printf("r <TIMEX TYPE=\"TME\" SBT=\"DAT\">nnu s lnge</TIMEX>");}
" s lnge och"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">s lnge</TIMEX> och");}
"ett r innan"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">ett r</TIMEX> innan");}
"r nu bttre"	{printf("r <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> bttre");}
"ngot tidigare n"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">ngot tidigare</TIMEX> n");}
"n tidigare \."	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">n tidigare</TIMEX> .");}
"ven tidigare i "	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">ven tidigare</TIMEX> i ");}
"har tidigare varit"	{printf("har <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX> varit");}
"inte alltid p"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">inte alltid</TIMEX> p");}
"inte alltid \."	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">inte alltid</TIMEX> .");}
" ver tid "	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">ver tid</TIMEX> ");}
" i tid \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">i tid</TIMEX> .");}
"Redan finns"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">Redan</TIMEX> finns");}
(Srskilt|Ganska)" "ofta	{printTME(yytext,0);}
"r tills dess"	{printf("r <TIMEX TYPE=\"TME\" SBT=\"DAT\">tills dess</TIMEX>");}
"Och nu "	{printf("Och <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
"Men nu "	{printf("Men <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ");}
"tt f n "	{printf("tt <TIMEX TYPE=\"TME\" SBT=\"DAT\">f n</TIMEX> ");}
"mycket som tidigare"	{printf("mycket som <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX>");}
"ta sig tid"	{printf("ta sig <TIMEX TYPE=\"TME\" SBT=\"DAT\">tid</TIMEX>");}
"som innan \."	{printf("som <TIMEX TYPE=\"TME\" SBT=\"DAT\">innan</TIMEX> .");}
"dr tidigare \."	{printf("dr <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX> .");}
"ngot senare kom"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">ngot senare</TIMEX> kom");}
"ngot senare nr"	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">ngot senare</TIMEX> nr");}
" senare \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">senare</TIMEX> .");}
"jag senare "	{printf("jag <TIMEX TYPE=\"TME\" SBT=\"DAT\">senare</TIMEX> ");}
"ganska lnge \."	{printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">ganska lnge</TIMEX> .");}
"sjuk lnge med"	{printf("sjuk <TIMEX TYPE=\"TME\" SBT=\"DAT\">lnge</TIMEX> med");}
"knt lnge \,"	{printf("knt <TIMEX TYPE=\"TME\" SBT=\"DAT\">lnge</TIMEX> ,");}
"drabbades tidigt \,"	{printf("drabbades <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigt</TIMEX> ,");}
"inte knt tidigare"	{printf("inte knt <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX>");}
"hemma fr lnge "	{printf("hemma <TIMEX TYPE=\"TME\" SBT=\"DAT\">fr lnge</TIMEX> ");}
" lnge \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">lnge</TIMEX> .");}
" n \."	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">n</TIMEX> .");}
" n \,"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">n</TIMEX> ,");}
" nu \,"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">nu</TIMEX> ,");}
"det fr sent \,"	{printf("det <TIMEX TYPE=\"TME\" SBT=\"DAT\">fr sent</TIMEX> ,");}
" lngre \!"	{printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">lngre</TIMEX> !");}
"g hem "[123]?[0-9]\/[1-9][0-9]?	{printTME(yytext,2);}
I" "[1-9]" v tid"	{printTME(yytext,0);}
[Ii]" brjan p v "[0-9]+	{printTME(yytext,0);}
[Mm]ellan" v "[0-9]+\-[0-9]	{printTME(yytext,0);}
"hittats tidigare"	{printf("hittats <TIMEX TYPE=\"TME\" SBT=\"DAT\">tidigare</TIMEX>");}
" den "[0-9][0-9]?\.[0-9][0-9]?	{int i=5; printf(" den <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); 	for(;i<yyleng; putchar(yytext[i++])); printf("</TIMEX>");}
" den "[0-9]\/[0-9]" "\-[0-9][0-9]	{int i=5; printf(" den <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); 	for(;i<yyleng; putchar(yytext[i++])); printf("</TIMEX>");}
[Pp]" "[0-9]+\/[0-9]+\/r	{printTME(yytext,0);}
[Dd]ate" \: "[12][0-9]+	{printTME(yytext,2);}
[A-Z]+DAGEN" DEN "[0-9][0-9]?	{printTME(yytext,0);}
([1-9][0-9]?\/[1-9][0-9]?|[12][0-9]\-[12][0-9]\/([1-9]|10|11|12))" "[12][0-9][0-9][0-9]	{/*21-22/11 2004*/ printTME(yytext,0);}
19[0-9][0-9]\/[8-9][0-9]	{printTME(yytext,0);}
19[0-9][0-9]\/19[0-9][0-9]	{printTME(yytext,0);}
[12][0-9][0-9][0-9]\-[0-9][0-9]\-[0-9][0-9]" "[012][0-9]\:[0-6][0-9]	{printTME(yytext,0);}
[12][0-9][0-9][0-9]\-[01][0-9]\-[0123][0-9]\-\-[12][0-9][0-9][0-9]\-[01][0-9]\-[0123][0-9]	{printTME(yytext,0);}
[12][0-9][0-9][0-9]\-[0-9][0-9]\-[0-9][0-9]	{printTME(yytext,0);}
1?[1-9]\.[1-9]\.[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[1-9][0-9]\.[1-9][0-9]" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[1-9][0-9]\-[01][0-9]\-[0-3][0-9]	{printTME(yytext,0);}
[123][0-9]\/([1-9]|10|11|12)" "\-[0-9][0-9]	{/*21/6 -04*/ printTME(yytext,0);}
	/* MISC */
([Ff]rn" ")?([Oo]mkring|[Kk]ring)" "[12][0-9][0-9][0-9]" r fre "Kristus	{printTME(yytext,0);}
([Ff]rn" ")?([Oo]mkring|[Kk]ring)" r "[0-9]+" fre Kristus"	{printTME(yytext,0);}
([Cc]irka" "|[Rr]edan" ")?([Nn]gra" hundra "r|[Pp]" "[^\n\t ]+\-talet|[0-9]+|[Mm]ellan" "[0-9]+" och "[0-9]+|[0-9]+\-[0-9]+)" "(efter|fre)" Kristus"	{printTME(yytext,0);}
([Cc]"irka "|[Rr]edan" "|[Pp]" ")?[^\n\t ]+\-talet" "(e|f)" Kr"\.?	{printTME(yytext,0);}
[Tt]ill" "[^\nA-Z ]+" "[^\n\t ]+" r "(efter|fre)" Kristi fdelse"	{printTME(yytext,0);}
[^\n\t ]*[Tt]usen" r "(efter|fre)" Kristi fdelse"	{printTME(yytext,0);}
[]"r "[0-9]+" "[ef]Kr	{printTME(yytext,0);}
[Ff]"ram till "[0-9]+" "[ef]Kr	{printTME(yytext,0);}
[Uu]ngefr" "[0-9]+" generationer bakt"	{printTME(yytext,0);}
[12][0-9][0-9][0-9]" \&amp\; "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[123][1-9]\/[1-9]" och "[123][1-9]\/[1-9]" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[123][1-9]\/[1-9]" "[12][0-9][0-9][0-9]	{printTME(yytext,0);}
[Ff]rn" "[123][1-9]\/[1-9]" och "[123][1-9]\/[1-9](" "[12][0-9][0-9][0-9])?	{printTME(yytext,0);}
([Ff]ram" "till" ")?([0-9]+\,)?[0-9]+" milj f\.Kr"\.?	{printTME(yytext,0);}
([Ff]ram" "till" ")?([0-9]+\,)?[0-9]+" f\.Kr"\.?	{printTME(yytext,0);}
[Ii]" den "[^\n ]+anska" "tiden	{printTME(yytext,0);}
[0-9]+\-talet" f \. Kr \."	{printTME(yytext,0);}
	/*i Xxxx 12NNN */
"i "[A-VXYZ][a-z]+" "[12][0-9][0-9][0-9]	{int i=2; printf("i "); for(;yytext[i]!=' ';putchar(yytext[i++]));	i++; printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); 	for(;i<yyleng; putchar(yytext[i++])); printf("</TIMEX>");}
	/*frn Xxxx 12NNN */
"frn "[A-VXYZ][a-z]+" "[12][0-9][0-9][0-9]	{int i=5; printf("frn "); for(;yytext[i]!=' ';putchar(yytext[i++]));	i++; printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); 	for(;i<yyleng; putchar(yytext[i++])); printf("</TIMEX>");}
"bott i "[A-Z][a-z]+" "[1-9]\-[1-9]" r"	{int i=7; printf("bott i "); for(;yytext[i]!=' ';putchar(yytext[i++]));	i++; printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); 	for(;i<yyleng; putchar(yytext[i++])); printf("</TIMEX>");}
	/**/

"poutses mble"	{printf("XXXXX");}
\n	{ECHO;}
.	{ECHO;}
%%
#ifdef YY_USE_PROTOS
int printTME (char *a, int x)
#else
     int printTME (a)
     char *a; int x;
#endif
{ int z=0;
int c=yyleng;
if (x==0) printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">%s</TIMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</TIMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</TIMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); z=z+1; 
	for(;z<yyleng; putchar(yytext[z++])); printf("</TIMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); z=z+1; 
	for(;z<yyleng; putchar(yytext[z++])); printf("</TIMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--; 
printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</TIMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==13){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
for(;yytext[z]!=' ';putchar(yytext[z++])); z++;
printf(" <TIMEX TYPE=\"TME\" SBT=\"DAT\">"); for(;z<c; putchar(yytext[z++]));
printf("</TIMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
else if (x==23){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">"); for(;z<c; putchar(yytext[z++]));
printf("</TIMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
else if (x==40){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">"); for(;z<c; putchar(yytext[z++]));
printf("</TIMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
main( argc, argv )
int argc;
char **argv;
{
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  yylex(); return(0);
}
