/*
	File: MsrPatB.ll
	"out-of-dictionary items"
	Author: Dimitrios Kokkinakis
	Version: 090102
	Finds: names of measures strings
*/
%{
%}
U	[\101-\132\300-\335\&]
NUM	Ett|En|[Tt]v|[Tt]re|[Ff]yra|[Ff]em|[Ss]ex|[Ss]ju|[^\n\t ]*[]tta|[Nn]io|[^\n\t ]+tio|[Tt]io|[Ee]lva|[Tt]olv|[Tt]retton|[Ff]jorton|[Ff]emton|[Ss]exton|[Ss]jutton|[Aa]rton|[Nn]itton|[Tt]jugo|[Tt]jugoen[Tt]jugotv|tjugofem
CITAT	\"|\|\'|\'\'|`|\|\
%{
	/* DEGREE */
  int printDGR (char *a, int x);
	/* VOLUME */
  int printVLM (char *a, int x);
	/* TEMP */
  int printTMP (char *a, int x);
	/* INDEX */
  int printINX (char *a, int x);
	/* DISTANCE */
  int printDST (char *a, int x);
	/* CURRENCY */
  int printCUR (char *a, int x);
	/* DENSITY DNS*/
  int printDEN (char *a, int x);
	/* PERCENT PRC*/
  int printPRC (char *a, int x);
	/* CMU - COMPUTER*/
  int printCMU (char *a, int x);
	/* WMU - WEIGHT&MASS*/
  int printWMU (char *a, int x);
	/* */
  int printXXX (char *a, int x);
	/* */
  int printTEL (char *a, int x);
	/* */
  int printLST (char *a, int x);
	/* AGE */
  int printAGE (char *a, int x);
	/* DOSAGE */
  int printDSG (char *a, int x);
	/* WEB */
  int printWEB (char *a, int x);
	/* Capacity&volume */
  int printCVU (char *a, int x);
	/* CooRDinates */
  int printCRD (char *a, int x);
	/* ELU ELECTRICL */
  int printELU (char *a, int x);
	/* SPD - SPEED */
  int printSPD (char *a, int x);
	/* PSS - PRESSURE */
  int printPSS (char *a, int x);
	/* FRQ - FEQUENCY */
  int printFRQ (char *a, int x);
	/* MSU - METRIC SURFACE UNIT */
  int printMSU (char *a, int x);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|MDC|TRM)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDC|MDA|MDD|MDO|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\=\"MSR\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
({NUM}|[0-9]+)" "[^\n ]*metaboliter	{ECHO;}
([0-9]+\-)?[0-9]+(\%)?" "(mer" "|mindre" "|extra" ")?(kilo)?kalorier	{printXXX(yytext,0);}
[0-9]+kcal\/[0-9]+" "gram	{printXXX(yytext,0);}
[0-9]+\-[0-9]+" kcal\/"[md]l	{printXXX(yytext,0);}
([0-9]+" "[0-9]+|[0-9]+|[0-9]+[\-\.\,][0-9]+|[0-9]+[\-\.\,][0-9]+.[0-9]+)" "(kalorier|kcal|kilokalorier)(\/dygn|\/dag|\/d)?	{printXXX(yytext,0);}
([0-9]+|[0-9]+[\-\.\,][0-9]+)" "(kilo|kalorier|kcal|kilokalorier)(\/dygn|\/dag|\/d)	{printXXX(yytext,0);}
([0-9]+|[0-9]+\.[0-9]+)" "(kilobequerel|[Bb]ecquerel|[Bb]ecquerell|Bq|MBq|MBq\/ml|Bq\/kg)(" per "[^\n\t ]*gram|" per "[^\n\t ]*meter|\/m3|\/ml)?	{printXXX(yytext,0);}
[0-9]+" "kilopond	{printXXX(yytext,0);}
[0-9]+" cal per kg"	{printXXX(yytext,0);}
	/* Computer Unit - CMU*/
([Dd]rygt" "|[Uu]pp" till ")?(en|tv|tre|fyra|fem|sex|sju|tta|nio|tio|[0-9]+|[0-9]+[0-9\-\,]+)" "([MmKk]bit|[Gg]igabit|[Mm]egabit|Mb|Kb|Mbyte|megabyte|kilobit|kilobyte|gigabyte)\/(s|sek|sekund)	{printCMU(yytext,0);}
([Dd]rygt" "|[Uu]pp" till ")?(en|tv|tre|fyra|fem|sex|sju|tta|nio|tio|[0-9]+|[0-9][0-9\-\,]+)" "([MK]bps|[Mm]bit|[Gg]igabit|[Mm]egabit|Kb|megabyte|kilobit|kilobyte|gigabyte)	{printCMU(yytext,0);}
([Dd]rygt" "|[Uu]pp" till ")?([0-9]+" ")?[0-9]+" "(kilobit|bits|Mbit|bitar|megabit|megabyte|kilobyte|gigabyte)" per sekund"	{printCMU(yytext,0);}
([Dd]rygt" "|[Uu]pp" till ")?{NUM}(\-{NUM})?" "(kilobit|Mbit|bitar|megabit|megabyte|kilobyte|gigabyte)" per sekund"	{printCMU(yytext,0);}
[0-9][0-9\-]+" "[MKk][Bb]" "	{int i=0;printf("<NUMEX TYPE=\"MSR\" SBT=\"CMU\">"); 	for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> "); }
(32|64|128)" bitar"	{printCMU(yytext,0);}
([0-9][0-9\-\,]+" "miljoner|[0-9]+x[0-9]+|[0-9]+" x "[0-9]+)" "(dpi|pixlar)	{printCMU(yytext,0);}
	/* SPEED */
([Oo]mkring" "|[Uu]ngefr" "|[Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]:a" "|[Cc]a" "|till" ")?([0-9\-]+" ")?("en halv"|[0-9\-]+)" "([Kk]m\/[sh]|m\/min|km\/tim|"meter per sekund"|"kilometer i timmen"|"meter i sekunden")	{printSPD(yytext,0);}
([Oo]mkring" "|[Uu]ngefr" "|[Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]:a" "|[Cc]a" "|till" ")?[0-9]+(\,[0-9]+)?" knop"(s" fart")?	{printSPD(yytext,0);}
([Dd]rygt" "|kring" "|ca" "|[Uu]ngefr" "|upp" till ")?([0-9]+|[0-9]+[\.\-\,0-9]*[0-9]+|tio)" "m\/s	{printSPD(yytext,0);}
([Oo]mkring" "|[Uu]ngefr" "|[Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]:a" "|[Cc]a" ")?[0-9]+(" till "[0-9]+|" eller "[0-9]+|[\-\,][0-9]+)?" "(m\/min|miles|[Kk]m|kilometre|meter)(\/time|" i timmen"|" i sekunden")	{printSPD(yytext,0);}
([Oo]mkring" "|[Uu]ngefr" "|[Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]:a" "|[Cc]a" ")?[0-9]+([\-\,][0-9]+)?" "varv(\/minut|\/min|\/time|i" "minuten)	{printSPD(yytext,0);}
[0-9]+(\-[0-9]+)?" "Km\/([sh]|tim|time|timmen|sekunden)	{printSPD(yytext,0);}
[Hh]astighet" "(p|av)" "("cirka "|"minst ")?([0-9]+[\,\- ][0-9]+|[0-9]+)(" kilometer i "timmen|" per "sekund|" meter i "sekunden|" ml\/kg"|" ml\/min")?	{printSPD(yytext,2);}
[0-9]+" "mm\/h	{printSPD(yytext,0);}
	/* PRESSURE - PSS */
\+[0-9]+[0-9]+" mm"(" Hg"|Hg)	{printPSS(yytext,0);}
[Mm]ellan" "[0-9]+" och "[0-9]+" mm "[Hh][Gg]	{printPSS(yytext,0);}
([0-9]+" ")?upp" "(mot|till)" "[0-9]+" mm"(" H"[Gg]|H[Gg])	{printPSS(yytext,0);}
[0-9]+" "till" "[0-9]+" mm "H[Gg]	{printPSS(yytext,0);}
frn" "[0-9]+" till "[0-9]+" mm "H[Gg]	{printPSS(yytext,1);}
[0-9]+" mm "H[Gg]	{printPSS(yytext,0);}
([Cc]irka" "|[]ver" "|[Uu]nder" "|"\< ")?([0-9]\,[0-9]\/|[0-9]+\,[0-9]+)?[0-9][0-9\/\-]*" "(mm" H"[Gg]|mmHg|hektopascal|millibar)	{printPSS(yytext,0);}
[^\n\t ]*tryck" "(kring|p|r)" "("hgst "|"omkring ")?[0-9]+[0-9\/\-]*(" mmHg"|" mm "[Hh][Gg]|" mm "[Gg]|mmHg)?	{printPSS(yytext,2);}
[^\n\t ]*"trycket "("under ")?[0-9]+\/[0-9]+(" mm "[Gg]|mmHg|" mm Hg"|" mmHg")?	{printPSS(yytext,1);}
[^\n\t ]*"trycket r "[0-9]+\/[0-9]+(" mm "[Gg]|mmHg|" mm Hg"|" mmHg")?	{printPSS(yytext,2);}
	/* MOD (Jyrki Niemi): Rule was split because of different left
	   contexts. Should the context be 2 or 3 words, preposition included
	   or exluded from the named entity?
	[^\n\t ]*trycket" "(kad" "frn|"kade med")" "[0-9]+\/[0-9]+(" till "[0-9]+\/[0-9]+|[0-9]+\,[0-9]+)?(" mm "[Gg]|mmHg|" mm Hg")?	{printPSS(yytext,2);}
	*/
[^\n\t ]*trycket" kad frn "[0-9]+\/[0-9]+(" till "[0-9]+\/[0-9]+|[0-9]+\,[0-9]+)?(" mm "[Gg]|mmHg|" mm Hg")?	{printPSS(yytext,2);}
[^\n\t ]*trycket" kade med "[0-9]+\/[0-9]+(" till "[0-9]+\/[0-9]+|[0-9]+\,[0-9]+)?(" mm "[Gg]|mmHg|" mm Hg")?	{printPSS(yytext,2);}
[^\n\t ]*tryck" mellan "[0-9]+" och "[0-9]+	{printPSS(yytext,2);}
([0-9\-]+" "[0-9\-]+|[1-9]+" \, "[0-9]+|[0-9]+|[1-9]+\,[0-9]+|[0-9]+[0-9]+)" mg H"[Gg]	{printPSS(yytext,0);}
[0-9]+[\,\/][0-9]+(" mm "[Gg]|" mm "[Hh]g|mmHg)	{printPSS(yytext,0);}
"En millibar"	{printPSS(yytext,0);}
[Bb]lodtryck" "(r|ligger|ligg)" : "[0-9]+\/[0-9]+(" mm "[Gg]|" mm "[Hh]g|mmHg)?	{printPSS(yytext,3);}
[Bb]lodtryck" ( > "[0-9]+\/[0-9]+(" mm "[Gg]|" mm "[Hh]g|mmHg)?	{printPSS(yytext,3);}
[Bb]lodtryck" "(r|ligger|ligg)" "[0-9]+\/[0-9]+(" mm "[Gg]|" mm "[Hh]g|mmHg)?	{printPSS(yytext,2);}
[Bb]lodtryck" som "(r|ligger|ligg)" "[0-9]+\/[0-9]+(" mm "[Gg]|" mm "[Hh]g|mmHg)?	{printPSS(yytext,3);}
	/* particularly in med texts */
[Bb]lodtrycket" ligger p "[0-9]+\/[0-9]+	{printPSS(yytext,3);}
([Bb]lodtryck|tryck|[Bb]ltr|BT)" "(liggande|stende)" "[0-9]+\/[0-9]+	{printPSS(yytext,2);}
([Bb]lodtryck|tryck|[Bb]ltr|[Bb][Tt])" "[0-9]+\/[0-9]+(" mm "[Gg]|" mm "[Hh]g|" "mmHg|mmHg)?	{printPSS(yytext,1);}
([Bb]lodtryck|tryck|[Bb]ltr|BT)" "[:\,]" "[0-9]+\/[0-9]+(" mm "[Gg]|" mm "[Hh]g|" "mmHg|mmHg)?	{printPSS(yytext,2);}
\=[0-9]+" mm Hg"	{printPSS(yytext,0);}
	/* MOD (Jyrki Niemi): Rule was split into two by the number of
	   words in the context:
	(B[Ll]"\. tr "|B[Ll]"\.tr ")[0-9]+\/[0-9]+	{printPSS(yytext,2);}
	*/
B[Ll]"\. tr "[0-9]+\/[0-9]+	{printPSS(yytext,2);}
B[Ll]"\.tr "[0-9]+\/[0-9]+	{printPSS(yytext,1);}
(cirka" "|ca" ")?([0-9]+" \- "[0-9]+|[0-9]+|[0-9]+\-[0-9]+|[0-9]+\,[0-9]+)" slag"(\/min|\/minut|" i minuten"|" per minut")	{printXXX(yytext,0);}
([Vv]id|[Uu]nder|[]ver)" "([0-9]+|[0-9]+" "[0-9]+)" "(varv|slag)\/minut	{printXXX(yytext,1);}
"BT "[\>\<]" "[0-9]+\/[0-9]+	{int i=5; printf("BT "); putchar(yytext[3]); 	printf(" <NUMEX TYPE=\"MSR\" SBT=\"PSS\">"); for(;i<yyleng;putchar(yytext[i++])); printf("</NUMEX>"); }
"BT "(ver|under|knappt|\:)" "[0-9]+(\/[0-9]+)?	{printPSS(yytext,2);}
([Ll]igg|[Ss]t)" "(ver|under|knappt|\:)" "[0-9]+\/[0-9]+	{printPSS(yytext,2);}
"BT "[0-9]+\/[0-9]+	{printPSS(yytext,1);}
[Bb]lodtrycket" "[\>\<]" "[0-9]+\/[0-9]+	{printPSS(yytext,2);}
[0-9]+mmHg	{printPSS(yytext,0);}
([Bb]lodtryck|tryck|[Bb]ltr|BT|bt)"\-fall ner till "[0-9]+(\/[0-9]+)?	{printPSS(yytext,3);}
[Bb]lodtrycksstegring" till "[a-z]+" "[0-9]+(\/[0-9]+)?	{printPSS(yytext,3);}
[Hh][Bb]" "(strax" under "|strax" ver ")?[1-9][0-9][0-9]?(" "g\/[Ll])?	{printXXX(yytext,1);}
[Hh][Bb]" "[1-9][0-9]\-[0-9]+(" "g\/[Ll])?	{printXXX(yytext,1);}
[Hh][Bb]" < "[1-9][0-9]+(" "g\/[Ll])?	{printXXX(yytext,2);}
[Hh][Bb]" p "(strax" under "|strax" ver ")?[1-9][0-9][0-9]?(" "g\/[Ll])?	{printXXX(yytext,2);}
	/* Electrical Unit - ELU*/
([Mm]er" n "|[Cc]irka" "|[Mm]inst" ")?([0-9\-]+" ")?([0-9]+|[0-9]+" "[0-9]+\/[0-9]+|[0-9]+\/[0-9]+|[0-9]+\.[0-9]+|[0-9]+\,[0-9]+|[0-9]+\-[0-9]+|[0-9]+" "[0-9]+)" "(miljon" "|miljoner" ")?(TWh|[^\n\t ]*watt|[^\n\t ]*wattimme|[^\n\t ]*wattimmar)(\/min)?	{printELU(yytext,0);}
([Mm]er" n "|[Cc]irka" "|[Mm]inst" ")?([Nn]"gra f"|[Ee]n" "kvarts|[Ee]tt" "halvt|[Ee]tt" "halv|[Dd]"rygt en"|[Tt]v|[Tt]re|[Ff]yra|[Ff]em|[Ss]ex|sju|tta|nio|tio|tolv|[0-9]+\-tals)" "(miljon" "|miljoner" ")?(TWh|[^\n\t ]*watt[^\n\t ]*wattimme|[^\n\t ]*wattimmar)(\/min)?	{printELU(yytext,0);}
(60|80|220|240)" W"	{printELU(yytext,0);}
([0-9]+" "|[0-9]+[\,\.])?[0-9][0-9\-]*" "(kilo|m)?volt" "	{int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"ELU\">"); 	for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> "); }
([0-9\-]+" ")?(tio|fem|tjugo|[0-9][0-9\-\,]*)" "(milli)?amp[e]re	{printELU(yytext,0);}
[0-9]+" "kW\/[0-9]+" "hk	{printELU(yytext,0);}
([0-9]+|[0-9]+\,[0-9]+|[0-9]+" "[0-9]+)" lux"	{printELU(yytext,0);}
([Mm]inst" "|[Mm]indre" n ")?[0-9]+" "[Jj]oule(" per "[^\n\t ]*meter)?	{printELU(yytext,0);}
[Uu]pptill" "[0-9]+\-[0-9]+" "mA	{printELU(yytext,0);}
[0-9]+" "(kilo[Vv]olt|kV|kV:s|mA)	{printELU(yytext,0);}
([Cc]yklar|till)" "[0-9]+" "W	{printELU(yytext,1);}
till" "[0-9]+W	{printELU(yytext,1);}
	/* FREQUENCY */
[Vv]ar" "[1-9][0-9\-]*(e|\:e|\:de)" "([^\n ]*dag|sekund|minut|timme|timma|dag|vecka|veckan|mnad|r)	{printFRQ(yytext,0);}
[Vv]ar" "[0-9]\-[0-9]" "(minut|timme|timma)	{printFRQ(yytext,0);}
([Vv]arannan" \, ")?[Vv]ar" "[^\n\t ]*(femt|fjrd|tredj|ond)e" "([^\n ]*dag|sekund|minut|timme|timma|dag|vecka|mnad)	{printFRQ(yytext,0);}
[Vv]arannan" "(sekund|minut|timme|timma|dag|helg|vecka|mnad)	{printFRQ(yytext,0);}
([Hh]gst" "|under" "|ver" ")?([0-9]+\,[0-9]+[0-9]+\,[0-9]+|[0-9]+x[0-9]+|[0-9]+\/[0-9\,]+|[0-9\-]+" "[0-9\-]+|[0-9]+" \- "[0-9]+|[1-9]+" \, "[0-9]+|[0-9]+|[0-9]+\,[0-9]+|[0-9]+\.[0-9]+|[0-9]+\-[0-9]+|[Tt]v|[Tt]re|[Ff]yra|[Ff]em|tusen|[Ff]lera)" "(gnger|ggr)"\/"(day|kg\/dag|kg\/day|kg\/min|kg\/timme|min|timme|dygn|vecka|dag|dagl|dagligen|mn|mnaden|v)(" i en vecka"|" i "[^\n ]+" veckor"|" sista dygnet")?	{printFRQ(yytext,0);}
([Hh]gst" "|under" "|ver" ")?([0-9]+\,[0-9]+[0-9]+\,[0-9]+|[0-9]+x[0-9]+|[0-9]+\/[0-9\,]+|[0-9\-]+" "[0-9\-]+|[0-9]+" \- "[0-9]+|[1-9]+" \, "[0-9]+|[0-9]+|[0-9]+\,[0-9]+|[0-9]+\.[0-9]+|[0-9]+\-[0-9]+|{NUM}|[Ee]"tt par"|[Ee]"tt ftal"|tusen|[Ff]lera|[Nn]gon|En)" "(gnger|ggr|gng|timme|timmar)" per "(minut|min|timme|mnad|dygn|vecka|dag|dagligen|r|rhundrade)	{printFRQ(yytext,0);}
([Hh]gst" "|under" "|ver" ")?([0-9]+\,[0-9]+[0-9]+\,[0-9]+|[0-9]+x[0-9]+|[0-9]+\/[0-9\,]+|[0-9\-]+" "[0-9\-]+|[0-9]+" \- "[0-9]+|[1-9]+" \, "[0-9]+|[0-9]+|[0-9]+\,[0-9]+|[0-9]+\.[0-9]+|[0-9]+\-[0-9]+|{NUM}|{NUM}"\-"{NUM}|{NUM}" till "{NUM}|[Ee]"tt par"|[Ee]"tt ftal"|tusen|[Ff]lera|[Ee]n" eller tv")" "(gnger|ggr|gng)" "("varje natt"|"sista dygnet"|dagligen|om" "dagen|"om ret")	{printFRQ(yytext,0);}
([Hh]gst" "|under" "|ver" ")?([0-9]+\,[0-9]+[0-9]+\,[0-9]+|[0-9]+x[0-9]+|[0-9]+\/[0-9\,]+|[0-9\-]+" "[0-9\-]+|[0-9]+" \- "[0-9]+|[1-9]+" \, "[0-9]+|[0-9]+|[0-9]+\,[0-9]+|[0-9]+\.[0-9]+|[0-9]+\-[0-9]+|{NUM}|{NUM}\-{NUM}|tusen|[Ff]lera)" "(gnger|ggr|gng)" i "(sekunden|timmen|dagligen|vecka|veckan|mnaden)	{printFRQ(yytext,0);}
([0-9]+\-)?[0-9]+([km]g|g)"\/d"(ygn)?	{printFRQ(yytext,0);}
([Mm]inst" ")?([0-9][+-9\-]*" min")" om dagen"	{printFRQ(yytext,0);}
[0-9]+" gng\/vecka"	{printFRQ(yytext,0);}
(under" "|ver" ")?[0-9]+(gng|gnger|ggr)"\/"(day|kg\/dag|kg\/day|kg\/min|kg\/timme|min|timme|dygn|vecka|dag|dagl|dagligen|mn|mnaden|mnad)	{printFRQ(yytext,0);}
[A-Za-z]+" gnger med "[0-9]\-[0-9]" minuters intervall"	{printFRQ(yytext,0);}
(1g\/mn|2ggr|1ggr\/V|1g\/v)	{printFRQ(yytext,0);}
"gller allt oftare"	{printFRQ(yytext,1);}
"\, ret runt"	{printf(", <NUMEX TYPE=\"MSR\" SBT=\"FRQ\">ret runt</NUMEX>"); }
{NUM}" dagar i "veckan	{printFRQ(yytext,0);}
{NUM}" och en halv gnger"	{printFRQ(yytext,0);}
[Vv]ar" tredje \, fjrde "(dag|mnad)	{printFRQ(yytext,0);}
[Vv]ar" tredje till fjrde "(dag|mnad)	{printFRQ(yytext,0);}
[Ff]rekvens" bilat "[0-9]+\/min	{printFRQ(yytext,2);}
[Ff]rekvens" "[0-9]+\/min	{printFRQ(yytext,1);}
[0-9]+" r i rad"	{printFRQ(yytext,0);}
[Vv]ar" "[1-9]\:?dje" "(r|vecka|mnad)	{printFRQ(yytext,0);}
([Mm]inst" ")?({NUM}|[0-9]+|[0-9]+\-[0-9]+)" "(minuter|timmar|dagar|h)\/(mnad|vecka|mnaden|veckan)	{printFRQ(yytext,0);}
[Vv]arannan" "dag" i "[^\n ]+" "dagar	{printFRQ(yytext,0);}
{NUM}" "dagar\/vecka" i "[^\n ]+" "veckor	{printFRQ(yytext,0);}
{NUM}" "dagar" i "veckan	{printFRQ(yytext,0);}
[Ff]rekvens" "[a-z]+" "[0-9]+\/min	{printFRQ(yytext,1);}
[Ff]rekv\.?" "[a-z]+" "[0-9]+(\/min)?	{printFRQ(yytext,1);}
(Mer" n"|[Hh]gst|[Uu]nder)" "[^\n< ]+" timmar per "dag	{printFRQ(yytext,0);}
[Ii]" "genomsnitt" "[^\n\t< ]+" "(veckor|dagar|r|mnader)	{printFRQ(yytext,0);}
([]rligen|[Dd]agligen|[Vv]eckovis|[Mm]nadsvis|[Tt]idvis|[Pp]eriodvis)	{printFRQ(yytext,0);}
	/* Metric surface Unit - MSU */
([Uu]ppemot" "|[Pp]" "|[]ver" "|[Uu]nder" "|[Mm]"inst "|[Uu]"ngefr "|[Oo]"mkring "|[Dd]"rygt "|[Cc]"irka "|[Dd]ryga" "|[Ff]rn" ")?[0-9]+([\,\.0-9\-\_]+|" "[0-9]+)?" "("miljoner ")?(mikrometer|kvadrat[^\n\t ]*meter|mm2|cm2|hkr|m2|km2|hektar|hektaren|tunnland)	{printMSU(yytext,0);}
([Uu]ppemot" "|[Pp]" "|[]ver" "|[Uu]nder" "|[Mm]"inst "|[Uu]"ngefr "|[Oo]"mkring "|[Dd]"rygt "|[Cc]"irka "|"dryga "|[Ff]"rn "){NUM}" "(mikrometer|kvadrat[^\n\t ]*meter|mm2|cm2|hkr|m2|km2|hektar|hektaren|tunnland)	{printMSU(yytext,0);}
bt" p "[0-9]+" fot"	{printMSU(yytext,1);}
{NUM}" tomma kvadratmeter"	{printMSU(yytext,0);}
[Jj]ag" r "[12]"\,"[0-9][0-9]	{printMSU(yytext,2);}
([Cc]irka" ")?[0-9]+" "[0-9]+" km"	{printMSU(yytext,0);}
[0-9][x\.][0-9]" "inch(es)?	{printMSU(yytext,0);}
	/* */
"BMI Pop"	{ECHO;}
volym" "[0-9]+(\.[0-9]+)?" "[^\n\t ]L	{printVLM(yytext,0);}
"BMI "[0-9]+[0-9\-\,]*(" eller mer"|" "[0-9]+|" kg\/m2")?	{printVLM(yytext,0);}
(vid|p)" "[0-9\-]+" BMI"	{printVLM(yytext,1);}
(BMI|BMI\-vrde)" "("\, ver"|"\&lt\;"|"\&gt\;"|"mindre n"|ver|under|p" "minst)" "[0-9\,]*[0-9](" kg\/m2")?	{printVLM(yytext,0);}
"BMI mellan "[0-9\,\-]*[0-9]" och "[0-9\,\-]*[0-9]	{printVLM(yytext,0);}
"BMI "[0-9][0-9\-\,]*(" eller mer"|" "[0-9]+|" kg\/m2")?	{printVLM(yytext,0);}
"BMI \( Body Mass Index ) p "[0-9\,\-]+(" eller mer")?	{printVLM(yytext,0);}
[1-9]0" BMI"	{printVLM(yytext,0);}
(BMI|[Bb]ody" "[Mm]ass" "[Ii]ndex)" p "[0-9\-\,\/]+([1-9])?	{printVLM(yytext,0);}
([Mm]edel\-BMI|BMI|[Bb]ody" "[Mm]ass" "[Ii]ndex|[Bb]odymassindex)(et)?	{printVLM(yytext,0);}
BMI" "[0-9]+\.[0-9]([0-9])?	{printVLM(yytext,0);}
BMI" "[0-9]+\.[0-9](\-[0-9]+\.[0-9])(" kg\/m2")?	{printVLM(yytext,0);}
[Ii]ndex" r "(under|ver)" "[0-9][0-9\-\,\/]*	{printVLM(yytext,2);}
\" "[0-9]+\.[0-9]+" kg\/m2"	{printVLM(yytext,0);}
[0-9]+" kg\/m2"	{printVLM(yytext,0);}
BMI" = "[0-9]+(\/kg\/m2)?	{printVLM(yytext,0);}
BMI" >"[0-9]+" eller \>= "[0-9]+	{printVLM(yytext,0);}
([Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]\:a" "|ca" "|[Ff]rn" "|till" "|[Dd]"rygt "|[Bb]"ara "|[Uu]ngefr" "|[Oo]mkring" "|[Uu]"pp till "|[Pp]" cirka "|[Pp]" "|[Uu]"nder ")?([0-9]+" eller "|[0-9]+" till "|[1-9][0-9]+" "|[0-9]" respektive ")?([0-9][0-9\-\,\.\/]*[0-9]+|[0-9]+|[0-9]+" "[0-9]+|[Tt]v|[Tt]re|[Ff]yra|[Ss]ex|[Ff]em|[Ss]ju|[]tta|[Nn]io|[Tt]io|[Tt]olv|[^\n\t ]*[Hh]undra|[Tt]"v hundra"|[Tt]"re hundra"|[Ff]"yra hundra"|[Ff]"em hundra"|[Ee]n" halv"|[Nn]"gra hundra"|[Nn]"gra f"|flera|"fr varje"|[Ee]"tt "[^\n\t ]+tal|miljoner)" "[^\n\t ]*(mil|mils|centimeter|meters|m|meter|[kcmd]m)" "(tjock|bred|brett)(e|a|t)?	{printVLM(yytext,0);}
([Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]\:a" "|ca" "|[Ff]rn" "|till" "|[Dd]"rygt "|[Bb]"ara "|[Uu]ngefr" "|[Oo]mkring" "|[Uu]"pp till "|[Pp]" cirka "|[Pp]" "|[Uu]"nder ")?([0-9]+" eller "|[0-9]+" till "|[1-9][0-9]+" "|[0-9]" respektive ")?([0-9][0-9\-\,\.\/]*[0-9]+|[0-9]+)" cm2\/m2"	{printVLM(yytext,0);}
	/* Length Unit - LNU */
([Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]\:a" "|ca" "|[Ff]rn" "|till" "|[Dd]"rygt "|[Bb]"ara "|[Uu]ngefr" "|[Oo]mkring" "|[Uu]"pp till "|[Pp]" cirka "|[Pp]" "|[Uu]"nder "|[Uu]"pptill ")?([0-9]+" x "|[0-9]+" eller "|[0-9]+" till "|[1-9][0-9]+" "|[0-9]" respektive "|[0-9]" resp "|{NUM}" eller ")?([0-9][0-9\-\,\.\/]*[0-9]+|[0-9]+|[0-9]+" "[0-9]+|[Tt]v|[Tt]re|[Ff]yra|[Ss]ex|[Ff]em|[Ss]ju|[]tta|[Nn]io|[Tt]io|[Tt]olv|[^\n\t ]*[Hh]undra|[Tt]"v hundra"|[Tt]"re hundra"|[Ff]"yra hundra"|[Ff]"em hundra"|[Ee]n" halv"|[Nn]"gra hundra"|[Nn]"gra f"|flera|"fr varje"|[Ee]"tt "[^\n\t ]+tal|miljoner|[^\n\t ]*[Tt]usen)" "[^\n\t ]*(kilometre|mil|mils|centimeter|meters|meters|m|meter|[kcmd]m)" "(stor|lng|hg|djup|hjd|havsdjup|bort|avstnd|hll)(e|a|t)?	{printDST(yytext,0);}
([Kk]"nappa "|[Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]\:a" "|ca" "|[Ff]rn" "|till" "|[Dd]"rygt "|[Bb]"ara "|[Uu]ngefr" "|[Oo]mkring" "|[Uu]"pp till "|[Pp]" cirka "|[Pp]" "|"p ver "|[Pp]" ca "|[Uu]"nder "|[]"ver ")?([0-9]+" eller "|[0-9]+" och "|[Mm]ellan" "[0-9]+" och "|[0-9]+" respektive "|[0-9]+" till ")?([1-9][0-9]*" ")?([Nn]gra|[Tt]v|[Tt]re|[Ff]yra|[Ss]ex|[Ff]em|[Ss]ju|[]tta|[Nn]io|[Tt]io|[Tt]olv|[0-9]+|[Ee]"tt par hundra"|[Nn]"gra hundra"|[^\n ]*[Hh]undra|[Ee]n" halv"|[Ee]ttusen|[Ee]tt" par"|[Ee]n" dryg"|"bara en"|[0-9]+\/[0-9]+|[0-9]+" "[0-9]+\/[0-9]+|[0-9]+"x"[0-9]+|[0-9]+" \- "[0-9]+|[0-9][0-9\-\,\.]*[0-9]+|[Ee]"tt "[^\n\t ]+tal|[^\n\t ]+ton)" "("miljoner "|"miljarder ")?([Kkcd]m|kilometer|centimeter|[^\n\t ]*[Mm]eter|[^\n\t ]*meterna|[^\n\t ]*metrarna)(\/t[a-z]*)?	{printDST(yytext,0);}
	/*had to separate the 'mm' cause it was interefering with the mm>hg*/
([Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]\:a" "|ca" "|[Ff]rn" "|till" "|[Dd]"rygt "|[Bb]"ara "|[Uu]ngefr" "|[Oo]mkring" "|[Uu]"pp till "|[Pp]" cirka "|[Pp]" "|"p ver "|[Pp]" ca "|[Uu]"nder "|[]"ver ")?([0-9]+" eller "|[0-9]+" och "|[Mm]ellan" "[0-9]+" och "|[0-9]+" respektive "|[0-9]+" till ")?([1-9][0-9]*" ")?([Nn]gra|[Tt]v|[Tt]re|[Ff]yra|[Ss]ex|[Ff]em|[Ss]ju|[]tta|[Nn]io|[Tt]io|[Tt]olv|[0-9]+|[Ee]"tt par hundra"|[Nn]"gra hundra"|[^\n ]*[Hh]undra|[Ee]n" halv"|[Ee]tt" par"|[Ee]n" dryg"|"bara en"|[0-9]+" "[0-9]+\/[0-9]+|[0-9]+"x"[0-9]+|[0-9]+" \- "[0-9]+|[0-9][0-9\-\,\.]*[0-9]+|[Ee]"tt "[^\n\t ]+tal|[^\n\t ]+ton)" "("miljoner "|"miljarder ")?mm(\/t[a-z]*)?" "	{int i=0;
	printf("<NUMEX TYPE=\"MSR\" SBT=\"DST\">");
	for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> "); }
([Nn]stan" "|[Mm]inst" "|[Cc]irka" "|[Cc]\:a" "|ca" "|[Ff]rn" "|till" "|[Dd]"rygt "|[Bb]"ara "|[Uu]ngefr" "|[Oo]mkring" "|[Uu]"pp till "|[Pp]" cirka "|[Pp]" "|[Uu]"nder ")?([1-9][0-9]" ")?[0-9][0-9\-\,\.]*[0-9]" "("svenska "|"nautiska ")?[a-z]*mil" "	{int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"DST\">"); 	for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX>"); putchar(' ');}
(hundratal|[0-9]+" x "[0-9]+)" "[^\n\t ]*meter	{printDST(yytext,0);}
[Pp]" "[0-9]+" m "	{ int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"DST\">");
	for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX>"); putchar(' ');}
([Cc]"entimeter fr centimeter"|[Dd]en" "knappa" "kilometern|[Nn]gon" "[^\n\t ]*meter|ngra" "[^\n\t ]*meter|[Ee]n" halvmil")	{printDST(yytext,0);}
(tv|tre|fyra|fem|sex|sju|tta|nio|[0-9]+)" "(eller|och)" "(tv|tre|fyra|fem|sex|sju|tta|nio|tio|[0-9]+)" "[^\n\t ]*meters" "[a-z]+	{printDST(yytext,0);}
([0-9]+|{NUM})" "(miljarder|miljoner)" "ljusr	{printDST(yytext,0);}
[0-9]+" "[0-9]+" ljusr"	{printDST(yytext,0);}
[0-9]+" "(engelska" "mil|ljusr|distansminuter)	{printDST(yytext,0);}
([Kk]"nappt "|[Nn]"stan "|[Cc]irka" "|[Uu]"pp till "|[Pp]" knappt "|[Dd]"rygt ")?({NUM}" nautiska"|f" nautiska"|{NUM}|[Hh]undra|[^\n\t ]+tio)" "(sj)?mil" "	{int i=0;
	printf("<NUMEX TYPE=\"MSR\" SBT=\"DST\">");
	for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> "); }
([Cc]irka|[Uu]"pp till"|[Nn]stan|[Dd]rygt|[Pp]" knappt"|[Dd]rygt)" "[^\n\t ]+" "(sj)?mil" "	{ int i=0;
	printf("<NUMEX TYPE=\"MSR\" SBT=\"DST\">");
	for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> "); }
[0-9]+" m  h"	{printDST(yytext,0);}
([Hh]gre|[Ll]gre)" n "[0-9]\,[0-9]+	{printDST(yytext,2);}
[^\n\t ]*"hoppet p "[0-9]\,[0-9]+	{printDST(yytext,2);}
[^\n\t ]+\-[^\n\t ]+" "sekundenheter	{printDST(yytext,0);}
[0-9\,]+("x"[0-9\.\,]+)+" "[cm]m	{printDST(yytext,0);}
[0-9\,]+(" x "[0-9\.\,]+)+" "[cm]m	{printDST(yytext,0);}
[^\n\t ]*mttet" "[0-9]+" x "[0-9]+" cm"	{printDST(yytext,1);}
ca" "[0-9]+[cm]m" "	{int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"DST\">"); 	for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> "); }
[Cc]irka" "[0-9]+" milen"	{printDST(yytext,0);}
	/* Coordinates - CRD */
[Ll]atitud" "[0-9]+" gr "[0-9]+" "min	{printCRD(yytext,1);}
[0-9]+" graders "[^\n\t ]+" "latitud	{printCRD(yytext,0);}
[Ll]atitud" "[NS]" "[0-9]+" "grader	{printCRD(yytext,1);}
[Ll]ongitud" "[V]" "[0-9]+" "grader	{printCRD(yytext,1);}
latitud" "(norr|ost)" "[0-9]+" "gr" "[0-9]+" "min(uter)?	{printCRD(yytext,1);}
(latituden|longituden)" "[0-9]+" "grader" \, "[0-9]+" "min(uter)?	{printCRD(yytext,1);}
koordinater" "[0-9]+\,[0-9]+\" "[SNV]	{printCRD(yytext,1);}
koordinater" "[0-9]+([\,\.][0-9]+)?" "[SNV]	{printCRD(yytext,1);}
koordinater" "[0-9]+([\,\.][0-9]+)?" "[SNV]	{printCRD(yytext,1);}
[0-9]+\,[0-9]+\" "[SNV]	{printCRD(yytext,1);}
	/* DEGREE DGR*/
([Rr]"unt "|"ver "|[Mm]"inus "|"plus "|"upp till "|"under "|"drygt "|[Nn]"stan ")?(\+\-)?[0-9]+([\,\.\-0-9]+)?" graders "(lutning|vinkel)	{printDGR(yytext,0);}
[^\n\t ]*vinkeln" mellan "[0-9]+" och "[0-9]+" "grader	{printDGR(yytext,1);}
[^\n\t ]*vinkel" "[a-z]+" "[0-9]+("\-"|" \- ")[0-9]+" "grader	{printDGR(yytext,1);}
[^\n\t ]*vinkeln" "([0-9]+|[0-9]+" ")	{printDGR(yytext,1);}
"360 grader"	{printDGR(yytext,0);}
[Rr]otation" "[0-9]+o	{printDGR(yytext,1);}
([Ee]xtension|[Ff]lexion)" "(ca" ")?[0-9\-]+" "grader	{printDGR(yytext,1);}
[0-9]+o" "flexion	{printDGR(yytext,0);}
([1-9]" \, "[0-9]|[1-9]|[1-9]\,[0-9]|fem|sex|tta|sju|nio|[1-9]\.[0-9])" p "("den ppna ")?[Rr]ichter(\-skalan|skalan)	{printDEN(yytext,0);}
[Mm]ellan" "[0-9]" och "[0-9]+" dBA"	{printDEN(yytext,0);}
([0-9\-]+" "|[0-9\-]+" resp\. ")?[0-9][0-9\-\,\_]*" "(herz|dB|dBA|dBAHz|kilohertz|[Mm]egahertz|[Hh]ertz|MHz|Beaufort|Hz)	{printDEN(yytext,0);}
[Rr]ichtermagnituden" "[1-9](" \, "[0-9]|\,[0-9])?	{printDEN(yytext,0);}
([0-9\-]+" ")?[0-9\-]+" "(ton" "trotyl|trotyl|ngstrm)	{printDEN(yytext,0);}
[0-9]+" "(decibel|db)	{printDEN(yytext,0);}
[0-9]+d[Bb]	{printDEN(yytext,0);}
[0-9]+" av "[0-9]+" "(decibel|db)	{printDEN(yytext,0);}
[0-9]+[Hh]z	{printDEN(yytext,0);}
	/* TEMPERATURE */
([Mm]ellan" ")?[\+\-]?[0-9\_]+(" "[0-9]+)?" "(och|till)" "[\+\-]?[0-9\_]+(" "[0-9]+)?" "grader	{printTMP(yytext,0);}
([Vv]id" ")?(c\:a|[Kk]ring" "|[Bb]ortt" "|minst" "|"strax under "|"cirka "|[Rr]"unt "|"ver "|[Mm]"inus "|"plus "|"upp till "|"under "|"drygt "|[Nn]"stan ")?[\+\-]?[0-9]+[\,\.\-0-9]*" grader "(plus|minus|[Cc]elsius|[Ff]ahrenheit|[Kk]elvin|varmt|kallt|C)	{printTMP(yytext,0);}
(c\:a|[Kk]ring" "|[Bb]ortt" "|[Vv]id" "|minst" "|"strax under "|"cirka "|[Rr]"unt "|"ver "|[Mm]"inus "|"plus "|"upp till "|"under "|"drygt "|[Nn]"stan ")?(tv|tre|fyra|fem|six|tta|nio|[a-z]*tio)" grader "(minus|C|[Cc]elsius|[Ff]ahrenheit|[Kk]elvin|varmt|kallt|plus)	{printTMP(yytext,0);}
([Vv]id" ")?(c\:a|[Kk]ring" "|[Bb]ortt" "|minst" "|"strax under "|"cirka "|[Rr]"unt "|"ver "|[Mm]"inus "|"plus "|"upp till "|"under "|"drygt "|[Nn]"stan ")?[\+\-]?[0-9]+[\,\.\-0-9]*" grader "\([Cc]|[Ff]|[Kk]|[Cc]elsius|[Ff]ahrenheit|[Kk]elvin)	{printTMP(yytext,0);}
(c\:a|[Kk]ring" "|[Bb]ortt" "|[Vv]id" "|minst" "|"strax under "|"cirka "|[Rr]"unt "|"ver "|[Mm]"inus "|"plus "|"upp till "|"under "|"drygt "|[Nn]"stan ")?[\+\-]?[0-9]+[\,\.\-0-9]*(\|\[Cc]|\[Ff]|\[Kk]|" C"|"\ Celsius")(\.)?	{printTMP(yytext,0);}
(c\:a|[Kk]ring" "|[Bb]ortt" "|[Vv]id" "|minst" "|"strax under "|"cirka "|[Rr]"unt "|"ver "|[Mm]"inus "|"plus "|"upp till "|"under "|"drygt "|[Nn]"stan ")?[\+\-]?[0-9]+[\,\.\-0-9]*\	{printTMP(yytext,0);}
(c\:a|[Kk]ring" "|[Bb]ortt" "|[Vv]id" "|minst" "|"strax under "|"cirka "|[Rr]"unt "|"ver "|[Mm]"inus "|"plus "|"upp till "|"under "|"drygt "|[Nn]"stan "|[Bb]"ara ")?(\+|\-)?[0-9]+[\,\.\-0-9]*" "(grader|graders|minusgrader|plusgrader)	{printTMP(yytext,0);}
[^\n\t ]*emperaturen" frn "[a-z]+" "[0-9]+" grader till "[a-z]+" "[0-9]+" "grader	{printTMP(yytext,2);}
([0-9]+" minus grader"|[0-9\,]+"\-gradiga vattnet"|[0-9\,]+"\-gradiga kylan")	{printTMP(yytext,0);}
("strax under"|[Oo]mkring|hgst|[Kk]ring|[Rr]unt|ver|[Mm]inus|[Pp]lus|"upp till"|under|drygt|[Nn]stan|minst)" "[0-9]+" "[a-z]*grader(" "minus)?	{printTMP(yytext,0);}
termometern" p "\-[0-9]+	{printTMP(yytext,1);}
("strax under "|[Oo]mkring" "|hgst" "|[Kk]ring" "|[Rr]unt" "|ver" "|[Mm]inus" "|[Pp]lus" "|"upp till "|under" "|drygt" "|[Nn]stan" "|minst" ")?"noll grader"	{printTMP(yytext,0);}
[Ii]" drygt "[0-9]+\-gradig" vrme"	{printTMP(yytext,0);}
[0-9]+\\-[0-9]+\[CF]	{printTMP(yytext,0);}
[0-9]+" "[Bb]tu\/min	{printTMP(yytext,0);}
"\+\/\- "[0-9]+"\C"	{printTMP(yytext,0);}
\+[0-9]+" C eller "(lgre|hgre)	{printTMP(yytext,0);}
\+[0-9]+C	{printTMP(yytext,0);}
[0-9]+C	{printTMP(yytext,0);}
[Tt]"emp \> "[0-9][0-9]\,[0-9]	{printTMP(yytext,2);}
"feber "[0-9][0-9]\,[0-9]	{printTMP(yytext,1);}
("c\:a"|[Cc]irka)" "[0-9]+\	{printTMP(yytext,0);}
"ver "[0-9]+"\ C"	{printTMP(yytext,0);}
([Tt]emp|[Tt]emperatur)" \( "[0-9]+(" \C"|" \"|"\C"|"\")	{printTMP(yytext,2);}
versteg" knappast "[0-9]+" grader"	{printTMP(yytext,1);}
[Tt]emp\.?" "[0-9][0-9][\,\.][0-9]	{printTMP(yytext,1);}
[Tt]emperaturen" "[a-z]+" mellan "[0-9]+" och "[0-9]+" grader"	{printTMP(yytext,2);}
(Nattemp|Dagstemp)" \: "[0-9][0-9]	{printTMP(yytext,2);}
([Tt]emp|[Tt]emperatur)" "[0-9][0-9\,]*(" \C"|" \"|"\C"|"\")	{printTMP(yytext,1);}
	/* PROCENT */
[Ss]" mnga som "[0-9](\-[0-9]+)?" "(procent|\%)	{printPRC(yytext,0);}
(P" "|[Uu]"ppemot "|[Yy]"tterligare "|[Ee]"ndast "|[Mm]"inst "|[Nn]"rmare "|[Kk]"nappt "|[Uu]"ngefr "|[Cc]irka" "|[Cc]a" "|[Bb]ara" "|[Cc]"\:a "|[Oo]mkring" "|[Nn]"ra "|[]"ver "|[Uu]"nder ")?([Mm]inus" "|[Mm]"er n "|[Mm]"indre n "|[Rr]unt" "|[Hh]"ela "|[Dd]rygt" "|[Nn]stan" "|[Uu]pp" till "|med" upp till "|med" "|[Pp]" plus\/minus ")?([Cc]"irka ")?[^\n\t ]*([Mm]ellan" en"|[Ee]"ndast en"|[Tt]v|[Tt]re|[Ff]yra|[Ff]em|[Ss]ex|[Ss]ju|[]tta|[Nn]io|[Tt]io|[Ee]lva|[Tt]olv|retton|[Tt]jugo|jorton|tioen|[0-9]+|[0-9]+\,[0-9]+)" "(eller|till|respektive|och|vs|[Ff]rn" "[0-9]+"  till"|mot)" "[^\n\t ]*("cirka en"|tv|tre|fyra|fem|sex|sju|tta|nio|tio|[0-9]+|[0-9]+\,[0-9]+)" "proc(enten|ent|\.|entenhet|entenheter)(\/r|" lgre"|" hgre"|" respektive "[0-9]+" procent")?	{printPRC(yytext,0);}
([Uu]"ppemot "|[Yy]"tterligare "|[Ee]"ndast "|[Mm]"inst "|[Nn]"rmare "|[Kk]"nappt "|[Uu]"ngefr "|[Cc]irka" "|[Cc]a" "|[Bb]ara" "|[Cc]"\:a "|[Oo]mkring" "|[Nn]"ra "|[]"ver "|[Uu]"nder ")?([Mm]"er n "|[Mm]indre" n "|[Rr]unt" "|[Hh]"ela "|[Dd]rygt" "|[Nn]stan" "|[Uu]pp" till "|[Pp]" plus\/minus ")?([0-9]+" eller "|[0-9]+" till "|[0-9]+\,[0-9]+" vs "|[0-9]+" vs "|"ver "|med" upp till "|med" "|[Ff]rn" "[0-9]+"  till")?[^\n\t ]*([Tt]v|[Tt]re|[Ff]yra|[Ff]em|[Ss]ex|[Ss]ju|[]tta|[Nn]io|[Tt]io|tioen|[Ee]lva|[Tt]olv|tretton|fjorton|[0-9]+|[0-9]+\,[0-9]+|"en kvarts"|[Nn]"gra f"|hundra)" "proc(enten|ent|\.|entenhet|entenheter)?(\/r)?	{printPRC(yytext,0);}
([Uu]"ppemot "|[Yy]"tterligare "|[Ee]"ndast "|[Mm]"inst "|[Nn]"rmare "|[Kk]"nappt "|[Uu]"ngefr "|[Cc]irka" "|[Cc]a" "|[Bb]ara" "|[Cc]"\:a "|[Oo]mkring" "|[Nn]"ra "|[]"ver "|[Uu]"nder ")?([Mm]"er n "|[Mm]"indre n "|[Rr]unt" "|[Hh]"ela "|[Dd]rygt" "|[Nn]stan" "|[Uu]pp" till "|[Mm]ellan" "[0-9]+" och "|med" upp till "|[0-9]+\%" vs "|[0-9]+" vs "|med" "|med" \> "|med" \< "|[Ff]rn" "[0-9]+"  till "|[Pp]" plus\/minus ")?([Cc]"irka ")?([0-9]+"\+"[0-9]+|[0-9]+""[0-9]+|[0-9]+[\.\,][0-9]+\-[0-9]+|[0-9]+[\.\,][0-9]+\-[0-9]+[\.\,][0-9]+|[0-9]\-[0-9]+[\.\,\-][0-9]+|[0-9]+[\.\,\-][0-9]+|[0-9]+|[0-9]+" till "[0-9]+)(" \%"|\%)(\-enheter|\/r)?	{printPRC(yytext,0);}
([Uu]"ppemot "|[Yy]"tterligare "|[Ee]"ndast "|[Mm]"inst "|[Nn]"rmare "|[Kk]"nappt "|[Uu]"ngefr "|[Cc]irka" "|[Cc]a" "|[Bb]ara" "|[Cc]"\:a "|[Oo]mkring" "|[Mm]elln" "[0-9]+" och "|[Nn]"ra "|[]"ver "|[Uu]"nder ")?([Mm]"er n "|[Mm]"indre n "|[Rr]unt" "|[Hh]"ela "|[Dd]rygt" "|[Nn]stan" "|[Uu]pp" till "|med" upp till "|med" "|[Ff]rn" "[0-9]+"  till"|[0-9]+" respective ")?([Cc]"irka ")?[0-9]+" \- "[0-9]+(" \%"|\%)(\-enheter|\/r)?	{printPRC(yytext,0);}
(\+|\-)[0-9]\,[0-9]\%(\-enheter|\/r)?	{printPRC(yytext,0);}
(snker|hjer)" med "[0-9]+" punkter"	{printPRC(yytext,2);}
[0-9]+"\:e och "[0-9]+"\:e percentilen"	{printPRC(yytext,0);}
([Uu]"ppemot "|[Yy]"tterligare "|[Ee]"ndast "|[Mm]"inst "|[Nn]"rmare "|[Kk]"nappt "|[Uu]"ngefr "|[Cc]irka" "|[Cc]a" "|[Bb]ara" "|[Cc]"\:a "|[Oo]mkring" "|[Nn]"ra "|[]"ver "|[Uu]"nder ")?[0-9]+"\:e percentilen"	{printPRC(yytext,0);}
[^\n ]*tusentals" procent"	{printPRC(yytext,0);}
[0-9]+[\.\,][0-9]+\-procent	{printPRC(yytext,0);}
[Mm]"indre n "[0-9]+" %"	{printPRC(yytext,0);}
	/* CURRENCY */
[0-9]+\/[0-9]+" av "[0-9]+" kr"\.?	{printCUR(yytext,0);}
([Kk]"nappt "|[Uu]"ngefr "|[Uu]ppemot" "|[Rr]unt" "|[Dd]rygt" "|[Mm]"inst "|[Nn]"rmare "|[Uu]pp" till "|[Oo]"mkring "|[Cc]irka" "|[]ver" "|[Kk]"ring ")?([^\n ]*[Hh]undra|[Ee]tt" par hundra"|[Ee]n|[Ee]n" "halv|flera" "hundra)" "milj(on|ard)(er)?" "([a-z]+ska" ")?(pund|lire|peso|litas|rubler|"schweiz franc"|rupees|rupier|rupiah|yen|[Ee]uro|lira|kronorna|[Kk]ronor|re|[^\n\t ]*dollar|Dmark|D\-mark|kr\.|kr|[^\n\t ]*franc|yuan|shilling|skillingar|skilling)(s)?	{printCUR(yytext,0);}
([Kk]"nappa "|[Kk]"nappt "|[Uu]"ngefr "|[Uu]ppemot" "|Runt" "|[Mm]"inst "|[Nn]"rmare "|[Pp]" ver "|[]ver" "|[Uu]pp" till "|[Oo]"mkring "|[Uu]nder" "|[Cc]irka" "|[Mm]ellan" "[0-9]+"\, "[0-9]+" och "|[Mm]ellan" "[0-9]+" "[0-9]+" och "|[Mm]ellan" "[0-9]+" och "|[Dd]"rygt "|[Ff]rn" "[0-9\,]+" till "|"av "{NUM}" till "|[Ff]rn" "[0-9]+" "[0-9]+" till "|"mot minus "|[Mm]"indre n ")?([Mm]"nga miljarder "|[Ff]"lera hundra "|[Ee]"tt par hundra "|"tolv "|"elva "|"flera "|[^\n\t ]+ton" "|[^\n\t ]*tio" "|{NUM}\-{NUM}" "|{NUM}" "|[^\n\t ]+tals" "|[0-9]+" eller "[0-9]+" "|[0-9]+" "[0-9]+\-[0-9]+" "[0-9]+" "|[0-9]+[\-\:\,\.\_][0-9]+" "|[0-9]+" "[0-9]+" "[0-9]+" "|[1-9]\-[1-9]\,[1-9]|[0-9]+" "[0-9]+" "|[0-9]+" "|[0-9]+\-[0-9]+" "|[0-9]+\-[0-9]+" "[0-9]+" "|[0-9]+" "\,[0-9]+" "|[0-9]+" \. "[0-9]+" "|[0-9]+\:[0-9]+\-[0-9]+\:[0-9]+" "|\-[0-9]+" "|[^\n\t ]*tusen" "|[Mm]nga" tusen "|[Hh]undra" ")([^\n\t ]*iljoner" "|[^\n\t ]*illion" "|[^\n\t ]*iljarder" "|[^\n\t ]*iljard" "|[^\n\t ]*iljon" "|milj" "|[^\n\t ]*iljader" "|[^\n\t ]*tusen" "|[^\n\t ]*hundra" ")?([a-z]+ska" ")?(won|spnn|yuan|rupees|cent|kopek|rubel|pund|lire|rand|peso|rubler|lira|"estniska kroon"|"US dollar"|US\-cent|shilling|"schweiz franc"|[Rr]inggit|dirham|rupier|skilling|skillingar|litas|dukater|riksbankdaler|riksdaler|pence|rupiah|[^\n\t ]*dollar|yen|[Mm]kr|Mdkr|krona|Mkr\.|[Ee]uro|kronorna|DKK|SEK|MSEK|EUR|[Kk]ronor|re|D\-mark|kr\.|kr|centimes|[^\n\t ]*franc|dollars)(s)?(\/[a-z]+)?(" till "[0-9]+\:[0-9]+" dollar"|" till "[0-9]+\:[0-9]+)?	{printCUR(yytext,0);}
(cirka|minst)" "(MSEK|MUSD|NOK|SEK|EUR|USD)" "[0-9\-]+(\.[0-9]+|\.[0-9]+\,[0-9]+)?	{printCUR(yytext,0);}
(MSEK|MUSD|SEK|EUR|USD)" "[0-9\-]+([\,\.][0-9]+)?	{printCUR(yytext,0);}
[0-9][0-9\-]*([\,\.][0-9]+)?" "(MSEK|MUSD|SEK|EUR|USD)	{printCUR(yytext,0);}
	/* MOD (Jyrki Niemi): Fixed an apparently incorrect regexp:
	("vrderas till"|"lnat ut"|"kapital p"|"frlust p"|"anslag p"|"viditetsbrist p")(" "[0-9]+)?[0-9\,]+" "milj(oner|arder)(" kronor")?
	*/
("vrderas till"|"lnat ut"|"kapital p"|"frlust p"|"anslag p"|"viditetsbrist p")" "[0-9][0-9\,]*" "milj(oner|arder)(" kronor")?	{printCUR(yytext,2);}
[^\n\t ]*(frmgenheten|betala|tjnat|kostade|reserverat)" "([0-9]" "[0-9]+" "[0-9]+|[0-9]+|[0-9]+[\,\. ][0-9]+|[0-9]+" "\,[0-9]+|tv)" "milj(oner|arder)(" kronor")?	{printCUR(yytext,1);}
"miljoner "(dollar|kronor)	{printCUR(yytext,0);}
"mot kursen "[0-9]\:[0-9][0-9]	{printCUR(yytext,2);}
[0-9]+(\.[0-9]+)?m	{printCUR(yytext,0);}
\$[0-9]+[\.\,][0-9]+	{printCUR(yytext,0);}
\$[0-9]+(" "[0-9][0-9]+)?	{printCUR(yytext,0);}
[A-Z][^\n\t ]+"dska dukater"(na)?	{printCUR(yytext,0);}
[0-9]+" "(NOK|mnkr|R:dr)	{printCUR(yytext,0);}
[0-9]+" "	{printCUR(yytext,0);}
[^\n\< ]+skillingar	{printCUR(yytext,0);}
({NUM}|[0-9][0-9\,]*)" "(daler|styfver)	{printCUR(yytext,0);}
[0-9]+" "(sklpund|alner)	{printCUR(yytext,0);}
	/* TELEPHONE */
([Tt]elefonsvarare|[Tt]lf|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|tln|vxl)" \( "[0-9]+" \) "[0-9]+(" "[0-9\_]+)?	{/*Telefon ( 09 ) 47 441*/printTEL(yytext,1);}
([Tt]elefonsvarare|[Tt]lf|ankn|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|Phone|tln|vxl)" "\+?[0-9][0-9\_]+(\/|\-|" \- "|\-|" ")[0-9\_]+" "[0-9\_]+(" "[0-9\_]+)?	{printTEL(yytext,1);}
([Tt]elefonsvarare|[Tt]lf|ankn|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|Phone|tln|vxl)" "\+?[0-9][0-9\_]+(\/|\-|" \- "|" ")?[0-9\_\-]+(" "[0-9\_]+)*	{printTEL(yytext,1);}
	/* MOD (Jyrki Niemi): Rule was split into two by the number of
	   context words:
	([Tt]elefonsvarare|[Tt]lf|ankn|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|Phone|tln|vxl)(" \."|"\."|":"|" :")" "\+?[0-9][0-9\_]+(" "|\/|\-|" \- "|\-)[0-9\_\-]+" "[0-9\_]+(" "[0-9\_]+)*	{printTEL(yytext,1);}
	*/
([Tt]elefonsvarare|[Tt]lf|ankn|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|Phone|tln|vxl)("\."|":")" "\+?[0-9][0-9\_]+(" "|\/|\-|" \- "|\-)[0-9\_\-]+" "[0-9\_]+(" "[0-9\_]+)*	{printTEL(yytext,1);}
([Tt]elefonsvarare|[Tt]lf|ankn|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|Phone|tln|vxl)(" \."|" :")" "\+?[0-9][0-9\_]+(" "|\/|\-|" \- "|\-)[0-9\_\-]+" "[0-9\_]+(" "[0-9\_]+)*	{printTEL(yytext,2);}
	/* MOD (Jyrki Niemi): Rule was split into two by the number of
	   context words:
	([Tt]elefonsvarare|[Tt]lf|ankn|[Mm]obil|Tel\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|[Tt]ln|vxl)(" \."|"\."|":"|" :")" "\+?[0-9][0-9\_]+(\/|\-|" \- "|" ")[0-9\_\-]+	{printTEL(yytext,1);}
	*/
([Tt]elefonsvarare|[Tt]lf|ankn|[Mm]obil|Tel\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|[Tt]ln|vxl)("\."|":")" "\+?[0-9][0-9\_]+(\/|\-|" \- "|" ")[0-9\_\-]+	{printTEL(yytext,1);}
([Tt]elefonsvarare|[Tt]lf|ankn|[Mm]obil|Tel\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|[Tt]ln|vxl)(" \."|" :")" "\+?[0-9][0-9\_]+(\/|\-|" \- "|" ")[0-9\_\-]+	{printTEL(yytext,2);}
	/* MOD (Jyrki Niemi): Rule was split into two by the number of
	   context words:
	([Tt]elefonsvarare|[Tt]lf|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|tln)(": "|" : ")"\( \+"[0-9]+" \) "[0-9\_\-]+(" "[0-9\_]+)*	{printTEL(yytext,1);}
	*/
([Tt]elefonsvarare|[Tt]lf|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|tln)": \( \+"[0-9]+" \) "[0-9\_\-]+(" "[0-9\_]+)*	{printTEL(yytext,1);}
([Tt]elefonsvarare|[Tt]lf|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|[Tt]elefax|tln)" : \( \+"[0-9]+" \) "[0-9\_\-]+(" "[0-9\_]+)*	{printTEL(yytext,2);}
(ringa|ns)" p "\+?[0-9\_]+(\/|\-|\/|" \- ")[0-9\_]+" "[0-9\_]+" "[0-9\_]+	{printTEL(yytext,2);}
0[23][01]\-[0-9\_]+(" "[0-9\_]+)+	{printTEL(yytext,0);}
0(8|3[0-9]|[74]0|7[0-9][0-9]|18)\-[0-9\_]+(" "[0-9\_]+)+(" eller "[0-9\_]+" "[0-9\_]+" "[0-9\_]+)?	{printTEL(yytext,0);}
0(8|[34][0-9]|[74]0|7[0-9][0-9]|18)" "[0-9\_]+(" "[0-9\_]+)+	{printTEL(yytext,0);}
0(8|[34][0-9]|[74]0|7[0-9][0-9]|18)\-[1-9][0-9][0-9][0-9][0-9][0-9][0-9]?	{printTEL(yytext,0);}
0[0-9]+" \( 0 \)"(" "[0-9]+)+	{printTEL(yytext,0);}
0[0-9]+" \( 0 \)"[0-9]+(" "[0-9]+)+	{/*without space after parentheses*/     printTEL(yytext,0);}
"tel nr "[0-9\_\-]+[0-9]+(" "[0-9\_]+)*	{printTEL(yytext,2);}
"tel nr "[0-9][0-9\_]+(" "[0-9\_]+)*	{printTEL(yytext,2);}
"tel hem : "[0-9][0-9\_]+(" "[0-9\_]+)*	{printTEL(yytext,2);}
"tel\. "[0-9][0-9\_]+(" "[0-9\_]+)*	{printTEL(yytext,1);}
"via vx "[0-9\_]+(" "[0-9\_]+)*	{printTEL(yytext,2);}
(tel|tln)" "[0-9][0-9][0-9][0-9][0-9][0-9]	{printTEL(yytext,1);}
" \+"[0-9][0-9]?" "[0-9]+" "[0-9]+	{int i=1; printf(" <NUMEX TYPE=\"MSR\" SBT=\"TEL\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</NUMEX>");}
" tel "[0-9][0-9][0-9][0-9][0-9]+	{int i=5; printf(" tel <NUMEX TYPE=\"MSR\" SBT=\"TEL\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</NUMEX>");}
0(3[0-9][0-9]|40|19)\-[0-9][0-9]" "[0-9][0-9]" "[0-9][0-9]	{printTEL(yytext,0);}
([Tt]lf|[Mm]obil|[Tt]el\.|[Ff][Aa][Xx]|[Tt]fn|Ring|[Tt]el|[Tt]elefon|tln)" \+"(" ")?[0-9]+\-\(0\)[0-9\-]+(" "[0-9]+)*	{printTEL(yytext,1);}
	/* LISTOR */
[Tt]urneringen" Europa "To(p|pp)" "[0-9]+	{ECHO;}
"Fortunes lista"	{printLST(yytext,0);}
("OM ")?[A-Z][^\n\t ]+brsens" O\-lista"	{printLST(yytext,0);}
("Wall Streets"|Fortunes|Attract|FN\:s)" "([Tt]op" ")?[^\n\t ]+\-lista	{printLST(yytext,0);}
Europa" "To(p|pp)" "[0-9]+	{printLST(yytext,0);}
[A-Z]+\:s" "[^\n\t ]+" "[0-9]+\-lista	{printLST(yytext,0);}
[^\n\t ]+\-rankingens" "[0-9]+\-bsta\-lista	{printLST(yytext,0);}
"Consumer "[^\n\t ]+" "[^\n\t ]*lista	{printLST(yytext,0);}
"World "[^\n\t ]+" List"	{printLST(yytext,0);}
"lista kallad "[A-Z][^\n\t ]+" Criteria"	{printLST(yytext,0);}
	/* AGE */
[Ff]rn" "[1-9][0-9]?" till "[1-9][0-9]?" veckors medianlder"	{printAGE(yytext,0);}
[Vv]id" "[a-z]+" till "[a-z]+" rs lder"(n)?	{printAGE(yytext,1);}
[^\nt<>]+" och ett "(halv|halft)" r "gammal	{printAGE(yytext,0);}
[Vv]id" "[0-9]+" rs och "[0-9]+" rs lder"(n)?	{printAGE(yytext,1);}
([Ff]rn|[Vv]id)" "[^\n\t ]+\-[^\n\t ]+" rs lder"(n)?	{printAGE(yytext,1);}
	/* MOD (Jyrki Niemi): Corrected action: apparently had an extra
	   trailing space in the first marked expression. */
[Vv]id" "[1-9][0-9]?" mnader och en vid "[1-9][0-9]?(" rs lder"|" rslder")(n)?	{int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"AGE\">"); for(;yytext[i]!=' '; putchar(yytext[i++])); putchar(' '); i++; for(;yytext[i]!=' '; putchar(yytext[i++])); putchar(' '); i++; for(;yytext[i]!=' '; putchar(yytext[i++])); printf("</NUMEX> och en <NUMEX TYPE=\"MSR\" SBT=\"AGE\">"); for(;i<yyleng;putchar(yytext[i++])); printf("</NUMEX>");}
[Bb]arn" "(frn|mellan)" "[^\n ]+" mnader "[^\n ]+" "[^\n ]+" rs lder"	{printAGE(yytext,1);}
[Bb]arn" "(frn|mellan)" "[^\n ]+" mnader till "[^\n ]+" "r(s" lder")?	{printAGE(yytext,1);}
[Vv]id" "[0-9]+" \, "[0-9]+" och "[0-9]+" mnaders lder"	{printAGE(yytext,0);}
([Tt]"\.o\.m\."|[Uu]"pp till"|[Ss]edan|[Ii]nnan|[Ff]re|[Vv]id|[Ii]|[]ver|[Ff]rn|[Uu]nder|[Ff]r" o m")" "(omkring" "|cirka" ")?[0-9]+(\-[0-9]|[0-9]+)?(" rs lder"|" mnaders lder"|" rslder")(n)?	{printAGE(yytext,0);}
([Uu]"pp till"|[Ss]edan|[Ii]nnan|[Ff]re|[Vv]id|[Ii]|[]ver|[Ff]rn|[Ee]fter|[Uu]nder)" "(tjuguett|[0-9]" \- "[0-9]|[^\n\t ]+\-|{NUM})("mnaders lder"|"rs lder"|"rslder"|" mnaders lder"|" rs lder"|" rslder")(n)?	{printAGE(yytext,0);}
[Ii]" "[1-9][0-9](" \- "|\-)[1-9][0-9](" rs lder"|\-rslder)(n)? 	{printAGE(yytext,0);}
[Ii]" "[1-9](" \- "|\-)[1-9][0-9]?(" rs lder"|\-rslder|\-rs" "lder)(n)? 	{printAGE(yytext,0);}
[^\n\t ]*ld(ern|rarna|ersgrupperna|ersgrupper|ersgruppen)" "[^\n\>\<\, ]+" "(och|\-|till)" "[^\n\>\<\, ]+(" r")?	{printAGE(yytext,1);}
[^\n\t ]*ld(rarna|ersgrupperna|ersgrupper|ersgruppen)" "[^\n\>\<\, ]+" r "(och|till)" "[^\n\>\<\, ]+" r"	{printAGE(yytext,1);}
[^\n\t ]*ld(rarna|ersgrupperna|ersgrupper|ersgruppen)" "[^\n\>\< ]+" r"	{printAGE(yytext,1);}
[^\n\t ]*"ldern "[1-9][0-9]?" \, "[1-9][0-9]?" och "[1-9][0-9]?" r"(" och ldre")?	{printAGE(yytext,1);}
(yngre|ldre)" \, "[0-9][0-9]?" r vs "[0-9][0-9]?" "r	{printAGE(yytext,2);}
[^\n\t ]*"ldern mellan "[1-9][0-9]" "(och|\-)" "[1-9][0-9](" r")?	{printAGE(yytext,1);}
[^\n\t ]*lder(n)?" "\SD" "[0-9\.\]+	{printAGE(yytext,1);}
[^\n\t ]*lder(n)?" "[1-9][0-9](\-[1-9][0-9]" r"|\+|" r")	{printAGE(yytext,1);}
(fre|mellan|till)" "[1-9]\-[0-9]" rs lder"(n)? 	{printAGE(yytext,1);}
[Bb]arn" p mellan "[^\n\t ]+" och "[^\n\t ]+" r"(" "gamla)?	{printAGE(yytext,1);}
[Bb]arn" upp till "[^\n\t ]+" r"(" "gamla|"s lder"|"s ldern"|sldern)?	{printAGE(yytext,1);}
([Aa]lla|[Uu]ngdomar|svensk|[Kk]vinnor|[Pp]atienter|[Mm]n|kille|[Bb]arn|patienten|[Pp]atient|[Ss]venskar|[Pp]ersoner)" "(runt|under|ver|fre|frn)" "[^\n\t ]+" r"("s lder"|"slder")(n)?	{printAGE(yytext,1);}
(sner|dttrar|barn|mn)" \, "[1-9][0-9]?" "(resp|respektive|och)" "[1-9][0-9]?" r"(" "gamla)?	{printAGE(yytext,2);}
(sner|dttrar|barn|mn)" \, "{NUM}" "(resp|respektive|och)" "{NUM}" r"(" "gamla)?	{printAGE(yytext,2);}
(sner|dttrar|barn|mn)" "[1-9][0-9]?" "(resp|respektive|och)" "[1-9][0-9]?" r"(" "gamla)?	{printAGE(yytext,1);}
(sner|dttrar|barn)" \( "[1-9][0-9]?" "(resp|respektive|och)" "[1-9][0-9]?" r \)"	{printAGE(yytext,1);}
([Vv]uxna|[Bb]arn)" \( "[1-9][0-9]?" r \)"	{printAGE(yytext,1);}
" lder p "[1-9][0-9]?" "(resp|respektive)" "[1-9][0-9]?" mnader"(" "gamla)?	{printAGE(yytext,2);}
(barn|mn)" \, "[1-9][0-9]"\-"[1-9][0-9]" "(resp|respektive|och)" "[1-9][0-9]?" r"(" "gamla)?	{printAGE(yytext,2);}
(mellan|"upp emot "|[Uu]"ngefr "|"cirka ")?([1-9]+" till "|[1-9]+" och "|[0-9]+" resp "|[0-9]+" respektive "|{NUM}" och "|frn" "{NUM}" till "|{NUM}" till ")?([0-9]+" "[0-9]+|[0-9]+\-[0-9]+|[0-9]+|{NUM}" respektive "{NUM}|{NUM}|[0-9]+\.[0-9]+|[0-9]+\,[0-9]+|"en till tv")" "(dagar|veckor|mnader|r)" "(gammalt|gammal|gamla)	{printAGE(yytext,0);}
[^\n\t ]*(flickor|pojkar|[Bb]arn)" p "({NUM}|[1-9][0-9]?)" "(resp|respektive)" "({NUM}|[1-9][0-9]?)" r"	{printAGE(yytext,1);}
[^\n\t ]*(gruppen|spelare|flickor|unga|veteraner|kvinna|ngon|sngare|kille|pojkar|elever|hion|dansare|anstllda|mnniskor|vljare|[Uu]ngdomar|[Kk]vinnor|[Pp]atienter|[Mm]n|[Bb]arn|vandrare|ungdom|atient|person|[Pp]ersoner|alla|[Mm]an|lder)" "(runt|under|ver|frn|p)" "({NUM}|[1-9][0-9]?)" r"(" och uppt"|"s lder")?	{printAGE(yytext,1);}
([Uu]nder|ver|fre)" "[^\n\t ]+" veckor"("s "|s)lder(n)?	{printAGE(yytext,0);}
([Uu]nder|ver|fre)" "[^\n\t ]+" veckors "lder(n)?	{printAGE(yytext,0);}
[Vv]id" "[0-9]+" veckors lder"(n)?	{printAGE(yytext,1);}
(kvinnorna|mnnen|[Hh]an|[Hh]on|patienterna|[Ff]lickan|[Pp]ojken|killen|[]ldern|[Pp]appan|[Bb]arn|[Vv]i)" "(r|var)" "[^\n\t ]+" r"(" eller "ldre)?	{printAGE(yytext,2);}
([Hh]an|[Hh]on|[Ff]lickan|[Pp]ojken)" icke "(r|var)" "[^\n\t ]*tio	{printAGE(yytext,3);}
[Bb]arnet" r ver "[^\n\t ]+" "(mnader|r)	{printAGE(yytext,2);}
[Bb]arnet" r "([0-9]+|[0-9]+\-[0-9]+)" "(mnader|r)	{printAGE(yytext,2);}
[Bb]arnet" var "[0-9]+" "(mnader|r)(" och "[0-9]+" mnader")?	{printAGE(yytext,2);}
[Bb]arnen" "[1-9]" och "[1-9]" "r	{printAGE(yytext,1);}
[Bb]arn" "(under|ver)" "[^\n\t ]+" "(mnader|[a-z]*r|[a-z]*ret)	{printAGE(yytext,1);}
[Bb]arn" "[^\n\t ]+\-[^\n\t ]+" "(mnader|r)	{printAGE(yytext,1);}
(kvinnorna|mnnen|dem|[Kk]vinnan|[Pp]atienten|[Mm]annen|[Pp]appan|[Bb]arnet|[Pp]ersonen|han|hon|[Bb]arn|[vv]i)" "(var|r)" "(nu|under|ver|bara)" "({NUM}|[1-9][0-9]?)" r"(" gammal")?	{printAGE(yytext,2);}
(var|r)" "(jag|du|han|hon)" "(ver" "|snart" ")?[1-9][0-9]?" r"	{printAGE(yytext,2);}
([Kk]vinna|[Mm]an)" \, "[0-9]+" r"	{printAGE(yytext,2);}
fyll(da|a|de|t|er)" "[0-9]+" , "[0-9]+" r"	{printAGE(yytext,1);}
fyll(da|a|de|t|er)" "[^\n\t ]+" "[^\n\t ]+" "[0-9]+" r"	{printAGE(yytext,3);}
fyll(da|a|de|t|er)" "[^\n\t ]+" "[0-9]+" r"	{printAGE(yytext,2);}
fyll(da|a|de|t|er)" "[0-9]+" r"	{printAGE(yytext,1);}
"fyllda "[1-9][0-9]?(" r")?	{printAGE(yytext,1);}
[Vv]id" fyllda "[a-z]+" r"	{printAGE(yytext,2);}
([Hh]an|[Hh]on)" fyllde "[0-9]+(" r")?	{printAGE(yytext,2);}
(yngre|ldre)" n "[1-9][0-9]?(\-[1-9][0-9])?(" "mnader|" "veckor|" "r)?	{printAGE(yytext,0);}
([1-9][0-9]|[1-9][0-9]?\-[1-9][0-9]?)" rs"(lder|" lder")(n)?	{printAGE(yytext,0);}
[^\n\t ]*(spelare|flickor|unga|pojkar|elever|mnniskor|[Uu]ngdomar|[Kk]vinnor|[Pp]atienter|[Mm]n|[Bb]arn|vandrare)" "[1-9][0-9]?" till "[1-9][0-9]?" r"(slder|sldern|s" "ldern)?	{printAGE(yytext,1);}
[Tt]ill" "[1-9][0-9]?\-[1-9][0-9]?" r"(slder|sldern|s" "ldern)?	{printAGE(yytext,1);}
[^\n\t ]*(spelare|flickor|unga|pojkar|elever|mnniskor|[Uu]ngdomar|[Kk]vinnor|[Pp]atienter|[Mm]n|[Bb]arn|vandrare)" upp "(till|mot)" "[1-9][0-9]?(" r"|\-r)(slder|sldern|"s ldern")	{printAGE(yytext,1);}
[^\n\t ]*(spelare|lickor|unga|kvinna|ngon|sngare|pojkar|hion|dansare|anstllda|mnniskor|vljare|ngdomar|[Kk]vinnor|atienter|[Mm]n|[Bb]arn|vandrare|ungdom|jukskterskor|[Ee]lever)" mellan "([1-9][0-9]?|[0-9]\/[0-9])" "(till|och)" "[1-9][0-9]?" r"	{printAGE(yytext,2);}
[^\n\t ]*(lickor|[Pp]ojkar|[Kk]vinnor|[Mm]n|[Bb]arn)" "(emellan|mellan)" "[^\n ]+ton" "(till|och)" "[^\n ]+ton" r"	{printAGE(yytext,2);}
"mellan "[1-9][0-9]?" och "[1-9][0-9]?" r"("s "|s)lder(n)?	{printAGE(yytext,0);}
"lder ver "[0-9]+" r"	{printAGE(yytext,1);}
[]"ldrarna "[1-9][0-9]?\-[1-9][0-9]?(" r")?	{printAGE(yytext,1);}
[]"ldrarna "[1-9][0-9]?" mnader upp till "[1-9][0-9]?" r"	{printAGE(yytext,1);}
"lder av "[1-9][0-9]+" r"	{printAGE(yytext,1);}
[1-9][0-9]+" r eller yngre"	{printAGE(yytext,0);}
(till|[Rr]unt)" "[0-9\-]+rsldern	{printAGE(yytext,0);}
[Ii]" "[^\n\t ]+\-" \, "[^\n\t ]+rslder(n)?	{printAGE(yytext,0);}
(r|var|blev)" "(runt|under|ver|ungefr)" "({NUM}|[1-9][0-9]?)" r"	{printAGE(yytext,1);}
"deltagarna i genomsnitt "[1-9][0-9]+" r"	{printAGE(yytext,1);}
"\, "[1-9][0-9]?" r"	{printAGE(yytext,1);}
"de under "[^\n\t ]+" "r	{printAGE(yytext,0);}
[Tt]illten" frn "[^\n\t ]+" r"	{printAGE(yytext,1);}
vara" "{NUM}" eller "{NUM}" r"	{printAGE(yytext,1);}
(man|du|han|hon|jag)" "(r|fyller)" "(tjugu|[1-9][0-9]?)" r"	{printAGE(yytext,2);}
([Hh]an|[Hh]on)" fyller sina "[a-z]+" r"	{printAGE(yytext,3);}
fyllt" mitt tjugonde "r	{printAGE(yytext,2);}
"mste vara "(under" "|ver" ")?[1-9][0-9]?" r"	{printAGE(yytext,2);}
(blev|r)" "[1-9][0-9]?" r"	{printAGE(yytext,1);}
[Ll][Dd][Ee][Rr]" \: "[1-9][0-9]?\+?(" r")?	{printAGE(yytext,2);}
"vid "[^\n\t ]+" ung lder"	{printAGE(yytext,0);}
([Jj]ag" var"|"ldern var"|"yngsta r"|"mn r"|"yngsta var"|"ldsta r"|"ldsta var"|"r ju")(" "bara)?" "([0-9]+|{NUM})" "(mnader|r)	{printAGE(yytext,2);}
([Jj]ag" var"|"ldern var"|"yngsta r"|"mn r"|"yngsta var"|"ldsta r"|"ldsta var"|"r ju")(" "bara)?" "[0-9]+r	{printAGE(yytext,2);}
"r "[^\n\t ]+" r ldre"	{printAGE(yytext,1);}
"fall under "[1-9][0-9]" "r	{printAGE(yytext,1);}
([Rr]edan" ")?([Vv]id" cirka "|[Vv]id" "|[Ff]"rn noll till cirka ")?ett" "(halvt" ")?rs" "lder	{printAGE(yytext,0);}
"till "[^\n\t ]+" rs lder"	{printAGE(yytext,1);}
[]ldermssigt" r de mellan "[^\n\t ]+" och "[^\n\t ]+" r"	{printAGE(yytext,3);}
[^\n\t ]*(kvinna|[Bb]arn|mnniska|son|dotter|man)" \, bara "[1-9][0-9]?" r"	{printAGE(yytext,2);}
[Yy]ngre" ldersgrupper \( \< "[0-9][0-9]" r"	{printAGE(yytext,4);}
[^\n\t ]*(kvinna|[Bb]arn|mnniska|son|dotter|man|vinnor)" \, "[1-9][0-9\-]*" r"	{printAGE(yytext,2);}
[^\n\t ]*([Bb]arn|[Mm]n|[Kk]vinnor)" "(\&lt\;|\&gt\;|\<|\>)" "[1-9][0-9\-]*" r"	{printAGE(yytext,2);}
[^\n\t ]*([Bb]arn|mnniskor|mn|vinnor)" "[1-9][0-9\-]*" r"	{printAGE(yytext,1);}
[^\n\t ]*([Bb]arn|nniskor|vinnor|atienter|ngdomar)" \( "[1-9][0-9]?\-[1-9][0-9]?" r \)"	{printAGE(yytext,1);}
([Jj]ag|[Hh]an|[Hh]on|atienten)" var "[a-z]*ton(" r")?	{printAGE(yytext,2);}
([Hh]an|[Hh]on)" var "[0-9]+" "dagar	{printAGE(yytext,2);}
([Jj]ag|[Hh]an|[Hh]on)" var ca "[1-9][0-9]?(" r")?	{printAGE(yytext,2);}
([Jj]ag|[Hh]an|[Hh]on)" r "[1-9][0-9]?" r"	{printAGE(yytext,2);}
([Jj]ag|[Hh]an|[Hh]on)" r bara "[^\n\t ]+" r"	{printAGE(yytext,2);}
([Pp]atienten|[Mm]edelldern)" var "([0-9]+"  "[0-9]+" r"|[0-9]+[0-9])	{printAGE(yytext,2);}
([Jj]ag|[Hh]an|[Hh]on)" var "[^\n\t ]+" och ett "[^\n ]+" r gammal"	{printAGE(yytext,2);}
[Bb]arn" r "[1-9]" r och ett "[0-9]+" mnader"	{printAGE(yytext,2);}
[^\n\t ]*lder(n)?" bland dessa var "[0-9]+" "r	{printAGE(yytext,4);}
[^\n\t ]*lder(n)?" p "[0-9]+(\,[0-9])?" "r	{printAGE(yytext,2);}
[^\n\t ]*lder(n)?" "[0-9]+\.[0-9]+" "r	{printAGE(yytext,1);}
[Bb]land" dem "(ver|under)" "[1-9][0-9]" r"	{printAGE(yytext,2);}
[Pp]atienterna" var i genomsnitt "[1-9][0-9]" r"	{printAGE(yytext,2);}
(kvinnor|mnnen|[Pp]atienter|[Bb]arn|[Pp]ersoner)(na)?" "[0-9]+" r"(" eller "ldre)?	{printAGE(yytext,1);}
"som idag r "[0-9]+" r"	{printAGE(yytext,3);}
"mn under "[1-9][0-9]" \."	{int i=4; printf("mn <NUMEX TYPE=\"MSR\" SBT=\"AGE\">"); for(;yytext[i]!=' '; putchar(yytext[i++])); putchar(' '); i++; for(;yytext[i]!=' '; putchar(yytext[i++])); printf("</NUMEX> .");}
[1-9][0-9]?" r ldre"	{int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"AGE\">"); for(;yytext[i]!=' '; putchar(yytext[i++])); putchar(' '); i++; for(;yytext[i]!=' '; putchar(yytext[i++])); printf("</NUMEX> ldre");}
[Uu]nder" sina frsta "[^\n\t ]+" dagar i livet"	{int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"AGE\">"); for(;yytext[i]!=' '; putchar(yytext[i++])); putchar(' '); i++; for(;yytext[i]!=' '; putchar(yytext[i++])); putchar(' '); i++; for(;yytext[i]!=' '; putchar(yytext[i++])); putchar(' '); i++; for(;yytext[i]!=' '; putchar(yytext[i++])); putchar(' '); i++;for(;yytext[i]!=' '; putchar(yytext[i++])); printf("</NUMEX>"); for(;i<yyleng;putchar(yytext[i++]));}
([Pp]nr" "|[Pp]ersonnummer" ")?[0-9][0-9][0-9][0-9][0-9][0-9]\-[0-9][0-9][0-9][0-9]	{printAGE(yytext,0);}
[Ff]"rn "[1-9][0-9]?" r och uppt"	{printAGE(yytext,0);}
[1-9][0-9]?" r och ldre"	{printAGE(yytext,0);}
[Ll]"ivet efter "[^\n\t ]+tio	{printAGE(yytext,2);}
[1-9][0-9]?\-[1-9][0-9]?"\-r gammal"	{printAGE(yytext,0);}
[^\n\t ]*"ldersgruppen "[0-9]+\-[0-9]+(\-r|" r")?	{printAGE(yytext,0);}
[^\n\t ]*"ldersgruppen "[0-9]+" mnader till "[0-9]+" r"	{printAGE(yytext,0);}
[^\n\t ]*lder(n)?" "[0-9]+" \( "[0-9]+\-[0-9]+" \) r"	{printAGE(yytext,0);}
[^\n\t ]*(vuxna|ldern|efolkningen)" "[0-9]"\-"[0-9]+" r"	{printAGE(yytext,1);}
efolkning" r "[1-9][0-9]" r eller mer"	{printAGE(yytext,2);}
[^\n\t ]*"ldern r "[0-9]+\.[0-9]+	{printAGE(yytext,2);}
[^\n\t ]*(lickor|ojkar|nniskor|ngdomar|vinnor|atienter|[Mm]n|[Bb]arn)" \( "[0-9]+\-[0-9]+" \) r"	{printAGE(yytext,1);}
[^\n\t ]*(lickor|ojkar|nniskor|ngdomar|[Kk]vinnor|[Pp]atienter|[Mm]n|[Bb]arn)" \, "[0-9]+\-[0-9]+" r"	{printAGE(yytext,2);}
[^\n\t ]*ersoner" mellan "[0-9]+" och "[0-9]+(" "r)?	{printAGE(yytext,1);}
[Bb]"arn mellan "[^\n ]+" mnader och "[0-9]+" "r	{printAGE(yytext,1);}
[Ll]ivslngd" \: "[0-9]+\.[0-9]+" r"	{printAGE(yytext,2);}
"De var mellan "[0-9]+" och "[0-9]+" r"	{printAGE(yytext,2);}
[Bb]arn" "[^\n\t ]+" och "[^\n\t ]+" "(mnader|r)	{printAGE(yytext,1);}
[1-9][0-9]?" years old"	{printAGE(yytext,0);}
(dotter|son|tjej|syster|bror)" som r "([0-9][0-9]?|tre|fyra|fem)" r"	{printAGE(yytext,3);}
(flicka|pojke|tjej|kille)" p "[0-9][0-9]?" r"	{printAGE(yytext,2);}
[Pp]ersoner" \( "[0-9][0-9]" r"	{printAGE(yytext,2);}
[Pp]ersoner" \> "[0-9][0-9]" r"	{printAGE(yytext,2);}
"nu r "[0-9][0-9]" r"	{printAGE(yytext,2);}
"med sina "[0-9][0-9]" "(r|mnader)	{printAGE(yytext,2);}
[^\n\t ]+" och ett halvt rslder"(n)?	{printAGE(yytext,0);}
[0-9]\-[0-9]" rsldern"	{printAGE(yytext,0);}
[Ii]" "([a-z]*tio|tre|fem|sex|sju|tta|nio|tv)rslder(n)?	{printAGE(yytext,0);}
[0-9]+\-"rs\-ldern"	{printAGE(yytext,0);}
[^\n ]+" och ett halvt respektive drygt "[^\n ]+" r"	{printAGE(yytext,0);}
(kvinnor|mn)" som "[a-z]+" r "[1-9][0-9]" "r	{printAGE(yytext,4);}
[^\n ]+"ldern ligger p "[0-9][0-9]" r"	{printAGE(yytext,3);}
[^\n ]+"lder varierade frn "[0-9][0-9]?" till "[0-9][0-9]?" r"	{printAGE(yytext,2);}
[SsRr]edan" "[0-9]+rs" "lder(n)?	{printAGE(yytext,0);}
[Vv]ar" "[a-z]+e" svensk ver "[1-9][0-9]	{printAGE(yytext,3);}
(barn|baby)" som r ngra mnader"(" gammal")?	{printAGE(yytext,3);}
[Bb]arnets" frsta "[a-z]+" mnader"	{printAGE(yytext,1);}
[Bb]arn" under "[1-9][0-9]?" mnaders lder"	{printAGE(yytext,1);}
"gruppen "[1-9][0-9]?" \- "[1-9][0-9]?" r"	{printAGE(yytext,1);}
"gruppen "[1-9][0-9]?"\-"[1-9][0-9]?" r"	{printAGE(yytext,1);}
"r "[1-9][0-9]r	{printAGE(yytext,1);}
[]lder" "[1-9][0-9]?" och drver"	{printAGE(yytext,1);}
[Vv]id" "[a-za0-9]+" dagars "lder	{printAGE(yytext,0);}
"fr mnnen "[1-9][0-9]?" r"	{printAGE(yytext,2);}
[Uu]nder" livets frsta "[^\n ]+" mnader"	{printAGE(yytext,0);}
[Kk]vinnor" "(under|ver)" "[2-8][0-9]	{printAGE(yytext,1);}
[^\n\t ]*(lickor|ojkar|elever|ngdomar|[Kk]vinnor|atienter|[Mm]n|[Bb]arn)" "[1-9][0-9]?" och "[1-9][0-9]?" r"	{printAGE(yytext,1);}
[Bb]arn" mindre n ungefr "[1-9]" r"	{printAGE(yytext,1);}
[Mm]edianlder" "[1-9]" r"	{printAGE(yytext,1);}
[Uu]nder" det "[^\n ]+[ae]" levnadsret"	{printAGE(yytext,0);}
[Bb]arn" ( < "[1-9]" r"	{printAGE(yytext,3);}
[Ss]ina" "{NUM}" r"	{printAGE(yytext,1);}
([Jj]ag|[Hh]an|[Hh]on)" var d "{NUM}" r"	{printAGE(yytext,3);}
	/* MOD (Jyrki Niemi): Fixed regexp:
	([Jj]ag|[Hh]an|[Hh]on)(" r ju "blott|" endast")" "(tjugu|{NUM})" r"	{printAGE(yytext,3);}
	*/
([Jj]ag|[Hh]an|[Hh]on)" r ju "(blott|endast)" "(tjugu|{NUM})" r"	{printAGE(yytext,3);}
([Jj]ag|[Hh]an|[Hh]on[Uu]ngen)" var redan nra "[^\n ]*tio" "r	{printAGE(yytext,3);}
"vilja vara "[a-z]+(tv|tre|fyra|fem|sex|sju|tta|nio|ett)" "r	{printAGE(yytext,2);}
(mamma|pappa|mormor|farmor)" som r "[1-9][0-9]	{printAGE(yytext,3);}
[Rr]edan" i "[a-z]+rsldern	{printAGE(yytext,0);}
[Uu]nder" "[^\n ]*ungdomstiden	{printAGE(yytext,0);}
[Uu]nder" "[^\n ]*ungdomsren	{printAGE(yytext,0);}
[Ii]" "[0-9]+\-" till "[0-9]+"\-rslder"(n)?	{printAGE(yytext,0);}
[Mm]ellan" sen tonrsperiod och "[0-9]+"\-rs lder"(n)?	{printAGE(yytext,0);}
[Ii]" ldersintervallen ver "[0-9]+" r"	{printAGE(yytext,2);}
[Bb]arn" \< "[0-9]+" r"	{printAGE(yytext,2);}
[Bb]arn" "[0-9]+" \- "[0-9]+" r"	{printAGE(yytext,1);}
[Yy]ngre" n "(tre|fyra|fem|tv)" "r	{printAGE(yytext,0);}
[]ldersfrdelning" var "[0-9]+\-[0-9]+" "r	{printAGE(yytext,2);}
[]ldersfrdelning" "[0-9]+\-[0-9]+" "r	{printAGE(yytext,1);}
[Dd]u" ver "[0-9][0-9]	{printAGE(yytext,1);}
[Ii]" ldrarna under "[0-9][0-9]" r"	{printAGE(yytext,2);}
[Ii]" "[a-z]+\-" och "[^\n\< ]+ldern	{printAGE(yytext,0);}
[0-9]+\-dagar" gammal"t?	{printAGE(yytext,0);}
[Uu]ngefr" "[^\n ]+" dagar gammal"t?	{printAGE(yytext,0);}
[]ldersklasserna" "[0-9]+" - "[0-9]+" r"	{printAGE(yytext,1);}
"vid sin dd "{NUM}" r"	{printAGE(yytext,3);}
[Ff]rn" "[^\n ]+rsldern	{printAGE(yytext,0);}
[Mm]edianldern" "(r|var)" "[0-9][0-9]	{printAGE(yytext,2);}
"ett r "[0-9][0-9]?" mnader"	{printAGE(yytext,2);}
	/* WEB */
(mms|http|ftp|https)\:\/\/[^\n\.\, ]+\.[^\n\t ]+	{printWEB(yytext,0);}
(www[1-4]|www)\.[^\n\.\, ]+\.[^\n\t ]+	{printWEB(yytext,0);}
	/* (http\:\/\/|ftp\:\/\/)?www\.[a-z0-9\-]+(\.[a-z0-9\-\/\?]+)*\.[a-z][a-z][a-z]?[a-z]?	{printWEB(yytext,0);}*/
[a-zA-Z0-9\-]+\.[a-zA-Z0-9\-\_]+\.[a-zA-Z0-9\-]+\@[a-zA-Z0-9]+\.[a-zA-Z0-9]+(\.[a-zA-Z0-9]+)*	{printWEB(yytext,0);}
[a-zA-Z0-9\-]+\.[a-zA-Z0-9\-\_]+\@[a-zA-Z0-9\-]+\.[a-zA-Z0-9]+(\.[a-zA-Z0-9]+)*	{printWEB(yytext,0);}
[a-zA-Z0-9][a-zA-Z0-9\-\_]+\@[a-zA-Z0-9][a-zA-Z0-9\-]+\.[a-zA-Z][a-zA-Z0-9]+(\.[a-zA-Z0-9]+)*	{printWEB(yytext,0);}
[^\n\.\,\<\> ][^\n\.\,\<\> ]+\.(com|se|org|net|info)	{printWEB(yytext,0);}
[a-zA-Z0-9\-]+\.[a-zA-Z0-9\-\_]+\(at\)[a-zA-Z0-9\-]+\.[a-zA-Z0-9]+(\.[a-zA-Z0-9]+)*	{printWEB(yytext,0);}
	/* Capacity and Volume Unit - CVU */
	/*? after the ml/? */
[0-9]+(\,[0-9])?" "kvadrat\-cm	{printCVU(yytext,0);}
([Mm]inst" "|[Uu]ngefr" "|[Oo]mkring" "|[Dd]rygt" "|[Cc]irka" "|dryga" ")?[0-9]+([\,\.0-9\_]+|" "[0-9]+)?(" "miljoner|" "miljarder)?" "(mm3|cm3|m3|km3|kubik[^\n\t ]*meter|[^\n\t ]g\/m3|g\/m3|[^\n\t ]g\/[cm]m3|g\/[cm]m3)	{printCVU(yytext,0);}
([Uu]"ngefr "|[Oo]"mkring "|[Dd]"rygt "|[Mm]er" n "|[Cc]irka" "|[Mm]inst" "|frn" ")?([Nn]"gra f"|[Ee]n" "kvarts|[Ee]tt" "halvt|[Ee]tt" "halv|[Dd]"rygt en"|[Tt]v|[Tt]re|[Ff]yra|[Ff]em|[Ss]ex|sju|tta|nio|tio|tolv|[0-9]*|[0-9]+|[0-9]+\-tals|[0-9]+" "[0-9]+\/[0-9]+|[0-9]+\/[0-9]+|[0-9]+\-[0-9]+\,[0-9]+|[0-9]+\.[0-9]+|[0-9]+\,[0-9]+"\-"[0-9]+\,[0-9]+|[0-9]+\,[0-9]+" till "[0-9]+\,[0-9]+|[0-9]+\,[0-9]+|[0-9]+\-[0-9]+|[0-9]+" "[0-9]+|[0-9]+\,[0-9]+\-[0-9]+|{NUM}" till "{NUM})" "(miljon" "|miljoner" "|miljarder" ")?([^\n\t ]+[^\n l]liter|liter)	{printCVU(yytext,0);}
([Mm]inst" "|[Uu]ngefr" "|[Oo]mkring" "|[Dd]rygt" "|[Cc]irka" "|dryga" "|[Mm]indre" n ")en" "("halv ")?liter	{printCVU(yytext,0);}
([0-9]+\-[0-9]+|[0-9]+\/[0-9]+|[0-9]+|[1-9]+" \, "[0-9]+|[1-9]+\,[0-9]+)" "(msk|krm)	{printCVU(yytext,0);}
([Mm]ellan" "[0-9]+" och"|[Mm]er" n "|[Cc]irka" "|[Mm]inst" ")?([Nn]"gra f"|[Ee]n" "kvarts|[Ee]tt" "halvt|[Ee]tt" "halv|[Dd]"rygt en"|[Tt]v|[Tt]re|[Ff]yra|[Ff]em|[Ss]ex|sju|tta|nio|tio|tolv|[0-9]*|[0-9]+|[0-9]+\-tals|[0-9]+" "[0-9]+\/[0-9]+|[0-9]+\/[0-9]+|[0-9]+" "[0-9]+\/[0-9\-]+|[0-9]+\,[0-9]+"\-"[0-9]+\,[0-9]+|[0-9]+\.[0-9]+|[0-9]+\,[0-9]+|[0-9]+\-[0-9]+|[0-9]+" "[0-9]+)" "(miljon" "|miljoner" "|miljarder" ")?(m[Ll]|dl|cl|promille)	{printCVU(yytext,0);}
[0-9]+\,[0-9]+" \( "[0-9\,]+\-[0-9\,]+" \) g\/l"	{printCVU(yytext,0);}
[0-9]\,[0-9]l" "	{printf("<NUMEX TYPE=\"MSR\" SBT=\"CVU\">"); putchar(yytext[0]); putchar(yytext[1]); putchar(yytext[2]); printf("l</NUMEX> ");}
[0-9]\,[0-9]" lit "	{printf("<NUMEX TYPE=\"MSR\" SBT=\"CVU\">"); putchar(yytext[0]); putchar(yytext[1]); putchar(yytext[2]); printf(" lit</NUMEX> ");}
([Uu]"nder "|[]"ver "|"\< "[0-9]|[0-9]\,[0-9]+" till "|[0-9]" till "|[0-9]+\,[0-9\-]+" respektive "|\-)?([0-9][0-9\,\-]+[0-9]+|[0-9\-]+" "[0-9\-]+|[1-9]" \, "[0-9]|[0-9]+|[0-9]+\,[0-9\-]+|[0-9]+\.[0-9]+|{NUM})" "mg\/mmol	{printCVU(yytext,0);}
([Gg]enomsnitt" ")?([Uu]nder" "|[]"ver "|"\< "[0-9]|[0-9]\,[0-9]+" till "|[0-9]" till "|[Mm]"ellan "[0-9]+" och "|[Mm]"ellan "[0-9]+\,[0-9\-]+" och "|[0-9]+\,[0-9\-]+" respektive "|\-)?([0-9][0-9\,\-]+[0-9]+|[0-9]+" \- "[0-9]+|[0-9\-]+" "[0-9\-]+|[1-9]" \, "[0-9]|[0-9]+|[0-9]+\,[0-9\-]+|[0-9]+\.[0-9]+|{NUM}|[0-9]+\?[0-9]+)" "(umol|nmol|pmol|milimol|millimol|mikromol|pmol|mmol|lmol|mol|g|nanogram)(\/[Ss]|\/m[Ll]|\/d[Ll]|\/[Ll]|\/[Ll]iter|" per liter"|" per milliliter")	{printCVU(yytext,0);}
([Gg]enomsnitt" ")?([Uu]nder" "|[]"ver "|"\< "[0-9]|[0-9]\,[0-9]+" till "|[0-9]" till "|[Mm]"ellan "[0-9]+" och "|[Mm]"ellan "[0-9]+\,[0-9\-]+" och "|[0-9]+\,[0-9\-]+" respektive "|\-)?([0-9][0-9\,\-]+[0-9]+|[0-9\-]+" "[0-9\-]+|[1-9]" \, "[0-9]|[0-9]+|[0-9]+\,[0-9\-]+|[0-9]+\.[0-9]+|[0-9]+|{NUM}|[0-9]+\?[0-9]+)(umol|nmol|pmol|milimol|millimol|mikromol|pmol|mmol|lmol|mol|g|nanogram)(\/[Ss]|\/m[Ll]|\/d[Ll]|\/[Ll]|\/[Ll]iter)	{printCVU(yytext,0);}
(under" "|ver" "|[0-9]+\,[0-9]+" till "|[0-9]+" till ")?([0-9]+x[0-9]+|[0-9]+\/[0-9\,]+|[0-9\-]+" "[0-9\-]+|[0-9]+" \- "[0-9]+|[1-9]+" \, "[0-9]+|[0-9]+|[0-9]+\,[0-9]+|[0-9]+\-[0-9]+|[0-9]+\,[0-9]+" \- "[0-9]+\,[0-9\-]+)" "(mg|IU|mikrog|g|m[Ll]|mikrogram|ggr|gram)(\/g|\/mg|\/m[Ll]|\/L|\/liter|" per liter"|" per kg")	{printCVU(yytext,0);}
" 1g "	{printf(" <NUMEX TYPE=\"MSR\" SBT=\"CVU\">1g</NUMEX> ");}
([Uu]"nder "|[]"ver "|"\< ")?([0-9]+\,[0-9]+" \- "[0-9]+\,[0-9\-]+|[0-9]+\,[0-9]+\-[0-9]+\,[0-9\-]+|[0-9\-]+" "[0-9\-]+|[1-9]" \, "[0-9]|[0-9]+|[0-9]+\,[0-9\-]+|[0-9]+\.[0-9]+|[0-9]+\,[0-9\-]+" respektive "[0-9]+\,[0-9\-]+)" "(milimol|millimol|mikromol|mmol|lmol|nanogram)(\/m[Ll]|\/d[Ll]|\/[Ll]|\/[Ll]iter|" per liter"|" per milliliter")?	{printCVU(yytext,0);}
([0-9]+" ")?[0-9]+" fat "	{int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"CVU\">"); 
	for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> ");}
" 1g "	{printf(" <NUMEX TYPE=\"MSR\" SBT=\"CVU\">1g</NUMEX> ");}
[0-9]+\,[0-9]+ml	{printCVU(yytext,0);}
[0-9]+\,[0-9]+" m g\/l"	{printCVU(yytext,0);}
[0-9]+" m g\/l"	{printCVU(yytext,0);}
	/* Weight and Mass Unit - WMU */
vikt" "[0-9\,]+" g\."	{int i=5; printf("vikt <NUMEX TYPE=\"MSR\" SBT=\"WMU\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</NUMEX>");}
vgande" "[0-9\,]+" g\."	{int i=8; printf("vgande <NUMEX TYPE=\"MSR\" SBT=\"WMU\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</NUMEX>");}
([Mm]er" n "|[Cc]irka" "|[Mm]inst" ")?([Nn]"rmare "|[Ff]"rn "{NUM}" till "[^\n\t ]+|[Nn]"gra f"|[Ee]n" "kvarts|[Ee]tt" "halvt|[Ee]tt" "halv|Ett|[Dd]"rygt en"|[Tt]v|[Tt]re|[Ff]yra|[Ff]em|[Ss]ex|sju|tta|nio|[^\n\t ]*tio|tolv|[0-9]*|[0-9]+|[0-9]+\-tals|[0-9]+" "[0-9]+\/[0-9]+|[0-9]+\/[0-9]+|[0-9]+\.[0-9]+|[0-9]+\,[0-9]+" och "[0-9]+\,[0-9]+|[0-9]+\,[0-9]+|[0-9]+\-[0-9]+|[Mm]"ellan "[0-9]+" och "[0-9]+|[0-9]+" respektive "[0-9]+|[0-9]+" eller "[0-9]+|[0-9]+\,[0-9]+\-[0-9]+|[0-9]+\/[0-9]+\/[0-9]+|[0-9]+" "[0-9]+|[0-9]+\.[0-9]+" eller "[0-9]+\.[0-9]+|[0-9]+" till "[0-9]+)" "(miljon" "|miljoner" "|miljarder" ")?(pounds|kilona|kilo|[Kk]ilogram|mikrog|mikrogram|gram|[tm]sk|kryddmtt|milligram|[Kk]g|kg\+|ton|mg|mikrog|g|l)	{printWMU(yytext,0);}
([Mm]er" n "|[Cc]irka" "|[Mm]inst" "|ca" "|[Nn]"rmare ")?([Ee]tt" "halvt|[Ee]tt" "halv|tv|tre|fyra|fem|sex|sju|tta|nio|[^\n\t ]*tio|tolv|[0-9]+|[0-9]+\/[0-9]+|[0-9]+\.[0-9]+|[0-9]+\,[0-9]+|[0-9]+\-[0-9]+)" "(miljoner" "|miljarder" "|miljondels" ")?gram	{printWMU(yytext,0);}
([Mm]er" n "|[Cc]irka" "|[Mm]inst" ")?([Nn]"gra f"|[Ee]n" "kvarts|[Ee]tt" "halvt|[Ee]tt" "halv|[Dd]"rygt en"|[Tt]v|[Tt]re|[Ff]yra|[Ff]em|[Ss]ex|sju|tta|nio|tio|tolv|[0-9]*|[0-9]+|[0-9]+\-tals|[0-9]+" "[0-9]+\/[0-9]+|[0-9]+\/[0-9]+|[0-9]+\.[0-9]+|[0-9]+\,[0-9]+|[0-9]+\-[0-9]+|[0-9]+" "[0-9]+)" "(miljon" "|miljoner" "|miljarder" ")?g" "	{int i=0;printf("<NUMEX TYPE=\"MSR\" SBT=\"WMU\">"); for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> "); }
[0-9]+[0-9\_\,\-]+g" "	{int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"WMU\">"); for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> "); }
[0-9\_]+g" "	{int i=0; printf("<NUMEX TYPE=\"MSR\" SBT=\"WMU\">"); for(;i<yyleng-1;putchar(yytext[i++])); printf("</NUMEX> "); }
([0-9]+"\,"|[0-9]+\,[0-9]+\-)?[0-9]+([km]g|g|gram)	{printWMU(yytext,0);}
([0-9]+\.[0-9]+|[0-9]+)\-([0-9]+\.[0-9]+|[0-9]+)mg	{printWMU(yytext,0);}
([0-9]+\-)?[0-9]+[km]g\/(kg|i)	{printXXX(yytext,0);}
(under" "|ver" "|[0-9]\,[0-9]" vs ")?([0-9]+x[0-9]+|[0-9]+\/[0-9\,]+|[0-9\-]+" "[0-9\-]+|[0-9]+" \- "[0-9]+|[1-9]+" \, "[0-9]+|[0-9]+|[0-9]+\,[0-9]+|[0-9]+\-[0-9]+)" "(mg|IE|IU|mikrog|g|m[lL]|mikrogram|ggr)(\/minut|\/min|\/m2|" "[Hh][Gg])?	{printXXX(yytext,0);}
[0-9]+[pm][lg](\/timme|\/ml|\/mL|\/dos|\/m2|\/dagl|\/dygn|\/L)?	{printXXX(yytext,0);}
pH(\-vrde)?" "(omkring|under|ver|p)" "[0-9]+([\-\,0-9]+)?	{printXXX(yytext,1);}
pH" "[0-9]+(\.[0-9])?	{printXXX(yytext,1);}
[0-9]+" \( mg \) ml\/l"	{printXXX(yytext,0);}
(ISBN|ISSN)" "("\: ")?[0-9][0-9]*" "[0-9]+" "[0-9]+" "[0-9]+	{printXXX(yytext,0);}
(ISBN|ISSN)" "("\: ")?[0-9][0-9](\-[0-9\-\/]+)+(\-X)?(" \- "[0-9]+)?	{printXXX(yytext,0);}
(ISBN|ISSN)" "("\: ")?[0-9][0-9]*"\-"[0-9\-]+	{printXXX(yytext,0);}
("P\.O\."|"P\. O\.")" Box "[0-9]+	{printXXX(yytext,0);}
\n	{ECHO;}
.	{ECHO;}
%%
int printXXX (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"XXX\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"XXX\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"XXX\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printMSU (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"MSU\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"MSU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"MSU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printFRQ (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"FRQ\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"FRQ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"FRQ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printCVU (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"CVU\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"CVU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"CVU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printDEN (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"DNS\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"DNS\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"DNS\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printDST (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"DST\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"DST\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"DST\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printWMU (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"WMU\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"WMU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"WMU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printVLM (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"VLM\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"VLM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"VLM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printDGR (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"DGR\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"DGR\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"DGR\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printPRC (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"PRC\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"PRC\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"PRC\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printCRD (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"CRD\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"CRD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"CRD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printELU (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"ELU\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"ELU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"ELU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printINX (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"INX\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"INX\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"INX\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printTMP (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"TMP\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"TMP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"TMP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printPSS (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"PSS\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"PSS\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"PSS\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"PSS\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printSPD (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"SPD\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"SPD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"SPD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printDSG (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"DSG\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"DSG\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"DSG\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printTEL (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"TEL\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"TEL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"TEL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printAGE (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"AGE\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"AGE\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"AGE\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"AGE\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"AGE\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printCUR (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"CUR\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"CUR\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"CUR\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printLST (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"LST\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"LST\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"LST\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printCMU (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"CMU\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"CMU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"CMU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
int printWEB (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<NUMEX TYPE=\"MSR\" SBT=\"WEB\">%s</NUMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"WEB\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <NUMEX TYPE=\"MSR\" SBT=\"WEB\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</NUMEX>");}
return(1);
}
main( argc, argv )
int argc;
char **argv;	
{	
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  
  yylex(); return(0);
}
