/*
	File: LocWsp.ll
	Annotation: <ENAMEX TYPE="LOC" SBT="AST|STR|GPL|PPL|FNC"><MTH="MWE"/>
	Author: Dimitrios Kokkinakis
	version: 110406
*/
%{
%}
U	[\101-\132\300-\335]
%{
  int printPPL  (char  *a);
  int printGPL  (char  *a);
  int printFNC  (char  *a);
  int printSTR  (char  *a);
  int printASTR (char  *a);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|TRM)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDD|MDI|MDO|MDD|MDC|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
	/* MULTI AREAS - GPL */
([Uu]nder|[]ver|i|med|om|[Ss]jn|till|[]n|nra|sig|ndde|n|ngs|kring|[Rr]unt|[Ff]rn|ver|[Vv]id|utmed|tanfr|p|mot)" "{U}[^\n ]+s" "[a-z]*(yta|tspets|dspets|kust|kusttrakter|strnder)	{int i=0; for(;yytext[i]!=' ';putchar(yytext[i++])); i++; printf(" <ENAMEX TYPE=\"LOC\" SBT=\"GPL\">"); for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
("Nordre lv"|"Finska "viken|"Vanda ")s" "[^\n ]*mynning(en|ar)?	{printGPL(yytext);}
{U}[^\n ]+s" "(nor|sd|vst|vnst|st)ra" "strand	{printGPL(yytext);}
{U}[^\n ]+(bukten|fjorden|sundet|bcken|n|floden|sjn|viken|havet|sund|nden|lven)s" "[^\n ]*(mynning|djup|botten|strand|inre|sida|delta|strnder)(en)?	{printGPL(yytext);}
(Vttern|Rhen|Nilen|Jenisej|Themsen|Bosporen|Mlaren|Gange|Tibern|Copacabana|Vnern|Donau|Volga|"Rda "[Hh]avet)s" "([^\n ]*mynning|strand|[^\n ]+sida)(en)?	{printGPL(yytext);}
"Archipilago de "{U}[^\n ]+	{printGPL(yytext);}
(Afrika|"Miami Beach")"s "[^\n ]+spets	{printGPL(yytext);}
(Stora|Eriks|Sl|Vejle)" "[^\n ]*[Ff]jord(en)?	{printGPL(yytext);}
(Nam|Chao|St)" "[^\n ]+\-floden	{printGPL(yytext);}
(Trosa|Lule|"S:t Annas"|Karlstads|Blekinge|{U}[^\n ]+tlands|{U}[^\n ]+holms|{U}[^\n ]+borgs|{U}[^\n ]+bottens|Pellinge|Bohuslns)(" sdra"|" norra")?" "[^\n ]*skrgrd	{printGPL(yytext);}
[^\n ]+nska" "([Rr]iviera|[Bb]ukte)n	{printGPL(yytext);}
(Anderna|Everest|Olympo|Fuji|{U}[^\n ]+berget|{U}[^\n ]+fjll|Himalaya|"Sierra Grande"|Pyrenerna|Merapi)s" "([^\n ]+" ")?(fot|topp|fauna|sluttning|massiv)[a-z]*	{printGPL(yytext);}
"Costa "(Blanca|Brava|Verde|[Dd]el" "Sud|[Dd]el" "Sol)(\-kust[a-z]*)?	{printGPL(yytext);}
{U}[^\n ]+s" "[^\n ]*(iga|norra|sdra|stra|vstra|ligaste)" kust"(bygd)?	{printGPL(yytext);}
(Spanien|Florida|Alaska|"Norra Amerika"|USA\:)"s "[^\n ]+stkust	{printGPL(yytext);}
[^\n ]+(ets|ska)" "(Guld|Medelhavs|Atlant)kust(en)?	{printGPL(yytext);}
({U}[^\n ]+sk|Svart|Still|[Ss]dr|[]str|[Nn]orr|[Vv]str)a" "[^\n ]*kust(en)?	{printGPL(yytext);}
[Ff]reningen" "Torsvikens" "[Nn]aturreservat	{ECHO;}
(Vst|st|Sd|Nor)"ra "[^\n ]+s" "[^\n ]+reservat	{printFNC(yytext);}
(Nacka|Tyresta|Flommen|Risveden|Punkaharju)(s)?" "[^\n ]+reservat	{printFNC(yytext);}
{U}[^\n ]+(unds|ns|bergs|alus|ska|ans)" "[^\n ]+reservat	{printFNC(yytext);}
"Playa "d(" \'"|e" "las|el)" "{U}[^\n ]+	{printGPL(yytext);}
{U}[^\n ]+s" "[^\n ]*(norra|sdra|stra|vstra|ligaste)" udde"	{printGPL(yytext);}
(West" "|North" ")?(Venice|Pebble|Vero|Laguna|Palm|Long|Daytona|Miami|"Santa Monica"|Bondi|Myrtle)" "Beach	{printGPL(yytext);}
Cap[a-z]*" "(Aguhlas|Aghulas|Cod|Yakatage|Verde|Canaveral)	{printGPL(yytext);}
(Borneo|Amazona|Kongo|"Costa Rica")"s regnskog"(ar|en)	{printGPL(yytext);}
(Lill|Stor|{U}[^\n ]+sk|Klar)a" "[Ss]j(n)?	{printGPL(yytext);}
(Mexiko|Kongo|Kampuchea|Kambodja|Panama|Amazona|Guyana|Colombia|Costa" "Rica|Sri" "Lanka|Burma|Borneo|Sumatra|Peru|Guatemala|Bolivia|Vietnam|Sydamerika|Sierra" "Leone)s" "[Dd]jung(el|ler)	{printGPL(yytext);}
{U}[^\n ]+vikens" "[Ll]agun	{printGPL(yytext);}
(Sdr|Pontinsk)a" "trske(t|n)	{printGPL(yytext);}
({U}[^\n ]+bergs|{U}[^\n ]+viks)" "[Kk]ile	{printGPL(yytext);}
	/* MULTI COUNTRIES & TERRITORIES */
"New England Patriots"	{ECHO;}
([^\n ]+"ska ")?([Ff]jrran|Mellersta)" stern"	{printPPL(yytext);}
"Australiens "[^\n ]+ra" Territorium"	{printPPL(yytext);}
S(t|t\.)" Vincent "([Aa]nd" "[Tt]he|[Aa]nd|och|\&)" Grenadinerna"	{printPPL(yytext);}
S[^\n ]+" "(Kitts|Christopher)" "[^\n ]" Nevis"	{printPPL(yytext);}
(Fulton|Market|"St Martin"|Apollo|Queens|Fox|Guilgud|Goldwyn|Alexandra|Ed" "Sullivan|Abbey|"Royal Court"|Haymarket)" Theatre"	{printFNC(yytext);}
S(\:t|t|t\.)" "Helena\-{U}	{ECHO;}
S(\:t|t|t\.|aint)" "(Moritz|Barthelemy|Rmy|Christopher|Eustatius|Helena|Kitts|Lucia|Martin|Vincent)	{printPPL(yytext);}
("Three Mile"|Norfolk|Cayman|Christmas|Cook|"U\.S\. Virgin"|"Phi Phi")" Island"(s)?	{printPPL(yytext);}
"Demokratiska "[^\n ]*[Rr]epubliken" "(Kongo|Korea)	{printPPL(yytext);}
"Hong Kong Tele"	{ECHO;}
"Hong Kong"	{printPPL(yytext);}
"Isle "[Oo]"f "(Man|Wight)	{printPPL(yytext);}
([Bb]alear|[Kk]apverd)iska" "[]arna	{printPPL(yytext);}
(Saron|Jon|[Bb]alear|[Kk]apverd|[Bb]ritt)iska" "[^\n ]*[]arna	{printPPL(yytext);}
N(ew|ya)" "([CK]aledonien|Ze[ea]land)	{printPPL(yytext);}
("Papua ")?"Nya Guinea"	{printPPL(yytext);}
Republik[a-z]*" "(Srpska|Slovenia)	{printPPL(yytext);}
"San Marino "(GP|Grand)	{ECHO;}
"San Marino"	{printPPL(yytext);}
S[a]o" Tom "(\&|och)" "Pr[a-z]+	{printPPL(yytext);}
S[a]o" Tom"	{printPPL(yytext);}
("Czech Republic"|"Vstra Samoa"|"Sierra Leone"|"Sri Lanka"|"Suomi Finland")	{printPPL(yytext);}
"Trinidad "(\&|och)" Tobago"	{printPPL(yytext);}
("Kap "Verde|"Turks \& Caicos")(arna|\-arna)?	{printPPL(yytext);}
{U}[^\n ]+iska" "Folkrepubliken" "{U}[^\n ]+	{printPPL(yytext);}
("Tyska "[Dd]emokrati|Centralafrikan|Jugoslavi|Dominikan)ska" "[^\n ]*[Rr]epublik(en)?	{printPPL(yytext);}
	/* MULTI SWE CITIES*/
("Gamla "[Ss]tans|{U}[^\n ]+fors)" "(grnder|torg|[Bb]ryggeri|bryggerier|[^\n ]+bana)	{printFNC(yytext);}
(Skisserna|Bohusln|Uppland|Jazzen|Folken|{U}[^\n ]+land|{U}[^\n ]+grd|Skagen)s" "[^\n ]*museum	{printFNC(yytext);}
"Stora "(Ryd|Torp|Lundby|Hga|Holm|Levene|Skedvi|Hllungen|Dammen|Mellby|Sundby|Vika|Viken|Haga)	{printPPL(yytext);}
Lilla" "(Torp|Bommen|London)(\-omrdet)?	{printPPL(yytext);}
K(gl|ungliga)" Huvudstaden"	{printPPL(yytext);}
({U}[^\n ]+berg|Lundbrunn)s" "[Kk]urort	{printPPL(yytext);}
"Vstra "{U}[^\n ]+" "[Ll]n(et|en)?	{printPPL(yytext);}
{U}[^\n ]+(land|ing|berg|borg)s" "[Ll]n	{printPPL(yytext);}
(Dalarnas|Malmhus|Stockholms|"Gteborgs och Bohus"|Blekinge)" "[Ll]n	{printPPL(yytext);}
{U}[^\n ]+(ss|bcks|areds|by|sj|berga|inge|mina|vikens|nebo||ngbo|torp|rbo|tuna|sunds|dals|stads|lvs|lunda|torps)" "[Ss]ocken	{printPPL(yytext);}
(Gryts|Fors|Ns|Ore|Tuve|Bergs|Srna|Strinds|Peleci|Krnbo|Torpa|Dorotea|Orns|Vla)" "[Ss]ocken	{printPPL(yytext);}
("Hammarby Sjstad"|"Sknes Fagerhult"|"Upplands Vsby"|"Villands Vnga"|"Vrends Nbbele"|"Sdra Sandby"|"Vrmlands Nyster"|"Vstra Mlaren"|"Bohus Malmn"|"Lilleby Sillvik"|"Nedre Malm"|"Kungens "[Kk]urva)	{printPPL(yytext);}

{U}[^\n ]+" Street "(Estate|Station)	{printFNC(yytext);}
[^\n ]*(inalen|mts|emma|atchen|rogram|arknad)" p "({U}[^\n ]+" ")+Road	{printFNC(yytext);}
({U}[^\n ]*" ")+"Street Station"	{printFNC(yytext);}
Klara" "[^\n ]+ra" "[^\n ]+gata(n)?	{printSTR(yytext);}
Gare(" "de[^\n ]*)?(" "{U}[^\n ]+)+	{printSTR(yytext);}
Odos(" "{U}[^\n ]+)+	{printSTR(yytext);}
"Santa Maria della "[^\n ]+kyrkan	{printFNC(yytext);}
"Santa Maria della "{U}[^\n ]+	{printPPL(yytext);}
(Via|Maria)" "(della|del)" "{U}[^\n ]+	{printSTR(yytext);}
"Via "("Appia Antica"|Appia|Felicati|Roma|Marmorata|Dolorosa|Monte[^\n ]+)	{printSTR(yytext);}
[Bb]oulevard" "(d[eui]" ")?{U}[^\n ]+(" "{U}[^\n ]+)*	{printSTR(yytext);}
([^\n ]*[Rr]iks|[Ll]ands|Europa|[Ll]ns)vgarna" "[A-Z0-9]+" och "[A-Z0-9]+	{printSTR(yytext);}
([^\n ]*[Rr]iksvg|Interstate|Route|[Ll]andsvg|Europavg|[Ll]nsvg|[Hh]uvudvg)" "[A-Z0-9]+	{printSTR(yytext);}
("Las Vegas"|Queens|"West Pico"|Amager|Ventura|California|"HC Andersens")" Boulevard"	{printSTR(yytext);}

[0-9\-]+" "{U}[^\n ]+" "Street	{printSTR(yytext);}
({U}[^\n ]+east|South|West|East|North|Lexington)" "[^\n ]+" "(Street|Boulevard|Avenue)	{printSTR(yytext);}
([0-9]+" ")?(Park|Pennsylvania|Hart|Florence|Madison|Lenox|Julian|Olive|Third|Fifth|Gasoline|Lexington|Beeches|Chicago|Addison|Colorado|Rockingham|Auburn|Beach|Upper|Downing|Bourbon|"Ban Co"|Carnaby|Fleet|Oldham|Pusher|South|Broad|Princes|Filbert|Bond|Market|"Kensington High"|{U}[^\n ]+" "House|[^\n ]+th|[^\n ]+nd)" "(Avenue|Street)	{printSTR(yytext);}
Aven[a-z]+" "[Dd][esai](" "{U}[^\n ]+)+	{printSTR(yytext);}
("Norra Gatan"|"Femte "[Aa]venyn)	{printSTR(yytext);}
(Portobello|"Al Green"|"Charing Cross"|Orchard|Avenell|St" "[^\n ]+)" Road"	{printSTR(yytext);}
St("ora Ny"|"en Sture")gatan	{printSTR(yytext);}
([0-9]+\:a|Renstiernas)" "gata(n)?	{printSTR(yytext);}
(Sankt|S:t|Vstra|Norra|stra|Sdra|Yttre|Danska)" "([^\n ]+gata|[^\n ]*[Vv]ge)n	{printSTR(yytext);}
"Prinsessan "[^\n ]+s" vg"	{printSTR(yytext);}
"id E 6 "	{printf("id <ENAMEX TYPE=\"LOC\" SBT=\"STR\">E 6</ENAMEX> ");}
"Promenade "[Dd]es" "{U}[^\n ]+	{printSTR(yytext);}
([0-9]+" ")?([Aa]venue|[Bb]oulevard|[Rr]ue)(" de"|" de la"|" "des|" "d\'|" du")?(" "{U}[^\n ]+)+	{printSTR(yytext);}
([Ll]illa|[Ss]tora)" "{U}[^\n ]+grnd	{printSTR(yytext);}
("Tysklands "[Aa]utobahn|"E "[2460]:an|"Champs "Ely[se]+|[Nn]"ya Alln"|"Nevskij Prospekt"|"Long Island Expressway"|"Vigerslev All")	{printSTR(yytext);}
	/* MULTI CITIES WITH KEY WORD & exceptions */
"District "(de|of)(" "{U}[^\n ]+)+	{printPPL(yytext);}
{U}[^\n ]+s\-" och "{U}[^\n ]+distrikt(et)?	{printPPL(yytext);}
{U}[^\n ]+(viken|land|dal|ping|borg|malm|holm)s" "[^\n ]*distrikt(et)?	{printPPL(yytext);}
(SVT:s|[Tt]idningen|skriver)" Norra "{U}[^\n ]+	{ECHO;}
"Norra "(Maga[sz]inet|Avdelningen)(s)?	{ECHO;}
"Norra Vsterbotten \( lib"	{ECHO;}
"hpl Norra "{U}[^\n ]+	{printFNC(yytext);}
("Norra Latin"|Stockholms" "ABF)\-hus(et)?	{printFNC(yytext);}
"Norra Brunn"(" "Comedy)?	{printFNC(yytext);}
"Norra Sknska "[^\n ]+egementet	{printFNC(yytext);}
"Norra "([Hh]amnen|[Ll]nken|[Bb]antorget)	{printFNC(yytext);}
"Norra "{U}[^\n\- ]+[^\ns ]	{printPPL(yytext);}
[Dd]"ivision "I+" "(stra|Vstra)" "{U}[^\n\- ]+	{ECHO;}
"stra "{U}[^\n ]+" I"[FK]	{ECHO;}
"stra "{U}[^\n\- ]+[^\ns ]	{printPPL(yytext);}
"Sdra "Hockey	{ECHO;}
"Sdra "{U}[^\n ]+\-{U}[^\n ]	{ECHO;}
"Sdra "(Teatern|[Ll]nken)	{printFNC(yytext);}
"Sdra "{U}[^\n\- ]+[^\ns ]	{printPPL(yytext);}
"Vstra Frlunda "(IF|HC)	{ECHO;}
[^\n ]*(serieledande|besegrade|mot|innan|"lag som"|slog|"spelar i"|formstarka|gnget)" Vstra"{U}[^\n\- ]+[^\ns ]	{ECHO;}
"Vstra Frlunda "(vunnit|tappade|klarade|storspela|"ville spela")	{ECHO;}
"Vstra Vrmlands jrnvg"	{printFNC(yytext);}
"Transsibiriska jrnvgen"	{printFNC(yytext);}
"Vstra "{U}[^\n\- ]+[^\n\-s ](" kommun")?	{printPPL(yytext);}
"vre "{U}[^\n\- ]+[^\ns ]	{printPPL(yytext);}
(West|South)" "(Middland|Bronx|Essex|Nyack|Kensington)	{printPPL(yytext);}
"Fresh Prince "(in|i)" Bel Air"	{ECHO;}
"Chevrolet Bel Air"	{ECHO;}
"tittar p Beverly Hills"	{ECHO;}
"Beverly Hills 90210"	{ECHO;}
"Beverly Hills\-villa"	{printFNC(yytext);}
	/*[^\n ]*(studio|vakt|rum|palatsen|studio|hem|nere)" i "("Bel Air"|"Beverly Hills")	{}*/
	/*(exklusiva|fashionabla)" "("Beverly Hills"|"Bel Air")	{}*/
("River View"|"Indy 500"|"Queens Park"|"Roland Garros")\-bana(n)?	{printFNC(yytext);}
(Oak|Chart|Wallnut)" "Hill(s)?\-bana(n)?	{printFNC(yytext);}
"Capitol "Hill(s)?	{printFNC(yytext);}
("Los Altos"|Pill|Notting|Frenchman|Chapel|Oakland|Bishop|Tower|Mose)" "Hill(s)?	{printPPL(yytext);}
S(t|"\:t"|aint|t\.)" "{U}[^\n ]+" "Hill	{printPPL(yytext);}
"Port Vale"\-{U}[^\n ]+	{ECHO;}
"Port Royal Golf"	{ECHO;}
"Port of San Francisco"	{printFNC(yytext);}
"Port "([Oo]f)(" "{U}[^\n ]+)+	{printPPL(yytext);}
(Puert[ao]" "[Dd]el|P[o]rto|"Puerto "[Ll]a|Port)(" "{U}[^\n ]+)+	{printPPL(yytext);}
"Pont au "{U}[^\n ]+	{printFNC(yytext);}
"Santa Cruz "[Dd]e" "{U}[^\n ]+	{printPPL(yytext);}
"Radio City"	{ECHO;}
"City of Theory"	{ECHO;}
[Cc][Ii][Tt][Yy]" of"(" "{U}[^\n ]+)+	{printPPL(yytext);}
{U}[^\n ][^\n ][^\n ]+" "[Cc]ity	{printPPL(yytext);}
(Music|Our)" Town"	{ECHO;}
{U}[^\n ]+" Town FC"	{ECHO;}
{U}[^\n ]+" Town Singers"	{ECHO;}
({U}[^\n ]+" ")*(South|Convention|Town)" Hall"	{printFNC(yytext);}
{U}[^\n ]+s" "[Cc]hinatown	{printFNC(yytext);}
[Tt]"he Old Town"	{printPPL(yytext);}
{U}[^\n ]+" "[Tt]own	{printPPL(yytext);}
(Men|P|Kan|Frn)" Island "	{int i=0; 
	for(;yytext[i]!=' ';putchar(yytext[i++])); i++;
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"PPL\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
"Edward Island Senators"	{ECHO;}
(S\:t|Prince|King)" "{U}[^\n ]+" "Island(s)?	{printPPL(yytext);}
"Seychelles Islands Foundation"	{ECHO;}
"NY Islanders"	{ECHO;}
"Thousand Islanddressing"	{ECHO;}
{U}[^\n ]+" "Island(s)?" Hotel"	{printFNC(yytext);}
{U}[^\n ]+" "Island(s)?	{printPPL(yytext);}
{U}[^\n ]+" Heights Promenade"	{printFNC(yytext);}
{U}[^\n ]+" Heights"	{printPPL(yytext);}
"Hga Kusten"	{printPPL(yytext);}
"Logistics Village"	{ECHO;}
{U}[^\n ]+" Village"	{printPPL(yytext);}
[Bb]"l "[Pp]orten	{ECHO;}
"Gamle Port"	{printFNC(yytext);}
("St ")?{U}[^\n ][^\n ][^\n ][^\n ]+" "Port(en)?	{printPPL(yytext);}
{U}[^\n ]+" "[Kk]yrkby	{printPPL(yytext);}
"Tampa Bay "(Mutiny|Lightning|Buccaneers)	{ECHO;}
"Green Bay Packers"	{ECHO;}
"Tampa Bay\-"{U}[^\n ]+	{ECHO;}
{U}[^\n ]+"\-Tampa Bay"	{ECHO;}
{U}[^\n ]+" Bay "(Hotel|Resort)	{printFNC(yytext);}
(lag|jumbon|"atchen mellan"|mter)" Tampa Bay"	{ECHO;}
{U}[^\n ]+" Francisco "Bay	{printGPL(yytext);}
"Bay Networks"	{ECHO;}
([^\n ]+paketet|Opera|Till|HIF)" Bay"	{ECHO;}
{U}[^\n ]+" "Bay	{printGPL(yytext);}
{U}[^\n ]+" "Square" "(Park|Caf|Garden|Theater)	{printFNC(yytext);}
{U}[^\n ]+" "Square	{printFNC(yytext);}
[^\n ]*(Lundby|Nacka|Hsselby|Farsta|holms|sunds|lvens|bergs)" "[Ss]trand	{printPPL(yytext);}
({U}[^\n ]+a|Pite|Grisslinge)" "[^\n ]*(havs|lufts|strand)bad	{printFNC(yytext);}
({U}[^\n ][^\n ]+" ")?(Low|Upp)"er "(We|Ea)st" Side"	{printPPL(yytext);}
"Frmre Orienten"	{printPPL(yytext);}
	/* FUNCTIONAL */
S(t|\:t)" "{U}[^\n ]+" "[^\n ]+hus" AB"	{ECHO;}
S(t|\:t)" "{U}[^\n ]+" "([^\n ]+hus|[^\n ]*[Kk]yrka|[Pp]ark|[Cc]hurch|Cathedral|[Gg]ymnasium)	{printFNC(yytext);}
({U}[^\n ]+" National"|Grace|Scripture)" "Cathedral	{printFNC(yytext);}
(St|Sankt|S\:t|Agios|Saint|Peter|Santa|San|Aleksandr)" "{U}[^\n ]+(klostret|katedral|basili[ck]a|station)(en|n)?	{printFNC(yytext);}
{U}[^\n ]+" "(Shopping|Medical|Conference|Kongress|Design)" Center"	{printFNC(yytext);}
("Simon Wiesenthal"|Molson|Toyota|Mazda|Canon|Citro[e]n|Fiat|Opel|Mitsubishi|Audi|Nissan|Union|Cargo|Gaia|Akal|MCI|Islamic|Darwin|Pepsi|Rockefeller|Hasselblads|Hasselblad|"Kennedy Space"|Lincoln|Staples|Wenner[Gg]ren|Wenner\-[Gg]ren|Cloetta|Mount" "[^\n ]+)" "[Cc]enter	{printFNC(yytext);}
"Simon Wiesenthal-centret"	{printFNC(yytext);}
"Lincoln Memorial"	{printFNC(yytext);}
[Tt]he" "[^\n ]+" Building"	{printFNC(yytext);}
(The|Royal)" "(Birkdale|Pavilion|"National Theatre")	{printFNC(yytext);}
("Santa F"|"Empire State")" Building"	{printFNC(yytext);}
{U}[^\n ]+" "(Tech|Veterans|Medical|Foundation)" Building"	{printFNC(yytext);}
(Halmstad|Coop|Sydkraft|Tower|"Lfbergs Lila"|"Sundsvall Park"|Kinnarps|"San Jose")" "Arena(n)?	{printFNC(yytext);}
("Royal ")?("Madison Square"|Covent|Kensington|Botanic|Convent|Boston|Kew|"MGM Grand"|"Maple Leafs"|"Maple Leaf")" Garden"(s)?(" "Arena)?	{printFNC(yytext);}
"Sveriges Nationalarena"	{printFNC(yytext);}
(Bajen|Malm|United|Madrid|Garden|Ranger|Mnchen|[^\n ]+stad|{U}+\:)s" "[^\n ]*arena(n)?	{printFNC(yytext);}
({U}[^\n ]+by|{U}[^\n ]+mmars|{U}[^\n ]+sbergs|{U}[^\n ]+ns|Tumba|Wira|Boda|Vr)" "[^\n ]*[Bb]ruk	{printFNC(yytext);}
(Vreta|Utstein|Valamo|Alvastra|S:t" "[^\n ]+|Alsike|Corvey|Vadstena|{U}[^\n ]+dals|{U}[^\n ]+ernas|Riseberga|{U}[^\n ]+ordens|{U}[^\n ]+borgs)" "[Kk]loster	{printFNC(yytext);}
"London "(Eye|"City Airport"|Gatwick|Heathrow)	{printFNC(yytext);}
("Kennedy Airport"|"La Guardia")	{printFNC(yytext);}
"Porte de "{U}[^\n ]+	{printFNC(yytext);}
"Barsebck "(1|2|I+)	{printFNC(yytext);}
"Nam "{U}[^\n ]+\-torget	{printFNC(yytext);}
({U}[^\n ]+sands|Skrea|{U}[^\n ]+fjllets|Kevans)" "[Ss]tugby	{printFNC(yytext);}
{U}[^\n ]+(fngelset|Colosseum)s" "murar	{printFNC(yytext);}
"Maison de "("l \' "|l[^\n ])(" "{U}[^\n ]+)+	{printFNC(yytext);}
"Svensk Trdgrd"	{ECHO;}
"Grand H"(yatt|[o]tel)s(" "[^\n ]+trdgrd)?	{printFNC(yytext);}
"Vrner Rydns fritidsgrd"	{printFNC(yytext);}
({U}[^\n ]+sttra|Sby|{U}[^\n ]+by|Lida|Bjrns|Run|Julita|Vada|Gimmene|Bckebols|Tyres|{U}[^\n ]+hulta|{U}[^\n ]+skolans|{U}[^\n ]+ngens)" "[^\n ]*grd	{printFNC(yytext);}
(Rosendals|sby|Centralbadets|Hwitans|Solbackens|Rockdala|Stadshusets|Trdgrdsfreningens|Ulrikedals|Ulriksdals)" "[^\n ]+grd(en|ar)?	{printFNC(yytext);}
(Bergian|Botani)ska" "[Tt]rdgrd(en)?	{printFNC(yytext);}
(Mont" "Parnasse|Mount" "Olivier|Pre" "Lachaise|Sdra" "skogs)(\-)?kyrkogrd(en)?	{printFNC(yytext);}
S(":t"|"t:a")" "[^\n ]+(" "kyrkas|" "norra)?" "[Kk]yrkogrd(en)?	{printFNC(yytext);}
(Adolf" "Fredriks|Allerums|Askims|Billdals|Bromma|Floby|Frmlingarnas|Hedvig" "Eleonora|Humla|Hrs|Johannes|Jrflla|Katarina|Klara|Kvibergs|Liding|Magdalena|Nacka|Norra|Nya|Pite|Ravlunda|Slinge|Norra|Spnga|Stampens|Svedala|Tyska|Tns|Uppsala|Vsterplana|Vstra|stra|xnevalla|Saint\-[^\n ]+)(" "kyrkas|" "norra)?" "[Kk]yrkogrd(en)?	{printFNC(yytext);}
(Gustav|"S\:ta Clara"|"Lundby Nya"|Klara|S:t)" "[^\n ]*[Kk]yrka(n)?	{printFNC(yytext);}
S(ankt|an|t|t\.)" "[^\n ]+kyrkan	{printFNC(yytext);}
("Hells Angel"|Bandido|[^\n ]+akademin|[^\n ]+frbundet|"MC Sweden"|[^\n ]+partiet)s" "[^\n ]*lokal(er)?	{printFNC(yytext);}
(Region|Svenska|Unga|[Tt]eater|Kungl|Internationella)" "[^\n ]+" "lokal(er)?	{printFNC(yytext);}
({U}[^\n ]+\:s|"Ung Vnsters"|Samis|Vnsterpartiets|"Svenska Mssans"|M[Cc]" "Swedens|Sotheby\'s|Vuxenskolans|Sidas|"Hells Angels")" "(byggnad|lokal)(er)?	{printFNC(yytext);}
{U}[^\n ]+(hem|huset|frening|mission|polisen|forum|skolan)s" lokaler"	{printFNC(yytext);}

S(\:|ank)t" "[^\n ]+(bron|plan|omrdet|plats|platsen)	{printFNC(yytext);}
S(\:|ank)t" Sigfrids "[^\n ]*pla[ntse]+	{printFNC(yytext);}
{U}[^\n ]+(tunneln|leden)s" "mynning(en|ar)?	{printFNC(yytext);}
(Sdra|Westmanska|[^\n ]+stads|[^\n ]+" sjukhusets")" BB"	{printFNC(yytext);}
{U}[^\n ]+s" konsulat"	{printFNC(yytext);}
"Gteborgs "([Hh]amninlopp|Kinematograf|Terrarium)	{printFNC(yytext);}
Radio(" "[^\n ]+)?" Music Hall"	{printFNC(yytext);}
("Royal Festival"|"Royal Albert"|Tivoli|Disney|Oxford)(" "[CK]on[sc]ert)?" Hall"	{printFNC(yytext);}
(Princess|Albert|Carnegie|Calder|Cobo|Waterfront)" Hall"	{printFNC(yytext);}
(Gteborgs|Stockholms|Uppsala|Malm)" "[Ss]tads(hus|teater)" AB"	{ECHO;}
(At[e]n|Uppsala|Oslo|Malm|Lund|Sdertlje)(s)?" "[^\n ]*(onsthall|entralstation|uktionsverk|entrum|[Cc]entral|innerstad|[Ss]lott|lottsruin)	{printFNC(yytext);}
{U}[^\n ]+(kping|holm|berg|borg|hamn|dal|vas|holmen|terbro|lanos|grd|gas|jevos|gered|nyj|rps|bygd|dalen|httan|backen|vetter)(s)?" "[^\n ]*(onsthall|entralstation|uktionsverk|entrum|[Cc]entral|innerstad|[Ss]lott|lottsruin)	{printFNC(yytext);}
(Uppsala|{U}[^\n ]+hamn|{U}[^\n ]+dal|Oslo|{U}[^\n ]+borg|Malm|Lund|{U}[^\n ]+kping|{U}[^\n ]+holm|{U}[^\n ]+berg|Sdertlje)(s)?" "[^\n ]+(hus|teater|kyrka|kapell|museum)	{printFNC(yytext);}
(Chicagos|Teherans|Bronx|Warszawas)" "("svarta ")?getto(n)?	{printFNC(yytext);}
([Pp]"rins Eugens "Walderma(r)?sudde|"Cabaret Lorensberg")	{printFNC(yytext);}
{U}[^\n ]+" "(Air|Air" "Force)" "Base	{printFNC(yytext);}
{U}[^\n ]+(skolan|gymnasiet)s" "[Aa]ula	{printFNC(yytext);}
{U}[^\n ]+a" "s(kolan|jukhu)s" "[Aa]ula	{printFNC(yytext);}
{U}[^\n ]+(lmens|atans|trands|sens|injens|hagens|ngs|plans|torgets|ergens|bergs|ngens)" "([Tt]\-bane|[Tt]\-|[Tt]unnelbane|pendeltg)station	{printFNC(yytext);}
(Mrsta|Mlnbos|Solna|Trngsunds|Zinkensdamms|Grdets|Blsuts|Slussens|Tumba|Vsterhaninge|"Kista Centrums"|"S:t Eriksplans"|"Sloane Squares"|"South Kensingtons"|"Vstra Skogens"|Masmo|Midsommarkransens|Ropsten|Alviks|Centralens|Farsta|Grdets|Hornstulls|Kasumigasekis|Alviks|West" "{U}[^\n ]+|Stora" "Mossens|Stockholm)" "([Tt]\-bane|[Tt]\-|[Tt]unnelbane|pendeltg)station	{printFNC(yytext);}
(Gteborg|Stockholm|Uppsala|Malm)(s)?" C "	{int i=0; 
	printf("<ENAMEX TYPE=\"LOC\" SBT=\"FNC\">");
	for(;yytext[i]!=' ';putchar(yytext[i++]));
printf(" C</ENAMEX> ");}
(Tokyo|Stockholm|Pari|Moskva|Oslo|London|Toronto|Yokohama|"New York")s" "([Pp]arker|[Tt]unnelbana|[Tt]\-bana|[Ss]ubway)	{printFNC(yytext);}
{U}[^\n ]+(holm|orget|plan|grden|torp|berg|ker|ared|md)s" "[^\n ]+bana	{printFNC(yytext);}
(Vstra|Lekkullens|Skansens|Solvalla|by|Jgersro|Mantorps|Barsebcks|Norra|Bergskers)" "[^\n ]+bana	{printFNC(yytext);}
(Kevinge|sterker|Landskrona|Delsjn|Haninge|Vdd|Toresta|Hammarby|Kungsngen|"Torrey Pine"|Viksj)(s)?" "[Gg]olfbana	{printFNC(yytext);}
(Ringhals|Oskarshamns|Barsebcks)" "[Kk]rnkraftverk	{printFNC(yytext);}
(Barsebck|Forsmark|Ringhals)" "[1-4](" och "[2-4]|\-[1-4])?	{printFNC(yytext);}
({U}[^\n ]+festivalen|Scandinavium|Hultsfred|Tivoli|Roskilde|Liseberg|"Rock Caf"[e]|"Gta Lejon"|Operan|Stadsteatern|Globen|Dramaten|Skansen|Solliden)s" "([Ss]tora" "|[Ll]illa" ")?[^\n ]*[Ss]cen	{printFNC(yytext);}
([Pp]|framfr)" "{U}[^\n ]+(huset|holm|grden|teater|festivalen|operan)s" "([Ss]tora" "|[Ll]illa" ")?[^\n ]*[Ss]cen	{int i=0; 
	for(;yytext[i]!=' ';putchar(yytext[i++])); i++; 
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
S:t" "Eriks(" ")?(terassen|klla|gymnasium|torg|[^\n ]+omrde|[^\n ]*sjukhus)	{printFNC(yytext);}
([^\n ]+yskland|Frintelsen|Hitler|FN\:|Stalin|Castro|FN|Gaza)s" "[^\n ]+lger	{printFNC(yytext);}
"Quai du"(" "{U}[^\n ]+)+	{printFNC(yytext);}
"rjans "[Vv]all" HBK"	{ECHO;}
"rjans "[Vv]all	{printFNC(yytext);}
"Grand "([Cc]afe|[Bb]azar|Parade|Ol|Palais|Place)	{printFNC(yytext);}
(Piper|Kinesi)ska" "[Mm]uren	{printFNC(yytext);}
(Vdd|Motala|Hjlmare|Kinda|Strmsholms|Sffle|Sdertlje|Trollhtte|Dalslands|Sickla|Gta)" "[Kk]anal(en)?	{printFNC(yytext);}
{U}[^\n ]+"s Folkets "([Hh]us|[Pp]ark)	{printFNC(yytext);}
(Svedala|Jrva|Gvle|Arvika)" Folkets "([Hh]us|[Pp]ark)	{printFNC(yytext);}
(Sagerska|Sociala|Ostindiska|Konsten|Dansen|Dalheimer|Nringslivet|Idrotten|Naturen|Ungdomen|Havet|"Ronald McDonald"|Utbildningen|Musiken)(s)?" "[Hh]us(et)?	{printFNC(yytext);}
(fulla|mot|ullsatt|kring|landets|vanfr|fyllt|edlagt|ggde|amla|frn|tanfr|enom|tadens|fullt|hyrt|nya|till|akom|unt|nytt|p|temot|ur|riva|ramfr)" "(Svenska" "Mssan|Folkets" "[Hh]us)	{int i=0; for(;yytext[i]!=' ';putchar(yytext[i++])); i++;
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
("gnader som"|"in i"|"kaler i"|"ionen av"|latsen" var")" Folkets "[Hh]us	{int i=0; for(;yytext[i]!=' ';putchar(yytext[i++])); i++; 
	putchar(' '); for(;yytext[i]!=' ';putchar(yytext[i++])); i++;
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
"Folkets "(Bio|Park)s" "(lokaler|huvudbyggnad)	{printFNC(yytext);}
(Torsvi|Lida|Farsta|Fittja|Enskede|Vr|Sttra)" "[Gg]rd	{printFNC(yytext);}
{U}[^\n ]+(kulla|by|sunda|ungs|sta|ns|hofs)" "[Gg]rd	{printFNC(yytext);}
("Adolf Fredriks"|"St:a Clara"|"S:t Grans")" "[^\n ]*[Gg]rd	{printFNC(yytext);}
"Central "[Pp]ark(" Zoo"|" "West|" "South)?	{printFNC(yytext);}
H[o]pital" Saint "{U}[^\n ]+	{printFNC(yytext);}
(Hyde|Flinders|Dbelns)" "[Pp]ark(" "Corner)?	{printFNC(yytext);}
(Speaker|Fritz[^\n ])s" Corner"	{printFNC(yytext);}
({U}[^\n ]+" ")+(Science|National|Olympic)" "[Pp]ark	{printFNC(yytext);}
(Sidley|Hampden|Selhurst|Gosford|Tjrnbro|Harriman|Goodison|Berzelii|ijared|Finsbury|Upton|Grant|"St James"|South|Newbury|Menlo|Nsby|Griffith|Letenska|Beach|"Gustav III\:s"|"Ivar Los"|Keillers|Kolmrdens|Wans|lands|Sknes|Bors|Slottsskogens|Huascaranas|Tikals|Grfsns|Windsors|Experience|Celtic|Vita|Fjllbo|Vallby|Lycksele|Orsa|S\:t|Kakadu|Tjuta|Greme|Canaima)" "[^\n ]*[Pp]ark(en)?	{printFNC(yytext);}
{U}[^\n ]+(torp|dalen|grden|kping|holm|dal)s" "[^\n ]*[Pp]ark	{printFNC(yytext);}
Nolhaga" "([Pp]ark|koloniomrde)	{printFNC(yytext);}
(Kunglig|[Nn]y)a" "Operan	{printFNC(yytext);}
"San "[^\n ]+\-operan	{printFNC(yytext);}
"Pater Noster"(\-skren)?	{printFNC(yytext);}
"al "{U}[^\n ]+\-universitet	{printFNC(yytext);}
{U}+[0-9]+\:s" kaserner"	{printFNC(yytext);}
("Himmelska "[Ff]ridens|Lilla|Rda|Frlunda|Gusta[vf]" "Adolfs|Sergels|lta|Stra)" "[Tt]org(et)?	{printFNC(yytext);}
"Sergel Plaza"(" Hotel")?	{printFNC(yytext);}
(Sagerska|Valands|{U}[^\n ]+ska|Folkets)" "[Pp]alats(et)?	{printFNC(yytext);}
"Centro de Arte"(" "{U}[^\n ]+)*	{printFNC(yytext);}
("Anfield Road"|"Nou Camp"|"San Siro"|"Santiago "Bernab[e]u)(\-stadion)?	{printFNC(yytext);}
("Guiseppe Meazza"|"Geoffrey Guichard"|"Flix Bollaert"|"Vanden Stock"|"Ferry Dusika"|"Ernst Happel"|"Ennio Tardini"|"Charles Herman"|"Benito Villamarin")\-stadion	{printFNC(yytext);}
(Brndby|Malm|Stockholms|Rsunda)" "[^\n ]*[Ss]tadion	{printFNC(yytext);}
("Stadio Comunale"|"Old Trafford"|"Wembley Stadium"|"White Hart Lane")	{printFNC(yytext);}
{U}[^\n ]+"s Olympiastadion"	{printFNC(yytext);}
"Avesta "[Mm]otorstadion	{printFNC(yytext);}
Palais" "d(e|es)(" "{U}[^\n ]+)+	{printFNC(yytext);}
Palais" "{U}[^\n ]+	{printFNC(yytext);}
(Castel|Palazzi|Palazzio)" "de(lla|lle|l)(" "{U}[^\n ]+)+	{printFNC(yytext);}
"Plaza "(San|del|de|"de la")(" "{U}[^\n ]+)+	{printFNC(yytext);}
"Cosme Palacio y "{U}[^\n ]+	{printFNC(yytext);}
"Place "("de la"|St|Saint|S:t|"Charles de")(" "{U}[^\n ]+)+	{printFNC(yytext);}
"Parc d"(es|"e la"|e)" "[^\n ]+	{printFNC(yytext);}
(Elite|Rockefeller)" Plaza"	{printFNC(yytext);}
(Solna|Nacka|Sdra|Grims|Spnga|Rnninge|"Vstra Skogens")" "[^\n ]*[Ss]tation	{printFNC(yytext);}
{U}[^\n ]+(malm|berg|ngen|hamn|plan|borg|grden)s" "[^\n ]*[Ss]tation	{printFNC(yytext);}
(Bolidens|Skattvngs|Skttvngs|Sala|DannemoraFalu|Codelcos)" "[^\n ]*gruva	{printFNC(yytext);}
("London Bullion"|Albert|Camden|Borough)" "Market	{printFNC(yytext);}
("Gustav Vasa-hemmet"|"La Fenice"|"Westminster Abbey"|"Suckarnas "[Bb]ro)	{printFNC(yytext);}
(City|Obs|OBS|Wessels|Konsum|Exet|KF)" "[Ss]tormarknad	{printFNC(yytext);}
"Jardin des "{U}[^\n ]+	{printFNC(yytext);}
(Johan|{U}[^\n ]+er)" "[^\n ]*[Pp]latz	{printFNC(yytext);}
(Oxford|Pi(c|cc)adilly)" Circus"	{printFNC(yytext);}
"World Trade "[Cc]enter	{printFNC(yytext);}
"New York Stock Exchange"	{printFNC(yytext);}
"Rda "(Sten|Kvarn)	{printFNC(yytext);}
"Flushing Meadows"	{printFNC(yytext);}
I[Cc][Aa]" Maxi"	{printFNC(yytext);}
(Malm|Konsum|Centrum|Samhall)" "Syd	{printFNC(yytext);}
"Bio "("Medicinskt Centrum"|Rio)	{printFNC(yytext);}
(Kungl|Kungliga)" "[^\n ]*(Musikhgskolan|Biblioteket|[Ss]lottet|[Hh]allen)	{printFNC(yytext);}
(Baltiska|Bl)" "(Stllet|[Hh]allen)	{printFNC(yytext);}
"Bibliotheca Alexandrina"	{printFNC(yytext);}
De[nt]" Kongelige "(Teater|Kapel|Bibliotek)	{printFNC(yytext);}
(Oxford|Essinge|"Musikaliska Akademien")(s)?" "[Bb]ibliotek	{printFNC(yytext);}
{U}[^\n ]+(holmens|sunds|bergs|sj|tulls|dals|ngens|holms|hamns|jdens|bygds|reds)" "[^\n ]*bibliotek	{printFNC(yytext);}
Ch[a]"teau de la"(" "{U}[^\n ]+)+	{printFNC(yytext);}
(Buckingham|Caesar\'s|Caesars|"Saint James"|Ledra|Eltham|Kensington|Floating)" "Palace	{printFNC(yytext);}
Biblioth[e]"que Nationale"	{printFNC(yytext);}
(Ns|Gunnebo|Lck|Fredensborg|Lederborg|Sels)" "[Ss]lott?	{printFNC(yytext);}
Ns" "[Ff]abriker	{printFNC(yytext);}
({U}[^\n ]+[nt]s|Pampas|Viamare)" "[Mm]arina	{printFNC(yytext);}
(Cheops|Keops)" "[Pp]yramid(en)?	{printFNC(yytext);}
Fort" "(James|Knox|Boyard)	{printFNC(yytext);}
(Dublin|Ashford|Windsor|Bolton)" Castle"	{printFNC(yytext);}
("Olof Palmes"|Warvinskys)" plats"(en)?	{printFNC(yytext);}
Estonias" "(vrak|frlisnings)plats	{printFNC(yytext);}
("Hjalmar Brant"|"Nils Ericson")[^\n ]+lats(en)?	{printFNC(yytext);}
"Golden Gate Award"	{ECHO;}
"Golden Gate"(\-bron|bron)?	{printFNC(yytext);}
"Hga "[Kk]usten(\-bron|bron)?	{printFNC(yytext);}
(Tower|Brooklyn|Vauxhall|Memorial|Stamford|Pleasant|Humber|Niagara\-Clifton|Beit)" "Bridge	{printFNC(yytext);}
(Sydney" ")?(Harbour|Harbor)" "Bridge	{printFNC(yytext);}
([Tt]he" ")?(Gothia|Pearl|Petronas|London|Bridge|O[Xx][Oo]|Euro|Scandinavian|Sears|Millennium|Alton|Chifley|"Kista Science")" "Tower(s)?	{printFNC(yytext);}
(Sky|Millennium)" "Dome	{printFNC(yytext);}
("Nya Louvren"|"Tate "Galler[iy]|"Tate Modern")	{printFNC(yytext);}
National(" "{U}[^\n ]+)?" Gallery"(" of "[^\n ]+)?	{printFNC(yytext);}
"Thielska "[Gg]alleriet	{printFNC(yytext);}
"Ramses "[IXV]+(\:s)?" "[^\n ]*[Tt]empel	{printFNC(yytext);}
"Tusen och "[Ee]n" "[Nn]att" "[Tt]empel	{printFNC(yytext);}
[^\n ]*(Vindarna|Augustu|Buddha|Salomo|Jehova|Diana|[Mm]ammon|Artemi|Jerusalem|Mormonerna|Folket|armn|Gud|"Heliga Ande"|"Kung Salomo")s" "[^\n ]*[Tt]empel	{printFNC(yytext);}
(Assad|"Ho Chi Minh"|Mao|Khomeini|Spencer|Lenin|Qin)s" "[Mm]ausoleum	{printFNC(yytext);}
{U}[^\n ]+(kllaren|\:|verken|skolan|hllan)s" "[^\n ]*matsal	{printFNC(yytext);}
Cit[^\n ]" de la "{U}[^\n ]+	{printFNC(yytext);}
("Sveriges ")?"Silicon "(Alley|Playa|Valley)(\-omrdet)?	{printFNC(yytext);}
"Stora "(Blt\-frbindelsen|Blt\-bron|Torget|Bltbron|[Vv]alla)("s fste")?	{printFNC(yytext);}
"Santa Maria "[Dd]el[a-z]*" "{U}[^\n ]+" kapell"	{printFNC(yytext);}
Sant[ai]" "{U}[^\n ]+" e "{U}[^\n ]+	{printFNC(yytext);}
(Stora|Gyllene)" "[^\n ]*[Ss]alen	{printFNC(yytext);}
("Seven Eleven"|"Grna Konsum")\-butik(er|erna|en)?	{printFNC(yytext);}
(rapporterar|vid)" "({U}[^\n ]+ens|Gteborgs|Uppsala|Astronomiska|R|Stockholms|Tyko" "Brahes)" "[Oo]bservatori(um|et)	{ECHO;}
({U}[^\n ]+dens|Gteborgs|Uppsala|Onsala|Astronomiska|R|Stockholms|Tycho" "Brahes|Tyko" "Brahes)" "[^\n ]*[Oo]bservatori(um|et)	{printFNC(yytext);}
"Piazza "(dai|della|dei|del|San|Tre|Santa)" "{U}[^\n ]+	{printFNC(yytext);}
Club" "(13|Vogue)	{printFNC(yytext);}
({U}[^\n ]+" "Country|Travellers|Olympic|Cavern)" "Club	{printFNC(yytext);}
{U}[^\n ]+" "(Kultur|Day|Park)" "Spa	{printFNC(yytext);}
Hard(r|" R")"ock Caf"(" "{U}[^\n ]+)?	{printFNC(yytext);}
"Caf "(de" "{U}[^\n ]+|P" stan")	{printFNC(yytext);}
(Paris" "Casino|Sunwing|Radisson" "Deauville|Radisson|Ving|Lmuria|Foxwoods)" "Resort	{printFNC(yytext);}
"Sheraton Hotel and Towers"	{printFNC(yytext);}
Hotel" "(New" "York|Sevilla|Nacional|Caesar)	{printFNC(yytext);}
[Hh][o]tel" "(du|de)(" "{U}[^\n ]*)+	{printFNC(yytext);}
(Grand|Scandic)" Hotel "{U}[^\n ]+	{printFNC(yytext);}
("Scandic Crown"|"Park Avenue"|Grand|Hyatt|Capital)" "[Hh]otel	{printFNC(yytext);}
("SAS Radisson"|"King David"|"Grand Met"|"Four Seasons"|"Blue Star"|"Always Family"|"Sun Club")\-hotell(en|et)?	{printFNC(yytext);}
[Ii]mam" "[^\n ]+" "gravmosk(n)?	{printFNC(yytext);}
("Nya Elfsborgs"|Varbergs|Akershus|{U}[^\n ]+strands|Bohus|Bodens|{U}[^\n ]+borgs|{U}[^\n ]+stens|{U}[^\n ]+sunds)" "[Ff]stning	{printFNC(yytext);}
{U}[^\n ]+" de Ville"	{printFNC(yytext);}
("Vin- och "[Ss]prithistorisk|Modern|{U}[^\n ]+sk)a" "[Mm]useets" "[^\n ]*(iotek|hrsal|ammare|lokaler|grd|rum|"tora salong")	{printFNC(yytext);}
(Jupiter|Gleerup|Sandberg|Humlan|Hedengren|Barnen|Bonier|Hamreliu|NK\:|Wettergren|Risberg|Hallman|Sjholm|Bergman|Junibacken)(s)?" "bokhandel	{printFNC(yytext);}
{U}[^\n ]+ska" "[Mm]useets" "[^\n ]*(utskott|avdelning|[Ff]rlag|mte|arkiv|jubileum|konferens)	{ECHO;}
(Modern|{U}[^\n ]+sk|"Vin\- och "[Ss]prithistorisk)"a "[^\n ]*[Mm]us[e]et	{printFNC(yytext);}
("J Paul"|[Vv]an)" "{U}[^\n ]+\-museet	{printFNC(yytext);}
("American National"|Guggenheim|Louisiana|Holocaust" "Memorial)" "[Mm]useum	{printFNC(yytext);}
("Stora Lundby"|"Statens "[^\n ]+|{U}[^\n ]+"s "lns)" "[^\n ]*museum	{printFNC(yytext);}
Muse(s)?" "{U}[^\n ]+" "d([^\n ]Art|"e la"|u|es)(" "{U}[^\n ]+)+(" de "{U}[^\n ]+)?	{printFNC(yytext);}
Muse" d"("e la"|u|es)(" "{U}[^\n ]+)+	{printFNC(yytext);}
Museo(" "{U}[^\n ]+)+(" de "{U}[^\n ]+)?	{printFNC(yytext);}
({U}[^\n ]+" ")?Museum" "(of|"of the")(" "{U}[^\n ]+)+	{printFNC(yytext);}
(Nato|Stasi|{U}+\:|{U}[^\n ]+imperiet|{U}+\:[^\n ]+|[^\n ]+\-polisen|[^\n ]+\-sekten|[^\n ]+partiet)s" "[^\n ]*hgkvarter	{printFNC(yytext);}
(Klara|Viking" "Lines|Stenas|Seacats|Postens|Arlandas|lvngens|"Stena Lines"|Cargo" "Centers|Malm)" "[^\n ]*terminal	{printFNC(yytext);}
"Casa de "{U}[^\n ]+	{printFNC(yytext);}
"Pier "[0-9]+	{printFNC(yytext);}
("Birger Jarls"|Mosebacke)" "[^\n ]*torn	{printFNC(yytext);}
[Dd]"en Gyldene Freden"	{printFNC(yytext);}
("Los Angeles"|"Santa Monica"|"Charles de Gaulle"|"La Guardia")(\-)?flygplats(en)?	{printFNC(yytext);}
{U}[^\n ]+s" internationella flygplats"	{printFNC(yytext);}
{U}[^\n ]+(viken|holmen|an|baden|n|sand|vik|torp|ng|lund|dal|strand|hyddan|berg)s" "(bad|camping)(plats)?	{printFNC(yytext);}
(Stra|sa|Lomma|Stockens|Askims|Meros|{U}[^\n ]+by|Ume)" "camping(plats)?	{printFNC(yytext);}
{U}[^\n ][^\n ][^\n ]+" trafikplats"	{printFNC(yytext);}
("Malm gamla"|Stra|Sr|{U}[^\n ]+s)" "[Ii]drottsplats	{printFNC(yytext);}
("Pizza Hut"|"Mc Donal"|"Mac Donal"|"Burger King"|McDonald)[^\n ]*("\-"|" ")[Rr]estaurang(en)?	{printFNC(yytext);}
{U}[^\n ][^\n ][^\n ]+" "[^\n ]*(klass|hamn|vg|rds|ters|rit|guld|tids|rn)krog	{printFNC(yytext);}
[0-9]+\:e" "[^\n ]+sjukhuset	{printFNC(yytext);}
"Villa "("San "[^\n ]+|Metcalfe|Haga|Park|Sola|Nobel|Villekulla|Borghese)	{printFNC(yytext);}
	/* dubious...*/
S:t" "[^\n ]+smottagningen	{printFNC(yytext);}
[A-Z]+"\:s "fste	{printFNC(yytext);}
(by|Hlleki|Rda|stad|Toarp|Floda)(s)?" "[Ss]teri	{printFNC(yytext);}
{U}[^\n ]+(bro|sund|berg||sta)(s)?" "[Ss]teri	{printFNC(yytext);}
(Calcutta|London|Kairo|"New York"|Soweto)s" "[Ss]lum(omrdet)?	{printFNC(yytext);}
("Terra Nova\-"|"Gamla ")varvet	{printFNC(yytext);}
Memorial" "(Park|Gardens|Cemetary|Museum|Auditorium|Coliseum)	{printFNC(yytext);}
("Stadion der "{U}[^\n ]+|"Estadio Municipal"|"Taj Mahal"|"Centre Pompidou"|"MGM Grand"|"Canal Grande"|"Kllereds Kpstad"|"Moulin Rouge"|"Yonkers Raceway"|"High Court"|"La Escondida"|"Maale Amos"|"San Sebastianokatakomben"|"Vrfru "[Gg]illestuga|"Community Shield"|"Tby Galoppbana"|"Liljevalchs konsthall"|"Grand Union Canal"|"Ales "[Ss]tenar|"kers Styckebruk"|"Ovala "[Rr]ummet|"Calle Genova"|"Liquor Store"|"Tellus fritidscenter"|"Hagia Sofia"|"Forum Romanum"|"Hyatt Regency"|"Beit Israel"|"Skara "[Ss]ommarland|"Forty Foot Pool"|"Casino de Paris")	{printFNC(yytext);}
S(aint|t|\:t|ankt)" Petersburg "(Cup|Championship)	{ECHO;}
S(aint|t|\:t|ankt)" Petersburg"	{printPPL(yytext);}
S(aint|t|\:t)" "(Andrew|Deni|John|George|Helier|John|Michael|Paul)(\s|s)?	{printPPL(yytext);}
(jrni[nga]+|hionabla|nrika|runt|yggt|anfr|riva|mot|[Vv]id|akom|[Pp]|[Nn]ra|kring|I|ationen|till)" "(Palazzo|Fort|Place|Casino|Bar|Club|Hotel+|S\:t|Palace)" "{U}[^\n ]+	{int i=0; for(;yytext[i]!=' ';putchar(yytext[i++])); i++;
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
(riva|vid|tanfr|runt|[Pp]|akom|[Nn]ra)" "Villa" "(d[^\n ])?{U}[^\n ]+	{int i=0; 	for(;yytext[i]!=' ';putchar(yytext[i++])); i++; 
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
[^\n ]*(lad|ggd|nvig|lgna|lagda|overad|besk|invid)[^\n ]*" "{U}[^\n ]+" "{U}[^\n ]+skola(n)?	{int i=0; for(;yytext[i]!=' ';putchar(yytext[i++])); i++;
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
(emot|tornet|under|frbi|beskte|beskt|anfr|[Vv]id|akom|beska|nra|ramfr|lmnade)" "("Big Ben"|"Burger King"|"Vita "[Hh]uset|{U}[^\n ]+" "[a-z]*grd[en]*)	{int i=0; for(;yytext[i]!=' ';putchar(yytext[i++])); i++;
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
[^\n ]*("kadad till"|"kador till"|"gen till"|"karna p"|"onom p"|"alen p"|"rdes till"|"nsiven p"|"avdelningen p"|"opter till"|nne" p"|"oende p"|"vrd p"|"kuten p"|"rdas p"|"ansport till"|"kickas till"|"peration p"|"ienter p"|"tt emot"|"evande till"|"musik p"|"ver till"|"sig p"|"in p"|"frs till"|"ulans till"|"fras till"|"rationen p"|"vllen p")(" "{U}[^\n ]+)+" "[^\n ]*(akut|jukhus|linik|asarett|hem|teater|huset|center|Clinic|boende)(met|et|en)?	{int i=0; for(;yytext[i]!=' ';putchar(yytext[i++])); i++; 	putchar(' ');  for(;yytext[i]!=' ';putchar(yytext[i++])); i++;
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
([Vv]id|i|frn|av|[Pp]|anfr|runt|akom|nra)(" "{U}[^\n ]+)+" "([Ii]drottsplats|katedral|golfbana|skolgrd|[^\n ]*ishall|byggnad)(en)?	{int i=0; 	for(;yytext[i]!=' ';putchar(yytext[i++])); 
	i++;  printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
[^\n ]*("ontor p"|"utiken p"|"mte i"|"randen i"|"gde upp"|"cker i"|"ramfrs i"|"stspel i"|"lokal fr"|"mte p"|"ryms i"|"mlingarna vid"|"in i"|"sig till"|"tllning i"|"ramat vid"|"alaset p"|"kalas vid"|"sera frbi"|"rarna p"|"pation av"|"ruta p"|"kument p"|"rffas p"|"isning av"|"kvar p"|"rum i"|"rum p"|"esk p"|"kast frn"|"nne p"|"in p"|overing[a-z]*" "av|husera[a-z]*" "p|"rren till")(" "{U}[^\n ]+)+" "[^\n ]*(Way|niversity|iblioteket|College|grden|ospital|[Ss]kolan|ymnasium|kontor|ambassad|ensivavdelning|ymnasiet)	{int i=0;
	for(;yytext[i]!=' ';putchar(yytext[i++])); i++; putchar(' '); 
	for(;yytext[i]!=' ';putchar(yytext[i++])); i++;
	printf(" <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">"); 
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
({U}[^\n ]+" ")+Golf(" \& Country")?" "Club	{printFNC(yytext);}
	/* MULTI CITIES NON SWEDISH (>230)*/
"tidningen "("San Francisco"|"Los Angeles")	{ECHO;}
(Soto|Campo|Ilha)" Grande"	{printPPL(yytext);}
{U}[^\n ]+" State "[a-z\,\.\-]	{ int i=0;
	printf("<ENAMEX TYPE=\"LOC\" SBT=\"PPL\">");
	for(;yytext[i]!=' ';putchar(yytext[i++]));
	putchar(yytext[i++]);
	for(;yytext[i]!=' ';putchar(yytext[i++]));
	printf("</ENAMEX>");
	for(;i<yyleng;putchar(yytext[i++]));}
"Camp David I"	{ECHO;}
"Colorado Springs Gazette"	{ECHO;}
("Camp David"|"Castelo Branco"|"Charlotte Amalie"|"Chatham Docks"|"Chi Lung"|"Ching Tao"|"Crans Montana"|"Coopers Crossing"|"Corpus Christi")	{printPPL(yytext);}
"Concha y Toro"	{printPPL(yytext);}
(Mellan|Central)"\- och "[^\n ]+uropa	{printPPL(yytext);}
"Cueva de los "{U}[^\n ]+	{printPPL(yytext);}
"Col "d("e la"|e|u)" "{U}[^\n ]+	{printPPL(yytext);}
	/* MOD (Jyrki Niemi): Moved [^\n ] outside double quotes */
"Col d"[^\n ]{U}[^\n ]+	{printPPL(yytext);}
"Cortina "d(" "\'|[^\na-z ])" "{U}[^\n ]+	{printPPL(yytext);}
([Dd]en" "Haag|"Del Rio"|"Delta Junction"|"Des Moines"|"Diego Garcia")	{printPPL(yytext);}
"Dals "(Lnged|Ed|Rostock)	{printPPL(yytext);}
"Dar "[Ee][sl](" "|\-)Sal[a]+m	{printPPL(yytext);}
"Eagle Pass"	{printPPL(yytext);}
"East "(London|Anglia|Rutherford)	{printPPL(yytext);}
"El "("Ferrol Del Caudillo"|Aaiun|Ain|Paso|Segundo|Alamein|Palomar)	{printPPL(yytext);}
(Europa|Hunts|West|Sand|Moses)" Point"	{printPPL(yytext);}
("False Pass"|"Fangcheng Gang"|"Flying Fish Cove"|"Fuji Suva"|"Froilan Tenorio")	{printPPL(yytext);}
"Fort "(Lauderdale|Myers|Yukon|Worth)	{printPPL(yytext);}
("Garmisch Partenkirchen"|"Gran Canaria"|"Gaza stad"|"Grand Turk"|"Grds Kpinge"|"Grnsta "[Gg]rde)	{printPPL(yytext);}
H[o]" "Ch[i]" Minh-staden"	{printPPL(yytext);}
("Ho Chi Minh-leden"|"Hammarby "[Ss]jstad|"Hat Yai"|"Hanstholm Havn"|"Higashi Harima"|"Hullie by"|"Haram al\-Sharif")	{printPPL(yytext);}
("International Falls"|"Irian Jaya"|"Indian Wells")	{printPPL(yytext);}
[I]le" "(de" "la|de)" "{U}[^\n ]+	{printPPL(yytext);}
("Jalapa Enriques"|"Joao Pessoa"|"Juan Fernandez")	{printPPL(yytext);}
"Key West Race"	{ECHO;}
"Khan "(Yunis|al\-[^\n ]+)	{printPPL(yytext);}
"La Corunas ml"	{ECHO;}
"La "(Jolla|Clusaz|Coruna|Habana|Higuera|Manga|Orotava|Pallice|Paz|Plata|Rioja|Rochelle|Serena|Spezia|Graciosa|Palma|Gomera)	{printPPL(yytext);}
"Las Palmas"\-{U}[^\n ]+	{ECHO;}
"Las Palmas"	{printPPL(yytext);}
(Farvl|Viva)" Las Vegas"	{ECHO;}
("Las Vegas"|"Little Rock")" Hilton"	{printFNC(yytext);}
"Las Vegas"	{printPPL(yytext);}
"Chateau Lake "{U}[^\n ]+	{printFNC(yytext);}
"Lake "(Louise|Placid)	{printPPL(yytext);}
"Lawi Lawi"	{printPPL(yytext);}
"Le Havre"\-{U}[^\n ]+	{ECHO;}
"Le Mans "("utan svensk"|[1-9][0-9])	{ECHO;}
(kra|krde|klassiska|[]rets|"plaga av")" Le Mans"	{ECHO;}
"Le "(Mans|Havre)	{printPPL(yytext);}
"Les "(Contamines|"Sables Dolonne")	{printPPL(yytext);}
"Lilla Edet "(samarbetar|hlsar|"har avtal")	{ECHO;}
(Vara|"Lilla Edet"|Gnosj)(" kommun"|"s kommun")?	{printPPL(yytext);}
{U}[^\n ]+(kils|mls|viks|ryd|bygds|backa|mora|kers|roteasunds|stads|lvs|by|holms|borgs|dals|lands|kyrka|bergs|pings|sands|lvs|valls|hamns|ns)" "([Ss]tift|[Kk]ommun)	{printPPL(yytext);}
(Malm|Ale|Lerum|Tanum|Askim|Vara|storp|Salem|Karlskoga|Eda|Tierp|Ume|Trollhttan|Bstad|Hjo|Vster|Lund|Skvde|Hrryda|re|Vetlanda|Rng|Huddinge|Oslo|Flen|Gullspng|Krokom)s" "([Ss]tift|[Kk]ommun)	{printPPL(yytext);}
"Little "(Rock|"Big Horn")	{printGPL(yytext);}
"Londons West End"	{printFNC(yytext);}
"Loch Ness"	{printFNC(yytext);}
{U}[^\n ]+\-"Los Angeles"	{ECHO;}
"Los Angeles"(" Daily"|" "Post|" "Motor|" "Times|\-{U}[^\n ]+)	{ECHO;}
[Dd]"owntown Los Angeles"	{printFNC(yytext);}
"Los Angeles\-studio"	{printFNC(yytext);}
"Los Angeles\-"[a-z]+orten(" "{U}[^\n ]+)+	{printPPL(yytext);}
L[Oo][Ss]" "A[Nn][Gg][Ee][Ll][Ee][Ss](\-trakten|\-omrdet)?	{printPPL(yytext);}
"Los Alamos National"	{ECHO;}
"Napa Valley Wine"	{ECHO;}
(Creek|Napa)" Valley"	{printPPL(yytext);}
Newcastle" upon "[^\n ]+	{printPPL(yytext);}
"New Jersey Devils"	{ECHO;}
"New Jersey\-"{U}[^\n ]+	{ECHO;}
"New Orleans Saints"	{ECHO;}
"New "(Rochelle|Jersey|Orleans|Albany|Brunswic|Delhi|Hampshire|Haven|Mexico|Westminster|"South Wales")	{printPPL(yytext);}
"Nordens Venedig"	{printPPL(yytext);}
N[o]tre" Dame de la "{U}[^\n ]+	{printFNC(yytext);}
N[o]tre" "Dame(\-katedralen)?	{printFNC(yytext);}
"New York "(Group|Philarmonic|Islanders|Magazine|Rangers|Times|Press|University|Review|Yankees|Giants|Dolls|Games|Marathon|Harlem|Post)	{ECHO;}
"of New York"	{ECHO;}
"paning i New York"	{ECHO;}
"New York\-"[a-z]+orten(" "{U}[^\n ]+)+	{printPPL(yytext);}
"ledde fram till Pearl Harbor"	{ECHO;}
"efter Pearl Harbor"	{ECHO;}
"basen Pearl Harbor"	{printf("basen <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">Pearl Harbor</ENAMEX>");}
("East ")?"Palo Alto"	{printPPL(yytext);}
{U}[^\n ]+" "Harb(or|our)	{printPPL(yytext);}
"Praia dos "{U}[^\n ]+	{printPPL(yytext);}

"Ras "[Aa][tl]" "(Tannurah|Khaimah)	{printPPL(yytext);}
R[Ii][Oo]" "[Dd][Ee]" J"[Aa][^\n ]+	{printPPL(yytext);}
"Rio "(Grande|Gallegos|B[rl]anco|"de la Plata"|"dei "[A-Z][^\n ]+)	{printPPL(yytext);}
"Rothesay Dock"	{printPPL(yytext);}
"Rda havsbadorten"	{printPPL(yytext);}
" i St Etienne "	{printf(" i <ENAMEX TYPE=\"LOC\" SBT=\"PPL\">St Etienne</ENAMEX> ");}
"Saint Denis de "{U}[^\n ]+	{printPPL(yytext);}
"Sakai Senboku"	{printPPL(yytext);}
"Salt Lake"(" "City)?	{printPPL(yytext);}
"San Antonio Spurs"	{ECHO;}
"San Antonio"\-{U}[^\n ]+	{ECHO;}
{U}[^\n ]+\-"San Antonio"	{ECHO;}
"San Quentin\-fngelset"	{printFNC(yytext);}
"San Francisco\-"{U}[^\n ]+	{ECHO;}
"San Francisco "(Yacht|Chronicle|Art|Symf|days)	{ECHO;}
"San Francisco\-bukten"	{printGPL(yytext);}
"San Jos"[e]" "(Mercury|Sharks|Rhinos)	{ECHO;}
"San Jos"[e]\-{U}[^\n ]+	{ECHO;}
"San Diego"(omrdet|\-omrdet)?	{printPPL(yytext);}
"San Fernando"(" Valley")?	{printPPL(yytext);}
"San "Fran[cs]isco(" State"|"s gaydistrikt")?	{printPPL(yytext);}
"San Miguel de Tucumn"	{printPPL(yytext);}
"San Salvador de Jujuy"	{printPPL(yytext);}
"San "(Augustin|Angelo|Antonio|Bernardino|Crist[o]bal|Quentin|Vicente)	{printPPL(yytext);}
"San "(Salvador|Jos[e]|Juan|Luis|"Luis Potosi"|Remo|Sebasti[a]n)	{printPPL(yytext);}
"Sankt "(Gallen|Ibb|Michel|Olof)	{printPPL(yytext);}
"Santa Monica "(Track|College|Software)	{ECHO;}
"flygen Santa Monica"	{ECHO;}
Sa(nk|n)ta" "(Anna|F|Fe|Cruz|Monica|Clara|Barbara|Rosa)	{printPPL(yytext);}
"Santiago "[Dd][IEie]" "C(uba|hile|ompostela)	{printPPL(yytext);}
"Santiago del Estero"	{printPPL(yytext);}
"Santo "(Polo|Domingo)	{printPPL(yytext);}
"San Paulo"\-{U}[^\n ]+	{ECHO;}
S[a]"o Paulos slum"(omrden)?	{printFNC(yytext);}
S[a]"o Paulo"(" stad")?	{printPPL(yytext);}

"Sharm "[Eea]l(" "|\-)She(ik|ikh|jk)	{printPPL(yytext);}
"Sioux Falls"	{printPPL(yytext);}
"Sierra "(Nevada|"de los "{U}[^\n ]+)	{printPPL(yytext);}
"Stade de "{U}[^\n ]+	{printPPL(yytext);}
"of South Carolina"	{ECHO;}
"St Louis"\-{U}[^\n ]+	{ECHO;}
S[^\n ]+" Louis "(Post|Rams|Blues|Cardinals|Vipers)	{ECHO;}
S[Tt]\." "L[Oo][Uu][Ii][Ss]	{printPPL(yytext);}
(East" ")?S[Tt]" "L[Oo][Uu][Ii][Ss]	{printPPL(yytext);}
S(aint|ankt|t|\:t)" "Peterstorget	{printFNC(yytext);}
{U}[^\n ]+" de la Croix"	{printPPL(yytext);}
"klubben "(Saint|S:t|St)" "Germain	{ECHO;}
S(t\.|aint|\:t|t)" "(Gervais|Germain|Tropez|Mellion|John|Anton|Nazaire|Louis|Paul|"Pierre And Miquelon"|"Croix Falls")	{printPPL(yytext);}
{U}[^\n ]+(lm|holms|borgs)" "[Ss]tad	{printPPL(yytext);}
"Syd "[Aa]frika	{printPPL(yytext);}
"Surat Thani"	{printPPL(yytext);}
"Tapis Oilfield"	{printPPL(yytext);}
T[Ee][Ll]" "[Aa][Vv][Ii][Vv](\-omrdet|omrdet)?	{printPPL(yytext);}
"Tetlin Junction"	{printPPL(yytext);}
"Thanh Pho Ho Chi Minh"	{printPPL(yytext);}

"trion Ulan Bator"	{ECHO;}
"Ulan Bator"	{printPPL(yytext);}
"Unterr den Linden"	{printPPL(yytext);}
"Vila Real"	{printPPL(yytext);}
"Val "d(" \'"|[^\n ])" "{U}[^\n ]+	{printPPL(yytext);}
"Val Gardena"	{printPPL(yytext);}
"Venice of the North"	{printPPL(yytext);}
("Umm al"|"Viano do"|"Valle de la"|"Vale do"|"Ville des"|"Valle di")(" "{U}[^\n ]+)+	{printPPL(yytext);}
"Wadi Feiran"	{printPPL(yytext);}
"Walla Walla"	{printPPL(yytext);}
"Washington "D(\.C\.|"\. C\."|C|" "C)	{printPPL(yytext);}
(North|West|South)" "(Washington|Hollywood|Virginia|Carolina|Dakota|Shields)	{printPPL(yytext);}
"Wijk aan Zee"	{printPPL(yytext);}
"Wodizlaw Slaski"	{printPPL(yytext);}
{U}[^\n ]+s" gamla "stad	{printPPL(yytext);}

\n	{ECHO;}
.	{ECHO;}
%%
int printPPL (char *a)

{ printf("<ENAMEX TYPE=\"LOC\" SBT=\"PPL\">%s</ENAMEX>",a); return(1); }
int printGPL (char *a)

{ printf("<ENAMEX TYPE=\"LOC\" SBT=\"GPL\">%s</ENAMEX>",a); return(1); }
int printFNC (char *a)

{ printf("<ENAMEX TYPE=\"LOC\" SBT=\"FNC\">%s</ENAMEX>",a); return(1); }
int printSTR (char *a)

{ printf("<ENAMEX TYPE=\"LOC\" SBT=\"STR\">%s</ENAMEX>",a); return(1); }
int printASTR (char *a)

{ printf("<ENAMEX TYPE=\"LOC\" SBT=\"AST\">%s</ENAMEX>",yytext); return(1);}

main( argc, argv )
int argc;
char **argv;	
{
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  yylex(); return(0);
}
