/*
	File: LocAst.ll
	Author: Dimitrios Kokkinakis
	version: 071129
*/

%{
%}
U	[\101-\132\300-\335]
%{
  int printASTR (char *a,int x);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|MDC)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDD|MDO|MDI|MDC|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>				{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>					{ECHO;}

	/* MULTI AREAS - AST */

	/* ASTRAL */
	/* TAG: <ENAMEX TYPE="LOC" SBT="AST"></ENAMEX> */
("Planet Hollywood"|"Planet Prize"|Lyngalax|Lyngalaxen)	{ECHO;}
"Venus , Mars"	{printf("<ENAMEX TYPE=\"LOC\" SBT=\"AST\">Venus</ENAMEX> , <ENAMEX TYPE=\"LOC\" SBT=\"AST\">Mars</ENAMEX>");}

[^\n ]*([Ll]iv" "p|[Vv]atten" "p|aketen" till"|andskapet" "p|bana" runt"|bilderna" "av|fara" "till|farkoster" "p|flytta" "till|flg" "frbi|frd[enrna]*" till"|iltur" p"|jorden" "p|kanalerna" "p|kurs" mot"|landa" "p|landa[adet]*" "p|landning" "p|liv" "p|markprov" "frn|ner" p"|planet" "efter|prov" "p|resa" "till|resa" kring"|resan" till"|reser" "till|resorna" "till|riktning" "mot|sidan" "av|sond" "till|starkare" "n|stor" "som|tmosfren" "p|bild" "a[vf]|del" "av|trafik" "till|vintern" "p|vstndet" till"|vg" till"|vgen" "till|strlning" "frn|vg" "mot|fart" "mot)" "(Neptunus|Lyran|Mnen|Enceladus|Mercurius|Saturnus|Uranus|Mars|Titan|Venus|Pluto|Jupiter)	{printASTR(yytext,2);}

(lysande|kring|n|[Ii]|sknja|P)" "(Mer[ck]urius|Saturnus|Uranus|Venus|Lyran|Pluto|Jupiter|Neptunus)							{printASTR(yytext,1);}
(Mercuriu|Saturnu|Uranu|Mar|Venu|Pluto|Jupiter|Neptunu)s" "("tunna "atmosfr|atmosfr|bana)				{printASTR(yytext,0);}
	/* MOD (Jyrki Niemi): Corrected context direction */
(utforska|P)" Mars"				{printASTR(yytext,1);}
(Mercuriu|Saturnu|Uranu|Mar|Venu|Pluto|Jupiter)s" "(poler|magnetflt|yta)						{printASTR(yytext,11);}
Sedna" "kretsar				{printASTR(yytext,11);}
Hale\-Bopp\-kometen				{printASTR(yytext,0);}
(Vintergatan|Hale\-Bopp)(s)?(" svans"|" komet")?		{printASTR(yytext,0);}
([Gg]atu|[Bb]rs|[Hh]it)kometen(" "{U}[^\n ]*)+		{ECHO;}
[Aa]steroid(en)?" "[0-9]+" "[A-Z0-9]+		{printASTR(yytext,1);}
(grann)?(Stjrnan|[Kk]omet|[Ss]tjrnbild|[Pp]lanet|[Aa]steroid)(en|er|erna)?(" "{U}[^\n ]+)+					{printASTR(yytext,1);}
[Pp]laneterna(" "{U}[^ \n]*)+([ \,]+{U}[^ \n]*)*(" och"(" "{U}[^ \n]*)+)?						{printASTR(yytext,1);}
(rhundradets|En|Ett|rets|stads)" komet"		{ECHO;}
"komet \,"(" "{U}[^\n ]*)+			{printASTR(yytext,2);}
{U}[^\n ]+" komet"				{printASTR(yytext,0);}
("rymdsond till"|"meteorit kallad")(" "{U}[^\n ]*)+	{printASTR(yytext,2);}
{U}[^\n ]+meteoriten				{printASTR(yytext,0);} 
Marsmnen" "{U}[^\n ]+				{printASTR(yytext,0);}
{U}[^\n ]+galax(en)?(" "{U}[^\n ]+)*			{printASTR(yytext,0);}
[^\n ]*(piralgalax|[Gg]alaxhop|[Ss]tjrnhop)en(" "{U}[^\n ]+)+							{printASTR(yytext,0);}
[^\n ]*[Gg]alaxen" "[A-Z][^\n ]+(" "[0-9]+)?		{printASTR(yytext,0);}
{U}[^\n ][^\n ]+" "(galax|Centauri)			{printASTR(yytext,0);}
([Hh]ela|att|tidiga|[Ii])" Universum"		{printASTR(yytext,1);}
"ljusa stjrnan"(" "{U}[^\n ]*)+			{printASTR(yytext,2);}
"nrmaste stjrnan \,"(" "{U}[^\n ]*)+		{printASTR(yytext,3);}
[Ss]"tjrnan i Orion"				{printASTR(yytext,0);}
[^\n ]*"estbilden p "[Ss]"tjrnan"(" "{U}[^\n ]*)+	{printASTR(yytext,2);}
("stjrnorna i"|"nrheten av"|"stjrnan i")" "Karlavagnen	{printASTR(yytext,2);}
[A-Z][^\n\< ]+planetens" magra "marker		{printASTR(yytext,0);}
{U}[^\n ]+"s mne "{U}[^\n ]+			{printASTR(yytext,0);}
{U}[^\n ]+" som kretsar kring "{U}[^\n ]+		{printASTR(yytext,0);}
{U}[^\n ]+"s mne"(" \, "|" "){U}[^\n ]+		{printASTR(yytext,0);}
{U}[^\n ]+" \, som r "{U}[^\n ]+"s mne"		{printASTR(yytext,0);}
{U}[^\n ]+" , "{U}[^\n ]+"s stora mne"		{printASTR(yytext,0);}
"mnarna kring"(" "{U}[^\n ]*)+			{printASTR(yytext,2);}
"mnar \, som "{U}[^\n ]*			{printASTR(yytext,3);}
"mngrannar \, "{U}[^\n ]*" och "{U}[^\n ]*		{printASTR(yytext,2);}
[Mm]eteorit(en)?" "{U}[A-Z0-9]+			{printASTR(yytext,1);}
[Pp]" Jorden"				{printASTR(yytext,1);}
[Ss]tjrnsystem(et)?" "{U}[A-Z0-9]+			{printASTR(yytext,1);}

i" Castor"					{printASTR(yytext,1);}
Jupiter" och "Io	{printf("<ENAMEX TYPE=\"LOC\" SBT=\"AST\">Jupiter</ENAMEX> och <ENAMEX TYPE=\"LOC\" SBT=\"AST\">Io</ENAMEX>");}
Merkurius" och "Venus	{printf("<ENAMEX TYPE=\"LOC\" SBT=\"AST\">Merkurius</ENAMEX> och <ENAMEX TYPE=\"LOC\" SBT=\"AST\">Venus</ENAMEX>");}

\n	{ECHO;}
.	{ECHO;}
%%

int printASTR(char *a, int x)

{ int z=0; int c=yyleng;

if (x==0) printf("<ENAMEX TYPE=\"LOC\" SBT=\"AST\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"LOC\" SBT=\"AST\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"LOC\" SBT=\"AST\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"LOC\" SBT=\"AST\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"AST\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}

return(1);}

main( argc, argv )
int argc;
char **argv;
{
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  yylex();return(0);
}
