/*
        File: EvnPat.ll
        Author: Dimitrios Kokkinakis
        version: 070501
*/
%{
%}
CITAT	\"|\|\'|\'\'|`
U	[\101-\132\300-\335\&]
%{
int printWR (char *a, int x);
int printCE (char *a, int x);
int printWE (char *a, int x);
int printAE (char *a, int x);
int printRE (char *a, int x);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|TRM|PRS|WRK|TME|MDC)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|FRQ|GPL|HPL|HUM|MDC|MDS|MDD|MDO|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"\<TIMEX TYPE\="\"TME"\" SBT\=\""DAT\"\>[^\n\<]+"\<\/TIMEX\>"	{ECHO;}
(Arkitekt|Aktie|Resultat|Slogan|Tittar|Utomhus|Musik|Id|Talang|Lag|Boxnings)tvling(en)?	{ECHO;}
(ret|Dygnet)" Runt"	{ECHO;}
(Pris|Bild|Frge)tvling	{ECHO;}
Halvmaraton	{ECHO;}
(Lgre|Prisrelaterat|Lggs|Fattade|Frsta|Kort|Fr|Fyra|Kvvets|Stans|Samtliga|Rejl|Orent|Mitt|Mer|Efter|Vann|Bara|Liknande|Ngot|Utfallande|Att|Frutom|Hjt|Motsvarande|Mnga|Infr|Fortsatt|Strsta|vriga|r|Ovanp|Mindre|Fungerar|Fre|Hela|Sm|Samma|Sjlva|Vart|Vilken|Vad|Inget|Dessa|Denna|Vad|Hela|Minsta|Krisens|En|Stora|Om|Detta|Fritt|Betydande|S|Huru|Allt|\&\#x201D\;|sjukans|Anfll|Betydande|Men|Vid|P|Deras|Det|Den|Ett|Trots|Under|Jag|Frst|Medan|ver|Vldsamt|Nr|Nra|Kvllens|Sdana|Motsvarande|[^\n ]+siffriga|[^\n ]+sjns|[^\n ]+lvens)" "[a-z]*(aflopp|brllopp|nomlopp|inlopp|cup|lopp|belopp)(et|en)?	{ECHO;}
{U}[^\n ]+s" "(brllopp|upplopp)	{ECHO;}
(Gteborg|Stockholm)s" "(hamn)?inlopp	{ECHO;}
"med "{U}[^\n ]+" "[Pp]rix	{ECHO;}
(Lyfta|Nr|Sista|Ser)" pucken"	{ECHO;}
Denna" tour"	{ECHO;}
"European Tour Course"	{ECHO;}
"Gate Open"	{ECHO;}
	/**************************************************************************/
	/* WEATHER PHENOMENA, NATURAL DISASTERS (and other NATURAL PHENOMENA) ETC */
	/**************************************************************************/
	/* TAG: <ENAMEX TYPE="EVN" SBT="WTH"></ENAMEX> */
([Vv]derfenomenet|Ovdret|[Hh]urricane|[Cc]yclone)(" "{U}[^\n ]+)+	{printWE(yytext,1);}
[^\n ]*([Ss]torm|[Tt]yfon|[Cc]yklon|[Oo]rkan|[Vv]ind)en(" "{U}[^\n ]+)+	{printWE(yytext,1);}
[^\n ]*([Ss]torm|[Tt]yfon|[Cc]yklon|[Oo]rkan|[Vv]ind)en" \" "{U}[^\n\"]+" \""	{printWE(yytext,1);}
	/********************************************************/
	/* HISTORICAL & POLITICAL: WARS, ACCIDENTS, REVOLUTIONS */
	/********************************************************/
(Fortsttnings|Sprk|Drog|Spa|Siffer|Rabatt|Stor|Fotbolls|Inbrdes|l|Kns|Krleks|Propaganda|Ord|Sj|Bil|TV\-|Biff|Handels|Gerilla|Knark|Pris|Kultur|Bensin)krig(en|et)?	{ECHO;}
(Spion|Mut|Fond|Finans|Arrangrs|Ls|Sex|Porr|Huligan|Flykting|Doping|Milj|Lsk)skandal	{ECHO;}
(Stor|Varnings|Hunger|Pilot|Tg|Massa)strejk(en)?	{ECHO;}
(Gas|Flyg|Trapp|Olje|Fartygs|Dds|Sj|Trafik)olyckan	{ECHO;}
(Informations|IT\-)revolution(en)	{ECHO;}
(Energi|Freds|Kris|Frsvars|Pensions)uppgrelse(n)?	{ECHO;}
[^\n ]*(ilitr|tor|Nato|fred|\-)vningen(" "{U}[^\n ]*)+	{printWR(yytext,0);}
[^\n ]+[^\nr ]"ska "[^\n ]*kriget	{printWR(yytext,0);}
{CITAT}" Operation"(" "[^\n\"\'\]+)+" "{CITAT}	{printWR(yytext,0);}
[^\n ]*"peration "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printWR(yytext,0);}
	/* MOD (Jyrki Niemi): Rule was split into two because of different
	   context sizes:
	[^\n ]*(perationen" kallas"|inle[dte]+" operation"|"razzian med namnet")(" "{U}[^\n ]*)+	{printWR(yytext,2);}
	*/
[^\n ]*(perationen" kallas"|inle[dte]+" operation")(" "{U}[^\n ]*)+	{printWR(yytext,2);}
[^\n ]*"razzian med namnet"(" "{U}[^\n ]*)+	{printWR(yytext,3);}
[^\n ]*perationen" kallas "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printWR(yytext,2);}
{U}+:s" "[Oo]peration(" "{U}[^\n ]*)+	{printWR(yytext,1);}
[^\n ]*peration" "([Tt]rafiknykterhet|[^\n ]+storm|Desert|Anakonda|[Kk]rogsanering|Barbarossa|[Kk]ondor)(" "{U}[^\n ]+)?	{printWR(yytext,0);}
([Ss]j)?[Ss]"laget vid"(" "{U}[^\n ]*)+(" bro")?	{printWR(yytext,0);}
[Bb]"efrielsen av"(" "{U}[^\n ]*)+	{printWR(yytext,0);}
{U}[^\n ]+krig(en|et)?	{/* Gulf-kriget*/printWR(yytext,0);}
{U}[^\n ]+uppgrelse(n)?	{/*Versaillesuppg*/printWR(yytext,0);}
{U}[^\n ]+(revolt|konflikt|revolution|skandal|olyckan|pakten|strejken|slakten|uppror)(en|et)?	{printWR(yytext,0);}
[Ii]"nfr "{U}[^\n ]+(mtet|"\:s mte")	{printWR(yytext,1);}
tala(r|de)" vid "{U}[^\n ]+mtet	{printWR(yytext,2);}
({U}+|Opec)\-(topp)?mte(t)?	{printWR(yytext,0);}
({U}+\:|Opec|Nato|[^\n ]+\-lnderna|Europardet|OSSE-ledarna)s" "[^\n ]*mte(t)?	{printWR(yytext,0);}
"Sharm el"[^\n ]+mtet	{printWR(yytext,0);}
[^\n ]*ampanj(en)?" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printWR(yytext,1);}
[^\n ]*[Kk]ampanj(en)?" "{U}[^\n ]+" "(till|mot|fr)" "[^\n ]+	{printWR(yytext,0);}
[^\n ]*[Kk]ampanj(en)?" "({U}[^\n ]+are|Lyckad|Fem|Stoppa|Rena|Nej|Vga)" "[^\n ]+	{printWR(yytext,0);}
[^\n ]*[Kk]ampanjen(" "{U}[^\n ]+)+	{printWR(yytext,0);}
[^\n ]*[Kk]ampanje(n|r)" som "{U}[^\n ]+" "(for|to)(" "{U}[^\n ]+)+	{printWR(yytext,0);}
{U}[^\n ][^\n ]+[astg]" "[^\n ]+\-kampanj(er|en)?	{printWR(yytext,0);}
"Internationella kampanjen "(mot|fr)" "[^\n ]+	{printWR(yytext,0);}
{CITAT}" "[Mm]anifestation(" "[^\n\"\'\]+)+" "{CITAT}	{printWR(yytext,0);} 
[^\n ]*[Mm]anifestation(en)?(" "{U}[^\n ]+)+(" the "[^\n ]+)?	{printWR(yytext,0);}
[^\n ]*[Mm]anifestation(en)?" "[^\n ]+are" mot "[^\n ]+	{printWR(yytext,0);}
Manifestation(en)?" mot "[^\n ]+	{printWR(yytext,0);}
{U}[^\n ]+(s|" "AB\:s)" "[^\n ]+sstmma	{printWR(yytext,0);}
(Sveriges" "[^\n ]+|Invik|{U}+\:|{U}+)s" "stmma	{printWR(yytext,0);}
([Ee]lfte|11)(\-september|" "september\-|" "september)[ad][a-z]+	{printWR(yytext,0);}
("World Trade "[^\n ]+xplosionen|[Dd]"agen D")	{printWR(yytext,0);}
[Ee]fter" "("Cyperns delning"|"11:e september"|"Pearl Harbor")	{printWR(yytext,1);}
[^\n ]*[Mm]assakern" "(vid|i)" "{U}[^\n ]+(" "[0-9]+)?	{printWR(yytext,0);}
{U}[^\n ]+\-(rttegnge|massaker)n(" "[0-9]+)?	{printWR(yytext,0);}
"vid "{U}[^\n ]+" "[^\n ]+s" "[^\n ]*(mte|demonstration|invigning|kongress|stmma|symposium)	{printWR(yytext,1);}
"vid "{U}[^\n ]+s" "[^\n ]*(konferens|demonstration|invigning|kongress|stmma|symposium)	{printWR(yytext,1);}
"vid "({U}[^\n ]+" ")+[^\n ]*(trff|trffen|mte|mtet)	{printWR(yytext,1);}
"vid "{U}[^\n ]+mtet	{printWR(yytext,1);}
{U}[^\n ]+"s Vnners rsmte"	{printWR(yytext,0);}
(mp|s|v|kd|{U}+)\-kongress(en)?	{printWR(yytext,0);}
{U}[^\n ]+(\-intifadan|\-kampanj|\-fred|\-attentatet|\-manifestation|paktsinvasion|\-trff)(en|er)?	{printWR(yytext,0);}
(Bastilj|Sovjetunion)ens" "[^\n ]*(fall|sammanbrott)	{printWR(yytext,0);}
	/*******************/
	/* ATHLETIC EVENTS */
	/*******************/
Nutektvling	{printCE(yytext,0);}
"vlingen Miss Universum"	{printCE(yytext,1);}
	/* TAG: <ENAMEX TYPE="EVN" SBT="ATL"> */
("Giro "d[^\n ]+Italia|O\-ringen|super-G)	{printAE(yytext,0);}
({U}[^\n ]+" ")*"Rolex International"	{printAE(yytext,0);}
("Grand Prix"|"Golden "[Ll]eague)\-(tv|gal|ser)[a-z]+	{printAE(yytext,0);}
Round" Robin"(" "[I]+)?	{printAE(yytext,0);}
[^\n ]*"festivalens Prix de "{U}[^\n ]+	{/*vann xxxfestivalens*/ECHO;}
"Giro "d(i|elle|\'|" \'"|" \"")" "{U}[^\n ]+	{printAE(yytext,0);}
([Tt]our" de"|"Coupe du")(" "{U}[^\n ]+)+	{printAE(yytext,0);}
({U}[^\n ]+" ")+"Awards Competition"	{printCE(yytext,0);}
International(" "{U}[^\n ]+)+" Competition"	{printAE(yytext,0);}
[^\n ]*[Oo]"lympiska "[^\n ]*[Ss]pel(et|en)?	{printAE(yytext,0);}
("Grand ")?"Prix "(des|du|de|of)" "[^\n ]+	{printAE(yytext,0);}
("Grand ")?"Prix "d(\'|" \'"|"\' "){U}[^\n ]+	{printAE(yytext,0);}
({U}[^\n ]+" ")*"Grand "([Ss]lam|Prix)(\-serie|\-kvalet|\-tvling[a-z]*|\-[a-z]*final[enr]*|\-[a-z]*match|\-[a-z]*turnering)?	{printAE(yytext,0);}
(F|[Ff]ormel)" "[1-3][0]*(\-[Mm]sterskap|\-VM|\-lopp|\-tvling)?(et|en|ar)?	{printAE(yytext,0);}
({U}[^\n ]+" ")*(SAS|Buick|Top|Hill)" Invitational"	{printAE(yytext,0);}
{U}[^\n ]+s" "GP	{printAE(yytext,0);}
(ponny|ungdoms)\-GP	{printAE(yytext,0);}
("Monte Carlos ")?(World|Master)" Series"(\-turnering[a-z]*)?	{printAE(yytext,0);}
(Master|Paris)" "[^\n ]*turnering[a-z]*	{printAE(yytext,0);}
(klassiska|kra|krde|[]rets|[Vv]ann)" "("Le Mans"|Daytona)	{printAE(yytext,1);}
"upplaga av "("Le Mans"|Daytona)	{printAE(yytext,2);}
(Drottning|Konung)" "{U}[^\n ]+" Pokal"	{printAE(yytext,0);}
([Ss]amvldes|Knalle|[Vv]inter|[Ss]ommar)spelen(" "[12][0-9][0-9][0-9])?	{printAE(yytext,0);}
[0-9]+\:e" "PGA\-tourtvling	{printAE(yytext,0);}
S(t|t\.)" "{U}[^\n ]+" Classic"	{printAE(yytext,0);}
"Le Mans"(" "|\-)([0-9]+|24\-timmarslopp)	{printAE(yytext,0);}
(Ironman|{U}[^\n ]+spelen)" "[12][0-9][0-9][0-9]	{printAE(yytext,0);}
(Sofia|Victoria|Elit|Vasa|Sverige)lopp(en|et)?	{printAE(yytext,0);}
"Msterskap i "{U}[^\n ]+(rally|racing)	{printAE(yytext,0);}
	/* KEYWORRD + X; Sure cases */
	/* restrictive with the suffix +spel, cause of strange cases */
[^\n ]*(urner|vl)ingen" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printAE(yytext,1);}
[^\n ]*"vlingen "({U}[^\n ]*" ")+(de|Trophy|Speedway|Masters|International|Classic|Volley)(" "{U}[^\n ]+)*	{printAE(yytext,1);}
[^\n ]*"vlingen "({U}[^\n ]+" ")+"of the World"	{printAE(yytext,1);}
[^\n ]*"vlingen "het(er|te)(" "{U}[^\n ]+)+	{printAE(yytext,2);}
(i|fr)" "({U}[^\n ]+" ")+(Trophy|Speedway|Masters|Classic|Volley)	{printAE(yytext,1);}
[^\n ]*"finalist i "{U}[^\n ]+(" "{U}[^\n ]+)+	{printAE(yytext,2);}
[^\n ]*frgetvlingen(" "{U}[^\n ]+)+	{printCE(yytext,1);}
[^\n ]*(vling|urnering)(en)?(" "{U}[^\n ]+)+	{printAE(yytext,1);}
[^\n ]*"vling av Super"(" "{U}[^\n ]+)+	{printAE(yytext,1);}
[Vv]ann" "({U}[^\n ]*" ")+(Trophy|Speedway|Masters|International|Classic|Minne)	{printAE(yytext,1);}
(spela[rdet]*|mtet|arrangera[rdet]*)" "({U}[^\n ]*" ")+(Trophy|International|Classic)	{printAE(yytext,1);}
"p "({U}[^\n ]*" ")+Speedway	{printAE(yytext,1);}
[^\n ]*"loppet Prix "[^\n ][^\n ]?(" ")?[^\n ]?" "(France|Am[e]rique)	{/*d'*/printAE(yytext,1);}
[^\n ]*"loppet Prix"(" "{U}[^\n ]+)+	{printAE(yytext,1);}
[^\n ]*turneringen" i "[^\n ]+" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printAE(yytext,3);}
[^\n ]*(meters|mmars|araton|agars|tapp|vslutnings|dsko|cuit\-|stor|rav|ykel|trt)lopp(et)?" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printAE(yytext,1);}
[^\n ]*ykelloppet(" "{U}[^\n ]+)+" "(runt|d[^\n ]{U}[^\n ]+|de" "{U}[^\n ]+)	{printAE(yytext,1);}
[^\n ]*(meters|mmars|raton|agars|tapp|vslutnings|dsko|cuit\-|stor|rav|ykel|trt)loppe[tn](" "{U}[^\n ]+)+	{printAE(yytext,1);}
	/* X + Keyword */
({U}[^\n ]+" ")+[^\n ]*(League|[Cc]up)(\-)?(frlggning|mtet|invigning|tvling|match|premir|final|semifinal|kvalet|kval)(en|er|arna|erna)?	{printAE(yytext,0);}
[Ss]uper\-{U}[^\n ]*(up|tvling|tour)(en)?	{/*super-G-tvling*/printAE(yytext,0);}
(SOC\:s|[Ss]uper|Grand)" "[^\n ]*([Cc]up|[^\n ]tvling|tour)(en)?	{/*super G-tvling*/printAE(yytext,0);}
{U}[^\n ]+" "{U}[^\n ]*tvling(en)?	{/*US Open-tvling*/printAE(yytext,0);}
({U}[^\n ]+" ")+[Tt]our(n|nament|\-final|\-tvling)?	{printAE(yytext,0);}
({U}[^\n ]+" ")+[^\n ]*[Cc]up(en|ens|s)?(" "[a-z]+" kvalomgng")?	{printAE(yytext,0);}
({U}[^\n ]+" ")+[Pp]rix(" Competition")?	{printAE(yytext,0);}
({U}[^\n ]+" ")*(Mercedes|Open|Touring)" "Champ(ionships)?	{printAE(yytext,0);}
({U}[^\n ]+" ")+Open(\-)?(tvlingarna|kvalet|[a-z]*final|[a-z]*finalen)?	{/*French Open*/printAE(yytext,0);}
"Whitbread Round "[Tt]he" World Race"(" "[Ff]or" The Volvo Trophy")?	{printAE(yytext,0);}
({U}[^\n ]+" ")+"the "{U}[^\n ]+" Race"	{printAE(yytext,0);}
({U}[^\n ]+" ")+Race(s)?	{/*Tall Ships Race*/printAE(yytext,0);}
({U}[^\n ]+" ")+("Grand National"|"Truck Trial"|"Challenge Invitation"|Runt|Challenge|[Mm]arathon|Maraton|Challenger|"World Final"|"All Stars"|Games|[^\n ]*[Pp]ucken|[Pp]rix\-serie|Championship|Carlo\-rallyt|Remo\-rallyt|Rally|Rallyt|League|Galopp)(s)?	{printAE(yytext,0);}
[]"rets "{U}[^\n ]+" runt"	{printAE(yytext,1);}
"etappen av "{U}[^\n ]+" runt"	{printAE(yytext,2);}
{U}[^\n ]+" "{U}[^\n ]+"\-finalen"	{/*Super Bowl-...*/printAE(yytext,0);}
({U}[^\n ]+" ")+Extravaganza	{printCE(yytext,0);}
(Under|Vann|Fre|En|Nsta|Efter|Vinna|Bsta|rets|Sjlva|Innan|Vilken)" turnering"(en)?	{ECHO;}
{U}[^\n ]+" "[^\n ]+(urnering|ompetition|athlon)(en)?	{printAE(yytext,0);}
({U}[^\n ]+" ")*{U}[^\n ]+(final|slut|cup)spel(en|et)?	{printAE(yytext,0);}
"Svenska "[^\n ]+spelen	{printAE(yytext,0);}
(CD\-ROM|Station)\-spel(et)?	{ECHO;}
[^\n ]*"klubb i "{U}[^\n ]+spel(en|et)?	{printAE(yytext,2);}
({U}[^\n ]+" ")*{U}[^\n ][^\n ]+\-spel(en|et)?	{printAE(yytext,0);}
{U}[^\n ]+"ska ppna msterskap"(en|et)?	{printAE(yytext,0);}
[0-9]+"\:e upplagan av "{U}[^\n ]+festivalen	{printCE(yytext,3);}
[0-9]+"\:e upplagan av"(" "{U}[^\n ]+)+(" "[Cc]up)?	{printAE(yytext,3);}
([Ii]|till)" "(Jmtlands|by)" Stora Pris"	{printAE(yytext,1);}
[^\n ]*seger(n)?" "(p|i)" "{U}[^\n ]+(tour|pokal)en	{printAE(yytext,2);}
[^\n ]*seger(n)?" "(p|i)" "(STCC|Postgirot|Silverhsten)	{printAE(yytext,2);}
[^\n ]*final(en)?" av "{U}[^\n ]+(tour|pokal)en	{printAE(yytext,2);}
[^\n ]*final(en)?" av "({U}[^\n ]+" ")+Series	{printAE(yytext,2);}
[^\n ]*final(en)?" i "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printAE(yytext,2);}
[^\n ]*etapp" p Girot"	{printAE(yytext,2);}
	/* Sure cases */
	/* (Paralympics|Allsvenskan|Superbowl|Vansbrosimningen|O\-[Rr]ingen|Vtternrundan|Finnkampen){printAE(yytext,0);}*/
[Oo]\-[Rr]ingen	{printAE(yytext,0);}
{U}+\-tourens" avslutningsrunda"	{printAE(yytext,0);}
[Ff]"ormula "[1-3]	{printAE(yytext,0);}
[Ss]chlager\-[SE]"M "[0-9]+	{printCE(yytext,0);}
[Ss]chlager" "[SE][Mm]" "[0-9]+	{printCE(yytext,0);}
([Hh]emma\-|[^\n ]+\-)?[DVES]M(" "[0-9]+)?	{printAE(yytext,0);}
[^\n ]+\-[DVES]M(\-[0-9]+|\-turneringen)	{printAE(yytext,0);}
"Indy "[0-9]+	{printAE(yytext,0);}
"GP "[1I]+	{printAE(yytext,0);}
([0-9]+\:e" ")?{U}[^\n ]+olympiaden	{printAE(yytext,0);}
(Sydney|"Salt Lake"|handikapp|sommar|vinter|"Los Angeles")\-OS(\-[0-9]+)?	{printAE(yytext,0);}
([^\n ]+\-)?OS(\-final|\-fest|\-semifinal|\-kval|\-kvalmatch|\-invigning)(en)?(" "[0-9]+)?	{printAE(yytext,0);}
([^\n ]+\-)?OS(" "[0-9]+)?	{printAE(yytext,0);}
([^\n ]+\-)?J?[DVES]M\-(final|fest|semifinal|kval|kvalmatch|invigning)(en)?	{printAE(yytext,0);}
([^\n ]+\-)?J?[DVES]M(" "[0-9]+)?	{printAE(yytext,0);}
{U}[^\n ]+ska" "[Mm]sterskap(en|et)?	{printAE(yytext,0);}
V75\-([1-9]|lopp|loppen)	{printAE(yytext,0);}
	/* Compounds */
(BBC|TV|CD|fiction|alla)\-serie(n)?	{ECHO;}
(Hemma|Hemside|Golf|Lag|Rock)tvling	{ECHO;}
(Gene|Natu)rally	{ECHO;}
(Fr|In)segling(en)?	{ECHO;}
Duotrav	{ECHO;}
{U}[^\n ]+(cup|cupfinal|stafett|[Pp]uck)(en)?	{printAE(yytext,0);}
{U}[^\n\" ]+[^0-9Vv \n](\-|final|lit)serie(n)?	{/*20-serien*/printAE(yytext,0);}
("San "|"Monte "){U}[^\n ]+" "[^\n ]*[Rr]ally(n|t)?	{printAE(yytext,0);}
[^\n ]*seglingen(" "{U}[^\n ]+)+	{printAE(yytext,0);}
{U}[^\n ]*segling(en|ar)?	{printAE(yytext,0);}
{U}[^\n ]*t(vl|urner)ing(en)?	{printAE(yytext,0);}
{U}[^\n ]*trav(en|et)?	{printAE(yytext,0);}
{U}[^\n ]*(trampet|araton|sregattan)	{printAE(yytext,0);}
(kast|ganger|floppat|raka|frammarsch)" i Wimbledon"	{printAE(yytext,2);}
(Vann|infr|vann|avgrs|vunnit|rets|spelat)" "(Challengers|Touren|Wimbledon|Akropolis)(" "[12][0-9][0-9][0-9])?	{printAE(yytext,1);}
(Vann|infr|vann|avgrs|vunnit|rets)(" "{U}[^\n ]+)+" "(International|Cir[cq]uit|Touren|Memorial)	{printAE(yytext,1);}
({U}[^\n ]+" ")+"International spelades"	{printAE(yytext,101);}
(rs|segla|frsta|i)" "Whitbread	{printAE(yytext,1);}
springa" "{U}[^\n ]+(maran|loppet|orienteringen)	{printAE(yytext,1);}
penningstinna(" "{U}[^\n ]+)+	{printAE(yytext,1);}
	/*******************/
	/* CULTURAL EVENTS */
	/*******************/
	/* TAG: <ENAMEX TYPE="EVN" SBT="CLU"> */
(Hade|Innan|Ingen|Min|Utver|Stor|Antingen|Frsta|Trots|Fast|Frn|Frutom|Efter|Att|Den|ven|S|Sen|Nr|Med|Frn|Men|En|Hennes|Bakom|Denna|Kring|Och|Infr|Om|P|Varken|Samma|rets|Under|Till|Vid|Frra|Bush)" "[a-z]*(kongress|festival|stllning)(en)?	{ECHO;}
[^\n ]*[Aa]uktion(en)?" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printCE(yytext,0);}
	/* Utstllning/Frestllning */
"Slutstllning \:"	{ECHO;}
[^\n ]*[^\nb ][et]stllning(en)?" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printCE(yytext,0);}
[^\n ]*[^\nb ][et]stllning(en)?" "(heter|\:|kallad)" "{CITAT}(" "[^\"\'\]+)+{CITAT}	{printCE(yytext,2);}
[^\n ]*[^\nb ][et]stllning(en)?" "(heter|kallad)" "(The|Ett|A|This)" "[^\n ]+(" "{U}[^\n ]+)*	{printCE(yytext,2);}
[^\n ]*[^\n l]?[^\nb ][et]stllning(en)?" "(heter|\:|kallad)(" "{U}[^\n ]+)+	{printCE(yytext,2);}
[^\n ]*[^\nb ][et]"stllningen \,"(" "{U}[^\n\,\- ]+)+" "(\-|\,|\.|\;|\!)	{printCE(yytext,21);}
[^\n ]*[^\nb ][et]stllning(en)?" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+	{printCE(yytext,0);}
[^\n ]*[^\nb ][et]stllning(en)?" "{U}[^\n ]+(erna|enska|vla|ande|ets|ors|ens|tio|ins)" "[^\n ]+(" "{U}[^\n ]+)*	{printCE(yytext,0);}
[^\n ]*[^\nb ][et]stllning(en)?" "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" "(\?|\,|\.|\-|\;)	{printCE(yytext,0);}
[^\n ]*[^\nb ][et]stllning(en)?" "{U}[^\n ]+" "("on the"|of|bl|is|from|in|och|and|egna)" "[^\n ]+	{printCE(yytext,0);}
({U}[^\n ]*s|hans|hennes|sin)" utstllning"(" "[A-Z0-9][^\n ]+)+	{printCE(yytext,1);}
[^\n ]*[^\nb ][et]stllningen(" "{U}[^\n ]+)+	{printCE(yytext,0);}
[Uu]tstllningen" \- kallad"(" "{U}[^\n\- ]+)+" \-"	{printCE(yytext,301);}
{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}" \, utstllning"	{printCE(yytext,102);}
([Ss]how|[Uu]tstllning)(en)?" som "(hette|heter)(" "{U}[^\n\- ]+)+	{printCE(yytext,3);}
(Dans|Familje)frestllning(en)?	{ECHO;}
(Slut|Be|Fre|Ut|Konstut|Slutut|Skrift)stllning(en)?	{ECHO;}
"My Fair Lady"	{ECHO;}
"Vanity Fair"	{ECHO;}
(En|Vr|Ny|Hennes|Fartfylld|Eller|Deras|Stor)" "[^\n ]*show	{ECHO;}
{U}[^\n ]*" "{U}[^\n ]*\-utstllning(en)?	{printCE(yytext,0);}
{U}[^\n ]*[et]stllning(en)?	{printCE(yytext,0);}
[^\n ]*utstllning" med namn"(" "{U}[^\n ]+)+	{printCE(yytext,3);}
{CITAT}(" "[^\"\'\\n]+)+" "{CITAT}" "(heter|heter|hette)" "(ut|fre)stllningen	{printCE(yytext,102);}
[^\n ]*utstllningarna" "{CITAT}(" "[^\"\'\\n]+)+" "{CITAT}	{printCE(yytext,0);}
{U}[^\n ]*" \& "{U}[^\n ]*" p Louisiana"	{printCE(yytext,102);}
"efter Grammys"	{printCE(yytext,1);}
[Ii]"nvigningen av "{U}[^\n ]+dag(arna|en)	{printCE(yytext,2);}
[^\n ]*seminarium" om "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printCE(yytext,2);}
([Tt]he" ")?({U}[^\n ]+" ")+Fair	{printCE(yytext,0);}
"Monte Carlos "[0-9]+"\:e "[^\n ]*festival	{printCE(yytext,0);}
(Cannes|Eurovisionens|Nordisk|Kpenhamns|Berlins|Giffon|Roslagen|Barnens|Tempo|mls|Falu|Popcorn|Montreals|[^\n ]+holms|[^\n ]+dals|Venedigs)" "[^\n ]+festival	{printCE(yytext,0);}
[0-9]+"\:e "[^\n ]*festivalen" i Cannes"	{printCE(yytext,0);}
({U}[^\n ]+" ")+[Jj]"azz "[Ff]estival	{printCE(yytext,0);}
{U}[^\n ]+(holm|borg)s?" "[^\n ]+\-" och "[^\n ]+festival(en)?	{printCE(yytext,0);}
{U}[^\n ]+(holm|borg)s?" "(film|{U}[^\n ]*)festival(en)?	{printCE(yytext,0);}
({U}[^\n ]+" ")+"International "{U}[^\n ]+festival	{printCE(yytext,0);}
({U}[^\n ]+" ")+(Festival|[^\n ]*estivalen)	{printCE(yytext,0);}
[0-9]+th(" "{U}[^\n ]+)*" "(Symposium|Conference)" on"(" "{U}[^\n ]+)*	{printCE(yytext,0);}
	/* MOD (Jyrki Niemi): Fixed * to + in the name part */
[^\n ]*onferens(en)?" "(heter|hette)(" "{U}[^\n ]+)+	{printCE(yytext,2);}
Pop[Ss]tad" "[0-9]+	{printCE(yytext,0);}
{U}[^\n ]+" "([A-Z0-9][^\n ]+" ")+[^\n ]+onferen(s|sen|ce)	{printCE(yytext,0);}
("Folk och "[Ff]rsvar|{U}[^\n ]+)s" "[^\n ]+onferen(s|ce)" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printCE(yytext,0);}
(Future|Rotarys|"Folk och "[Ff]rsvars|{U}[^\n ]+"\:s")" "[^\n ]+onferen(s|ce)	{printCE(yytext,0);}
[Ii]nternationella" "{U}[^\n ]+(kongress|salong|symposium)(en)?	{printCE(yytext,0);}
("the ")?({U}[^\n ]+" ")+[^\n ]+(orkshop|ongress)(en)?" "(on|of|in)(" "{U}[^\n ]+)+	{printCE(yytext,0);}
("the ")?({U}[^\n ]+" ")+[^\n ]+(orkshop|ongress)(en)?	{printCE(yytext,0);}
{U}[^\n ]+\-kongressen	{printCE(yytext,0);}
{U}[^\n ]+:s" "[^\n ]+[ea]" "[Ss]ymposium	{printCE(yytext,0);}
({U}[^\n ]+" ")*[^\n ]*Expo(n)?(\-[0-9]+)?	{/*BoExpo*/printCE(yytext,0);}
{U}[^\n ]+" "[Jj]azz" "[0-9]+	{printCE(yytext,0);}
({U}[^\n ]+" ")+Contest	{printCE(yytext,0);}
([Pp]|[Uu]nder)(" "{U}[^\n ]+)*" Telecom "[0-9]+	{printCE(yytext,1);}
"p "{U}[^\n ]+" "{U}[^\n ]+galan	{printCE(yytext,1);}
[^\n ]*[Kk]on(fer[ea]ns|gress|ventet)(en)?" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printCE(yytext,1);}
[^\n ]*[Kk]on(fer[ea]ns|gress|ventet)(en)?(" "{U}[^\n ]+)+	{printCE(yytext,1);}
[^\n ]*festival(en)?" kallad "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printCE(yytext,2);}
[^\n ]*festival(en)?" hade namnet "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printCE(yytext,3);}
[^\n ]*festival(en)?" \- "{U}[^\n ]+" the "{U}[^\n ]+" \-"	{printCE(yytext,1);}
[^\n ]*(ymposiet|alangjakten)(" "{U}[^\n ]+)+	{printCE(yytext,1);}
(ppnar|stora)" "{U}[^\n ]+(holm|borg)s" "[^\n ]*festival(" "{U}[^\n ]+)+	{printCE(yytext,1);}
"arrangrerna bakom"(" "{U}[^\n ]+)+	{printCE(yytext,2);}
([]rets|[0-9]+\a)" "{U}[^\n ]+gala(n)?	{printCE(yytext,0);}
{U}[^\n ]+s" Musikvecka"	{printCE(yytext,0);}
"Festival de"(" "{U}[^\n ]+)+	{printCE(yytext,0);}
[^\n ]*(konserte|feste|estivale|[Mm]ssa)n" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printCE(yytext,1);}
[^\n ]*(fest|estival)en(" "{U}[^\n ]+)+	{/*small letters title*/printCE(yytext,0);}
[^\n ]*(kel|sik|ata|lyg|ese|t|om)"mssa "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printCE(yytext,0);}
[^\n ]*(ykel|usik|ata|lyg|ese|t|le[ck]om)mssa(" "{U}[^\n ]+)+(" "[0-9]+)?	{printCE(yytext,0);}
(Succ|Skils)mss(a|an)	{ECHO;}
{U}[^\n ]+" \& "{U}[^\n ]+mssa(n)?	{printCE(yytext,0);}
{U}[^\n ]+\-" och "{U}[^\n ]+mssa(n)?	{printCE(yytext,0);}
[^\n ]*[Mm]ssan" "{U}[^\n ]+" "(by|mot|fr)" "[^\n ]+	{printCE(yytext,1);}
[^\n ]*[Mm]ssan" Dagens "[^\n ]+(" "[0-9]+)?	{printCE(yytext,1);}
[^\n ]*[Mm]ssan(" "{U}[^\n ]+)+(" "[0-9]+)?	{printCE(yytext,1);}
{U}[^\n ]+"mssan p Svenska mssan"	{printCE(yytext,31);}
"Sveriges "{U}[^\n ]+"s jubileumsfirande"t?	{printCE(yytext,0);}
{U}[^\n ]+"s jubileumsfest"	{printCE(yytext,0);}
[]"rets "{U}[^\n ]+jubileum	{printCE(yytext,1);}
[^\n ]*[Ff]irandet" av"(" "{U}[^\n ]+)+" "[^\n ]*(rsjubiluem|festivalen)	{printCE(yytext,2);}
[^\n ]*[Ff]irandet" av"(" "{U}[^\n ]+)+	{printCE(yytext,2);}
"Nordiska "[^\n ]+" "[^\n ]+jubileum	{printCE(yytext,0);}
(SAS|Natos|U:s|Rigas)" "[^\n ]+jubileum	{printCE(yytext,0);}
{U}[^\n ]+" "{U}[^\n ]+\-konsert(en)?	{printCE(yytext,0);}
([Vv]re|[Hh]ste|[Ss]ommare|[Vv]inter)ns" "{U}[^\n ]+(utstllning|salong|festival|debatt|konserter)	{printCE(yytext,1);}
(p|"lokaler i")" Svenska Mssan"	{ECHO;}
{U}[^\n ]+a" "Mssan	{printCE(yytext,0);}
(Svenska" ")?{U}[^\n ]+biennalen	{printCE(yytext,0);}
{U}[^\n ]*seminariet	{printCE(yytext,0);}
{U}[^\n ]*festival(en)?	{printCE(yytext,0);}
{U}[^\n ]*expeditionen(" "{U}[^\n ]+)+(" "\-?[0-9]+)?	{printCE(yytext,0);}
[^\n ]*expeditionen" "{U}+	{printCE(yytext,1);}
([0-9]+" rs ")?{U}[^\n ]*konferens(en)?	{printCE(yytext,0);}
{U}[^\n ]*mss(a|an)	{printCE(yytext,0);}
Kulturb(ro|y)" "\-?[0-9]+	{printCE(yytext,0);}
[Aa]rrangrerna" "av(" "{U}[^\n ]+)+	{printCE(yytext,2);}
(insamlings|film|advents|[Tt][Vv]\-)galan(" "{U}[^\n ]+)+	{printCE(yytext,1);}
(Sven|Nordi|Vstsven)ska" "[^\n ]+(lm|rie|sik)dagar(na)?	{printCE(yytext,0);}
Fallens" "[^\n ]*dagar(na)?	{printCE(yytext,0);}
"Internationella dagen "(fr|mot)" "[^\n ]+	{printCE(yytext,0);}
([Dd]en" ")?[Ii]nternationella" "[^\n ]+dagen	{printCE(yytext,0);}
{U}[^\n ]+nas" "[Dd]ag	{printCE(yytext,0);}
	/*******************/
	/* RELIGIOUS EVENTS */
	/*******************/
	/* TAG: <ENAMEX TYPE="EVN" SBT="RLG"> */
("Jungfru Mari"[eas]+" bebdelse"|Domens|S:t" "[^\n ]+)" "[Dd]ag(en)?	{printRE(yytext,0);}
(Saint|S:t|St)" "{U}[^\n ]+" Day"	{printRE(yytext,0);}
"Sankt "{U}[^\n ]+dagen	{printRE(yytext,0);}
[^\n ]*[Hh]gtiden(" "{U}[^\n ]+)+	{printRE(yytext,1);}
[Ff]iras(" "{U}[^\n ]+)+" "[^\n ]*[Dd]ag(en)?	{printRE(yytext,1);}
[Ff]iras" "{U}[^\n ]+dag(en)?	{printRE(yytext,1);}
[^\n ]*mnaden" "Ramadan	{printRE(yytext,1);}
\n	{ECHO;}
.	{ECHO;}
%%
int printWR(char *a, int x)

{ int z=0; int c=yyleng;
     if (x==0) printf("<ENAMEX TYPE=\"EVN\" SBT=\"HPL\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"HPL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"HPL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"HPL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"HPL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==5){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"HPL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==31){
while(yytext[c]!=' ') c--; 
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"HPL\">"); z=z+1;
for(;z<c; putchar(yytext[z++])); printf("</ENAMEX>");
for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
int printWE(char *a, int x)

{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"EVN\" SBT=\"WTH\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"WTH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"WTH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);
}
int printCE(char *a, int x)

{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"EVN\" SBT=\"CLU\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"CLU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");
}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"CLU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"CLU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"CLU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==5){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"CLU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==102){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"EVN\" SBT=\"CLU\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
else if (x==21){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"EVN\" SBT=\"CLU\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
else if (x==301){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"EVN\" SBT=\"CLU\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
int printAE(char *a, int x)

{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"EVN\" SBT=\"ATL\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"ATL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"ATL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"ATL\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==101){
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"EVN\" SBT=\"CLU\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
int printRE(char *a, int x)

{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"EVN\" SBT=\"RLG\">%s</ENAMEX>",yytext); 
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"EVN\" SBT=\"RLG\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);
}

main( argc, argv )
int argc;
char **argv;        
{
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  yylex();return(0);
}
