!= ==============================================================
!= HFST Pmatch rule file manually converted from Flex source file
!= filterBadTags.ll
!= ==============================================================


!= ============================================================
!= Definitions of various regular expressions and GNU M4 macros
!= ============================================================

! Are the following definitions of partial tag names needed, as tags
! are now represented as single symbols?

Define Enamex {Enamex} ;
Define Numex {Numex} ;
Define Timex {Timex} ;

Define MainTagName [Enamex | Numex | Timex] ;
Define TagNamePart [UppercaseAlpha LowercaseAlpha LowercaseAlpha] ;
Define TagName [TagNamePart (TagNamePart (TagNamePart (TagNamePart)))] ;

m4_divert(-1)

m4_dnl Various M4 utility macro definitions

m4_dnl TODO: Add documentation

m4_define(`_ApplyAndJoin',
	  `m4_ifelse(`$#', `3', `$1(`$3')',
	  	     `$1(`$3')`'$2`'_ApplyAndJoin(`$1', `$2', m4_shift(m4_shift(m4_shift($@))))')')

m4_define(`_Apply', `_ApplyAndJoin(`$1', `, ', m4_shift($@))')

m4_define(`_AlternativesApply', `[ _ApplyAndJoin(`$1', `
	 | ', m4_shift($@)) ]')

m4_define(`_ApplyAndJoinNewline', `_ApplyAndJoin(`$1', `
', m4_shift($@))')

m4_define(`_ListApply', `_ApplyAndJoin(`$1', `, ', m4_shift($@))')

m4_define(`_Join',
	  `m4_ifelse(`$#', `2', `$2',
	  	     `$2$1`'_Join(`$1', m4_shift(m4_shift($@)))')')

m4_define(`_JoinNonEmpty2',
	  `m4_ifelse(`$2', `', `$3',
	             `$3', `', `$2',
		     `$2$1$3')')

m4_dnl From GNU M4 manual
m4_define(`_Curry', `$1(m4_shift($@,)_$0')
m4_define(`__Curry', ``$1')')

m4_dnl Used in currying
m4_define(`_Concat', `_Join(`', $@)')
m4_define(`_ConcatRev', `$2$1')
m4_define(`_EncloseStr', `_Concat(`$1', `$3', `$2')')

m4_define(`_AddPrefix', `_Apply(`_Curry(`_Concat', `$1')', m4_shift($@))')
m4_define(`_AddSuffix', `_Apply(`_Curry(`_ConcatRev', `$1')', m4_shift($@))')
m4_define(`_Enclose',
	  `_Apply(`_Curry(`_EncloseStr', `$1', `$2')', m4_shift(m4_shift($@)))')

m4_define(`_First', `$1')
m4_define(`_ItemCount', `$#')
m4_define(`_Quote', `$*')
m4_define(`_Dquote', ``$*'')
m4_define(`_ButLast',
	  `m4_ifelse(`$#', `0', `',
	             `$#', `1', `',
		     `$#', `2', `$1',
	             `$1, _ButLast(m4_shift($@))')')
m4_define(`_ButListLast',
	  `m4_ifelse(_ItemCount($1), `0', `',
	             _ItemCount($1), `1', `',
		     _ItemCount($1), `2', _First($1),
	             `_First($1), _ButListLast(_Dquote(m4_shift($1)))')')

# Why doesn't the following work? Maybe too much quoting.
# m4_define(`_Combine0',
# 	  `m4_ifelse(`_ItemCount($2)', `0', `',
# 	             `_ItemCount($2)', `1', `_AddPrefix(`_First($2)$1', $3)',
# 	             `_AddPrefix(`_First($2)$1', $3), _Combine(`$1', _Dquote(m4_shift($2)), `$3')')')

m4_dnl Note that _Combine takes the first list as the second parameter
m4_dnl and the second list as the rest.
m4_define(`_Combine',
	  `m4_ifelse(`$#', `3', `_AddSuffix(`$3$1', $2)',
	             `_AddSuffix(`$3$1', $2), _Combine(`$1', `$2', m4_shift(m4_shift(m4_shift($@))))')')

m4_define(`_Contains',
	  `m4_ifelse(`$1', `', `',
	  	     _First($1), `$2', `$2',
		     `_Contains(_Dquote(m4_shift($1)), `$2')')')

m4_define(`_Intersect',
	  `m4_ifelse(`$1', `', `',
		     `$2', `', `',
		     _Contains(`$1', _First($2)), _First($2),
			 `_JoinNonEmpty2(`,', _First($2),
			                 _Dquote(_Intersect(`$1', _Dquote(m4_shift($2)))))',
		     `_Intersect(`$1', _Dquote(m4_shift($2)))')')

m4_define(`_Insert', `["" -> [$1]]')
m4_define(`_InsertTr', `[m4_patsubst(`$1', `.', ` 0:%\&') ]')
m4_define(`_InsertSym', `0:"$1"')
m4_define(`_Remove', `[[$1] .o. [[$1].l -> ""]]')
m4_define(`_RemoveSym', `"$1":0')

m4_define(`_StartTag', `"<$1>"')
m4_define(`_StartTagEnamex', `_StartTag(`Enamex$1')')
m4_define(`_EndTag', `"</$1>"')

m4_define(`_DisambiguateTagEnamex',
	  `[_StartTag(`Enamex$1'):_StartTag(`Enamex$2')]')

# m4_define(`_AddStartTag0', `_Insert(`_StartTag(`$1')')')
m4_define(`_AddStartTag', `_InsertSym(`<$1>')')
m4_define(`_AddEndTag', `_InsertSym(`</$1>')')
m4_define(`_RemoveStartTag', `_RemoveSym(`<$1>')')
m4_define(`_RemoveEndTag', `_RemoveSym(`</$1>')')

m4_define(`_ReplaceStartTag', `RemoveStartTag$1 AddStartTag$2')

m4_define(`_TagTypes', `Enamex, Numex, Timex')

m4_define(`_TypesEnamex', `Evn, Loc, Obj, Org, Prs, Wrk')
m4_define(`_SubtypesEvn', `Atl, Clu, Hpl, Rlg, Wth')
m4_define(`_SubtypesLoc', `Ast, Fnc, Gpl, Ppl, Str')
m4_define(`_SubtypesObj', `Cmp, Fwp, Prd, Prz, Vha, Vhg, Vhw, Mdc')
m4_define(`_SubtypesOrg', `Arl, Ath, Clt, Crp, Edu, Fin, Plt, Tvr')
m4_define(`_SubtypesPrs', `Anm, Hum, Mth')
m4_define(`_SubtypesWrk', `Prj, Tvr, Waa, Wao, Wmd')

m4_define(`_TypesNumex', `Msr')
m4_define(`_SubtypesMsr', `Age, Cmu, Crd, Cur, Cvu, Dgr, Dns, Dst, Elu, Frq, Inx, Lst, Msu, Prc, Pss, Spd, Tel, Tmp, Vlm, Web, Wmu, Xxx')

m4_define(`_TypesTimex', `Tme')
m4_define(`_SubtypesTme', `Dat')

m4_define(`_TypeSubtypes', `_AddPrefix(`$1', _Subtypes$1)')

m4_define(`_MainTypeSubtypes', `_Apply(`_TypeSubtypes', _Types$1)')

m4_define(`_EnamexTypeSubtypes', `_MainTypeSubtypes(`Enamex')')

m4_define(`_AllMainTypeSubtypes',
	  `_ListApply(`_MainTypeSubtypes', _TagTypes)')

m4_define(`_TagDefsStartRemove',
	  `Define StartTag$1 _StartTag(`$2') ;
Define RemoveStartTag$1 _RemoveStartTag(`$2') ;
Define EndTag$1 _EndTag(`$2') ;
Define RemoveEndTag$1 _RemoveEndTag(`$2') ;')

m4_define(`_DefAlternatives',
	  `Define $1 _AlternativesApply(`_Curry(`_Concat', `$2')', $3) ;')

m4_define(`_TagDefsStartRemoveList',
	  `m4_define(`_List$1',
		     `_ListApply(`_Curry(`_Concat', `$2')', $3)')m4_dnl
	   _DefAlternatives(`StartTag$1', `StartTag$2', `$3')
_DefAlternatives(`RemoveStartTag$1', `RemoveStartTag$2', `$3')
_DefAlternatives(`EndTag$1', `EndTag$2', `$3')
_DefAlternatives(`RemoveEndTag$1', `RemoveEndTag$2', `$3')')

m4_define(`_TagDefs',
	  `_TagDefsStartRemove(`$1', `$2')
Define AddStartTag$1 _AddStartTag(`$2') ;
Define AddEndTag$1 _AddEndTag(`$2') ;')

m4_define(`_TagDefsType',
	  `_TagDefs(`$2', `$1$3', `$1')')
m4_define(`_TagDefsTypeSub',
	  `_TagDefsType(`$1', `$2$3', `$2$3')')

m4_define(`_TagDefsTypeStartRemove', `_TagDefsStartRemove(`$2', `$1 $3')')

m4_define(`_TagDefsTypes',
	  `_ApplyAndJoinNewline(`_Curry(`_TagDefsTypeSub', `$1', `$2')',
	  		        _Subtypes$2)
_TagDefsStartRemoveList(`$2', `$2', `_Subtypes$2')
')

m4_define(`_TagDefsAllTypes',
	  `_ApplyAndJoinNewline(`_Curry(`_TagDefsTypes', `$1')', _Types$1)')

m4_define(`_TagDefsEnamexStartRemove',
	  `_TagDefsTypeStartRemove(`Enamex', `$1', `$2')')

m4_define(`_TagDefsTypeStartRemoveAll',
	  `_TagDefsTypeStartRemove(`$1', `$1', `TagNamePart TagNamePart+')')

# The file ambiguous-tags.txt should contain the names of ambiguous
# tags, each on its own line.
m4_define(`_AllAmbigTypes',
	  `m4_translit(_Dquote(m4_patsubst(m4_include(`ambiguous-tags.txt'), `
\(\w\)', `, \1')), `
')')

# m4_define(`_TagAmbig0',
# 	  `_AlternativesApply(`_$1Tag',
# 	                      _AddPrefix(`$2', _Combine(`', `$3', $4)))')
m4_define(`_TagAmbig',
	  `_AlternativesApply(`_$1Tag',
	                      _Intersect(_Dquote(_AllAmbigTypes), _Dquote(_AddPrefix(`$2', _Combine(`', `$3', $4)))))')
m4_define(`_DefineTagAmbig',
	  `Define $1TagAmbiguous$2
        _TagAmbig(`$1', `$3', `$4', `$5') ;')
m4_define(`_DefineStartTagAmbig', `_DefineTagAmbig(`Start', $@)')
m4_define(`_DefineEndTagAmbig', `_DefineTagAmbig(`End', $@)')

m4_define(`_AnyStartTag',
	  `_AlternativesApply(`_StartTag',
			      _AddPrefix(`$1', _MainTypeSubtypes(`$1')))')
m4_define(`_AnyEndTag',
	  `_AlternativesApply(`_EndTag',
			      _AddPrefix(`$1', _MainTypeSubtypes(`$1')), `$1')')

# FIXME: The following assumes that _TypesTimex and _TypesNumex
# contain a single item
m4_define(`_FullTagName',
	  `m4_ifelse(m4_regexp(`$1', `\(Ena\|Nu\|Ti\)mex'), `0', `',
	  	     m4_substr(`$1', `0', `3'), _TypesNumex, `Numex',
	  	     m4_substr(`$1', `0', `3'), _TypesTimex, `Timex',
		     `Enamex')$1')

m4_divert(0)

! StartTag*, RemoveStartTag*, AddStartTag* for all tag types,
! generated by M4 macros.

_ApplyAndJoinNewline(`_TagDefsAllTypes', _TagTypes)

_TagDefsTypeSub(Enamex, `PrsHumUnu')
_TagDefsTypeSub(Enamex, `PrsHumPru')

m4_dnl _ApplyAndJoinNewline(`_TagDefsTypeStartRemoveAll', _TagTypes)

_TagDefsStartRemoveList(LocXpl, `Loc', `Ppl, Gpl')
_TagDefsStartRemoveList(LocPplOrGplOrFnc, `Loc', `Ppl, Gpl, Fnc')
_TagDefsStartRemoveList(WrkOrPrsOrLoc, `', `Wrk, Prs, Loc')
_TagDefsStartRemoveList(LocOrPrs, `', `Loc, Prs')
_TagDefsStartRemoveList(LocOrOrgOrWrk, `', `Loc, Org, Wrk')
_TagDefsStartRemoveList(ObjVhX, `Obj', `Vha, Vhg, Vhw')
_TagDefsStartRemoveList(OrgOrWrkOrPrs, `', `Org, Wrk, Prs')

! Ambiguous tags, generated by M4 macros

_DefineStartTagAmbig(Loc, Enamex, `_TypeSubtypes(Loc)', `_EnamexTypeSubtypes')
_DefineStartTagAmbig(LocOrg, Enamex, `_TypeSubtypes(Loc)', `_TypeSubtypes(Org)')
_DefineStartTagAmbig(LocPplOrgAth, Enamex, `LocPpl', `OrgAth')
_DefineStartTagAmbig(LocOrgAth, Enamex, `_TypeSubtypes(Loc)', `OrgAth')
_DefineStartTagAmbig(LocLocPplOrgAth, Enamex, `_TypeSubtypes(Loc)', `LocPpl, OrgAth')
_DefineStartTagAmbig(LocPrs, Enamex, `_TypeSubtypes(Loc)', `_TypeSubtypes(Prs)')
_DefineStartTagAmbig(LocPrsHum, Enamex, `_TypeSubtypes(Loc)', `PrsHum')
_DefineStartTagAmbig(LocPplPrsHum, Enamex, `LocPpl', `PrsHum')
_DefineStartTagAmbig(LocXpl, Enamex, `LocPpl, LocGpl', `_EnamexTypeSubtypes')
_DefineStartTagAmbig(ObjMdcPrs, Enamex, `ObjMdc', `_TypeSubtypes(Prs)')
_DefineStartTagAmbig(OrgPrs, Enamex, `_TypeSubtypes(Org)', `_TypeSubtypes(Prs)')
_DefineStartTagAmbig(OrgPrsHum, Enamex, `_TypeSubtypes(Org)', `PrsHum')
_DefineStartTagAmbig(OrgAth, Enamex, `_EnamexTypeSubtypes', `OrgAth')
_DefineStartTagAmbig(PrsHum, Enamex, `_EnamexTypeSubtypes', `PrsHum')
m4_dnl _DefineStartTagAmbig(Any2, Enamex, `_EnamexTypeSubtypes', `_EnamexTypeSubtypes')

_DefineStartTagAmbig(Any2, `', `_AllAmbigTypes', `')
_DefineEndTagAmbig(Any2, `', `_AllAmbigTypes', `')

Define StartTagEnamex [StartTagAmbiguousAny2 | _AnyStartTag(Enamex)] ;
Define StartTagNumex _AnyStartTag(Numex) ;
Define StartTagTimex _AnyStartTag(Timex) ;

Define StartTag [StartTagEnamex | StartTagNumex | StartTagTimex] ;

Define EndTagEnamex [EndTagAmbiguousAny2 | _AnyEndTag(Enamex)] ;

Define Endtag [EndTagEnamex | _AnyEndTag(Numex) | _AnyEndTag(Timex)] ;

Define AnyTag [StartTag | Endtag] ;

Define AddEndTagEnamex _InsertSym(`</Enamex>') ;

Define RemoveStartTag _Remove(`StartTag') ;
Define RemoveEndTag _Remove(`Endtag') ;

Define RemoveStartTagEnamex _Remove(`StartTagEnamex') ;
Define RemoveStartTagNumex _Remove(`StartTagNumex') ;
Define RemoveStartTagTimex _Remove(`StartTagTimex') ;
Define RemoveEndTagEnamex _Remove(`EndTagEnamex') ;

Define AnyChar [Alpha|Num|Punct|Whitespace|"­"] ;
Define NoTag [? - ["<"|">"|AnyTag]] ;
Define NST [NoTag - Whitespace] ;
Define NS [ NST ] ;
Define NSTag [ NST ] ;

Define NoTags NoTag+ ;
Define NSTagDash [NSTag - "-"] ;
Define NSTagDashColon [NSTagDash - ":"] ;
Define NoTagNum [NoTag - Num];

!= ===============================================
!= Pmatch regular expression shorthand definitions
!= ===============================================

Define WhitespaceOrBoundary [Whitespace|#] ;
Define UNIMPLEMENTED [ "" ] ;
Define Upper [UppercaseAlpha|"&"] ;
Define AZ
     ["A"|"B"|"C"|"D"|"E"|"F"|"G"|"H"|"I"|"J"|"K"|"L"|"M"|"N"|"O"|"P"|"Q"|"R"|"S"|"T"|"U"|"V"|"W"|"X"|"Y"|"Z"] ;
Define Az
     ["a"|"b"|"c"|"d"|"e"|"f"|"g"|"h"|"i"|"j"|"k"|"l"|"m"|"n"|"o"|"p"|"q"|"r"|"s"|"t"|"u"|"v"|"w"|"x"|"y"|"z"] ;
Define NSTagComma [NST - ","];
Define NSHash [? - [Whitespace|"#"|"<"|">"]] ;
Define NSDash [? - [Whitespace|"-"|"<"|">"]] ;
Define NSColon [? - [Whitespace|":"|"<"|">"]] ;
Define NSDashColon [? - [Whitespace|":"|"-"|"<"|">"]] ;
! Define NoTag [? - ["<"|">"]] ;
Define NoQuote [? - ["\n"|"\""|"'"|"´"|"«"|"»"|"<"|">"]] ;
Define NoQuoteVbar [? - ["\n"|"\""|"'"|"|"|"´"|"«"|"»"|"<"|">"]] ;
Define NoQuoteHash [? - ["\n"|"\""|"'"|"´"|"#"|"«"|"»"|"<"|">"]] ;
Define CapWord [ Upper NS* ] ;
Define CapWord2 [ Upper NS+ ] ;
Define CapWord3 [ Upper NS NS+ ] ;
Define CapWord4 [ Upper NS NS NS+ ] ;
Define UpperDigit [UppercaseAlpha|Num] ;
Define UpperDigitDash [UppercaseAlpha|Num|"-"] ;
Define Lower [ LowercaseAlpha ] ;
Define LowerDigit [LowercaseAlpha|Num] ;
Define LowerDigitDash [LowercaseAlpha|Num|"-"] ;
Define DigitDash [Num|"-"] ;
Define AsciiAlpha [ AZ | Az ] ;
Define AlphaDigit [Alpha|Num] ;
Define AlphaDigitDash [Alpha|Num|"-"] ;
Define AlphaDigitDashUnder [Alpha|Num|"-"|"_"] ;
Define Num02 ["0"|"1"|"2"] ;
Define Num03 ["0"|"1"|"2"|"3"] ;
Define Num06 ["0"|"1"|"2"|"3"|"4"|"5"|"6"] ;
Define Num19 ["1"|"2"|"3"|"4"|"5"|"6"|"7"|"8"|"9"] ;
Define Num13 ["1"|"2"|"3"] ;
Define YearNum [ ["1"|"2"] Num Num Num ] ;
Define Word [ NS+ ] ;
Define LowerWord LowercaseAlpha+ ;
Define UpperWord UppercaseAlpha+ ;
! Define EndTagEnamex [ "</ENAMEX>" ] ;
! Define StartTagEnamex
!      [ "<ENAMEX TYPE=" %" "" UpperWord "" %" " SBT=" %" "" UpperWord "" %" ">" ] ;
Define WordBoundary [ [Whitespace|Punct] - ["<"|">"] | # ] ;
Define Aa ["A"|"a"] ;
Define Bb ["B"|"b"] ;
Define Cc ["C"|"c"] ;
Define Dd ["D"|"d"] ;
Define Ee ["E"|"e"] ;
Define Ff ["F"|"f"] ;
Define Gg ["G"|"g"] ;
Define Hh ["H"|"h"] ;
Define Ii ["I"|"i"] ;
Define Jj ["J"|"j"] ;
Define Kk ["K"|"k"] ;
Define Ll ["L"|"l"] ;
Define Mm ["M"|"m"] ;
Define Nn ["N"|"n"] ;
Define Oo ["O"|"o"] ;
Define Pp ["P"|"p"] ;
Define Qq ["Q"|"q"] ;
Define Rr ["R"|"r"] ;
Define Ss ["S"|"s"] ;
Define Tt ["T"|"t"] ;
Define Uu ["U"|"u"] ;
Define Vv ["V"|"v"] ;
Define Ww ["W"|"w"] ;
Define Xx ["X"|"x"] ;
Define Yy ["Y"|"y"] ;
Define Zz ["Z"|"z"] ;



m4_divert(-1)

m4_define(`__Literal', `$1')
m4_define(`_DefineDefine',
	  `m4_define(m4_patsubst(`$1', `^_', `_Define'),
	  	     Define m4_ifelse(`$2', `', m4_patsubst(`$1', `^_', `'),
		     	     	       `$2')@
       `$1'(__Literal($`'@)))')

m4_define(`_RemoveTags',
	  `RemoveStartTag$1 [ $2 ] RemoveEndTag$1')

m4_define(`_Tagged',
	  `StartTag$1 [ $2 ] EndTag$1')

m4_define(`_EndTagFull',
	  `EndTag(_FullTagName(`$1'))')

m4_define(`_EndTagContext',
	  `_EndTagFull(`$1')m4_ifelse(`$2', `', `', `
	 $2')')

m4_define(`_DefineChangeTagFull (old_tag_base, new_tag, preceding_outer
				 preceding_inner, within, following_inner,
				 following_outer)')
m4_define(`_DefineChangeTagFull',
	  `Define ChangeTag@
       [ $3
         Define(
	   $4
	   [ _RemoveTags(`$1', `$5') ]
	   $6
	   _EndTagFull(`$2') )
	 $7 ]')

m4_define(`_DefineChangeTag (old_tag_base, new_tag, preceding, within,
			     following)')
m4_define(`_DefineChangeTag',
	  `_DefineChangeTagFull(`$1', `$2', `', `$3', `$4', `$5')')

m4_define(`_DefineChangeTagOld',
	  `Define ChangeTag@
       [ $3
         [ _RemoveTags(`$1', `$4') ]
	 $5
	 _EndTagFull(`$2') ]')

m4_dnl This is not used
# m4_define(`_DefineChangeStartTag',
# 	  `Define ChangeStartTag@
#        [ [$3]
#          _ReplaceStartTag(`$1', `$2')
# 	 [$4] ]')

m4_define(`_ExpandChangeTagFull (old_tag_base, new_tag, preceding_outer,
				 preceding_inner, within, following_inner,
				 following_outer)')
m4_define(`_ExpandChangeTagFull',
	  `$3
	   Define(
	     [ $4
	     [ _RemoveTags(`$1', `$5') ]
	     $6 ]
	     _EndTagFull(`$2') )
	   $7')

m4_define(`_ExpandChangeTag (old_tag_base, new_tag, preceding, within,
			     following)')
m4_define(`_ExpandChangeTag',
	  `$3
	   [ _RemoveTags(`$1', `$4') ]
	   $5
	   _EndTagFull(`$2')')

m4_define(`__DefineExpandChangeTag (old_tag_base, new_tag, preceding, within,
				    following, [defname_base])')
m4_define(`__DefineExpandChangeTag',
	  `Define m4_ifelse(`$#', `6', `$6', `ExpandChangeTag')@
       _ExpandChangeTag($@)')

m4_define(`_ExpandSubtypes',
	  `m4_ifelse(`$1', `', `_AllMainTypeSubtypes',
		     m4_len(`$1'), `3', `_TypeSubtypes(`$1')',
		     m4_regexp(`$1', `\(Ena\|Nu\|Ti\)mex'), `0',
			 `_MainTypeSubtypes(`$1')',
		     `$1')')

m4_define(`_MoveTagAny',
	  `_AlternativesApply(
	  	`_Curry(`_Move$1B', m4_shift(m4_shift($@)))',
		_ExpandSubtypes(`$2'))')

m4_define(`_MoveTagFullAny',
	  `[ $3
	 _AlternativesApply(
	    `_Curry(`_Move$1B', m4_shift(m4_shift(m4_shift(m4_shift($@)))))',
	    _ExpandSubtypes(`$2'))
	 $4 ]')

m4_define(`old_tag_base, new_tag, preceding, within, following')
m4_define(`_DefineChangeMoveStartTagLeft',
	  `__DefineExpandChangeTag(`$1', `$2', `$3', `$4', `$5',
				   `ChangeMoveStartTagLeft')')

m4_define(`_DefineMoveStartTagLeft (tag_base, preceding, within, following)')
m4_define(`_DefineMoveStartTagLeft',
	  `__DefineExpandChangeTag(`$1', `$1', `$2', `$3', `$4',
				   `MoveStartTagLeft')')

m4_define(`_MoveStartTagLeft (tag_base, preceding, within, following)')
m4_define(`_MoveStartTagLeft',
	  `_ExpandChangeTag(`$1', `$1', `$2', `$3', `$4')')

m4_define(`_MoveStartTagLeftB',
	  `Define(
	_MoveStartTagLeft(`$4', `$1', `$2', `$3') )')

m4_define(`_MoveStartTagLeftAny',
	  `_MoveTagAny(`StartTagLeft', `$1', `$2', `$3', `$4')')
_DefineDefine(`_MoveStartTagLeftAny', `MoveStartTagLeft')

m4_define(`old_tag_base, new_tag, preceding, within, following')
m4_define(`_DefineChangeMoveEndTagRight',
	  `__DefineExpandChangeTag(`$1', `$2', `$3', `$4', `$5',
				   `ChangeMoveEndTagRight')')

m4_define(`tag_base, preceding, within, following')
m4_define(`_DefineMoveEndTagRight',
	  `__DefineExpandChangeTag(`$1', `$1', `$2', `$3', `$4',
				   `MoveEndTagRight')')

m4_define(`_MoveEndTagRightFull (tag_base, preceding, within, following_inner,
				 following_outer)')
m4_define(`_MoveEndTagRightFull',
	  `[ $2
	StartTag$1
	$3
	RemoveEndTag$1
	$4
	AddEndTag$1
	$5 ]')
m4_dnl	  `_ExpandChangeTagFull(`$1', `$1', `$2', `$3', `$4', `$5', `$6')')
_DefineDefine(`_MoveEndTagRightFull', `MoveEndTagRight')

m4_define(`_MoveEndTagRightFullB',
	  `_MoveEndTagRightFull(`$6', `$1', `$5', `$2', `$3', `$4')')

m4_define(`_MoveEndTagRightFullAny',
	  `_MoveTagFullAny(`EndTagRight', `$1', `$2', `$6', `$3', `$4', `$5')')
_DefineDefine(`_MoveEndTagRightFullAny', `MoveEndTagRight')

m4_define(`_MoveEndTagRight (tag_base, preceding, within, following_inner)')
m4_define(`_MoveEndTagRight',
	  `_MoveEndTagRightFull(`$1', `$2', `$3', `$4', `')')

m4_define(`_MoveEndTagRightB',
	  `Define( _MoveEndTagRight(`$4', `$1', `$2', `$3') )')

m4_define(`_MoveEndTagRightAny',
	  `_MoveTagAny(`EndTagRight', `$1', `$2', `$3', `$4')')
_DefineDefine(`_MoveEndTagRightAny', `MoveEndTagRight')

m4_define(`tag_base, preceding, within1, between, within2, following, [count]')
m4_define(`_DefineCombineNames',
	  `Define CombineNames@
       [ [ [$2]
           _RemoveTags(`$1', `$3')
           [ $4 _RemoveTags(`$1', `$5') ]m4_ifelse(`$7', `', `', `^$7')
	   [$6] ]
	 _EndTagFull(`$1') ]')

m4_define(`__ReduceChangeTag (old_tag_base, new_tag, preceding, within,
			     following)')
m4_define(`__ReduceChangeTag',
       `[ _RemoveTags(`$1', `$3
	 Define(
	   $4
	   _EndTagFull(`$2') )
	 $5
        ') ]')

m4_define(`__DefineReduceChangeTag (old_tag_base, new_tag, preceding, within,
				    following, [defname_base])')
m4_define(`__DefineReduceChangeTag',
	  `Define m4_ifelse(`$#', `6', `$6', `ReduceChangeTag')@
       __ReduceChangeTag(`$1', `$2', `$3', `$4', `$5')')

m4_define(`_MoveEndTagLeft (tag_base, preceding, within, following)')
m4_define(`_MoveEndTagLeft',
	  `__ReduceChangeTag(`$1', `$1', `$2', `$3', `$4')')
_DefineDefine(`_MoveEndTagLeft')

m4_define(`_MoveEndTagLeftB',
	  `_MoveEndTagLeft(`$4', `$1', `$2', `$3')')
m4_define(`_MoveEndTagLeftAny',
	  `_MoveTagAny(`EndTagLeft', `$1', `$2', `$3', `$4')')
_DefineDefine(`_MoveEndTagLeftAny', `MoveEndTagLeft')

m4_define(`_MoveStartTagRight (tag_base, preceding, within, following)')
m4_define(`_MoveStartTagRight',
	  `__ReduceChangeTag(`$1', `$1', `$2', `$3', `$4')')
_DefineDefine(`_MoveStartTagRight')

m4_define(`_MoveStartTagRightB',
	  `_MoveStartTagRight(`$4', `$1', `$2', `$3')')
m4_define(`_MoveStartTagRightAny',
	  `_MoveTagAny(`StartTagRight', `$1', `$2', `$3', `$4')')
_DefineDefine(`_MoveStartTagRightAny', `MoveStartTagRight')

m4_divert(0)

Define TaggedOrgAth [StartTagOrgAth NoTags Endtag];

Define XMLCharEntity [{&#} ("x") Num+ ";"] ;

!= ==================================================
!= Pmatch definitions for converted Flex source begin
!= ==================================================

!= ==========================================================
!= Pmatch definitions for Flex regular expression definitions
!= ==========================================================

!# 
!# 	File: filterBadTags.ll
!#           Author: Dimitrios Kokkinakis
!#           version: 061026
!#         To be run each time AFTER each flexer that has been applied
!# 

!R SHITWORDS_PERS	Även|Men|Om|På|När|Också|Att|Eftersom|Och|Vad|Enligt|[Mm]äktige|[Gg]alopp|[Ff]ormtoppade|Struken|LOPP|Avd|populära|lilla|[Ss]torfavoriten|underjordens|bor|illbringade|nominerat|tillsates|sa|hälsade|tänkte|sade|säger|friställde|lovar

Define SHITWORDS%_PERS [ {Även} | {Men} | {Om} | {På} | {När} | {Också} | {Att} | {Eftersom} | {Och} | {Vad} | {Enligt} | Mm {äktige} | Gg {alopp} | Ff {ormtoppade} | {Struken} | {LOPP} | {Avd} | {populära} | {lilla} | Ss {torfavoriten} | {underjordens} | {bor} | {illbringade} | {nominerat} | {tillsates} | {sa} | {hälsade} | {tänkte} | {sade} | {säger} | {friställde} | {lovar} ] ;

!R SHITWORDS_LOCS	"båt över till"|"gårdar som"|"högsta topp"|"i höjd med"|"i utkanten av"|"Platsen är"|"platsen är"|"tåget förbi"|"tåget mellan"|[Bb]ortre|[Ff]rån|[Gg]enom|[Ii]genomkajen|[Ii]ntill|[Mm]ellan|[Mm]ot|[Nn]edanför|[Nn]ära|[Pp]"å toppen"|[Pp]å|[Vv]id|[Öö]ver|andra|Bara|bergstoppen|bor|bostad|bott|buss|bussen|byggdes|byn|Där|Ett|filial|flyg|flyget|framträdandet|förbi|Förutom|Hade|Hela|huset|högkvarter|konsert|kring|kvarteret|ligger|lilla|lirar|ljusa|längs|Längs|medborgare|Men|mottagning|möttes|När|närmaste|Och|Också|rektor|rektorn|resa|reser|rest|reste|runt|Sedan|Själva|Som|spelas|stadsdelen|Stiger|stugan|Till|tåget|underhåller|uppträder|Utanför|Utmed|utställning|utställningen|Varför|visas|visning|åka|åker|åkt|åkte|Även

Define SHITWORDS%_LOCS [ {båt över till} | {gårdar som} | {högsta topp} | {i höjd med} | {i utkanten av} | {Platsen är} | {platsen är} | {tåget förbi} | {tåget mellan} | Bb {ortre} | Ff {rån} | Gg {enom} | Ii {genomkajen} | Ii {ntill} | Mm {ellan} | Mm {ot} | Nn {edanför} | Nn {ära} | Pp {å toppen} | Pp "å" | Vv {id} | ["Ö"|"ö"] {ver} | {andra} | {Bara} | {bergstoppen} | {bor} | {bostad} | {bott} | {buss} | {bussen} | {byggdes} | {byn} | {Där} | {Ett} | {filial} | {flyg} | {flyget} | {framträdandet} | {förbi} | {Förutom} | {Hade} | {Hela} | {huset} | {högkvarter} | {konsert} | {kring} | {kvarteret} | {ligger} | {lilla} | {lirar} | {ljusa} | {längs} | {Längs} | {medborgare} | {Men} | {mottagning} | {möttes} | {När} | {närmaste} | {Och} | {Också} | {rektor} | {rektorn} | {resa} | {reser} | {rest} | {reste} | {runt} | {Sedan} | {Själva} | {Som} | {spelas} | {stadsdelen} | {Stiger} | {stugan} | {Till} | {tåget} | {underhåller} | {uppträder} | {Utanför} | {Utmed} | {utställning} | {utställningen} | {Varför} | {visas} | {visning} | {åka} | {åker} | {åkt} | {åkte} | {Även} ] ;

!R SHITWORDS_EVNT	Eftersom|På|Att|Trots|Övriga|Inför|storloppet|Efter|Denna|Bakom|Innan|Under|Ta|Nästa|Vann|Och|Även|Vid|När|skrev|tidskriften|tidningen|romanen|boken

Define SHITWORDS%_EVNT [ {Eftersom} | {På} | {Att} | {Trots} | {Övriga} | {Inför} | {storloppet} | {Efter} | {Denna} | {Bakom} | {Innan} | {Under} | {Ta} | {Nästa} | {Vann} | {Och} | {Även} | {Vid} | {När} | {skrev} | {tidskriften} | {tidningen} | {romanen} | {boken} ] ;

!R SHITWORDS_OBJS	[Ee]n|[Ee]tt|För

Define SHITWORDS%_OBJS [ Ee "n" | Ee {tt} | {För} ] ;

!R SHITWORDS_ORGS	Vid|[Ff]öretaget|Och|bakom|Från|Eftersom|Enligt|På|Hur|i|Även|Men

Define SHITWORDS%_ORGS [ {Vid} | Ff {öretaget} | {Och} | {bakom} | {Från} | {Eftersom} | {Enligt} | {På} | {Hur} | "i" | {Även} | {Men} ] ;

!R SHITWORDS_WORK	Eftersom|Både|Förutom|Enligt|erfar|Som|Också|[tT]idningen|Till|På|Även

Define SHITWORDS%_WORK [ {Eftersom} | {Både} | {Förutom} | {Enligt} | {erfar} | {Som} | {Också} | ["t"|"T"] {idningen} | {Till} | {På} | {Även} ] ;

!R ORGDESIGNATOR	"Nordiska AB"|"North America"|"of "[A-Z][^\n\t ]+|"Svenska AB"|[^\n\t\<\> ]*"enhet för "[^\n\t\<\> ]+|[^\n\t ]*[Ff][Öö][Rr][Ee][Nn][Ii][Nn][Gg]|[^\n\t ]*anstalt|[^\n\t ]*anstalten|[^\n\t ]*avdelning|[^\n\t ]*avdelningen|[^\n\t ]*byrån|[^\n\t ]*division|[^\n\t ]*förbund|[^\n\t ]*förvaltning|[^\n\t ]*förvaltningen|[^\n\t ]*kommissionen|[^\n\t ]*kommittén|[^\n\t ]*oundation|[^\n\t ]*rotel|[^\n\t ]*sektion|[^\n\t ]*skontor|[^\n\t ]*tjänst|[^\n\t ]*ämbete|[^\n\t ]+bolag|[^\n\t ]+grafigrupp|[Aa][Bb]|[Aa]\.[Bb]\.|[Aa]gency|[Aa]kademin|[Ii]nc|[Ii]nternational|[Ll][Tt][Dd]|[Vv]änner|A\.m\.b\.a|A\.S\.|A\/S|ADR|AG|Aktiebolaget|Alliance|ApS|AS|Asia|Assoc|B\.V\.|BV|C[Oo]|China|Communications|Company|Consortium|Consulting|Coop\.|Corp|Corporation|Enterprises|Europe|Fastigheter|Foundation|G[Mm][Bb][Hh]|Group|Gruppen|Handelsföretag|HB|Healthcare|Hld|Holding|Holdings|Incorporated|Industrial|Industry|Inst\.|KB|Labs|lasarett|Limited|Ltda|Management|Mfg|Music|N\.V\.|Norden|Nordic|Office|Offshore|Oy|Packaging|Partners|Partnerships|Pharm\.|Pharmaceuticals|Productions|Provider|Publications|publishing" "agency|Research|riksorganisation|S\.A\.|S\.p\.A|SA|Scandinavia|Services|SS|Sweden|Sverige|Syd|Systems|Team|UK|Union|Works|Worldwide|Väst|[Kk]ansli

Define ORGDESIGNATOR [ {Nordiska AB} | {North America} | {of } AZ Word | {Svenska AB} | NSTag* {enhet för } NSTag+ | NS* Ff ["Ö"|"ö"] Rr Ee Nn Ii Nn Gg | NS* {anstalt} | NS* {anstalten} | NS* {avdelning} | NS* {avdelningen} | NS* {byrån} | NS* {division} | NS* {förbund} | NS* {förvaltning} | NS* {förvaltningen} | NS* {kommissionen} | NS* {kommittén} | NS* {oundation} | NS* {rotel} | NS* {sektion} | NS* {skontor} | NS* {tjänst} | NS* {ämbete} | Word {bolag} | Word {grafigrupp} | Aa Bb | Aa "." Bb "." | Aa {gency} | Aa {kademin} | Ii {nc} | Ii {nternational} | Ll Tt Dd | Vv {änner} | {A.m.b.a} | {A.S.} | {A/S} | {ADR} | {AG} | {Aktiebolaget} | {Alliance} | {ApS} | {AS} | {Asia} | {Assoc} | {B.V.} | {BV} | "C" Oo | {China} | {Communications} | {Company} | {Consortium} | {Consulting} | {Coop.} | {Corp} | {Corporation} | {Enterprises} | {Europe} | {Fastigheter} | {Foundation} | "G" Mm Bb Hh | {Group} | {Gruppen} | {Handelsföretag} | {HB} | {Healthcare} | {Hld} | {Holding} | {Holdings} | {Incorporated} | {Industrial} | {Industry} | {Inst.} | {KB} | {Labs} | {lasarett} | {Limited} | {Ltda} | {Management} | {Mfg} | {Music} | {N.V.} | {Norden} | {Nordic} | {Office} | {Offshore} | {Oy} | {Packaging} | {Partners} | {Partnerships} | {Pharm.} | {Pharmaceuticals} | {Productions} | {Provider} | {Publications} | {publishing agency} | {Research} | {riksorganisation} | {S.A.} | {S.p.A} | {SA} | {Scandinavia} | {Services} | {SS} | {Sweden} | {Sverige} | {Syd} | {Systems} | {Team} | {UK} | {Union} | {Works} | {Worldwide} | {Väst} | Kk {ansli} ] ;

!R HUMDESIGNATOR	sor|[Bb]in|al|af|el|der|van|[Vv]on|van" "der|van" de"|von|De" "la|"de la"|la|le|de|da|wa|abu|dos

Define HUMDESIGNATOR [ {sor} | Bb {in} | {al} | {af} | {el} | {der} | {van} | Vv {on} | {van der} | {van de} | {von} | {De la} | {de la} | {la} | {le} | {de} | {da} | {wa} | {abu} | {dos} ] ;

!R HUMDESIGNATOR_E	al\-[^\n\t ]+|el\-[^\n\t ]+|d\'[A-Z][^\n\t ]+|[Dd]en" "Store

Define HUMDESIGNATOR%_E [ {al-} Word | {el-} Word | {d'} AZ Word | Dd {en Store} ] ;

!R HUMDESIGNATOR_I	sor|[Bb]in|al|af|der|van|van" "de|ibn|[Vv]on|"van der"|von|"de la"|al\-[^\n\t ]+|da|wa|el\-[^\n\t ]+|d\'[A-Z][^\n\t ]+|abu|[A-Z]" "[A-Z]

Define HUMDESIGNATOR%_I [ {sor} | Bb {in} | {al} | {af} | {der} | {van} | {van de} | {ibn} | Vv {on} | {van der} | {von} | {de la} | {al-} Word | {da} | {wa} | {el-} Word | {d'} AZ Word | {abu} | AZ " " AZ ] ;

!R HUMAMBIGNAMES	Dagar|Brand|Sagan|Skott|Ben|Ag|Sol|Mina|Elva|Milan|Liv|Po|Lo|Fred|Inga|Hans|Bo|Dag|Maj|April|Juni|Klara|Hun|P\-O

Define HUMAMBIGNAMES [ {Dagar} | {Brand} | {Sagan} | {Skott} | {Ben} | {Ag} | {Sol} | {Mina} | {Elva} | {Milan} | {Liv} | {Po} | {Lo} | {Fred} | {Inga} | {Hans} | {Bo} | {Dag} | {Maj} | {April} | {Juni} | {Klara} | {Hun} | {P-O} ] ;

!R VHGDESIGNATOR	[0-9]\.[0-9]|[0-9]+\-kombin|[0-9]+\-serie|[1-6]\,[0-9]|[Cc]abriolet|[Cc]c|[Cc]orvette|[Cc]oupé|[Dd]iesel" "[Tt]urbo|[Jj]eep|[Vv]oyger|AWD" "Sedan|Business|Diesel|herrgårdsvagn|kombi|Sportsedan|Sportwagon|Touring|Transporter|Turbo|V[68]

Define VHGDESIGNATOR [ Num "." Num | Num+ {-kombin} | Num+ {-serie} | ["1"|"2"|"3"|"4"|"5"|"6"] "," Num | Cc {abriolet} | Cc "c" | Cc {orvette} | Cc {oupé} | Dd {iesel } Tt {urbo} | Jj {eep} | Vv {oyger} | {AWD Sedan} | {Business} | {Diesel} | {herrgårdsvagn} | {kombi} | {Sportsedan} | {Sportwagon} | {Touring} | {Transporter} | {Turbo} | "V" ["6"|"8"] ] ;

!R LOCDESIGNATOR	del|de" "la|de|do

Define LOCDESIGNATOR [ {del} | {de la} | {de} | {do} ] ;

!= =================================
!= Pmatch definitions for Flex rules
!= =================================

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Det<\/ENAMEX>
!A {printf("Det");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Elfva<\/ENAMEX>
!A {printf("Elfva");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">OCH<\/ENAMEX>
!A {printf("OCH");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Den<\/ENAMEX>
!A {printf("Den");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Och<\/ENAMEX>
!A {printf("Och");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Jag<\/ENAMEX>
!A {printf("Jag");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Er<\/ENAMEX>
!A {printf("Er");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Ni<\/ENAMEX>
!A {printf("Ni");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Du<\/ENAMEX>
!A {printf("Du");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Ej<\/ENAMEX>
!A {printf("Ej");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Hon<\/ENAMEX>
!A {printf("Hon");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Han<\/ENAMEX>
!A {printf("Han");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Stora<\/ENAMEX>
!A {printf("Stora");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Gamla<\/ENAMEX>
!A {printf("Gamla");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Efter<\/ENAMEX>
!A {printf("Efter");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">DET<\/ENAMEX>
!A {printf("DET");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Allt<\/ENAMEX>
!A {printf("Allt");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Egna<\/ENAMEX>
!A {printf("Egna");}

!R "\. "\<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Hans<\/ENAMEX>
!A {printf(". Hans");}

!R ^\<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Hans<\/ENAMEX>
!A {printf("Hans");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Hennes<\/ENAMEX>
!A {printf("Hennes");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Godt<\/ENAMEX>
!A {printf("Godt");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Med<\/ENAMEX>
!A {printf("Med");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Vad<\/ENAMEX>
!A {printf("Vad");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">I<\/ENAMEX>
!A {printf("I");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Vid<\/ENAMEX>
!A {printf("Vid");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Första<\/ENAMEX>
!A {printf("Första");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Mina<\/ENAMEX>
!A {printf("Mina");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Backarna<\/ENAMEX>
!A {printf("Backarna");}

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">Framåt<\/ENAMEX>
!A {printf("Framåt");}

! The preceding rules were collected to the following two:
Define RemoveTags@
       [ RemoveStartTag
	 [{Det} | {Elfva} | {OCH} | {Den} | {Och} | {Jag} | {Er} | {Ni} | {Du}
	  | {Ej} | {Hon} | {Han} | {Stora} | {Gamla} | {Efter} | {DET} | {Allt}
	  | {Egna} | {Hennes} | {Godt} | {Med} | {Vad} | "I" | {Vid} | {Första}
	  | {Mina} | {Backarna} | {Framåt}]
	 RemoveEndTag ] ;
Define RemoveTags@ [ [# | { . }] RemoveStartTag {Hans} RemoveEndTag ] ;

!**> EnamexLocGpl|EnamexPrsHum :: <>Allt</> => Allt | <>Jag</> => Jag
!**> <EnamexPrsHum>I</EnamexPrsHum> => I
!**> EnamexPrsHum :: Test . <>Hans</> => Test . Hans | <>Hans</> => Hans | Där <>Hans</> levde => Där <>Hans</> levde

!R \<ENAMEX" "TYPE=\"[A-Z]+\"" "SBT=\"[A-Z]+\">\&\#x?[0-9]+\;<\/ENAMEX>
!A {int i=0; for (;yytext[i]!='>';i++); i++;
!A for (;yytext[i]!='<';putchar(yytext[i++]));}

Define RemoveTags@ [ RemoveStartTag XMLCharEntity RemoveEndTag ] ;

!R \<ENAMEX[^\>]+HUM\"\>[^\<]+\-\<\/ENAMEX\>" "[a-zåäö]+" "
!A {int i=0; for (;yytext[i]!='>';putchar(yytext[i++])); 
!A 	putchar('>');i++;for (;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng-1;putchar(yytext[i++])); printf("</ENAMEX> ");}

_DefineMoveEndTagRight(`PrsHum', `', `NoTags "-"', `" " LowerWord RC(" ")') ;

! Define MoveEndTag@
!        [ StartTagPrsHum NoTags "-" RemoveEndTag " " LowerWord AddEndTagPrsHum
!          " " ] ;

!R \<ENAMEX" "[^\>]+HUM\"\>[^\<]+\-\<\/ENAMEX\>" "\<ENAMEX" "[^\>]+HUM\"\>[a-zåäö]+<\/ENAMEX\>" "
!A {int i=0; for (;yytext[i]!='>';putchar(yytext[i++])); 
!A 	putchar('>'); i++;for (;yytext[i]!='<';putchar(yytext[i++]));  i=i+15;	putchar(' ');
!A 	for (;yytext[i]!='>';i++);i++; for(;i<yyleng;putchar(yytext[i++]));}

_DefineCombineNames(`PrsHum', `', `NoTags "-"', `" "', `LowerWord') ;

!# *******************************************
!#  SOME SOCCER TEAMS BEFORE THE EXCEPTIONS   
!#  <ENAMEX TYPE="ORG" SBT="ATH"><MTH="MWE"/> 
!# *******************************************

!R "\<ENAMEX TYPE\=\"ORG\" SBT\=\"ATH\"\>"[^\n\<\>]+"\<\/ENAMEX\>"\-[A-ZÅÄÖ][^ \-\n\>\<]*
!A {int i=0; 
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); putchar(yytext[i++]);
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
!A 	for(;i<yyleng; putchar(yytext[i++])); printf("</ENAMEX>");}

! NOTE: In the following, 'TaggedOrgAth "-"' should not be in a
! context, since it would not be counted in the length of the match
! and another rule would remove the tags of the other part.

Define AddTags@
       [ TaggedOrgAth "-"
	 Define(
	   UppercaseAlpha NSTagDash*
           EndTag(EnamexOrgAth) ) ] ;

!R [A-ZÅÄÖ][^ \-\n\<\>]*\-"\<ENAMEX TYPE\=\"ORG\" SBT\=\"ATH\"\>"[^\n\<\>]+"\<\/ENAMEX\>"
!A { int i=0;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
!A 	for(;yytext[i]!='-';putchar(yytext[i++]));
!A 	printf("</ENAMEX>"); for(;i<yyleng; putchar(yytext[i++]));}

Define AddTags@
       [ Define(
            UppercaseAlpha NSTagDash*
	    EndTag(EnamexOrgAth) )
       	 "-" TaggedOrgAth ] ;

!R "\<ENAMEX TYPE\=\"ORG\" SBT\=\"ATH\"\>"[^\n\<\>]+"\<\/ENAMEX\>\-\<ENAMEX TYPE\=\"ORG\" SBT\=\"ATH\"\>"[^\n\<\>]+"\<\/ENAMEX\>"
!A {ECHO;}

Define Except@
       [ TaggedOrgAth "-" TaggedOrgAth ] ;

!#  AT Texts - common fix on errors 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[Dd]r" "[A-Z][^\n\<\>]+" "[A-Z][^\n\<\>]+" "[A-Z][^\n\<\>]+" "(sjukhus|vårdcentral)\<\/ENAMEX\>
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); putchar(' ');i++;
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); putchar(' ');i++;
!A 	for(;yytext[i]!=' ';putchar(yytext[i++]));              i++;
!A 	printf("</ENAMEX> <ENAMEX TYPE=\"LOC\" SBT=\"FNC\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

Define SplitTags@
       [ RemoveStartTagPrsHum
         Define(
	   Dd "r" [" " CapWord2]^2
	   EndTag(EnamexPrsHum) )
	 " "
	 Define(
	   CapWord2 " " [{sjukhus} | {vårdcentral}]
	   EndTag(EnamexLocFnc) )
	 RemoveEndTagPrsHum ] ;

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[Dd]r" "[A-Z][^\n\<\>]+" "[A-Z][^\n\<\>]+" "(VC|SU|SU\/S|SU\/ÖS|SS|SU\/SS|[A-Z][^\< ]+huset|[A-Z][^\< ]+akuten)\<\/ENAMEX\>
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); putchar(' ');i++;
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); putchar(' ');i++;
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineMoveEndTagLeft(PrsHum,
	`',
        `Dd "r" [" " CapWord2]^2',
	`" "
         [ {VC} | {SU} ("/" ("Ö"|"S") "S") | {SS}
	   | CapWord2 [{huset} | {akuten}] ]') ;

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[Dd]r" "[A-Z][^\n\<\>]+" "(VC|SU|SU\/S|SU\/ÖS|SS|SU\/SS|[A-Z][^\< ]+hus|[A-Z][^\< ]+centralen|[A-Z][^\< ]+huset|[A-Z][^\< ]+akuten|[A-Z][^\< ]+kliniken|[A-Z][^\< ]+platsen|[A-Z][^\< ]+gruppen|Södra)\<\/ENAMEX\>
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); putchar(' ');i++;
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineMoveEndTagLeft(PrsHum,
	`',
	`Dd "r" [" " CapWord2]',
	`" "
       	 [ {VC} | {SU} ("/" ("Ö"|"S") "S") | {SS}
	   | CapWord2 [{hus} ({et}) | {centralen} | {akuten} | {kliniken}
	               | {platsen} | {gruppen}]
           | {Södra} ]') ;

! *******************************************************************
!  Modifications before the "ERRORS for humans" 
! *ok** <PRS>Xs</> president|*minister|*kommunalråd|polischef <PRS> => <PPL> ... <PRS> 
! *******************************************************************

!R \<ENAMEX" "TYPE=\"PRS\"" "SBT=\"HUM\"\>[A-ZÅÄÖ][^\n ]+s\<\/ENAMEX\>(" "vice)?" "[^\n\>\< ]*(president|minister|kommunalråd|polischef)" "
!A {int i=29;
!A 	printf("<ENAMEX TYPE=\"LOC\" SBT=\"PPL\">"); for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(PrsHum, LocPpl,
	`',
	`CapWord2 "s"',
	`RC(({ vice}) " " NSTag*
	    [{president} | {minister} | {kommunalråd} | {polischef}] " ")') ;

!# *ok** <PRS>Xs</> forward|tränare|lagledare|försvarspelare|förbundskapten|fotbollsbas <PRS> => <ORG> ... <PRS> 

!R \<ENAMEX" "TYPE=\"(LOC|PRS)\"" "SBT=\"...\"\>[A-ZÅÄÖ][^\n ]+s\<\/ENAMEX\>" "("besvikne "|"assisterande ")?[^\n ]*(målvakt|forward|tränare|lagledare|örsvarspelare|örbundskapten|otbollsbas)" \<ENAMEX TYPE=\"PRS\""
!A {int i=29; printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(LocOrPrs, EnamexOrgAth,
	`',
	`CapWord2 "s"',
        `RC(" " ([{besvikne} | {assisterande}] " ") NS*
	    [{målvakt} | {forward} | {tränare} | {lagledare} | {örsvarspelare}
	     | {örbundskapten} | {otbollsbas}] " " StartTagPrs)') ;

!# *ok** <PRS>Xs</> ordförande|*chef|*sekreterare|vd|*direktör|*talesman|*ekonom|*revisor <PRS> => <ORG> ... <PRS> 

!R \<ENAMEX" "TYPE=\"PRS\"" "SBT=\"HUM\"\>[A-ZÅÄÖ][^\n ]+s\<\/ENAMEX\>" "(pressekreterare|talesman|presstalesman)
!A {ECHO;}

Define Except@
       [ StartTagPrsHum CapWord2 "s" EndTagEnamex
         " " [{pressekreterare} | ({press}) {talesman}] ] ;

!R \<ENAMEX" "TYPE=\"PRS\"" "SBT=\"HUM\"\>[A-ZÅÄÖ][^\n ]+s\<\/ENAMEX\>" "[^\n ]*(ordförande|chef|sekreterare|[Vv][Dd]|direktör|talesman|ekonom|revisor)" \<ENAMEX TYPE=\"PRS\""
!A {int i=29;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); for(;i<yyleng;putchar(yytext[i++]));}

!R \<ENAMEX" "TYPE=\"PRS\"" "SBT=\"HUM\"\>[A-ZÅÄÖ][^\n ]+s\<\/ENAMEX\>" "[^\n ]*(ordförande|chef|sekreterare|[Vv][Dd]|direktör|ekonom|revisor)" "
!A {int i=29;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); for(;i<yyleng;putchar(yytext[i++]));}

! Combined the preceding two rules; should they really have the
! difference?
! The correct interplay between these rules and the preceding Except
! rule require following the tagged part with the right context
! directly, without using RC().

_DefineChangeTagFull(PrsHum, OrgCrp,
	`', `',
	`CapWord2 "s"',
	`',
	`" " NS*
	 [ [{ordförande} | {chef} | {sekreterare} | Vv Dd | {direktör}
	    | {ekonom} | {revisor}] " "
	   | {talesman } StartTagPrs ]') ;

!# *******************************************************************
!#  REMOVES THE ANNOTATION, KEEPING THE GENITIVE FOLLOWED BY A SPACE 
!# *******************************************************************
!# *ok** <PRS> +++ => +++ 

!R \<ENAMEX" "TYPE=\"PRS\"" "SBT=\"HUM\"\>(Fred|Unna|Kamp|Klipp|Sett|Hopp|Dela|Ange|Axel|Anger|Val|Van|Stig)\<\/ENAMEX\>" "(på|vid|av|att|ingen|dig|ur|upp|närmare|mot|med|om|in|ett|ut|fram|nu" "fram)
!A {int i=0;
!A 	for(;yytext[i]!='>';i++); i++;
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	for(;yytext[i]!='>';i++); i++;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

Define RemoveTags@
       [ RemoveStartTagPrsHum
         [{Fred} | {Unna} | {Kamp} | {Klipp} | {Sett} | {Hopp} | {Dela}
	  | {Ange} | {Axel} | {Anger} | {Val} | {Van} | {Stig}]
	 RemoveEndTag " "
	 [{på} | {vid} | {av} | {att} | {ingen} | {dig} | {ur} | {upp}
	  | {närmare} | {mot} | {med} | {om} | {in} | {ett} | {ut}
	  | ({nu }) {fram}] ] ;

!# *ok** <ORG>s +++ => <LOC> 

!R \<ENAMEX" "TYPE\=\"ORG\"[^\>\/]+\>[^\n\<\>]+\<\/ENAMEX\>s" "[^\n ]*(yggnad|lokal|matsal|fabrik|anläggning|stuga|butik)[enra]*
!A {int i=29; 
!A 	printf("<ENAMEX TYPE=\"LOC\" SBT=\"FNC\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng;putchar(yytext[i++]));   printf("</ENAMEX>");}

_DefineChangeMoveEndTagRight(Org, LocFnc, `', `NoTags',
       `[ {s } NS*
          [{yggnad} | {lokal} | {matsal} | {fabrik} | {anläggning} | {stuga}
	   | {butik}] ["e"|"n"|"r"|"a"]* ]') ;

!# *ok** <WRK>s +++ => WRK 

!R \<ENAMEX" "TYPE\=\"(LOC|ORG|WRK)\"" "SBT\=\"...\"\>[^\n\<\>]+\<\/ENAMEX\>s" "[^\n ]+(upplag|sid|sbilag)a
!A {int i=29; 
!A 	printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng;putchar(yytext[i++]));   printf("</ENAMEX>");}

_DefineChangeMoveEndTagRight(LocOrOrgOrWrk, WrkWmd, `', `NoTags',
       `{s } Word [{upplag} | {sid} | {sbilag}] "a"') ;

!# *ok** <ORG>s +++ => <ORGs> +++ 

!R \<ENAMEX" "TYPE\=\"ORG\"[^\>\/]+\>[^\n\<\>]+\<\/ENAMEX\>s" "[^\n ]*(ledning|lönsamhet|aktien)
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	printf("s</ENAMEX>"); i=i+10;
!A 	for(;i<yyleng;putchar(yytext[i++])); }

_DefineMoveEndTagRightFullAny(Org,
       `', `', `NoTags',
       `"s"',
       `" " NS* [{ledning} | {lönsamhet} | {aktien}]') ;

!#  ############################################################################################################## 
!#  Characters around the annotation 
!#   *ok** +<ENAMEX>+ => ++ 

!R [^\n\>\<\t ]+\<ENAMEX[^\n\>]+\>[^\n\<]+\<\/ENAMEX\>[^\n\< ]+
!A {int i=0; for(;yytext[i]!='<';putchar(yytext[i++])); 
!A 	for(;yytext[i++]!='>';); for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	for(;yytext[i++]!='>';); for(;i<yyleng;putchar(yytext[i++]));}

!R [^\n\>\<\t ]+\<..MEX[^\n\>]+\>[^\n\<]+\<\/NUMEX\>[^\n\< ]+
!A {int i=0; for(;yytext[i]!='<';putchar(yytext[i++])); 
!A 	for(;yytext[i++]!='>';); for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	for(;yytext[i++]!='>';); for(;i<yyleng;putchar(yytext[i++]));}

! Combined to a single rule
Define RemoveTags@ [ NSTag+ RemoveStartTag NoTags RemoveEndTag NSTag ] ;

!#  Characters to the left of the annotation 
!# * +<ENAMEX> => ++ 

!R [^\n\>\<\t ]+\<ENAMEX[^\n\>]+\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0; for(;yytext[i]!='<';putchar(yytext[i++])); 
!A 	for(;yytext[i++]!='>';); for(;yytext[i]!='<';putchar(yytext[i++]));}
!R [^\n\>\<\t ]+\<..MEX[^\n\>]+\>[^\n\<]+\<\/..MEX\>
!A {int i=0; for(;yytext[i]!='<';putchar(yytext[i++])); 
!A 	for(;yytext[i++]!='>';); for(;yytext[i]!='<';putchar(yytext[i++]));}

! TODO: Couldn't this be combined with the previous rule?
Define RemoveTags@ [ NSTag+ RemoveStartTag NoTags RemoveEndTag ] ;

!#  kEEP THE 's' in ENAMEX if the word is >5 characters; (Annar>s, Trot>s 
!# *ok** <ENAMEX>s => ENAMEXs 
!#  TIMEX/NUMEX NO GOOD! have been removed

!R \<ENAMEX[^\n\>\<]+\>[^\n\< ][^\n\< ][^\n\< ][^\n\< ][^\n\< ]+\<\/ENAMEX\>s" "
!A {int i=0; for(;i<yyleng-11;putchar(yytext[i++]));
!A 	printf("s</ENAMEX> ");}

Define InnerContent1 NSTag^>4;

_DefineMoveEndTagRightAny(Enamex,
       `', `InnerContent1',
       `"s" RC(" ")') ;

! NOTE: Reordered rules slightly to avoid duplicating RemoveTags

!#  fix for LITTBANK 

!R \<TIMEX[^\n\>\<]+\>[^\n\<]+\<\/TIMEX\>[\.\;\)\,]
!A {ECHO;}

! NOTE: This rule was incorporated with a rule below

!#  Characters to the right of the annotation 
!# ...adding chars in ...ENAMEX\>[^\n\@\.\, ]+... would permit bad tokenised text 
!# *ok** <ENAMEX>+ => + 

!R \<ENAMEX[^\n\>\<]+\>[^\n\<]+\<\/ENAMEX\>[^\n ]+
!A {int i=0; for(;yytext[i++]!='>';);
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	for(;yytext[i++]!='>';); for(;i<yyleng;putchar(yytext[i++]));}
!R \<..MEX[^\n\>\<]+\>[^\n\<]+\<\/..MEX\>[^\n ]+
!A {int i=0; for(;yytext[i++]!='>';);
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	for(;yytext[i++]!='>';); for(;i<yyleng;putchar(yytext[i++]));}

! Handle cases in which the tags should be removed: everything except
! the above combination: Enamex, at least 5 non-spaces, "s"
! immediately following the end tag. Each case has a rule of its own.

Define RemoveTags@
       [ [ RemoveStartTagEnamex [ NoTags - [ NSTag NSTag NSTag NSTag NSTag+ ] ]
           RemoveEndTag "s" ]
	 RC(WordBoundary) ] ;

Define RemoveTags@
       [ [ RemoveStartTagEnamex NoTags RemoveEndTag [ NSTag+ - "s" ] ]
         RC(WordBoundary) ] ;

Define RemoveTags@
       [ [ [StartTagNumex .o. RemoveStartTag]
           NoTags RemoveEndTag NSTag+ ]
	 RC(WordBoundary) ] ;

! The TIMEX exception above was incorporated in the following rule

Define RemoveTags@
       [ [ [StartTagTimex .o. RemoveStartTag]
           NoTags RemoveEndTag [ NSTag+ - ["."|";"|")"|","] ] ]
	 RC(WordBoundary) ];

!#  ############################################################################################################## 
!#  specific ERRORS for humans; 
!# *ok** <PRS>säger Xxxx(ets|ens) VD X+</> 

!R \<ENAMEX" "TYPE\=\"PRS[^\n\>]+\>[a-zåäö]+" "[A-ZÅÄÖ][^\n ]+s" "[Vv][Dd]" "[^\<]+\<\/ENAMEX\>
!A {int i=0; 
!A 	for(;yytext[i++]!='>';); 
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); putchar(yytext[i++]);
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); putchar(yytext[i++]);
!A 	printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));  }

Define MoveStartTag@
       [ RemoveStartTagPrs LowerWord " " CapWord2 {s }
         Define(
	   Vv Dd " " NoTags RemoveEndTag
	   EndTag(EnamexPrsHum) ) ] ;

!# *ok** <PRS>säger Xxxx(ets|ens) => <PRS>säger Xxxx(ets|ens) 

!R \<ENAMEX" "TYPE\=\"PRS[^\n\>I]+\>[a-zåäö]+" "[A-ZÅÄÖ][^\n ]+(ens|erns|ans|bolaget|ings|kets|ands|rnas|rikes|arks|lvo|\:s)\<\/ENAMEX\>
!A {int i=0; 
!A 	for(;yytext[i++]!='>';); for(;yytext[i]!='<';putchar(yytext[i++]));}

! NOTE: Added an exception: HUMDESIGNATOR, "fru" and "herr" before the
! capitalized word do not trigger the rule

Define RemoveTags@
       [ RemoveStartTagPrs
         [ LowerWord - [HUMDESIGNATOR | {fru} | {herr}] ] " " CapWord2
         [{ens} | {erns} | {ans} | {bolaget} | {ings} | {kets} | {ands}
	  | {rnas} | {rikes} | {arks} | {lvo} | {:s}]
	 RemoveEndTag ];

!#  specific ERRORS for humans; berättade LO:s chef <> 

!R \<ENAMEX" "TYPE\=\"PRS[^\n\>I]+\>[A-ZÅÄÖ]+"\:s"<\/ENAMEX\>
!A {int i=0; for(;yytext[i]!='<';putchar(yytext[i++])); 
!A 	for(;yytext[i++]!='>';); for(;yytext[i]!='<';putchar(yytext[i++]));}

Define RemoveTags@
       [ RemoveStartTagPrs UpperWord {:s} RemoveEndTag ] ;

!#  specific ERRORS for humans; <>Göteborgs</> <>ordförande X+</> 

!R \<ENAMEX" "TYPE\=\"PRS[^\n\>I]+\>[A-ZÅÄÖ][^\n\>\< ]+s\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS[^\n\>]+\>{HUMDESIGNATOR}" "[A-ZÅÄÖ]
!A {ECHO;}

! This exception is integrated in the following rule

!R \<ENAMEX" "TYPE\=\"PRS[^\n\>I]+\>[A-ZÅÄÖ][^\n\>\< ]+s\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS[^\n\>]+\>[a-zåäö]+" "[A-ZÅÄÖ]
!A {
!A 	int i=0; for(;yytext[i++]!='>';);
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); for(;yytext[i++]!='>';);
!A 	for(;i<yyleng;putchar(yytext[i++]));}

Define RemoveTags@
       [ RemoveStartTagPrs CapWord2 "s" RemoveEndTag " "
         StartTagPrs [LowerWord - HUMDESIGNATOR] " " UppercaseAlpha ] ;

!#  specific ERRORS for animals; <>Det</> 

!R "\<ENAMEX TYPE\=\"PRS\" SBT\=\"ANM\"\>"(Det|Den|Jag|Han|Hon|De|Det" "är|Det" "var)\<\/ENAMEX\>
!A { int i=0; for(;yytext[i++]!='>';);
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));}

Define RemoveTags@
       [ RemoveStartTagPrsAnm
         [{Det} ({är} | {var}) | {Den} | {Jag} | {Han} | {Hon} | {De}]
	 RemoveEndTag ] ;

!# *******************************************************************
!#  Sometimes there are uppercase shit words matched in the beginning; which should be removes 
!#  NOT in ALL categories! E.g. Films 
!# *******************************************************************
!# need special cases; <LOC>{PREPS} sth</>

!R \<ENAMEX" "TYPE\=\"LOC[^\n\>]+\>{SHITWORDS_LOCS}" "[A-ZÅÄÖ][^\n\<]+\<\/ENAMEX\>
!A {int i=0; int j=0; for(;yytext[j++]!='>';); 
!A 	for(;yytext[j]!=' ';putchar(yytext[j++]));
!A 	putchar(' '); for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); for(;yytext[i++]!=' ';); 
!A 	for(;i<yyleng;putchar(yytext[i++]));}

!R \<ENAMEX" "TYPE\=\"PRS[^\n\>]+\>{SHITWORDS_PERS}" "[^\n\<]+\<\/ENAMEX\>
!A {int i=0; int j=0; for(;yytext[j++]!='>';); 
!A 	for(;yytext[j]!=' ';putchar(yytext[j++]));
!A 	putchar(' '); for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); for(;yytext[i++]!=' ';); 
!A 	for(;i<yyleng;putchar(yytext[i++]));}

!R \<ENAMEX" "TYPE\=\"EVN[^\n\>]+\>{SHITWORDS_EVNT}" "[^\n\<]+\<\/ENAMEX\>
!A {int i=0; int j=0; for(;yytext[j++]!='>';); 
!A 	for(;yytext[j]!=' ';putchar(yytext[j++]));
!A 	putchar(' '); for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); for(;yytext[i++]!=' ';); 
!A 	for(;i<yyleng;putchar(yytext[i++]));}

!R \<ENAMEX" "TYPE\=\"OBJ[^\n\>]+\>{SHITWORDS_OBJS}" "[A-ZÅÄÖ][^\n\<]+\<\/ENAMEX\>
!A {int i=0; int j=0; for(;yytext[j++]!='>';); 
!A 	for(;yytext[j]!=' ';putchar(yytext[j++]));
!A 	putchar(' '); for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); for(;yytext[i++]!=' ';); 
!A 	for(;i<yyleng;putchar(yytext[i++]));}

!R \<ENAMEX" "TYPE\=\"ORG[^\n\>]+\>{SHITWORDS_ORGS}" "[A-ZÅÄÖ][^\n\<]+\<\/ENAMEX\>
!A {int i=0; int j=0; for(;yytext[j++]!='>';); 
!A 	for(;yytext[j]!=' ';putchar(yytext[j++]));
!A 	putchar(' '); for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]);
!A 	for(;yytext[i++]!=' ';); 
!A 	for(;i<yyleng;putchar(yytext[i++]));}

!R \<ENAMEX" "TYPE\=\"WRK[^\n\>]+\>{SHITWORDS_WORK}" "[^\n\<]+\<\/ENAMEX\>
!A {int i=0; int j=0; for(;yytext[j++]!='>';); 
!A 	for(;yytext[j]!=' ';putchar(yytext[j++]));
!A 	putchar(' '); for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]);
!A 	for(;yytext[i++]!=' ';); 
!A 	for(;i<yyleng;putchar(yytext[i++]));}

m4_divert(-1)

! Collected the preceding rules to the following M4 macros and their
! application

m4_define(`_BadwordsSuffixLoc', `LOCS')
m4_define(`_BadwordsSuffixPrs', `PERS')
m4_define(`_BadwordsSuffixEvn', `EVNT')
m4_define(`_BadwordsSuffixObj', `OBJS')
m4_define(`_BadwordsSuffixOrg', `ORGS')
m4_define(`_BadwordsSuffixWrk', `WORK')

m4_define(`_MoveStartTagOver',
	  `[RemoveStartTag$1 [$2] AddStartTag$1]')

m4_define(`_MoveStartTagOverBadword',
	  `_MoveStartTagOver(`$1$2', `SHITWORDS%_'_BadwordsSuffix$1` " "')')

m4_define(`_DefineMoveStartTagOverBadword',
`Define MoveStartTagRight@
       [ _AlternativesApply(`_Curry(`_MoveStartTagOverBadword', $1)',
       	 		    _Subtypes$1)
	 UppercaseAlpha NoTags Endtag ] ;
')

m4_divert(0)

_ApplyAndJoinNewline(`_DefineMoveStartTagOverBadword', _TypesEnamex)

!#  In some cases with multiple quotations in a short passage, the matching can become strange 

!R \<ENAMEX[^\n\>]+\>[^ \n\<]+" "\"" "("\, stod det \,"|"\, som"|"\, och"|"och en"|men|och|som|\,)" "\"\<\/ENAMEX\>
!A {	int i=0; for(;yytext[i]!='>';i++); i++;
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	printf(" #WORD6REMOVED# ");}

Define RemoveTags@
       [ RemoveStartTagEnamex NSTag+ " " "\"" " "
         [{, stod det ,} | {, som} | {, och} | {och en} | {men} | {och}
	  | {som} | ","] " " "\""
	 RemoveEndTag ] ;

!# ***********************************************************************************************
!#  **** Removes some garbgae 
!# 	    <>........ i</>    <>........ .</>	 <>........ ,</>             ****************************
!# ***********************************************************************************************

!R \<ENAMEX" TYPE\="[^\n\>]+\>[^\n\<\>]+" "(i|\.|\,|\:)\<\/ENAMEX\>
!A {int i=0; int x=yyleng; for(;yytext[x]!='<';--x); --x; --x;
!A 	for(;i<x;putchar(yytext[i++])); printf("</ENAMEX>");
!A 	putchar(yytext[x]); putchar(yytext[x+1]);}

Define ExcludeAfter1 " " ["i" | "." | "," | ":"] ;

_DefineMoveEndTagLeftAny(Enamex,
      `',
      `NoTags',
      `ExcludeAfter1') ;

!R \<ENAMEX" TYPE\="[^\n\>]+\>(\:|\.|\,|\)|\()" "[^\n\<\>]+\<\/ENAMEX\>
!A {int i=0; int x=0;
!A 	for(;yytext[i]!='>';i++); i++;
!A 	putchar(yytext[i]); putchar(yytext[i+1]);
!A 	for(;yytext[x]!='>';putchar(yytext[x++]));
!A 	putchar(yytext[x]); x=x+3;
!A 	for(;x<yyleng;putchar(yytext[x++]));}

Define ExcludeBefore1 [[":"|"."|","|"("|")"] " "] ;

_DefineMoveStartTagRightAny(Enamex,
      `ExcludeBefore1',
      `NoTags') ;

!# ***********************************************************************************************
!#  **** This is actually a TAG-ADDER part    ****************************************************
!# ***********************************************************************************************
!# * <CLC> +++ => <CLC> <CLC> 
!# * <ORG> ( X+ ) => <ORG> ( <ORG> ) 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<\(0-9]+\<\/ENAMEX\>" \( "[A-ZÅÄÖ]+" \)"
!A {int i=0;
!A 	for(;yytext[i]!='(';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); putchar(yytext[i++]);
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\""); putchar(yytext[24]); 
!A 	putchar(yytext[25]); putchar(yytext[26]); printf("\">");
!A 	for(;yytext[i]!=' ';putchar(yytext[i++]));
!A 	printf("</ENAMEX>"); for(;i<yyleng;putchar(yytext[i++]));}

m4_divert(-1)
m4_define(`_CopyTagsRightEnamex',
	  `Define(
	     LC(_Tagged(`$1', `[$2]') [$3])
	     [$4]
	     RC($5)
	     EndTag(Enamex$1) )')
m4_define(`_CopyTagsRightParOrg',
	  `_CopyTagsRightEnamex(`Org$1', `[NoTagNum - "("]+', `{ ( }',
	  		        `UpperWord', `{ )}')')
m4_divert(0)

Define AddTags@ _AlternativesApply(`_CopyTagsRightParOrg', _SubtypesOrg) ;

!# * <ORG> , X+ .|, => <ORG> , <ORG> .|, 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<\(0-9\,]+\<\/ENAMEX\>" \, "[A-TV-ZÅÄÖ][A-ZÅÄÖ]+" "(\,|\.)
!A {int i=0;
!A 	for(;yytext[i]!=',';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); putchar(yytext[i++]);
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\""); putchar(yytext[24]); 
!A 	putchar(yytext[25]); putchar(yytext[26]); printf("\">");
!A 	for(;yytext[i]!=' ';putchar(yytext[i++]));
!A 	printf("</ENAMEX>"); for(;i<yyleng;putchar(yytext[i++]));}

m4_divert(-1)
m4_define(`_CopyTagsRightCommaOrg',
	  `_CopyTagsRightEnamex(`Org$1', `[NoTagNum - ["("|","]]+', `{ , }',
	  		        `UpperWord - [{USA} | {UK}]', `" " [","|"."]')')
m4_divert(0)

Define AddTags@ _AlternativesApply(`_CopyTagsRightCommaOrg', _SubtypesOrg) ;

!# * <ORG> XXX?X?X? [NOT EU&USA/VD] => ORG 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<\>\(0-9\,\:]+\<\/ENAMEX\>" "[A-TW-Z][A-TV-Z][A-Z]?[A-Z]?[A-Z]?" "[a-zåäö\,\.]
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); 
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); putchar(yytext[i++]);
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"");
!A 	putchar(yytext[24]); putchar(yytext[25]); putchar(yytext[26]); 
!A 	printf("\">"); for(;yytext[i]!=' ';putchar(yytext[i++]));
!A 	printf("</ENAMEX> "); putchar(yytext[yyleng-1]);}

m4_divert(-1)
m4_define(`_CopyTagsRightShortOrg',
	  `_CopyTagsRightEnamex(`Org$1', `[NoTagNum - ["("|","|":"]]+', `" "',
				`UppercaseAlpha^{2,5} - [{EU} | {USA} | {VD}]',
				`" " [LowercaseAlpha|","|"."]')')
m4_divert(0)

Define AddTags@ _AlternativesApply(`_CopyTagsRightShortOrg', _SubtypesOrg) ;

!# * <ORG> , Xx och|, <ORG> => <ORG> <ORG> <ORG> WROOOOOOOOOONG 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<\>]+\<\/ENAMEX\>" \, "[A-ZÅÄÖ][^\n\> ]+" "(och|\,)" "\<ENAMEX" "TYPE\=\"ORG\"
!A { int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); printf(" , "); i=i+3;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
!A 	for(;yytext[i]!=' ';putchar(yytext[i++]));
!A 	printf("</ENAMEX> "); for(;yytext[i++]!=' ';);
!A 	for(;i<yyleng;putchar(yytext[i++]));}

Define AddTags@
       [ LC(StartTagOrg NoTags EndTagEnamex { , })
	 CapWord2
         RC(" " [{och} | ","] " " StartTagOrg)
	 EndTag(EnamexOrgCrp) ] ;

!# *ok** <ORG> of|and|& Xx => <ORG> 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>" "(of|and|\&)" "[A-ZÅÄÖ][^\n\>\< ]+
!A {int x=yyleng; 
!A 	int i=0; for(;yytext[x]!='<';--x);
!A 	for(;i<x; putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng;putchar(yytext[i++]));
!A 	printf("</ENAMEX>");}

Define IncludeAfter1 [" " [{of} | {and} | "&"] " " CapWord2] ;

_DefineMoveEndTagRightAny(Org,
      `',
      `NoTags',
      `IncludeAfter1') ;

!# *ok** <VHG> VHGDESIGN => <VHG> 

!R \<ENAMEX" "TYPE\=\"OBJ\"" "SBT\=\"VH.\"\>[^\n\<]+\<\/ENAMEX\>" "{VHGDESIGNATOR}" "
!A {int x=yyleng; int i=0;
!A 	for(;yytext[x]!='<';--x);
!A 	for(;i<x; putchar(yytext[i++]));i=i+9;
!A 	for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

Define IncludeAfter2 " " VHGDESIGNATOR ;

_DefineMoveEndTagRightFullAny(`_ListObjVhX',
       `', `', `NoTags',
       `IncludeAfter2',
       `" "') ;

!# *ok** <ORG> ORGDESIGNATOR => <ORG> 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>s?(" "{ORGDESIGNATOR})+" "
!A {int x=yyleng; int i=0;
!A 	for(;yytext[x]!='<';--x);
!A 	for(;i<x; putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

!# *ok** <ORG> ORGDESIGNATOR\n => <ORG> 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>(" "{ORGDESIGNATOR})+"\n"
!A {int x=yyleng; int i=0;
!A 	for(;yytext[x]!='<';--x);
!A 	for(;i<x; putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX>\n");}

! The above two rules combined and slightly generalized.

Define IncludeAfter3 ("s") [" " ORGDESIGNATOR]+ ;

_DefineMoveEndTagRightFullAny(Org,
       `', `', `NoTags',
       `IncludeAfter3',
       `WhitespaceOrBoundary') ;

!# *ok** <PRS> HUMDESIGNATOR Xx+|X. Xx => <PRS> 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "({HUMDESIGNATOR}(" "[A-ZÅÄÖ][^\n\< ]*)+|[A-Z]\.(" "[A-ZÅÄÖ][^\n\< ]*)+)
!A {	int x=yyleng; 	int i=0; for(;yytext[x]!='<';--x);
!A 	for(;i<x; putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng;putchar(yytext[i++]));
!A 	printf("</ENAMEX>");}

_DefineMoveEndTagRight(PrsHum,
      `',
      `NoTags',
      `" " [ HUMDESIGNATOR | UppercaseAlpha "." ] [" " CapWord]+') ;

!# *ok** <PRS> Xx => <PRS> 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "[A-ZÅÄÖ][^\n\< ]+
!A {int x=yyleng; int i=0;
!A 	for(;yytext[x]!='<';--x);
!A 	for(;i<x; putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng;putchar(yytext[i++]));
!A 	printf("</ENAMEX>");}

_DefineMoveEndTagRight(PrsHum,
      `',
      `NoTags',
      `" " CapWord') ;

!# *ok** <PRS> HUMDESIGNATOR => <PRS> 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<]+\<\/ENAMEX\>" "{HUMDESIGNATOR_E}
!A {int x=yyleng; 	int i=0; for(;yytext[x]!='<';--x);
!A 	for(;i<x; putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng;putchar(yytext[i++]));
!A 	printf("</ENAMEX>"); }

_DefineMoveEndTagRight(PrsHum,
      `',
      `NoTags',
      `" " HUMDESIGNATOR%_E') ;

!# *ok** HUMDESIGNATOR <PRS> => <PRS> 

!R " "{HUMDESIGNATOR_I}" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=1; printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	for(;yytext[i]!='>';i++);  i++;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineMoveStartTagLeft(PrsHum,
      `LC(" ") HUMDESIGNATOR%_I " "',
      `NoTags') ;

!# *ok** <PRS> ( [csmv] ) => <PRS> ( <ORG> ) 
!#  Political parties following a person name 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\(]+\<\/ENAMEX\>" \( "(s|c|m|v|f|mp|fp|sp|kd|kds|sd|kds)" \)"
!A {int i=0;
!A 	for(;yytext[i]!='(';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); putchar(yytext[i++]);
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"PLT\">");
!A 	for(;yytext[i]!=' ';putchar(yytext[i++]));
!A 	printf("</ENAMEX>"); for(;i<yyleng;putchar(yytext[i++]));}

Define AddTags@
       [ LC(StartTagPrsHum [NoTag - "("]+ Endtag { ( })
	 [ "s" | "c" | "m" | "v" | "f" | {mp} | {fp} | {sp} | {kd} | {kds}
          | {sd} | {kds} ]
	 RC({ )})
	 EndTag(EnamexOrgPlt) ] ;

!# *ok** HUMAMBIGNAMES +++ => PRS 

!R {HUMAMBIGNAMES}" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>
!A {int i=0; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));}

_DefineMoveStartTagLeft(PrsHum,
	`HUMAMBIGNAMES " "',
	`NoTags') ;

!# *ok** <PRS> +++ => STR 
!# *ok** <PPL> +++ => STR 

!R \<ENAMEX" "TYPE\=\"(PRS|LOC)\"" "SBT\=\"[A-Z][A-Z][A-Z]\"\>[^\n\<]+\<\/ENAMEX\>" "(gränd|[Ss]treet|gata|GATA|Strasse|Road|Avenue|Boulevard)" "
!A {
!A 	int i=29; printf("<ENAMEX TYPE=\"LOC\" SBT=\"STR\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}	

Define ChangeTag@
       [ [ RemoveStartTagLocOrPrs NoTags RemoveEndTag " "
	   [ {gränd} | Ss {treet} | {gata} | {GATA} | {Strasse} | {Road}
	     | {Avenue} | {Boulevard} ] ]
	 RC(" ")
	 EndTag(EnamexLocStr) ] ;

!# *ok** mellan Xx och <PPL> => mellan <LOC> och <LOC> 

!R ellan" "[A-ZÅÄÖ][^\n\<\> ]+" och "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"PPL
!A {int i=6; printf("ellan <ENAMEX TYPE=\"LOC\" SBT=\"PPL\">");
!A 	for(;yytext[i]!=' ';putchar(yytext[i++]));
!A 	printf("</ENAMEX>");
!A 	for(;i<yyleng;putchar(yytext[i++])); }

Define AddTags@
       [ LC({ellan })
         CapWord2
         RC({ och } StartTagLocPpl)
         EndTag(EnamexLocPpl) ] ;

!# *ok** Xx & <ORG> => <ORG> 

!R [A-ZÅÄÖ][^\n\<\> ]*" \& "\<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>
!A {int i=0; printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));}

_DefineMoveStartTagLeft(OrgCrp,
	`CapWord { & }',
	`NoTags') ;

!# *ok** +++ <LOC> => LOC 

!R (Saint|Gamla|St\.|Lilla|Stora)" "\<ENAMEX" "TYPE=\"LOC\"" "SBT=\"...\"\>
!A {int i=0; int x=0; 
!A 	for(;yytext[i]!='<';i++); 
!A 	                	for(;i<yyleng;putchar(yytext[i++])); 
!A 	for(;yytext[x]!='<';putchar(yytext[x++]));}

Define IncludeBefore1 [{Saint} | {Gamla} | {St.} | {Lilla} | {Stora}] " " ;

_DefineMoveStartTagLeftAny(Loc, 
      `IncludeBefore1',
      `NoTags') ;

!# *ok** +++ <LOC> => LOC 

!R (Buidling|Restaurang|Hotel|Galleri|VC|[Vv]årdcentralen|[Vv]årdc|VåC)" "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"...\"\>
!A {int i=0; printf("<ENAMEX TYPE=\"LOC\" SBT=\"FNC\">");
!A 	 for(;yytext[i]!='<';putchar(yytext[i++]));}

_DefineChangeMoveStartTagLeft(Loc, LocFnc,
	`[ {Building} | {Restaurang} | {Hotel} | {Galleri} | {VC}
	   | {[Vv]årdc} ({entralen}) | {VåC} ] " "',
	`NoTags') ;

!# *ok** +++ vid <LOC&ORG> => LOC 

!R (sning|jongen|alerna|hållna|unden|gligt|mrådet|lats|ddag)" vid "\<ENAMEX" "TYPE\=\"LOC\/ORG\"" "SBT\=\"...\/...\"\>[^\n\<]+\<\/ENAMEX\>
!A { int i=0;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"FNC\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

m4_divert(-1)
m4_define(`_DefineDisambiguateTag (amb_tag, new_tag, preceding, within,
				   following)')
m4_define(`_DefineDisambiguateTag',
	`Define DisambiguateTag@
       [ $3
         [ [StartTagAmbiguous$1 .o. RemoveStartTag] $4 RemoveEndTag ]
         $5
	 EndTag(Enamex$2) ]')

m4_define(`_DefineDisambiguateTagSimple (amb_tag, new_tag, preceding,
				   	 following)')
m4_define(`_DefineDisambiguateTagSimple',
	  `_DefineDisambiguateTag(`$1', `$2', `$3', `NoTags', `$4')')
m4_divert(0)

_DefineDisambiguateTagSimple(LocOrg, LocFnc,
           `LC([ {sning} | {jongen} | {alerna} | {hållna} | {unden} | {gligt}
              | {mrådet} | {lats} | {ddag} ] { vid })') ;

!# *ok** +++ på <LOC&ORG> => LOC 

!R (pelar|ummen|amförs|spelas|stå|slagord|stå|ngssal|kalbrist|isades|liniken|nlagd|öket|vård)" på "\<ENAMEX" "TYPE\=\"LOC\/ORG\"" "SBT\=\"...\/...\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"FNC\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocOrg, LocFnc,
         `LC([ {pelar} | {ummen} | {amförs} | {spelas} | {stå} | {slagord} 
	      | {stå} | {ngssal} | {kalbrist} | {isades} | {liniken} | {nlagd}
	      | {öket} | {vård} ] { på })') ;

!# *ok** +++ i <LOC&ORG> => LOC 

!R (vlidit|njetter|okaler|sal|formerar|erkstad|gnaderna|usik)" i "\<ENAMEX" "TYPE\=\"LOC\/ORG\"" "SBT\=\"...\/...\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"FNC\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocOrg, LocFnc,
        `LC([ {vlidit} | {njetter} | {okaler} | {sal} | {formerar} | {erkstad}
              | {gnaderna} | {usik} ] { i })') ;

!# *ok** +++ +++ <PPL> => +++ +++ <GPL> 

!R (östra|västra|norra|södra|stuga" "på|villa" "på|stuga" "i|"söder om"|närliggande|utanför|norr" "om)" "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"PPL\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"GPL\"");
!A 	i=i+16; for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(LocPpl, LocGpl,
      `LC([ {östra} | {västra} | {norra} | {södra} | {stuga på} | {villa på}
              | {stuga i} | {söder om} | {närliggande} | {utanför} | {norr om} ]
	    " ")',
      `NoTags') ;

!# *ok** <LOC&ATH> +++ => <ATH> 

!R \<ENAMEX" "TYPE\=\"LOC\/ORG\"" "SBT\=\"...\/ATH\"\>[^\n\<]+\<\/ENAMEX\>" "[^\n\<\> ]*(kom" "tillbaka|var" alldeles för "bra|i" "högsta|förlora|spelare|orkade|vann|börjar" "serie)
!A { int i=0;
!A 	for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocOrgAth, OrgAth,
	 `',
         `RC(" " NSTag*
	    [ {kom tillbaka} | {var alldeles för bra} | {i högsta} | {förlora}
	      | {spelare} | {orkade} | {vann} | {börjar serie} ])') ;

!# *ok** +++ +++ <ORG> => FNC 

!R [^\n\>\<\= ]*(nne" "på|"nne i"|"onom på"|tanför" "[a-zåäö]+|"dött på"|ittemot" "[a-zåäö]+|"pererades på"|"skadade till"|ned" "till|"skulle till"|uppsöka|"dagen på"|ntill|"sängen på"|"ferensen på"|"ulans till"|"spelas i"|"föreläser i"|transport[a-z]+" till"|"hålls i"|"framträdde i"|"föras till"|"operera sig vid"|"vårdas på"|"inlagd på"|"vård på"|[^\n ]"parken i"|"ceremoni på"|Förbi|nne" på"|"fördes till"|"atienter till"|"kickades till")" "\<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[A-ZÅÄÖ][^\n\<0-9][^\n\<0-9]+\<\/ENAMEX\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"FNC\"");
!A 	i=i+16; for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(Org, LocFnc,
	`LC(NSTag*
	    [ {nne på} | {nne i} | {onom på} | {tanför } LowerWord | {dött på} | {ittemot } LowerWord | {pererades på} | {skadade till} | {ned till} | {skulle till} | {uppsöka} | {dagen på} | {ntill} | {sängen på} | {ferensen på} | {ulans till} | {spelas i} | {föreläser i} | {transport} LowerWord { till} | {hålls i} | {framträdde i} | {föras till} | {operera sig vid} | {vårdas på} | {inlagd på} | {vård på} | NS {parken i} | {ceremoni på} | {Förbi} | {fördes till} | {atienter till} | {kickades till} ]
	    " ")',
	`UppercaseAlpha NoTagNum NoTagNum+') ;

!# *ok** +++ <LOC/ORG> => FNC 
!# *ok** +++ <LOC/LOC> => FNC 

!R (yggt|nytt|kallt|fritt|förbi|invigda|tanför|akom|renovera|noverade|[Nn]ära)" "\<ENAMEX" "TYPE\=\"LOC\/...\"" "SBT\=\"...\/...\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"FNC\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(Loc, LocFnc,
         `LC([ {yggt} | {nytt} | {kallt} | {fritt} | {förbi} | {invigda}
	      | {tanför} | {akom} | {renovera} | {noverade} | Nn {ära} ] " ")') ;

!# *ok** +++ <LOC/ORG> => LOC 

!R ("akterna av"|"vigning av"|"onsert från"|farten" "till|"år från"|"ringen från"|"årig från"|"edamot från"|"man från"|"ikopter till"|"komst till"|"yttades till"|"kom tlll")" "\<ENAMEX" "TYPE\=\"LOC\/ORG\"" "SBT\=\"...\/...\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"FNC\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocOrg, LocFnc,
         `LC([  [{akterna} | {vigning}] { av}
	     | [{onsert} | {år} | {ringen} | {årig} | {edamot} | {man}] { från}
	     | [{farten} | {ikopter} | {komst} | {yttades} | {kom}] { till} ]
	    " ")') ;

!# *ok** +++ <LOC/HUM> => <LOC> 
!#  BUT: cupen mot   utgå från   poäng mot

!R (sändas" "till|resa" "till|Till|reste" "till|nått|"redsavtal med"|ängs|"kanten av"|"pmöte med"|"läggningar med"|tida|edre|tination|dsliga|dsligt|orten|esökte|belgiska|[Öö]vre|ervänd[a-z]+" till"|anlände" "till|ervänd[a-z]+" "[a-z]+" "till|"förts till"|"koppling till"|rordrabbade|ombdrabbade|ldsdrabbade|anrika|kallt|ett|[^\n\= ]*landet|flyg[a-z]*" till"|tåg[a-z]*" tlll"|[Rr]unt|"ett "[^\n \=]+|träckan|rigets|ockuper[^\n\= ]+|llersta|dagens|landet|soligt|nära|igger|kring|intog|vadera|tidens|mrådet|sitt|tanför|besöker|ntrala|"trakten av"|talets|"elarna av"|"delen av"|"ned till"|"ner till"|"kom till"|"kommer av"|"ntrum av"|[Ff]rån|[Vv]ia|[Vv]id|spanska|franska|merikanska|[Öö]ver|enom|[Hh]ela|[Ii]|[Pp]å|[Mm]ot|ellan|edanför|[Ii]nom|[Ii]nre|förort|"i just"|"kör till"|"örort till"|"hem till"|ortom|"ägen till"|"väg till"|"i själva"|stryka|South|i" "[^\n ]+ska|lyttade" "till|turné" "till|sig" "till|land" "än|mitt" "kärra|passerat)" "\<ENAMEX" "TYPE\=\"LOC\/PRS\"" "SBT\=\"...\/HUM\"\>[^\n\<]+\<\/ENAMEX\>
!A { int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"PPL\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocPrsHum, LocPpl,
         `LC([ {sändas till} | {resa till} | {Till} | {reste till} | {nått} | {redsavtal med} | {ängs} | {kanten av} | {pmöte med} | {läggningar med} | {tida} | {edre} | {tination} | {dsliga} | {dsligt} | {orten} | {esökte} | {belgiska} | ["Ö"|"ö"] {vre} | {ervänd} LowerWord (" " LowerWord) { till} | {anlände till} | {förts till} | {koppling till} | {rordrabbade} | {ombdrabbade} | {ldsdrabbade} | {anrika} | {kallt} | {ett} | (Word) {landet} | {flyg} (LowerWord) { till} | {tåg} (LowerWord) { till} | Rr {unt} | {ett } Word | {träckan} | {rigets} | {ockuper} Word | {llersta} | {dagens} | {landet} | {soligt} | {nära} | {igger} | {kring} | {intog} | {vadera} | {tidens} | {mrådet} | {sitt} | {tanför} | {besöker} | {ntrala} | {trakten av} | {talets} | {elarna av} | {delen av} | {ned till} | {ner till} | {kom till} | {kommer av} | {ntrum av} | Ff {rån} | Vv {ia} | Vv {id} | {spanska} | {franska} | {merikanska} | ["Ö"|"ö"] {ver} | {enom} | Hh {ela} | Ii | Pp "å" | Mm {ot} | {ellan} | {edanför} | Ii {nom} | Ii {nre} | {förort} | {i just} | {kör till} | {örort till} | {hem till} | {ortom} | {ägen till} | {väg till} | {i själva} | {stryka} | {South} | {i } Word {ska} | {lyttade till} | {turné till} | {sig till} | {land än} | {mitt kärra} | {passerat} ] " ")') ;

!# *ok** <LOC&PRS> *minister => <LOC> 
!#  Israels armé 

!R \<ENAMEX" "TYPE\=\"LOC\/PRS\"" "SBT\=\"PPL\/HUM\"\>[^\n\<]+\<\/ENAMEX\>" "[^\n ]*(armé|minister|kabinett|krig|president)
!A { int i=0;
!A 	for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"LOC\" SBT=\"PPL\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocPplPrsHum, LocPpl,
	`',
	`RC([ " " (Word)
	      [ {armé} | {minister} | {kabinett} | {krig} | {president} ] ])') ;

!# *ok** <LOC&PRS> +++ => <FNC> 

!R \<ENAMEX" "TYPE\=\"LOC\/PRS\"" "SBT\=\"...\/HUM\"\>[^\n\<]+\<\/ENAMEX\>" "[^\n\<\> ]*(jukhus|splats|skola|[Tt]org|central|Hospital)
!A { int i=0;
!A 	for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"LOC\" SBT=\"FNC\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocPrsHum, LocFnc,
	`',
	`RC([ " " NSTag*
 	      [{jukhus} | {splats} | {skola} | Tt {org} | {central}
	       | {Hospital}] ])') ;

!# *ok** <LOC> och|eller|, <LOC&PRS> => <LOC> och|eller|, <LOC> 

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"PPL\"\>[^\n\<]+\<\/ENAMEX\>" "(och|eller|\,)" "\<ENAMEX" "TYPE\=\"LOC\/...\"" "SBT\=\".PL\/...\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"PPL\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocXpl, LocPpl,
	`LC(StartTagLocPpl NoTags EndTagEnamex " " [{och} | {eller} | ","] " ")') ;

!# *ok** <LOC&PRS> och <LOC> => <LOC> 

!R \<ENAMEX" "TYPE\=\"LOC\/PRS\"" "SBT\=\"PPL\/HUM\"\>[^\n\<]+\<\/ENAMEX\>" "(och|\,|eller)" "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"PPL\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"LOC\" SBT=\"PPL\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocPplPrsHum, LocPpl,
	`',
	`RC(" " [{och} | "," | {eller}] " " StartTagLocPpl NoTags EndTagEnamex)') ;

!# *ok** <LOC&PRS> och <PRS> => <PRS> 

!R \<ENAMEX" "TYPE\=\"LOC\/PRS\"" "SBT\=\"PPL\/HUM\"\>[^\n\<]+\<\/ENAMEX\>" och "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\< ]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"LOC\" SBT=\"PPL\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

! NOTE: The above rule seems to choose incorrectly LOC PPL instead of
! PRS HUM.

_DefineDisambiguateTagSimple(LocPplPrsHum, PrsHum,
	`',
	`RC({ och } StartTagPrsHum NSTag+ EndTagEnamex)');

!# *ok** <LOC> +++ => ATH 
!#  removed the SS, because of the AT texts 

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"[A-Z][A-Z][A-Z]\"\>[^\n\<]+\<\/ENAMEX\>" "besegrade" "(han|hon|det)
!A {ECHO;}

Define Except@
       [ StartTagLoc NoTags EndTagEnamex { besegrade } [{han} | {hon} | {det}] ] ;

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"[A-Z][A-Z][A-Z]\"\>[^\n\<]+\<\/ENAMEX\>" "(AIF|IK|MSK|FF)\:s" "([ABC]\-[a-zåäö]*|DC\-[a-zåäö]*|[a-zåäö]*)lag(et)?
!A { int i=29;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}

Define ChangeTag@
       [ RemoveStartTagLoc NoTags RemoveEndTag
         " " [{AIF} | {IK} | {MSK} | {FF}] {:s }
	 [["A"|"B"|"C"] "-" Lower* | {DC-} Lower* | Lower*] {lag} ({et})
	 EndTag(EnamexOrgAth) ] ;

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"[A-Z][A-Z][A-Z]\"\>[^\n\<]+\<\/ENAMEX\>" "(SK|BK|AIF|IK|BIK|TS|GK|Ishockeyklubb|Hockey|Sportklubb|[^\n ]+rittklubb|[Gg]olfklubb|[Rr]idklubb|[Kk]anotklubb|Sportclub|Basket|[Ss]portklubb|MSK|IF|FF|FF\:s|[ABC]\-pojkar|[ABCVMOS]\-[a-z]*lag|[ABCVMOS]\-[a-z]*trupp|Innebandy|DC\-[a-z]*lag|[^\n ]*landslag)
!A { int i=29;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng;putchar(yytext[i++]));
!A 	printf("</ENAMEX>");}

Define ChangeTag@
       [ RemoveStartTagLoc NoTags RemoveEndTag
         " " [{SK} | {BK} | {AIF} | {IK} | {BIK} | {TS} | {GK} | {Ishockeyklubb} | {Hockey} | {Sportklubb} | Word {rittklubb} | Gg {olfklubb} | Rr {idklubb} | Kk {anotklubb} | {Sportclub} | {Basket} | Ss {portklubb} | {MSK} | {IF} | {FF} | {FF:s} | ["A"|"B"|"C"] {-pojkar} | ["A"|"B"|"C"|"V"|"M"|"O"|"S"] "-" Az* {lag} | ["A"|"B"|"C"|"V"|"M"|"O"|"S"] "-" Az* {trupp} | {Innebandy} | {DC-} Az* {lag} | NS* {landslag}]
	 EndTag(EnamexOrgAth) ] ;

!# *ok** <LOC|PRS> +++ => <ORG> 

!R \<ENAMEX" "TYPE\=\"(PRS|LOC)\"" "SBT\=\"[A-Z][A-Z][A-Z]\"\>[^\n\<]+\<\/ENAMEX\>" "[^\n ]*(Brandkåren|Health|AB|Slakteri|[^\n\< ]+myndighet|[^\n uöb][^\n\< ]+senhet|Vänner|[^\n ]+förening|Company|örlag|tiftelse|"älso\- och "[^\n ]+nämnd|"kliniska forskningscentrum")(en|er)?
!A {int i=29; printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}

Define ChangeTag@
       [ RemoveStartTagLocOrPrs NoTags RemoveEndTag
         " " NS* [{Brandkåren} | {Health} | {AB} | {Slakteri} | NSTag+ {myndighet} | [NS - ["u"|"ö"|"b"]] NSTag+ {senhet} | {Vänner} | Word {förening} | {Company} | {örlag} | {tiftelse} | {älso- och } Word {nämnd} | {kliniska forskningscentrum}] ({en} | {er})
	 EndTag(EnamexOrgCrp) ] ;

!# *ok** <ORG> +++ => <LOC> 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[A-ZÅÄÖ][^\n\<]+\<\/ENAMEX\>" "[^\n ]*(lilla" "park|hotell|bygge|[Tt]org|huvudkontor|tält|butik|yggnad|lokaler|matsal|fabrik|anläggning|stuga|gård|tunnel|laboratorium)(ar)?" "
!A { int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"FNC\">"); i=i+17; 
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

Define ChangeTag@
       [ [ RemoveStartTagOrg NoTags RemoveEndTag
           " " NS* [{lilla park} | {hotell} | {bygge} | Tt {org} | {huvudkontor} | {tält} | {butik} | {yggnad} | {lokaler} | {matsal} | {fabrik} | {anläggning} | {stuga} | {gård} | {tunnel} | {laboratorium}] ({ar}) ]
	 RC(" ")
	 EndTag(EnamexLocFnc) ] ;

!# *ok** <LOC> {LOCDESIGNATOR}|+++ => LOC 

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"PPL\"\>[^\n\<]+\<\/ENAMEX\>" "({LOCDESIGNATOR}(" "[A-ZÅÄÖ][^\n\< ]*)+|al\-[^\n\t\< ]+|[Ll]"äns "[Ll]andsting|[Ll]än|Väst|syd|Sydväst|Södra|Norra|Västra|Östra|[Kk]ommun|[Ss]tift)" "
!A {int x=yyleng; 	int i=0; for(;yytext[x]!='<';--x);
!A 	for(;i<x; putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng-1;putchar(yytext[i++]));printf("</ENAMEX> ");}

_DefineMoveEndTagRightFull(LocPpl,
       `', `', `NoTags',
       `" " [LOCDESIGNATOR [" " Upper NSTag*]+ | {al-} NSTag+ | Ll {äns } Ll {andsting} | Ll {än} | {Väst} | {syd} | {Sydväst} | {Södra} | {Norra} | {Västra} | {Östra} | Kk {ommun} | Ss {tift}]',
       `" "') ;

!# *ok** <FNC> i Xx => <FNC> i <PPL> 

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"FNC\"\>[^\n\<]+\<\/ENAMEX\>" i "[A-ZÅÄÖ][^\n\t\< ]+
!A { int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]);
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	printf("> i <ENAMEX TYPE=\"LOC\" SBT=\"PPL\">"); i=i+4;
!A 	for(;i<yyleng;putchar(yytext[i++]));
!A 	printf("</ENAMEX>");}

Define AddTags@
       [ LC(StartTagLocFnc NoTags EndTagLocFnc { i })
	 [ Upper NSTag+ ]
       	 EndTag(EnamexLocPpl) ] ;

!# *ok** <ORG> +++  => <OBJ> 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[A-ZÅÄÖ][^\n\<]+\<\/ENAMEX\>" "([AB]|[AB]\-aktie|[AB]\-aktier)" "
!A { int i=0;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"OBJ\" SBT=\"PRD\">"); i=i+17; 
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

Define ChangeTag@
       [ [ RemoveStartTagOrg Upper NoTags RemoveEndTag
           " " [["A"|"B"] | ["A"|"B"] {-aktie} | ["A"|"B"] {-aktier}] ]
	 RC(" ")
	 EndTag(EnamexObjPrd) ] ;

!# *ok** <PRS> <...&PRS> => <PRS> <PRS> 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"...\/PRS\"" "SBT\=\"...\/HUM\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"PRS\" SBT=\"HUM\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(PrsHum, PrsHum,
	`LC(StartTagPrsHum NoTags EndTagEnamex " ")') ;

!# *ok** +++ vid <PRS> => <LOC> 

!R [^\n\=\<\> ]*(llisionen|nere|tation|plats|män|platsen|ute|olycka|boende)" "(på|vid)" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[A-Z]+
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"PPL\">"); i=i+17;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

Define ChangeTag@
       [ LC(NSTag* [{llisionen} | {nere} | {tation} | {plats} | {män} | {platsen} | {ute} | {olycka} | {boende}]
            " " [{på} | {vid}] " ")
	 [ RemoveStartTagPrsHum UpperWord NoTags RemoveEndTag ]
         EndTag(EnamexLocPpl) ] ;

!# *ok** +++ vid <PRS> => <ORG> 

!R [^\n\= ]*([Cc]hef|orskare|studier|examen|fessor|erksamma|bildningen|olycka|verksamhet)" vid "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[A-Z]+
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"CRP\">"); i=i+17;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

Define ChangeTag@
       [ LC(NSTag* [Cc {hef} | {orskare} | {studier} | {examen} | {fessor} | {erksamma} | {bildningen} | {olycka} | {verksamhet}] { vid })
	 [ RemoveStartTagPrsHum UpperWord NoTags RemoveEndTag ]
         EndTag(EnamexOrgCrp) ] ;

!# *ok** +++ <LOC> över <LOC> => ORG(ATH) 

!R [Vv][Aa][Nn][Nn]" "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"...\"\>[^\n \<\=]+\<\/ENAMEX\>" över "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\">");
!A 	for(;yytext[i]!='>';i++); i++;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\">");
!A 	for(;yytext[i]!='>';i++); i++;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

Define ChangeTag@
       [ Define(
           LC(Vv Aa Nn Nn " ")
           [ RemoveStartTagLoc NSTag+ RemoveEndTag ]
           EndTag(EnamexOrgAth) )
	 { över }
	 Define(
	   [ RemoveStartTagLoc NSTag+ RemoveEndTag ]
	   EndTag(EnamexOrgAth) ) ] ;

!# *ok** <PRS> [A-ZÅÄÖ].? <PRS> => <PRS> 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "[A-ZÅÄÖ]\.?" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));  i=i+9;
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));  i=i++;
!A 	for(;yytext[i]!='>';i++); i++;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineCombineNames(`PrsHum', `', `NoTags', `" " Upper (".") " "', `NoTags') ;

!# * <PRS> "som tillsammans med"|och Xx:s => <PRS> <ORG> 
!#  <Bo Henning> och HTF:s  / except USA:s 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "("som tillsammans med"|och)" "[A-TV-Z][^ \n]+\:s
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]);
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	while(!isupper(yytext[i])) putchar(yytext[i++]);
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));
!A 	printf("</ENAMEX>");}

Define AddTags@
       [ LC(StartTagPrsHum NoTags EndTagEnamex " "
	    [{som tillsammans med} | {och}] " ")
	 [ (CapWord2 - {USA}) {:s} ]
         EndTag(EnamexOrgCrp) ] ;

!# *ok** <PRS> X , => <PRS> , 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\> ]+\<\/ENAMEX\>" "[A-Z]" \,"
!A {int i=0; for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]);
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	putchar(yytext[i++]);putchar(yytext[i++]);
!A 	printf("</ENAMEX> ,");}

_DefineMoveEndTagRightFull(PrsHum,
      `', `', `NoTags',
      `" " Upper',
      `{ ,}') ;

!# *ok** <PRS> +++ Xx+ => <PRS> +++ <PRS> 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "("som tillsammans med"|och)(" "[A-Z][^ \:\n\<\-\>]+[^ \:\n\<\-\>s])+" "
!A {int i=0; for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]);
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	while(!isupper(yytext[i])) putchar(yytext[i++]);
!A 	printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
!A 	for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

Define AddTags@
       [ LC(StartTagPrsHum NoTags EndTagEnamex " "
            [{som tillsammans med} | {och}] " ")
	 [ Upper NSTagDashColon+ [NSTagDashColon - "s"]
           [" " Upper NSTagDashColon+ [NSTagDashColon - "s"]]* ]
	 RC(" ")
	 EndTag(EnamexPrsHum) ] ;

!# *ok** <PRS> " Xx " X+ => <PRS> 

!R SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" \" "[A-ZÅÄÖ][^\n\< ]+" \" "[A-ZÅÄÖ][^\n\< ]+
!A {int x=yyleng; int i=0;
!A 	for(;yytext[x]!='<';--x);
!A 	for(;i<x; putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng;putchar(yytext[i++]));
!A 	printf("</ENAMEX>");}

_DefineMoveEndTagRight(PrsHum,
      `', `NoTags',
      `" " "\"" " " Upper NSTag+ " " "\"" " " Upper NSTag+') ;

!# *ok** <PRS> " Xx " <PRS> => <PRS> 

!R SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" \" "[A-ZÅÄÖ][^\n\<\" ]+" \" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]);
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i++; putchar(' ');
!A 	i=i+9;for(;yytext[i]!='<';putchar(yytext[i++]));}

_DefineCombineNames(`PrsHum', `', `NoTags',
	            `" " "\"" " " Upper [NSTag - "\""]+ " " "\"" " "',
		    `NoTags') ;

!# *ok** +++ <ATH> och Xx => +++ <ATH> och <ATH> 

!R [^\n\>\<\t ]*(mellan|möts|lagen)" "\<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"ATH\"\>[^\n\<]+\<\/ENAMEX\>" "och(" "[A-ZÅÄÖ][^\n\> ]+)+
!A { int i=0; 
!A 	int x=yyleng; for(;yytext[x]!='>';--x);
!A 	for(;i<x+1;putchar(yytext[i++])); printf(" och "); x=x+6;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
!A 	for(;x<yyleng;putchar(yytext[x++]));printf("</ENAMEX>"); 
!A 	}

Define AddTags@
       [ LC(NSTag* [{mellan} | {möts} | {lagen}] " "
	    StartTagOrgAth NoTags EndTagEnamex { och })
	 [ Upper NSTag+ [" " Upper NSTag+]* ]
         EndTag(EnamexOrgAth) ] ;

!# *ok** <ORG> och XXX => <...> och <ORG>

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>" och "[A-Z][A-Z][^\n ]+
!A { int i=0; 
!A 	int x=yyleng; for(;yytext[x]!='>';--x);
!A 	for(;i<x+1;putchar(yytext[i++])); printf(" och "); x=x+6;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
!A 	for(;x<yyleng;putchar(yytext[x++]));printf("</ENAMEX>"); 
!A 	}

Define AddTags@
       [ LC(StartTagOrg NoTags EndTagEnamex { och })
         [ Upper Upper Word ]
         EndTag(EnamexOrgCrp) ] ;

!#  <ATH> och <LOC/ORG> => <ATH> och <ATH> 

!R SBT\=\"ATH\"\>[^\n\<]+\<\/ENAMEX\>" och "\<ENAMEX" "TYPE\=\"LOC\/...\"" "SBT\=\"[\/A-Z]+\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0;
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\">"); i=i+25;
!A 	for(;i<yyleng;putchar(yytext[i++])); }

_DefineDisambiguateTagSimple(Loc, OrgAth,
	`LC(StartTagOrgAth NoTags EndTagEnamex { och })') ;

!# *ok** <PRS> +++ => FNC 

!R \<ENAMEX" "TYPE\=\"(PRS|LOC)\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>(s)?" "[^\n ]*([A-Z][^\n\>\< ]+" "[Bb]ar|[^\n ]+ibliotek|Theatre|[^\n ]+plats|[Aa]rena|vc|VC|äldreboende|väderkvarn|regemente|galleri|Gallery|Motel|National" "[Pp]ark|[Tt]org|torn|okhandel|aula|[Hh]ospital|School|ostterminal|ussterminal|[Mm]oské|[Mm]oskén|behandlingshem|sjukhem|reningsverk|Pavilion|Hilton|Building|Hotel|[Hh]otell|kyrka|kapell|[^\n ]*skola|Church|museum|[^\n ]+hus|[^\n ]+rum|[^\n ]+station|[a-zåäö]hall|[Ss]hoppingcenter|stugby|Center|[^\ni ]park|Park|äb|gator|slott|[Cc]entrum|lasarett|gård|V[Cc]|[Zz]oo|vägsstation|[Vv]årdcentral)" "
!A {int i=29; printf("<ENAMEX TYPE=\"LOC\" SBT=\"FNC\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

Define ChangeTag@
       [ [ [ RemoveStartTagLocOrPrs NoTags RemoveEndTag ]
           ("s") " " NS* [Upper NSTag+ " " Bb {ar} | Word {ibliotek} | {Theatre} | Word {plats} | Aa {rena} | {vc} | {VC} | {äldreboende} | {väderkvarn} | {regemente} | {galleri} | {Gallery} | {Motel} | {National } Pp {ark} | Tt {org} | {torn} | {okhandel} | {aula} | Hh {ospital} | {School} | {ostterminal} | {ussterminal} | Mm {oské} | Mm {oskén} | {behandlingshem} | {sjukhem} | {reningsverk} | {Pavilion} | {Hilton} | {Building} | {Hotel} | Hh {otell} | {kyrka} | {kapell} | NS* {skola} | {Church} | {museum} | Word {hus} | Word {rum} | Word {station} | Lower {hall} | Ss {hoppingcenter} | {stugby} | {Center} | [? - ["\n"|"i"|" "]] {park} | {Park} | {äb} | {gator} | {slott} | Cc {entrum} | {lasarett} | {gård} | "V" Cc | Zz {oo} | {vägsstation} | Vv {årdcentral}] ]
	 RC(" ")
	 EndTag(EnamexLocFnc) ] ;

! *ok** <ATH> xxxx <PPL> => <ATH> xxxx <ATH>

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"ATH\"\>[^\n\<]+\<\/ENAMEX\>" "(mot|och|möter|besegrade)" "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"(PPL|GPL|FNC)\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++])); putchar(yytext[i++]);
!A 	for(;yytext[i]!='>';putchar(yytext[i++])); putchar(yytext[i++]);
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+29;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
!A 	for(;i<yyleng;putchar(yytext[i++])); }

! NOTE: This rule was effectively commented out in the source with but
! was it by accident (missing end of comment) or deliberately?

Define ChangeTag@
       [ LC(StartTagOrgAth NoTags EndTagEnamex " "
	    [{mot} | {och} | {möter} | {besegrade}] " ")
         [ RemoveStartTagLocPplOrGplOrFnc NoTags RemoveEndTag ]
         EndTag(EnamexOrgAth) ] ;

! * <PRS> , NN? , => <PRS> , <MSR> ,

!R SBT\=\"HUM\"\>[^\n\<\,]+\<\/ENAMEX\>" \, "[1-9][0-9]" "[\:\.\,]
!A {int i=0; for(;yytext[i]!=',';putchar(yytext[i++]));
!A 	printf(", <NUMEX TYPE=\"MSR\" SBT=\"AGE\">");
!A 	i=i+2;putchar(yytext[i++]); putchar(yytext[i++]);
!A 	printf("</NUMEX> "); putchar(yytext[yyleng-1]);}

!R SBT\=\"HUM\"\>[^\n\<\,]+\<\/ENAMEX\>" \, "[1-9]" "[\:\.\,]
!A {int i=0; for(;yytext[i]!=',';putchar(yytext[i++]));
!A 	printf(", <NUMEX TYPE=\"MSR\" SBT=\"AGE\">");
!A 	i=i+2; putchar(yytext[i++]);
!A 	printf("</NUMEX> "); putchar(yytext[yyleng-1]);}

! Combined the preceding two rules
Define AddTags@
       [ LC(StartTagPrsHum [NoTag - ","]+ EndTagEnamex { , })
	 [ Num19 (Num) ]
         RC(" " [":"|"."|","])
	 EndTag(NumexMsrAge) ] ;

!# ******************************************************************************
!#  This is actually a tag-MODIFIER part 
!# ******************************************************************************
!# *ok** <ORG> +++ => OBJ(PRD} 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>(Nasdaq|[^\n\<]+börsen)\<\/ENAMEX\>" "("steg med"|"föll med"|"föll tillbaka"|"gick ned"|"gick upp"|steg|stigit|backade|backat|sjönk|tappade|handlades|"fortsatte upp med"|"som gick upp"|"vände ned med")" "([0-9]|drygt|närmare|däremot|från|något|kraftigt|"som väntat"|"som en")
!A {ECHO;}

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>" "("dök med"|"följde med nedåt"|"steg med"|"föll med"|"föll tillbaka"|"gick ned"|"gick upp"|steg|"klättrade med"|klättrade|stigit|"backade med"|backade|backat|sjönk|tappade|handlades|"fortsatte upp med"|"som gick upp"|"vände ned med")" "([0-9]|drygt|närmare|däremot|från|något|kraftigt|"som väntat"|"som en"|"som steg med"|\<NUMEX)
!A {int i=0; 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"OBJ\" SBT=\"PRD\"");
!A 	i=i+16; for(;i<yyleng;putchar(yytext[i++]));}

! NOTE: Combined the preceding two rules into one

Define ChangeTag@
       [ [ RemoveStartTagOrg [ NoTags - [{Nasdaq} | NoTags {börsen}] ]
           RemoveEndTag ]
         RC(" " [{dök med} | {följde med nedåt} | {steg med} | {föll med} | {föll tillbaka} | {gick ned} | {gick upp} | {steg} | {klättrade med} | {klättrade} | {stigit} | {backade med} | {backade} | {backat} | {sjönk} | {tappade} | {handlades} | {fortsatte upp med} | {som gick upp} | {vände ned med}] " " [Num | {drygt} | {närmare} | {däremot} | {från} | {något} | {kraftigt} | {som väntat} | {som en} | {som steg med} | StartTagNumex])
	 EndTag(EnamexObjPrd) ] ;

!#  var med i Rwandas besegrade hutu-arme
!#  .... besegrades med| besegrade <> 
!#  if the exception works then ok to 

!R " i \<ENAMEX TYPE=\"LOC\" SBT=\"PPL\"\> besegrade"
!A {ECHO;}

! CHECK: Is the above rule correct, or should rather the word(s)
! preceding "besegrade" be enclosed in ENAMEX?

Define Except@ [ StartTagLocPpl NoTags EndTagEnamex { besegrade} ] ;

!# *ok** <LOC> +++ => ORG(ATH) 

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>" "(efter" "[0-9]\-[0-9]\-seger|vann" enkelt "i|vägrar" spela "i|en" ny frispark"|hamnar" i "seedningsgruppen|hade" ett stort "boll|förlustmatch|"första mål"|"vann mötet"|"höll nollan"|"första hemmaseger"|"dominerade första"|"gjorde "[^\n ]+" mål"|"tog en snabb ledning"|"som segrare med "[1-6]\-|segermål|EM\-motstånd|"till "[^\n ]*final|hemmabesegr|bortabesegra|besegrade|"vände "[0-9]\-[0-9]\-underläg|"vände ledning"|"föll med hela"|"har överraskat"|matcher|"vann efter förläng"|"hade förlorat match"|"vann överraskande mot"|"förlorade första semi"|"enkelt till semi"|"förlorade hemma"|"förlorade poäng"|"spelade bra"|"spelade "[0-9]\-|utklassade|utspelat|"vann hemma"|"var duktiga"|"visade mästar"|kvitterade|"inledde med"|"i serietopp"|kvittering|"missar slutspel"|"vann mittfält"|"tog ledningen"|"lätt vidare"|"föll i slutminut"|"vann bortamatch"|skrällde|"leder ligan"|"vann till slut"|"till elitserien"|"på bortaplan"|"hemma med [0-9]"|"på hemmaplan"|"vann den första match"|"vann första mötet"|"hade före matchen"|nobbar|avancerar|"i elitserien"|"i superetta"|"i semifinal"|"i söderetta"|"leder kvalserie"|"tog brons"|ödesmatch|VM\-back|sparkar" "förbundskapten|"leder med"|"leder nu match"|"leder nu med "[1-9]|"ledde med"|"hade en svår bortamatch"|planhalva|"ville spela"|"vinner kvartsfinal"|"vidare mot"|"klarade "[0-4]|P[1-9][0-9]|"vann med "[0-9]+\-|klar" "favorit|"vann match"|"vann övertygande"|"vann rugby"|"vann "[a-zåäö]*final|"vann sin hemmamatch"|"vann toppmötet"|"föll bort"|"ska spela en fot"|"spelade under"|"föll mot"|"spelade dåligt"|"spelade utan"|storspela|"spelade stor"|"spelade "[0-9]|"spelade ett öppet"|"var klart för semi"|"spelade effektiv"|vann" \<ENAMEX TYPE\=\"EVN")
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\""); i=i+16; for(;i<yyleng;putchar(yytext[i++]));}

Define ChangeTag@
       [ [ RemoveStartTagLoc NoTags RemoveEndTag ]
         RC(" " [{efter } Num "-" Num {-seger} | {vann enkelt i} | {vägrar spela i} | {en ny frispark} | {hamnar i seedningsgruppen} | {hade ett stort boll} | {förlustmatch} | {första mål} | {vann mötet} | {höll nollan} | {första hemmaseger} | {dominerade första} | {gjorde } Word { mål} | {tog en snabb ledning} | {som segrare med } ["1"|"2"|"3"|"4"|"5"|"6"] "-" | {segermål} | {EM-motstånd} | {till } NS* {final} | {hemmabesegr} | {bortabesegra} | {besegrade} | {vände } Num "-" Num {-underläg} | {vände ledning} | {föll med hela} | {har överraskat} | {matcher} | {vann efter förläng} | {hade förlorat match} | {vann överraskande mot} | {förlorade första semi} | {enkelt till semi} | {förlorade hemma} | {förlorade poäng} | {spelade bra} | {spelade } Num "-" | {utklassade} | {utspelat} | {vann hemma} | {var duktiga} | {visade mästar} | {kvitterade} | {inledde med} | {i serietopp} | {kvittering} | {missar slutspel} | {vann mittfält} | {tog ledningen} | {lätt vidare} | {föll i slutminut} | {vann bortamatch} | {skrällde} | {leder ligan} | {vann till slut} | {till elitserien} | {på bortaplan} | {hemma med } Num | {på hemmaplan} | {vann den första match} | {vann första mötet} | {hade före matchen} | {nobbar} | {avancerar} | {i elitserien} | {i superetta} | {i semifinal} | {i söderetta} | {leder kvalserie} | {tog brons} | {ödesmatch} | {VM-back} | {sparkar förbundskapten} | {leder med} | {leder nu match} | {leder nu med } Num19 | {ledde med} | {hade en svår bortamatch} | {planhalva} | {ville spela} | {vinner kvartsfinal} | {vidare mot} | {klarade } ["0"|"1"|"2"|"3"|"4"] | "P" Num19 Num | {vann med } Num+ "-" | {klar favorit} | {vann match} | {vann övertygande} | {vann rugby} | {vann } Lower* {final} | {vann sin hemmamatch} | {vann toppmötet} | {föll bort} | {ska spela en fot} | {spelade under} | {föll mot} | {spelade dåligt} | {spelade utan} | {storspela} | {spelade stor} | {spelade } Num | {spelade ett öppet} | {var klart för semi} | {spelade effektiv} | {vann } StartTagEvn])
	 EndTag(EnamexOrgAth) ] ;

!# *ok** <LOC> +++ => ORG(ATH) 

!R \<ENAMEX" "TYPE\=\"(PRS|LOC)\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>" "(\(" h "\)|\(" b "\)|b" "[0-9]|h" "[0-9])
!A { int i=0;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\"");
!A 	i=i+16; for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(LocOrPrs, OrgAth, `', `NoTags',
	`RC(" " [{( h )} | {( b )} | ["b"|"h"] " " Num])') ;

!# *ok** <LOC> +++ <LOC> => ORG(ATH) 

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"...\"\>[^\n \<\=]+\<\/ENAMEX\>" slog "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\">");
!A 	for(;yytext[i]!='>';i++); i++;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\">");
!A 	for(;yytext[i]!='>';i++); i++;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

Define ChangeTag@
       [ Define(
           _RemoveTags(Loc, `NSTag+')
           EndTag(EnamexOrgAth) )
	 { slog }
	 Define( _RemoveTags(Loc, `NSTag+')
           EndTag(EnamexOrgAth) ) ] ;

!# *ok** <LOC> +++ => ORG(PLT) 

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"...\"\>[^\n\<]+\<\/ENAMEX\>" "[^\n ]*(socialtjänst|tingsrätt|senat|[Pp]arlament|[Rr]egering|[Aa]mbassad|[^\n\< ]+ministerium|[^\n ]+departement|[^\n ]+departementet)" "
!A {int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"PLT\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

_DefineChangeMoveEndTagRight(Loc, OrgPlt,
	`',
	`NoTags',
	`" " NS* [{socialtjänst} | {tingsrätt} | {senat} | Pp {arlament} | Rr {egering} | Aa {mbassad} | NSTag+ {ministerium} | Word {departement} | Word {departementet}]
	 RC(" ")') ;

!# * +++ ORG => LOC(FNC) 
!#  often i news... th is <ORG>Sveriges XXX</> and afterwards <ORG>Sverges</> 

!R "VD på \<ENAMEX TYPE=\"ORG\" SBT=\"CRP\"\>Sveriges\<\/ENAMEX\> största"
!A {printf("VD på <ENAMEX TYPE=\"LOC\" SBT=\"PPL\">Sveriges</ENAMEX> största");}

_DefineChangeTag(OrgCrp, LocPpl,
	`LC({VD på })',
	`{Sveriges}',
	`RC({ största})') ;

!R "i \<ENAMEX TYPE=\"ORG\" SBT=\"CRP\"\>Sverige\<\/ENAMEX\>"
!A {printf("i <ENAMEX TYPE=\"LOC\" SBT=\"PPL\">Sverige</ENAMEX>");}

_DefineChangeTag(OrgCrp, LocPpl,
	`LC({ i })',
	`{Sverige}') ;

!# *ok** <PRS|WRK> fond  => ORG 

!R \<ENAMEX" "TYPE\=\"(WRK|PRS|LOC)\"" "SBT\=\"...\"\>[^\n\<\>]+\<\/ENAMEX\>" "[^\n ]*[Ff][Oo][Nn][Dd](en|er)?" "
!A {	int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"FIN\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> "); }

_DefineChangeMoveEndTagRight(WrkOrPrsOrLoc, OrgFin,
	`',
	`NoTags',
	`" " NS* Ff Oo Nn Dd ({en} | {er})
	 RC(" ")') ;

!# *ok** <ORG|WRK|PRS> +++ => <OBJ/PRZ} 

!R \<ENAMEX" "TYPE\=\"(ORG|WRK|PRS)\"" "SBT\=\"...\"\>[^\n\<\>]+\<\/ENAMEX\>" "[^\n ]*(ragdguld|Award|pris|utmärkelse|medaljen|tipendier|tipendium|Trophy)(et)?
!A { 	int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"OBJ\" SBT=\"PRZ\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng;putchar(yytext[i++]));
!A 	printf("</ENAMEX>");}

_DefineChangeMoveEndTagRight(OrgOrWrkOrPrs, ObjPrz,
	`',
	`NoTags',
	`" " NS* [{ragdguld} | {Award} | {pris} | {utmärkelse} | {medaljen} | {tipendier} | {tipendium} | {Trophy}] ({et})') ;

!# *ok** <OBJ> +++ => <ORG> 

!R \<ENAMEX" "TYPE\=\"OBJ\"" "SBT\=\"[A-Z][A-Z][A-Z]\"\>[^\n\<\>]+\<\/ENAMEX\>" "(meddela|hoppas|teckna|tillverka)
!A { 
!A 	int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(Obj, OrgCrp,
	`',
	`NoTags',
	`RC(" " [{meddela} | {hoppas} | {teckna} | {tillverka}])') ;

!# * <LOC|ORG> +++ => WRK 

!R \<ENAMEX" "TYPE\=\"(LOC|ORG|WRK)\"" "SBT\=[^\n\>]+\>[^\n\<\>]+\<\/ENAMEX\>" "[^\n ]*(direktiv|idskrift|rapport|Magazine|Journal|ubileumsbok|ressmeddelande|roschyr)(en)?" "
!A { int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

_DefineChangeMoveEndTagRight(LocOrOrgOrWrk, WrkWmd,
	`',
	`NoTags',
	`" " NS* [{direktiv} | {idskrift} | {rapport} | {Magazine} | {Journal} | {ubileumsbok} | {ressmeddelande} | {roschyr}] ({en})
	 RC(" ")') ;

!# * <LOC|ORG|WRK> +++ => <EVN> 

!R \<ENAMEX" "TYPE\=\"(LOC|ORG|WRK)\"" "SBT\=[^\n\> ]+\>[^\n\<\>]+\<\/ENAMEX\>" "[^\n ]*(årsmöte|iksstämma|toppmöte|festival|utställning|ubileum|ongress)(en|et)?" "
!A { int i=0;
!A 	for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"EVN\" SBT=\"CLU\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

_DefineChangeMoveEndTagRight(LocOrOrgOrWrk, EvnClu,
	`',
	`NoTags',
	`" " NS* [{årsmöte} | {iksstämma} | {toppmöte} | {festival} | {utställning} | {ubileum} | {ongress}] ({en} | {et})
	 RC(" ")') ;

!# * +++ <LOC|ORG(ATH)> => <ORG(ATH)> 

!R ([0-9]\-[0-9]|final|förlorat|[Ff]örlust|kvittering|semi|mötet|förlusterna|förlängning|kvart|lottas|match|mål|period|revansch|seger|segern|serien|insats|tränare)(en)?" "(för|mot|över)" "\<ENAMEX" "TYPE\=\"LOC\/ORG\"" "SBT\=\"...\/ATH\"\>[^\n\<]+\<\/ENAMEX\>
!A { int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocOrgAth, OrgAth,
	`LC([Num "-" Num | {final} | {förlorat} | Ff {örlust} | {kvittering} | {semi} | {mötet} | {förlusterna} | {förlängning} | {kvart} | {lottas} | {match} | {mål} | {period} | {revansch} | {seger} | {segern} | {serien} | {insats} | {tränare}] ({en}) " " [{för} | {mot} | {över}] " ")') ;

!# * +++ <LOC/ORG(ATH)> => <ORG(ATH)> 

!R (mötet" "med|tippade|"ötena med"|möta|möter|ledde|lorar|spöa|sitt|starka|späckade|favorit|avoriterna|räddade|lorade|starkt|lämnade|klubb|talienska|vann|rivalen|försvarande|laget|"övergång från"|"förvärvet från"|"fältare från"|"sparken från"|"spelarna från"|hans|"säsong med"|"spelade mot"|"spelade för"|"vitterat för"|"imman spelade"|"mål för"|"spelar för"|"vittering för"|avgjorde|"stryk av"|"guld med"|"guldet till"|"match för"|"örlust för"|krislaget|skadefyllt|effektivt|"spela för"|"raka för"|"målet när"|"matcher mot just"|"kampen mot"|"säsong med"|"tränar med"|besegrade|besegra|"tlånad av"|"mål av"|knäckte)" "\<ENAMEX" "TYPE\=\"LOC\/(LOC|ORG)\"" "SBT\=\"[A-Z][A-Z][A-Z]\/(PPL|ATH)\"\>[^\n\<]+\<\/ENAMEX\>
!A {	int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocPplOrgAth, OrgAth,
	`LC([{mötet med} | {tippade} | {ötena med} | {möta} | {möter} | {ledde} | {lorar} | {spöa} | {sitt} | {starka} | {späckade} | {favorit} | {avoriterna} | {räddade} | {lorade} | {starkt} | {lämnade} | {klubb} | {talienska} | {vann} | {rivalen} | {försvarande} | {laget} | {övergång från} | {förvärvet från} | {fältare från} | {sparken från} | {spelarna från} | {hans} | {säsong med} | {spelade mot} | {spelade för} | {vitterat för} | {imman spelade} | {mål för} | {spelar för} | {vittering för} | {avgjorde} | {stryk av} | {guld med} | {guldet till} | {match för} | {örlust för} | {krislaget} | {skadefyllt} | {effektivt} | {spela för} | {raka för} | {målet när} | {matcher mot just} | {kampen mot} | {tränar med} | {besegrade} | {besegra} | {tlånad av} | {mål av} | {knäckte}] " ")') ;

!R (möte" "i|området)" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"PPL\">");}

_DefineChangeTag(PrsHum, LocPpl,
	`LC([{möte i} | {området}] " ")',
	`NoTags') ;

!# *ok** +++ <LOC> => +++ <ATH> 

! NOTE: Reorganized these rules: The context words in the exception
! rule have been removed from the main rule, and the exception rule
! uses regular language difference.

!R (stärker|rädda|konkurrenten|jämt|slog)" "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"[A-Z][A-Z][A-Z]\"\>EU[^\n ]+\<\/ENAMEX\>
!A {ECHO;}

!R [^\n\<\>\= ]*("assists för"|"atch mellan"|"atchen mellan"|"efter segrande"|"fick straff"|tränare" "för|"finalen vann"|"förvärvet från"|"i cupen mot"|"gör comeback i"|"ha besegrat"|"halvlek gjorde"|"emmamöte med"|"lag som"|"laget besegra"|"lyckades besegra"|"match för"|"med "[0-9\-]+" över"|"mot hemmanationen"|"mål för sitt"|"nkel seger för"|"ockey mellan"|"seger över"|"segern över"|"slog ut"|"spela för"|"spelade inte för"|"spelar i"|"spelade ut"|"spel i grekiska"|"tminuten lyckades"|"tog stryk av"|"torseger för"|"tränar med"|"tränare i"|"tvis seger för"|"utlånad till"|"utspelade av"|"vann de över"|"vinna hemma över"|[^\n\<\>\t ]*finalen" "mellan|[1-4]\-[0-4]" för"|[1-7]\-[0-4]" "till|[Ss]"å spelar"|allsvenska|besegrade|ebuterade|ligamötet" "med|erieledande|formsvaga|grupptvåan|gänget|hemmabesegra|I\-kollegan|I\-laget|Jumbon|jämt|klubb|klubben|kvitterade|mabesegrat|mosade|Mot|motståndare|"långboll av"|onkurrenten|otboll" "mellan|rädda|skytt" "för|slog|slå|starka|stärker|svårspelade|Team|tekniskt|utvilat|vann" "över|ykomlingarna|örbundskapten" "för)" "\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"[GP]PL\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\""); i=i+16; for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(LocXpl, OrgAth,
	`LC(NSTag* [{assists för} | {atch mellan} | {atchen mellan} | {efter segrande} | {fick straff} | {tränare för} | {finalen vann} | {förvärvet från} | {i cupen mot} | {gör comeback i} | {ha besegrat} | {halvlek gjorde} | {emmamöte med} | {lag som} | {laget besegra} | {lyckades besegra} | {match för} | {med } [Num|"-"]+ { över} | {mot hemmanationen} | {mål för sitt} | {nkel seger för} | {ockey mellan} | {seger över} | {segern över} | {slog ut} | {spela för} | {spelade inte för} | {spelar i} | {spelade ut} | {spel i grekiska} | {tminuten lyckades} | {tog stryk av} | {torseger för} | {tränar med} | {tränare i} | {tvis seger för} | {utlånad till} | {utspelade av} | {vann de över} | {vinna hemma över} | NSTag* {finalen mellan} | ["1"|"2"|"3"|"4"] "-" ["0"|"1"|"2"|"3"|"4"] { för} | ["1"|"2"|"3"|"4"|"5"|"6"|"7"] "-" ["0"|"1"|"2"|"3"|"4"] { till} | Ss {å spelar} | {allsvenska} | {besegrade} | {ebuterade} | {ligamötet med} | {erieledande} | {formsvaga} | {grupptvåan} | {gänget} | {hemmabesegra} | {I-kollegan} | {I-laget} | {Jumbon} | {klubb} | {klubben} | {kvitterade} | {mabesegrat} | {mosade} | {Mot} | {motståndare} | {långboll av} | {onkurrenten} | {otboll mellan} | {skytt för} | {slå} | {starka} | {svårspelade} | {Team} | {tekniskt} | {utvilat} | {vann över} | {ykomlingarna} | {örbundskapten för}] " ")',
	`NoTags') ;

_DefineChangeTag(Loc, OrgAth,
	`LC([{stärker} | {rädda} | {konkurrenten} | {jämt} | {slog}] " ")',
	`NoTags - [{EU} Word]') ;

!# *ok** +++ mot <LOC> => +++ mot <ATH> 

!R [^\n\<\>\= ]*([0-4]\-[0-4]" "|mål|assist|bortaplan|poäng|spela|vinner|vittering|örlust|örlusten|öppningen|förlorade|inalserien|final|final" \- "|[Ff]inalen|[Ss]egern|seger|minuten|straffar|mjukstart|landskamp|[Hh]emma|match[a-zåäö]*|mötet|landskamper|halvlek|målet|förlorar|straffmissen|straffläggningen|nederlag|omeback|ältare|spelade)" mot "([^\n ]+ska" "|[^\n ]+äna" ")?\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"[GP]PL\"\>[^\n\<]+\<\/ENAMEX\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\""); i=i+16; for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(LocXpl, OrgAth,
	`LC(NSTag* [["0"|"1"|"2"|"3"|"4"] "-" ["0"|"1"|"2"|"3"|"4"] " " | {mål} | {assist} | {bortaplan} | {poäng} | {spela} | {vinner} | {vittering} | {örlust} | {örlusten} | {öppningen} | {förlorade} | {inalserien} | {final} | {final - } | Ff {inalen} | Ss {egern} | {seger} | {minuten} | {straffar} | {mjukstart} | {landskamp} | Hh {emma} | {match} Lower* | {mötet} | {landskamper} | {halvlek} | {målet} | {förlorar} | {straffmissen} | {straffläggningen} | {nederlag} | {omeback} | {ältare} | {spelade}] { mot } (Word [{ska} | {äna}] " "))',
	 `NoTags') ;

!R ATH\"\>[^\n\<]+\<\/ENAMEX\>" "("får möta"|mot)" "([^\n\= ]+ska" ")?\<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"[^\n ]+\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\""); i=i+16; for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(Loc, OrgAth,
	`LC(StartTagOrgAth NoTags EndTagEnamex " " [{får möta} | {mot}] " "
	    (NSTag+ {ska }))',
	`NoTags') ;

!# *ok** +++ <XXX/XXX> => <ATH> 

!R ([0-4]\-[0-4]" "|mål|assist|bortaplan|poäng|spela|vinna|senast|vinner|kvittering|Förlust|örlusten|öppningen|förlorade|inalserien|final|final" \- "|inalen|segern|seger|minuten|straffar|mjukstart|landskamp|hemma|[Mm]atchen|match|matcher|venskmötet|landskamper|halvlek)" mot "\<ENAMEX" "TYPE\=\"[A-Z]+\/[A-Z]+\"" "SBT\=\"[A-Z]+\/[A-Z]+\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"ATH\"");
!A 	i=i+23; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(Any2, OrgAth,
	`LC([["0"|"1"|"2"|"3"|"4"] "-" ["0"|"1"|"2"|"3"|"4"] " " | {mål} | {assist} | {bortaplan} | {poäng} | {spela} | {vinna} | {senast} | {vinner} | {kvittering} | {Förlust} | {örlusten} | {öppningen} | {förlorade} | {inalserien} | {final} | {final - } | {inalen} | {segern} | {seger} | {minuten} | {straffar} | {mjukstart} | {landskamp} | {hemma} | Mm {atchen} | {match} | {matcher} | {venskmötet} | {landskamper} | {halvlek}] { mot })') ;

!# *ok** <PPL> +++ => <GPL> 

!R \<ENAMEX" "TYPE\=\"LOC\"" "SBT\=\"PPL\"\>[A-ZÅÄÖ][^\n\<]+\<\/ENAMEX\>" "[^\n\t\<\> ]*(kärgård|kust|ustlinje|[^m\n\t\<\> ]sida|bottnar|sjö)" "
!A { int i=0;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"GPL\">"); i=i+17; 
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+9; for(;i<yyleng-1;putchar(yytext[i++]));
!A 	printf("</ENAMEX> ");}

_DefineChangeMoveEndTagRight(LocPpl, LocGpl,
	`',
	`Upper NoTags',
	`" " NSTag* [{kärgård} | {kust} | {ustlinje} | [NSTag - ["m"]] {sida} | {bottnar} | {sjö}]',
	`RC(" ")') ;

!# *ok** +++ <PRS> => <LOC> 

!R (Stadio|Sankt|Santa|San|Saint|S\:t|St\.|St|South|St" \."|Ch[aâ]teau|[Nn]orra)" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n \<]+\<\/ENAMEX\>
!A {int i=0; 
!A 	printf("<ENAMEX TYPE=\"LOC\" SBT=\"FNC\">");
!A 	for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+29; for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeMoveStartTagLeft(PrsHum, LocFnc,
	`[{Stadio} | {Sankt} | {Santa} | {San} | {Saint} | {S:t} | {St} ((" ") ".") | {South} | {Ch} ["a"|"â"] {teau} | Nn {orra}] " "',
	`NSTag+') ;

!# *ok** +++ i <PRS> => <LOC> 

!R (flicka|åldtäkten|garage|gplats|varteren|medlem|basist|spelas|arnevalen|kolorna|hallen|studio|banan|ungdomar|ongressen|tävling|minister|tationen|cupen|ästerskapen|vistelse|villorna|ävlingar|trummis|lalom|professor|lärare|kolleger|kollegan|orskare|familj|här)" i "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[A-Z]+
!A {int i=0;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"PPL\">"); i=i+17;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(PrsHum, LocPpl,
	`LC([{flicka} | {åldtäkten} | {garage} | {gplats} | {varteren} | {medlem} | {basist} | {spelas} | {arnevalen} | {kolorna} | {hallen} | {studio} | {banan} | {ungdomar} | {ongressen} | {tävling} | {minister} | {tationen} | {cupen} | {ästerskapen} | {vistelse} | {villorna} | {ävlingar} | {trummis} | {lalom} | {professor} | {lärare} | {kolleger} | {kollegan} | {orskare} | {familj} | {här}] { i })',
	`Upper (NoTags)'
) ;

!# *ok** +++ <PRS> => <LOC> 
!#  needs completion <>San</> Xxx OR <>San</> <PRS> 

!R ([Vv]id|[Ii]|[Ff]rån|på|mot|[^\n\= ]+ska|ligger|kyrkan|[Ii]" "[^\n\<\= ]+ska)" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>(Santa|San|Saint|S\:t|S\.t)(" "|\<)
!A {int i=0;
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"LOC\" SBT=\"PPL\">"); i=i+17;
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(PrsHum, LocPpl,
	`LC([Vv {id} | Ii | Ff {rån} | {på} | {mot} | [? - ["\n"|"="|" "]]+ {ska} | {ligger} | {kyrkan} | Ii " " NSTag+ {ska}] " ")',
	`[{Santa} | {San} | {Saint} | {S:t} | {S.t}] (" " NoTags)') ;

!# ****************************************
!#  This is a tag-DISAMBIGUATION part - Activated after the list-lookup part   
!# **  *talets LOC/ORG => LOC
!# 	 ***  <LOC> eller|till|och LOC/PRS	=> LOC
!# 	 ***  ^LOC/PRS => LOC
!# 	 ***  <ORG> HUM/LOC => LOC
!# 	 *** ()*(match|final)(en) mot <PPL>
!# 	 *** matchen mellan <PPL> and X .
!# 	******************************************
!# *ok** <ORG> och <ORG/PRS> => <ORG> och <ORG> 

!R \<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"...\"\>[^\n\<\=]+\<\/ENAMEX\>" "(eller|och|\,)" "\<ENAMEX" "TYPE\=\"ORG\/PRS\"" "SBT\=\"...\/...\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"CRP\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(OrgPrs, OrgCrp,
	`LC(StartTagOrgCrp NoTags EndTagEnamex " " [{eller} | {och} | ","]
	    " ")') ;

!# *ok** <PRS> och <LOC/PRS> => PRS 

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\=]+\<\/ENAMEX\>" "(eller|och)" "\<ENAMEX" "TYPE\=\"LOC\/PRS\"" "SBT\=\"...\/...\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"PRS\" SBT=\"HUM\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocPrs, PrsHum,
	`LC(StartTagPrsHum NoTags EndTagEnamex " " [{eller} | {och}] " ")') ;

!# *ok** +++ i <ORG/PRS> => +++ i <ORG> 

!R (kning|nehav|vd|värde|haven|sparande|yrelse|garna|tämma|äsonger|rätt|lytande|dförande|äga|uppgång)[a-z]*" i "\<ENAMEX" "TYPE\=\"ORG\/PRS\"" "SBT\=\"...\/HUM\"\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"CRP\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

! NOTE: The rule spans up to the end tag.

_DefineDisambiguateTagSimple(OrgPrsHum, OrgCrp,
	`LC([{kning} | {nehav} | {vd} | {värde} | {haven} | {sparande} | {yrelse} | {garna} | {tämma} | {äsonger} | {rätt} | {lytande} | {dförande} | {äga} | {uppgång}] Lower* { i })') ;

!# *ok** +++ <ORG/PRS> => +++ <ORG> 

!R ("mineras av"|"värde för"|"värdet för"|makten|"vhoppare från"|"retag som"|"nät från"|"marbetet med"|"samarbete med"|raketen|lländska|[Pp]å|kurrenten|orska|steg|oterades|[Vv]id|rganet|"nställd av"|"smeddelande från"|inom|"insten för"|meddelade|"verantörer till"|köpa|franska|spanska|svenska|förse|amerikanska|"ägs av"|"såldes till"|"apport från"|"order till"|dextungviktaren|dextunga|dexstarka)" "\<ENAMEX" "TYPE\=\"ORG\/PRS\"" "SBT\=\"...\/HUM\"\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"ORG\" SBT=\"CRP\"");
!A 	i=i+24; for(;i<yyleng;putchar(yytext[i++]));}

! NOTE: The rule spans up to the end tag.

_DefineDisambiguateTagSimple(OrgPrsHum, OrgCrp,
	`LC([{mineras av} | {värde för} | {värdet för} | {makten} | {vhoppare från} | {retag som} | {nät från} | {marbetet med} | {samarbete med} | {raketen} | {lländska} | Pp "å" | {kurrenten} | {orska} | {steg} | {oterades} | Vv {id} | {rganet} | {nställd av} | {smeddelande från} | {inom} | {insten för} | {meddelade} | {verantörer till} | {köpa} | {franska} | {spanska} | {svenska} | {förse} | {amerikanska} | {ägs av} | {såldes till} | {apport från} | {order till} | {dextungviktaren} | {dextunga} | {dexstarka}] " ")') ;

!#  <ORG&PRS> PRS   => PRS 
!#  <ORG&PRS> +++ => ORG 
!#  <ORG&PRS> och|, ORG 

!R \<ENAMEX" "TYPE\=\"ORG\/PRS\"" "SBT\=\"...\/HUM\"\>[^\n\<]+\<\/ENAMEX\>" "("i ett press"|redovisar|varslar|bygger|och" \<ENAMEX TYPE\=\"ORG"|"\, <ENAMEX TYPE\=\"ORG")
!A {int i=0; 
!A 	for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(OrgPrsHum, OrgCrp,
	`',
	`RC(" " [{i ett press} | {redovisar} | {varslar} | {bygger}
	         | [{och} | ","] " " StartTagOrg])') ;

!#  <ORG&PRS> +++ => OBJ 
!#  the A and B shold be inside 

!R \<ENAMEX" "TYPE\=\"ORG\/PRS\"" "SBT\=\"...\/...\"\>[^\n\<]+\<\/ENAMEX\>" "("A "|"B steg"|"B vände"|"B backa"|"B notera"|"B sjönk"|"B stängde"|"B "[0-9]\:|föll" "[0-9]|föll" "med|slutade" "på" "[0-9]|"steg med"|"B föll"|"sjönk med")
!A {int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"OBJ\" SBT=\"PRD\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(OrgPrs, ObjPrd,
	`',
	`RC(" " [{A } | {B } [{steg} | {vände} | {backa} | {notera} | {sjönk} | {stängde} | Num ":" | {föll}] | {föll } Num | {föll med} | {slutade på } Num | {steg med} | {sjönk med}])') ;

!# *ok** <LOC/ORG> +++ => ORG(ATH) 

!R \<ENAMEX" "TYPE\=\"LOC\/ORG\"" "SBT\=\"...\/...\"\>[^\n\<]+\<\/ENAMEX\>" "(guldhopp|"börjar hemma"|"i kvarts"|"med "[^ ]" poäng"|lottades|"föll med hela"|"förlorade poäng"|"spelade "[0-9]\-[0-9]|utklassade|utspelat|"vann hemma"|"vinner kvarts"|kvitterade|"inledde med"|"i serietopp"|"vann mittfält"|"tog ledningen"|"en straff"|"till semifinal"|"vann bortamatch"|skrällde|"leder ligan"|"vann till slut"|"på hemmaplan"|"vann första mötet"|FF|FF\:s|"hade före matchen"|[^\n ]*landslag|nobbar|MSK|avancerar|"leder med"|"ville spela"|"vidare mot"|klättrat|vunnit|storspela|"klarade "[0-4]|P[1-9][0-9]|"klart för semifi"|besegrade|imponerade|"vann med"|klar" "favorit|"vann toppmötet"|storvann|"vann rättvis"|"föll bort"|"spelade under"|"föll mot"|"spelade utan"|starkast|"spelade stor"|"spelade "[0-9]|"spelade ett öppet"|"spelade effektiv"|[0-9]\-[0-9])
!A { int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(LocOrg, OrgAth,
	`',
	`RC(" " [{guldhopp} | {börjar hemma} | {i kvarts} | {med } NS { poäng} | {lottades} | {föll med hela} | {förlorade poäng} | {spelade } Num "-" Num | {utklassade} | {utspelat} | {vann hemma} | {vinner kvarts} | {kvitterade} | {inledde med} | {i serietopp} | {vann mittfält} | {tog ledningen} | {en straff} | {till semifinal} | {vann bortamatch} | {skrällde} | {leder ligan} | {vann till slut} | {på hemmaplan} | {vann första mötet} | {FF} | {FF:s} | {hade före matchen} | NS* {landslag} | {nobbar} | {MSK} | {avancerar} | {leder med} | {ville spela} | {vidare mot} | {klättrat} | {vunnit} | {storspela} | {klarade } ["0"|"1"|"2"|"3"|"4"] | "P" Num19 Num | {klart för semifi} | {besegrade} | {imponerade} | {vann med} | {klar favorit} | {vann toppmötet} | {storvann} | {vann rättvis} | {föll bort} | {spelade under} | {föll mot} | {spelade utan} | {starkast} | {spelade stor} | {spelade } Num | {spelade ett öppet} | {spelade effektiv} | Num "-" Num])') ;

!# *ok** <.../PRS> <PRS> => <PRS> <PRS> 

!R \<ENAMEX" "TYPE\=\"...\/PRS\"" "SBT\=\"...\/HUM\"\>[^\n\<]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

! NOTE: It suffices to have the start tag in the right context, since
! Pmatch does not count the context to the leftmost longest match.

_DefineDisambiguateTagSimple(PrsHum, PrsHum,
	`',
	`RC(" " StartTagPrsHum)') ;

!# *ok** <.../PRS> +++ => <PRS> +++ 

!R \<ENAMEX" "TYPE\=\"...\/PRS\"" "SBT\=\"...\/HUM\"\>[^\n\<]+\<\/ENAMEX\>" "(ansåg|minns)
!A {
!A 	int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(PrsHum, PrsHum,
	`',
	`RC(" " [{ansåg} | {minns}])') ;

!# * <ATH> +++ <LOC/ORG> ==> <ATH> +++ <ATH> 

!R SBT\=\"ATH\"\>[^\n\<]+\<\/ENAMEX\>" "(\,|och|mot|möter|mötte)" "\<ENAMEX" "TYPE\=\"LOC\/ORG\"" "SBT\=\"...\/...\"\>
!A {int i=0; 	for(;yytext[i]!='<';putchar(yytext[i++])); putchar('<'); 
!A 	i++;for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");}

_DefineDisambiguateTagSimple(LocOrg, OrgAth,
	`LC(StartTagOrgAth NoTags EndTagEnamex " " ["," | {och} | {mot} | {möter} | {mötte}] " ")') ;

!# *ok** <LOC/ORG(ATH) och <ORG(ATH)> ==> <ATH> och <ATH>

!R \<ENAMEX" "TYPE\=\"...\/ORG\"" "SBT\=\"...\/ATH\"\>[^\n\<]+\<\/ENAMEX\>" och "\<ENAMEX" "TYPE\=\"ORG\"" "SBT\=\"ATH\"\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=0; for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineDisambiguateTagSimple(OrgAth, OrgAth,
	`',
	`RC({ och } StartTagOrgAth)') ;

!# * ORG , (LOC|ORG)/(ORG|PRS) , ORG => ORG , ORG , ORG 
!# *****************************************************************************************
!#  JOIN 
!#  low+|, HUM HUM HUM low+|,  => low+ HUM+HUM+HUM low 
!#  low+|, HUM HUM low+|,|.    => low+ HUM+HUM low+|.  
!#  ^HUM HUM                   => HUM+HUM              

m4_divert(-1)
m4_define(`_DefineCombineNamesHum (preceding, following, [count])')
m4_define(`_DefineCombineNamesHum',
	  `_DefineCombineNames(`PrsHum', `$1', `NoTags', `" "', `NoTags', `$2',
			       `$3')')
m4_divert(0)

!R [a-zåäö\.\,\(\:\)\-\>0-9\[\*]" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "[a-zåäö\,\.\)\(\-\:\<0-9\]\|\;]
!A {int i=2;  putchar(yytext[0]);putchar(yytext[1]); for(;yytext[i]!='>';putchar(yytext[i++])); 
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); putchar(' '); 
!A 	i=i+39; for(;yytext[i]!='<';putchar(yytext[i++])); putchar(' '); 
!A                                         i=i+39; for(;i<yyleng;putchar(yytext[i++])); }

_DefineCombineNamesHum(
	`LC([LowercaseAlpha|Num|AnyTag|"."|","|"("|")"|":"|"-"|">"|"["|"*"] " ")',
	`RC(" " [LowercaseAlpha|Num|AnyTag|","|"."|")"|"("|"-"|":"|"<"|"]"|"|"|";"])',
	`2') ;

!R [a-zåäö\.\,\(\:\)\-\>0-9\[\*\;]" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>[\t ]*\n
!A {int i=2;  putchar(yytext[0]);putchar(yytext[1]); for(;yytext[i]!='>';putchar(yytext[i++])); 
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); putchar(' '); 
!A 	i=i+39; for(;yytext[i]!='<';putchar(yytext[i++])); putchar(' '); 
!A                                         i=i+39; for(;i<yyleng;putchar(yytext[i++])); }

_DefineCombineNamesHum(
	`LC([LowercaseAlpha|Num|AnyTag|"."|","|"("|":"|")"|"-"|">"|"["|"*"|";"] " ")',
	`',
	`2') ;

!# *ok** + <PRS> <PRS> + => + <PRS> + 

!R [a-zåäöA-Z\.\,\(\:\)\-\>\!\?\*\;\"\»\«\}\©]" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "[a-zåäö\&\,\.\)\(\-\:\<0-9\|\!\;\»\«\?\{]
!A {int i=2;  
!A 	putchar(yytext[0]);putchar(yytext[1]); for(;yytext[i]!='>';putchar(yytext[i++])); 
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); putchar(' '); 
!A 	i=i+39; for(;i<yyleng;putchar(yytext[i++])); }

_DefineCombineNamesHum(
	`LC([Alpha|AnyTag|"."|","|"("|":"|")"|"-"|">"|"!"|"?"|"*"|";"|"\""|"»"|"«"|"}"|"©"] " ")',
	`RC(" " [LowercaseAlpha|Num|AnyTag|"&"|","|"."|")"|"("|"-"|":"|"<"|"|"|"!"|";"|"»"|"«"|"?"|"{"])') ;

!R ^\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "[a-zåäö\,\.\)\(\-\:\<0-9\|\!\;\»\«\?]
!A {int i=0;  
!A 	for(;yytext[i]!='>';putchar(yytext[i++])); 
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); putchar(' '); 
!A 	i=i+39; for(;i<yyleng;putchar(yytext[i++])); }

_DefineCombineNamesHum(
	`LC(#)',
	`RC(" " [LowercaseAlpha|Num|AnyTag|","|"."|")"|"("|"-"|":"|"<"|"|"|"!"|";"|"»"|"«"|"?"])') ;

!R [a-zåäöA-Z\.\,\(\:\)\-\>\!\?\;\©]" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>[\t ]*\n
!A {int i=2;  
!A 	putchar(yytext[0]);putchar(yytext[1]); for(;yytext[i]!='>';putchar(yytext[i++])); 
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); putchar(' '); 
!A 	i=i+39; for(;i<yyleng;putchar(yytext[i++])); }

_DefineCombineNamesHum(
	`LC([Alpha|AnyTag|"."|","|"("|":"|")"|"-"|">"|"!"|"?"|";"|"©"] " ")',
	`RC(Whitespace* #)') ;

!R ^[\t ]*\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>
!A {int i=0; 
!A 	for(;yytext[i]!='>';putchar(yytext[i++])); for(;yytext[i]!='<';putchar(yytext[i++])); 
!A 	putchar(' '); i=i+39; for(;i<yyleng;putchar(yytext[i++]));}

_DefineCombineNamesHum(`LC(# Whitespace*)') ;

!R ^[A-Z]" "[A-Z]" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>
!A {int i=3; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
!A 	putchar(yytext[0]);printf(" ");putchar(yytext[2]); printf(" ");
!A 	for(;yytext[i++]!='>';); for(;i<yyleng;putchar(yytext[i++]));}

_DefineMoveStartTagLeft(PrsHum,
	`LC(#)
	 UppercaseAlpha " " UppercaseAlpha " "',
	`NoTags') ;

! NOTE: The following three rules could probably be combined into one.

!R ([A-Z]\.)+[A-Z]\." "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>
!A {int i=0; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); for(;yytext[i]!='<';putchar(yytext[i++])); }

_DefineMoveStartTagLeft(PrsHum,
	`[UppercaseAlpha "."]^>1 " "',
	`NoTags') ;

!R ([A-Z]\." ")+[A-Z]\." "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>
!A {int i=0; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); for(;yytext[i]!='<';putchar(yytext[i++])); }

_DefineMoveStartTagLeft(PrsHum,
	`[UppercaseAlpha {. }]^>1',
	`NoTags') ;

!R ([A-Z]" \. ")+[A-Z]" \. "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>
!A {int i=0; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); for(;yytext[i]!='<';putchar(yytext[i++])); }

_DefineMoveStartTagLeft(PrsHum,
	`[UppercaseAlpha { . }]^>1',
	`NoTags') ;

! CHECK: Does the following Flex rule also remove the second ENAMEX
! start tag, as it probably should? The Pmatch rule removes it.

!R \<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>[^\n\<\>]+\<\/ENAMEX\>" \. "[A-Z]" \. "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>
!A {int i=0;
!A 	for(;yytext[i]!='>';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); for(;yytext[i]!='<';putchar(yytext[i++]));
!A 	i=i+9; for(;yytext[i]!='<';putchar(yytext[i++]));}

_DefineCombineNames(`PrsHum', `', `NoTags', `{ . } UppercaseAlpha { . }',
		    `NoTags') ;

!# PPL">Alexandria</ENAMEX> , Antiokia och <ENAMEX TYPE="LOC" SBT="PPL">Jerusalem

!R PPL\"\>[^\< ]+\<\/ENAMEX\>" \, "[A-Z][^\n \<]+" och \<ENAMEX TYPE\=\"LOC"
!A {int i=0;
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+12; printf("</ENAMEX> , <ENAMEX TYPE=\"LOC\" SBT=\"PPL\">");
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");  for(;i<yyleng;putchar(yytext[i++]));}

!R PPL\"\>[^\< ]+\<\/ENAMEX\>" \, "[A-Z][^\n \<]+" \, \<ENAMEX TYPE\=\"LOC"
!A {int i=0;
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+12; printf("</ENAMEX> , <ENAMEX TYPE=\"LOC\" SBT=\"PPL\">");
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");  for(;i<yyleng;putchar(yytext[i++]));}

! NOTE: Combined the preceding two rules into one

m4_divert(-1)
m4_define(`_DefineAddTagsMiddleWord',
	  `Define AddTags@
       [ LC(_Tagged(`$1', `NoTags') { , })
	 [ UppercaseAlpha NSTag+ ]
         RC(" " [{och} | ","] " " StartTag$1)
         _EndTagFull($1) ]')
m4_divert(0)

_DefineAddTagsMiddleWord(LocPpl) ;

!R HUM\"\>[^\< ]+\<\/ENAMEX\>" \, "[A-Z][^\n \<]+" och \<ENAMEX TYPE\=\"PRS"
!A {int i=0;
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+12; printf("</ENAMEX> , <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");  for(;i<yyleng;putchar(yytext[i++]));}

!R HUM\"\>[^\< ]+\<\/ENAMEX\>" \, "[A-Z][^\n \<]+" \, \<ENAMEX TYPE\=\"PRS"
!A {int i=0;
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+12; printf("</ENAMEX> , <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
!A 	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");  for(;i<yyleng;putchar(yytext[i++]));}

! NOTE: Combined the preceding two rules into one

_DefineAddTagsMiddleWord(PrsHum) ;

!# *****************************************************************************************
!#  TERMINOLOGY 
!# ===================================>

!R \<\<ENAMEX" "TYPE\=\"[A-Z][A-Z][A-Z]\"" "SBT\=\"[A-Z][A-Z][A-Z]\"\>ENAMEX" "TYPE\=\"[^\n\" ]+\"" "SBT\=\"[^\n\" ]+\"\>[^\n\<]+\<\/ENAMEX\>[^\n\<]+\<\/ENAMEX\>
!A {
!A 	int i=1; for(;i<30;putchar(yytext[i++])); i=i+28;for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;
!A 	for(;i<yyleng;putchar(yytext[i++])); }

! TODO: Is this really needed?

Define FixTag@
       [ _Remove("<") StartTagEnamex
         _Remove(Enamex TagNamePart TagNamePart ">")
         NoTags RemoveEndTag NoTags EndTagEnamex ] ;

!# *ok** <MDC> ( <PRS|LOC> ) => MDC ( MDC ) 

!R \"OBJ\"" "SBT\=\"MDC\"\>[^\n\<\(]+\<\/ENAMEX\>" \( "\<ENAMEX" "TYPE\=\"[PL][A-Z\/]+\"" "SBT\=\"[A-Z\/]+\"\>[^\n\<\(]+\<\/ENAMEX\>" \)"
!A {int i=0;
!A 	for(;yytext[i]!='(';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); 
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	i=i+17; printf("=\"OBJ\" SBT=\"MDC\">");
!A 	for(;i<yyleng;putchar(yytext[i++])); }

_DefineChangeTag(LocOrPrs, ObjMdc,
       `LC(_Tagged(ObjMdc, `[NoTag - "("]+') { ( })',
       `[NoTag - "("]+',
       `RC({ )})') ;

!# *ok** <MDC> , <PRS> , => <MDC> , <MDC> 

!R \"OBJ\"" "SBT\=\"MDC\"\>[^\n\<\,\=\t]+\<\/ENAMEX\>" \, "\<ENAMEX" "TYPE\=\"[PL][A-Z\/]+\"" "SBT\=\"[A-Z\/\=]+\"\>[^\n\<\,]+\<\/ENAMEX\>" \,"
!A {int i=0;
!A 	for(;yytext[i]!=',';putchar(yytext[i++]));
!A 	putchar(yytext[i++]); 
!A 	for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	i=i+17; printf("=\"OBJ\" SBT=\"MDC\">");
!A 	for(;i<yyleng;putchar(yytext[i++]));}

_DefineChangeTag(LocOrPrs, ObjMdc,
       `LC(_Tagged(ObjMdc, `[NoTag - ","]+') { , })',
       `[NoTag - ","]+',
       `RC({ ,})') ;

!# * +++ <OBJ/...> => +++ <OBJ> 

!R medel" "\<ENAMEX" "TYPE\=\"OBJ\/PRS\"" "SBT\=\"...\/MDC\"\>
!A {int i=0; for(;yytext[i]!='=';putchar(yytext[i++]));
!A 	printf("=\"OBJ\" SBT=\"MDC\">"); i=i+17;
!A 	for(;i<yyleng;putchar(yytext[i++])); }

! CHECK: Are the attributes really "OBJ/PRS"+".../MDC" and not +"MDC/..."?

_DefineDisambiguateTagSimple(ObjMdcPrs, ObjMdc,
       `LC({medel })') ;

!#  +årig <PRS> 

!R [^\n<> ]+årig" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"\>
!A {int i=0; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); for(;yytext[i]!='<';putchar(yytext[i++])); }

! NOTE: For performance reasons, the following three rules match up to
! an end tag, unlike the original. Could it affect the result?
! However, most if not all rules need to match a start tag anyway, so
! maybe it is not a problem.

_DefineMoveStartTagLeft(PrsHum,
	`NSTag+ {årig }',
	`NoTags') ;

!R [^\n<> ]+årig" "\<ENAMEX" "TYPE\=\"PRS\"" "SBT\=\"HUM\"" "ANI=\"UNU\"\>
!A {int i=0; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\" ANI=\"UNU\">"); for(;yytext[i]!='<';putchar(yytext[i++])); }

_DefineMoveStartTagLeft(PrsHumUnu,
	`NSTag+ {årig }',
	`NoTags') ;

!#  TIMEX 

!R [RrSs]edan" "\<TIMEX" "TYPE\=\"TME\"" "SBT\=\"DAT\"\>
!A {int i=0; printf("<TIMEX TYPE=\"TME\" SBT=\"DAT\">"); for(;yytext[i]!='<';putchar(yytext[i++])); }

_DefineMoveStartTagLeft(TmeDat,
	`[Rr|Ss] {edan }',
	`NoTags') ;

! NOTE: The following surname guesser rules have been moved to PrsPat,
! so that lines without tags can safely be skipped (matched as a
! whole) to improve run-time speed. (Jyrki Niemi 2014-11-26)

!#  GUESSER 
!# *ok** Xvic|Xvski|Xwska|x+sson => <PRS> 

!R ^[A-ZÅÄÖ][^\n\t\>\< ]+(vic|sson|wska|wski|vski)" "
!A {int i=0; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); for(;i<yyleng-1;putchar(yytext[i++])); 
!A 	printf("</ENAMEX> ");}

!Define PrsHumGuessBySuffix
!       [ Upper NSTag+ [{vic} | {sson} | {wska} | {wski} | {vski}] ] ;

!Define AddTags@
!       [ LC(#)
!	 PrsHumGuessBySuffix
!         RC(" ")
!	 EndTag(EnamexPrsHum) ] ;

!R [A-ZÅÄÖ][^\n\t\>\< ]+(vic|sson|wska|wski|vski)\n
!A {int i=0; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); for(;i<yyleng-1;putchar(yytext[i++])); 
!A 	printf("</ENAMEX>\n");}

! TODO: This rule might be combined with the above if HFST Pmatch
! allowed such context expressions as [LC(#) RC(" ") | LC(" ") RC(#)].

!Define AddTags@
!       [ LC(" ")
!         PrsHumGuessBySuffix
!	 RC(#)
!	 EndTag(EnamexPrsHum) ] ;

!# * ERRORS THAT HAVE TODO WITH THE DCA 

!R \<ENAMEX" "TYPE=\"(LOC|PRS)\"" "SBT=\"...\"\>(In|Hör|Som|På|Om|Allt|Inte|Men|En|Ett|När|Där|För|Då|Vad|Hur|Ja)\<\/ENAMEX\>" "
!A {int i=0;
!A 	for(;yytext[i]!='>';i++); i++;
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); printf(" ");}

Define RemoveTags@
       [ _RemoveTags(LocOrPrs,
                     `{In} | {Hör} | {Som} | {På} | {Om} | {Allt} | {Inte} | {Men} | {En} | {Ett} | {När} | {Där} | {För} | {Då} | {Vad} | {Hur} | {Ja}')
         " " ] ;

!# <ENAMEX TYPE="PRS" <ENAMEX TYPE="PRU">SBT="HUM/PRU">Ordförande</ENAMEX> i Läkarförbundet</ENAMEX>  
!#  new august 2010 

!R \<ENAMEX" "TYPE=\"PRS\"" "\<ENAMEX" "TYPE=\"PRU\">SBT[^\> ]+\>[^\<\>\n]+\<\/ENAMEX\>[^\n\<\>]+\<\/ENAMEX\>
!A {int i=0;
!A 	for(;yytext[i]!='>';i++); i++;
!A 	printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\" ANI=\"PRU\">"); 
!A 	for(;yytext[i]!='<';putchar(yytext[i++])); i=i+9;   for(;i<yyleng;putchar(yytext[i++])); }

! TODO: Is this really needed?

Define NestedStartTagPrsPru "<" Enamex {Prs} "<" Enamex {Pru} ">" TagNamePart+ ">" ;

Define FixTag@
       [ _Remove(NestedStartTagPrsPru)
         NoTags _Remove(`{</} Enamex {Pru>}') NoTags
	 RemoveEndTagEnamex
	 EndTag(EnamexPrsHumPru) ] ;

! CHECK: The following rules have been moved from WrkWsp (and combined
! into one). Does it affect the result?

!R "Journal of the \<ENAMEX TYPE=\"ORG\" SBT=\"CRP\"\>"[^\n\<]+"\<\/ENAMEX\>"
!A {int i=15;	printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">Journal of the ");	for(;yytext[i]!='>';i++); i++; for(;i<yyleng; putchar(yytext[i++]));}

!R "Journal of \<ENAMEX TYPE=\"ORG\" SBT=\"CRP\"\>"[^\n\<]+"\<\/ENAMEX\>"
!A {int i=11;	printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">Journal of the ");	for(;yytext[i]!='>';i++); i++; for(;i<yyleng; putchar(yytext[i++]));}

_DefineChangeMoveStartTagLeft(OrgCrp, WrkWmd,
       `{Journal of } ({the })', `NoTags') ;


! Improve run-time speed by matching whole lines without tags, since
! they cannot be matched by any other expression. (Jyrki Niemi
! 2014-11-26)

Define SkipUntaggedLine@ [ .#. NoTags .#. ] ;


Define TOP [ @@ ] ;
