#! /usr/bin/env python
# -*- coding: utf-8 -*-


"""
Usage: pmatch-add-weights.py < pmatch_rule_file.in > pmatch_rule_file.out

Adds weights to Pmatch definitions, to simulate rule ordering.

TODO: Real parsing of Pmatch definitions.

Author: Jyrki Niemi (jyrki.niemi@helsinki.fi) 2014
"""


import sys
import codecs
import re

from optparse import OptionParser


class WeightAdder(object):

    def __init__(self, opts):
        self._opts = opts

    def process_input(self, infiles):
        if isinstance(infiles, list):
            for infile in infiles:
                self._process_file(infile)
        else:
            self._process_file(infiles)

    def _process_file(self, infile):
        if isinstance(infile, basestring):
            with codecs.open(infile, 'r', encoding='utf-8') as inf:
                self._process_input(inf)
        else:
            self._process_input(infile)

    def _process_input(self, infile):
        collect_def = False
        add_weight = False
        def_text = ''
        weight = 1
        for line in infile:
            if not collect_def:
                if line.strip().startswith('!') or not line.strip():
                    sys.stdout.write(line)
                    continue
                elif re.search(r'Define\s+', line.strip()):
                    collect_def = True
                    if re.match(r'Define\s+'
                                + self._opts.define_name_regexp
                                + r'\s',
                                line):
                        add_weight = True
                else:
                    sys.stdout.write(line)
            if collect_def:
                def_text += line
                if line.strip().endswith(';'):
                    collect_def = False
                    if add_weight:
                        def_text = def_text[:-1] + ' ' + str(weight) + '\n'
                        weight += 1
                    sys.stdout.write(def_text)
                    def_text = ''
                    add_weight = False


def getopts():
    optparser = OptionParser()
    optparser.add_option('--target', type='choice', choices=['top', 'rules'],
                         default='top')
    optparser.add_option('--define-name-regexp',
                         default=r'(?:(?:Ena|Nu|Ti)mex[a-zA-Z]+|Except)\d+')
    (opts, args) = optparser.parse_args()
    return (opts, args)


def main():
    sys.stdout = codecs.getwriter('utf-8')(sys.stdout)
    sys.stdin = codecs.getreader('utf-8')(sys.stdin)
    (opts, args) = getopts()
    ins_adder = WeightAdder(opts)
    ins_adder.process_input(args or sys.stdin)


if __name__ == '__main__':
    main()
