/*
        File: WrkPat.ll
        Author: Dimitrios Kokkinakis
        version: 090516
        Finds titles of ARTWORK
*/
%{
%}
U	[\101-\132\300-\335]
CITAT	\"|\|\'|\'\'|\|\|\&\#x201[39D]\;
%{
	/* projects */
int printWRKP (char *a, int x);
	/* written media */
int printWMD (char *a, int x);
	/* paintings, sculptures? */
int printWAO (char *a, int x);
	/* Rest */
int printWRK (char *a, int x);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDI|MDS|MDC|MDD|MDA|MDO|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"\<TIMEX TYPE\=\"TME\" SBT\=\"DAT\"\>"[^\n\<]+\<\/TIMEX\>	{ECHO;}

(Lne|TV\-)avtalet	{ECHO;}
[^\n ]+rojekt(et)?(" "{U}[^\n ]+)+" "(till|in|to|for)" "[^\n ]+	{printWRKP(yytext,1);}
[^\n ]+rojekt(et)?" "{U}[^\n ]+(\'s|isk|ing|ande|ges|iv|ska|borg|ens|erns|ella)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRKP(yytext,1);}
[^\n ]+rojekt(en)?" "{U}[^\n ]+" och "{U}[^\n ]+	{printWRKP(yytext,1);}
[^\n ]+rojekt(et|en)?(" "{U}[^\n ]+)+	{printWRKP(yytext,1);}
[^\n ]+rojektet" \, som ftt namnet "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRKP(yytext,5);}
[^\n ]+rojektet" som ftt namnet "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRKP(yytext,4);}
[^\n ]+rojekt(et)?" "(kallas|heter)" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRKP(yytext,2);}
[^\n ]+rojekt(et)?" "(kallas|heter|kallat)(" "{U}[^\n ]+)+	{printWRKP(yytext,2);}
[^\n ]+rojekt(et)?" som "(kallas|heter)(" "{U}[^\n ]+)+	{printWRKP(yytext,3);}
(Pilot|Forsknings|Utvecklings|ldre|Bygg|Samarbets|Drm|Film)projektet	{ECHO;}
({U}[^\n\<\> ]+" ")+Project	{printWRKP(yytext,0);}
{U}[^\n ]+avtalet	{printWRKP(yytext,0);}
[^\n ]*(EU\-programmet|ivsmedelsprogrammet|tredningen|kningsprogrammet|ntorsprogrammet|roduktsomrdet|stndsprogrammet|ksamhetsomrdet|frsomrde|ffrsomrdet)(" "{U}[^\n ]+)+	{printWRKP(yytext,1);}
(med|deltagande|delta|medlemskap|in|medlem|deltar)" i "(EMU|ERM)	{printWRKP(yytext,2);}
(Kanske|Som|Vad|Med|Och|Enligt|Fr|Den|Till|Under|Nr|P|Om|Men|Inom)" "[Pp]osten	{ECHO;}
(Kom|Ut|[Vv][Dd]\-|Klara)posten	{ECHO;}
(E\-|{U}[^\n ]+minister)posten	{ECHO;}
[^\n ]*idningen" "{U}[^\n ]+dets	{ECHO;}
(Vra|Bsta|Att|Enligt|FOTO|Foto)" "Nyheter(na)?	{ECHO;}
(Av|Medan|Gteborgs|Stockholms|Stor|Hellre|Den|Som|Till|Inuti|Ngon|Vad|Samma|Tusentals|P|Ingen|Sveriges|Hela|Alla|r|Att|En|Eller|Ny|Kommer|Fr|ven|Dessa|De|Danska|Dagliga|Bda|Engelska|Efter|Grna|Norska|Frsenade|F|Flera|Flertalet|Enligt|Landets|Lrdagens|Andra|Om|Ngra|Mnga|Men|Nr|Tio|Och|Bra|Bakom|Frn|Ls|Med|{U}[^\n ]+iska)" "[a-z]*tidning(ar|en)?	{ECHO;}
(av|nligt|till|dagens)" "(SvD|Arbetet|GP|DN|Sydsvenskan|NE|Expressen|Dagens" "{U}[^\n ]+)	{printWMD(yytext,1);}
(SvD|Arbetet|GP|DN|Sydsvenskan|Expressen)" \( "[0-9]+\/[0-9]	{printWMD(yytext,102);}
(terg|publicera|krnika|rubriken|beskrivs|redovisas|rapportera)[dtivens]*" i "(Nature|SvD|Arbetet|GP|DN|Pravda|"Ord och Bild"|GT|Slitz|Aftonbladet|Gteborgs\-Posten|Sydsvenskan|Expressen|Dagens" "{U}[^\n ]+)	{printWMD(yytext,2);}
(terg|publicera|krnika|rubriken|redovisas|rapportera)[dtivens]*" i"(" "{U}[^\n ]*)+" "{U}[^\n ]*(bladet|osten|yheter|ost|ndustri)	{printWMD(yytext,2);}
skriver" "{U}[^\n ]+(bladet|yheter)	{printWMD(yytext,1);}
([Uu]r|[Ii])" "(SvD|Arbetet|GP|DN|Sydsvenskan|Expressen)	{printWMD(yytext,1);}
"artiklar som finns i"(" "{U}[^\n ]*)+	{printWMD(yytext,4);}
"Klla \:"(" "{U}[^\n ]*)+" News"	{printWMD(yytext,2);}
[^\n ]*rtikel(n|serie)?" i "{U}[^\n ]+(ns|sk|ska)" "[^\n ]+(sk|ska|el)" "[^\"\n ]+	{printWMD(yytext,2);}
[^\n ]*rtikel(n|serie)?" i "{U}[^\n ]+(ns|sk|ska)" "[^\n ]+	{printWMD(yytext,2);}
[^\n ]*rtikel(n|serie)?" i"(" "{U}[^\n ]*)+	{printWMD(yytext,2);}
[^\n ]*([Pp]rosan|[Rr]ecension)" i"(" "{U}[^\n ]*)+	{printWMD(yytext,2);}
[^\n ]*(nadens|enaste|rsta|ista|andra|agens|tryckt|rs)" "(upplaga|upplagan|numret)" av"(" "{U}[^\n\: ]+)+	{printWMD(yytext,3);}
[^\n ]*(enaste|rsta|ista|andra|agens|tryckt)" "(upplaga|upplagan|numret)" av "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWMD(yytext,3);}
(enaste|rsta)" numret av "{U}[^\n ]+(ns|sk)" "[^\n ]+	{printWMD(yytext,3);}
[^\n ]+(numret" "av|tupplagan" "av|"renumerera p")(" "{U}[^\n ]+)+	{printWMD(yytext,2);}
[^\n ]*dakt(r|ionschef)(en)?" fr "{U}[^\n ]+(sk|ska|ns)" "[^\n ]+(" "{U}[^\n ]*)*	{printWMD(yytext,2);}
[^\n ]*dakt(r|ionschef)(en)?" fr "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWMD(yytext,2);}
[^\n ]*dakt(r|ionschef)(en)?" fr"(" "{U}[^\n ]*)+	{printWMD(yytext,2);}
{U}+\-artikel(n)?	{printWMD(yytext,0);}
num(mer|ret)" av "(Nature|Lancet|{U}[^\n ]+vrlden)	{printWMD(yytext,2);}
([Ff]ack|hus|[Pp]arti|egerings)organet(" "{U}[^\n ]*)+	{printWMD(yytext,1);}
[^\n ]*registret" "[A-Z][\-A-Z]+	{printWMD(yytext,1);}
[Ii]" "JAMA	{printWMD(yytext,1);}
{U}[^\n ]+"\-"([Pp]os|Corresponden)ten	{printWMD(yytext,0);}
({U}[^\n ]*" ")+(Posten|Correspondenten|Kuriren|Socialdemokraten|Chronicle|Cronicle|Zeitung|Shimbun|Times|Dagblad|Pravda|Tribune)	{printWMD(yytext,0);}
[^\n ]*([Tt]idningen|blaskan)" "{U}[^\n ]+(" om "|" du "|" "[Oo]f" the "){U}[^\n ]+	{printWMD(yytext,1);}
[^\n ]*[Tt]id(ning|skrift)en" "{U}[^\n ]+(iva|iskt|sts|al|ns|isk)" "[^\n ]+	{printWMD(yytext,1);}
[^\n ]*[Tt]id(ning|skrift)(en)?" "(al\-[^\n ]+|iDAG)	{printWMD(yytext,1);}
[^\n ]*[Tt]id(ning|skrift)(en)?" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWMD(yytext,1);}
[^\n ]*[Tt]id(ninga|skrifte)rna(" "{U}[^ \n]*)+([ \,]+{U}[^ \n]*)*(" "(och|eller)(" "{U}[^ \n]*)+)?	{printWMD(yytext,1);}
[^\n ]+(kvallerbladet|kriften)" "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" "(\?|\,|\.|\-|\;)	{printWMD(yytext,101);}
[^\n ]*[Tt]id(ning|skrift)(en)?(" "{U}[^\n ]*)+	{printWMD(yytext,1);}
"kvallerbladet "{U}[^\n ]+	{printWMD(yytext,0);}
[^\n ]*"idningarna r"(" "{U}[^\n ]*)+" och"(" "{U}[^\n ]*)+	{printWMD(yytext,2);}
({U}[^\n ]+" ")+[^\n ]*[Tt]idning(ar|en)?(" "{U}[^\n ]*)*	{printWMD(yytext,0);}
{U}[^\n ]+" "({U}[^\n ]+bladet|Nyheter|Nyheterna)	{printWMD(yytext,0);}
{U}[^\n ]+(tidning|tidningen|journalen|bladet|[Kk]uriren|posten|snytt|posten)	{printWMD(yytext,0);}
skriver(" "{U}[^\n ]*)+" Press"	{printWMD(yytext,1);}
"skriver The"(" "{U}[^\n ]*)+	{printWMD(yytext,1);}
"Isvestija"	{/*leave it here before the PLT/ORG*/ printWMD(yytext,0);}
erfar(" "{U}[^\n ]*)+	{printWMD(yytext,1);}
"intervju "(med|till)" "(DN|GP)	{printWMD(yytext,2);}
"skrev al\-Iraq"	{printWMD(yytext,1);}
	/* <ENAMEX TYPE="WRK" SBT="WAO"></ENAMEX><MTH="PTR"/> */
[^\n ]*("videon till"|"uppfljare till"|"illustration till"|lning" "som)" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWAO(yytext,2);}
[^\n ]*(kulpturgrupp|lning|kulptur)(en)?" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWAO(yytext,1);}
[^\n ]*(tavla|[Ss]taty)(n)?" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWAO(yytext,0);}
[^\n ]+(lning|kulptur)(en)?" \,"(" "{U}[^\n\,\- ]+)+" "(\-|\,|\.|\;|\!)	{printWAO(yytext,201);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" "("heter en mlning"|"hette en mlning")	{printWAO(yytext,103);}
[^\n ]*(lning|kulptur)(en)?" "{U}[^\n ]+(pas|sas|iga|isk|rs|ns|nde|ska|ns|nas|ts)" "[^\n ]+(" "{U}[^\n ]+)*	{printWAO(yytext,1);}
[^\n ]*[Mm]lning(en)?" "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" "(\?|\,|\.|\-|\;)	{printWAO(yytext,101);}
[^\n ]*(lning|kulptur)(en)?" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWAO(yytext,1);}
[^\n ]*(kulpturgrupp|lning|kulptur)(en)?(" "{U}[^\n ]*)+	{printWAO(yytext,1);}
"bermda mlning"(" "{U}[^\n ]+)+	{printWAO(yytext,2);}
[^\n ]+lning" som"(" "{U}[^\n ]*)+	{printWAO(yytext,2);}
({U}[^\n ]+" ")?{U}[^\n ]+s" "[^\n ]*staty(et)?	{printWAO(yytext,0);}
({U}[^\n ]+" ")?{U}[^\n ]+\-monument(et)?	{printWAO(yytext,0);}
[^\n ]*[Ss]taty(n)?(" "{U}[^\n ]+)+	{printWAO(yytext,0);}
"kollektionen heter"(" "{U}[^\n ]*)+	{printWAO(yytext,2);}
	/*****************************/
	/* *** KEYWORD " TITLE " *** */
	/*****************************/
[^\n ]*sj(unga|ng|unger|unga|ungande)" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
[^\n ]*(utkommer|ressionistiska|lsa|dirigerade|dirigerat|komponerat|komponerade|lser|lst|sviten|emoarer|emoarerna|[Uu]tgivna|usikteaters|Abbas|enaktarna|nstallationen)" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
[^\n ]+(to|ri|ra|rio|tho)logi(n)?" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
([Vv]agg|[Bb]arn)visa(n)?" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
[^\n ]+(belnade|versatta|verstta|tkomna|versatt)" "{CITAT}" "{U}[^\n ]+(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
[^\n ]*(iktcykel|naktare|krivelse|succ|ografi|[Oo]pera|[Ss]erie|hriller|[Tt]itel|hlager|omedi|[Ee]ss|erttelse|rtikel|studie|klassiker|estseller|ulkalender|praktaria|krnika|estsljare|itzervinnare|folder)(n)?" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
[^\n ]*(okument|exikon|paradnumr|amlingsverk|rottsverk|[Bb]idrag|andsverk|[Ee]pos|otografi|eportag|pslagsverk|[Ss]pex|onstverk|sterverk|skdespel|stodonverk|kesterverk|filmverk)(et)?" "{CITAT}(" "[^\n\"\'\\#]+)+" "{CITAT}	{printWRK(yytext,1);}
[^\n ]*(omanseri|eminari|styck|umentalarbet|rosaarbet|innesmrk|[Hh]ft|apitl)e[nt]?" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
	/* MOD (Jyrki Niemi): The directive "#minus lc [Tt]idskrift" in the
	   action of the following rule excludes "tidskrift" from the left
	   context so that such names get WRK WMD from a rule above. This is
	   not handled by Pmatch rule ordering by weights since contexts are
	   not weighted(?). */
[^\n ]*(kantat|hymn|thyrambe|kildring|olym|ubrik|tredning|spalt|usikal|[Pp]salm|apport|[Rr]oman|[Ss]krift|[Ss]ng|ppsats|[Ll]t|[Nn]ovell|ovellet|elodram|[Pp]js|[Ee]pos|[Bb]alett|[Bb]ok|[Bb]allad|[Dd]ikt|vhandling|paroll|tionrull|[Ss]kylt|monolog|[Hh]it)(en)?" "{CITAT}" "{U}[^\n\# ]*(" "[^\n\#\"\'\]+)*" "{CITAT}	{/* #minus lc [Tt]idskrift */ printWRK(yytext,1);}
[^\n ]*(forism|vell|ss|ikt|ebut|yrik|ntologi|psats|onett|ssay|ttelse|ument)samling(en)?" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\]+)*" "{CITAT}	{printWRK(yytext,1);}
[^\n ]*(rfrbundets|[Pp]ocket|kabar|varietn|temat|tema)" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
("Verk \:"|"sitt verk")" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
	/*************************************/
	/* *** KEYWORD KEYWORD " TITLE " *** */
	/*************************************/
	/* <ENAMEX TYPE="WRK" SBT="???"></ENAMEX><MTH="PTR"/> */
" akten av "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,0);}
[Pp]"jser "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" och "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
[^\n ]*(roman|biografi|[Bb]ok|epos|avhandling|rtikelseri|ubriken)(en)?" "[\:\,]" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n ]*(ramfranden|ecensioner|versttning|vsnittet|remir|psttning|frestllning|andsvisning|exemplar|skaparen|frande|scensttning|ramfrandet)" av "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n ]*(versttning|tolkning|remir|psttning|lsning)(en)?" av "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
(anekdoter|aria|arior|citat|hmtad|hmtat|inspelningar|inspiration|rader|repliken|scen|scener|jungande|slagnumren|strof|stycke|texterna|snger|musiken|handlingsmnster|sngnummer|uppslag|utdrag)" ur "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n ]*([Tt]ext|uppfljar|frord|[Mm]usik|[Mm]anus|[Mm]anuskript|frfattare)(en|et)?" till "{CITAT}" "{U}[^\n\# ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
(gamla|behandla|avhandlade|over|kring|i|p|runt|valt)" mnet "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n ]*(ongspremiren|ebuten|ebuterade)" med "{CITAT}" "{U}[^\n ]+(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n ]*(publicera[dest]+|dpersonen|ollen|lmstjrnan|gestalting|gestaltas|andlingen)" i "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
	/* MOD (Jyrki Niemi): Added missing space after "rfattaren bakom" */
("rfattaren bakom "|"dirigerade hela "|"ge ut "|"satte upp "|"teater ger "|"omfattande samling "|"songens sista "|"rapport om "|"som visar "|"eaterfrening ger "|"gav ut "){CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n ]*(opera|pjs|artikel|rtikeln|[Bb]oken|stycket|klassiker|cker|dikter|sterverk)" "(kallad|heter|som)" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n\< ]*[Pp]"js \: "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n\< ]*("i som hette"|"elodin som hette"|"roman som hette"|"vhandlingen i mnet"|"hymn som heter"|"sng som heter")" "{CITAT}" "{U}[^\n ]+(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,3);}
[^\n ]*(opera|pjs|bok|vsnitt)" "(med" "namnet|hade" "namnet|[^\n ]+" kallas")" "{CITAT}" "{U}[^\n ]+(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,3);}
"akten av "({U}[^\n ]+" ")?{U}[^\n ]+"s "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n ]*(peraversion|\-version|ioversion|psttning)(en)?" av "({U}[^\n ]+" ")?{U}[^\n ]+"s "{CITAT}" "{U}[^\n ]+(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
{U}[^\n ]+s" "[^\n ]*bok" "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,2);}
[^\n ]*[Ff]"ormulret "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
	/*****************************/
	/* *** " TITLE " KEYWORD *** */
	/*****************************/
	/* <ENAMEX TYPE="WRK" SBT="???"></ENAMEX><MTH="PTR"/> */
^{CITAT}(" "[^\"\'|\\n\#]+)+" "{CITAT}" "(av|spelar|visas|sjng)	{printWRK(yytext,101);}
{CITAT}(" "[^\"\'|\\n\#]+)+" "{CITAT}" "(Av|seminarium|premirvisa|sjunger|publicerades|mlats)	{printWRK(yytext,101);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" \( "[1-2][0-9][0-9][0-9]" \)"	{printWRK(yytext,0);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" \( "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" \)"	{printWRK(yytext,0);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" \, "[^\n ]*(belnad|sjng|frestllning|ventyr)[^\n ]*	{printWRK(yytext,102);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" "("med musik"|"r rubriken"|"var rubriken")	{printWRK(yytext,102);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" "("hade premir"|"i regi"|"visas p"|"handlar om"|"som Oscarnominerades")	{printWRK(yytext,102);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" "het(te|er)" "(bok|lt|pjs|frestllning)[a-z]*	{printWRK(yytext,102);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" "("r hennes bsta"|"som nu visas"|"\, en bok")	{printWRK(yytext,103);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" kom ut "(\,|fr|hst|i|[0-9])	{printWRK(yytext,103);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" som kom ut "(\,|fr|hst|i|[0-9])	{printWRK(yytext,104);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" \, som kom ut "(\,|fr|hst|i|[0-9])	{printWRK(yytext,105);}
{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" \, som "(kom" "[0-9]|"hade premir")	{printWRK(yytext,104);}
	/*********************************/
	/* *** KEYWORD , {T}ITLE ,|. *** */
	/*********************************/ 
(lsa|sjunga|dirigerade|komponerat|lser|lst|sjng|sjunger|regisserat)" \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
[^\n ]+(to|ri|ra|rio|tho)"login \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
[^\n ]+(ublikframgngar|belnade|versatta|utkomna)" \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
([Vv]agg|[Bb]arn)visa(n)?" \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
[^\n ]*(klassiker|succ|ografi|[Ss]erie|[Tt]itel|chlager|omedi|[Ee]ss|erttelse|rtikel)n?" \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
[^\n ]*([Dd]ikt|amlingsverk|andsverk|[Ee]pos|eportag|pslagsverk|[Ss]pex|onstverk)(et)?" \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
[^\n ]*(rosaarbete|innesmrke|[Dd]rama|eportage)t?" \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
[^\n ]*(volym|ubrik|tredning|spalt|usikal|[Pp]salm|apport|[Rr]oman|[Ss]krift|ppsats|[Ll]t|ovell|elodram|[Pp]js|[Ee]pos|[Bb]alett|[Bb]ok|[Bb]allad|[Dd]ikt|vhandling)(en)?" \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
[^\n ]*(orism|vell|ss|ikt|ebut|yrik|ologi|ment|sats)samling(en)?" \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
[^\n ]*([Oo]pera|[Ss]ngen|[Hh]iten|[Pp]ocket)" \,"(" "{U}[^\n\,\- ]+)+" "[\-\,\.\;\!]	{printWRK(yytext,201);}
	/* *** Keyword[BESTMD] TITLE *** */
	/*Allow max 2or3 tokens OR KEYWORD from title +sth*/
{U}[^\n ]+s" "Requiem	{printWRK(yytext,0);}
[^\n ]+(ri|rio|to|ra)logi(n)?(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
[Vv]olymerna(" "{U}[^\n ]*)+" och"(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
[Ii]" "[^\n ]*verket(" "{U}[^\n ]*)+	{printWRK(yytext,2);}
[^\n ]*([Rr]oman|[Nn]ovell|vhandling|[Ss]kildringen)(en)?" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(ria|iga|isk|rs|ns|nde|ska|ns|nas|)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,0);}
[^\n ]*([Rr]oman|[Nn]ovell|vhandling|[Pp]js)(en)?" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*([Rr]oman|[Nn]ovell|vhandling|[Pp]js)(en)?" "{U}[^\n ]+" och "[^\n ]+	{printWRK(yytext,1);}
[^\n ]*([Rr]oman|[Nn]ovell|vhandling|[Pp]js)(en)?" "({U}[^\n ]+" ")+(enkel|"of a"|for|and|of|"of the"|"for the")" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
	/*(Och|Mina|Vad|S|Som|Lilla|Bakom|Les|Jag|Ngon|In|Frn|I|De|Allt|Mitt|Att|A|The|En|Ett|Till|Nr|Det|Den|Du)*/
[^\n ]*([Bb]oken|[Nn]ovell|vhandling|[Pp]js)(en)?" "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" "[\(\?\-\,\.\;\!]	{printWRK(yytext,101);}
[^\n ]*(omanen|[Rr]oman|[Pp]js|jsen|iteln|tudien|pporten)" "{U}[^\n ]+(llt|bara|da|es|ent|isk|rs|ns|nde|iga|nas|iala|ska|nsk|avs|ets|igt|ares)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*[Bb]ok(en)?" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*[Bb]oken" "{U}[^\n ]+" och "[^\n ]+	{/*och*/printWRK(yytext,1);}
[^\n ]*(usikal|usikalen|[Dd]rama|[Dd]ramat|[Ff]ars|[Ff]arsen|[Kk]omedi|omedin)" "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" "(\?|\,|\.|\-|\;)	{printWRK(yytext,101);}
[^\n ]*[Dd]"ramat "{U}[^\n ]+(nas|ens|nde|ans)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*([Dd]ramat|[Ff]arsen|omedin|[Kk]omedi)" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*[Ff]ars(en)?" "{U}[^\n ]+a" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*(omedin|[Kk]omedi|elationsdrama|rkesterstycket)(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
[^\n ]*"ubriken "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" "(\?|\,|\.|\-|\;)	{printWRK(yytext,101);}
[^\n ]*"ubriken "{U}[^\n ]+(isk|rs|ns|nde|ska|es|igt|:s|ella)" "[^\n ]+	{printWRK(yytext,1);}
[^\n ]*"ubriken "(The|Hur|Att|View)" "[a-z]+" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*"ubriken "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" of"|" without"|" ett")?(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
"Caf Opera"	{ECHO;}
[^\n ]*[Oo]pera(n)?" "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" "(\?|\,|\.|\-|\;)	{printWRK(yytext,101);}
[^\n ]*[Oo]pera(n)?" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
operor" "{U}[^\n ]+" och "{U}[^\n ]+	{printWRK(yytext,1);}
[^\n ]*([Rr]evy|[Ss]howe|[Dd]ikte)n" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*(evy|kandal)succ(n)?" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*([Oo]pera|soar|diktcykel|sngcykel|evysucc|andalsucc|[Dd]ikte|[Ss]onata|[Rr]evy|[Ss]howe)(n)?(" "{U}[^\n ]+)+	{printWRK(yytext,1);}
[^\n ]*rapport" "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" "(\?|\,|\.|\-|\;)	{printWRK(yytext,101);}
[^\n ]*[Ss](ingeln|ngen|chlagern|pex|kdespel|pexet|kdespelet)" "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*inglarna(" "{U}[^\n ]*)+" "(to|och|of)(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
[^\n ]*[Ss](ingeln|ngen|chlagern|pex|kdespel|pexet|kdespelet)(" "{U}[^\n ]*)+	{printWRK(yytext,1);} 
[^\n ]+(iso|tionsserie|ingla)rna(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
[^\n ]*(ng|ammar|lust|eater|usik|sago|bygde|gst)spelet(" "{U}[^\n ]+)+	{printWRK(yytext,1);}
[^\n ]*(ebut|yrik|ntologi|psats|forism|ovell|ss|[Dd]ikt|erttelse|okument)samling(en)?(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
[^\n ]+"iteln "{U}[^\n ]+(" "[^\n ]+)?" "[^\n\, ]+" "(\?|\,|\.|\-|\;)	{printWRK(yytext,101);}
[^\n ]+"iteln "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+sa" "[^\n ]+	{printWRK(yytext,1);}
[^\n ]+"iteln "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]+"iteln "Varfr" "[^\n ]+	{printWRK(yytext,1);}
[^\n ]+"iteln "{U}[^\n ]+(" the"|" of"|" in"|" to the")[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
{U}[^\n ]+\-studie[rn](" "{U}[^\n ]*)*	{/*Leave it 0 ? Xxx-syudien?*/ printWRK(yytext,0);}
[^\n ]+"ppsatsen "{U}[a-z]?[a-z]?[a-z]?[a-z]?" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,1);}
[^\n ]*(rkester|amlings|ppslags|ikt|onst|ster|oman|gdoms|lag|bands|ilm)verk(et)?(" "{U}[^\n ]+)+	{printWRK(yytext,0);}
{U}[^\n ]+"s "[^\n ]*(bok|tragedy)(" "{U}[^\n ]+)+	{printWRK(yytext,2);}
[^\n ]*(berttelse|rockslt)" "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" "(\?|\,|\.|\-|\;)	{printWRK(yytext,101);}
"romanerna "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" \( "[0-9]+" \) och "{U}[^\n ]+(" "[^\n ]+)?" "[^\n ]+" \("	{printWRK(yytext,1);}
"romanerna "{CITAT}" "{U}[^\n ]*(" "[^\n\"\'\\#]+)*" "{CITAT}" och "{CITAT}" "{U}[^\n ]+(" "[^\n\"\'\\#]+)*" "{CITAT}	{printWRK(yytext,1);}
[Nn]yutkomna(" "{U}[^\n ]*)+" "(of|on|the|in)" "[^\n ]+	{printWRK(yytext,1);}
[Nn]yutkomna" "{U}[^\n ]+"s "[^\n ]+	{printWRK(yytext,1);}
[^\n ]*({U}[^\n ]+\-lte|vlingslte|[Vv]olyme|itel|roma|entraria|ulkalender|iskoklassiker|atlesklassiker|[Aa]ria|{U}[^\n ]+\-aria|[Mm]elodi|[Bb]allade|itellte|estseller|onografi|[Ee]ss|jltesaga|lettsaga|olksaga|TV\-serie)n(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
[^\n ]*([Dd]ramat|ithyramben|lexikonet|sjungande|uperhit|enaktare|0-talshit)(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
[^\n ]*(ppsttning|tudien|ppsats|usikberttelsen|sberttelsen|yutkomna|karjournal|[Bb]ok|[Rr]apport|schrift|ubriken|[Oo]perett|usikal|[Ff]ars|[Pp]js|[Rr]oman|ovell|vhandling|ollektion|deoinstallation|skildring|sidiga)(en)?(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
	/* HETER */
[^\n ]*(omanen|stycket|rtikeln|[Bb]oken|roman)" "(hette|heter)(" "{U}[^\n ]*)+	{printWRK(yytext,2);}
[^\n ]*(ublikation|ovell|film|roman|bok|tidning|skrift)(en)?" "(med" "namnet|"som heter")(" "{U}[^\n ]*)+	{printWRK(yytext,3);}
	/* MOSTLY WRITTEN MATERIAL, newspapers, books etc. */
[^\n ]*(rfattaren|egissr|manus|omslaget|frordet|vertyren|texten|[Vv]ideon|tracket)" till"(" "{U}[^\n ]*)+	{printWRK(yytext,2);}
	/* WRITTEN MATERIAL that should NOT be ORGS */
(Pln|Lse|Familje|Kok|Lro)bok(en)?	{ECHO;}
Reebok	{ECHO;}
(Valda|Dessa|De)" skrifter"	{ECHO;}
[^\n ]*(ecko|yhets|[Rr]ese|[Ss]port|grds|rr|bolls)magasinet(" "{U}[^\n ]+)+	{printWRK(yytext,1);}
{U}[^\n ]+(borg|land)sguiden	{printWRK(yytext,0);}
(Svensk|Svenska|{U}[^\n ]+s)" "[^\n ]+bok	{printWRK(yytext,0);}
("Frsta "|"Andra ")?{U}[^\n ]+bok(en)?	{printWRK(yytext,0);}
{U}[^\n ]+\-rapport(en)?	{printWRK(yytext,0);}
{U}[^\n ]+" "([^\n ]+" ")?kvartalsskrift	{/* X Xisk Xskrift */printWRK(yytext,0);}
{U}[^\n ]+" skrifter"	{printWRK(yytext,0);}
{U}[^\n ]+" "[^\n ]+(ri|rio|to|ra)login	{printWRK(yytext,0);}
"lser "("Kalle Anka"|"Charles Dickens"|Bamse|Strindberg)	{printWRK(yytext,1);}
(lser|lste|anekdoter|aria|arior|citat|repliken|scen|scener|sjungande|slagnumren|sjunger|texterna|snger|musiken|handlingsmnster|sngnummer)" ur "{U}[^\n ]*[^\ns ](" "{U}[^\n ]*)*	{printWRK(yytext,2);}
(lser|lsteanekdoter|aria|arior|citat|repliken|scen|scener|sjungande|slagnumren|sjunger)" ur"(" "{U}[^\n ]*)+	{printWRK(yytext,2);}
[^\n ]+"ska versttning av"(" "{U}[^\n ]*)+	{printWRK(yytext,3);}
[^\n ]*(eckobrevet|yhetstjnsten|yhetsbrevet|enkten)(" "{U}[^\n ]*)+	{printWRK(yytext,1);}
{U}[^\n ]+" "Nyhetsbrevet	{printWRK(yytext,0);}
	/*COMPOUNDS*/
(Inskriften|Tidskriften|Mordutredningen|Tidskrifter|Lrobckerna|Brottsutredningen|Notskriften|Freskrifterna|Avskrifter|Skolbckerna|Dagbckerna|Kulturtidskrifter|Freskriften|Freskrifter|Utskriften|Utskrifter|Tidskrifterna|Talskriften|TV\-predikan)	{ECHO;}
{U}[^\n ]+(\-katalog|psalm|\-konvention|enkt|skrift|evangelium|evangeliet|arkivet|bckerna|predikan|registret|utredningen|sagorna|arkiven|symfoni|symfonin|sonaten)(en|er|erna)?	{printWRK(yytext,0);}
	/* Keyword i TITLE & Keyword av/title TITLE */
[^\n ]*(ragrafer|nvisningar|erttelser|estmmelser|skildringen)(na)?" i"(" "{U}[^\n ]*)+	{printWRK(yytext,2);}
[^\n ]*(dpersonen|stycket|framgr)" i "{U}[^\n ]+" "{U}[^\n ]+s(" "{U}[^\n ]*)+	{printWRK(yytext,4);}
[^\n ]*"rollen i "{U}[^\n\: ]+"s "[^\n ]+" \."	{printWRK(yytext,2);}
[^\n ]*"rollen i "({U}[^\n ]+" ")?{U}[^\n\: ]+s(" "{U}[^\n ]*)+	{printWRK(yytext,2);}
" akten av "{U}[^\n ]+"s "[^\n ]+	{printWRK(yytext,2);}
" akten av"(" "{U}[^\n ]+)+	{printWRK(yytext,2);}
[^\n ]+([^nm\n ]frandet|psttning)" av "{U}[^\n ]*" "{U}[^\n ]*s(" "{U}[^\n ]+)+	{/*gen auth */printWRK(yytext,2);}
[^\n ]+"psttning av "{U}[^\n ]*s(" "{U}[^\n ]+)+	{/*gen auth */printWRK(yytext,2);}
[^\n ]+([^nm\n ]frandet|psttning)" av "{U}[^\n ]*" "(\.|\,|p|i)	{printWRK(yytext,2);}
[^\n ]+(ska|ns)" uppsttning av"(" "{U}[^\n ]+)+	{printWRK(yytext,3);}
[^\n ]*s(kapar|pelning)(arna|en)" av "{U}[^\n ]+" "{U}[^\n ]+(ade|s)" "[^\n ]+(" "{U}[^\n ]+)*	{printWRK(yytext,2);}
[^\n ]*(psttning|skapar|pelning)(arna|en)" av "(I|Time|En|Det|Den|Hga)" "[^\n ]+	{printWRK(yytext,2);}
[^\n ]*s(kapar|pelning)(arna|en)" av"(" "{U}[^\n ]+)+	{printWRK(yytext,2);}
	/* MOD (Jyrki Niemi): Rule was split into two based on right
	   context length. They could be recombined in Pmatch rules.
	   [^\n ]*(\-version|"nslipar sin version"|"krivit sin version"|ioversion)(en)?" av "{U}[^\n ]+" "[^\n ]+" "(\,|\.)	{printWRK(yytext,2);}
	 */
[^\n ]*(\-|io)version(en)?" av "{U}[^\n ]+" "[^\n ]+" "(\,|\.)	{printWRK(yytext,2);}
[^\n ]*(nslipar|krivit)" sin version av "{U}[^\n ]+" "[^\n ]+" "(\,|\.)	{printWRK(yytext,4);}
	/* MOD (Jyrki Niemi): Rule was split into two based on right
	   context length. They could be recombined in Pmatch rules.
	   [^\n ]*(\-version|"nslipar sin version"|"krivit sin version"|ioversion)(en)?" av"(" "{U}[^\n ]+)+	{printWRK(yytext,2);}
	 */
[^\n ]*(\-|io)version(en)?" av"(" "{U}[^\n ]+)+	{printWRK(yytext,2);}
[^\n ]*(nslipar|krivit)" sin version av"(" "{U}[^\n ]+)+	{printWRK(yytext,4);}
	/* more specific patterns */
("frelsa om"|"brett upplagda"|"titel r"|"sterliga verk")(" "{U}[^\n ]+)+	{printWRK(yytext,2);}
"lsa om The "[^\n ]+" of the"(" "{U}[^\n ]+)+	{printWRK(yytext,2);}
(ut|med)" samlingen"(" "{U}[^\n ]+)+	{printWRK(yytext,2);}
	/* KEYWORD som TITLE(s) -test */
[^\n ]*(omaner|[Ll]tar|eckare)" som"(" "{U}[^\n\,]+)+" \,"(" "{U}[^\n\,]+)+	{printWRK(yytext,2);}
[^\n ]*(cker|omaner|[Ll]tar|eckare)" som"(" "{U}[^\n ]*)+" och"(" "{U}[^\n ]*)+	{printWRK(yytext,2);}
[^\n ]*(cker|omaner|[Ll]tar|eckare)" som "({U}[^\n ]+" of a"|Det|Den|A|The)" "[^\n ]+	{printWRK(yytext,2);}
[^\n ]*(versiktsverk|cker|omaner|[Ll]tar|eckare|verk)" som "{U}[^\n ]+s" "[^\n ]+	{printWRK(yytext,2);}
[^\n ]*(versiktsverk|cker|omaner|[Ll]tar|eckare)" som"(" "{U}[^\n ]*)+	{printWRK(yytext,2);}
\n	{ECHO;}
.	{ECHO;}
%%
int printWRKP(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==5){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"PRJ\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);
}
int printWMD(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==5){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==101){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==102){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WMD\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
int printWAO(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAO\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==101){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==103){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==201){
while(yytext[c]!=' ') c--; 
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAO\">"); z=z+1;
for(;z<c; putchar(yytext[z++])); printf("</ENAMEX>");
for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
int printWRK(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==5){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==101){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==102){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==103){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==104){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==105){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==201){
while(yytext[c]!=' ') c--; 
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"WRK\" SBT=\"WAA\">"); z=z+1;
for(;z<c; putchar(yytext[z++])); printf("</ENAMEX>");
for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
main( argc, argv )
int argc;
char **argv;
{
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  yylex();return(0);
}
