/*
	File: PrsPat.ll
	Dimitrios Kokkinakis
	version: 041210
*/
%{
%}
U		[A-Z]
%{
  int printCLC (char  *a, int x);
  int printHUM1 (char *a, int x);
  int printHUM2 (char *a, int x);
  int printHUM3 (char *a, int x);
  int printHUM4 (char *a, int x);
	/* MEN */
  int printHUMN1 (char *a, int x);
	/* WOMEN */
  int printHUMN2 (char *a, int x);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|TRM)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDC|MDD|MDA|MDI|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>										{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"\<TIMEX TYPE\="\"TME"\" SBT\=\""(DAT)\"\>[^\n\<]+"\<\/TIMEX\>"										{ECHO;}

	/*******************/
	/* MOST OCCUPATION */
	/*******************/
	/* SPECIAL fr 'man': MAN+NEN+N+NNEN*/
[^\n ]*(studie|vrds|bergs|borgens|bne|fregngs|hall|hemuls|uvud|lepto|lebe|lek|edicin|myto|mrkes|mrk|yro|rors|sages|amarbets|ports|tudio|system|kerhets|axerings|uppbrds|vlds|vrderings|rkes|styres|irkus|show|stunt|teater|skaps|hovs|mbets|ndustri|kp|radio|reklam|evolver|vice|tjnste|bank|brons|ramtids|gentle|hger|front|center|j|bts|omb|tyr|nans|nds|hair|ags|ndre|mera|lag|les|lis|[Tt]al|uds|rans|ls|laser|stnds|gels|orr|joners|stats|dels|st|frs|rand|nings|arko|spel|lder|rafts|fr|ress|rd|[Tt][Ii]s|blues|sp|vnster|\-|syns)(man|mannen)(" \'"|" \:"|" \""|" ,")?(" "{U}[^\n\t ]*)+														{printHUM1(yytext,1);}
[^\n ]*(tyr|nans|nds|hair|ags|ndre|mera|lag|les|lis|tal|uds|rans|ls|gels|orr|stats|st|s\-)(mn|mnnen)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?							{printHUM1(yytext,1);}
[^\n ]*[Vv]n(nen)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ][^\n\t ][^\n\t ]*)+					{printHUM1(yytext,1);}

	/*SKA+SKAN+SKOR+SKORNA*/
	/* MOD (Jyrki Niemi): Rule was split into two based on the number
	   of spaces in context:
	   [^\n ]*(student|rvtager|anser|arbeter|bader|innehaver|hopper|lper|svger|syssler|onstker|ventyrer|kaster|igener|rnmor|rnmo|fre|kter|mmer|peler|anger|fessor|nger|hller|oppler)sk(a|an)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+					{printHUM1(yytext,1);}
         */
[^\n ]*(student|rvtager|anser|arbeter|bader|innehaver|hopper|lper|svger|syssler|onstker|ventyrer|kaster|igener|rnmor|rnmo|fre|kter|mmer|peler|anger|fessor|nger|hller|oppler)sk(a|an)(" "{U}[^\n\t ]*)+					{printHUM1(yytext,1);}
[^\n ]*(student|rvtager|anser|arbeter|bader|innehaver|hopper|lper|svger|syssler|onstker|ventyrer|kaster|igener|rnmor|rnmo|fre|kter|mmer|peler|anger|fessor|nger|hller|oppler)sk(a|an)" "[':\",(](" "{U}[^\n\t ]*)+					{printHUM1(yytext,2);}
[^\n ]*(rnmor|rnmo|fre|kter|mmer|peler|anger|nger)sk(or|orna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?														{printHUM1(yytext,1);}

	/* INNA+INNAN+INNOR+INNORNA */
[^\n ]*([Kk]v|rev|rd|n|ud|man|r|ig|st|ul|lt|op|fv)inn(a|an)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+		{printHUM1(yytext,1);}

	/*A+AN+OR+ORNA*/
[Ll]"nskollegan "{U}[^\n\t ]+												{ECHO;}
[Ss]nabbsnk(a|an)(" \'"|" \:"|" \""|" ,"|" \(")?" "{U}[^\n\t ]+							{ECHO;}
[^\n ]*([Ff]lick|[Kk]olleg|[Mm]amm|[Pp]app|[Ss]tjrn|rinsess|sett|tv)(a|an)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																			{printHUM1(yytext,1);}
[^\n ]*[]nkan(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+								{printHUM1(yytext,1);}

	/* ARE-AREN-ARNA */
[^\n ]*[Tt]"rnaren "{U}[^\n\t ]*" \" "{U}[^\n\t ]*" \" "{U}[^\n\t ]*							{printHUM1(yytext,1);}
"Ersttare \:"(" "{U}[^\n\t ]*)+(" , "{U}[^\n\t ]*" "{U}[^\n\t ]*)*" och"(" "{U}[^\n\t ]*)+				{printHUM1(yytext,2);}
"Ersttare \:"(" "{U}[^\n\t ]*)+(" , "{U}[^\n\t ]*" "{U}[^\n\t ]*)*								{printHUM1(yytext,2);}
[^\n ]*(affrs|bil|biograf|butiks|bt|bts|caf|fordons|fr|galleri|hotell|hund|hus|hst|jg|kiosk|klubb|klubbs|krog|macks|motell|pizzeria|plantage|pub|ranch|ren|restaurang|stug|stuge|torp|villa)garen(" "{U}[^\n\t ]*)+							{printHUM1(yytext,1);}
(med|tyckte|edger|[Ee]nligt|berttar|menar|sger|anser|sade|sa)" garen"(" "{U}[^\n\t ]*)+				{printHUM1(yytext,2);}
([Hh]ans|sin|stridde)" fregngar"(e|en)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+					{printHUM1(yytext,1);}

[^\n ]*(potek|ytt|luff|[Bb]rott|[Bb]ls|[Bb]ag|[Bb]omb|[Bb]ox|[Bb]ygg|bestig|vbr|[Dd]om|[Dd]yk|[Ee]ftertrd|[Ff]alt|[Ff]lt|[Ff]orsk|[Ff]usk|ildhugg|tenhugg|fatt|rsvar|[Gg]rund|[Hh]andl|[Kk]rg|led|[Ll]k|[Ll]r|[Mm]ak|mobb|[Mm]edl|dikt|hantverk|finn|ilm|ynta|rdd|[Rr]idd|[Mm]l|[Mm]kl|[Mm]st|[Mm]rd|rogrammer|[Rr]app|fficer|tmj[Rr]ed|[Ss]egl|[Ss]egr|ekreter|[Ss]kap|[Ss]kepp|samordn|potek|[Ss]ng|aml|fr|olf|svets)ar(e|en)(" \'"|" \:"|" \""|" \(")?(" "{U}[^\n\t ]*)+												{printHUM1(yytext,1);}
[^\n ]*([Bb]rott|[Bb]ls|[Bb]ag|[Bb]omb|[Bb]ox|[Bb]ygg|bestig|vbr|[Dd]yk|[Ee]ftertrd|[Ff]alt|[Ff]lt|[Ff]orsk|[Ff]usk|ildhugg|tenhugg|fatt|rsvar|[Gg]rund|[Hh]andl|[Kk]rg|[Ll]ed|[Ll]k|[Ll]r|[Mm]ak|[Mm]edl|dikt|hantverk|finn|ilm|ynta|rdd|[Rr]idd|[Mm]l|[Mm]kl|[Mm]rd|rogrammer|[Rr]app|[Rr]ed|[Ss]egl|[Ss]egr|ekreter|[Ss]kap|[Ss]kepp|samordn|[Ss]ng)arna(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?														{printHUM1(yytext,1);}

[^\n ]*(lp|ngkamp|ltskriv|eckn|rovjobb|ockeyjobb|span|vrd|[Ss]pel|[Tt]rn|[Uu]tred|[Uu]tstll|[Vv]inn|[]klag|ventyr|borg|[Dd]ans|ristag|kast|utv)ar(e|en)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+									{printHUM1(yytext,1);}

[Aa]rbetsgivare" "{U}[^\n\t ]+													{ECHO;}
[^\n ]+(is|fall|far|rbryt|belgng|frrtt|giv|gr|hav|jlp|hopp|nvn|kp|lgg|odl|skmp|rgfrslj|skringsslj|mpet|planer|rbet|restnd|retrd|spex|stag|stt|vet|tag|k|skd|vervak|elyft|nk|oast|skt|edicin)ar(e|en)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+	{printHUM1(yytext,1);}
[^\n ]+(fall|far|rbryt|frrtt|giv|gr|hav|jlp|hopp|nvn|kp|lgg|odl|skmp|rgfrslj|skringsslj|mpet|planer|rbet|restnd|retrd|spex|stag|stt|vet|tag|k|skd|vervak|nk)arna(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?																			{printHUM1(yytext,1);}

	/* IKER-IKERN-IKERNA*/
[^\n ]*(afat|aforist|agnost|llerg|stigmat|stmat|botan|iabet|iagnost|ialekt|gocentr|ep|pilept|erot|et|fonet|grammat|herald|heret|iron|kron|log|man|elankol|metod|mim|neurot|nostalg|numismat|opt|aralyt|arano|parod|polem|ragmat|soriat|eumat|chismat|spast|statist|stilist|symfon|anat|fob|sto|etor|atir|enet|lektr|kadem|takt|ekan|yst|omant|enet|ektr|yst|us|atir|fys|nalyt|istor|[Kk]om|[Ll]yr|ykiatr|graf|[Kk]eram|ramat|[Kk]rit|amentar|olit|tekn|eoret|ekan|temat|ag)ikern(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+						{printHUM1(yytext,1);}

[^\n ]*(afat|orist|agnost|llerg|stigmat|stmat|botan|iabet|iagnost|ialekt|gocentr|ep|ilept|erot|et|fonet|grammat|herald|heret|iron|kron|log|man|elankol|metod|mim|neurot|nostalg|numismat|opt|aralyt|arano|parod|polem|ragmat|soriat|eumat|chismat|spast|statist|stilist|symfon|anat|fob|sto|etor|atir|enet|lektr|kadem|takt|ekan|yst|omant|enet|ektr|yst|us|atir|fys|nalyt|istor|[Kk]om|[Ll]yr|ykiatr|graf|[Kk]eram|ramat|[Kk]rit|amentar|olit|tekn|eoret|ekan|temat|ag)iker(" \'"|" \:"|" \"")?(" "{U}[^\n\t ]*)+									{printHUM1(yytext,1);}


[^\n ]*(us|nalyt|istor|[Kk]om|[Ll]yr|sykiatr|graf|[Kk]eram|ramat|[Kk]rit|amentar|olit|tekn)ikerna(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?									{printHUM1(yytext,1);}


	/* ER-ERN-ERNA*/
[^\n ]*([Ss]print|[Gg]angst|[Bb]rod|[Dd]ott|[Dd]esign|[Ff]ad|[Kk]ansl|mod|[Rr]eport|[Ss]vg|[Ss]yst|[Mm]inist|artend|[Mm]anag|partn|[Pp]sykiat|[Ss]kald|kipp)er(n)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+								{printHUM1(yytext,1);}
[^\n ]*(iolinist|[Dd]esign|[Kk]ansl|[Rr]eport|[Ss]vg|[Ss]yst|[Mm]inist|artend|[Mm]anag|partn|[Pp]sykiat|[Ss]kald)erna(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?							{printHUM1(yytext,1);}

	/* OR-ORN-ORER-ORERNA */
[^\n ]*[Pp]rofessor(n)?(" \'"|" \:"|" \""|" ,"|" \(")?" Institutionen"							{ECHO;}
[^\n ]*(ommentat|nspekt|iktat|[Dd]okt|[Ff]arbr|[Kk]urat|[Ll]ekt|[Pp]ast|rofess|[Rr]ekt|[Ss]enat|arrendat|[Rr]evis)or(n)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+														{printHUM1(yytext,1);}
[^\n ]*(nspekt|mmentat|iktat|[Dd]okt|[Ff]arbr|[Kk]urat|[Ll]ekt|[Pp]ast|rofess|[Rr]ekt|[Ss]enat|arrendat|[Rr]evis)or(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?							{printHUM1(yytext,1);}

	/* UN */
[^\n ]*([Ff]|[Hh]ust|gu)r(u|un)(" \'"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+						{printHUM1(yytext,1);}

[^\n ]*(arving|bitrd|blindstyr|brkstak|fartdr|festpriss|forskningsresand|fng|frskall|frbigend|grann|jmlik|knutt|knsvarels|lustigkurr|medskand|meningsfrnd|pappskall|plgoand|roadi|samvetsfng|sidoarving|sjlsfrnd|snuskpell|tokstoll|tronarving|trosfrnd|ingsfng|universalsnill|vingelpell|vgfarand|stm|ambo|lukare|rige|pliktige|herde)n(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+			{printHUM1(yytext,1);}

	/* ARIE */
[^\n ]+(tek|arkiv|extraordin|legat|springvik|prim|recept|vik)arie(n)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																				{printHUM1(yytext,1);}

	/* IST-ISTEN [[Jj]ournal, [Ff]inal */
[^\n ]*(bsolut|altru|angl|antikr|arab|batter|bigam|cembal|kuter|defait|determin|ego|ekvilibr|esperant|excerp|hibition|exorc|faun|fetisch|filatel|flor|folklor|formal|gratial|harp|horn|imperial|individual|kabbal|kalvin|kanot|karrir|klassic|kop|lingv|manikyr|masoch|material|mejer|mod|moped|myter|konform|ykter|optim|riental|pedikyr|fektion|prokur|propagand|radiotelegraf|reform|relativ|roman|semit|slav|sof|spirit|spiritual|stat|tandhygien|telegraf|universal|utop|iet|ymbol|te|apt|cykl|rt|enor|[Aa]ktiv|[Bb]il|[Ee]ss|nal|[Ff]ljt|[Gg]itarr|fon|[Hh]eroin|[Hh]umor|[Jj]ur|[Kk]em|[Kk]ommun|[Mm]askin|ian|[Pp]opul|[Ss]ol|cial|rombon|[Tt]ur|rgan|ror|lkohol|rinett|board|otan|az|ller|[Bb]as|eal|vell|iolin|ontor|ournal|part|obby|ivi|ural|sad|strial|lumn|ell|ption|ras|rett|xtrem|udd|kal|pital|rosa|umental|erman|emin|nark|ell|ndolin|emin|lpin|enin|hauvin|sion|uman|lon|eron|mpon)ist(en)?(" \'"|" \:"|" \""|" ,")?(" "{U}[^ \n\:]*)+										{printHUM1(yytext,1);}

[^\n ]*(cykl|rt|enor|[Aa]ktiv|[Bb]il|[Ee]ss|nal|[Ff]ljt|[Gg]itarr|fon|[Hh]eroin|[Hh]umor|[Jj]ur|[Kk]em|[Kk]ommun|[Mm]askin|ian|[Pp]opul|[Ss]ol|cial|rombon|[Tt]ur|rgan|ror|lkohol|rinett|board|otan|az|ller|[Bb]as|eal|vell|iolin|ontor|ournal|part|obby|ivi|ural|sad|strial|lumn|ell|ption|ras|rett|xtrem|udd|kal|pital|rosa|umental)ist(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^ \n\:]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?																		{printHUM1(yytext,1);}

	/* ANT-ANTEN-ANTER */
tant(en)?(" \'"|" \:"|" \""|" ,")?(" "{U}[^\n\t ]*)+										{printHUM1(yytext,1);}
[^\n ]*(ommend|serge|rotest|[Dd]ebut|[Ff]abrik|[Ll]jtn|raktik|[Pp]redik|[Rr]epresent|T|sagot|kafet|bankt|adjut|hyrest|matt|sionrst)ant(en)?(" \'"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+										{printHUM1(yytext,1);}
[^\n ]*([Dd]ebut|[Ff]abrik|[Ll]jtn|raktik|[Pp]redik|[Rr]epresent|[Tt])ant(er|erna)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?									{printHUM1(yytext,1);}

	/* ENT-ENTEN-ENTER */
	/* sident OK */
[^\n ]*([Aa]g|[Aa]ssist|[Dd]irig|[Dd]oc|[Pp]ati|sid|[Pp]roduc|[Ss]tud|eces|[Ii]nted|[Ii]ntend|krib|ispon)ent(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+													{printHUM1(yytext,1);}
[^\n ]*([Aa]g|[Aa]ssist|[Dd]irig|[Dd]oc|[Pp]ati|sid|[Pp]roduc|[Ss]tud|eces|nted|krib)ent(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?									{printHUM1(yytext,1);}

	/* AT-ATEN-ATER */
[^\n ]+(enator|ansler|nster|edicin|anslers|sdags|resident|andslags|ledar|sonvals|positions|inister|vignings|parti|rdfrande|rds)kandidat(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+										{printHUM1(yytext,1);}
[^\n ]+(enator|ansler|nster|edicin|anslers|sdags|resident|andslags|ledar|sonvals|positions|inister|vignings|parti|rdfrande|rds)kandidat(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?				{printHUM1(yytext,1);}

[^\n ]*(ljemagn|kastr|[Aa]dvok|[Dd]emokr|[Dd]iplom|[Mm]oder|kamr)at(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+	{printHUM1(yytext,1);}
[^\n ]*([Aa]dvok|[Dd]emokr|[Dd]iplom|[Mm]oder|kamr)at(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?														{printHUM1(yytext,1);}

	/*KTR+KTREN+KTRER*/
[^\n ]*(esinfe|introdu|kondu|le|proje|tra|vivise|stru|[Dd]ire|[Ii]nspe|[Rr]eda|orra|filmsa)ktr(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																{printHUM1(yytext,1);}
[^\n ]*(stru|[Dd]ire|[Ii]nspe|[Rr]eda|orra|filmsa)ktr(er|erna)(" \:"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?																{printHUM1(yytext,1);}

	/*R+REN+RER*/
	/* [Ll]everant not GOOD => ORG */

[^\n ]*ationsmarkr(en)?(" \'"|" \:"|" \""|" ,"|" \(")?" "{U}[^\n\t ]+						{ECHO;}

[^\n ]*(abort|kompanjat|ackusch|ackvisit|ministrat|affisch|annons|bankrutt|cisel|dans|dekorat|emonstrat|desert|detach|diskont|dispasch|dompt|emalj|exekut|export|flan|frond|grav|ypnotis|improvisat|nfiltrat|inspirat|installat|nterlokut|intrig|jongl|ollaborat|olonisat|kommunikat|konnss|konspirat|kontroll|kooperat|litterat|mark|mask|min|mont|navigat|observat|organisat|pik|portrtt|pos|presentat|rapport|rekvisit|reparat|reson|revolt|sabot|semin|servit|skrod|smink|spedit|stuckat|suffl|sympatis|srmark|vaccinat|voltig|llustrat|provokat|ks|ebatt|rnik|ass|[Aa]mat|mbassad|[Ff]abrik|uvern|[Ii]nformat|ngenj|omposit|[Kk]rnik|edalj|egiss|imat|kommend|sprkr|[Kk]ass|ebat|kulpt|fris)r(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																{printHUM1(yytext,1);}


[^\n ]*(ass|[Aa]mat|[Aa]mbassad[Ff]abrik|[Gg]uvern|[Ii]nformat|[Ii]ngenj|[Kk]omposit|[Kk]rnik|[Mm]edalj|[Rr]edakt|[Rr]egiss|imat|kommend|ebat)r(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?				{printHUM1(yytext,1);}

	/*LOGEN-LOGER-LOGERNA*/
[^\n ]*(genea|minera|algo|astro|akterio|balneo|bryo|ermato|mbryo|dokrino|eto|etymo|armako|filo|glacio|grafo|hippo|histo|iktyo|indo|kremlo|lexiko|usiko|myko|odonto|paleonto|pomo|runo|ermino|oxik|rdi|adi|osmet|mun|ynek|rnit|ek|ism|ex|sin|pat|ide|ysi|osm|ntom|vir|gypt|zo|ydr|rke|[Bb]i|eteor|[Gg]e|trop|oci|syk|eur|imin|demi|te|tn|tesio)olog(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+				{printHUM1(yytext,1);}

[^\n ]*(sin|pat|ide|ysi|osm|ntom|vir|gypt|zo|ydr|rke|[Bb]i|eteor|[Gg]e|trop|oci|syk|eur|imin|demi|te|tn)olog(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?							{printHUM1(yytext,1);}


	/*REN+RER+RERNA (pensionr, missionr,...)*/
[^\n ]*(olont|eterin|sion|[Mm]iljard|finansi|miljon|konstn)r(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+	{printHUM1(yytext,1);}
[^\n ]*(eterin|sion|[Mm]iljard|finansi|miljon|konstn)r(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?														{printHUM1(yytext,1);}

	/*ISEN+ISER+ISERNA*/
[^\n ]*(kulptr|akt|knd|old|[Mm]ark|rvitr|duktr|[Aa]ktr|[Nn]rpol|riminalpol|rdningspol|rumm|lod)is(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+														{printHUM1(yytext,1);}
[^\n ]*(rvitr|duktr|[Aa]ktr|[Nn]rpol|riminalpol|rdningspol)is(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?												{printHUM1(yytext,1);}

	/*KTEN+KTER+KTERNA*/
[^\n ]*(dida|rkite|[Aa]djun|refe|[Ss]l|[Vv]a)kt(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+			{printHUM1(yytext,1);}
[^\n ]*(rkite|[Aa]djun|refe|[Ss]l|[Vv]a)kt(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?																{printHUM1(yytext,1);}

	/*ETEN+ETER+ETERNA*/
[^\n ]*([Pp]rof|stmagn|rsonligh|[Pp]o)et(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+				{printHUM1(yytext,1);}
[^\n ]*([Pp]rof|stmagn|rsonligh|[Pp]o)et(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?																{printHUM1(yytext,1);}

	/*FEN+FER+FERNA*/
[^\n ]*(tnogra|ypogra|togra|[Ff]iloso|cenogra|[Cc]he|eoso)f(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+	{printHUM1(yytext,1);}
[^\n ]*(togra|[Ff]iloso|cenogra|[Cc]he)f(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?																	{printHUM1(yytext,1);}

	/* MEN+MARNA */
[^\n ]*(IOK\-|tyrelse|edaktions|jury|parti|mitt|band)medlem(men)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+	{printHUM1(yytext,1);}
[^\n ]*(IOK\-|tyrelse|edaktions|jury|parti|mitt|band)medlem(mar|marna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?												{printHUM1(yytext,1);}

	/* STEN */
[^\n ]*([Pp]r|ymna|g|pro)st(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+					{printHUM1(yytext,1);}
[^\n ]*([Pp]r|ymna|g)st(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?																			{printHUM1(yytext,1);}

	/* SEN */
[^\n ]*(lillt|[Dd]ans|landst|majt|medalj)s(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+				{printHUM1(yytext,1);}

	/* INEN */
[^\n ]*(ongmask|[Rr]abb|blond|[Kk]us)in(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+				{printHUM1(yytext,1);}

	/* POLISEN */
[^\n ]*(MC\-|trafik|tull|varters|ykel|ymd)polis(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+			{printHUM1(yytext,1);}

	/*EN+ER+ERNA*/
"Kung Fu"\-[^\n ]+													{ECHO;}
"Kung Fu"														{ECHO;}
(Klverkung|Ruterkung)" Syd"												{ECHO;}
"General "(Electric|Film|Motors)											{ECHO;}

[^\n ]*(ardinal|profil|irtuos|radikal|ldsjl|[Ii]mam|ultan|aryton|etektiv|[Bb]ond|[Aa]miral|[Bb]iskop|[Gg]eneral|eograf|[Hh]yresvrd|[Kk]apten|[Mm]ajor|dagog|[Pp]ilot|[Pp]rins|[Ss]chejk|erapeut|[Bb]aron|bas|boss|[Ii]dol|clown|elev|konom|stronom|expert|[Ff]amilj|lykting|orward|tomodell|nrik|gestalt|[Kk]ock|mpanjon|nditor|[Tt]jej|rollkarl|onsul|onsulent|onsult|kund|[Kk]usk|[Mm]arskalk|[Mm]atros|[Mm]uslim|lskytt|lsskytt|naut|atriark|[Mm]ogul|ilmlegend|bollslegend|atolik|[Ss]hejk|[Ss]kald|[Ss]opran|trateg|[Tt]enor|ppmodell|rurg|rubadur|[Ff]amilj|[Ss]ultan|eteran|alang|ogoped|[Bb]ankir|kning|demagog)(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+						{printHUM1(yytext,1);}

[^\n ]*(trept|yl)okock(er|erna)(" \:"|" ,"|" \(")?" "[A-Z]+[^\n ]+									{ECHO;}
[^\n ]*(unior|[Aa]miral|[Bb]iskop|[Dd]anss|[Gg]eneral|eograf|[Hh]yresvrd|[Kk]apten|[Mm]ajor|dagog|[Pp]ilot|[Pp]rins|[Ss]chejk|erapeut|[Tt]sar|[Bb]aron|bas|boss|[Ii]dol|clown|[Ee]lev|konom|expert|[Ff]amilj|lykting|orward|tomodell|nrik|gestalt|[Kk]ock|mpanjon|nditor|[Tt]jej|[Kk]usin|onsul|onsulent|onsult|kund|[Kk]usk|[Mm]arskalk|[Mm]atros|[Mm]uslim|lskytt|naut|atriark|[Ss]opran|trateg|[Tt]enor|ppmodell|rurg|rubadur|[Ff]amilj|[Ss]ultan|eteran)(er|erna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?		{printHUM1(yytext,1);}

	/*EN+ARNA*/
[^\n ]*([Kk]ung|onung|fficer|ublikan|gubb|[Gg]oss|drng|[Cc]oach|[Kk]ompis|[Ss]kdis|[]ttling|back|lnning|ottning|rummis|[Ss]kurk|rmling|ring|vding|[Mm]unk|knning|\-kill|forskill|rmkill)(en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+			{printHUM1(yytext,1);}
[^\n ]*([Gg]oss|drng|[Cc]oach|[Kk]ompis|[Ss]kdis|[]ttling|back|lnning|ottning|rummis|[Ss]kurk|rmling|ring|vding|[Mm]unk|knning|[Pp]rins|[Kk]ung)(ar|arna)(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?		{printHUM1(yytext,1);}

	/*RDET+EN*/
[^\n ]+(epartements|munal|tings|ess|gion|tads|tats|rgar|rtts|rikes)rd(et|en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																		{printHUM1(yytext,1);}

	/*ET+EN*/
[^\n ]+(bbot|rrskap|mbud|roffs|rvrv)(et|en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+				{printHUM1(yytext,1);}

	/*+ NA */
[^\n ]*(inistra|eportra|[Mm]dra|[Ff]rua|ttra|orska|[Hh]erra|usike|ystra|[Ss]ne|villinga|[Pp]olise|postla)rna(" \:"|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?								{printHUM1(yytext,1);}

	/* TITLE */
"herr Gurka"															{ECHO;}
"Miss Saigon"															{ECHO;}
"Madame Butterfly"														{ECHO;}
"En af Stockholms"														{ECHO;}
(Chr|Alexandr|Pehr|Tohr|Yassir|Aleksandr)(" "{U}[^\n\t ]*)+									{printHUM1(yytext,0);}
({U}[^\n\t ]*" ")+"bin al\-"{U}[^\n\t ]*											{printHUM1(yytext,0);}
"Abd al\-"{U}[^\n\t ]*														{printHUM1(yytext,0);}
({U}[^\n\t ]*" ")+("van der"|"van den"|bin|al|af|der|van|[Vv]on|abu)(" "{U}[^\n\t ]*)+					{printHUM1(yytext,0);}

(dtr|L|Af|Al|[Dd]\:r|[Dd]r|[Dd]r\.|[Ff]ru|[Hh]err|[Hh]r|[Mm]r|[Mm]r\.|[Mm]rs|[Ss]ir|Do[kc]tor|B\:n|B)" "{U}\." "({U}[^\n\t ]*)+																		{printHUM1(yytext,1);}
[^\n ]*(fru|\-VD\:n|[Mm]amsell|[Mm]ademoiselle)(" "{U}[^\n\t ]*)+								{printHUM1(yytext,1);}
(ex\-VD|[Vv][Dd]|[Vv][Dd]\:n)(" "{U}[^\n\t ][^\n\t ]*)+									{printHUM1(yytext,1);}

(dtr|L|Af|Al|[Dd]\:r|Der|DJ|[Dd]r|[Dd]r\.|[Ff]ru|[Hh]err|[Hh]r|[Ll]ady|[Ll]ord|[Mm]adame|[Mm]iss|[Mm]onsieur|[Mm]r|[Mm]r\.|[Mm]rs|[Pp]rince|[Pp]rincess|[Ss]enior|[Ss]enor|[Ss]eor|[Ss]eora|[Ss]eorita|[Aa]yatollah|[Ss]ignor|[Ss]ignorina|[Ss]ir|Do[kc]tor|[Mm]ster|Ms\.?|B\:n|B|doa|[Tt]sar|Van|"Van den"|"Van der")(" "{U}[^\n\t ]*)+										{printHUM1(yytext,0);}

	/* CASES THAT DO NOT FIT TO THE PREVIOUS */
[^\n ]*([Ss]ystrarna|[Pp]aret)(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" och"(" "{U}[^\n\t ]*)+)?				{printHUM1(yytext,1);}
"Frken Julie"															{ECHO;}

[^\n ]*isstnkt(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[a-z][^\n\t ]*)+		{/*cause, misstnkt UUU(disease)*/printHUM1(yytext,1);}
[^\n ]*(ttachn|ggravida|populistiske|emir|sambo|riherre|sundsbon|glvsbon|oktorand|[Mm]atros|farao|sonson|[Ss]onen|mor|seudonymen|sinnige|oderate|hyperaktive|muftin|avlidne|mesen|[Bb]lvite|amanuens|[Pp]aret|[Bb]imbon|kicklige|[Aa]nsvarige|korpral|rottsoraklet|fulle|ktuelle|elake|[]B|[Ff]rken|damen|ladyn|prkrr|vntansfull|patriotisk|erfarne|rjunge|[Rr]abbi|diakonissa|ofjunkar)(" \'"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																	{printHUM1(yytext,1);}

[^\n ]*(tskrivar[Bb]itrd|[Rr]ockar|[Pp]v|[Gg]oss)(e|en)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+		{printHUM1(yytext,1);}
[^\n ]*(ysko|[Bb]ar)nen(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" och"(" "{U}[^\n\t ]*)+)?	{printHUM1(yytext,1);}
[^\n ]*[Bb]arnet(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+								{printHUM1(yytext,1);}
"Brderna Lejonhjrta"														{ECHO;}
[^\n ]*[Bb]r(order|ordern|der|derna|or|orsa|orsan)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" och"(" "{U}[^\n\t ]*)+)?																{printHUM1(yytext,1);}
[^\n ]*(portie|hauff)(r|ren)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+						{printHUM1(yytext,1);}
[^\n ]*([Hh]istorik|rooki|[Kk]araktr|alligraf)en(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+			{printHUM1(yytext,1);}
[^\n ]*([Ff]ars|[Kk]olleg)(a|an)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+						{printHUM1(yytext,1);}
[^\n ]*[Kk]olleg(er|or|orna|erna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?																	{printHUM1(yytext,1);}
[^\n ]*[Kk]ommissari(e|en|er|erna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+					{printHUM1(yytext,1);}
[^\n ]*[Ll]edam(ot|oten)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+							{printHUM1(yytext,1);}
[^\n ]*edam(ter|terna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" "(och|eller)(" "{U}[^\n\t ]*)+)?																		{printHUM1(yytext,1);}
[^\n ]*([Mm]ak|[Hh]jlt)(e|en|ar|arna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+					{printHUM1(yytext,1);}

[^\n ]*[Oo]rdfrand(e|en)(" \'"|" \:"|" \""|" ,"|" \(")?" "Lkemedelsvrlden		{ECHO;}

[^\n ]*([Hh]erd|[]verst|fverste|[Vv]ittn|[Oo]rdfrand)(e|en|ena)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+	{printHUM1(yytext,1);}
[^\n ]*[Ss]ndebud(et|en)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+							{printHUM1(yytext,1);}
[^\n ]+[]ri(ga|ge)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+								{printHUM1(yytext,1);}
[^\n ]*([Kk]ejsar|commandant)(e|en)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+					{printHUM1(yytext,1);}
[^\n ]*(konsul|konstapel|maka|kmpe|[Pp]romotor|[Jj]ockey|[Hh]usse|[Gg]reve|[Gg]refve|[Tt]utor|[Ss]yrra|[Mm]oster|[Ff]aster|[Mm]ulla|arfar|studerande|orfar|farsfar)(n)?(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+								{printHUM1(yytext,1);}

([Tt]rnar|[Cc]oach|[Dd]omar|[Ll]andslags|[Aa]nfalls[Mm]edlar)duon(" "{U}[^\n\t ]*)+(" , "{U}[^\n\t ]*" "{U}[^\n\t ]*)*" och"(" "{U}[^\n\t ]*)+															{printHUM1(yytext,1);}

	/* PATTERNS THAT MATCH A LOT...*/
	/* NAME INITIAL */

^{U}[^\n\t ]+" "{U}[^\n\t ]+" \, "[^\n ]+" "[^\n ]*(analytiker|fessor|fattare|ister|chef|srd|sarie|graf|tr|ledare|rektor|frande)[^\n ]*																	{printHUM2(yytext,30);}
	/* MOD (Jyrki Niemi): The following rule was split into two
	   because of the different number of spaces in the context:
	   ^{U}[^\n\t ]+" "{U}[^\n\t ]+" \, "(professor|expert|leg|knd|"t f"|tf|[^\n ]*makaren)					{printHUM2(yytext,20);}
	 */
^{U}[^\n\t ]+" "{U}[^\n\t ]+" \, "(professor|expert|leg|knd|tf|[^\n ]*makaren)					{printHUM2(yytext,20);}
^{U}[^\n\t ]+" "{U}[^\n\t ]+" \, t f"					{printHUM2(yytext,30);}
^{U}[^\n\t ]+" "{U}[^\n\t ]+" r "[^\n ]*("en person"|[1-9][0-9]" r")							{printHUM2(yytext,30);}
^{U}[^\n\t ]+" "{U}[^\n\t ]+" r "[^\n ]*(ansvarig|arie|besviken|bosatt|chef|docent|essor|fil|fdd|ist|ister|kare|inna|kritiker|ledamot|ledare|lektor|log|misstnkte|orand|personen|person|rande|rare|strateg|stlld|sker|tare|tillbaka|vuxen|ttare|erande)							{printHUM2(yytext,20);}

^"Men "{U}[^\n\t ]+(" som")?" tackade"												{ECHO;}
^{U}[^\n\t ]+" "{U}[^\n\t ]+(" som")?" "(bor|befann|tackade)						{printHUM2(yytext,10);}
^{U}[^\n\t ]+" "{U}[^\n\t ]+(" som")?" "("r fdd")								{printHUM2(yytext,20);}

^{U}[^\n\t ]+" "{U}[^\n\t ]+" \, "[0-9][0-9]?" \,"										{printHUM2(yytext,30);}
^"Och USA sger"														{ECHO;}
^{U}[^ \n\:]+" "{U}[^\n\t ][^\n\t ]+" "(sitter|jobbade|adopterade|sger|mumlade|nickade|talade|berttade|dog|eftertrd|ddades|tipsade|tipsar|framhller|framhll|mlade|skrattade)																	{printHUM2(yytext,10);}
^{U}[^\n\t ]+" "{U}[^\n\t ]+" "("vxte upp"|"brukar sga"|"heter han"|"spelar en")						{printHUM2(yytext,20);}
^{U}[^\n\t ]+" "{U}[^\n\t ]+" har "(arbet|bertt|dokumenter|fotografer|regisser|funder|trttn|studer|jobb|regisser|skildr)at																			{printHUM2(yytext,20);}
^{U}[^\n\t ]+" "{U}[^\n\t ]+" har "(bott|frstelse|frsttt|frsttt|iscensatt|lst|sagt|sjlv|skrivit|suttit|uppfunnit|uttryckt|versatt)																	{printHUM2(yytext,20);}

	/* anyware in a sentence */
	/* MOD (Jyrki Niemi): Added missing leading space to "talar om"
	   and "talade om":
	   {U}[^ \&\:\n]+[^ \&\:\n][^ \&\:\n]" "{U}[^ \&\:\n][^ \&\:\n]+(" och hans"|" och hennes"|" arbetar som"|"talar om"|"talade om")				{printHUM2(yytext,20);}
	 */
{U}[^ \&\:\n]+[^ \&\:\n][^ \&\:\n]" "{U}[^ \&\:\n][^ \&\:\n]+" "("och hans"|"och hennes"|"arbetar som"|"talar om"|"talade om")	{printHUM2(yytext,20);}

	/* Common Arabic */
[^\n\t ]*(sger|sade|rige|president|familjen|minister|jordaniern)" al\-"[^\n\t ]+(" "{U}[^\n\t ]+)*			{printHUM2(yytext,1);}

	/* TRAILING */
(Av|huvudpersonen)" "{U}[^\n\t ]+(" "{U}[^\n\t ]*)+								{/*minst 2 names*/printHUM3(yytext,1);}
(cenografi|[Ss]olister|edverkande|[Aa]rtister|[Rr]ollerna|[Tt]ext|[Tt]eckning|[Kk]oreografi|Ljusdesign|Bild|Av)" :"(" "{U}[^\n\t ]*)+(" , "{U}[^\n\t ]*" "{U}[^\n\t ]*)*" och"(" "{U}[^\n\t ]*)+									{printHUM3(yytext,2);}
([Dd]irigent|[Tt]ext|[Tt]eckning|[Kk]oreografi|[Rr]ollerna)" \:"(" "{U}[^\n\t ][^\n\t ]+)+(" , "{U}[^\n\t ]*" "{U}[^\n\t ]*)*(" "\.|" "m_fl|" m fl")?																{printHUM3(yytext,2);}
	/* MOD (Jyrki Niemi): The following rule was split into two
	   because of variable number of words in left context:
	   (man|person)(" som")?" "(hette|kallas|kallad|kallades)(" \'"|" \"")(" "{U}[^\n ]*)+(" \'"|" \"")				{printHUM3(yytext,2);}
	 */
(man|person)" "(hette|kallas|kallad|kallades)(" \'"|" \"")(" "{U}[^\n ]*)+(" \'"|" \"")				{printHUM3(yytext,2);}
(man|person)" som "(hette|kallas|kallad|kallades)(" \'"|" \"")(" "{U}[^\n ]*)+(" \'"|" \"")				{printHUM3(yytext,3);}
{U}[^\n\t ]+" "{U}[^\n\t ]+" eftertrder"(" "{U}[^\n\t ]*)+									{printHUM3(yytext,0);}
"tror bde"(" "{U}[^\n\t ]*)+" och"(" "{U}[^\n\t ]*)+									{printHUM3(yytext,2);}
"spelas av Teater "{U}[^\n\t ]*(" "{U}[^\n\t ]*)+										{ECHO;}
(Musik|spelas|framspelad|[Ff]rispelad|spelad|filmer|mlad|assisterad|dirigerad|fotograferad|frfattad|gestaltad|komponerad|redigerad|ritad|skapad|tolkad|trnad|versatt)" av "{U}[^\n\t ]*(" "{U}[^\n\t ]*)+								{printHUM3(yytext,2);}
(leds|ledd|[Mm]lning|mlningar|pjser|roman|opera|skrevs|manus|inkarnerad|tonsatt|ledning|portrt|frord|utvisningen|operett|regi|ml|grattas|gratuleras|mlningar|utstllning|regisserad|gestaltas|sng|snger|gestaltades|portrtt|fredrag|minne|novell|skriven)" av "{U}[^ \n\:\-]*(" "{U}[^\n\t ]*)+														{printHUM3(yytext,2);}
"huvudrollen som"(" "{U}[^\n\t ]*)+												{printHUM3(yytext,2);}
[^\n\t ]*(ulturpersonligheter|kndisar|personer|flicka)" som"(" "{U}[^\n\t ]*)+(" , "{U}[^\n\t ]*" "{U}[^\n\t ]*)*" och"(" "{U}[^\n\t ]*)+																	{printHUM3(yytext,2);}
[^\n ]*(dam|nsk|sof|olog|yngling|are|herre|ist|kvinna|kompis|kusin|gosse|bror|person|kille|son|dotter|tjej|vn|gst|pojke|man|mnniska)" "("som heter"|"vid namn")(" "{U}[^\n\t ]*)+												{printHUM3(yytext,3);}
"kallar "(honom|henne)" \""(" "{U}[^\n\t ]*)+" \""										{printHUM3(yytext,2);}
"set mot "{U}[^\n\t ]*(" "{U}[^\n\t ]*)+											{printHUM3(yytext,2);}
"starke man "{U}[^\n\t ]*(" "{U}[^\n\t ]*)+											{printHUM3(yytext,2);}
(knskada|[Mm]ordet|angrepp)" p "{U}[^\n\t ]*(" "{U}[^\n\t ]*)+								{printHUM3(yytext,2);}
(samtal|kamrat|intervjun|ktenskap|[Gg]ift|[Ss]ambo|soulmusik)" med "{U}[^\n\t ]*(" "{U}[^\n\t ]*)+			{printHUM3(yytext,2);}
(vn|nhriga|medarbetare|syster|son|bror|kusin|dottern|eftertrdare)" till "{U}[^\n\t ]*(" "{U}[^\n\t ]*)+		{printHUM3(yytext,2);}
([Jj]ag|[Hh]on|[Hh]an|[^\n ]*chefen|[^\n ]*rdfrande|kansler|man)" heter"(" "{U}[^\n\t ]*)+				{printHUM3(yytext,2);}

	/* With VERBS */
(skratt|argumenter|reflekter|hvd|ppek|kommenter|bertt|konstater|frklar|frg|men)a(r|de|t)(" "{U}[^\n\t ]*)+" "(Telegraph|Tidning|Allehanda|Folkblad|Industri|Nyheter|Socialdemokraten|Dagblad|Spo)				{ECHO;}
(argumentera|reflektera|hvda|ppeka|kommentera|bertta|konstatera|frklara|frga|mena|sge)(r|de|t)" "[^\n ]*(frbundet|ommissionen|Socialstyrelsen|Amnesty|Jmo|Aftonbladet|Uppsala|SVT|SvD|Expressen|SAS|Kvllsposten|ndsposten|Dagens|inspektionen)																{ECHO;}

(argumenter|reflekter|hvd|ppek|kommenter|bertt|konstater|frklar|frg|men|skmt)a(r|de|t)" "{U}[^\n\t ]*(en|\:|n|t|g|a|k|e)s" "(VD|[a-eg-z][^\n\t ]+)(" \,")?(" "{U}[^\n\t ]*)+									{/*berttar Mattias fr GP*/printHUM4(yytext,2);}

(argumenter|reflekter|hvd|ppek|kommenter|bertt|konstater|frklar|frg|men)a(r|de|t)" "{U}{U}{U}?		{ECHO;}
(argumenter|reflekter|hvd|ppek|kommenter|bertt|konstater|frklar|frg|men)a(r|de|t)" "{U}[^\n\t ]*verket	{ECHO;}

(skoj|rop|suck|klag|argumenter|reflekter|hvd|ppek|kommenter|bertt|konstater|frklar|frg|men)a(r|de|t)(" "{U}[^ \:\n]*)+																			{printHUM4(yytext,1);}
(skrek|utbrast)(" "{U}[a-z][a-z][^ \:\n]*)+											{printHUM4(yytext,1);}
s(a|ade|ger)" "{U}[^\n\t ]+s" "[Vv][Dd](" "{U}[^ \n\:]+)+									{printHUM4(yytext,3);}
sger(" "{U}[^ \n\:]+)+													{printHUM4(yytext,1);}

" sade "{U}[^\n\:A-Z ]+" "(i|vid|p)	{int i=6; printf(" sade <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
			for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>"); for(;i<yyleng; putchar(yytext[i++]));}
" sa "{U}[^\n\:A-Z ]+" "(i|vid|p)	{int i=4; printf(" sa <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
			for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>"); for(;i<yyleng; putchar(yytext[i++]));}
{U}[^\n\: ]+s" "[^\n ]*(visit|novell|sambo|hustru|pappa|syster)	{int i=0; printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">");
			for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>"); for(;i<yyleng; putchar(yytext[i++]));}
(von|sor)(" "{U}[^\n\t ]+)+													{printHUM4(yytext,0);}
[^\n ]+(ngr|krain|gentin|ustraliens|elg|rasilian|inlnd|teborg|ollnd|rlnd|talien|anadens|ederlnd|chweiz|sterrik|holm|istans)ar(e|en)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+											{printHUMN1(yytext,1);}
[^\n ]+(gentin|ustraliens|elg|rasilian|inlnd|teborg|ollnd|rlnd|talien|anadens|ederlnd|chweiz|sterrik|holm)arna(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" och"(" "{U}[^\n\t ]*)+)?								{printHUMN1(yytext,1);}
[^\n ]*(lgeri|itau|anzani|raki|ustrali|ordani|ndonesi)ern(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+		{printHUMN1(yytext,1);}
Rochester															{ECHO;}
[Ee]"st"(er|erna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+(" och"(" "{U}[^\n\t ]*)+)?				{printHUMN1(yytext,1);}
[Ee]sten(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+									{printHUMN1(yytext,0);}
[^\n ]*(amaican|[Aa]rab|olombian|portugis|jugoslav|orean|ngrar|igerianen|katalan|[Aa]frikan|[Aa]merikan|rasilian|[Bb]ritt|[Gg]rek|[Ii]srael|[Kk]enyan|[Kk]roat|[Kk]uban|uadorian|kines|enegales|ulgar|udanes|kurd|ghanan)en(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																				{printHUMN1(yytext,1);}
[^\n ]*([Aa]frikan|[Aa]merikan|rasilian|[Bb]ritt|[Gg]rek|[Ii]srael|[Kk]enyan|[Kk]roat|[Kk]uban|uadorian|kines)(er|erna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" och"(" "{U}[^\n\t ]*)+)?							{printHUMN1(yytext,1);}

[^\n ]*([Mm]exikan|[Mm]arockan|[Pp]eruan|[Pp]olack|[Rr]umn|[Ss]erb|[Ss]lovak|[Ss]panjor|[Tt]jeck|turk)en(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+														{printHUMN1(yytext,1);}
[^\n ]*([Mm]arockan|[Pp]eruan|[Pp]olack|[Rr]umn|[Ss]erb|[Ss]lovak|[Ss]panjor|[Tt]jeck|orean)(er|erna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" och"(" "{U}[^\n\t ]*)+)?								{printHUMN1(yytext,1);}

[^\n ]*([Dd]ansk|[Ss]vensk)(en|e)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+						{printHUMN1(yytext,1);}
[^\n ]*(walesar|lndar|[Bb]rass|[Rr]yss|[Ss]kott|[Tt]ysk|lnning|lndar|[Jj]apan|belgar|hilenar)(e|en)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+														{printHUMN1(yytext,1);}
[^\n ]*([Bb]rass|[Dd]ansk|[Rr]ys|[Ss]kott|[Ss]vensk|[Tt]ysk|lnning|lnd)(ar|arna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" och"(" "{U}[^\n\t ]*)+)?										{printHUMN1(yytext,1);}
([Ll]iby|[Pp]akistani|[Pp]alestini|ustrali)ern(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+				{printHUMN1(yytext,1);}
[^\n ]*([Aa]afrikan|[Aa]merikan|[Rr]y|[Rr]umn|[Ss]pan|[Ff]inlnd|[Jj]apan|Sven)(ske)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																		{printHUMN1(yytext,1);}

[^\n ]*(ustrali|unger|rlnd[Jj]apan|[]sterriki|[Rr]y|ritti|kroati|igerian)skan(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																		{printHUMN2(yytext,1);}
[^\n ]*(uban|[Bb]ulgari|[Ff]ransy|[Ss]panjor|[Rr]umn|ebor|krain)(ska|skan)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+																			{printHUMN2(yytext,1);}
[^\n ]*(merikan|[Tt]y|[Ss]ven|inesi|[Bb]ulgari|[Ff]ransy|[Jj]apan|[Nn]or|[]sterriki|[Rr]y|[Ss]panjor|bor)(skor|skorna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" och"(" "{U}[^\n\t ]*)+)?							{printHUMN2(yytext,1);}

[^\n ]*(kinesi|korean|afrikan|aiwanesi|[Ll]itaui|[Ff]in|lovaki|[Pp]ol|[Rr]umnn|merikan|[Tt]y|[Nn]or|[Ii]talien)skan(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+													{printHUMN2(yytext,1);}

[Aa]merikan(arna|er|erna)(" \'"|" \:"|" \""|" ,"|" \(")?(" "{U}[^\n\t ]*)+([ \,]+{U}[^\n\t ]*)*(" och"(" "{U}[^\n\t ]*)+)?	{printHUMN1(yytext,1);}


"poutses mble"															{printf("XXXXX");}
\n	{ECHO;}
.	{ECHO;}
%%

int printMTH(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"PRS\" SBT=\"MTH\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"MTH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"MTH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}

return(1); }

int printCLC(char *a,int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"PRS\" SBT=\"CLC\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"CLC\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"CLC\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"PRS\" SBT=\"CLC\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1); }

int printANM(char *a,int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"PRS\" SBT=\"ANM\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==5){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==6){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==10){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==20){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==30){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==40){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==50){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"PRS\" SBT=\"ANM\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}

return(1); }

int printHUM1(char *a,int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1); }

int printHUM2(char *a,int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">%s</ENAMEX>",yytext);
else if (x==10){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==20){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==30){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1); }

int printHUM3(char *a,int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1); }

int printHUM4(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
for(;yytext[z]!=' ';putchar(yytext[z++]));
while(yytext[c]!=' ') c--; 
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1); }

int printHUMN1(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">%s</ENAMEX>",yytext);

else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}

return(1); }

int printHUMN2(char *a,int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"PRS\" SBT=\"HUM\">%s</ENAMEX>",yytext);

else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"PRS\" SBT=\"HUM\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}

return(1); }

main( argc, argv )
int argc;
char **argv;
{
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  yylex(); return(0);
}

