/*
          File: OrgWsp.ll
          Author: Dimitrios Kokkinakis
          version: 090410
*/
%{
%}
U	[\101-\132\300-\335\&\_]
%{
  int printTVR  (char *a);
  int printPLT  (char *a);
  int printCRP  (char *a);
  int printATH  (char *a);
  int printCLT  (char *a);
  int printARL  (char *a);
  int printEDU  (char *a);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|MDC|TRM)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDA|MDD|MDI|MDP|MDO|MDC|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|FRQ|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"\<TIMEX TYPE\="\"TME"\" SBT\=\""(DAT)\"\>[^\n\<]+"\<\/TIMEX\>"	{ECHO;}
	/* AIRINDUSTRI */
	/* => TRANSPORT (Aeronautic, Railway, Navy ?*/
(Flygalliansen|"Aerospatiale of")(" "{U}[^\n ]+)+	{printARL(yytext);}
"Boeing Aerospace "[^\n ]+" Electronics"	{printARL(yytext);}
"Air "(France|Saint\-[^\n ]+)	{printARL(yytext);}
"Pan American "[^\n ]+" Organization"	{printARL(yytext);}
	/* AIR (TRANSPORT) */
({U}[^ \n\>\<]+" ")+A(erospatiale|ir|irway|irline|viation)(s)?(" "{U}[^ \n]+)*	{printARL(yytext);}
A[ei]r(" "{U}[^ \n\-]+)+	{printARL(yytext);}
	/* */
[^\n ]+SU\/stra" "[Ss]jukhuset	{printCRP(yytext);}
stra" "sjukhusets" "[^\n ]+mottagning	{printCRP(yytext);}
Sahlgrenska" akademins "[^\n ]+" "institution	{printCRP(yytext);}
Sahlgrenska" "[^\n ]*[Ss]jukhuset"/"(Sahlgrenska|[]stra|Mlndal)	{printCRP(yytext);}
("Malms Allmnna"|Nacka|Danderyds|Lwenstrmska|"Astrid Lindgrens"|Akademiska|Sundsvalls|stra|SU\/Sahlgrenska|Sahlgrenska|{U}[^\n ]+dals|Malm|Karolinska|Huddinge|stersunds|Lunds|Ume|Norrlands|Vasa|Linkpings|Uppsala|Stockholms|rebro|rhus)" "[^\n ]*(vrdsavdelning|[Ss]jukhus)(et)?(s" "[^\n ]+iska" "[^\n ]*enhet|s" centrala "[^\n ]+avdelning|s" "[^\n ]+klinik|s" "[^\n ]+enhet|s" akutmottagning"|s" "enhet" fr "[^\n ]+isk" "[^\n ]+)?	{printCRP(yytext);}
("S\:t Eriks"|[Dd]rottning" Silvias "[Bb]arn\-" och"|Sabbatsbergs|Endokrinologiska|Geriatriska)" "[^\n ]*(klinik|sjukhus)(et|ets)?	{printCRP(yytext);}
{U}[^\n ][^\n ]+" "(Avd\.|Avd|[Aa]vdelning|[Ee]nhet)" fr "[^\n ]+ologi	{printEDU(yytext);}
(Avd\.|Avd|[Aa]vdelning|[Ee]nhet)en" fr "[^\n ]+ologi	{printEDU(yytext);}
"Svenska freningen fr "[^\n ]+s" "[^\n ]+	{printCRP(yytext);}
"Svensk "[Ff]rening" "fr" vre "[^\n ]+	{printCRP(yytext);}
{U}[^\n ]+"s "[Uu]niversitetssjukhus(et|en)?	{printCRP(yytext);}
"Svenska "[^\n ]+freningens" sektion fr barn\- och "[^\n ]+ogi	{printCRP(yytext);}
({U}[^\n ][^\n ]+" ")+[Uu]niversitets(sjukhus|sjukhuset|sy[gk]ehus|laboratoriet)	{printCRP(yytext);}
Medicinska" "[^\n ]+rdet	{printCRP(yytext);}
Internationella" "[Ss]amfundet" mot "[^\n ]+sjukdomar	{printCRP(yytext);}
	/* EDUcational */
University" of "[^\n ]+" at "{U}[^\n ]+	{printEDU(yytext);}
University" of "[^\n ]+" "[^\n ]+" "Center	{printEDU(yytext);}
[^\n ]+"\- och "[^\n ]+enheten" fr "[^\n ]+	{printEDU(yytext);}
({U}[^\n ]+" ")+"State "(College|University|U)(" School of "[^\n ]+)?	{printEDU(yytext);}
({U}[^\n ]+" and ")?({U}[^\n ]+" ")+(Universitaire|College|University|Univesity|Univ|Univ\.)(" School of "[^\n ]+|" Hospital"|" Medical"|" School")*	{printEDU(yytext);}
({U}[^\n ][^\n ]+" ")*(College|[Aa]cademy|[Uu]niversity|[Ss]chool)" "(for|[Oo]f)" "[^\n ]+(" "{U}[^\n ]+)*(" of Medicine")?	{printEDU(yytext);}
(Universit[e]|Coll[e]ge|Akademie|Universidade|Universidad|Universidad" "Polit[e]cnica)" "(del|der|de|"de la")(" "{U}[^\n ]+)+	{printEDU(yytext);}
(Universit[e]|Coll[e]ge|Akademie)" "{U}[^\n ]+" "(der|de)(" "{U}[^\n ]+)+	{printEDU(yytext);}
("the ")?({U}[^\n ][^\n ]+" ")+(Universit[y]|[Uu]niversit[e]t|Academy|College|School)(" "{U}[^\n ]+)*	{printEDU(yytext);}
({U}[^\n ][^\n ][^\n ]+" ")+(teknisk(a)?" ")?[Uu]niversit[e]t(et)?	{printEDU(yytext);}
"Studiefrbundet "{U}[^\n ]+skolan	{printEDU(yytext);}
(Svenska" "|Musikaliska" "|Kungliga" "|Sahlgrenska" ")+[^\n ]*akadem(i|ie)n	{printEDU(yytext);}
Kungliga(" "{U}[^\n ]+)+" "[^\n ]*[Aa]kadem(i|ie)n	{printEDU(yytext);}
Kungliga" "[^\n ]+\-" och "[^\n ]*akadem(i|ie)n	{printEDU(yytext);}
Kungliga" "[Vv]etenskaps\-" och "[^\n ]+	{printEDU(yytext);}
{U}[^\n ]+s" "[Tt]ekniska" "[Hh]gskola(n)?	{printEDU(yytext);}
{U}[^\n ]+\-" och "{U}[^\n ]+skola(n)?	{printEDU(yytext);}
[^\n ]*(erns|Kungl|Kungliga|Finska|ella|Svenska|Statens|munala|Hgre|Centrala|ppna|borgs|Nordiska|istiska|Mlardalens|rtrns)" "[^\n ]+gskola(n)?	{printEDU(yytext);}
[^\n ]*(alett|efls|blioteks|[Ee]lit|ilm|oto|andels|drott|nalist|jgar|onst|krigs|adett|kyrk|lrar|musik|mlar|plant|polis|eal|rid|scen|sim|social|eater|urist|nderrtelse|valtnings|vrd|rkes)[^\n ]*skola(n)?(" "{U}[^\n ]+)+	{printEDU(yytext);}
"Hgskolan fr "[^\n ]+" och "[^\n ]+	{printEDU(yytext);}
(Universitt|Universiteit|University" of"|Hgskolan)(" "{U}[^\n ]+)+(" of "[^\n ]+" and "[^\n ]+|" and "[^\n ]+)?	{printEDU(yytext);}
A[kc]ad[e]mi[ae]" "(de|des)" "[^\n ]+(" "{U}[^\n ]+)*	{printEDU(yytext);}
"Sveriges "[^\n ]+universitet	{printEDU(yytext);}
{U}[^\n ]+s" "([Ii]nstitut" fr "[^\n ]+ala" "studier|[^\n ]+vetenskapliga" "[Aa]kademi)	{printEDU(yytext);}
{U}[^\n ]+(iga|ska)" "[Ii]nstitutionen	{printEDU(yytext);}
"Chalmers "[^\n ]+skola	{printEDU(yytext);}
"Svenska "[^\n ]+skolan	{printEDU(yytext);}
{U}[^\n ]+" "("Hgre "[^\n ]+skola|"Research Laboratory"|"Technische Hochschule")	{printEDU(yytext);}
("Svenska "|"Internationella ")?[Rr]"da "[Kk]orsets" "[^\n ]+skola	{printEDU(yytext);}
[Vv]id" "{U}[^\n ]+" "{U}[^\n ]+skola(n)?	{int i=4;putchar(yytext[0]);printf("id <ENAMEX TYPE=\"ORG\" SBT=\"EDU\">");	for(;i<yyleng; putchar(yytext[i++])); printf("</ENAMEX>");}
(Universitetet|Hgskolan)" i"(" "{U}[^\n ]+)+	{printEDU(yytext);}
"Inst\. fr "[^\n ]+sk" och "[^\n ]+tiv" vetenskap"	{printEDU(yytext);}
"Inst\. fr "([^\n ]+insk" "|[^\n ]+inska" ")?[^\n ]*(folkhlsa|medicin|kemi|ologi|omvrdnad|kirurgi|obstetrik|vetenskap|vetenskaper)	{printEDU(yytext);}
"Institutet fr "[^\n ]+(ymdfysik|forskning|"bildande medicin"|offentlig" och internationell "rtt)	{printEDU(yytext);}
"Institut fr "[^\n ]+" und "[^\n ]+	{printEDU(yytext);}
[Cc]entrum" fr "(medfdda" "metabola" "[^\n\< ]+|[^\n ]+invasiv" kirurgi"|socialvetenskaplig" alkohol\- och "drogforskning|[^\n ]+" "Medicin)	{printEDU(yytext);}
Collegium" "[^\n ]+um	{printEDU(yytext);}
{U}[^\n ]+iska" "[Ff]akulteten	{printEDU(yytext);}
"Stiftelsen fr "[^\n ]+"isk "[Ff]orskning	{printEDU(yytext);}
(Faculty|School)" of"(" "{U}[^\n ]+)+(" and "{U}[^\n ]+)?	{printEDU(yytext);}
"Instituto Politcnico "{U}[^\n ]+	{printEDU(yytext);}
"Instituto per la "{U}[^\n ]+	{printEDU(yytext);}
"Institute fr "{U}[^\n ]+	{printEDU(yytext);}
[Ii]"nstitutionen fr "[Mm]edicin(" och vrd"|sk" "[^\n ]+sk" och "[^\n ]+fysik|sk" "[^\n ]+" och "[^\n ]+statistik|sk" och "[^\n ]+sk" "[^\n ]+|sk" "[^\n ]+|ska" "[^\n ]+|" \, kirurgi och ortopedi")?	{printEDU(yytext);}
[Ii]nstitutionen" fr kvinnors och barns "hlsa	{printEDU(yytext);}
[Ii]nstitutionen" fr "[Hh]lsa" , vrd och samhlle"	{printEDU(yytext);}
[Ii]nstitutionen" fr "([Kk]linisk|[Mm]olekylr)" "[^\n ]+	{printEDU(yytext);}
([A-Z][^\n ]+s" ")?[^\n ]+ationella" "[Ii]nstitut" fr "[^\n ]+forskning	{printEDU(yytext);}
[Ii]nstitutionen" fr "("genetik och "[^\n ]+|[^\n ]+logi" och "[^\n ]+logi|[^\n ]+ylr" och "klinisk" "[^\n ]+|[^\n ]+system" och "[^\n ]+lra|folkhlsa" och klinisk medicin"|biokemi" och biofysik"|"hlsa och samhlle")	{printEDU(yytext);}
"Karolinska "[Ii]nstitutet(s)?(" institution fr oral "[^\n ]+)?	{printEDU(yytext);}
"Univ\. of "{U}[^\n ]+	{printEDU(yytext);}
("Les ")?Laboratoires" "{U}[^\n ]+	{printEDU(yytext);}
"Uppsala kliniska "[^\n ]+centrum	{printEDU(yytext);}
[Nn]ational" "[Ii]nstitute" fr "[^\n ]+" and "[^\n ]+al" "[^\n ]+	{printEDU(yytext);}
[Kk]unskapscentrum" fr "[^\n ]+(tastrofpsykiatri|strningar)	{printEDU(yytext);}
Nationellt" "[^\n ]*centrum" fr rrelseorgansens "sjukdomar	{printEDU(yytext);}
	/* TV Channels, Radio, Press */
	/* <ENAMEX TYPE="ORG" SBT="TVR"> */
"World Press Review"	{ECHO;}
	/* MOD (Jyrki Niemi): Corrected the action to take into account
	   the first character of the match:
	   [0-9]" ,"(" "{U}[^\n ]+)+" Press"	{int i=2;putchar(yytext[0]);printf(", <ENAMEX TYPE=\"ORG\" SBT=\"TVR\">");	for(;i<yyleng; putchar(yytext[i++])); printf("</ENAMEX>");}
	 */
[0-9]" ,"(" "{U}[^\n ]+)+" Press"	{int i=3;putchar(yytext[0]);printf(" , <ENAMEX TYPE=\"ORG\" SBT=\"TVR\">");	for(;i<yyleng; putchar(yytext[i++])); printf("</ENAMEX>");}
({U}[^\n ]+" ")+(University|Institution|Museum|Issues|Science|Free)" Press"	{printTVR(yytext);}
"20th Century Fox"	{printTVR(yytext);}
{U}[^\n ]+" Film "(Company|Institute|AG)	{printTVR(yytext);}
"Canal "(\+[^\n\-\< ]*)	{printTVR(yytext);}
(Danmark|Sverige)s" "Radio(s)?(" "{U}[^\n ]+)?	{printTVR(yytext);}
"TF 1"	{printTVR(yytext);}
({U}[^\n ]+" ")+(Broadcasting|Radio|Television|News)" Network"(s)?	{printTVR(yytext);}
({U}[^\n ]+" ")+(Sports|News)" "(Broadcasting|Channel|Wire|Service|Agency)	{printTVR(yytext);}
"U\. S\. News \& World Report"	{printTVR(yytext);}
"TV "[1-9]" "(Danmark|Gteborg|Stockholm|Malm|Skaraborg|Plus)	{printTVR(yytext);}
"TV "[1-9]\:s	{printTVR(yytext);}
(SVT|TV)" "[0-9][0-9]?	{printTVR(yytext);}
"Radio "{U}[^\n ]+(land|botten|holm)	{printTVR(yytext);}
"Nya Kina"	{printTVR(yytext);}
({U}[^\n ]+" ")+"Broadcasting Union"	{printTVR(yytext);}
"Channel "[1-8]	{printTVR(yytext);}
	/* <ENAMEX TYPE="ORG" SBT="CLT"> */
({U}[^\n ]+" "[Ff]amily|"Asian Dub")" "[Ff]oundation	{printCLT(yytext);}
"Gta "[Ll]ejon	{printCLT(yytext);}
(Malm|Stockholms|sterkers|{U}[^\n ]+borgs|{U}[^\n ]+lands|{U}[^\n ]+liga|{U}[^\n ]+kpings|S:t|{U}[^\n ]*rmns)" "([^\n ]+s" ")?[^\n ]*(osskr|ensemble|ymfoniker|ymfoniorkester|musikkr|amkren)	{printCLT(yytext);}
Svenska" "[^\n ]+(vnner|semblen)	{printCLT(yytext);}
"Kungliga "{U}[^\n ]+ska" "[^\n ]*sllskapet	{printCLT(yytext);}
({U}[^\n ]+" ")*(National|Royal)" Ballet"	{printCLT(yytext);}
"Ballets de"(" "{U}[^\n ]+)+	{printCLT(yytext);}
("Les Ballets"|Thtre)(" "{U}[^ \n]+)+	{printCLT(yytext);}
{U}[^\n ]+ska" "[^\n ]+s" "[Vv]nner	{printCLT(yytext);}
{U}[^\n ]+" "(Big|Steel)" Band Festival"	{ECHO;}
({U}[^\n ]+" ")+(B[Ii][Gg]|Brothers|Steel)" "[Bb][Aa][Nn][Dd]	{printCLT(yytext);}
"New Yorks"(" "|\-)filharmoniker(na)?	{printCLT(yytext);}
("Judas Priest"|"Pearl Jam"|"Royal Beat"|"Gyllene Tider"|"Perssons "Pack|"Twisted Sister"|"The Hives"|"The Cure"|"Infinitive Mass"|"Massive Attack"|"Carte Blanche")	{printCLT(yytext);}
({U}[^\n ]+" ")?(Harlem|National|Ballet|Court)" Theatre"(" Company")?	{printCLT(yytext);}
({U}[^\n ]+" ")+(Girl|Jazz)" "(Quartet|Trio)	{printCLT(yytext);}
({U}[^\n ]+" ")*(Royal|House|harlem|Utah|Euro)" Jazz"	{printCLT(yytext);}
(Cirque|Th[e][a]tre)" "(des|du)" "{U}[^\n ]+	{printCLT(yytext);}
{U}[^\n ]+sei" "[Vv]nner	{printCLT(yytext);}
{U}[^\n ]+" "Sinfonietta	{printCLT(yytext);}
({U}[^ \n]*" ")+(Musikteater|"Puppet Theatre"|Dansteater|Quintet|Orchestra|Teatro|Orkester|{U}[^\n ]orkester)(n)?	{printCLT(yytext);}
{U}[^\n ]+\-" och "[^\n ]+s" "[^\n ]*(organisation|nmnd|ledning|styrelse|sverk|institut|kommission)(et|en|n)?	{printCRP(yytext);}
(Sveriges" "|[^\n ]*Svenska" ")?[^\n ]+\-" och "[^\n ]+(kammar|kontor|frbund|frening)(en|et)?	{printCRP(yytext);}
{U}[^\n ]+s" "[^\n ]+\-" och "[^\n ]+(kontor|rd|institut)(et)?	{printCRP(yytext);}
[^\n ]*(frbundet|Institutet)" "(mot|fr)" "[^\n ]+"\- och "[^\n ]+	{printCRP(yytext);}
{U}[^\n ]+"\- och "[^\n ]*(nmnd|ledning|styrelse|sverk|institut|kommission|frvaltning)(et|en|n)?	{printCRP(yytext);}
"Lkemedelsindustrifreningens \( Lif \) etiska nmnd"	{printCRP(yytext);}
(Smfretaga|Fretaga|{U}[^\n ]+freninga|Akademike)rnas" "([Cc]entral|[Rr]iks)organisation	{printCRP(yytext);}
"Forskningsanstalten fr "[^\n ]+medicin" och "[Ll]ivsmedel	{printCRP(yytext);}
({U}+s|{U}+\:s|Statens|[^\n ]*[Ff]rsvarets|Skandinaviska|Atens|Hndelns)" "([^\n ]+ska" ")?[^\n ]*(institut|rd|nstalt|verk)(et|en)?	{printCRP(yytext);}
"Inspektionen fr "[^ \n]+ska" "[^\n ]+	{printCRP(yytext);}
{U}[^\n ]+s" "[Hh]gsta" "[^\n ]*[Dd]omstol	{printCRP(yytext);}
(Idrottens|Hgsta|[^\n ]+rdets|[Ii]nternationella|EU\:s)" "[^\n ]*[Dd]omstol(en)?	{printCRP(yytext);}
"Nmnden fr bedmning av "[Ll]kemedels(reklam|information)	{printCRP(yytext);}
"Kyrkornas vrldsrd"(s" "[^\n ]+departement)	{printCRP(yytext);}
(Europardet|Nringslivet)s" "[^\n ]+" mot "[^\n ]+(ande|isk)" "[^\n ]+	{printCRP(yytext);}
[Ss]"tatens "([Ii]nstitut|beredning)" fr "([^\n ]+ial" "|[^\n ]+sk" ")?[^\n ]+	{printCRP(yytext);}
(Centrala|[Ss]tatens)" "[^\n ]+(givarverk|rnvgar|byr|rd|elager|sverk|institut|myndighet|kommission|inspektion|levern|styrelse)	{printCRP(yytext);}
"Statens "[^\n ]+iska" "[^\n ]+	{printCRP(yytext);}
"Statens "{U}[^\n ]+	{printCRP(yytext);}
(Vstsve|[Ss][Vv][Ee]|[Aa]merika)[Nn][Ss][Kk][Aa]" "([Kk]raftnt|[Kk]ennelklubb|[^\n ]*[Ii]nstitut|[Ss]prknmnd|UD|[^\n ]+[Ff][][Rr][Bb][Uu][Nn][Dd]|[^\n ]+frening|[^\n ]+kammar)(en|[Ee][Tt])?	{printCRP(yytext);}
{U}[^\n ]+(holm|borg|land)s" "[Ss]tifts" "{U}[^\n ]*frvaltning	{printCRP(yytext);}
{U}[^\n ]*(borg|holm|kne|viken|fonden|anstllda|"Maria\-Gamla stan"|malm)s" "[^\n ]+(kollegium|snmnd|sllskap|fullmktige|frbund|frening|kommitt|frvaltning)(er|n|en|et)?	{printCRP(yytext);}
{U}[^\n ]+(rol|polit|ekonom)iska" "[Ii]nstitutet	{printCRP(yytext);}
Sveriges" "[^\n ]+lkares" "frening	{printCRP(yytext);}
Sveriges" Lkares "[Ii]ntressefrening" "fr(" "{U}[^\n ]+)+	{printCRP(yytext);}
(Svenska|Sveriges)" "[^\n ]+iska" "[^\n ]*([Ff]rbund|[Ii]nstitut)(et)?	{printCRP(yytext);}
Svenska" "[^\n ]+s" "[^\n ]*([Kk]ulturrd|[Cc]entralrd|[Ff]rbund|[Ff]rbundet|organisation)	{printCRP(yytext);}
"Sveriges "[^\n ]+iska" och "[^\n ]+iska" "[Ii]nstitut	{printCRP(yytext);}
"Sveriges "[^\n ]+" "([Aa]kademikers|[Ss]tudentkrer|[Aa]ttacher)	{printCRP(yytext);}
({U}[^\n ]+mnnen|Motorcyklister|{U}[^\n ]+frskringar)"s "([Cc]entralorganisation|[^\n ]+avdelning)	{printCRP(yytext);}
({U}[^\n ]+erket|{U}{U}+\:|Apoteket)s" "[^\n ]+[^\ng ]enhet	{/*lgenhet*/printCRP(yytext);}
[Ss]mittskyddsenheten" "[A-Z]+	{printCRP(yytext);}
(Lns)?[Ee]nheten" fr "([Ll]ung"\- och "[^\n ]+forskning|[^\n ]+"medicin och klinisk "[^\n ]+)	{printCRP(yytext);}
(ver)?[Ss]tyrelsen" fr "[^\n ]+(ellt|vil)" "[^\n ]+	{printCRP(yytext);}
("Svenska "|"Internationella ")?[Rr]"da "[^\n ]+" "[^\n ]+federationen	{printCRP(yytext);}
(Nya|Om|Hela|Intill)" kyrkan"	{ECHO;}
({U}[^\n ]+"isk ")?({U}[^\n ]+"iska Lutherska"|"Romersk-katolska"|Ortodoxa|Katolska|Svenska|Finska|[Gg]"rekisk-ortodoxa")" "[Kk]yrkan	{printCRP(yytext);}
[Rr]"dda Barnen"	{printCRP(yytext);}
{U}[^\n ]+"s "[Ll]ns" "[Ll]andsting(fullmktige)?	{printCRP(yytext);}
[Vv]id" "[Ll]"andstinget i "{U}[^\n ]+	{int i=4; putchar(yytext[0]); 	printf("id <ENAMEX TYPE=\"ORG\" SBT=\"CRO\">"); for(;i<yyleng; putchar(yytext[i++])); printf("</ENAMEX>");}
(Sdra" ")?{U}[^\n ]+(borgs" och Bohus "ln|hamn|vall|nd|sund|land|borg|holm|berg|dal|ping|tad|httan|nden|vik|ippan)"s "(landsting|tingsrtt)	{printCRP(yytext);}
[Ll]andstinget" "({U}[^\n ]+rg|Skne|{U}[^\n ]+land)	{printCRP(yytext);}
{U}[^\n ]+"s lns "[^\n ]*(frbund|bolag|sllskap|frening|fullmktige|myndighet)	{printCRP(yytext);}
"Institutet fr "[^\n ]+(nal|ska|isk|nsk|ial|nde|gre)" "[^\n ]+	{printCRP(yytext);}
{U}[^\n ]+" "[^\n ]+(nings|ister|sions|skaps|arbets|ransch)rdet	{printCRP(yytext);}
({U}[^\n ]+ska" ")?([^\n ]+iska|Kristna)" rdet"	{printCRP(yytext);}
{U}[^\n ]+"frebyggande rdet"	{printCRP(yytext);}
(Sveriges|{U}[^\n ]+mnnens|{U}[^\n ]+kens|{U}[^\n ]+\:s|De" "[^\n ]+kappades|[^\n ]+kappades|{U}[^\n ]+skolornas)" "[^\n ]+frbund	{printCRP(yytext);}
{U}[^\n ]+"anstlldas "([^\n ]+ingsrd|[Ff]rbund)	{printCRP(yytext);}
"Svensk "(frening" fr akutsjukvrd"|frening" fr "[^\n ]+logi|[^\n ]+tjnst|[^\n ]+frmedling|Idrottsreklam|Handel|Fisk)	{printCRP(yytext);}
"Svenskt Nringsliv"	{printCRP(yytext);}
(Amerika|Sve)nska" "[^\n ]+(ssekreteriatet|lyktingrdet|murarorden|kren|sllskapet|missionen|unionen|frbundet|MTS\-nt|rikalinjen|kompaniet|facket|sverket|frbundets" "[^\n ]+savdelning)	{printCRP(yytext);}
Scientific" Committee of the Federation of European Societies for "[^\n ]+" of the "[A-Z][^\n ]+	{printCRP(yytext);}
[Ee]uropeiska" "[^\n ]+freningen	{printCRP(yytext);}
Internationella" "[^\n ]+(vgsunionen|rdsunionen|nergiorganet|tikunionen|sunionen|byrn|kammaren|klubben|kommissionen|tribunalen|arbetsorganisation|rganisationen" fr "[^\n ]+|frbundet)	{printCRP(yytext);}
{U}[^\n ]+(borg|holm|regionen)s" Lokaltrafik"	{printCRP(yytext);}
(Svenska" ")?(Afrikanska|Ostindiska)" "[KCk]ompa(n|gn)iet	{printCRP(yytext);}
"Natur och Kultur"	{printCRP(yytext);}
([Ee]uropeiska|[Ee]ngelska|{U}[^\n ]+borgs|"Sdra "{U}[^\n ]+borgs)" "[Ff]otboll(s)?frbund(et)?	{printCRP(yytext);}
([Vv]st)?[Ee]"uropeiska "[^\n ]+organisationen" "{U}+	{printCRP(yytext);}
{U}[^\n ]+iska" "[^\n ]+organisationen	{printCRP(yytext);}
"Organisationen fr "[Ss]"kerhet och "[Ss]"amarbete i Europa"	{printCRP(yytext);}
(Finlands|Svenska|Sveriges|Legitimerade)" "[^\n ]+" "[Rr]iksfrbund	{printCRP(yytext);}
{U}[^\n ]+(chens|ernas|iska|riges)" "[Rr]iks(organisation|frbund)(et|en)?	{printCRP(yytext);}
"Vstra Gtalands "[^\n ]+(nmnd|ledning)(en)?	{printCRP(yytext);}
{U}+\:s" "([^\n ]ella" ")?[^\n ]*(medelsmyndighet|inspektion|byr|rikesdepartement|ommissariat|organisation|organ|styrelse|smyndigheter|styrkor|grupp)(" "{U}+)?	{printCRP(yytext);}
{U}[^\n ]+" "[^\n ]*styrelse	{printCRP(yytext);}
[Rr]iksfrbund(et)?" fr "[^\n ]+(ellt" "[^\n ]+ande|isk" fibros"|ial" och mental hlsa")	{printCRP(yytext);}
[Rr]iksfrbundet" "([Cc]ystisk" "[Ff]ibros|Rrelsehindrade" Barn och Ungdormar")	{printCRP(yytext);}
	/* MOD (Jyrki Niemi): Corrected a double space in pattern:
	   ({U}[^\n ]+" ")+" "(European|Projects|Technology)" Agency"	{printCRP(yytext);} */
({U}[^\n ]+" ")+(European|Projects|Technology)" Agency"	{printCRP(yytext);}
{U}[^\n ]+" Projekt AB"	{printCRP(yytext);}
(Strategi|Aktions|Arbets)gruppe[nr]" fr "[^\n ]+(ell|isk)" "[^\n ]+	{printCRP(yytext);}
	/* MOD (Jyrki Niemi): Removed a leading "s" from pattern:
	   s{U}[^\n ]+s" "[^\n ]+iska" "([Ii]nstitut|[Oo]bservatorium)	{printCRP(yytext);} */
{U}[^\n ]+s" "[^\n ]+iska" "([Ii]nstitut|[Oo]bservatorium)	{printCRP(yytext);}
(Association|Institut|Federation)" "[^\n ]+" des "(" "{U}[^\n ]+)+(" de "[^\n ]+)?	{printCRP(yytext);}
Societe" "[^\n ]+" de "(" "{U}[^\n ]+)+	{printCRP(yytext);}
(Institut|Societe|Fed[ea]ration)" "(du|de|of)(" "{U}[^\n ]+)+	{printCRP(yytext);}
(European|Nordic|American|International)" "[Ss]ociety" "(for|of|for" "the)" "[^\n ]+(ive|ic|al)" "[^\n ]+	{printCRP(yytext);}
(European|Nordic|American|International|{U}[^\n ]+ish)" "(Organization|Association|[Ss]ociety)" "(of|for|for" "the)" "{U}[^\n ]+(" of the "[^\n ]+|" of "{U}[^\n ]+|" and "{U}[^\n ]+)?	{printCRP(yytext);}
Ntverk(et)?" fr "[^\n ]+ologi	{printCRP(yytext);}
"Cancer\- och "[^\n ]+hjlpen	{printCRP(yytext);}
Association" of"(" "{U}[^\n ]+)+" "Directors	{printCRP(yytext);}
"Nationellt "[Cc]entrum" fr "[^\n ]+fring	{printCRP(yytext);}
"Nationellt "[^\n ]+inskt" "[Ff]orum	{printCRP(yytext);}
(Swedish|American|"New York")(" "{U}[^\n ]+)+" "Association	{printCRP(yytext);}
Society" for the "[^\n ]+" "(for|of)" "[^\n ]+	{printCRP(yytext);}
(International|European|American)" Society "(for|of)(" "{U}[^\n ]+)+	{printCRP(yytext);}
	/* MULTI WITH STRONG/COMMON DESIGNATOR */
[^\n ]+pings" "[Dd]omkapitel	{printCRP(yytext);}
(International|Stockholm)(" "{U}[^\n ]+)*" Study Group"	{printCRP(yytext);}
([A-Z][^\n ]+" "Study|[A-Z][^\n ]+" and "[^\n ]+" "Study)" Group"	{printCRP(yytext);}
({U}[^\n ]+" ")*(Tecumseh|Sonoco|Gerber|Avon|Cvc|Composite|Canada|Video|Home|Memory|Microelectronic|Household|Engineering)" Products"	{printCRP(yytext);}
(Council|Directorate)" of "(" "{U}[^\n ]+)	{printCRP(yytext);}
({U}[^\n ][^\n ][^\n ]+" ")+Enterprises	{printCRP(yytext);}
({U}[^\n ][^\n ][^\n ]+" ")+(Stock|Options|Mercantile|Commodity)" Exchange"	{printCRP(yytext);}
{U}[^\n ][^\n ][^\n ]+" "[Gg]lass" "AB	{printCRP(yytext);}
Svenska" "({U}[^\n ]+bolaget|Koppar|Bomklarna|Missionskyrkan|Foder|Cellulosa|UD|Bostder|[Ss]pel)	{printCRP(yytext);}
"Volvo "[Pp]erson[a-z]+	{printCRP(yytext);}
"Ericsson "Micro[^\n ]+	{printCRP(yytext);}
({U}[^\n ]+" ")?(Satellite|Norris|Mobile|Matra|Fidelity|Conus)" Communications"	{printCRP(yytext);}
{U}[^\n ]+" Mobile "("Data Design"|Phones|Communications)	{printCRP(yytext);}
(International|Modo|United|Holmen|Metso|Stratton|SCA|Consolidated|Simpson|Scott|Munksj)(" "{U}[^ \n]+)*" "Paper(s)?(" "Sales|" "Mills)?	{printCRP(yytext);}
"New York State "[^\n ]+" Institute"	{printCRP(yytext);}
({U}[^\n ]+" ")+(Supplier|Technology|Research)" Institute"	{printCRP(yytext);}
([Tt]he" "|Le" ")?(National" "|Central" "|Federal" ")?"Bureau "(des|of)(" "{U}[^\n ]+)+	{printCRP(yytext);}
Trygg(" "|\-)Hansa(" "SPP)?(" Gruppen"|" Liv")?	{printCRP(yytext);}
(Gteborg|Stockholm)(s)?" "([^\n ]+byr|Vatten|Energi" Din "El|[^\n ]+dentbostder)	{printCRP(yytext);}
({U}[^\n ]+" ")+(Associat|Technologi|Equiti|Industri|Societi|Laboratori|Consultanci|Compani|Authoriti|Agenci|Securiti)es	{printCRP(yytext);}
("Far East Oil"|Norwegian|{U}[^\n ]+banken)(" "[^\n ]+)?" Trading"	{printCRP(yytext);}
(My|Big)" "Travel	{printCRP(yytext);}
({U}[^\n ]+" ")+(Technology|Development|Medical|Electronics|Research|Cooperation|Communication|Cancer|Hurricane|Science)(s)?" Center"	{printCRP(yytext);}
({U}[^\n ]+" ")*(GE|Carbide|Electric)" Silicones"	{printCRP(yytext);}
"Warner "[^\n ]+" "(Techniques|Lambert|Music|Records)	{printCRP(yytext);}
({U}[^\n ]+" ")+(Trading|Maritime)" Overseas"	{printCRP(yytext);}
({U}[^\n ]+" ")+(Speyer|Continental|Allied)" Properties"	{printCRP(yytext);}
({U}[^\n ]+" ")*(General|Flour|Guilford|Cone)" Mills"	{printCRP(yytext);}
(Ica|"Brutus stling"|"Sveriges Radio"|Norstedt|Kaiser|Gernandt|SNS|E\+T|Fabel|Arkiv|S[Vv]D|Arkitektur|Liber|"Albert Bonnier"|{U}[^\n ]+universitetets|Alba|Aller|Bonnier|Verigo|Atlanti|Verbum|"Rabn och Sjgren"|"Nordiska "[Mm]useet|Atlas|Vertigo|Carlsson|Gothia|Vagabond|Gidlund)(s)?" "[^\n ]*[Ff]rlag	{printCRP(yytext);}
({U}[^\n ]+" ")*("and Women"[^\n ]+|Swedishamerican|State" "Mental|Hammersmith|Memorial|General|Princess|Royal|Marsden|Community|Karolinska|Abbots|Jewish|Naval|Royal" "London)(" "{U}[^\n ]+)?" Hospital"	{printCRP(yytext);}
[Vv]id" "(St|New|National|Royal|Queen|Princess)" "{U}[^\n ]+" "Hospital	{int i=4;putchar(yytext[0]);printf("id <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); for(;i<yyleng; putchar(yytext[i++])); printf("</ENAMEX>");}
(Petroleo|Petroleum|Petronas|Petroleos|Tel[e]fonos)(" de")?(" "{U}[^\n ]+)+	{printCRP(yytext);}
{U}[^\n ]+" "[Dd](e|es)" "(Petroleos|Petroles)	{printCRP(yytext);}
({U}[^\n ]+" ")+(Tool|Electrical|Automoble|Auto|Steel)" "Works?	{printCRP(yytext);}
(Commercial|Consumers|Norwich)(" "{U}[^\n ]+)*" "Union	{printCRP(yytext);}
(Akzo|Thermo|Nitro|EKA)" Nobel"(" "{U}[^\n ]+)*	{printCRP(yytext);}
North" "(Start|Star)	{printCRP(yytext);}
"Norsk "[^\n ]+institutt(" Kemi")?	{printCRP(yytext);}
{U}[^\n ]+stad" "[Ss]tudentkr	{printCRP(yytext);}
{U}[^\n ]+" "(Global|Executive)" "Advisors	{printCRP(yytext);}
{U}[^\n ]+" "(International|Information)" "Network	{printCRP(yytext);}
Royal" "[^\n ]+" "Department	{printCRP(yytext);}
"United "(Defense|Defence)(s)?	{printCRP(yytext);}
({U}[^\n ]+" ")*(Drilling|Mando)" "Machinery	{printCRP(yytext);}
"Chemical Engineering "[^\n ]+" "Construction	{printCRP(yytext);}
"Federal "(Express|[^\n ]+" "[Cc]ommission|de" "{U}[^\n ]+)	{printCRP(yytext);}
{U}[^\n ]+(esta|sunds|bottens)" "[Jj][e]rnverk	{printCRP(yytext);}
"American Telephone "[^\n ]+" Telegraph"	{printCRP(yytext);}
"Stora "Paper[a-z]+	{printCRP(yytext);}
[^\n ]*"Union "(Fleurs|Carbide|"Offshore Exploration"|[^\n ]+" "Espanoles)	{printCRP(yytext);}
({U}[^\n ]+" ")+("Hotell \& Restauranger"|"Hotels \& Resorts"|"Hotel Group"|Hotels" "International)	{printCRP(yytext);}
"Pharmacia "Bio[^\n ]+	{printCRP(yytext);}
(Gteborgs|Stockholms)" "([Kk]ommunala|stads)" "[^\n ]+bolag	{printCRP(yytext);}
"AB "Goman[^\n ]*	{printCRP(yytext);}
[^\n ]+hamns" "Mekaniska" "Verkstad	{printCRP(yytext);}
European" "([^\n ]+" for "[Dd]isease" "[Pp]revention|[^\n ]+" for "[Ss]"moking "[Pp]revention|[^\n ]+" "[Cc]onsortium|"League Against "[A-Z][^\n ]+)	{printCRP(yytext);}
\n	{ECHO;}
.	{ECHO;}
%%
  int printATH(char *a)
{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">%s</ENAMEX>",yytext); return(1); }
  int printTVR(char *a)
{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"TVR\">%s</ENAMEX>",yytext); return(1); }
  int printPLT(char *a)
{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"PLT\">%s</ENAMEX>",yytext); return(1); }
  int printEDU(char *a)
{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"EDU\">%s</ENAMEX>",yytext); return(1); }
  int printCRP(char *a)
{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">%s</ENAMEX>",yytext); return(1); }
  int printARL(char *a)
{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"ARL\">%s</ENAMEX>",yytext); return(1); }
  int printCLT(char *a)
{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"CLT\">%s</ENAMEX>",yytext); return(1); }
main( argc, argv )
  int argc;
  char **argv;        
{        
    ++argv, --argc;
    if ( argc > 0 )
      yyin = fopen( argv[0],"r");
    else
      yyin = stdin;
    
    yylex(); return(0);
}
/*
  int printTVR YY_PROTO((char *a));
  int printPLT YY_PROTO((char *a));
  int printCRP YY_PROTO((char *a));
  int printATH YY_PROTO((char *a));
  int printCLT YY_PROTO((char *a));
  int printARL YY_PROTO((char *a));
  int printEDU YY_PROTO((char *a));
*/
