/*
	File: OrgPat.ll
	Author: Dimitrios Kokkinakis
	version: 041201
	Finds a variety of Organizations using pattern matching
*/
%{
%}
U	[\101-\132\300-\335\&]
%{
  int printCRP (char  *a, int x);
  int printATH (char  *a, int x);
  int printCLT (char  *a, int x);
  int printARL (char  *a, int x);
  int printFNC_CRP (char  *a,int x);
  int printCRP0 (char  *a, int x);
  int printEDU (char *a,int x);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|TRM)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDC|MDD|MDA|MDO|MDI|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|FRQ|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"\<TIMEX TYPE\="\"TME"\" SBT\=\""DAT\"\>[^\n\<]+\<\/TIMEX\>	{ECHO;}
"\<ENAMEX TYPE\="\"PRS\"" SBT\="\"HUM\"" ANI\="\"[A-Z][A-Z][A-Z]\""\>"[^\n\<]+"\<\/ENAMEX\>"	{ECHO;}
	/* the? xxxxxx X  and some MULTI DESIGNATORS */
("the ")?({U}[^\n ]+" ")*(Center|Centre|"European Patent"|Department|Bureau|Organisation|Council|[Ff]ederation|[Aa]lliance|[Cc]ommittee|[Ii]nstitute|Board|Association|Instituto|[Ff]oundation)" "(do|for|fr|of|"of the"|"for the"|on)(" "{U}[^\n\< ]+)+(" of "[^\n\< ]+)?(" and "[^\n\< ]+)?(" "{U}[^\n\< ]+)*	{printCRP(yytext,0);}
("the ")?({U}[^\n ]+" ")*(Center|Centre|"European Patent"|Department|Bureau|Organisation|Council|[Ff]ederation|[Aa]lliance|[Cc]ommittee|[Ii]nstitute|Board|Association|Instituto|[Ff]oundation|Kommittn)" "(do|for|fr|of|"of the"|"for the"|on)" "[^\n ]+(" "{U}[^\n\< ]+)*	{printCRP(yytext,0);}
("the ")?({U}[^\n ]+" ")+([Ff]ederation|[Aa]lliance|[Cc]ommittee|[Ii]nstitute|Board|Association|Dental" Center"|Research" Center"|"Business Group"|"Hotels "[^\n ]+" Resorts")	{printCRP(yytext,0);}
	/* MUSIC, THEATER? */
(En|Att|Nr)" trio"	{ECHO;}
Picadd?"illy Circus"	{ECHO;}
[Ll]iten" vtskeansamling"	{ECHO;}
[^\n ]*(lues|kust|phop|[Pp]op|[Ss]oul)gnget(" "{U}[^ \n]*)+	{printCLT(yytext,1);}
[^\n ]*(robat|rtist|sbands|ixie|hop|hopp|oesi|ojk|ueer|rap|ggae|revy|nstnrs|visnings|vokal|synt|ango|eater|[Rr]ock|punk|[Dd]ans|zz|satir|echno|usik|[Pp]op|[Ss]ng|onsttar|ngeles|jej|spelmans|lamenco|York|dance|umental|tals)(\-)?gruppen(" "{U}[^ \n]*)+	{printCLT(yytext,1);}
[^ \n]*([Ss]tor|[Rr]ock|[Ss]ynt|jej|ojk|ans|core|ult|[Hh]us|hester|zz|lasgow|alm|borgs|ggae|xie|echno|sala|manna|pings|holms|htte|hus|tals|roll|ngdoms|hop|punk|me|metal|alsa|oul|York|[Pp]op|ppie|stads|rogg|attle|lues|bland|stuna|makt|vle|exas|komp|live|cover|leans)(\-)?bandet(" the")?(" "{U}[^ \n]*)+	{printCLT(yytext,1);}
"grupp vid namn"(" "{U}[^ \n]*)+	{printCLT(yytext,3);}
"i bandet"(" "{U}[^ \n]*)+	{printCLT(yytext,2);}
sng(erska|are)" i "{U}[^\n ]+(" "{U}[^ \n]*)+	{printCLT(yytext,2);}
[^\n ]+"onsert med "{U}[^\n ]+(en|ge|\:|rna|olm|an|rg)s" "[^\n ]+	{printCLT(yytext,2);}
[^\n ]*(nsemble|gruppen|nsemblen)" "(The|Theatre|Les|Le|La)" "[^\n ]+	{printCLT(yytext,1);}
[^\n ]+nsemble(n)?(" "{U}[^ \n]*)+	{printCLT(yytext,0);}
[^\n ]*(vorit|[Ss]ynt|itarr|[Pp]op|iano|usik|echno|ock)(du|tri)o(n)?(" "{U}[^\n ]*)+	{printCLT(yytext,1);}
[^\n ]*(vartetten|vintetten|irque|rkestern|innoklubben|okklubben)(" "{U}[^\<\>\n ]*)+	{printCLT(yytext,1);}
[^\n ]*(ng|[Dd]ans|teratur|usik)sllskapet(" "{U}[^ \<\>\n]*)+	{printCLT(yytext,1);}
({U}[^ \n]*" ")+[^ \n]*(Circus|Balett|Sextet|Band|Symfoniker|\-kvartett|\-kvintett|trio)(en|n)?	{printCLT(yytext,0);}
(med|av)(" "{U}[^ \n]*)+" "[^ \n]+[kr]kr	{printCLT(yytext,1);}
[^\n ]+(am|mar|ng|anna|ell|rko|oss|mans)kren(" "{U}[^\<\>\n ]*)+	{printCLT(yytext,1);}
(E\-Type|{U}[^ \n]*orkestern)	{printCLT(yytext,0);}
kren(" "{U}[^ \n]*)+	{/*leave it 0!*/ printCLT(yytext,0);}
[^\n ]*(ans|pstars)grupperna(" "{U}[^\n ]*)+	{printCLT(yytext,1);}
att" "(Gteborgsopera|Stadsteater)n	{printCLT(yytext,1);}
	/* sth fr X */
("Svenska "|{U}[^\n ]+"ella ")?[^\n ]*(llskap|[Nn]mnd|stitution|nstitut|rbund|rening)(et|en)?" fr "[^\n ]+"\- och "[^\n ]+	{printCRP(yytext,0);}
	/*("Svenska "|{U}[^\n ]+"nella ")?Centrum" fr "[^\n ]+forskning	{printCRP(yytext,0);}*/
("Svenska "|{U}[^\n ]+"nella ")?[^\n ]*(Byrn|llskapet|Centrum|[Nn]mnden|nstitutionen|nstitutet|rbundet|reningen)" fr "[^\n\<\> ]+(ars|ad|al|sk|ska|ns|rda|lt|ll|ig|iga|ing|ik)(" av "[^\n ]+isk)?" "[^\n ]+	{printCRP(yytext,0);}
[^\n ]*[Ff]"rbundet fr det "[^\n ]+	{printCRP(yytext,0);}
("Svenska "|"Svensk "|"Nationella ")?[^\n ]*(tiftels|anstalt|nstitut|Centrum|[Nn]mnd|nstitution|rbund|Frening|Enhet)(en|et)?" "(mot|fr)" "[^\n ]+(" "{U}[^\n ]+)*	{printCRP(yytext,0);}
	/* vid namn/kallas X & CITAT */
[^\n ]*([Bb]ol|ret)ag(et)?" \, som "(heter|kallas)(" "{U}[^\n ]+)+	{printCRP(yytext,4);}
[^\n ]*([Bb]ol|ret)ag(et)?" "("som heter"|"med namnet"|"vid namn"|"ska kallas")(" "{U}[^\n ]+)+	{printCRP(yytext,3);}
[^\n ]*([Bb]ol|ret)ag(et)?" "[\"\\'`]+(" "[^\n\"\'\]+)+" "[\"\\'\`]+	{printCRP(yytext,1);}
[^\n ]*([Bb]ol|ret)ag(et)?" \, "{U}[^\n ]+" \,"	{printCRP(yytext,2);}
({U}[^\n ]+" ")+"\, ett fretag"	{printCRP(yytext,103);}
[^\n ]*(rsjttarna|olagen|retagen)(" "{U}[^\n ]+)+(" \, "{U}[^\n ]+)*" "(samt|och)(" "{U}[^\n ]+)+	{printCRP(yytext,1);}
[^\n ]+(raf|ger|ld|ons|els|aru)kedjorna(" "{U}[^\n ]+)+(" \, "{U}[^\n ]+)*" "(samt|och)(" "{U}[^\n ]+)+	{printCRP(yytext,1);}
	/* sth X */
[^\n ]*jumbolaget(" "{U}[^\n ]+)+	{ECHO;}
[^\n ]*(esign|olags|tekt|stri|ggeri|retagar|retags|sult|medels|ele|lekom|varu|enrs|krings|rkstads)grupp(en)?(" "{U}[^\n ]+)+	{printCRP(yytext,0);}
[^\n ]*(arterarrangren|nsertarrangren|tesarrangren|esearrangren|ivalarrangren|edlartjnsten|yhetstjnsten|esetjnsten|rlusttyngda|artellen)(" "{U}[^\n ]+)+	{printCRP(yytext,1);}
[^\n ]*(ghets|klam|nons|istik|isions|vokat|ese|opnings)byr(n)?(" "{U}[^\n ]+)+	{printCRP(yytext,0);}
[^\n ]*([Gg]as|net|[Bb]il|[Ss]tl|ykel|usik|lekom|lags|medels)gigant(en)?(" "{U}[^\n ]+)+	{printCRP(yytext,1);}
[^\n ]*(ansch|stnds|arbets|{U}[^\n ]+\-)organ(en|et)?(" "{U}[^\n ]+)+	{printCRP(yytext,0);}
	/* [^\n ]*(in|il|ox|klad|uss|lyg|rdons|ronik|nisch|krets|ruck|ings|pers|ils|nus)tillverkar(en|na)?(" "{U}[^\n ]+)+	{printCRP(yytext,1);} */
[^\n ]+tillverkar(en|na)?(" "{U}[^\n ]+)+	{printCRP(yytext,1);}
[^\n ]*anisation(en)?" "[Tt]he" "[^\n ]+" of the "[^\n ]+(" of "[^\n ]+)?	{printCRP(yytext,0);}
[^\n ]*(tiftels|rbundet|rening|rganisation)(en)?" "[^\n ]+([^\nru ]ts|da|skas|[^n\n ]ns|lms|ska|ges)" "[^\n ]+	{printCRP(yytext,1);}
[^\n ]+"ernationella "{U}[^\n ]+e[tn]s	{printCRP(yytext,0);}
[^\n ]*[Ff]"irman "{U}[^\n ]*" \& "[^\n ]+	{printCRP(yytext,1);}
[^\n ]*"rganisationen fr "[^\n ]+skt" "[^\n ]+	{printCRP(yytext,0);}
[^\n ]*(tiftelsen|rening)" "("Det "[^\n ]+a|Fri|De|De|Det)" "[^\n ]+	{printCRP(yytext,1);}
({U}[^\n ]+"ska "|{U}[^\n ]+"nella ")?[^\n ]*(Samfund|[Nn]tverk)et(" "{U}[^\n ]+)+(" mot "[^\n ]+)?	{printCRP(yytext,0);}
[^\n ]*(odehus|[Rr]ederi|onglomerat|rdenssllskap|[Bb]olag|[Ff]ack|[Ff]rlag|retag|rbund|nstitut|operativ|klarhus|kemedelsverk|atentverk|[Vv]arv|Sllskap|lyktingorgan)(et)?(" "{U}[^\n ]+)+	{printCRP(yytext,1);}
[^\n ]*(forlag|rganisation|[Ff]ack|nstitution|dration|rossist|[Bb]olag|[Ff]abrik|[Ff]rening|ternetkonsult|[Ff]ilial|everantr|erksoperatr|etoperatr|biloperatr|leoperatr|\-operatr|erooperatr|myndighet|oncern|istributr|gentur|brs|\-konsult)(en)?(" "{U}[^\n ]+)+	{printCRP(yytext,1);}
[^\n ]*(pakten|terfrskrare|[Ff]irma|olkrrelse|ponsor|atorfrsljare|ankesmedja|[Kk]edja|jtte|terfrsljare|mdstyrelse|tiftelse|torgare)(n)?(" "{U}[^\n ]+)+	{printCRP(yytext,1);}
(SDN|Taxi|"Sveriges Frenade"|[^\n ]*[Ff]rsvarets)(" "{U}[^\n ]+)+	{printCRP(yytext,0);}
[^\n ]+\:s" "[^\n ]+(rd|rgan)" "{U}[^\n\< ]+	{printCRP(yytext,0);}
[^\n ]*[Bb]olaget" "S(verig|tock)[^\n ]+" "[^\n ]+	{printCRP(yytext,1);}
	/* Swedish DESIGNATORS + DESIGNATORS*/
(Till|Fre|Internationela|Nationella|Sdana|Privata|Multinationella|En|Eftersom|Stor|Stora|Inget|Bra|Besviken|Hundra|Antalet|Denna|Finns|Fyra|Japanska|Sedan|Skumma|Vstsveriges|Trkigare|Srskilt|Utlndska|Varfr|Vilken|Gteborgs|Fljande|Vra|Svenska|Amerikanska|Bakom|Lt|Som|Sm|Ska|Skall|Mnnens|Samma|P|Samtliga|Bda|Bgge|Av|Blir|Bland|Andra|Alla|Vrt|Vr|Vilka|Detta|Vilket|Vid|Varje|Ytterligare|Under|Tv|Tre|Att|Flera|En|Dessa|Den|Litet|Inte|Inom|Ingen|Inga|Hans|Genom|Frutom|Frra|Fr|Frn|Ett|P|Enligt|Nr|Medan|Men|Fler|ven|Det|De|Srskilt|Ovan|Om|Och|Ocks|Nya|Ny|Mnga|Mitt|Ngra|Nra|vriga|Sval)" "[a-z]*(institution|kommitt|pastorat|samfund|fretag|frbund|institut|kansli|tourism|sgverk|scoutkr|sllskap|rd|stiftelsen|koncern|koncernfack|fondbolag|fond|organisation|frening|frmedling|[^\<\n ]samling|nmnd|vnner|kommunfullmktige)(et|en|n|n)?	{ECHO;}
"Tysklands terfrening"	{ECHO;}
(|{U}[^\n ]+\-)terfrening	{ECHO;}
({U}[^\n ]+" ")+[^\n ]*(tiftelse|kommitt[e])(n)?	{printCRP(yytext,0);}
({U}[^\n ]+" ")+([Ff]retagsgrupp|[Ff]retagspartner|Frbund|Vrkstder|Kommunfretag|Fastighetskredit|Fastighetsfrmedling|Frvaltning|Konsult|Produktion|Energi|Rederi|"Ekonomisk Frening")(s)?(" "{U}[^\n ]+)*	{printCRP(yytext,0);}
([Ii]|frn)(" "{U}[^\n ]+)+" "(baptist|missions|pingst)?frsamling(en)?	{printCRP(yytext,1);}
({U}[^\n ]+" ")+[^\n ]*(ourism|[Ss]amling|[Kk]oncern|oncernfack|Organisation|[Ff]rening|rmedling|[Ff]rsamling|[Nn]mnd)(en)?	{printCRP(yytext,0);}
({U}[^\n ]+" ")+{U}[^\n ]*nstitution(en)?	{printCRP(yytext,0);}
({U}[^\n ]+" ")+[^\n ]*(astorat|[Ss]amfund|[Ff]retag|[Ii]nstitut|[Kk]ansli|sgverk|[Ss]coutkr|[Ff]rbund)(et)?	{printCRP(yytext,0);}
{U}[^\n ]+"s "[^\n ]*[Vv]nner"s rsmte"	{ECHO;}
({U}[^\n ]+" ")*{U}[^\n ]+(en|um|et|in|an|d)s" "[Vv]nner	{printCRP(yytext,0);}
({U}[^\n ]+" ")+(Trprodukt|Fastighet|Industri|Konsult)(er)?	{printCRP(yytext,0);}
({U}[^\n ]+"gs ")[Bb]okfrlag	{printCRP(yytext,0);}
	/* X DESIGNATORS-possible-S + DESIGNATOR*/
"Big Brother"	{ECHO;}
"Tom Cruise"	{ECHO;}
"Anders Post"	{ECHO;}
"Medical Journal"	{ECHO;}
	/* X DESIGNATORS-plural:IES + DESIGNATOR*/
({U}[^\n\>\< ]+" ")+(Alliance|Agency|Accountant|Associate|Association|Administration|Automobile|Asset|Bio|Biocare|Bro|Biotech|Boat|Brother|Bureau|Biometric|Catering|Consortium|Cargo|Car|Card|Centre|Chemical|Commercial|Communication|Company|Component|Consultancy|Consultant|Consulting|Contract|Corporation|Cruise|Council|Electric|Electrical|Electronic|Energi|Enterpri[sz]e|Equipment|Equity|Estate|Exchange|Export|Finance|Firma|Orden|Dynamics|Data|Firm|Food|Forum|Foundation|Fund|Group|Holding|Hotel|House|Import|Industry|Institute|Instrument|Insurance|International|Inv|Invest|Investment|Jet|Kartell|Line|Logisti[kc]|Lab|Licensing|Management|Manufacturing|Medical|Microelectronic|Microsystem|Mining|Motor|National|Networking|Network|Oil|Organi[sz]ation|Partner|Petrochemical|Petroleum|Pharmaceutical|Plastic|Post|Product|Production|Publishing|Provisioning|Proprietary|Rail|Resor|Railway|Record|Renting|Research|Resource|Record|Service|Society|Security|Semiconductor|Shipping|Solution|Software|Steel|System|Supplier|Television|Tech|Technology|Telecommunication|T[e]l[e][ck]om|Tobacco|Therapeutic|Tool|Tour|Trading|Travel|IT\-Partner|Venture|Wireles|"Aero Support"|Verlag)s?	{printCRP(yytext,0);}
	/* Most General */
({U}[^\n\t\>\< ]+" ")+(HB|[Aa][Bb]|[Aa]\.[Bb]\.|[Cc][Oo]|[Ii]nc|[Ll][Tt][Dd]|AG|A\.S\.|A\/S|AS|ADR|Corp|Gmb[Hh]|Hld|Limited|N\.V\.|Oy|S\.A\.|SA|Aktiebolag|Incorporated|BV|B\.V\.)	{printCRP(yytext,0);}
	/* General Patterns */
(Ford|Wallenberg|Volvo|Trelleborg|Kinnevik|Disney|Stenbeck|Bonnier|[Nn]orsk|[Ff]insk|[Ss]vensk|[^\n ]+\-|ommun|Celsiu|ommunal|andsting)(s)?gda(" "{U}[^\n ]+)+	{printCRP(yytext,0);}
[^\n ]*(njr|hef)" "(fr|vid)" "({U}[^\n\<\> ]+" ")+[^\n ]*(enhet|tyrelse|kr|sjukhus|klinik|asarett|trafik|anstalt|mitt|byr|elevision|kontor|verk|valtning|vrd|entrum)	{printCRP(yytext,2);}
[^\n ]*"rdfrande i "[^\n ]+("\- och"|ska|nas|ges)" "[^\n ][^\n ]+(" "{U}[^\n ]+)*	{printCRP(yytext,2);}
[^\n ]*("kund hos"|"kper konkurrenten"|"psagd frn"|"har frvrvat")(" "{U}[^\n ]+)+	{printCRP(yytext,2);}
relse(resultate|frlus)t" fr"(" "{U}[^\n ]+)+	{printCRP(yytext,2);}
[^\n ]*(verksam|nstllda|kreterare|ledare|journalist|lkare|frestndare|orskarna)" vid"(" "{U}[^\n ]+)+	{printCRP(yytext,2);}
[^\n ]*(rdfrande|elseresultatet|aktie|bud|kreterare|rinflytande|apitalet|iegare|aktier|orgare|torgaren|ledamot|edamterna|edlemmar|edlemskap|ktierna|udgare|poptioner|garandelen|icensandelen|cernchef|vd)" i"(" "{U}[^\n ]+)+	{printCRP(yytext,2);}
[^\n ]*(erenskommelse|mmanslagning|samverka|usion|amgende)(t|en|n)?" "(av|mellan)(" "{U}[^\n ]*)+" och"(" "{U}[^\n ]*)+	{printCRP(yytext,2);}
[^\n ]*(gs|pkpet|knadsfrs|ponsrats|Helgt|rsnotering|rsintroduktion)(en)?" av"(" "{U}[^\n ]+)+	{printCRP(yytext,2);}
([Ff]usion|amgende|manslagning|avtale)(t|en)?" med"(" "{U}[^\n ]+)+	{printCRP(yytext,2);}
"utvecklas gemensamt av"(" "{U}[^\n ]+)+" och"(" "{U}[^\n ]+)+	{printCRP(yytext,3);}
({U}[^\n ]+" ")+"r en organisation"	{printCRP(yytext,103);}
(underavdelning|underleverantr|dotterbolag|moderbolag)" till"(" "{U}[^\n ]+)+	{printCRP(yytext,2);}
[^\n ]*(kreterare|bud|hefposten|ekonom|nkpare|ersonalen)" p "{U}[^\n ]+\:s" "[^\n ]+	{printCRP(yytext,2);}
[^\n ]*(kreterare|bud|hefposten|ekonom|nkpare|ersonalen)" p"(" "{U}[^\n ]+)+	{printCRP(yytext,2);}
[^\n ]*([Dd]\:n|ekniker|rogramansvarig|dfrande|[Vv][Dd]|rektr|onsult|lytiker|ledare|chef|udsman|chefer|hefen)" "(p|fr|i)" "(Klara|Les|Svenska|{U}+\:s)" "[^\n ]+	{printCRP(yytext,2);}
[^\n ]*([Dd]\:n|tekniker|mansvarig|dfrande|[Vv][Dd]|irektr|onsult|lytiker|ledare|chef|budsman|chefer|hefen|heferna)" "(p|fr|vid)(" "{U}[^\n ]+)+(s" "{U}[^\n ]+|"\:s "[^\n ]+)?	{printCRP(yytext,2);}
[^\n ]*(kad|gre|alverad|rndrad)" vinst fr"(" "{U}[^\n ]+)+	{printCRP(yytext,3);}
[^\n ]*(rsaktuella|noterade)(" "{U}[^\n\- ]+)+	{printCRP(yytext,1);}
{U}[^\n ]+s" "(lnsamhe|koncernled|fretagsled|aktiek|marknadsled|produktionsled|inkpsledn|dotterbo|moderbol)[a-z]*	{printCRP(yytext,11);}
[^\n ]*(varig|flet|sman|stent|legor|oteln|xpert|efl|tredare|hef|avande|rbete|tjnst|r|sarie|ekniker|panare|lld)" "(vid|p|hos|frn)" "[^\n ]+(polis|bevakning)en	{printCRP(yytext,2);}
[^\n ]*(operatr|polis)en" "{U}{U}{U}?	{printCRP(yytext,1);}
[^\n ]*(rapporten|relsemedlemmar|statistik|ressmeddelande)" frn "{U}{U}+	{printCRP(yytext,2);}
[^\n ]*("nstllda inom"|"rundaren av")" "{U}{U}+	{printCRP(yytext,2);}
[^\n ]*(edningen|lesman|mbud|trdare)" fr "{U}{U}+	{printCRP(yytext,2);}
(av|med|om|fr)" "{U}[^\n ]+s" produkter"	{int i=0; for(;yytext[i]!=' ';putchar(yytext[i++]));	i++; printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");
	for(;i<yyleng; putchar(yytext[i++]));}
{U}[^\n ]+s" "[^s\n ][^\n ]+" "[Vv][Dd]	{printCRP(yytext,102);}
[0-9]" s\. "{U}[^\n ]+" "(\.|"\& "{U}[^\n ]*" \.")	{printCRP(yytext,2);}
	/* AD HOC (Ericsson) */
[^\n ]*("avtal med"|"rsvrdet fr"|"onkurrent till")" "(Ericsson|Pepsi|Metall|Posten)	{printCRP(yytext,2);}
(Ericsson|{U}{U}{U}?{U}?|Transport|Saab|Astra|{U}[^\n ]+mnnen)" varsl"[a-z]+	{printCRP(yytext,11);}
(Astra|Ikea|Motorola|Nokia|Siemens|Saab|Telia|Volvo|Skanska)" "[^\n ]+" "Ericsson	{int x=0;
	printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
	for(;yytext[x]!=' ';putchar(yytext[x++]));
	printf("</ENAMEX> "); x++;
	for(;yytext[x]!=' ';putchar(yytext[x++])); x++;
	printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
	for(;x<yyleng; putchar(yytext[x++])); printf("</ENAMEX>");}
	/* also X:s xxx vd */
(Investor|Ericsson|Telia|Volvo|Citypendeln|Skandia|Framfab|Scania|Autonova|Stora|Skanska|Drott|Saco|Posten|Arla|{U}[^\n ]+bolaget|[A-Z]\:)s" "(personal|[Vv][Dd])	{printCRP(yytext,11);}
{U}[^\n ]+s" "(informations|koncern|teknik|forsknings|marknads)chef	{printCRP(yytext,11);}
	/* EDUCATION */
[Vv]id" "{U}[^\n ]+skola(n)?	{printEDU(yytext,1);}
	/* COMPOUNDS */
[^ \n]*(Kanal|Historie|Nt|[Hh]ant|Original|[Kk]raft|Regel|Konst|Sg|Stor|Glas|Bland|Smlt|Slag)verk(et)?	{ECHO;}
[^ \n]*(Oppositions|Lag|Kommunal|Stats|Ordfr|Trafiklandstings|borga)rdet	{ECHO;}
[^ \n]*(Ut|Nyut|Om)nmnd	{ECHO;}
"ett "[^ \n]*verk	{ECHO;}
[^ \n]*(ter|Trdgrds)frening	{ECHO;}
Omorganisationen	{ECHO;}
PR-konsult	{ECHO;}
(Wi|Krni)kren	{ECHO;}
[^\n ]+ombudsman(nen)?" "{U}	{ECHO;}
{U}[^ \n]+(frbund|institut|sekretariat|sllskap|utskott|verk)(et)?	{printCRP0(yytext,0);}
{U}[^ \n]+(kooperativet|kollegium|ministeriet|mbetet)	{printCRP0(yytext,0);}
{U}[^ \n]+[^ \nm]rdet	{printCRP0(yytext,0);}
{U}[^ \n]+(fta|knads|\-)domstol(en)?	{printCRP0(yytext,0);}
{U}[^ \n]+(kriminal|ederation|frening|rvaltning|klubb|kommission|konsult|myndighet|nmnd|organisation|sinspektion|ddningstjnst)(en)?	{printCRP0(yytext,0);}
{U}[^\n ]+kren	{printCLT(yytext,0);}
{U}[^\n ]+(aconsult|ullstyrelse|folkrrelse|kommitt|sakademi|stiftelse)(n)?	{printCRP0(yytext,0);}
{U}[^\n ]+ombudsman(nen)?	{printCRP0(yytext,0);}
{U}[^\n ]+\-koncernen	{printCRP0(yytext,0);}
{U}[^\n ]+(lnskrim[^\n ]+|fren\.|frb\.)	{printCRP0(yytext,0);}
{U}+\-distrikt(et)?	{printCRP0(yytext,0);}
(hos|[Ii]nom|[Vv]id|Enligt)" "{U}[^\n ]+(koncern|vrd|grupp|polis|administration)en	{printCRP(yytext,1);}
(eBay|3Com|3G|3M|3GIS|AMI)	{printCRP0(yytext,0);}
[^\n ]*(bts|rejv|ing|kotika|olitik|ings|rave|utralitets|eri|val|rtts|energi|skydds|ibel|handels)kommission(en)?	{printCRP0(yytext,0);}
\n	{ECHO;}
.	{ECHO;}
%%
int printCLT(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"ORG\" SBT=\"CLT\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CLT\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CLT\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CLT\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"CLT\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1);}
int printCRP(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==102){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">");
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf("</ENAMEX>");
for(;c<yyleng; putchar(yytext[c++]));}
else if (x==103){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1);}
int printATH(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==102){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==1002){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==103){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==202){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1);}
int printCRP0(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"CRP\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1);}
int printFNC_CRP(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"LOC/ORG\" SBT=\"FNC/CRP\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"LOC/ORG\" SBT=\"FNC/CRP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"LOC/ORG\" SBT=\"FNC/CRP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);}
int printARL(char *a, int x)
{printf("<ENAMEX TYPE=\"ORG\" SBT=\"ARL\">%s</ENAMEX>",yytext); return(1);}
int printEDU(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"ORG\" SBT=\"EDU\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"EDU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"EDU\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);}
main( argc, argv )
int argc;
char **argv;	
{	
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  
  yylex(); return(0);
}
