/*
	File: OrgFin.ll
	<ENAMEX TYPE="ORG" SBT="FIN|TVR|ATH|CLT|PLT|CRP"><MTH="PTR"/>
	Author: Dimitrios Kokkinakis
	version: 081026
*/

%{
%}
U		[\101-\132\300-\335\&]
%{
  int printFIN (char  *a, int x);
  int printFINx (char *a);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|TRM)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDC|MDD|MDA|MDO|MDI|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>						{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"\<TIMEX TYPE\="\"TME"\" SBT\=\""DAT\"\>[^\n\<]+\<\/TIMEX\>						{ECHO;}
"E\. coli"										{ECHO;}

([Tt]he" ")?("People\'s "|Industrial" "|"Federal Reserve "|Swiss" "|Union" "|Reserve" "|Royal" "|State" "|Central" "|Development" "|National" ")*Bank" "(of|"of the"|for)?(" "{U}[^\n ]+)+						{printFINx(yytext);}
"Arab Bank for"(" "{U}[^\n ]+)+							{printFINx(yytext);}
"Banque Scandinave en Suisse"							{printFINx(yytext);}
"Banque National de "{U}[^\n ]+							{printFINx(yytext);}
"Nationale Bank van"(" "{U}[^\n ]+)+							{printFINx(yytext);}
"Banque de"(" "{U}[^\n ]+)+								{printFINx(yytext);}
"Den "[^\n ]+"ske "[Bb]ank								{printFINx(yytext);}
"Goldman "(och|and|\&" ")?Sachs							{printFINx(yytext);}
"Matteus "(Fondkommi[s]+ion|Bank)							{printFINx(yytext);}
(Folksam|Nordbanken|Enskilda|Robur)" Kapitalfrvaltning"					{printFINx(yytext);}
"Skandia "(Link|Mklarna|Liv|Kapitalfrvaltning)						{printFINx(yytext);}
"Selabanki slands"								{printFINx(yytext);}
[^\n ]*"Sparbanken "{U}[^\-\n ]+							{/*Finn, Vst*/printFINx(yytext);}
"Tcf Bank Savings Fsb"								{printFINx(yytext);}
"Tsentralniy Bank Rossiyskoy Federatsiyi"						{printFINx(yytext);}
"Trkiye Cumhuriyeti Merkez Bankas"							{printFINx(yytext);}
(First|SEB|Mitsui|Paribas|Vision|East|Watermark)(" "{U}[^\n ]+)*" "(Banking|Capital)(" Markets")?		{printFINx(yytext);}
"European Bank for "{U}[^\n ]+" and "{U}[^\n ]+						{printFINx(yytext);}
"SEB "(Fretagsinvest|Fondfrvaltning)						{printFINx(yytext);}
({U}[^\n ]+s|[Ee]uropeiska|[^\n ]+tiska)" "[Cc]entralbank(en)?(" "{U}+)?				{printFINx(yytext);}
([456]\:e|[Ss]jtte|[Ff]emte|[Ff]jrde)" "AP\-fonden						{printFINx(yytext);}
{U}[^\n ]+s" "finansinspektion(" "{U}+)?							{printFINx(yytext);}
"Interamerikanska "[^\n ]*banken							{printFINx(yytext);}
("Division Internationell"|Akademiker)" "Frskring						{printFINx(yytext);}
"Internationella "([^\n ]+banken|[Vv]alutafonden)						{printFINx(yytext);}
Svensk(a)?" "(Kassaservice|Kredit|{U}[^\n ]+kredit|[^\n ]+kassan)					{printFINx(yytext);}
"Union Europenne Des Experts Comtables Economiques"						{printFINx(yytext);}
[Tt]"he Organisation for Economic Cooperation and Development"					{printFINx(yytext);}
"AMF "[Pp]ension(" "[^\n ]+fond)?							{printFINx(yytext);}
("Nordic Capitals"|Chester|Wasa|Sveriges|Nordic|Riksbankens)" "[^\n ]+fond(en|er)?			{printFINx(yytext);}
("Credit Suisse ")?"First Boston"							{printFINx(yytext);}
Cr[e]dit" "(Suisse|Lyonnais)							{printFINx(yytext);}
(Merill|Merrill|Merril)" Lynch"(" "Realty|" \& Co"|" "Global)?					{printFINx(yytext);}
"Banco Santander"(" Central Hispano")?							{printFINx(yytext);}
("Burlington Indust\."|"G E"|GE|Renaissance|Ericsson|"Bain Venture"|Nippondenso|Gatx|Intel|Growth|Nordic)" Capital"(" "Bank|" Venture"|" Bilfinans")?									{printFINx(yytext);}
"Svenska "("Metall Brsen"|[Pp]enninglotteriet" "[Aa]ktiebolag)					{printFINx(yytext);}
(Svenska|Stockholms)" "(Patentbyr|Penninglotteriet|Auktionsverk|(e\-)?[Hh]andelskammare|Bankfrening)(en|n)?	{printFINx(yytext);}
(Stockholms|Svenska)" "Handelsbank(en)?							{printFINx(yytext);}
{U}[^\n ]+ska" "({U}[^\n ]+|kultur)fonden						{printFINx(yytext);}
({U}[^\n ]+" ")+"Mortgage Association"							{printFINx(yytext);}
{U}[^\n ]+bankens" enhet fr "[^\n ]+ell" "[^\n ]+						{printFINx(yytext);}
(Bankers|National|Wallenberg|New|USA:s|Mitsubishi)(" "{U}[^\n ]+)*" "Trust(" \& "Banking)?			{printFINx(yytext);}
(Sten" "A|Knut" och "Alice)" "{U}[^\n ]+s" "[Ss]tiftelse					{printFINx(yytext);}
(Governmental" ")?"Overseas Economic Cooperation Fund"						{printFINx(yytext);}
("Venture Capital"|"Tishman Development "[^\n ]+" Acquisition")" Fund"				{printFINx(yytext);}
Sparbanke(rna|n)s" "[^\n ]*(bank|byr)							{printFINx(yytext);}
Konsumenternas" "([Bb]ank|[Ff]rskrings|[Ff]ond)byr						{printFINx(yytext);}
(Bor|Kristianstad)s" "[Ss]parbank							{printFINx(yytext);}
(Depository|Investment|Northern|Industrial|"George House")" "Trust					{printFINx(yytext);}
[Dd]"rottning "[^\n ]+" "[^\n ]+fond							{printFINx(yytext);}
("Mitsubishi UFJ Financial"|"Mizuho Financial"|"Sumitomo Mitsui Financial"|"Gothia Financial"|Capital|3i)" Group"	{printFINx(yytext);}
"Pengar "[Ii]" Sverige AB"								{printFINx(yytext);}
{U}+\:s" "[^\n ]+fond(er)?								{printFINx(yytext);}
"Bank al\-"[^\n ]+								{printFINx(yytext);}
[Bb]an(co|que|ka|ca|k)" "({U}[^\n ]+" ")?("de la"|a|de|du|del|do)(" "{U}[^\n ]+)+" de"(" "{U}[^\n ]+)+		{printFINx(yytext);}
[Bb]an(co|que|ka|ca|k)" "({U}[^\n ]+" ")?("de la"|a|de|di|du|del|do)(" "{U}[^\n ]+)+			{printFINx(yytext);}

"New York"(\-)?brsen								{printFINx(yytext);}
Oslo" "Brs									{printFINx(yytext);}
{U}[^\n ]+organisationernas" "Insamlingsrd						{printFINx(yytext);}
[Kk]ommissionen" fr ekonomisk uppgrelse"						{printFINx(yytext);}

	/* BANKS, FINANCIAL, */
	/* <ENAMEX TYPE=ORG SBT=FIN><MTH=PTR/> */
"Credit Act"										{ECHO;}
[Bb]an(co|que|ka|ca|k)(" "{U}[^\n ]+)+							{printFIN(yytext,0);}
Cr[e]dit(" "{U}[^\n ]+)+								{printFIN(yytext,0);}
[^\n ]*(nansinspektionen|banken|kapitalbolaget)(" "{U}[^\n ]+)+					{printFIN(yytext,1);}
({U}[^\n ]+" ")+(Banka|Banken|Nationalbank|Bank|Banking|"Capital Management")				{printFIN(yytext,0);}
[^\n ]*(apital|[Bb]ank|konom|inans|handels)grupp(en)?(" "{U}[^\n ]+)+				{printFIN(yytext,1);}
[Bb]ank(irfirma|jtte)n(" "{U}[^\n ]+)+							{printFIN(yytext,1);}
({U}[^\n ]+" ")+[Ff]ond(bolag|brs|kommi[s]+ion)(s)?(" "{U}[^\n ]+)*				{printFIN(yytext,0);}
"al\-Barakaat"								{printFIN(yytext,0);}



\n	{ECHO;}
.	{ECHO;}
%%

  int printFINx(char *a)

{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"FIN\">%s</ENAMEX>",yytext); return(1); }


int printFIN(char *a, int x)

{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"ORG\" SBT=\"FIN\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"FIN\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"FIN\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"FIN\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"FIN\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1);}




main( argc, argv )
int argc;
char **argv;	
{	
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  
  yylex(); return(0);
}

