/*
	File: AthPat.ll
	<ENAMEX TYPE="ORG" SBT="FIN|TVR|ATH|CLT|PLT|CRP"><MTH="PTR"/>
	Author: Dimitrios Kokkinakis
	version: 060601
	Finds a variety of Athletic Organizations using pattern matching
*/
%{
%}
U	[\101-\132\300-\335\&]
SPORTS	B[Oo][Ii][Ff]VBK|BI|ASK|GoIF|TK|AIF|GIK|IS|IF|FF|SK|IP|MS|MK|SK|IK|Damfotboll|FC|GIF|BTK|AIK|BK|IFK|F\.C\.|HC|IBK|OK|HIF|Gif|B[Oo][Ii]S|FF:s|IS" "FK|GK
%{
  int printATH (char  *a, int x);
  int printATH_M (char *a);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DAT|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDC|MDD|MDA|MDO|MDI|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|TRM|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"\<TIMEX TYPE\="\"TME"\" SBT\=\""DAT\"\>[^\n\<]+"\<\/TIMEX\>"	{ECHO;}
"ishockeylandslaget Conny"	{ECHO;}
"Talat assyriska"	{ECHO;}
(Toronto" ")?"Maple Lea"(fs)" Garden"	{ECHO;}
(Toronto" ")?"Maple Lea"(fs|ves)	{printATH_M(yytext);}
(St|S\:t|St" \.")" Louis "(Blues|Cardinals|Vipers)(\-{U}[^\n ]+)?	{printATH_M(yytext);}
"Vstra Frlunda "[Kk]ommun	{/*tagged as PPL*/ECHO;}
("Vstra "|"V ")?Frlunda(" "BK|" "Indians|" "Hockey|" "HC|" "Club|" "HV|s" "[ABC]\-lag|s" "[ABC]\-lagstrupp)+	{printATH_M(yytext);}
(Vstra|V)" "Frlunda\-{U}[^\n ]*	{printATH_M(yytext);}
{U}[^\n ]*"\-Vstra Frlunda"	{printATH_M(yytext);}
{U}[^\n ]*"\-New Jersey"	{printATH_M(yytext);}
"Sheffield "(W\.|United|W|Wednesday)(" FC")?	{printATH_M(yytext);}
Atl[e]tico" "{U}[^\n ]+	{printATH_M(yytext);}
Maccabi" "{U}[^\n ]+	{printATH_M(yytext);}
"San "Jos[e]" "(Sharks|Rhinos)	{printATH_M(yytext);}
{U}[^\n ]+(httans|ycke|unflo|bergs|levi|vgens|stads|pings)" FK"	{printATH_M(yytext);}
	/* 	<ENAMEX TYPE=ORG SBT=ATH><MTH=PTR/> */
{U}[^\n ]+s" "(U" "[0-9]+|[ABC]|EM|VM|DC|World" "Cup)\-[a-z]*lag	{printATH(yytext,0);}
{U}[^\n\: ]+s" "FF(\:s|s)" "[ABC]\-[a-z]*lag	{printATH(yytext,0);}
{U}[^\n ]+(ens|lands|ges|das)" "{U}+\-vinnande" "[a-z]*lag	{printATH(yytext,0);}
(Europa|Australien|Sverige|[^\n ]+land)s" "(Solheim|Ryder|Davis)" "[Cc]up\-lag	{printATH(yytext,0);}
(Sverige|Norge)s" "fotbollsdamer	{printATH(yytext,0);}
{U}[^\n ]+(ien|land|rike|eria|na|rge|den|ugal|by|\:)s" "[^\n ]*(landslag|landslagstrupp|juniorlag|A\-trupp|M\-trupp|OS\-trupp|EM\-lag)(en)?	{printATH(yytext,0);}
(Svenska|Norska|[^\n ]+iska)" "[^\n ]*(landslag|landslagstrupp|juniorlag|A\-trupp|M\-trupp|OS\-trupp|EM\-lag)(en|et)?(" i maraton"|" i ishockey"|" i handboll"|" i innebandy")?	{printATH(yytext,0);}
Sveriges" "(alpina|[^\n ]+ast[ae])" "[^\n ]*landslag	{printATH(yytext,0);}
(internationella|{U}[^\n ]+ska)" "[^\n ]+(rottning|sport|boll)s?frbund(et|ets)?	{printATH(yytext,0);}
(Elfenbenskusten|Norge|Polen|Sierra" "Leone|Sverige|USA\:|Venezuela|Vietnam)s" "[^\n ]*(staffet|lands)lag	{printATH(yytext,0);}
({U}[^\n ]+iska|{U}[^\n ]+es|{U}[^\n ]+ens|[Ii]nternationella|Svenska|Kenyas|{U}[^\n ]+lands)" "[Oo]lympiska" "[^\n ]*[Kk]ommi[^\n ]+	{printATH(yytext,0);}
Djurgrden" "(och|\,)" "(AIK|Malm|Modo|Frjestad|Hammarby)	{printATH(yytext,0);}
{U}[^\n ]+\-(lvstranden|AIK|Modo|Frjestad|Hammarby)	{printATH(yytext,0);}
(AIK|Modo|Frjestad|Hammarby)\-{U}[^\n ]+	{printATH(yytext,0);}
{U}[^\n ]+" "{SPORTS}\:s" "[^\n ]*(trupp|lag)	{printATH(yytext,0);}
{SPORTS}\:s" "[^\n ]*(trupp|lag)	{printATH(yytext,0);}
"Helt OK"	{ECHO;}
({U}[^\n ]+" ")*(karlarnas|Chess|Sporting|Cricket|Karting|Soccer|Cycle|Lions|Yacht|Motorcycle|Jockey|[^\n ]*ball|Golf|Hockey)" "(Sport)?(Kl|[Cc])lub+	{printATH(yytext,0);}
[Ss]vensklaget" Kiel"	{printATH(yytext,1);}
({SPORTS}|IBF|KFUM|BKV|IBK)(" "{U}[^\n ]+)+	{printATH(yytext,0);}
({U}[^\n ]+" ")+{SPORTS}\-{SPORTS}(" "{U}[^\n ]+)+	{printATH(yytext,0);}
({U}[^\n ]+" ")+\-{SPORTS}(" "{U}[^\n ]+)+	{printATH(yytext,0);}
({U}[^\n ]+" ")+\-{U}[^\n ]+" "{SPORTS}	{printATH(yytext,0);}
({U}[^\n ]+" ")+{SPORTS}\-{U}[^\n ]+	{printATH(yytext,0);}
({U}[^\n ]+" ")+{SPORTS}\:s" "[FP][1-5][0-9]	{printATH(yytext,0);}
({U}[^\n ]+" ")+({SPORTS}|AIS)	{printATH(yytext,0);}
(Karlstad|Halmstad|Gteborgs|Mlndals|Krra)" "(MF|HF|BK)	{printATH(yytext,0);}
{U}[^\n ]+" "(httans|bergs|vgens|levi)" "FK	{printATH(yytext,0);}
[^\n ]*matchen" "{U}[^\n ]+[^\n v]\-{U}[^\n ]+[^\n v]	{printATH(yytext,1);}
[^\n ]*(jumbo|A\-|farmar|ensations|sala|kpings|pojk|tlje|dflyttnings|star|pstickar|ockey|asket|asebol|emma|Rom\-|NBA\-|hockeylands|Gteborgs|B\-lands|Ume|matr|mitt|opp|otten|edar|NHL\-|itten|eedway|[1-5]\-|liga|lubb|eague\-|bolls|NFL\-|Stor|uperetta|[Ff]armar|stad|[Ii]nvandrar|Solna|liga|Oslo|OS\-|mstar|elit|herr|orts|ett\-|borta|bal|boll\-|svensk\-|Stockholms|spels|sensations|final|proffs|skrll|Karlstads|Norrlands|NHL\-|serie|andy|[IV]\-|penhamns|lule|bandy|motstndar|Vsters|versitets)lagen(" "{U}[^\n ]+)+" och"(" "{U}[^\n ]+)+	{printATH(yytext,1);}
[^\n ]*(jumbo|A\-|farmar|ensations|sala|kpings|pojk|tlje|dflyttnings|star|pstickar|ockey|asket|asebol|emma|Rom\-|NBA\-|hockeylands|Gteborgs|B\-lands|Ume|matr|mitt|opp|otten|edar|NHL\-|itten|eedway|[1-5]\-|liga|lubb|eague\-|bolls|NFL\-|Stor|uperetta|[Ff]armar|stad|[Ii]nvandrar|Solna|liga|Oslo|OS\-|mstar|elit|herr|orts|ett\-|borta|bal|boll\-|svensk\-|Stockholms|spels|otten|sensations|final|proffs|skrll|Karlstads|Norrlands|NHL\-|serie|andy|[IV]\-|penhamns|lule|bandy|motstndar|Vsters|versitets)lag(et|en)?(" "{U}[^\n ]+)+	{printATH(yytext,1);}
[^\n ]*(Serieledar|sderettan|[Ll]agmaskin|Finalmotstndar|jolretsfinalister|gue\-nykomling|formstarka|tabesegrade|ottenkollegan|erieledande|1\-stall|stallet|stkollegan|emmastarka|ottentippade|[EV]M\-debutant|[Uu][Pp]\-utslagna|NHL\-kollega|kvalmotstndar|spelsplatskonkurrent)(en|na)?(" "{U}[^\n ]+)+	{printATH(yytext,1);}
[^ \n]*(llsvensk|igaled|erieled|eriesegr|[Mm]st|[Uu][Pp]\-vinn)arna(" "{U}[^\n ]+)+	{printATH(yytext,1);}
[Aa]llsvenska" "[^\n ]+derby	{ECHO;}
[Aa]llsvenska(" "{U}[^\n ]+)+	{printATH(yytext,1);}
[^ \n]*(abell|eague)\-(tv|tre|fyr|femm|sex)an(" "{U}[^\n ]+)+	{printATH(yytext,1);}
[^\n ]*(bolls|otten|[Tt]opp|jumbo|serie|I\-)gnget(" "{U}[^\n ]+)+	{printATH(yytext,1);}
[^\n ]*(At[e]n|dart|yk|ule|grad|hst|ockey|liga|topp|sim|glings|erings|star|proffs|segel|[Gg]olf|[Ss]tor|emma|bolls|lyg|onny|ykel|otor|Rid|ero|rrangr|[Dd]am|ugby|alm|owling|drotts|andy|holms|stads|\-|boll|Paris|ondon|dals|valla|borgs|stads|fors|desliga|im|asket)klubb(arna|en)(" "{U}[^\<\n ]+)+	{printATH(yytext,1);}
"Chalmers flygklubb"	{printATH(yytext,0);}
"Stanley "[Cc]up\-mstarna(" "{U}[^\<\n ]+)+	{printATH(yytext,2);}
"trnar med "([AB]\-laget|{U}+|{U}[^\n ]+s)" "innebandy	{printATH(yytext,2);}
	/* mot */
	/* <ATH></> ? ? mot|slog X+*/
({U}[^\n ]+" ")+(vann|spelade|fll|frlorade)" "(borta|hemma)" mot"(" "{U}[^\n ]+)+	{printATH(yytext,0);}
[^\n ]*(vann|spelade|fll|frlorade|avgjorde|avgra|[0-6]\-[0-6])" "(borta|hemma)" mot"(" "{U}[^\n ]+)+	{printATH(yytext,3);}
(vann|spelade|fll|frlorade)(" "{U}[^\n ]+)+" "(hemma|borta)" mot"(" "{U}[^\n ]+)+	{printATH(yytext,1);}
[^\n ]*(death|straffar|mafrlust|halvtid|stolpen|derbyt|[Ll]eague|VM|borta|ndskampen|inalerna|inaldramat)" mot"(" "{U}[^\n ]+)+	{printATH(yytext,2);}
[^\n ]*(emmamtet|bortamte|lslandskamp|itseriepremir|cupfinal)(en)?" mot"(" "{U}[^\n ]+)+	{printATH(yytext,2);}
[^\n ]*(nings|olls|ma|kval|rupp|cup|pels|eague\-|borta)match(en|er)?" mot"(" "{U}[^\n ]+)+	{printATH(yytext,2);}
[^\n ]*eague\-(mstare|mte)" med"(" "{U}[^\n ]+)+	{printATH(yytext,2);}
("blev utbytt"|"frsta period")" mot"(" "{U}[^\n ]+)+	{printATH(yytext,3);}
("nr hans lag"|"gamla lag \,")(" "{U}[^\n ]+)+	{printATH(yytext,3);}
[^\n ]+"hockeyns smsta lag"(" "{U}[^\n ]+)+	{printATH(yytext,3);}
"klarade "[0-9]\-[0-9]" mot"(" "{U}[^\n ]+)+	{printATH(yytext,3);}
[0-9]\-[0-9]" i "[^\n ]*"kvalet mot"(" "{U}[^\n ]+)+	{printATH(yytext,4);}
[0-6]\-[0-6]" mot"(" "{U}[^\n ]+)+" "{SPORTS}	{printATH(yytext,2);}
[0-6]\-[0-6]" fr "{U}[^\n ]+" mot "{U}[^\n ]+	{printATH(yytext,2);}
[0-6]\-[0-6]" mot "{U}[^\n ]+" "(\,|\.|[a-z])	{int i=8; putchar(yytext[0]); putchar(yytext[1]); putchar(yytext[2]); 
	 printf(" mot <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
	 for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");
	 for(;i<yyleng; putchar(yytext[i++]));}
"tvlar fr "{U}[^\n ]+s" "{U}+	{printATH(yytext,2);}
[^\n ]*(ednings|trst|sjlv|eger|nick)ml(et)?" mot"(" "{U}[^\n ]+)+	{printATH(yytext,2);}
[^\n ]*lokala" "laget(" "{U}[^\n ]+)+	{printATH(yytext,2);}
	/* a bit dangerous if >1 things following-Tennis! */
({U}[^\n ]+" ")+([0-6]\-[0-6]\-vann|[0-6]\-[0-6]\-besegrade|hemmabesegrade|hemmaslog|bortaslog)(" "{U}[^\n ]+)+	{printATH(yytext,0);}
({U}[^\n ]+" ")+(final|premir|skrll)vann	{printATH(yytext,11);}
[^\n ]*(vann|slog|krossade)(" "{U}[^\n ]+)+" med "[0-9]\-[0-9]	{printATH(yytext,102);}
[^\n ]*(vann|slog)(" "{U}[^\n ]+)+" p "(hemma|borta)plan	{printATH(yytext,102);}
(mot|fr)" "Team(" "{U}[^\n ]+)+	{printATH(yytext,1);}
(Han|Hon)" slog"(" "{U}[^\n ]+)+" med"	{ECHO;}
({U}[^\n ]+" ")+slog(" "{U}[^\n ]+)+" med"	{printATH(yytext,11);}
[^\n ]*(agledare|exproffs|agkaptenen|lvaktsdebutanten)" i"(" "[^\n ]ska)?(" "{U}[^\n ]+)+	{printATH(yytext,2);}
[^\n ]*([Mm]atch|final|M\-mte|VM|derby|kval|eague-final|inalserien|atchserien)(t|en|et)?" mellan"(" "{U}[^\n ]+)+" och"(" "{U}[^\n ]+)+	{printATH(yytext,2);}
Seriefreningen" elitvolleyboll"	{printATH(yytext,0);}
"matcher mot"(" "{U}[^\n ]+)+" med "[0-9]\-[0-9]	{printATH(yytext,202);}
({U}[^\n ]+" ")+slagit(" "{U}[^\n ]+)+" i en "[VE]M\-match	{printATH(yytext,103);}
({U}[^\n ]+" ")+pressade(" "{U}[^\n ]+)+" i "[VE]M\-kval	{printATH(yytext,1002);}
({U}[^\n ]+" ")+"vann med "[0-9]\-[0-9]" \( "[0-9]\-[0-9]" \) borta mot"(" "{U}[^\n ]+)+	{printATH(yytext,0);}
(derbyt|[EV]M\-kval)(" "{U}[^\n ]+)+\-{U}[^\n ]+	{printATH(yytext,1);}
"Vstra Frlunda "(vunnit|storspelat|klarade|tappade|mter|fll|P[1-9][0-9])	{printATH(yytext,11);}
[^\n ]*("kvitterade fr"|"segern mot"|"senast mot"|"trnare i"|"seger mot"|"frvrvet frn"|"hockey mellan"|"minuten mot")" Vstra Frlunda"	{printATH(yytext,2);}
[^\n ]*(strker|rdda|konkurrenten|slog|starka|gnget|jmt|finalen)" Vstra Frlunda"	{printATH(yytext,1);}
[^\n ]*ublikvnliga" Frlunda"	{printATH(yytext,1);}
[Kk]"lubbar \:"(" "{U}[^ \n]*)+(" , "{U}[^ \n]*" "{U}[^ \n]*)*" och"(" "{U}[^ \n]*)+	{printATH(yytext,2);}
[^\n ]*(spel|coach|landslag|lagkamrat|periode|pong|kapten|[Mm]atch|turnering)[a-z]*" "[a-z]+" Tre Kronor"	{printATH(yytext,2);}
[^\n ]*("matcher fr"|"bundskapten mot"|"manager fr"|"kamper i"|"mstare med"|"seger fr"|"skyttar i"|"kamper med"|"lagsman i"|"terbud till"|debut[a-z]*" i"|gngslge" "fr)" Tre Kronor"	{printATH(yytext,2);}
"Tre Kronors "[a-z]+	{printATH(yytext,11);}
"Tre Kronor "(fick|inte|skapa|kval|rddad|besegrad|miss|spela)	{printATH(yytext,11);}
[^\n ]*"spel med "{U}[^\n ]+klubben(" "{U}[^ \n]+)+	{printATH(yytext,2);}
(Svenska|{U}[^\n ]+borgs|{U}[^\n ]+sunds)" fallskrmsklubb"	{printATH(yytext,0);}
{U}[^\n ]+" "(Idrotts|Sim)allians	{printATH(yytext,0);}
[Ss]portchef" i "{U}[^\n ]+\:s" "[^\n ]+(boll|sektion)	{printATH(yytext,2);}
("mittfltare i"|"lagkapten i"|"spelklar fr"|"matchvinnare fr"|[Ss]portchef" i"|"mlskytt fr")(" "{U}[^ \n]*)+(" "[^\n ]+lag)?	{printATH(yytext,2);}
(ordfrande|spelarna)" i "(Iraklis|Landvetter|Djurgrden|Team" "{U}[^\n ]+)	{printATH(yytext,2);}
(i|in|bakom)" "{U}[^\n ]+s" "[^\n ]*(erbyseger|edningsml|backslinje|backlinje|mittflt|raffomrde)	{printATH(yytext,11);}
[^\n ]*(yrnations|[Ff]otbolls)turneringen" mot "{U}[^ \n]+	{printATH(yytext,2);}
(Modo|Djurgrden|Trelleborg|Frlunda|Brage|Ume|Hammarby|Elfsborg|Frjestad)s" "(juniorer|sportchef|stjrna|ml|kvittering|klubbdirektr)	{printATH(yytext,11);}
{U}[^\n ]+lands" "[^\n ]+(edningsml|ackslinje|acklinje|ittflt|raffomrde)	{printATH(yytext,11);}
{U}[^\n ]+s" "startelva	{printATH(yytext,11);}
[Aa]"llsvenska mte mellan "{U}[^ \n]+" och "{U}[^ \n]+	{printATH(yytext,3);}
[Jj]umbolagen(" "{U}[^ \n]+)+" och"(" "{U}[^ \n]+)+	{printATH(yytext,1);}
(topp|vnster|hger|landslags)forward" i"(" "{U}[^ \n]+)+	{printATH(yytext,2);}
	/* MOD (Jyrki Niemi): Fixed " Cup\-lag" -> "Cup\-lag" */
(Norge|Siriu|Brasilien|Hammarby|Blvitt|Djurgrden|Boi|Frlunda|Lule|Malm|Svehof|Skvde|Drott|Leksand|Degerfor|Toronto|United|Arsenal|Ranger|Chelsea|England|ster|{U}+\:|Ume|Gai|Bryn|Mora|Varenne|Alings|Eslv|Bayern|Modo|rgryte|Lazio|Tumba|Degerfor|Bajen|Vster|{U}[^\n ]+borg|Assyriska|{U}[^\n ]*stad|Real|Inter|Motala|Sundsvall|Toronto|Hcken|Timr|Kalmar|{U}[^\n ]+tlje|"New Jersey"|Parma|Pite|Herflge|{U}[^\n ]+kping|{U}[^\n ]+\-{U}[^\n ]+|{U}[^\n ]+" "{U}+\:)s" "[^\n ]*(stjrnspelare|guard|forward|mlvakt|trnare|mittfltare|manager|bollslag|herrlag|drmlag|mstarlag|Cup\-lag|laguppstllning|juniorlag|pojklag|[1-9][0-9]\-lag|hockeylag|landslags|damlag|uppvisning|supporterklack)	{printATH(yytext,11);}
rets" "[^\n ]*(anfallare|mlvakt|mittfltare|mittfltsstjrna|lagkapten|vnsterfrsvarare|hgerfrsvarare|mittfrsvarare)	{ECHO;}
{U}[^\n ]+s" "mlvaktsspel	{ECHO;}
{U}[^\n ]+s" "[^\n ]*(mlfarlige|nyckelspelare|frsvarsspelare|landslagsspelare|fotbollsspelare|stjrnspelare|U[12][0-9]\-spelare|anfallare|mlvakt|mittfltare|mittfltsstjrna|lagkapten|vnsterfrsvarare|hgerfrsvarare|mittfrsvarare)	{printATH(yytext,11);}
(Norge|Siriu|Brasilien|Hammarby|Blvitt|Djurgrden|Boi|Frlunda|Lule|Malm|Svehof|Skvde|Drott|Leksand|Degerfor|Toronto|United|Arsenal|Ranger|Chelsea|England|ster|{U}+\:|Ume|Gai|Bryn|Mora|Varenne|Alings|Eslv|Bayern|Modo|rgryte|Lazio|Tumba|Degerfor|Bajen|Vster|{U}[^\n ]+borg|Assyriska|{U}[^\n ]*stad|Real|Inter|Motala|Sundsvall|Toronto|Hcken|Timr|Kalmar|{U}[^\n ]+tlje|"New Jersey"|Parma|Pite|Herflge|{U}[^\n ]+kping|{U}+\:)s" "[1-9]\-[0-9]\-ml	{printATH(yytext,11);}
[Ss]panska" "(Vigo)	{printATH(yytext,1);}
[Gg]rekiska" "(Iraklis|Aris)	{printATH(yytext,1);}
[Dd]anska" "(lborg|Herflge|Brndby)	{printATH(yytext,1);}
"stjrnspckade "(United|Inter|Barcelona)	{printATH(yytext,1);}
DIF\/lvsj	{printATH(yytext,0);}
"rdbl rgryte"	{printATH(yytext,1);}
Cart\-serien	{printATH(yytext,0);}
([Ii]talienska|favoriterna|lokalrivalen)" "Milan	{printATH(yytext,1);}
[^\n ]*(VM\-|[Hh]emma|[Gg]uld)favoriterna(" "{U}[^ \n]+)+	{printATH(yytext,1);}
"AIK och Djurgrden"	{printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">AIK</ENAMEX> och <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">Djurgrden</ENAMEX>");}
"Victory Challange dubbelvann"	{printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">Victory Challange</ENAMEX> dubbelvann");}
(matchen|spela[a-z]*)" "(i|mot|med)" "ster	{printATH(yytext,2);}
Malms" "ml	{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">Malms</ENAMEX> ml");}
TFF" "vann	{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">TFF</ENAMEX> vann");}
" i "{U}[^\n ]+"s ml "	{int i=3; printf(" i <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX> ml ");}
"ordnade "{U}[^\n ]+"s trstml"	{int i=8; printf("ordnade <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX> trstml");}
" in "{U}[^\n ]+"s segerml mot "{U}[^\n ]+	{int i=4; printf(" in <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX> segerml mot ");
	printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); i=i+14;
	for(;i<yyleng; putchar(yytext[i++])); printf("</ENAMEX>");}
"gav "{U}[^\n ]+" "[1-9]\-[0-9]" mot "{U}[^\n ]+	{int i=4; printf(" gav <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");
	putchar(yytext[i++]); putchar(yytext[i++]); putchar(yytext[i++]); 
putchar(yytext[i++]); printf(" mot <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
	i=i+5; for(;i<yyleng; putchar(yytext[i++])); printf("</ENAMEX>");}
" in "{U}[^\n ]+"s segerml"	{int i=4; printf(" in <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX> segerml");}
" in "{U}[^\n ]+"s ledningsml"	{int i=4; printf(" in <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX> ledningsml");}
"gjorde "{U}[^\n ]+"s ml "	{int i=7; printf("gjorde <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX> ml ");}
"bda "{U}[^\n ]+"s ml "	{int i=5; printf("bda <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX> ml ");}
"gav "{U}[^\n ]+" ledningen "(efter|med|i|borta)	{int i=4; printf("gav <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");	for(;i<yyleng; putchar(yytext[i++]));}
	/* MOD (Jyrki Niemi): Fixed not to omit "segern" */
"gav "{U}[^\n ]+" segern med"	{int i=4; printf("gav <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX> segern med");}
"gav "{U}[^\n ]+" "[1-9]\-[0-9]	{int i=4; printf("gav <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");	for(;i<yyleng; putchar(yytext[i++]));}
{U}[^\n\- ]+s" "[a-z]+" "(frbundskapten|mittfrsvarare|lagkapten|mlvakt|anfallare|mittfltare|lagsfrsvarare|toppfrsvarare)	{	int i=0; printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");
	for(;i<yyleng; putchar(yytext[i++]));}
(Djurgrden|Frlunda|Timr|Drott|Skvde)" i elitserien"	{int i=0; printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">");
	for(;yytext[i]!=' ';putchar(yytext[i++])); printf("</ENAMEX>");
	for(;i<yyleng; putchar(yytext[i++]));}
"Champions League\-mstarna "{U}[^\n ]+	{printATH(yytext,2);}
{U}[^\n ]+" "(b|h)" "[0-9]\-[0-9]	{printATH(yytext,11);}
"EU:s herrar"	{ECHO;}
{U}+\:s" "(4x[14]00\-lag|herrar|damer|basketlag)	{printATH(yytext,0);}
{U}+\:s" "[^\n ]*"vinnande stafettlag"	{printATH(yytext,0);}
{U}[^\n ]+s" "[^\n ]+(farmar|bolls)lag	{printATH(yytext,0);}
([]verraskningslaget|FA\-cupfinalklara)(" "{U}[^ \n]+)+	{printATH(yytext,1);}
[^\n ]*matchen" ledde "HV	{printATH(yytext,2);}
[^\n ]*(matchen|final|kval)" "Sverige\-{U}[^\n ]+	{printATH(yytext,1);}
[^\n ]+andskampen" "{U}[^\n ]+\-{U}[^\n ]+	{printATH(yytext,1);}
snkte" United"(" "{U}[^\n ]+)?	{printATH(yytext,1);}
\n	{ECHO;}
.	{ECHO;}
%%
int printATH(char *a, int x)
{ int z=0; int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==102){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==1002){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==103){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; 
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
else if (x==202){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">"); 
for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>"); for(;c<yyleng; putchar(yytext[c++]));}
return(1);}
  int printATH_M(char *a)
{ printf("<ENAMEX TYPE=\"ORG\" SBT=\"ATH\">%s</ENAMEX>",yytext); return(1); }
main( argc, argv )
int argc;
char **argv;	
{	
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  
  yylex(); return(0);
}
