/*
	File: ObjPat.ll
	Author: Dimitrios Kokkinakis
	Version: 090730
	Finds: names of objects of different types
*/
%{
%}
U	[\101-\132\300-\335]
CITAT	\"|\|\'|\'\'|`
%{
  int printWVEH (char *a, int x);
  int printAVEH (char *a, int x);
  int printGVEH (char *a, int x);
  int printCMP (char *a, int x);
  int printPRD (char *a, int x);
  int printPRZ (char *a, int x);
  int printFWP (char *a, int x);
%}
%%
	/* EXCEPTIONS */
"\<ENAMEX TYPE\="\"(EVN|LOC|MSR|OBJ|ORG|PRS|WRK|TME|MDC|TRM)"\" SBT\=\""(ANM|ARL|AST|ATH|ATL|CLC|CLT|CLU|CMP|CRP|DEN|EDU|FIN|FNC|FWP|GPL|HPL|HUM|MDC|MTH|PER|PLT|PPL|PRD|PRJ|PRZ|RLG|RTV|STR|TVR|VHA|VHG|VHW|WAA|WAO|WMD|WMO|WTH|MDC|MDO|MDD|MDS|MDI|IDX)\"\>[^\n\<]+\<\/ENAMEX\>	{ECHO;}
"\<NUMEX TYPE\="\"MSR"\" SBT\=\""(DGR|VLM|TMP|INX|DST|CUR|DEN|PRC|CMU|WMU|XXX|TEL|LST|AGE|WEB|CVU|CRD|ELU)\"\>[^\n\<]+\<\/NUMEX\>	{ECHO;}
"\<TIMEX TYPE\="\"TME"\" SBT\=\""(DAT)\"\>[^\n\<]+"\<\/TIMEX\>"	{ECHO;}
	/* VEHICLES */
	/* TAG: <ENAMEX TYPE="OBJ" SBT="VHC"></ENAMEX> */
	/* AIR */
(Strids|Attack|Trafik)flygplan	{ECHO;}
(Olyckshelikoptern|"Georgia Satellite")	{ECHO;}
"Place de la Concorde"	{ECHO;}
gatuplanet" "{U}[^\n ]+	{ECHO;}
planet" "(Venus|Mars)	{ECHO;}
Mars" "{U}[^\n ]+" "(Orbite|Surveyo|Lande)r	{printAVEH(yytext,0);}
[^\n ]*(kretsaren|Satelliten|ometjgaren|[Ll]andaren|kretsaren|[Ss]onden|ymdstationen|[Rr]oboten|elikoptern|[Rr]ymdraket|ymdskeppet|ymdfrjan)" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printAVEH(yytext,0);}
[^\n ]*[Rr](ymdstation|obot|ymdraket)(en)?(" "{U}[^\n ]+)+	{printAVEH(yytext,0);}
[^\n ]*(ometjgare|[Ss]onde|kretsare|elikopter|arslandare|villinglandare|ymdskeppet|ymdfrja|Attackvigge|eppelinare)(n)?(" "{U}[^\n ]+)+	{printAVEH(yytext,1);}
[Ss]atelliten(" "[A-Z0-9][^\n ]*)+	{printAVEH(yytext,1);}
(flg" "en|flyger" "en|[Uu]"ppskjutningen av")(" "[A-Z0-9][^\n ]+)+	{printAVEH(yytext,2);}
"bemannad farkost"(" "{U}[^\n ]+)+	{printAVEH(yytext,2);}
[Rr]obotsystemet" "{U}[^\n ]+" "[0-9]+	{printAVEH(yytext,0);}
[Ss]ystem" "[0-9]+" Viggen"	{printAVEH(yytext,0);}
([Ss]pionsatellit|[Rr]obotsystem)(et)?" \, "{U}[^\n ]+" "[0-9]+	{printAVEH(yytext,2);}
[Ff]light" "[A-Z0-9]+(" "[0-9]+)?	{printAVEH(yytext,0);}
[A-Z]+" "[^\n ]+\-robotar	{printAVEH(yytext,0);}
(Airbus|Cessna|Mirage|Phantom|Fokker|Boeing)(" "|\-)[0-9]+(\/[0-9]+)?(\-[0-9]+)?([A-Z][A-Z][A-Z]?|\:a|\:an|\-maskin|\-maskiner|\-plan|\-planet)?	{printAVEH(yytext,0);}
(Aeroflot" ")?"Airbus "[A0-9\-\/]+([A-Z]|" "3[34]0)?(\-plan)?	{printAVEH(yytext,0);}
[^\n ]*(H[Kk][Pp]|[Hh]elikopter|[Hh]elikoptern|"McDonnell Douglas")" "[A-Z0-9\-]+	{printAVEH(yytext,0);}
("McDonnell Douglas "|Boeing" ")?(MD|DC)\-[1-9][0-9]?(\-[0-9]+|\:an|\:a)?	{printAVEH(yytext,0);}
Jas[0-9]+[^\n ]+	{printAVEH(yytext,0);}
"Jas "[0-9]+(" "{U}[^\n ]+)?	{printAVEH(yytext,0);}
	/*(Viggen|Tomcat|Awacs)(\-)?plan(et|en)?	{printAVEH(yytext,0);}*/
(TU|Beagle|MD|Ilushin|Tupolev|[Vv]oyager|Antonov)(\-|" ")[0-9A-Z]+(\:a|\:or|\/[0-9]+)?	{printAVEH(yytext,0);}
(A3[0-9]0\-[1-8]00|[^\n ]+anska" ")?("Lockheed LI"[0-9]+|"Sonic Cruiser"|"Pan Am"|"Sea Harrier"|MiG|Concorde|Mi[Gg]\-[1-4][1-4]|"32 Lansen"|[FJ][0-9]+" Draken"|"Mig "[1-8][0-9]\:or|Mig\-[1-8][0-9]\:or|DC" "3(\:a|\:an|\:or|\:orna)|Il-76|"DC 10"|F117A|Eurofighter|Cessna|Tupolev|Viggen|"F-18 Hornet"|Saab" Aero X"|"Saab 2 000"|"Saab 105"|S[Aa][Aa][Bb]" 340"|"Jas Gripen"|B52\:an|"B\-52"(\:a|\:an|\:or|\:orna)?|"C\-130 Hercules"|F16|F18|F16\/F18|Tu\-1[35]4)(\-planen|\-planet|\-[^\n ]*plan|prototypen)?	{printAVEH(yytext,0);}
([^\n ]+lines|747|Dash)\-[^\n ]*plan[etn]*	{printAVEH(yytext,0);}
([^\n ]+iska" Su "2[0-9]|[^\n ]+anska" F "1[68]|[^\n ]+anska" "F\-1[68]|[^\n ]+anska" "Mirage|"Super Puma"|"Mi 8-helikoptern"|"Apollo 1"[0-9]|"Spirit of St\. Louis")	{printAVEH(yytext,0);}
(nya|kpa|[0-9]+|ny|gammal)" "(Airbus|Gripen|J[Aa][Ss]|A380)	{printAVEH(yytext,1);}
({U}[^\n ]+" ")+Satellite	{printAVEH(yytext,0);}
sonderna(" "[A-Z0-9][^\n ]+)+" och"(" "[A-Z0-9][^\n ]+)+	{printAVEH(yytext,0);}
{U}[^\n ]+\-(robotar|missil|sond|satellit)(en|er|erna|na)?	{printAVEH(yytext,0);}
{U}[^\n ]+(helikopt[a-z]+|flygplan|flygplanet)	{printAVEH(yytext,0);}
(Nasas" rymd"|[^\n ]*ymd)sond(en)?(" "{U}[^\n ]+)+	{printAVEH(yytext,0);}
[^\n ]*planet" "{U}[^\n ]+" "[0-9]+(" "[0-9]+)?(" "{U}[^\n ]+)?	{printAVEH(yytext,1);}
[^\n ]*[Pp]lanet" \, en "{U}[^\n ]+(" "[0-9]+)	{printAVEH(yytext,3);}
[^\n ]*planet(" "{U}[^\n ]+)+(" "[0-9\_]+)?(" "[0-9\_]+)?	{printAVEH(yytext,1);}
[^\n ]*"plan av typen "{U}[^\n ]+" "[0-9\-]+(" "{U}[^\n ]+)?	{printAVEH(yytext,3);}
[^\n ]*"planet av typen "{U}[^\n ]+	{printAVEH(yytext,3);}
[^\n ]*"plan av "(modell|typ)en(" "{U}[^\n ]+)+	{printAVEH(yytext,3);}
	/* MOD (Jyrki Niemi): Corrected context to 2 (was 3) */
[^\n ]*"plan av "[^\n ]+\-typ	{printAVEH(yytext,2);}
[^\n ]*"plan "(A" "10|[0-9]+" Gripen")	{printAVEH(yytext,1);}
[^\n ]*"plan \, av typ "{U}[^\n ]+	{printAVEH(yytext,4);}
[^\n ]*(jet|umbo|sagerar)plan(et)?" "[A-Z\/0-9\-]+	{printAVEH(yytext,1);}
Lufthansas" plan "[A-Z\/0-9\-]+	{printAVEH(yytext,0);}
Embraer" "[A-Z]+\-[0-9]+	{printAVEH(yytext,0);}
[^\n ]*[Mm]nlandaren(" "{U}[^\n ]+)	{printAVEH(yytext,1);}
	/******************/
	/* WATER */
U\-btar	{ECHO;}
"Gotheborg "I+	{printWVEH(yytext,0);}
{U}[^\n ]+" of the Seas"	{printWVEH(yytext,0);}
[Pp]" Estonia"	{printWVEH(yytext,1);}
(S\/V|S\/S|S\/Y|m\/s|M\/S|HMS|USS|s\/s|t\/s|M\/F)" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printWVEH(yytext,0);}
(S\/V|S\/S|S\/Y|m\/s|M\/S|HMS|USS|s\/s|"H M S"|t\/s|M\/F)(" "{U}[^\n ]+)+	{printWVEH(yytext,0);}
[Oo]stindiefararen(" "{U}[^\n ]+)?	{printWVEH(yytext,0);}
[^\n ]*(Amerikalinjens|trimaran|galjon|[Ff]regatt|[Gg]aleas|[Kk]atamaran|prm|[Ff]arkost|[Kk]orvett|[Bb]t)(en)?" "{CITAT}(" "[^\,\n ][^\n\"\'\]+)+" "{CITAT}	{printWVEH(yytext,1);}
[^\n ]*(ilfraktare|julngare|larngare|[Ss]konare|sbrytare|[Jj]agare|trlare|riggare|[Kk]utter|racer|[Tt]anker|[Kk]ryssare|[Ff]rja)(n)?" "{CITAT}(" "[^\n\"\'\]+)+" "{CITAT}	{printWVEH(yytext,1);}
[^\n ]*([Ff]artyg|[Ss]kepp)(et)?" "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printWVEH(yytext,1);}
[^\n ]*([Kk]uttern|[Tt]ankern|[Ff]artyget|[Kk]ryssaren|[Ff]rjan|[Bb]ten|[Ss]keppet)(" "{U}[^\n ]+)+" of"(" "{U}[^\n ]+)+	{printWVEH(yytext,1);}
[^\n ]*(trimaran|[Jj]agare|[Ff]regatt|[Gg]aleas|[Kk]atamaran|riggare|[Kk]utter|[Ff]regatt|prm|racer|[Tt]anker|[Ff]arkost|[Ff]artyg|[Kk]orvett|[Kk]ryssare|[Ff]rja|[Bb]t|[Ss]kepp)(en|et|n)?" \,"(" "{U}[^\n ]+)+" "[\.\,]	{printWVEH(yytext,2);}
[^\n ]*(svepare|Briggen|yachten|ljeriggen|erviceriggen|trlare|[Tt]rimaran|riggare|[Gg]aleasen|[Ss]konerten|[Ff]regatten|prmen|racern|[Tt]ankern|[Ff]arkosten|[Ff]artyget|[Ff]artygen|[Kk]orvetten|[Kk]ryssare|[Ff]rja|[Bb]ten|[Ss]keppet|larngaren|lyxjakten|ilfraktare|sbrytare|[Ss]konare|fraktskuta)(n)?(" "{U}[^\n ]+)+(" "[0-9]+)?	{printWVEH(yytext,1);}
([Tt]v|vars)" fartyg"(" "{U}[^\n ]+)+" och"(" "{U}[^\n ]+)+	{printWVEH(yytext,2);}
[^\n ]*([Bb]ta|[Ss]konerte)rna(" "{U}[^\n ]+)+" och"(" "{U}[^\n ]+)+	{printWVEH(yytext,1);}
[Ss]konerterna" "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}" och "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printWVEH(yytext,1);}
([Vv]ntade|[Tt]v|vars)" fartyg "(\:|\,)(" "{U}[^\n ]+)+" och"(" "{U}[^\n ]+)+	{printWVEH(yytext,2);}
([Vv]ntade|[Tt]v|vars)" fartyg "(\:|\,)(" "{U}[^\n ]+)+	{printWVEH(yytext,2);}
[^\n ]*"fartyg r jgaren"(" "{U}[^\n ]+)+	{printWVEH(yytext,3);}
([0-9]+" ")?[0-9]+\-(fot|tonn)are(n)?" "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printWVEH(yytext,0);}
([0-9]+" ")?[0-9]+\-(fot|tonn)are(n)?(" "{U}[^\n ]+)+	{printWVEH(yytext,0);}
{U}[^\n ]*\-bt(arna|ar|en)	{printWVEH(yytext,0);}
gick(" "[A-Z0-9][^\n ]+)+" p grund"	{printWVEH(yytext,12);}
[^\n ]*(bt|btarna|btar)" av typ"(en)?(" "{U}[^\n ]+)+	{printWVEH(yytext,3);}
bt" av modell"(" "{U}[^\n ]+)+	{printWVEH(yytext,3);}
"frjan under namnet"(" "{U}[^\n ]+)+	{printWVEH(yytext,3);}
"vraket efter"(" "{U}[^\n ]+)+	{printWVEH(yytext,2);}
"oljan frn vraket"(" "{U}[^\n ]+)+	{printWVEH(yytext,3);}
"Ombord i"(" "{U}[^\n ]+)+	{printWVEH(yytext,2);}
(skeppare|skepparen|kapten|[Oo]mbord)" p "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printWVEH(yytext,2);}
[^\n ]*(kapten" p"|[Oo]mbord" p"|"bt var")" "[^\n ]"s "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printWVEH(yytext,2);}
(skeppare|skepparen|kapten|[Oo]mbord)" p"(" svenska")?(" "{U}[^\n ]+)+	{printWVEH(yytext,2);}
"supertanker \, \" "{U}[^\n ]+" \" och \" "{U}[^\n ]+" \""	{printWVEH(yytext,2);}
"btar "{U}[^\n ]+" och "{U}[^\n ]+	{printWVEH(yytext,0);}
^({U}[^\n ]+" ")+sjsttes	{printWVEH(yytext,11);}
{U}[^\n ]+s" "frlisning	{printWVEH(yytext,11);}
"\" "("Americas Challenger"|"Swedish Match"|"EF Education"|"EF Language")" \""	{printWVEH(yytext,0);}
"andraplacerade Swedish Match"	{printWVEH(yytext,1);}
"sin "(H\-|Star)bt	{printWVEH(yytext,1);}
"en Maxi 95"	{printWVEH(yytext,1);}
"VO 60"\:[a-z]+	{printWVEH(yytext,0);}
[Ff]lottans" fregatt "[A-Z][^\n\t\< ]+	{printWVEH(yytext,1);}
[^\n ]*([Kk]ryssning" "med|[Bb]esttningen" "p|"deras "[^\n ]*bt|"linjens fartyg"|[Ff]"artyget heter")(" "{U}[^\n ]+)+	{printWVEH(yytext,2);}
[^\n ]*([Kk]ryssning" "med|[Bb]esttningen" "p)" "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printWVEH(yytext,2);}
	/* MOD (Jyrki Niemi): Modified regexp to convert correctly to
	   Pmatch: optional explicit "Queen" for all alternatives */
[^\n ]*(propellerdriven|godslastade|brga|Danmarks-fararen|fartyg)(" "Queen)?(" "{U}[^\n ]+)+	{printWVEH(yytext,1);}
"Viking Lines frjor"	{printWVEH(yytext,0);}
{U}+\-frj(a|or|orna|an)	{printWVEH(yytext,0);}
{U}+\-(fartyg|frjan)	{printWVEH(yytext,0);}
(KBV|Najad|Mal|Oceanis)" "[0-9][0-9][0-9]?	{printWVEH(yytext,0);}
ubt(en)?" "(U" "[0-9]+|[0-9]+)	{printWVEH(yytext,1);}
	/******************/
	/* GROUND */
"handelsjtten Amazon"	{ECHO;}
"Austin Powers"	{ECHO;}
"Austin Green"	{ECHO;}
(Fiat|Opel|Mitsubishi|Audi|Nissan|Rolls\-Royce)" "(Auto|Sverige|Motor)s?	{ECHO;}
[^\n ]*mobilen" "{U}[^\n ]+" "[0-9]+	{printCMP(yytext,1);}
"Audi "[0-9\/A-Z]+(cc)?(" Avant"|" Quatro"|" "[346])?	{printGVEH(yytext,0);}
(Bugatti|"Alfa Romeo")" "[A-Z0-9]+	{printGVEH(yytext,0);}
"BMW "[0-9]+(ti|i|d|iA|[A-Z][1-9]|DA)?(" Sedan"|" Coup"|" Touring"|" Compakt"|" Cabriolet")?	{printGVEH(yytext,0);}
"BMW "[0-9]+" "(ti|i|d|iA|[A-Z][1-9]|DA)(" Sedan"|" Coup"|" Touring")|" Compakt"|" Cabriolet"?	{printGVEH(yytext,0);}
"Cadillac "\-?[0-9]+	{printGVEH(yytext,0);}
"Citro[e]n "[A-Z0-9]+	{printGVEH(yytext,0);}
"Chevrolet "(Tahoe|Beauville|Caprice|Cavalier|Camaro|Lumina|"Bel Air"|Suburban|Corvette|Blazer|"Trans Sport")	{printGVEH(yytext,0);}
(Kawasaki|Honda)" "[A-Z0-9\-]+(" "[0-9]+)?	{printGVEH(yytext,0);}
"Fiat "[1-9]00	{printGVEH(yytext,0);}
"Ferrari "({U}[^\n ]+|365)	{printGVEH(yytext,0);}
"Ford "(Galaxie|Thunderbird|Thunderbirden|Roaster|Ranger|Mustang|Ka|Streetka|Windstar|Aerostar|Anglia|Galaxy|Sierra|Focus|Ka|Lincoln|Fiesta|Escort|Mondeo|Scorpio|Granada)(" GL"|" XR2i")?	{printGVEH(yytext,0);}
"Jeep "Grand" "{U}[^\n ]+	{printGVEH(yytext,0);}
"Land Rover"(n)?	{printGVEH(yytext,0);}
"Lotus "(Esprit|Super" Seven"|Seven)(\-kopia)?	{printGVEH(yytext,0);}
"Mercedes "([A-C]\-klass|[CESLKA][CESLKMG]*)(" ")?[0-9]+(E\-[0-9]+)?	{printGVEH(yytext,0);}
"Mercedes "[1-9][0-9]0([A-Z])?	{printGVEH(yytext,0);}
"Mazda "[0-9\-A-Z]+	{printGVEH(yytext,0);}
"Nissan "{U}[^\n ]+" "[1-9]\,[0-9]	{printGVEH(yytext,0);}
"Nissan "{U}[^\n ]+(" "[0-9]+)?	{printGVEH(yytext,0);}
Opel(s)?" "(Tigra|Agila|Astra|Kadett|Omega|Sintra|Vectra|Manta|Zafira|Frontera)(" "[A-Z]+)?	{printGVEH(yytext,0);}
"Peugeot "[0-9][0-9][0-9](" "[A-Z]+[0-9]*|" "Coup|" "Maxi)?	{printGVEH(yytext,0);}
"Porsche "9[0-9][0-9]	{printGVEH(yytext,0);}
"Renault "(5|Scenic|Scnic|Clio|Espace|Laguna|M[e]gane|Twingo|Kangoo)(" GTE")?	{printGVEH(yytext,0);}
"Saab "(900|9\-[2-9]|9\.[2-9]|9\-[2-9]\-cabriolet)S?(" "[1-3]\,[0-4]t|" "[1-3]\.[1-3])?(" GX"|" Turbo"|" GT")	{printGVEH(yytext,0);}
"Toyota "(RV4|Celica|Prius|Hiace|Previa|Picnic|Yaris|Camry|Corolla|Landcruiser|Prius|Avensis|Carina|[^\n ]+wagon)(" "[0-9]+[0-9\,]*)?	{printGVEH(yytext,0);}
"Suzuki "{U}[^\n ]+(" "[0-9\,]+)?	{printGVEH(yytext,0);}
"Subaru "(Impreza|Forester|Outback|Legacy)(" "[^\n ]+" "[AWDXTR])?	{printGVEH(yytext,0);}
Volvo" "[0-9]+00" milj"	{ECHO;}
"Volvo "(S|V)[1-9]0	{printGVEH(yytext,0);}
"Volvo "(S|V)" "[0-9SVC\/]+	{printGVEH(yytext,0);}
Volvo\-[0-9][0-9]\:(an|a)	{printGVEH(yytext,0);}
"Volvo "[0-9][0-9][0-9](" "Turbo|" "GLT|" "GLE|\:an|\:a|\-serien)?	{printGVEH(yytext,0);}
"Volvo "[0-9][0-9][0-9]\/[0-9][0-9][0-9]	{printGVEH(yytext,0);}
[^\n ]+\-Volvon	{printGVEH(yytext,0);}
(Volvos|Volvo)" "XC[1-9]0	{printGVEH(yytext,0);}
S[Aa][Aa][Bb]" "[1-9]\-[1-9](X|\-klassen|\-serien|[A-Z])?(" "[1-9]\,[0-9])?	{printGVEH(yytext,0);}
S[Aa][Aa][Bb]" "90+(\/[0-9]+|i|[A-Z][A-Z]|V4)?	{printGVEH(yytext,0);}
(VW|Volkswagen)" "(Jetta|Beetle|Golf|Polo|Vento|Bora|Lupo|Passat)(" "[1-9]\.[0-9]i)?	{printGVEH(yytext,0);}
{U}+\-buss(en)?	{printGVEH(yytext,0);}
"Jaguar "([A-Z]\-type|[A-Z0-9]+)	{printGVEH(yytext,0);}
"XJR Jaguar"(" "[A-Z0-9]+)?	{printGVEH(yytext,0);}
VW\-bubbla(n)?	{printGVEH(yytext,0);}
[^\n ]*hjulsdrivna(" "{U}[^\n ]+)+(" "[0-9A-Z\:a]+)?	{printGVEH(yytext,1);}
[^\n ]*(bensin|tanol|cell|hjuls)driven" "{U}[^\n ]+(" "[0-9]+)?	{printGVEH(yytext,1);}
"hjulsdrivaren "[0-9]+(" "{U}[^\n ]+)+	{printGVEH(yytext,1);}
[^\n ]*"sitsig version av "[0-9A-Z][^\n ]+	{printGVEH(yytext,2);}
[^\n ]*(tridsvagnen|sitsig|oadstern)(" "{U}[^\n ]+)+	{printGVEH(yytext,1);}
[Dd]"ivision "[0-9]\-serie	{ECHO;}
({U}[^\n ]+" ")+[0-9]+" "([0-9]+\-kombin|[0-9]+\-serie|Turbo|[Cc]abriolet|[Vv]oyger|[Cc]c|[Cc]orvette|[Cc]oup|Diesel|[Dd]iesel" "[Tt]urbo|Touring|Transporter|Sportwagon)	{printGVEH(yytext,0);}
({U}[^\n ]+" ")+([0-9]+\-kombin|[0-9]+\-serie|Turbo|[Cc]abriolet|[Vv]oyger|[Cc]c|[Cc]orvette|[Cc]oup|Diesel|[Dd]iesel" "[Tt]urbo|Touring|Transporter|Landcruiser|Sportwagon)	{printGVEH(yytext,0);}
"tillverkar sin "[^\n ]" "([0-9]+\-serie|[Cc]abriolet|[Cc]oup)	{printGVEH(yytext,2);}
[^\n ]*(pendeln|[Bb]ilen|[Jj]eepen|onceptbil)(" "{U}[^\n ]+)+	{printGVEH(yytext,1);}
[^\n ]*[Bb]"ilen "{CITAT}(" "[A-Z][^\n\"\'|\]+)+" "{CITAT}	{printGVEH(yytext,1);}
(Volvo|[Ll]gpris|[Pp]restige|[Ll]iters|[Ss]edan|[Bb]il|sport)modellen(" "[A-Z0-9][^\n ]+)+	{printGVEH(yytext,1);}
{U}[^\n ]+" "G[^\n ]X" "[1-9]\,[1-9]	{printGVEH(yytext,0);}
[^\n ]*"bil av mrket"(" "{U}[^\n ]+)+	{printGVEH(yytext,3);}
[^\n ]*([Bb]il|[Bb]ils|eep)mrket(" "{U}[^\n ]+)+	{printGVEH(yytext,1);}
[^\n ]*(vagn|[Bb]il)(ar)?" av typ"(" "[A-Z0-9][^\n ]+)+	{printGVEH(yytext,3);}
	/*varumrket moved up; cause of varumrket Volvo */
[Vv]arumrket" "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printPRD(yytext,1);}
[Vv]arumrke(t)?(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
(Plymouth|Amazon|Audi|Austin|Chrysler|Citro[e]n|Dodge|Fiat|Honda|Hyundai|Isuzu|Jeep|KIA|Lada|Lamborghini|Lancia|"Alfa Romeo"|Mitsubishi|Mazda|Nissan|Oldsmobile|Opel|Peugeot|Porsche|Renault|Seat|Skoda|Subaru|Suzuki|Toyota|VAZ|Rolls\-[Rr]oyce|Triumph|VW|Vauxhall|Volkswagen|Volvo|Saab)"s modell"(" "{U}[^\n ]+)+	{printGVEH(yytext,0);}
([^\n ]*kra|sin|hennes|[Hh]ans|kr|typen|rkerivalen|egen|den|modellen|nykomlingen)" "(Plymouth|Amazon|Audi|Austin|Chrysler|Citro[e]n|Dodge|Fiat|Honda|Hyundai|Isuzu|Jeep|KIA|Lada|Lamborghini|"Alfa Romeo"|Lancia|Mitsubishi|Mazda|Nissan|Oldsmobile|Opel|Peugeot|Porsche|Renault|Seat|Skoda|Subaru|Suzuki|VAZ|Rolls\-[Rr]oyce|Toyota|Triumph|VW|Vauxhall|Volkswagen|Volvo|Saab|Mercedes|Pontiac)(" "{U}[^\n ]+)*(" "[0-9\-]+)?(" "[A-Z]?[A-Z]?[A-Z])?	{printGVEH(yytext,1);}
	/* gr Toyotan */
[^\n ]*(mrket|Den|tillverkar|trasig|dammig|En|grna|byggd|vita|sin|begagnad|lilla|[Nn]ya|nyare|rda|bla|vitt|gamla|stora|gr|bl|vit|svart|[Rr][][Dd]|brun|grn|gul|ny|liten|frgad|kerade|gammal|stulen|gula|bruna|givna|modellen|brnslesnla)" "(Morris|Folka|Plymouth|Amazon|Audi|Austin|Chrysler|Mustang|Citro[e]n|Ford|Dodge|Fiat|Golf|Golfen|Honda|Hyundai|Isuzu|Jeep|KIA|Lada|Datsun|McLaren|Lamborghini|Lancia|Mercedes|Chevan|Lincoln|"Alfa Romeo"|Mitsubishi|Mazda|Nissan|Oldsmobile|Opel|BMW|Peugeot|Porsche|Renault|Seat|Skoda|Subaru|Suzuki|Toyota|VAZ|Rolls\-[Rr]oyce|Triumph|VW|Vauxhall|Volkswagen|Volvo|Kawasaki|Saab)(" "{U}[^\n ]+)*(" "[0-9\-]+)?(" "[A-Z]?[A-Z]?[A-Z])?	{printGVEH(yytext,1);}
[^\n ]*(registrerade|mmas|grna|vita|appas|lilla|nya|rda|bla|gra|svarta|bruna|gula|frgade|kerade|gamla|utrustad|stulna|rostiga|frsk|vanlig|trnga)" "(Plymouth|Amazon|Audi|Austin|Chrysler|Citro[e]n|Dodge|Lotus|Golf|Fiat|Honda|Hyundai|Isuzu|Jeep|KIA|Lada|Lamborghini|Lancia|"Alfa Romeo"|Mitsubishi|Mazda|Nissan|Oldsmobile|Opel|Peugeot|Porsche|Renault|Seat|Skoda|Subaru|Suzuki|Toyota|VAZ|Rolls\-[Rr]oyce|Datsun|Triumph|VW|Vauxhall|Volkswagen|Golf|Volvo|Saab)(en|n)?(" "{U}[^\n ]+)*	{printGVEH(yytext,1);}
(Plymouth|Audi|Austin|Chrysler|Citro[e]n|Dodge|DeLorean|Fiat|Honda|Hyundai|Isuzu|Jeep|KIA|Lada|Lamborghini|Lancia|Mitsubishi|Mazda|"Alfa Romeo"|Nissan|Oldsmobile|Opel|Peugeot|Porsche|Renault|Seat|Skoda|Subaru|Suzuki|Toyota|Volkswagen|Rolls\-[Rr]oyce|Triumph|VAZ|VW|Vauxhall|Aston-Martin)(" "{U}[^\n ]+)+	{printGVEH(yytext,0);}
"rd med "(Lamborghini|BMW|Porsche|Rolls\-[Rr]oyce|Mercedes|Saab)(" "{U}[^\n ]+)*(" "[0-9\-]+)?	{printGVEH(yytext,2);}
" en "(Plymouth|Amazon|Audi|Austin|Chrysler|Citro[e]n|Dodge|Fiat|Honda|Hyundai|Isuzu|Jeep|KIA|Lada|Lamborghini|Lancia|"Alfa Romeo"|Mitsubishi|Mazda|Nissan|Oldsmobile|Opel|Peugeot|BMW|Porsche|Renault|Seat|Skoda|Subaru|Suzuki|Toyota|VAZ|Rolls\-[Rr]oyce|Datsun|Triumph|VW|Vauxhall|Volkswagen|Volvo|Saab)(" "{U}[^\n ]+)*	{int i=4; 	printf(" en <ENAMEX TYPE=\"OBJ\" SBT=\"VHG\">");
	for(;i<yyleng;putchar(yytext[i++])); printf("</ENAMEX>");}
[0-9]+" en helt ny bil"	{printGVEH(yytext,40);}
("Coupe de"|"GL Express")" "{U}[^\n ]+	{printGVEH(yytext,0);}
[Ss]"tridsfordon "[0-9]+	{printGVEH(yytext,0);}
[^\n ]*(ghets|svv|bb)"tget "{U}[^\n ]+	{printGVEH(yytext,0);}
(sin|en)" "Harley(" "Davidson)?	{printGVEH(yytext,0);}
Husqvarna" "[0-9\-]+(cc)?	{printGVEH(yytext,0);}
(lng-merca|"9-5 Aero")	{printGVEH(yytext,0);}
{U}+\-bil(" "{U}[^\n ]+)+	{printGVEH(yytext,0);}
{U}+[^\n ]*\-(stridsvagnar|bussar|cabben|traktor|traktorn|bussarna|limousiner|bil|bilar|bilen)(na)?	{printGVEH(yytext,0);}
(SUV\:[a-z]+|lyx\-SUV|E\-klasskombi|Birkin" "S[1-9]|T\-Ford)	{printGVEH(yytext,0);}
(sin|[Nn]ya|modellen|modellerna|i)" "(Ferrari|[SV][456]0)	{printGVEH(yytext,1);}
[^\n ]*buss" "[0-9][0-9]?[0-9]?	{printGVEH(yytext,0);}
[^\n ]*(ter|tre|fem|fyr|[0-9]+\-)vxlade(" "{U}[^\n ]+)+	{printGVEH(yytext,1);}
[0-9]+" "(Ferrari|Maserati|Lotus)	{printGVEH(yytext,0);}
[^\n ]*(modellen|gamla|[Nn]ya|bil|vagn|rymliga|kup|kupn|kra)" "(4th" "Thunderbird|Laguna" "II|Leopard|Cross" "Country|Celica|Lotus|Jaguaren|Omega|Polo|Passat|S[86]0|V65|[CV]70|S\/V70|S\/V40)(\-modellen)?	{printGVEH(yytext,1);}
[^\n ]*"cykel "Mustang	{printGVEH(yytext,1);}
[^\n ]*cylindri(g|ga)(" "{U}[^\n ]+)+	{printGVEH(yytext,1);}
	/* FOOD and WINE */
[^\n ]*(whiskyn|whisky-sort|[Ff]rukt|[Dd]rink|[Dd]ryck|[Ss]vamp|[Dd]ruvsort|[Ss]allad|[Gg]lass)en(" "{U}[^\n ]+)+	{printFWP(yytext,1);}
([Vv]ild|[Mm]ar)svinet" "{U}[^\n ]+	{ECHO;}
[^\n ]*([Mm]argarin|[]ppl|[Vv]in|smr)et(" "{U}[^\n ]+)+	{printFWP(yytext,1);}
[^\n ]*([Kk]onjak|[Tt]uggummit|[Dd]ruvan|ljummen|dricka)(" "{U}[^\n ]+)+	{printFWP(yytext,1);}
[^\n ]*([Rr]aps|[Ff]isk|[Oo]liv)oljan(" "{U}[^\n ]+)+	{printFWP(yytext,1);}
[Vv]inet" heter"(" "{U}[^\n ]+)+	{printFWP(yytext,2);}
(let|[Kk]affe|[Kk]onjaks|[Gg]lass|whisky|l)mrket(" "{U}[^\n ]+)+	{printFWP(yytext,1);}
({U}[^\n ]+" ")+[Pp]inot" "(Blanc|Noir|[Gg]ris)	{printFWP(yytext,0);}
[^\n ]*Pinot(" "{U}[^\n ]+)+	{printFWP(yytext,0);}
[cdm]l" "(Schweppes|Kelda|Tea|Cognac|Heinz|Herrljunga|Ocean|Cr[e]me" "de)(" "{U}[^\n ]+)*	{printFWP(yytext,1);}
" "(cl|dl|ml|en)" "([^\n ]+" ")?("Bl Band"|"Pepsi Max"|"Pepsi\-Cola"|"Coca "[Cc]ola|Ramlsa|Tuborg|Coca\-Cola|Pepsi|"Pepsi Cola"|"Johhny Walker"|R[e]my" Martin"|Guinness|Guiness|Fanta)	{printFWP(yytext,2);}
" "(drick[aer]+|kall|ny|sin|mngd|klunk|dricka|[a-z]*drack|gill[a-z]+|mest)" "("Pepsi\-Cola"|"Coca Cola"|Ramlsa|Tuborg|Coca\-Cola|Pepsi|[Kk]orv" "Stroganoff|"Pepsi Cola"|"Johhny Walker"|"Grand Marnier"|Singha|"Remy Martin"|"Pripps Bl"|"Absolut "[Vv]odka|cola)	{printFWP(yytext,2);}
({U}[^\n ]+\-l|{U}[^\n ]+\-let|frapp|glhwein|gzelme|t[sz]at[sz]iki|vermouth|[Bb]"oeuf "[Bb]ourguignon|"Kelloggs cornflakes"|[Oo]\'boy|"Active Rheuma "[Pp]lus|cornflakes|carpaccion|"Big MC \& Co"|Big\-Mac|"Big "[Mm]ac(k)?(s)?|"Diet Pepsi"|7\-up|lussekatter|Les" Fumes Blanches"|Les" "Fumes|After" "Eight)(en)?	{printFWP(yytext,0);}
(serveras|koppar|servera)" "("Lfbergs "[Ll]ila|[Ee]"arl "[Gg]rey|Ramlsa)	{printPRD(yytext,1);}
Kelloggs(" "{U}[^\n ]+)+	{printPRD(yytext,0);}
(Pripps|Norrlands|bro|Spendrups|Falcon|Jmtlands|"Nils Oskars")" "[Jj]ul(l|brygd)?	{printFWP(yytext,0);}
[^\n ]+ums" "Akvavit	{printFWP(yytext,0);}
{U}[^ \n]+" "(Cisk|Winter|Dark)" Lager"	{printFWP(yytext,0);}
{U}[^ \n]+" Blanc de Blancs"	{printFWP(yytext,0);}
({U}[^\n ]+" ")+(VSOP|"Grande Anne"|"Dame Ros"|"Grand Cru"|"Premier Cru"|"Sauvignon Blanc"|"XO Special"|"Gran Reserva")(" "{U}[^\n ]+)?	{printFWP(yytext,0);}
({U}[^\n ]+" ")+de(" "{U}[^\n ]+)(Beaujolais|Riserva|Chardonnay)(" "{U}[^\n ]+)?	{printFWP(yytext,0);}
({U}[^\n ]+" ")+(Cabernet|Riesling|Sauvignon|Beaujolais|Riserva|Chardonnay)(" "[A-Z0-9\-][^\n ]+)?	{printFWP(yytext,0);}
"Rioja "[^\n ]+" "[Rr]eserva	{printFWP(yytext,0);}
Vino" "{U}[^\n ]+" di"(" "{U}[^\n ]+)+	{printFWP(yytext,0);}
(rd|vitt)" "(Cabernet|Riesling|Sauvignon|Beaujolais|Riserva|Chardonnay)(" "{U}[^\n ]+)*	{printFWP(yytext,1);}
(litet|helt|ett)" glas"(" "{U}[^\n ]+)+	{printFWP(yytext,2);}
(Semper" "[^\n ]+ersttning|"Karl Johan svamp"|"Gustav II Adolfs\-bakelse"|"Gustav Adolfsbakelse"|"Thousand Islanddressing"|Old" "[Bb]eefeater)[^\n ]*	{printFWP(yytext,0);}
"ett paket"(" "{U}[^\n ]+)+	{printFWP(yytext,2);}
"ett Ingrid Marie"	{printFWP(yytext,1);}
Ch[a]teau" "{U}[^\n ]+" "[12][0-9][0-9][0-9]	{printFWP(yytext,0);}
[Bb]utelj(er)?(" "{U}[^\n ]+)+	{printFWP(yytext,1);}
	/* Prizes */
(S|Syd)venska" Dagbladets "[^\n ]+(gdguld|medalj|pris)	{printPRZ(yytext,0);}
(Goncourt|Pulitzer|Booker|Silverbjrnen|"Alternativa Nobel"|"Sten "[^\n ]+)pri[sz](et)?	{printPRZ(yytext,0);}
("US Open"|"Stanley Cup"|"Henri Delaunay")\-(pokalen|buckla|trof)(n)?	{printPRZ(yytext,0);}
" "(inhstat|ingen|egen|hmta|tilldelats|ger|gett|ha|tilldelades|andra|en|ftt|fick|emot|vann)" "(Grammy|Emmy|[Gg]rammis|Rockbjrn|Oscar|Guld[^\n ]+|guldpalmen|"Golden Globe")	{/*Guldknappen,Guldpalm*/printPRZ(yytext,2);}
Ingen" "(Emmy|Grammis|Grammy|Rockbjrn|Oscar|Guld[^\n ]+)	{printPRZ(yytext,1);}
"fick "{U}[^\n ]+" "[A-Z]" "{U}[^\n ]+(priset|medaljen|stipendiet)	{printPRZ(yytext,1);}
(fr|gr|emot|prestigefyllda|egen|hmta|tilldelats|ger|gett|ha|tilldelades|andra|en|ftt|fick|honom|henne)" "{U}[^\n ]+(buckla|statyett|priset|medaljen|orden|stipendiet)	{printPRZ(yytext,1);}
([Tt][Vv]\-|[Uu]ngdoms|[Pp]rogram)priset(" "{U}[^\n ]+)+	{printPRZ(yytext,0);}
{U}[^\n ]+" "{U}[^\n ]+\-(pokal|pris|diplom)(et|en|er|erna)?	{printPRZ(yytext,0);}
({U}+"\:s ")?(Lill|Stor)a" "[^\n ]*pris(et)?	{printPRZ(yytext,0);}
(Volvo|Riksbanken|SvD\:|{U}+\:)s" "[^\n ]*pris(et)?	{printPRZ(yytext,0);}
("Gteborgs stads"|Nobels|Nordiska|Nordiska" "[Rr]dets)" "[^\n ]*pris(et)?	{printPRZ(yytext,0);}
(gr|han|hon)" "{U}[^\n ]*(priset|medaljen|orden)(" "{U}[^\n ]+)+	{printPRZ(yytext,1);}
(han|hon)" "{U}[^\n ]+(priset|medaljen|orden)	{printPRZ(yytext,1);}
(Kungl[^\n ]*" Ingenjrsvetenskapsakademiens"|IVAs)" "[^\n ]*medalj	{printPRZ(yytext,0);}
{U}[^\n ]+" of the "[Yy]ear	{printPRZ(yytext,0);}
{U}[^\n ]+ska" "[Ss]tiftels[^\n ]+" "{U}[^\n ]+(pris|stipendium)	{printPRZ(yytext,0);}
{U}[^\n ]+fondens" "[^\n ]+" "{U}[^\n ]+(pris|stipendium)	{printPRZ(yytext,0);}
{U}[^\n ]*" "[Ss]"tiftelsens stipendium fr "[^\n ]+	{printPRZ(yytext,0);}
{U}[^\n ]*" "{U}[^\n ]*stipendi(et|um)	{printPRZ(yytext,0);}
[The]" "({U}[^\n ]+" ")+Prize	{printPRZ(yytext,0);}
{U}[^\n ]+" "Prize	{printPRZ(yytext,0);}
[^\n ]*(utsett|utsgs)" till "[]rets" "[^\n ][^\n ]+	{printPRZ(yytext,2);}
[^\n ]*(utsett|utsgs)" till "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printPRZ(yytext,2);}
[^\n ]*([Tt]iteln|[Uu]tmrkelsen|priset|pris)" "[]rets" "[^\n ]+	{printPRZ(yytext,1);}
[^\n ]*[Uu]tmrkelsen" "{U}[^\n ]+(tor|isk|ts|ns|nde|ska)" "[^\n ]+	{printPRZ(yytext,1);}
[^\n ]*[Uu]tmrkelsen(" "{U}[^\n ]*)+(" of the "{U}[^\n ]*)?	{printPRZ(yytext,1);}
[^\n ]*[Uu]tmrkelsen" "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printPRZ(yytext,1);}
[^\n ]*[Uu]tmrkelse(n)?" \,"(" "{U}[^\n\,]+)+" \,"	{printPRZ(yytext,1);}
[^\n ]*"festivalens Prix de "{U}[^\n ]+	{printPRZ(yytext,1);}
[]rets" "{U}[^\n ]+" "{U}[^\n ]+(pris|gva)	{printPRZ(yytext,1);}
[]rets" "{U}[^\n ]+(pris|gva)	{printPRZ(yytext,1);}
nominera(des|d|ts)?" "(fr|till)" "(Guldknappen|{U}[^\n ]+priset)	{printPRZ(yytext,2);}
{CITAT}(" "[^\n\"\'|\]+)+" Trophy "{CITAT}	{printPRZ(yytext,0);}
("belnades med "|"nomineringen till ")(Silver[^\n ]+|Guld[^\n ]+|{U}[^\n ]+pris)	{printPRZ(yytext,2);}
({U}[^\n ]+" ")?{U}[^\n ]+\-(stipendi|pris)(er|et|um)?	{printPRZ(yytext,0);}
{U}[^\n ]+\:s" "({U}[^\n ]+iska" ")?{U}[^\n ]+pris	{printPRZ(yytext,0);}
{U}[^\n ]+"s kulturpris"	{printPRZ(yytext,0);}
"seger i "(Storsj|Amatr|Kunga|Lands|Drottning|Jubileums)pokalen	{ECHO;}
	/*(Storsj|Amatr|Kunga|Lands|Drottning|Jubileums)pokalen	{printPRZ(yytext,0);}*/
"tilldelats "{U}[^\n ]+" och "{U}[^\n ]+" "[^\n ]+pris	{printPRZ(yytext,1);}
({U}[^\n ]*" ")+Award	{printPRZ(yytext,0);}
(guldbaggar|"Champions League"|"Stanley Cup"|"Grand "[Ss]lam)(\-)?tit(eln|lar|el)	{printPRZ(yytext,0);}
"gefyllda priset"(" "{U}[^\n ]+)+	{printPRZ(yytext,2);}
[Ss]tipendiet(" "{U}[^\n ]+)+	{printPRZ(yytext,1);}
"ur "{U}[^\n ]+" "{U}[^\n ]+" "[^\n ]+fond	{printPRZ(yytext,1);}
"Cancer\- och "[^\n ]+fondens" "[^\n ]+ska" "[Pp]ris	{printPRZ(yytext,0);}
(utmrkelse[a-z]*|hem|mottagit|emot|tilldelats)(" "{U}[^\n ]+)" "([Tt]rophy|[^\n ]+priset)	{printPRZ(yytext,1);}
(pengar|spelar|du|rikare)" p "Bingolotto	{printPRZ(yytext,2);}
[^\n ]*priset" Best in "[^\n ]+	{printPRZ(yytext,1);}
("Internationella "[^\n ]+priset|SM" guld"|"Dramatens "[^\n ]+stipendium)	{printPRZ(yytext,0);}
{U}[^\n ]+s" internationella miljpris"	{printPRZ(yytext,0);}
lag\-[EMVOS]+\-guldet	{printPRZ(yytext,0);}
	/* General Pattern-Products */
{U}[^\n ]+\-(obligation|akti)e(n|r|rna)	{printPRD(yytext,0);}
(Astra" "Zeneca|Coca" "Cola)\-aktie(n|r|rna)	{printPRD(yytext,0);}
{U}[^\n ]+" "[AB]\-aktie(n|r|rna)	{printPRD(yytext,0);}
Astra" "A	{printPRD(yytext,0);}
([Ss]eger|[Mm]l|[Ll]ag|[Hh]it|[Mm]akt|[Mm]edalj|[Pp]ong|[Vv]inst)maskin(en)?(" "{U}[^\n ]+)+	{ECHO;}
[^\n ]*(prngmn|[Ee]lixir|nstrument|eleskop)et(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
[Jj]tteteleskop" "[A-Z][A-Z][A-Z]+	{printPRD(yytext,1);}
[Ss]prngmnet" "[^\n ]+oluen	{printPRD(yytext,0);}
[^\n ]*([Ll]eksakskanin|[Kk]rm|[Gg]as|[Pp]rototyp)en(" "{U}[^\n ]+)+	{printPRD(yytext,0);}
[^\n ]*[Kk]oden" "[0-9]+	{printPRD(yytext,0);}
[^\n ]*[Oo]rkidn" "{U}[^\n ]+(" och "{U}[^\n ]+)?	{printPRD(yytext,1);}
[^\n ]*([Mm]askin|[Pp]arfym|[Pp]rodukt|rodukterna)(en)?(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
[^\n ]*[Ss]torsljare(n)?(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
(Slampan|[Dd]omstolen|\-domstolen|vd\-stolen)(" "{U}[^\n ]+)+	{ECHO;}
[^\n ]*(stol|[Ll]eksak|[Ss]kinngrupp)(en)?(" "{U}[^\n ]+)+	{printPRD(yytext,0);}
[^\n ]*(flaska|[Bb]okhylla|[Ll]ampa|limpor|limpa)(n)?(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
[^\n ]*([Tt]tnings|[Tt]vtt|[Dd]isk|[Rr]engrings|[Pp]uts)medlet(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
[^\n ]*([Tt]vtt|[Dd]isk|[Rr]engrings|[Pp]uts)"medlet "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printPRD(yytext,1);}
[^\n ]+(abrikat|vrnssystem)et(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
[^\n ]+prisserien(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
[^\n ]*flaskan" "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printPRD(yytext,1);}
ikldd(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
[Mm]as[ck]ot(en)?(" "{U}[^ \n]+)+" the"(" "{U}[^ \n]+)+	{printPRD(yytext,1);}
[Mm]as[ck]ot(en)?(" "{U}[^ \n]+)+	{printPRD(yytext,1);}
[Vv]arumrken(" "{U}[^ \n]*)+(" \, "{U}[^ \n]*" "{U}[^ \n]*)*" och"(" "{U}[^ \n]*)+	{printPRD(yytext,1);}
[Vv]arumrke(t|na)" "{U}[^\n ]+" "(\&|och)" "{U}[^\n ]+	{printPRD(yytext,1);}
[^\n ]*(ostym|[Kk]ld|onkurrent|igarett|obaks|port|pecial|skiv|kvalitets|blj)mrket(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
(rkande|tnder)" en"(" "{U}[^\n ]+)+	{printPRD(yytext,2);}
"senaste produkt "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printPRD(yytext,2);}
"produkt \- "{U}[^\n ]+" \-"	{printPRD(yytext,2);}
"produkt r "{U}[^\n ]+" \-"	{printPRD(yytext,2);}
"lanserat en produkt \,"(" "{U}[^\n ]+)+	{printPRD(yytext,4);}
([Ff]lyg|[Rr]aket|[Hh]uvud)motorn(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
("en burk"|"en ask"|"kunna lansera")(" "{U}[^\n ]+)+	{printPRD(yytext,2);}
"som tillverkar"(" "{U}[^\n ]+)+	{printPRD(yytext,2);}
[^\n ]*"lanseringen av"(" "{U}[^\n ]+)+	{printPRD(yytext,2);}
"av mrke"(t)?(" "{U}[^\n ]+)+	{printPRD(yytext,2);}
"av mrke"(t)?" "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printPRD(yytext,2);}
[^\n ]+"nska mrket"(" "{U}[^\n ]+)+	{printPRD(yytext,2);}
[^\n ]*[Mm]"rken som"(" "{U}[^ \n]*)+(" \, "{U}[^ \n]*)*" och"(" "{U}[^ \n]*)+	{printPRD(yytext,2);}
("Levi\'s Jeans"|"Master Mind")	{printPRD(yytext,0);}
(Prince|Blend|Camel|Marlboro)" "([Mm]enthol|Filter|Lights)	{printPRD(yytext,0);}
("Sony Ericsson"|Siemens|Sony|Denon|Hitachi|Minolta|Kenwood|Samsung|Panasonic|Philips|JVC|Braun|Philishave|Panasonic|Kodak|Nikon|Nokia|Motorola|Siemens|Nec|Toshiba|Canon|Fuji)(s)?" "[A-Z0-9][A-Z0-9\-\/]+i?(" "[0-9]+)?	{printPRD(yytext,0);}
("Barnngens barn"|"ACO Mild")tvl	{printPRD(yytext,0);}
("EU\:s bl flagg"|"Mild tvl ACO"|"Stanley Cup-ringen"|"Soft Air Guns"|"L\'Oreal Studio"|"Styling Gel"|"Wella Hairspray"|"Wella Volym"|"Libress Invisible")	{printPRD(yytext,0);}
(spela|avslutat)" ett parti "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printPRD(yytext,2);}
(spela|avslutat)" ett parti"(" "{U}[^\n ]+)+	{printPRD(yytext,2);}
[Nn]y" version av"(" "{U}[^\n ]+)+	{printPRD(yytext,3);}
({U}[^\n ]+" ")?{U}[^\n ]+\-(solglasgon|kort|skor|album|klnning|jackor|affisch|keps|mssa|klder|flaska|trja|docka|dockor|dockorna|hatt|kostym|drkt|jeans)(ar|n|en|er|na|et)?	{printPRD(yytext,0);}
(rym|rymd|mode|militr|kndis|action|cowboy)dockan(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
	/* WEAPONS */
("Winchester "[0-9]+|Winchester[0-9]+|kalas[jh]nikov)(\-gevr|\-karbin)?	{printPRD(yytext,0);}
"Colt "[0-9]+(\:a)?	{printPRD(yytext,0);}
"Magnum "(\.)?(357|44)	{printPRD(yytext,0);}
[^\n ]*[Gg]"evr Carl Gustaf"	{printPRD(yytext,0);}
[^\n ]*(revolvrar|[Gg]evret)(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
sin" AK "[45]\:a	{printPRD(yytext,1);}
[^\n ]*"vapnet r en"(" "{U}[^\n ]+)+	{printPRD(yytext,2);}
Uzi(n)?	{printPRD(yytext,0);}
"Smith \& Wesson"(" "[0-9]+)?	{printPRD(yytext,0);}
	/* GAMES, CARDS * Tipsbingo (also in the gaz) ? Yatzy */
	/* Spader Dam NOT GOOD, too many other things*/
Ruter" "Dam	{printPRD(yytext,0);}
[^\n ]*([Rr]ol|[Kk]ort|teri|lskaps|iper)spel(et)?" "{CITAT}(" "[^\n\"\'|\]+)+" "{CITAT}	{printPRD(yytext,1);}
[^\n ]*([Rr]ol|[Kk]ort|otteri|llskaps)spelet(" "{U}[^\n ]+)+	{printPRD(yytext,1);}
(Qi|Falun)" "Gong(\-kurser)?	{printPRD(yytext,0);}
([Dd]ame|[Hh]erra)rnas" 470"	{printPRD(yytext,0);}

"poutses mble"	{printf("XXXXX");}
\n	{ECHO;}
.	{ECHO;}
%%
int printWVEH (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"OBJ\" SBT=\"VHW\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHW\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHW\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHW\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==11){
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"OBJ\" SBT=\"VHW\">"); for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
else if (x==12){
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
for(;yytext[z]!=' ';putchar(yytext[z++])); z++;
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHW\">"); for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
int printAVEH (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"OBJ\" SBT=\"VHA\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHA\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);
}
int printGVEH (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"OBJ\" SBT=\"VHG\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHG\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHG\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"VHG\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==40){
while(yytext[c]!=' ') c--; c--; 
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--; c--;
while(yytext[c]!=' ') c--;
printf("<ENAMEX TYPE=\"OBJ\" SBT=\"VHG\">"); for(;z<c; putchar(yytext[z++]));
printf("</ENAMEX>");  for(;c<yyleng; putchar(yytext[c++]));}
return(1);
}
int printCMP (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"OBJ\" SBT=\"CMP\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"CMP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"CMP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"CMP\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);
}

int printPRD (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"OBJ\" SBT=\"PRD\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"PRD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"PRD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==3){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"PRD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
else if (x==4){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"PRD\">"); z=z+1; 
for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);
}
int printPRZ (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"OBJ\" SBT=\"PRZ\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"PRZ\">");z=z+1; for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");
}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"PRZ\">");z=z+1; for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);
}
int printFWP (char *a, int x)
{ int z=0;
int c=yyleng;
if (x==0) printf("<ENAMEX TYPE=\"OBJ\" SBT=\"FWP\">%s</ENAMEX>",yytext);
else if (x==1){
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"FWP\">");z=z+1; for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");
}
else if (x==2){
for(;yytext[z]!=' ';putchar(yytext[z++])); putchar(yytext[z++]);
for(;yytext[z]!=' ';putchar(yytext[z++]));
printf(" <ENAMEX TYPE=\"OBJ\" SBT=\"FWP\">");z=z+1; for(;z<yyleng; putchar(yytext[z++])); printf("</ENAMEX>");}
return(1);
}
main( argc, argv )
int argc;
char **argv;	
{	
  ++argv, --argc;
  if ( argc > 0 )
    yyin = fopen( argv[0], "r" );
  else
    yyin = stdin;
  
  yylex(); return(0);
}
