# -*- coding: utf-8 -*-

# common.mk
#
# Makefile definitions common to Makefile and src/Makefile


EMPTY = 
SP = $(EMPTY) $(EMPTY)

CONV_BASE_VARIANTS = weighted unweighted
CONV_MOD_VARIANTS = noins num

DEFAULT_VARIANT = weighted
DEFAULT_VARIANT_SUFF = $(patsubst %-,%,$(subst $(SP),-,$(SP)$(DEFAULT_VARIANT)))

get_base_variant = $(strip $(firstword \
	$(foreach mod,$(CONV_BASE_VARIANTS),\
		$(if $(findstring $(mod),$(1)),$(1))) \
		$(DEFAULT_VARIANT)))
get_mod_variant = $(strip \
	$(foreach mod,$(CONV_MOD_VARIANTS),\
		$(if $(findstring $(mod),$(1)),$(1))))

BASE_VARIANT = $(call get_base_variant,$(VARIANT))
MOD_VARIANT = $(call get_mod_variant,$(VARIANT))

BASE_SUFF = -$(BASE_VARIANT)

get_base_suff = -$(call get_base_variant,$(patsubst -%,%,$(1)))

MOD_SUFF = $(patsubst -%,%,$(subst $(SP),-, $(MOD_VARIANT)))
VARIANT_SUFF = $(BASE_SUFF)$(MOD_SUFF)

FULL_SUFF = $(BASE_SUFFIX)$(VARIANT_SUFF)

VARIANTS = $(strip $(subst -@,,\
	$(foreach basevar,$(CONV_BASE_VARIANTS),\
		$(foreach modvar1,@ $(word 1,$(CONV_MOD_VARIANTS)),\
			$(foreach modvar2,@ $(word 2,$(CONV_MOD_VARIANTS)),\
				$(basevar)-$(modvar1)-$(modvar2))))))
